C-------------------------------------------------------------------------------
C                          odu_com.f (=XCQTCOM.FOR)
C                   - COMMON Block definition for odu_therm.f
C
C
C  This is ODU port of 'CE-THERM-R1', the thermal analysis portion of 'CE-QUAL-R1'
C  for the temperature startification & DO water quality modeling in the
C  Lake Moomaw, VA.  Source codes were ported to Sun Solaris Fortran 77 (ver. 4.0).
C  All codes are compliant to the standard ANSI X3-9-1978 Fortran 77 standard, ISO 
C  1539-1980, FIPS 69-1, BS 6832, and MIL-STD-1753, and should be compiled
C  by any standard ANSI F77 compiler.  All vendor-specific library or function calls
C  were either removed or substituted with standard F77 routines in order to ensure
C  the maximum portability among heterogeneous OSs and platforms.
C
C  This port is based on the CE-THERM-R1, 3/21/90 version.
C  CE-QUAL-R1 is a research tool for reservoir ecosystem snalysis
C  used by the water quality modeling group, U.S. ACE Waterways Experiment Station.
C
C-------------------------------------------------------------------------------
C  Lake Water Quality Modeling Group (e-mail: ace@cee.odu.edu)
C  Department of Civil Environmental Engineering
C  KDH 130B
C  Old Dominion University
C  Norfolk, VA 23529-0241
C
C	Jaewan Yoon, Group Leader 	(yoon@cee.odu.edu)
C	Shannon W. Holland		(holland@cee.odu.edu)
C	Frederick F. Burgess 		(burgess@cee.odu.edu)
C
C-------------------------------------------------------------------------------
C
C    C O M M O N S
C
         IMPLICIT DOUBLE PRECISION (A-H,O-Z)
         CHARACTER*8 MODE,STRUCT,CHOICE,VERIFY,FTRBAY,PUMPBK,CURVE
     *   ,CALBRAT
         COMMON/AREA00/VERIFY
C
         COMMON/AREA01/
     *     TEMP(70), TDS(70),   SSOL(70), VTEMP(70),
     *     VELEV(70)
         DIMENSION  EQ1(70,3)
         EQUIVALENCE  (EQ1(1,1),TEMP(1))
C
         COMMON/AREA02/
     *     TEMPDT(70),TDSDT(70),SSOLDT(70)
         DIMENSION  EQ2(70,3)
         EQUIVALENCE  (EQ2(1,1),TEMPDT(1))
C
         COMMON/AREA03/
     *     FEE(70),  PTDS(70),  PSSOL(70)
         DIMENSION  EQ3(70,3)
         EQUIVALENCE(EQ3(1,1),FEE(1))
C
         COMMON/AREA04/
     *     TEMPIN(2),TDSIN(2),  SSOLIN(2)
         DIMENSION  EQ4(2,3)
         EQUIVALENCE  (EQ4(1,1),TEMPIN(1))
C
         COMMON/AREA05/
     *     TEMPOU,   TDSOU,     SSOLOU
         DIMENSION  EQ5(3)
         EQUIVALENCE  (EQ5(1),TEMPOU)
C
         COMMON/AREA06/
     *     ACOEF(9), AREA(71), AROUT(9), DVOL(71), ELOUT(9),
     *     WCOEF(2), WIDTH(70),VOL(71),  Z(71),    BELOW,
     *     FMAX(9),  FMIN(9),  ELEMSL,   WANGLE(9),
     *     SELMAX,   ELMAX,    RESEL,    SDZ(70),
     *     SDZMIN,   SDZMAX,   RLEN,     CMZ(70),  FRACT(71),
     *     PVDIM(9), PHDIM(9), V(70),    CMZMIX,   ZREF,
     *     AFBCOF(9)
C
         COMMON/AREA07/
     *     AA,       BB,       CLD(24),
     *     DB(24),   DP(24),   APR(24),  WND(24),  QNA(24),
     *     QNS(24),  CLOUD,    DELCLD,   DBT,      DELDBT,
     *     DPT,      DELDPT,   APRES,    DELPRS,   WIND,
     *     DELWND,   XDPT,     XQNS,     XQNA,     XDBT,
     *     XAPR,     XWND,     FONE,     FTWO,     EA,
     *     ES,       EV,       XLAT,     XLON,     TURB,
     *     QSW,      SURFRAC,  TEV
C
         COMMON/AREA08/
     *     SSETL,    TSSETL,   DELEQ4(2,3)
C
         COMMON/AREA09/
     *     TARGET,   DELQIN(2),QI,       QO,       QIN(2),
     *     QOT(9),   QHI(70),  QHO(70),  HGTPRT,   DENPRT,
     *     COEF,     WRHGT,    WRLNG,    FLORAT,   WRFLOW,
     *     WLNGTH,   CREST
C
         COMMON/AREA10/
     *     CDENS,    SHELCF,   PEFRAC,   TKEW,     CDIFW,
     *     CDIFF,    ZMIX,     EXCO,     DENS(70), DC(71),
     *     XX(70,3), SWS(71),  SW(71),   EXTINS,   SVEL
C
         COMMON/AREA12/
     *     SORS(70,3)
C
         COMMON/AREA13/
     *     IFIRST,   ILAST,    IPRT,     INTINT,   INTMET,
     *     INTQ(2),  INTWQ(2,3),ISTART,  IYEAR,    NHRS,
     *     NHOI,     NOUT(8),  NOUTS,    NTRIBS,   IFLO,
     *     IMIX,     JLITE,    JMIN,     JMAX,     LNDAY,
     *     LET(8),   NDAY,     NHOURS,   NTC,      NUME,
     *     NWELL(9), NVDAY,    NVCOUNT,  NVTMPS,   LAYPRT,
     *     LCRST,    NCURV,    NFTRBY
C
         COMMON/AREA14/
     *     TITLE(90),QIC,  QLEAP,  QWEIR,  QPORT,  QSPEC, QNORM,
     *     QSUB,     QSBJET,   QPMPBK,   QAFTER,   QCALBR
         LOGICAL QIC,QLEAP,QSUB,QWEIR,QPORT,QSBJET,QPMPBK,QAFTER,
     *            QSPEC,  QNORM,   QCALBR
C
         COMMON/AREA15/
     *     FTIME(365,4),FRATE(365,4),    FTYPE,     FDAY(365),
     *     NSETS(365),  PBENTR(70),      GVOLUME,   PVOLUME,
     *     QE(70),      OUTFLO(70),      SUMFLO(70),ETA(70),
     *     ALPHAR,      ALPHAS,          BF,        BTM,
     *     ENSSOL,      ENTDS,           ENTEMP,    E,
     *     CHBTM,       GHOURS,          ICYCL,     ICHEK,
     *     IBTM,        INTAB,           LM,        LQ,
     *     ITOP,        LAMBDR,          LAMBDS,    LE,
     *     LMLE,        LQLE,            LOWLIM,    MF,
     *     OPCH,        PHOURS,          PBCOEF,    PBHGT,
     *     PGAMMA,      PBLAYR,          PBAREA,    PBRATE,
     *     PBDEN,       PBTEMP,          PBSSOL,    PBTDS,
     *     SUMGV,       SUMPV,           SPACJ,     TOPLIM,
     *     TOP,         THETAO,          TIME,      ABFLOW,
     *     ABTEMP,      ABTDS,           ABSSOL,    FLOVOL,
     *     GTEMP,       GTDS,            GSSOL,     PBFLOW,
     *     ABVOL,       RBVOL,           RBTEMP,    RBSSOL,
     *     RBTDS,       LAYRS,           RO0,       TPE,
     *     EDX(70),     ETX(70),         YTX(70),   SX,
     *     DSX,         YX(6),           YPX(6),    LX,
     *     IQX,         IKX,             HX,        QMXSOL,
     *     QMXTDS,   NPORTN(365,4),      ABRELT
         REAL*8 LM,LQ,LE,LMLE,LQLE,LAMBDR,LAMBDS,MF
         INTEGER FDAY,OPCH,TOPLIM,PBLAYR
         CHARACTER*1 FTYPE(365,4)

C	
C  char*12 for I/O flenames
C  stdin/out will be assigned to moomawin/out
C

	character InputFilename*12
	character OutputFilename*12
	character TimeStamp*24
	character UserInput*1
	integer LogProgress
	integer MoomawIn, MoomawOut

	common /Necessary_things_in_life/
     *		InputFilename, 	OutputFilename,
     *		MoomawIn,		MoomawOut,
     *		TimeStamp,		LogProgress
     *		UserInput
