C-------------------------------------------------------------------------------
C                       odu_therm.f
C
C                          M A I N
C
C  This is ODU port of 'CE-THERM-R1', the thermal analysis portion of 'CE-QUAL-R1'
C  for the temperature startification & DO water quality modeling in the
C  Lake Moomaw, VA.  Source codes were ported to Sun Solaris Fortran 77 (ver. 4.0).
C  All codes are compliant to the standard ANSI X3-9-1978 Fortran 77 standard, ISO 
C  1539-1980, FIPS 69-1, BS 6832, and MIL-STD-1753, and should be compiled
C  by any standard ANSI F77 compiler.  All vendor-specific library or function calls
C  were either removed or substituted with standard F77 routines in order to ensure
C  the maximum portability among heterogeneous OSs and platforms.
C
C  This port is based on the CE-THERM-R1, 3/21/90 version.
C  CE-QUAL-R1 is a research tool for reservoir ecosystem snalysis
C  used by the water quality modeling group, U.S. ACE Waterways Experiment Station.
C
C-------------------------------------------------------------------------------
C  Lake Water Quality Modeling Group (e-mail: ace@cee.odu.edu)
C  Department of Civil Environmental Engineering
C  KDH 130B
C  Old Dominion University
C  Norfolk, VA 23529-0241
C
C	Jaewan Yoon, Group Leader 	(yoon@cee.odu.edu)
C	Shannon W. Holland		(holland@cee.odu.edu)
C	Frederick F. Burgess 		(burgess@cee.odu.edu)
C
C-------------------------------------------------------------------------------
C    ORDER OF SUBROUTINES
C
C    NUMBER                    SUBROUTINE
C       1                        OPREAD
C       2                        PDCIDE
C       3                        RADIATE
C       4                        FLOWIN
C       5                        CONTRL
C       6                        PUMPKN
C       7                        INFLOP
C       8                        BUCKET
C       9                        ENTRN
C      10                        SBJET
C      11                        RUNGS
C      12                        DERIVE
C      13                        WBJET
C      14                        OUTVEL(JUMP)
C      15                        VPORT
C      16                        VWEIR
C      17                        LAYERS
C      18                        MIXING
C      19                        HEAT
C      20                        ENTRAIN(TDENS)
C      21                        TRNSPT
C      22                        TMPRTR
C      23                        SOLIDS
C      24                        TDSOL
C      25                        CONMIX
C      26                        REREG
C      27                        OBLOUT
C      28                        OUTPT1
C      29                        OUTPT2
C      30                        OUTPT3(N)
C      31                        INTEGR
C-------------------------------------------------------------------------------


       BLOCK DATA
         REAL*8     LAMBDR,  LAMBDS
         LOGICAL    QSBJET
         COMMON /BLOCK/  ALPHA(8),    BETA(8),
     *                   QSBJET,      SPACJ,      ALPHAR,
     *                   ALPHAS,      LAMBDR,     LAMBDS
         DATA ALPHA/6.05,5.10,2.65,-2.04,-9.94,-22.29,-40.63,-66.90/
         DATA BETA/0.522,0.710,0.954,1.265,1.659,2.151,2.761,3.511/         
         DATA QSBJET / .FALSE. /
         DATA SPACJ/2000./
         DATA ALPHAR/0.0535/
         DATA ALPHAS/0.140/
         DATA LAMBDR/1.20/
         DATA LAMBDS/1.0/
        END



        PROGRAM THERM
         INCLUDE 'odu_com.f'
         COMMON DTEMP,DTDS,DSSOL
         LOGICAL QFLOOD,QSAME
         DIMENSION EQIC(3)
         DIMENSION TRIBDAT(370,5,2) 
         EQUIVALENCE (EQIC(1),DTEMP)
         DIMENSION DATA(9),Q(4),T(4)
         REAL*8 FILID(5)
         CHARACTER*8 FILNAM(8)
cy
cy----- declare char*12 for I/O flenames
cy   	also see 'odu_com.f' for shared common block data
cy
         character InputFilename*12
         character OutputFilename*12
         character UserInput*1
         character TimeStamp*24
         integer LogProgress
         logical HeyFile
	 
c
c

         RO(X,Y,Z)=1000.-(((X-3.98)**2*(X+283.))/(503.57*(X+67.26)))
     *             +0.00062*Y+0.00078*Z
         TDELT(X,Y)=2.*(DEXP(X*Y)-1.)/(DBLE(NHOI)*(DEXP(X*Y)+1.))
CB
CB CALL MAXFILES
CB
CB         CALL MAXFILES
CB
CB INITIALIZE VARIABLES
CB
 9001   CONTINUE
        DO 9002 I=1,70
         TEMP(I)=0.
         QHI(I)=0.
         QHO(I)=0.
         SWS(I)=0.
         DC(I)=0.
         SSOL(I)=0.
          DO 9003 J=1,3
           XX(I,J)=0.
           SORS(I,J)=0.
 9003     CONTINUE
 9002   CONTINUE 
         SWS(71)=0.
         DC(71)=0.    
        DO 9005 I=1,370
          DO 9006 J=1,5
           TRIBDAT(I,J,1)=0.
           TRIBDAT(I,J,2)=0.
 9006     CONTINUE
 9005     CONTINUE
          LK1=1
          LK2=1
          LK3=1
          LK4=1
          LK5=1
         DO 9008 I=1,8
          NOUT(I)=0
 9008    CONTINUE
          KL=1
          QIN(1)=0.
          QIN(2)=0.
          TEV=0.
cy
cy----- display title
cy
      write (*,3400)
 3400 format(///
     Q,/,'      ******************************************************'
     Q,/,'      *                CE-THERM-R1 - ODU_96r3              *'
     Q,/,'      ******************************************************'
     Q,/,'      *                                                    *'
     Q,/,'      *               A Thermal Analysis for               *'
     Q,/,'      *             Lake Water Quality Modeling            *'
     Q,/,'      *                                                    *'
     Q,/,'      *                         by                         *'
     Q,/,'      *                                                    *'
     Q,/,'      *        U.S. ACE Waterways Experiment Station       *'
     Q,/,'      ******************************************************'
     Q,/,'      *                                                    *'
     Q,/,'      *       Sun Solaris port for the Lake Moomaw, VA     *'
     Q,/,'      *                                                    *'
     Q,/,'      *                         by                         *'
     Q,/,'      *                                                    *'
     Q,/,'      *          Lake Water Quality Modeling Group         *'
     Q,/,'      *               (e-mail: ace@cee.odu.edu)            *'
     Q,/,'      *   Department of Civil & Environmental Engineering  *'
     Q,/,'      *               Old Dominion University              *'
     Q,/,'      *                                                    *'
     Q,/,'      *                    August, 1996                    *'
     Q,/,'      ******************************************************')

cy
cy-----define input data file & check
cy

9731  write(*,321)
 321  format(//,1x,
     q'-> CE-THERM-R1 INPUT datafile (12 char max.)?')
      read(*,322) InputFilename
  322 format(a12)

		if(InputFilename.EQ.'') then
c			print *
			print *,'*** No Input filename defined, Assuming CQT.DAT ***'
			InputFilename = 'cqt.dat'

			inquire(file=InputFilename,exist=HeyFile)
			
			if (HeyFile.NE..TRUE.) then
				print *, '*** INPUT CQT.DAT DOES NOT EXIST!'
				go to 9731
			end if
		end if

cy
cy-----define output file
cy

      write(*,323)
  323 format(//,1x,
     q'-> OUTPUT filename for this simulation (12 char max.)?')
      read(*,324) OutputFilename
  324 format(a12)

		if(OutputFilename.EQ.'') then
c			print *
			print *,'*** No Output filename defined, Assuming CQT.OTP ***'
			OutputFilename = 'cqt.otp'
		end if


cy
cy----- validating I/O input
cy

	if ((InputFilename.NE.'').AND.(OutputFilename.NE.'')) then
cy 
cy  I/O file difined correctly.
cy  prompt the user for a yes/no response on the simulation pregress
cy  display on the screen
cy
		print *
		print *
		print *, '-> Would like to display simulation progress on screen(y/n)?'
6330		read(*, 6333) UserInput
6333		format(A1)
        	ilen = LEN(UserInput)

		if (UserInput.EQ.'') then
			print *, '*** Please select either ''y'' or ''n'' '
			go to 6330
		end if

	        iasc = ichar(UserInput)
	        if ((iasc.GT.96).AND.(iasc.LT.123)) then
	                UserInput = char(iasc-32)
	        end if

cy
cy--- redirect progress to a log file
cy
			if (UserInput.EQ.'Y') then
cy
cy--- display on screen
				LogProgress=6
			else
cy
cy--- redirect to 'simul.log' at unit=13
cy
				LogProgress=13
				open(UNIT=LogProgress, file='simul.log', status='unknown')
				print *
				print *, '*** Simulation progress will be logged to ''simul.log'' file'
				print *, '***************************************************************'
				print *, '*** START ODU_THERM Simulation......'
					call fdate(TimeStamp)
				print *, '*** s_mark : ', TimeStamp
				print *, '*** input  : ', InputFilename	 
				print *, '*** output : ', OutputFilename
				print *, '***************************************************************'
			end if
	
         write(LogProgress, 3400) 
         write(LogProgress, *) '  '
         write(LogProgress, *) '***************************************************************'
	 write(LogProgress, *) '*** START ODU_THERM Simulation......'
         write(LogProgress, *) '***************************************************************'
		call fdate(TimeStamp)
	 write(LogProgress, *) '*** s_mark : ', TimeStamp
	 write(LogProgress, *) '*** input  : ', InputFilename	 
	 write(LogProgress, *) '*** output : ', OutputFilename	 	 
         write(LogProgress, *) '***************************************************************'
      else
cy
cy------ go back to I/O user prompt (unnecessary?)
cy
		go to 9731
      end if

cy
cy  assign basic Input & Output units
cy  original src has unit assignments;
cy	1, 3, 4  - temp. scratch files (sequential)
cy	5 - stdin
cy	6 - stdout
cy	88+K -  another scratchs/sequential (K=3)
cy		changed to STATUS='KEEP' to STATUS='delete'
cy
cy  stdin/out will be assigned to moomawin/out
cy

	MoomawIn=11
	MoomawOut=12

cy	
cy------ I/O bussiness
cy

      open(UNIT=MoomawIn, file=InputFilename, status='unknown',blank='zero',err=6271)
      open(UNIT=MoomawOut, file=OutputFilename, status='unknown',err=6272)

cy
cy----- skip the OPEN/ERR trap
cy
      go to 6270

cy
cy------- Error flags for I/O file error & proper termination
cy  
6271    	print *, '*** Problem(s) the reading INPUT :', InputFilename
        	stop
          
6272    	print *, '*** Problem(s) the creating OUTPUT :', OutputFilename
        	stop

cy           
cy---- Orig. Unit assignment
cy
Cy         OPEN(UNIT=05,FILE='cqt.dat',STATUS='OLD',BLANK='ZERO')
Cy         OPEN(UNIT=06,FILE='cqt.otp',STATUS='new')

C
C   READ TITLE CARDS AND JOB CARD. CONVERT IFIRST AND ILAST FROM
C   JULIAN DAYS TO HOURS.
C   ISTART SPECIFIES HOUR THAT COMPUTATION BEGINS.
C   UPDATES BEGIN AT IFIRST. INTENDED THAT ISTART >=IFIRST.
C   IF ISTART IS CHANGED, INITIAL CONDITIONS MUST
C   CORRESPONDINGLY BE CHANGED
C


6270     READ(MoomawIn,1000)(TITLE(I),I=1,90)
1000     FORMAT(8X,18A4)
	 write(LogProgress,*) '     - I/O START   reading INITIAL input data'
	 

         READ(MoomawIn,1010)IFIRST,ILAST,NHOI,IPRT,ISTART,IYEAR
 1010    FORMAT(8X,9I8)
C
C Checking READ_IN
C
 	 write(LogProgress,1010) IFIRST,ILAST,NHOI,IPRT,ISTART,IYEAR
Cy	 stop

         IF(ISTART.EQ.0)ISTART=IFIRST
         IFIRST=24*(IFIRST-1)
         ILAST=24*ILAST
         ISTART=24*(ISTART-1)
         QLEAP=.FALSE.
         IF(MOD(IYEAR,4).EQ.0)QLEAP=.TRUE.
C
C  READ AND CHECK FOR ALLOWABLE COMBINATIONS OF 
C  NHOI,MODE,STRUCT,CHOICE,PUMPBK,FTRBAY
C
         READ(MoomawIn,1041)MODE,STRUCT,CHOICE,CALBRAT
         QCALBR=.FALSE.
         QNORM=.FALSE.
         QPORT=.FALSE.
         QWEIR=.FALSE.
         QSPEC=.FALSE.
         QAFTER=.FALSE.
         QPMPBK=.FALSE.
         IF(CALBRAT.EQ.'      NO')QCALBR=.TRUE.
         IF(MODE.EQ.'  NORMAL')QNORM=.TRUE.
         IF(STRUCT.EQ.'    PORT')QPORT=.TRUE.
         IF(STRUCT.EQ.'    WEIR')QWEIR=.TRUE.
         IF(STRUCT.EQ.'PORTWEIR')QPORT=.TRUE.
         IF(STRUCT.EQ.'PORTWEIR')QWEIR=.TRUE.
         IF(CHOICE.EQ.' SPECIFY')QSPEC=.TRUE.
         IF(QNORM)GO TO 2019
         READ(MoomawIn,1041)PUMPBK,FTRBAY
         IF(FTRBAY.EQ.'AFTERBAY')QAFTER=.TRUE.
         IF(QAFTER)READ(MoomawIn,1031)(AFBCOF(I),I=1,3),NFTRBY
 1031    FORMAT(8X,3F8.0,I8)
         IF(PUMPBK.EQ.'PUMPBACK')QPMPBK=.TRUE.
         IF(QPMPBK)READ(MoomawIn,1040)PBCOEF,THETAO
         IF(.NOT. QSPEC .OR. .NOT.QPORT.OR.QWEIR) GO TO 2039
         IF(QPMPBK .AND. .NOT. QAFTER)GO TO 2039
         IF(NHOI .NE. 24)GO TO 2039
 2019    IF(.NOT. QSPEC .AND. QWEIR)GO TO 2039
         GO TO 2041
 2039    WRITE(MoomawOut,2037)
 2037    FORMAT(9X,'UNACCEPTABLE COMBINATION OF VARIABLES',/,
     1          9X,'NHOI,MODE,STRUCT,CHOICE,PUMPBK,FTRBAY')
         STOP
C
C  READ PHYSICAL DATA, CONVERT M3/SEC TO M3/HR
C  NOTE--PORTS ARE NUMBERED FROM TOP DOWN
C

 2041    READ(MoomawIn,1020)NTRIBS ,NUME,XLAT,XLON,TURB,AA,BB,ELEMSL
 1020    FORMAT(8X,2I8,3F8.0,2E8.0,F8.0)
         write(LogProgress,*) '     - I/O END   reading INITIAL input data'
         write(LogProgress,*) '     - I/O START reading PHYSICAL input data'   
         READ(MoomawIn,1040)RLEN,SDZMIN,SDZMAX
         READ(MoomawIn,1040)(SDZ(I),I=1,NUME)
         RESEL=0.
         DO 04 I=1,NUME
           RESEL=RESEL+SDZ(I)
   04    CONTINUE
C
C  CHECK TO DETERMINE IF ARRAYS ARE OF SUFFICIENT SIZE
C
         IF(NUME.GT.70)WRITE(MoomawOut,3010)
 3010    FORMAT(' TOO MANY LAYERS-MAIN')
         IF(NUME.GT.70)STOP
         IF(NTRIBS.GT.2)WRITE(MoomawOut,3030)
 3030    FORMAT(' TOO MANY TRIBUTARIES')
         IF(NTRIB.GT.2)STOP
         IF(.NOT. QPORT)GO TO 09
 1041    FORMAT(8X,4A8)
         READ(MoomawIn,1020)NOUTS
         NN=NOUTS
         IF(NOUTS.GT.8)WRITE(MoomawOut,3020)
 3020    FORMAT(' TOO MANY PORTS')
         IF(NOUTS.GT.8)STOP
         IF(.NOT.QSPEC)NN=NOUTS+1
         DO 08 I=1,NN
           READ(MoomawIn,1043)ELOUT(I),PVDIM(I),PHDIM(I),
     *                  NWELL(I),FMIN(I),FMAX(I),WANGLE(I)
   08    CONTINUE
 1043    FORMAT(8X,3F8.0,I8,3F8.0)
         IF (WANGLE(I) .LT. 0.1 ) WANGLE(I) = 180.
         DO 12 I=1,NN
           AROUT(I)=PVDIM(I)*PHDIM(I)
   12    CONTINUE
         IF(QSPEC)GO TO 11
         J=NOUTS+1
         DO 07 I=1,J
           FMIN(I)=FMIN(I)*3600.
           FMAX(I)=FMAX(I)*3600.
   07    CONTINUE
         READ(MoomawIn,2043)SELMAX,BELOW,NUMWEL,QFLOOD,QSAME
 2043    FORMAT(8X,2F8.0,I8,2L8)
 1040    FORMAT(8X,9F8.0)
         SELMAX=SELMAX*3600.
   11    IF(.NOT.QWEIR)GO TO 6
   09    READ(MoomawIn,1040)WRLNG,WRHGT,COEF
         QSUB=.FALSE.
         IF(COEF.LE.0)QSUB=.TRUE.
C
C         READ GENERATING FUNCTION COEFFICIENTS
C         FOR AREA AND WIDTH.  AREA CAN BE DESCRIBED  
C         BY POWER OR QUADRATIC FUNCTIONS
C
   06    CONTINUE
         write(LogProgress,*) '     - I/O END   reading PHYSICAL input data'

         NCURV=1
         write(LogProgress,*) '     - I/O START reading FUNCTION COEFF. input data'
         READ(MoomawIn,1041)CURVE
         IF(CURVE.EQ.'   POWER')NCURV=2
         READ(MoomawIn,1040)(ACOEF(I),I=1,3)
         READ(MoomawIn,1040)(WCOEF(I),I=1,2)
         READ(MoomawIn,1040)SHELCF,PEFRAC,CDIFW,CDIFF,CDENS
         READ(MoomawIn,1040)EXCO,SURFRAC,EXTINS
         write(LogProgress,*) '     - I/O END   reading FUNCTION COEFF. input data'
C
C   SET UP INITIAL GEOMETRICAL ATTRIBUTES OF LAYERS
C
         write(LogProgress,*) '     - START setting up initial geometrical attributed of layers'
         AREA(1)=1.
         VOL(1)=1.
         Z(1)=0.
         DO 10 I=1,NUME
           Z(I+1)=Z(I)+SDZ(I)
           AREA(I+1)=AFN(NCURV,Z(I+1),ACOEF)
           VOL(I+1)=VFN(NCURV,Z(I+1),ACOEF)
           WIDTH(I)=WFN((Z(I)+Z(I+1))/2.,WCOEF)
           DVOL(I)=VOL(I+1)-VOL(I)
           FRACT(I)=AREA(I)/AREA(I+1)
   10    CONTINUE
         FRACT(1)=0.
         write(LogProgress,*) '     - END   setting up initial geometrical attributed of layers'
C
C        IDENTIFY INITIAL OUTLET LOCATIONS BY LAYER
C
         write(LogProgress,*) '     - START identifying initial outlet locations by layer'
         DO 20 I=1,NN
           DO 30 J=1,NUME
             IF(ELOUT(I).GT.Z(J+1))GO TO 30
             NOUT(I)=J
             GO TO 20
   30      CONTINUE
   20    CONTINUE
         SUM=0
         DO 25 I=1,NUME
           SUM=SUM+SDZ(I)
   25    CONTINUE
         SDZAVG=SUM/DBLE(NUME)
         write(LogProgress,*) '     - END   identifying initial outlet locations by layer'                  
C
C   READ SUSPENDED SOLIDS SETTLING RATE
C
         write(LogProgress,*) '     - I/O START reading suspend solids settling rate'
         READ(MoomawIn,1040)TSSETL
C
C   CHANGE RATE FROM PER DAY TO PER HOUR
C
         Y=DBLE(NHOI)/24.
         SSETL=TDELT(TSSETL/SDZAVG,Y)*SDZAVG
         write(LogProgress,*) '     - I/O END   reading suspend solids settling rate'

C
C    READ INITIAL CONDITIONS,BUILD INITIAL WATER QUALITY ARRAYS
C    VALUE MUST BE SPECIFIED AT LEAST FOR LOWEST AND HIGHEST LAYERS
C
         write(LogProgress,*) '     - START building initial WQ arrays'
         READ(MoomawIn,1010)NPOINT
         DO 65 I=1,3
           EQIC(I)=0.
           DO 66 J=1,NUME
             EQ1(J,I)=0.
   66      CONTINUE
   65    CONTINUE
         write(LogProgress,*) '     - END   building initial WQ arrays'
         L=1

         write(LogProgress,*) '     - START interpolating WQ arrays with elev.s'
         DO 70 I=1,NPOINT
           READ(MoomawIn,1040)ELEV,DTEMP,DTDS,DSSOL
C
C         LOAD WATER QUALITY ARRAYS AT EACH 'ELEV' WITH CORRESPONDING
C         DATA. INTERPOLATE FOR OTHER LAYERS.
C
           DO 80 J=1,NUME
             IF(ELEV.LT.Z(J).OR.ELEV.GT.Z(J+1))GO TO 80
   90        DO 100 K=1,3
                EQ1(J,K)=EQIC(K)
  100        CONTINUE
             IF((J-L).LE.1)GO TO 130
             LP1=L+1
             JM1=J-1
             NDIF=J-L
             DO 105 N=1,3
               DH=(EQ1(J,N)-EQ1(L,N))/DBLE(NDIF)
               DO 150 M=LP1,JM1
                 EQ1(M,N)=EQ1(M-1,N)+DH
  150          CONTINUE
  105        CONTINUE
             GO TO 130
   80      CONTINUE
  130      L=J
   70    CONTINUE
         write(LogProgress,*) '     - END   interpolating WQ arrays with elev.s'

C
C READ INITIAL AFTERBAY ATTRIBUTES
C

         IF(QAFTER)READ(MoomawIn,1040)ABVOL,ABTEMP,ABSSOL,ABTDS
         write(LogProgress,*) '     - START reading initial afterbay attributes'
         write(LogProgress,*) '     - END   reading initial afterbay attributes'
C
C   READ NAMES OF SIMULATION OUTPUT FILE(S)
C   STANDARD USAGE-FIRST FILE CONTAINS WATER COLUMN
C   DATA, SECOND FILE,OUTFLOW DATA, REST, INFLOW(S).
C
         write(LogProgress,*) '     - START preparing files for simulation output results'
         K=NTRIBS+2
         READ(MoomawIn,1070)(FILNAM(I),I=1,K)
 1070    FORMAT(8X,8A8)
         DO 700 I=1,K
           OPEN(UNIT=88+I,FILE=FILNAM(I),STATUS='NEW',
     *          FORM='UNFORMATTED')

  700    CONTINUE
C
C  READ SIMULATION IDENTIFICATION TEXT TO BE
C  INSERTED IN OUTPUT FILES
C
         READ(MoomawIn,1080)(FILID(I),I=1,5)
 1080    FORMAT(8X,5A8)

         write(LogProgress,*) '     - END   preparing files for simulation output results'
C
C  UPDATE PROCESSOR--CONVERT TYPE-SEQUENTIAL DATA TO
C  INTERVAL-SEQUENTIAL FORM. 
C  EACH DATA TYPE LOADED ONTO SEPARATE SCRATCH DISK FILE.
C  BE AWARE OF SCRATCH FILE LIMITS.
C
C        READ METEOROLOGICAL,DATA,PUT ON FILE 01
C

         write(LogProgress,*) '     - START updating processor via temp file #1'
         READ(MoomawIn,1050)INTMET,NCARDS
 1050    FORMAT(8X,2I8)
         OPEN(UNIT=01,STATUS='SCRATCH',FORM='UNFORMATTED')
         DO 175 I=1,NCARDS
           READ(MoomawIn,1044)CLOUD,DBT,DPT,APRES ,WIND
           WRITE(01)CLOUD,DBT,DPT,APRES ,WIND
  175    CONTINUE
 1044    FORMAT(16X,8F8.0)
         REWIND 01
         write(LogProgress,*) '     - END   updating processor via temp file #1'
         
C
C        READ OPERATION SCHEDULE IF SCHEDULE MODE.
C        NOTE SCHEDULE ORGANIZED IN TERMS OF 'OPERATION CHANGES'-
C        DAYS FOR WHICH NO SCHEDULE IS SPECIFIED HAVE THE SAME
C        SCHEDULE AS THE MOST RECENT ONE SPECIFIED.
C
         IF(.NOT.QNORM)CALL OPREAD

         write(LogProgress,*) '     - START updating processor via temp file #3'
         OPEN(UNIT=03,STATUS='SCRATCH',FORM='UNFORMATTED')
         IF(.NOT.QNORM)GO TO 199
C
C        READ INTAKE AND/OR WEIR FLOW DATA,PUT ON FILE 03.
C        IF BOTH PORTS AND WEIR ARE USED, FLOW DATA ARE INTERLEAVED.
C        REGULATION MUST USE PORTS ONLY
C        CONVERT OUTFLOW UNITS FROM M3/SEC TO M3/HR
C        NOTE--PORTS NUMBERED FROM TOP DOWN
C        ALSO NOTE--ASSUMES NO MORE THAN 8 PORTS
C        OTHERWISE REFINE CARD SEQUENCING
C
         IF(QWEIR.AND..NOT.QPORT)GO TO 192
         IF(QSPEC) GO TO 180

         write(LogProgress,*) '     - I/O START reading intake/flow data'
         READ(MoomawIn,1050)INTINT,NCARDS
         DO 195 I=1,NCARDS
           READ(MoomawIn,1042)(Q(K),T(K), K=1,4)
 1042      FORMAT(16X,8F8.0)
           DO 196 J=1,4
             WRITE(03) Q(J)*3600.,T(J)
  196      CONTINUE
  195    CONTINUE
         REWIND 03
         GO TO 199
  180    READ(MoomawIn,1050)INTINT,NCARDS
         I=0
  191    I=I+1
         IF(I.GE.NCARDS+1)GO TO 190
         READ(MoomawIn,1060)(LET(J),QOT(J),J=1,NOUTS)
         IF(QPORT.AND.QWEIR)READ(MoomawIn,1040)WRFLO
 1060    FORMAT(16X,I8,F8.0,I8,F8.0,I8,F8.0,I8,F8.0)
         WRITE(03)(QOT(J)*3600.,J=1,NOUTS)
         IF(QPORT.AND.QWEIR)WRITE(03)WRFLO*3600
         GO TO 191
  190    CONTINUE
         REWIND 03
         GO TO 199
  192    READ(MoomawIn,1050)INTINT,NCARDS
         DO 193 I=1,NCARDS
           READ(MoomawIn,1040)(DATA(J),J=1,9)
           DO 194 J=1,9
             WRITE(03)DATA(J)*3600.
  194      CONTINUE
  193    CONTINUE
         REWIND 03
         write(LogProgress,*) '     - I/O END   reading intake/flow data'
         write(LogProgress,*) '     - END   updating processor via temp file #3'
         
C
C        BY TRIBUTARY,READ INFLOWS ,TEMPERATURE,TDS,AND SS
CB
CB       THE ABOVE DATA IS STORED IN A THREE-DIMENSIONAL ARRAY    
CB       NAMED TRIBDAT(I,J,K).  I REFERS TO THE ROW NUMBER IN
CB       WHICH THE DATA IS STORED, J TO THE COLUMN, AND K TO 
CB       WHETHER THE DATA IS FOR TRIBUTARY 1 OR 2.  INFLOW DATA
CB       ARE IN COLUMN 1, TEMPERATURE IN COLUMN 2, TDS IN 
CB       COLUMN 3, AND SSOL IN COLUMN 4.
CB
  199   write(LogProgress,*) '     - I/O START reading inflow, temperature, TDS, SS by tributary' 
        DO 200 I=1,NTRIBS
CB
CB   INFLOWS  
CB   
        READ(MoomawIn,1050)INTQ(I),NCARDS
           DO 210 J=1,NCARDS
             READ(MoomawIn,1040)(DATA(K),K=1,9)
             DO 215 K=1,9
                 LL=((J-1)*9)+K
                 TRIBDAT(LL,1,I)=DATA(K)*3600.
  215        CONTINUE
  210      CONTINUE
CB
CB   J=1    TEMPERATURE
CB   J=2    TDS
CB   J=3    SSOL
CB
           DO 218 J=1,3
             READ(MoomawIn,1050)INTWQ(I,J),NCARDS
             DO 230 K=1,NCARDS
               READ(MoomawIn,1040)(DATA(L),L=1,9)
               DO 235 L=1,9
                   LL=((K-1)*9)+L
                   TRIBDAT(LL,(J+1),I)=DATA(L)  
  235          CONTINUE
  230        CONTINUE
  218      CONTINUE
  200    CONTINUE
        write(LogProgress,*) '     - I/O END   reading inflow, temperature, TDS, SS by tributary' 

C*
C*  READ RELEASES FROM AFTERBAY IF REQUIRED.
C*  CONVERT FROM M3/SEC TO M3/HR
C*
         IF(.NOT.QAFTER)GO TO 201

        write(LogProgress,*) '     - I/O START reading & preparing releases from afterbay' 
         READ(MoomawIn,1050)INTAB,NCARDS
         DO 202 I=1,NCARDS
           READ(MoomawIn,1040)(DATA(J),J=1,9)
           DO 203 J=1,9
               LL=((I-1)*9)+J
               TRIBDAT(LL,5,1)=DATA(J)*3600.
  203      CONTINUE
  202    CONTINUE
        write(LogProgress,*) '     - I/O END   reading & preparing releases from afterbay' 

C
C  READ IN VERIFICATION DATA IF VERIFICATION RUN
C
C  ****NOTE--ENSURE ADEQUATE DIMENSIONING FOR VTEMP AND VELEV****
C
  201    write(LogProgress,*) '     - I/O START reading verification data' 
         READ(MoomawIn,1041)VERIFY
          IF(VERIFY.NE.'     YES')GO TO 209
         READ(MoomawIn,1050)NVRFY
 
         write(LogProgress,*) '     - START updating processor via temp file #4' 
         OPEN(UNIT=04,STATUS='SCRATCH',FORM='UNFORMATTED')
         DO 207 I=1,NVRFY
         READ(MoomawIn,1046)NVDAY,NVTMPS,(VELEV(J),VTEMP(J),J=1,NVTMPS)
 1046    FORMAT(7X,I6,1X,I3,1X,4(F4.1,1X,F9.3,1X),/,
     *           (18X,F4.1,1X,F9.3,1X,F4.1,1X,F9.3,1X,
     *           F4.1,1X,F9.3,1X,F4.1,1X,F9.3)) 
           WRITE(04)NVDAY,NVTMPS,(VELEV(J),VTEMP(J),J=1,NVTMPS)
         IF(NVTMPS.EQ.4) BACKSPACE 5 
  207    CONTINUE
         REWIND 04
  209    CONTINUE
         write(LogProgress,*) '     - END   updating processor via temp file #4'
         write(LogProgress,*) '     - I/O END   reading verification data' 

C
C  READ FIRST TWO RECORDS FROM EACH SCRATCH
C  FILE TO INITIALIZE UPDATE PROCESS AND
C  DETERMINE FIRST UPDATE INCREMENTS.
C  (EXCEPT INFLOWS, OUTFLOWS, AND AFTERBAY RELEASES)
C

        write(LogProgress,*) '     - START reading & updating processor records' 
         READ(01)CLOUD ,DBT ,DPT ,APRES ,WIND
         READ(01)CLOUD2,DBT2,DPT2,APRES2,WIND2
         DELCLD=(CLOUD2-CLOUD)*DBLE(NHOI)/DBLE(INTMET)
         DELDBT=(DBT2-DBT)*DBLE(NHOI)/DBLE(INTMET)
         DELDPT=(DPT2-DPT)*DBLE(NHOI)/DBLE(INTMET)
         DELPRS=(APRES2-APRES)*DBLE(NHOI)/DBLE(INTMET)
         DELWND=(WIND2-WIND)*DBLE(NHOI)/DBLE(INTMET)
         IF(.NOT.QNORM)GO TO 225
         IF(QWEIR.AND..NOT.QPORT)GO TO 221
         IF(QSPEC)GO TO 220
         READ(03) QO,TARGET
         GO TO 225
  220    READ(03)(QOT(I),I=1,NOUTS)
         IF(QPORT.AND.QWEIR)READ(03)WRFLOW
         GO TO 225
  221    READ(03)WRFLOW     
  225    DO 260 I=1,NTRIBS
          QIN(I)=TRIBDAT(KL,1,I)
          IF(I.EQ.2)GO TO 1261
             STOR1=LK1      
             STOR2=LK2
             STOR3=LK3
             STOR4=LK4
          GO TO 1262  
 1261        LK1=STOR1          
             LK2=STOR2
             LK3=STOR3
             LK4=STOR4 
 1262       DO 270 J=1,3
CB
CB   J=1    TEMPERATURE
CB   J=2    TDS
CB   J=3    SSOL
CB
             IF(J.EQ.2) GO TO 9101
             IF(J.EQ.3) GO TO 9102
CB
CB    TEMPERATURE
CB
             EQ4(I,J)=TRIBDAT(LK1,J+1,I) 
             DATA2=TRIBDAT((LK1+1),J+1,I)
             LK1=LK1+1
               GO TO 9103
CB
CB    TDS
CB
 9101        EQ4(I,J)=TRIBDAT(LK2,J+1,I) 
             DATA2=TRIBDAT((LK2+1),J+1,I)
             LK2=LK2+1
               GO TO 9103
CB
CB    SSOL
CB
 9102        EQ4(I,J)=TRIBDAT(LK3,J+1,I) 
             DATA2=TRIBDAT((LK3+1),J+1,I)
             LK3=LK3+1
 9103      DELEQ4(I,J)=(DATA2-EQ4(I,J))*DBLE(NHOI)/DBLE(INTWQ(I,J))
  270      CONTINUE
  260    CONTINUE
         IF(.NOT.QAFTER)GO TO 261
           ABFLOW=TRIBDAT(1,5,1)
        write(LogProgress,*) '     - END   reading & updating processor records' 

C
C  INITIALIZE AND BEGIN COMPUTATION LOOP
C  WRITE SIMULATION ID ON OUTPUT FILES
C
  261    write(LogProgress,*) '*** START initialize & beginning computation loop' 
         REWIND 89
         WRITE(89)(FILID(I),I=1,5)
         REWIND 90
         WRITE(90)(FILID(I),I=1,5)
         DO 315 I=1,NTRIBS
           J=90+I
           REWIND J
           WRITE(J)(FILID(K),K=1,5)
  315    CONTINUE
         NHRS=-NHOI
         LNDAY=IFIRST/24
         IMIX=NUME
         ZMIX=SDZ(NUME)
         NHOURS=IFIRST-NHOI
         CALL OUTPT1
         QIC=.TRUE.
         CALL OUTPT2
         QIC=.FALSE.
C
C  FOR VERIFICATION RUN SET COUNTER EQUAL TO 1 AND
C  READ IN FIRST TEMPERATURE PROFILE
C
         IF(VERIFY.NE.'     YES')GO TO 320
         NVCOUNT=1

        write(LogProgress,*) '     - I/O START reading temperature from verification data' 
         READ(04)NVDAY,NVTMPS,(VELEV(J),VTEMP(J),J=1,NVTMPS)
        write(LogProgress,*) '     - I/O END   reading temperature from verification data' 
  320    NHOURS=NHOURS+NHOI
	 write(LogProgress, *) ' '
         write(LogProgress, *) '***************************************************************'
         write(LogProgress, *) 'NHOURS at ',NHOURS
C
C  BYPASS DATA INCREMENT/UPDATE PROCESS ON FIRST PASS
C

        write(LogProgress,*) '     - START   data increment/update processes on' 
        write(LogProgress,*) '               meterological, outlet flow, inflow'
        write(LogProgress,*) '               water quality, temperature, TDS, SS'
        write(LogProgress,*) '               afterbay release arrays'        
         IF(NHOURS.EQ.IFIRST)GO TO 420
C
C  INCREMENT DATA FOR THIS PASS, UPDATE
C  PERIODICALLY AS REQUIRED
C
C        INCREMENT METEOROLOGICAL DATA
C

         CLOUD=CLOUD+DELCLD
         DBT=DBT+DELDBT
         DPT=DPT+DELDPT
         APRES=APRES+DELPRS
         WIND=WIND+DELWND
         IF(MOD(NHOURS-IFIRST,INTMET).NE.0)GO TO 325
C
C        GET METEOROLOGICAL UPDATES
C        CALCULATE INCREMENTS
C
         READ(01)CLOUD2,DBT2,DPT2,APRES2,WIND2
         DELCLD=(CLOUD2-CLOUD)*DBLE(NHOI)/DBLE(INTMET)
         DELDBT=(DBT2-DBT)*DBLE(NHOI)/DBLE(INTMET)
         DELDPT=(DPT2-DPT)*DBLE(NHOI)/DBLE(INTMET)
         DELPRS=(APRES2-APRES)*DBLE(NHOI)/DBLE(INTMET)
         DELWND=(WIND2-WIND)*DBLE(NHOI)/DBLE(INTMET)
C
C        IF NOT TIME TO UPDATE OUTFLOW USE PRESENT VALUE W/O INCREMENT
C
  325    IF(.NOT.QNORM)GO TO 370
         IF(MOD(NHOURS-IFIRST,INTINT).NE.0)GO TO 370
C
C        GET OUTLET FLOW UPDATES
C
         IF(QWEIR.AND..NOT.QPORT)GO TO 336
         IF(QSPEC) GO TO 365
         READ(03) QO,TARGET
         GO TO 370
  365    READ(03)(QOT(I),I=1,NOUTS)
         IF(QPORT.AND.QWEIR)READ(03)WRFLOW
         GO TO 370
  336    READ(03)WRFLOW
C
C        IF NOT TIME TO UPDATE INFLOW USE PRESENT VALUE W/O INCREMENT
C
  370    DO 390 I=1,NTRIBS
           IF(MOD(NHOURS-IFIRST,INTQ(I)).NE.0)GO TO 400
C
C        GET INFLOW UPDATES
C
             IF(I.EQ.2)GO TO 401
             KL=KL+1
  401        QIN(I)=TRIBDAT(KL,1,I) 
C
C        INCREMENT WATER QUALITY DATA
C
           IF(I.EQ.2) GO TO 1401 
             STOR11=LK1
             STOR22=LK2
             STOR33=LK3
             STOR44=LK4
           IF(I.EQ.1) GO TO 400 
 1401        LK1=STOR11
             LK2=STOR22
             LK3=STOR33
             LK4=STOR44
CB
CB   J=1    TEMPERATURE
CB   J=2    TDS
CB   J=3    SSOL
CB
  400      DO 410 J=1,3
             EQ4(I,J)=EQ4(I,J)+DELEQ4(I,J)
             IF(MOD(NHOURS-IFIRST,INTWQ(I,J)).NE.0)GO TO 410
C
C        GET WATER QUALITY UPDATE
C        CALCULATE INCREMENT
C
             IF(J.EQ.2) GO TO 9104
             IF(J.EQ.3) GO TO 9105
             DATA2=TRIBDAT(LK1+1,J+1,I)
             LK1=LK1+1
               GO TO 9106
CB
CB    TDS
CB
 9104       DATA2=TRIBDAT(LK2+1,J+1,I)
            LK2=LK2+1
               GO TO 9106  
CB
CB    SSOL
CB
 9105       DATA2=TRIBDAT(LK3+1,J+1,I)
            LK3=LK3+1
 9106      DELEQ4(I,J)=(DATA2-EQ4(I,J))*DBLE(NHOI)/DBLE(INTWQ(I,J))
  410      CONTINUE
  390    CONTINUE
         IF(.NOT.QAFTER)GO TO 420
C
C  IF NOT TIME TO UPDATE AFTERBAY RELEASE
C  USE PRESENT VALUE W/O INCREMENT
C
         IF(MOD(NHOURS-IFIRST,INTAB).NE.0)GO TO 420
C
C  GET AFTERBAY RELEASE UPDATE
C
           LK4=LK4+1 
           ABFLOW=TRIBDAT(LK4,5,1)
  420    CONTINUE
        write(LogProgress,*) '     - END     data increment/update processes on' 
        write(LogProgress,*) '               meterological, outlet flow, inflow'
        write(LogProgress,*) '               water quality, temperature, TDS, SS'
        write(LogProgress,*) '               afterbay release arrays'        


C
C  KEEP TRACK OF DAY SEQUENCE FOR RADIATION
C  PARAMETERS. IS IT A NEW DAY?
C
        write(LogProgress,*) '     - START   checking solar radiation and interpolating weather data' 
         NDAY=NHOURS/24
         IF(NDAY.GT.LNDAY)GO TO 430
C
C        NO, ACCUMULATE HOURS SINCE NEW DAY BEGAN
C
         NHRS=NHRS+NHOI
         GO TO 440
C
C        YES, RESET ACCUMULATOR AND SET 'LAST NEW DAY' COUNTER
C
  430    NHRS=0
         LNDAY=NDAY
C
C        INTER-INTERPOLATE WEATHER DATA TO GET
C        NHOI HOURLY VALUES FOR CLOUD,DBT,DPT,APRES,WIND
C        TREAT NHOI=24 AS A SPECIAL CASE
C
  440    CONTINUE
         IF(NHOI.EQ.24)GO TO 445
         DO 450 I=1,NHOI
           CLD(I)=CLOUD+DELCLD*DBLE(I-1)/DBLE(NHOI)
           DB (I)=DBT+DELDBT*DBLE(I-1)/DBLE(NHOI)
           DP (I)=DPT+DELDPT*DBLE(I-1)/DBLE(NHOI)
           APR(I)=APRES+DELPRS*DBLE(I-1)/DBLE(NHOI)
           WND(I)=WIND+DELWND*DBLE(I-1)/DBLE(NHOI)
  450    CONTINUE
         GO TO 448
  445    DO 446 I=1,NHOI
           CLD(I)=CLOUD
           DB(I)=DBT
           DP(I)=DPT
           APR(I)=APRES
           WND(I)=WIND
  446    CONTINUE
  448    CONTINUE
        write(LogProgress,*) '     - END     checking solar radiation and interpolating weather data' 

C
C SKIP COMPUTATIONAL LOOP IF UPDATES ARE EARLIER THAN ISTART
C
        IF(NHOURS.LT.ISTART)GO TO 600
C
C  COMPUTE DENSITY PROFILE
C

        write(LogProgress,*) '     - START   calculating density profile' 
         DO 449 I=1,NUME
           DENS(I)=RO(TEMP(I),SSOL(I),TDS(I))
  449    CONTINUE
        write(LogProgress,*) '     - END     calculating density profile' 

C
C   RELOCATE OUTLETS BY LAYER
C

        write(LogProgress,*) '     - START   relocating outlets by layer' 
         DO 452 I=1,NN
           DO 453 J=1,NUME
             IF(ELOUT(I).GT.Z(J+1))GO TO 453
             NOUT(I)=J
             GO TO 452
  453      CONTINUE
  452    CONTINUE
        write(LogProgress,*) '     - END     relocating outlets by layer'   
  
C
C  CALCULATE FLOW FROM PORTS IF REGULATION IS CHOSEN
C
         IF(QSPEC) GO TO 495
        write(LogProgress,*) '     - START   calculating temperature & flow from ports' 
         CALL PDCIDE (NWELL,NOUTS,ELOUT,QO,PVDIM,RESEL,NUMWEL,
     *                QFLOOD,QSAME,TEMP,FMAX,TARGET,SELMAX,
     *                FMIN,PHDIM,NUME,Z,QOT)              
        write(LogProgress,*) '     - END     calculating temperature & flow from ports' 
  495    CONTINUE
C
C  COMPUTE LONGWAVE,SHORTWAVE,BACK RADIATION,
C  VAPOR PRESSURE,SATURATION VAPOR PRESSURE, AND EVAPORATION
C

        write(LogProgress,*) '     - START   calculating ' 
        write(LogProgress,*) '                   longwave, shortwave, back radiation,' 
        write(LogProgress,*) '                   vapor pressure, saturation vapor pressure,'         
        write(LogProgress,*) '                   evaporation, net heat transfer rate'         
                
         CALL RADIATE(LogProgress)

        write(LogProgress,*) '     - END     calculating ' 
        write(LogProgress,*) '                   longwave, shortwave, back radiation,' 
        write(LogProgress,*) '                   vapor pressure, saturation vapor pressure,'         
        write(LogProgress,*) '                   evaporation, net heat transfer rate'

C
C  ROUTE LAYER INFLOWS. COMPUTE INFLOWING
C  LAYER THERMAL ENERGIES.
C

        write(LogProgress,*) '     - START   calculating inflow routing, layer thermal energies' 
         CALL FLOWIN
        write(LogProgress,*) '     - END     calculating inflow routing, layer thermal energies' 

C
C  EITHER WITHDRAW CONTINUOUS FLOW FROM LAYERS(OUTVEL)
C  OR CONTROL GENERATION AND/OR PUMPBACK PROCESS(CONTRL)
C

        write(LogProgress,*) '     - START   calculating control generation/pumpback process' 
         IF(.NOT.QNORM)CALL CONTRL
        write(LogProgress,*) '     - END     calculating control generation/pumpback process' 

        write(LogProgress,*) '     - START   calculating withdraw continuous flow'                  
         IF(QNORM)CALL OUTVEL(1)
        write(LogProgress,*) '     - END     calculating withdraw continuous flow'                           
C
C
C  RESIZE AND RENUMBER LAYERS. REFIGURE LAYER ATTRIBUTES
C  (NOTE-PARTIAL WATER BALANCES PERFORMED IN SCHEDULED MODE)
C

        write(LogProgress,*) '     - START   updating size, number, attributes of layers'                  
         IF(QNORM)CALL LAYERS(1)
         IF(.NOT.QNORM)CALL LAYERS(2)
        write(LogProgress,*) '     - END     updating size, number, attributes of layers'                  
                 
C
C  CALCULATE DEPTH OF MIXED LAYER
C

        write(LogProgress,*) '     - START   calculating mixed layer depth' 
         CALL MIXING
        write(LogProgress,*) '     - END     calculating mixed layer depth' 
                 
C
C   CALCULATE DIFFUSION COEFFICIENTS.
C   SET UP TRANSPORT MATRIX ELEMENTS
C

        write(LogProgress,*) '     - START   calculating diffusion coeff.s & setting up transport matrix' 
         CALL TRNSPT
        write(LogProgress,*) '     - END     calculating diffusion coeff.s & setting up transport matrix' 
                 
C
C   CALCULATE TEMPERATURE ARRAY
C

        write(LogProgress,*) '     - START   calculating temperature estimates' 
         CALL TMPRTR
        write(LogProgress,*) '     - END     calculating temperature estimates'
         
C
C   CALCULATE SUSPENDED SOLIDS ARRAY
C

        write(LogProgress,*) '     - START   calculating SS estimates' 
         CALL SOLIDS
        write(LogProgress,*) '     - END     calculating SS estimates' 
                 
C
C   CALCULATE TDS
C

        write(LogProgress,*) '     - START   calculating TDS estimates' 
         CALL TDSOL
        write(LogProgress,*) '     - END     calculating TDS estimates' 
                 
C
C  CALCULATE DENSITY PROFILE AGAIN
C

        write(LogProgress,*) '     - START   calculating density profile estimates' 
         DO 490 I=1,NUME
           DENS(I)=RO(TEMP(I),SSOL(I),TDS(I))
  490    CONTINUE
        write(LogProgress,*) '     - END     calculating density profile estimates' 
          
C
C  DETERMINE IF A DENSITY INSTABILITY EXISTS
C  MIX UNTIL A STABLE DENSITY GRADIENT IS OBTAINED
C

        write(LogProgress,*) '     - START   adjusting density profile estimates for its stability' 
         CALL CONMIX
        write(LogProgress,*) '     - END     adjusting density profile estimates for its stability' 
                 
C
C   COMPUTE OUTFLOWING CONSTITUENTS FOR CONTINUOUS OUTFLOWS.
C   (NOTE- IN SCHEDULED MODE, OUTFLOWS COMPUTED BY S/R 'CONTRL')
C
         IF(.NOT.QNORM)GO TO 491

        write(LogProgress,*) '     - START   calculating continuous outflow constituents'
         CALL OUTVEL(2)
        write(LogProgress,*) '     - END     calculating continuous outflow constituents'
                 
C
C  COMPUTE AFTERBAY ATTRIBUTES AS REQUIRED
C
  491    IF(QAFTER) then
        write(LogProgress,*) '     - START   calculating afterbay attributes'
  	CALL REREG
        write(LogProgress,*) '     - END     calculating afterbay attributes'  	
	end if

C
C  OUTPUT IF DESIRED
C
C    FOR VERIFICATION RUN DETERMINE SPECIAL PRINT DAYS FOR
C    VERIFICATION AND OUTPUT
C
         IF(VERIFY.NE.'     YES')GO TO 565
         JDAY=(NHOURS+NHOI)/24
         IF(JDAY.NE.NVDAY)GO TO 565
         CALL OUTPT2
         NVCOUNT=NVCOUNT+1
         IF(NVCOUNT.GT.NVRFY)GO TO 570
         READ(04)NVDAY,NVTMPS,(VELEV(J),VTEMP(J),J=1,NVTMPS)
         GO TO 570
  565    IF(MOD(NHOURS-ISTART+NHOI,IPRT).NE.0)GO TO 570
         CALL OUTPT2
C
C  OBLIGATORY OUTPUT. 
C
  570   write(LogProgress,*) '*** END   computation loop for NHOURS at ',NHOURS
  	write(LogProgress,*) '     - PROCESS   updating output for current computation loop' 
  	CALL OBLOUT

C
C CHECK FOR TERMINATION
C
  600    CONTINUE
         IF(NHOURS+NHOI.GE.ILAST)GO TO 800
         GO TO 320
Cy  800    CLOSE(UNIT=89,STATUS='KEEP')
  800    CLOSE(UNIT=89,STATUS='delete')

        write(LogProgress, *) '  '
        write(LogProgress, *) '***************************************************************'
   	write(LogProgress,*) '     - START   preparing final output'   	
        write(LogProgress,*) '     - START   cleaning temp files'
         J=90+NTRIBS
         DO 801 I=90,J
Cy           CLOSE(UNIT=I,STATUS='KEEP')
           CLOSE(UNIT=I,STATUS='delete')
  801    CONTINUE
        write(LogProgress,*) '     - END     cleaning temp files'

	if (UserInput.EQ.'N') then
		CLOSE(UNIT=LogProgress,STATUS='KEEP')
		print *
		print *
		
		print *, '***************************************************************'
	        print *, '*** Successful & Normal ODU_THERM Simulation.'
		print *, '***************************************************************'

		print *
		print *		
		print *, '***************************************************************'
	        print *, '*** END ODU_THERM Simulation. Results directed to -> ', OutputFilename		
		print *, '*** Simulation progress was logged to ''simul.log'' file'
			call fdate(TimeStamp)
		print *, '*** e_mark : ', TimeStamp
		print *, '***************************************************************'
	end if
	                  
        write(LogProgress,*) '     - END     preparing final output'  	
        
Cy
Cy------- Wake-up ring
Cy

         write(LogProgress, *) '  '
         write(LogProgress, *) '  '
		
         write(LogProgress, *) '***************************************************************'
         write(LogProgress, *) '*** Successful & Normal ODU_THERM Simulation.'
         write(LogProgress, *) '***************************************************************'

         write(LogProgress, *) '  '
         write(LogProgress, *) '  '
		
         write(LogProgress, *) '***************************************************************'
         write(LogProgress, *) '*** END ODU_THERM Simulation. Results directed to -> ', OutputFilename
		call fdate(TimeStamp)
	 write(LogProgress, *) '*** e_mark : ', TimeStamp
         write(LogProgress, *) '***************************************************************'
         write(LogProgress, *) '  '         

Cy
Cy------- Good housekeeping. Normal happy termination :-)
Cy

         CLOSE(UNIT=MoomawIn,STATUS='KEEP')
         CLOSE(UNIT=MoomawOut,STATUS='KEEP')

6279    STOP
        END



         SUBROUTINE OPREAD
         INCLUDE 'odu_com.f'
C
C**********************************************************************
C
C  S U B R O U T I N E   O P R E A D                         NUMBER 1
C
C**********************************************************************
C  READ OPERATION SCHEDULES
C
         CHARACTER*1 XTYPE(2)
         DIMENSION LPORTN(2), XTIME(2),XRATE(2)
         INTEGER OLD,XDAY
C
C  READ ONE LINE OF
C  DATA OPERATION
C
         OPCH=0
         XDAY = 0

         write(LogProgress,*) '     - I/O START reading & preparing operation schedules'
         READ(MoomawIn,1000)NCARDS
 1000    FORMAT(8X,I8)
         DO 100 I=1,NCARDS
           OLD = XDAY
           READ ( 05, 510 ) XDAY, (XTYPE(J),XTIME(J),
     *                      XRATE(J),LPORTN(J), J = 1, 2 )
C
C  DETERMINE IF CURRENT
C  DATA RECORD REFERS TO A
C  NEW OPERATION CHANGE DAY
C
           IF ( XDAY .EQ. OLD .OR. XDAY .EQ. 0 ) GO TO 120
C
C  NEW OPERATION
C  CHANGE DAY
C
           OPCH = OPCH + 1
           NSETS(OPCH) = 0
           FDAY(OPCH) =XDAY
 120       CONTINUE
C
C  ASSIGN DATA FROM CURRENT
C  RECORD TO APPROPRIATE ARRAYS
C
           NSM = 1
           IF (XTYPE(2) .EQ. 'G' .OR.
     *       XTYPE(2) .EQ. 'P' ) NSM = NSM + 1
           DO 130 J = 1, NSM
             IJK = NSETS(OPCH) + J
             IF(XTYPE(J).EQ.'P')FTYPE(OPCH,IJK)='P'
             IF(XTYPE(J).EQ.'G')FTYPE(OPCH,IJK)='G'
             FTIME(OPCH, IJK) = XTIME(J)
             NPORTN(OPCH,IJK)=LPORTN(J)
             FRATE(OPCH, IJK) = XRATE(J)
 130       CONTINUE
           NSETS(OPCH) = NSETS(OPCH) + NSM
 100     CONTINUE
         RETURN
 510     FORMAT ( 8X, I8, 2 ( 7X, A1, F8.0, F8.0, I8 ) )
         write(LogProgress,*) '     - I/O END   reading & preparing operation schedules'
         END


         SUBROUTINE PDCIDE(NWELL,NPORTS,PHGT,RELE,PVDIM,DEPTH,
     1   NUMWEL,QFLOOD,QSAME,TEMP,FMAX,TARGET,SELMAX,FMIN,PHDIM,
     2   ISURF,ZZ,QFLOW)

C
C*******************************************************************************
C
C   S U B R O U T I N E   P D C I D E                                 NUMBER 2
C
C*******************************************************************************
C   ORIGINAL CODING BY HYDRAULICS LAB.  RECEIVED 20 DEC 85 IN ENV. LAB
*         
*  THIS ROUTINE CHOOSES THE PORTS THAT SHOULD
*  BE OPEN AND THE FLOWS THROUGH THEM SUCH THAT
*  HYDRAULIC AND QUALITY CONSTRAINTS ARE MET
*
         IMPLICIT DOUBLE PRECISION(A-H,O-Z)
****************************************************************
         DIMENSION XFLOW(3), QWELL(9), JXPORT(3), WDUM(70),
     *             QD(9), TPORT(9), FLOMAX(9),
     *             TOPPRT(9), LPORT(9), PAREA(9),
     *             NWELL(9),PHGT(9),ZZ(71),
     *             PVDIM(9),TEMP(70),FMAX(9),
     *             FMIN(9),PHDIM(9),JPORT(9),FLOW(9),QFLOW(9)
         LOGICAL QCHECK, Q1, Q2, QD, QFIRST, QWELL, QMORE, QSAME,
     *           QSW, QFLOOD
         DATA SMALL / 1.E - 08 /
         DATA QFIRST, NFLOOD  / .TRUE., 1 /
         DATA FACTOR / 1. /
C         DATA QFLOOD, QSAME / 2 * .TRUE. /
         DATA FGMIN, FGMAX / 2 * 0. /
         DATA C / 0.9 /
C
C   LINKAGE BETWEEN PDECIDE AND R1
C
        IF(.NOT.QFLOOD) GOTO 12
        FGMAX=FMAX(NPORTS+1)
        FGMIN=FMIN(NPORTS+1)
        FGHGT=PHGT(NPORTS+1)
   12   CONTINUE                   
*         
*  IF QSAME IS TRUE, THE FLOOD GATES
*  ARE HOUSED WITHIN THE WETWELLS.
*  OTHERWISE, THE SW AND FLOOD SYSTEMS
*  ARE SEPERATE. IF QSAME IS TRUE, THE
*  FLOOD GATE CONSTRAINTS ARE HALVED.
*         
         FGCF = 1.0
         IF ( QSAME ) FGCF = 0.5
         FGMAX = FGMAX * FGCF
         FGMIN = FGMIN * FGCF
         QMORE = .TRUE.
         EXTRA = 0.
         IF (QFLOOD ) NFLOOD = NPORTS + 1
         COEF = C * SQRT ( 2.0 * 9.81 ) * FACTOR
*         
*         
*  ASSIGN LOGICAL VARIABLES TO PORTS
*  DEPENDING UPON WHICH WET WELL THE
*  PORT IS IN
*         
         J = NWELL(1)
         DO 140 I = 1, NPORTS
         QWELL(I) = NWELL(I) .EQ. J
 140     CONTINUE
*         
*  DETERMINE LAYER OF EACH PORT
*  INCLUDING THE FLOOD GATE
*         
         IF ( QFLOOD ) PHGT(NFLOOD) = FGHGT
         NP = NPORTS
         IF ( QFLOOD ) NP = NPORTS + 1
         DO 150 I = 1, NP
         DO 148 JJ=1,ISURF
         JM=JJ
         IF(PHGT(I).GT.ZZ(JJ).AND.PHGT(I).LE.ZZ(JJ+1))GOTO 149
 148     CONTINUE
 149     LPORT(I)=JM 
 150     CONTINUE
 160     CONTINUE
         TFLOW = RELE
*         
*  RETURN IF THERE NO FLOW
*         
         IF ( TFLOW + EXTRA .GT. SMALL ) GO TO 180
         EXTRA = 0.
 170     CONTINUE
         JOPEN = 1
         JPORT(1) = 1
         FLOW(1) = 1.E - 20
         M = 10
         GO TO 600
 180     CONTINUE
C*         
C*  DETERMINE TEMPERATURE AT EACH PORT
C*  QD(I) = .FALSE. MEANS PORT(I) IS
C*  OUTSIDE THE POOL
C*         

        write(LogProgress,*) '     - START   calculating temperature at each port' 
         DO 190 I = 1, NPORTS
         QD(I) = .FALSE.
         TOPPRT(I) = PHGT(I) + 0.5 * PVDIM(I)
         PAREA(I) = PVDIM(I) * PHDIM(I)
         IF ( DEPTH .LT. TOPPRT(I) ) GO TO 190
         IJK = LPORT(I)
         TPORT(I) = TEMP(IJK)
         FLOMAX(I)=(COEF * PAREA(I) * SQRT(DEPTH - TOPPRT(I)))*3600.
         FLOMAX(I) = DMIN1 ( FMAX(I), FLOMAX(I) )
         QD(I) = .TRUE.
 190     CONTINUE
         IF ( .NOT. QFLOOD ) GO  TO 200
         IJK = LPORT(NFLOOD)
         TPORT(NFLOOD) = TEMP(IJK)
         FLOMAX(NFLOOD) = FGMAX
         QD(NFLOOD) = .TRUE.
         FMIN(NFLOOD) = FGMIN
 200     CONTINUE
        write(LogProgress,*) '     - END     calculating temperature at each port' 

*         
*  DETERMINE WHERE OBJECTIVE TEMPERATURE IS LOCATED
*

         DO 210 I = 1, NPORTS
         K = I
         IF ( .NOT. QD(I) ) GO TO 210
         IF ( TARGET .GE. TPORT(I) ) GO TO 220
         IF ( .NOT. QFLOOD .AND. TARGET .LE. TPORT(NPORTS) )
     *                               GO TO 310
         IF ( QFLOOD .AND. TARGET .LE. TPORT(NFLOOD) ) GO TO 310
         GO TO 330
 210     CONTINUE
         IF (QFLOOD .AND. QD(NFLOOD)  ) GO TO 310
 215     EXTRA = TFLOW + EXTRA
         TFLOW = 0.
         GO TO 170
 220     CONTINUE
*         
*  THE FOLLOWING IS EXECUTED IF THE OBJECTIVE
*  TEMPERATURE IS HIGHER THAN THE HIGHEST
*  POSSIBLE WITHDRAWAL TEMPERATURE.  FLOW IS
*  TAKEN FROM THE HIGHEST PORTS
*         
         JOPEN = 0
         REST = TFLOW + EXTRA
         FGFLOW = REST
         FSLMT = SELMAX
         Q1 = QWELL(K)
*         
         DO 240 I = K, NPORTS
         IF ( I .EQ. K ) GO TO 230
         IF ( JOPEN .EQ. 2 ) GO TO 240
         Q2 = QWELL(I)
         IF ( ( Q1 .AND. Q2 ) .OR. .NOT. ( Q1 .OR. Q2 ) ) GO TO 240
         IF ( JOPEN .EQ. 1 ) FSLMT = SELMAX - FLOW(1)
 230     CONTINUE
         FLW = DMIN1 ( REST, FLOMAX(I), FSLMT )
         IF ( FLW .LT. FMIN(I) ) GO TO 240
         JOPEN = JOPEN + 1
         JPORT(JOPEN) = I
         FLOW(JOPEN) = FLW
         REST = REST - FLW
         IF ( JOPEN .EQ. 1 .AND. QFLOOD ) FGFLOW = REST
         IF ( REST .LT. SMALL ) GO TO 250
 240     CONTINUE
         IF ( .NOT. QFLOOD ) GO TO 250
         IF ( QSAME ) GO TO 245
         FLW = DMIN1 ( REST, FGMAX )
         IF ( FLW .LT. FGMIN ) GO TO 250
         JOPEN = JOPEN + 1
         FLOW(JOPEN) = FLW
         JPORT(JOPEN) = NFLOOD
         GO TO 246
*         
*  FLOODGATES ARE WITHIN WETWELLS, DIVIDE
*  FLOW AMONG TOP PORT AND FLOODGATE.
*         
 245     CONTINUE
         FLW = DMIN1 ( FGFLOW, FGMAX )
         IF ( FLW .LT. FGMIN ) GO TO 250
         IF ( JOPEN .LT. 2 ) JOPEN = JOPEN + 1
         IF ( JOPEN .GE. 2 ) JOPEN = 2
         JPORT ( JOPEN ) = NFLOOD
         FLOW ( JOPEN ) = FLW
 246     CONTINUE
         REST = REST - FLW
 250     CONTINUE
         EXTRA = REST
         IF ( JOPEN .GT. 0 ) GO TO 260
         JOPEN = 1
         FLOW(1) = 1.E - 20
         JPORT(1) = 1
         TFLOW = FLOW(1)
         M = 15
         GO TO 600
 260     CONTINUE
         TFLOW = 0.
         DO 270 I = 1, JOPEN
         TFLOW = TFLOW + FLOW(I)
 270     CONTINUE
         IF ( JOPEN .EQ. 3 ) GO TO 290
         IF ( JOPEN .EQ. 2 ) GO TO 280
*         
         M = 20
         GO TO 600
 280     CONTINUE
         IF ( JPORT(2) .EQ. NFLOOD .AND. QFLOOD ) GO TO 300
         M = 25
         GO TO 600
 290     CONTINUE
         M = 30
         GO TO 600
 300     CONTINUE
         M = 35
         GO TO 600
 310     CONTINUE
*         
*  THE FOLLOWING IS EXECUTED IF THE OBJECTIVE
*  TEMPERATURE IS LESS THAN THE LOWEST POSSIBLE
*  WITHDRAWAL TEMPERATURE.  ALL OF THE FLOW IS
*  TAKEN FROM THE FLOOD GATES IF THEY EXIST.
*  OTHERWISE, ALL FLOW IS TAKEN FROM LOWEST GATES.
*         
         JOPEN = 0
         IF ( .NOT. QFLOOD ) GO TO 550
         FGMX = FGMAX / FGCF
         FGMN = FGMIN / FGCF
         REST = TFLOW + EXTRA
         FLW = DMIN1 ( REST, FGMX )
         IF ( FLW .LT. FGMN ) GO TO 550
 320     CONTINUE
         EXTRA = REST - FLW
         JPORT(1) = NFLOOD
         FLOW(1) = FLW
         JOPEN = 1
         TFLOW = FLW
         M = 40
         GO TO 600
 330     CONTINUE
*         
*  THE FOLLOWING IS EXECUTED IF THE OBJECTIVE
*  TEMPERATURE LIES WITHIN SELECTIVE WITHDRAWAL
*  TEMPERATURE LIMITS
*         
         REST = TFLOW + EXTRA
         IF ( REST .LE. SELMAX ) GO TO 340
         IF ( REST .LT. FGMIN + SELMAX ) GO TO 480
         GO TO 490
 340     CONTINUE
*         
*  FLOW IS WITHIN SELECTIVE WITHDRAWAL CAPACITY
*         
         NPM1 = NPORTS - 1
         DO 350 I = 1, NPM1
         K = I
         IF ( .NOT. QD(I) ) GO TO 350
         IF ( TARGET .LE. TPORT(I) .AND.
     *        TARGET .GT. TPORT(I + 1) ) GO TO 360
 350     CONTINUE
         K = NPORTS
         IF ( QFLOOD .AND. ( TARGET .LE. TPORT(K) .AND. TARGET
     *        .GT. TPORT(NFLOOD) ) ) GO TO 375
         EXTRA = REST
         GO TO 170
 360     CONTINUE
         Q1 = QWELL(K)
         K1 = K + 1
         DO 370 I = K1, NP
         IF ( QFLOOD .AND. I .EQ. NFLOOD ) GO TO 370
         IF ( ( Q1 .AND. QWELL(I) ) .OR.
     *        ( .NOT. Q1 .AND. .NOT. QWELL(I) ) ) GO TO 370
         J = I
         GO TO 380
 370     CONTINUE
 375     CONTINUE
         J = NFLOOD
 380     CONTINUE
         JOPEN = 2
         JPORT(1) = K
         JPORT(2) = J
*         
*  FOR DUAL WETWELL SYSTEM, ANY
*  PORT SHOULD HAVE CAPABILIY TO
*  RELEASE ABOUT ONE-HALF OF SELMAX
*  FOR A 2 FT SUBMERGENCE
*         
         IF ( TARGET - TPORT(J) .GT. TPORT(K) - TPORT(J) )
     *                                          GO TO 384
         FLOW(1) = REST * ( TARGET - TPORT(J) ) /
     *                     ( TPORT(K) - TPORT(J) )
         GO TO 385
 384     CONTINUE
         FLOW(1) = REST
 385     CONTINUE
         FLOW(2) = REST - FLOW(1)
         IF ( FLOW(1) .GT. FLOMAX(K) ) GO TO 430
         IF ( FLOW(1) .LT. FMIN(K) ) GO TO 440
         IF ( FLOW(2) .LT. FMIN(J) ) GO TO 460
         IF ( FLOW(2) .GT. FLOMAX(J) ) GO TO 470
 390     CONTINUE
 400     CONTINUE
         FLW = FLOW(1) + FLOW(2)
         TFLOW = FLW
         IF ( ( QFLOOD .AND. JPORT(2) .EQ. NFLOOD ) .AND.
     *                       FLOW(2) .GT. 0. ) GO TO 410
         M = 45
         GO TO 600
 410     CONTINUE
         M = 50
         GO TO 600
 430     CONTINUE
         FLOW(1) = FLOMAX(K)
         FLOW(2) = DMIN1 ( FLOMAX(J), REST - FLOW(1) )
         IF ( FLOW(2) .GE. FMIN(J) ) GO TO 390
         FLOW(2) = 0.
         JOPEN = 1
         EXTRA  = EXTRA + TFLOW - FLOW(1)
         TFLOW = FLOW(1)
         M = 55
         GO TO 600
 440     CONTINUE
         F1 = FLOW(1)
         F2 = FLOW(2)
         FLOW(1) = FMIN(K)
         FLOW(2) = DMIN1 ( FLOMAX(J), REST - FLOW(1) )
         IF ( FLOW(2) .GE. FMIN(J) .OR. FLOW(2) .LT. 0. ) GO TO 450
         JPORT(1) = K
         IF ( F2 .GT. F1 ) JPORT(1) = J
         JOPEN = 1
         EXTRA = 0.
         FLOW(1) = REST
         M = 60
         GO TO 600
 450     CONTINUE
         IF ( FLOW(2) .GE. 0. ) GO TO 390
         FLOW(1) = REST
         EXTRA = 0.
         FLOW(2) = 0.
         JOPEN = 1
         GO TO 400
 460     CONTINUE
         FLOW(2) = 0.
         FLOW(1) = DMIN1 ( FLOMAX(K), REST )
         JOPEN = 1
         EXTRA = EXTRA + TFLOW - FLOW(1)
         JPORT(1) = K
         GO TO 390
 470     CONTINUE
         FLOW(2) = FLOMAX(J)
         FLOW(1) = DMAX1( FLOMAX(K), REST - FLOW(2) )
         EXTRA = TFLOW - FLOW(1) - FLOW(2)
         GO TO 390
 480     CONTINUE
*         
*  FLOW IS GREATER THAN SELECTIVE WITHDRAWAL
*  CAPACITY BY LESS THAN FLOOD GATE MINIMUM
*  CAPACITY.  ONLY SELECTIVE WITHDRAWAL
*  MAXIMUM IS WITHDRAWN.
*         
         REST = SELMAX
         GO TO 340
 490     CONTINUE
*         
*  FLOW IS LARGE ENOUGH TO REQUIRE THAT
*  SOME IS TAKEN FROM FLOOD GATE.
*         
         SELMX = SELMAX
         IF ( QSAME ) SELMX = 0.5 * SELMX
         FLW = REST - SELMX
         TX = ( TARGET * REST - TPORT(NFLOOD) * FLW ) / SELMX
         QCHECK = .TRUE.
         DO 500 I = 1, NPORTS
         IF ( .NOT. QD(I) ) GO TO 500
         K = I
         IF ( QCHECK .AND. TX .GE. TPORT(I) ) GO TO 520
         IF ( QSAME ) GO TO 516
         QCHECK = .FALSE.
         IF ( TX .LT. TPORT(I) .AND.
     *        TX .GE. TPORT(I + 1) ) GO TO 510
 500     CONTINUE
         JOPEN = 1
         JPORT(1) = NFLOOD
         FLOW(1) = DMIN1 ( REST, FGMAX / FGCF )
         EXTRA = REST - FLOW(1)
         IF ( DABS ( EXTRA ) .LT. SMALL ) EXTRA = 0.
         TFLOW = FLOW(1)
         M = 65
         GO TO 600
 510     CONTINUE
         EXTRA = 0.
         JOPEN = 1
         QSW = .FALSE.
*         
*  NOTE FROM ABOVE THAT
*  TX = ( TARGET * REST - TPORT(NFLOOD) * FLW ) / SELMAX
*         
         FLOW1 = SELMAX * ( TX - TPORT(K + 1) ) /
     *           ( TPORT(K) - TPORT(K + 1) )
         FLOW1 = DMIN1 ( FLOW1, SELMAX )
         IF ( FLOW1 .LT. SMALL ) FLOW1 = 0.
         FLOW2 = REST - FLW - FLOW1
         IF ( FLOW2 .LT. SMALL ) FLOW2 = 0.
         IF ( FLOW1 .GT. FLOMAX(K) .AND.
     *        K .NE. 1 ) GO TO 515
*         
*  DIVIDE FLOW AMONG K AND K + 1 PORTS OR
*  NEXT LOWER PORT NOT IN SAME WET WELL
*         
         FLOW(2) = 0.
         Q1 = QWELL(K)
         KP1 = K + 1
         DO 511 I = KP1, NPORTS
         IF ( ( Q1 .AND. QWELL(I) ) .OR. ( .NOT. Q1 .AND. .NOT.
     *          QWELL(I) ) ) GO TO 511
         IF ( .NOT. QD(I) ) GO TO 511
         JOPEN = 2
         JPORT(2) = I
         FLOW(2) = DMIN1 ( FLOW2, FLOMAX(I) )
         QSW = .TRUE.
         GO TO 512
 511     CONTINUE
 512     CONTINUE
         IF ( .NOT. QSW ) FLOW(2) = 0.
         JOPEN = JOPEN + 1
         JPORT(1) = K
         FLOW(1) = DMIN1 ( SELMAX - FLOW(2), FLOMAX(K) )
         JPORT(JOPEN) = NFLOOD
         FLOW(JOPEN) = REST - FLOW(1) - FLOW(2)
         M = 70
         GO TO 600
 515     CONTINUE
*         
*  DIVIDE FLOW AMONG K AND K - 1 PORTS AS POSSIBLE
*         
         FLOW(1) = 0.
         JPORT(2) = K
         FLOW(2) = DMIN1 ( FLOW1, FLOMAX(K) )
         Q1 = QWELL(K)
         KM1 = K - 1
         DO  513 I = 1, KM1
         L = K - I
         IF ( ( Q1 .AND. QWELL(I) ) .OR. ( .NOT. Q1 .AND. .NOT.
     *          QWELL(I) ) ) GO TO 513
         IF ( .NOT. QD(L) ) GO TO 513
         JPORT(1) = L
         FLOW(1) = DMIN1 ( SELMAX - FLOW(2), FLOMAX(L) )
         JOPEN = 3
         GO TO 514
 513     CONTINUE
         IF ( FLOW(1) .GT. 0. ) GO TO 514
         FLOW(1) = FLOW(2)
         JPORT(1) = JPORT(2)
         FLOW(2) = 0.
         JOPEN = 2
 514     CONTINUE
         JPORT(JOPEN) = NFLOOD
         FLOW(JOPEN) = REST - FLOW(1) - FLOW(2)
         M = 75
         GO TO 600
*         
*  TX BELOW TOP PORT
*  FOR QSAME = TRUE
*         
 516     CONTINUE
         DIFF = 100.
         JOPEN = 0
         FLOW(1) = 0.
         FLOW2 = 0.
         DO 517 I = 1, NPORTS
         IF ( .NOT. QD(I) ) GO TO 517
         FLOW1 = REST * ( TARGET - TPORT( NFLOOD) ) /
     *        ( TPORT(I) - TPORT( NFLOOD ) )
         FLOW1 = DMIN1 ( FLOW1, FLOMAX(I) )
         IF ( FLOW1 .LT. FMIN(I) ) GO TO 517
         JOPEN = 1
         IF ( NUMWEL .EQ. 1 ) GO TO 518
         FLOW2 = REST - FLOW1
         FLOW2 = DMIN1 ( FLOW2, FGMAX )
         IF ( FLOW2 .LT. FGMIN ) FLOW2 = 0.
         JOPEN = 2
         TOTFLO = FLOW1 + FLOW2
         TEST = ( FLOW1 * TPORT(I) + FLOW2 * TPORT( NFLOOD) )
     *          / TOTFLO
         TEST = DABS ( TARGET - TEST )
         IF ( TEST .GE. DIFF ) GO TO 517
         DIFF = TEST
         JPORT(1) = I
         JPORT(2) = NFLOOD
         FLOW(1) = FLOW1
         FLOW(2) = FLOW2
         EXTRA = REST - FLOW(1) - FLOW(2)
         GO  TO 519
 517     CONTINUE
 519     CONTINUE
         IF ( JOPEN .LT. 2 ) GO TO 518
         TFLOW = FLOW(1) + FLOW(2)
         M = 77
         GO TO 600
 518     CONTINUE
         JOPEN = 1
         TFLOW = FLOW(1)
         M = 78
         GO TO 600
 520     CONTINUE
*         
*  THE OBJECTIVE TEMPERATURE IS HIGHER THAN
*  THE HIGHEST TEMPERATURE WHICH CAN BE OBTAINED
*  FOR THE GIVEN FLOW.  RELEASE IS FROM THE TOP
*  PORTS AND THE FLOOD GATE.
*         
         FLOW(1) = FLOMAX(K)
         FLOW(2) = 0.
         JOPEN = 1
         JPORT(1) = K
         REST = REST - FLOW(1)
         IF ( QSAME ) GO TO 545
          
         QCHECK = QWELL(K)
         DO 530 I = K, NPORTS
         IF ( ( QCHECK .AND. QWELL(I) )  .OR.
     *   .NOT. ( QCHECK .OR. QWELL(I) ) .OR. .NOT. QD(I) ) GO TO 530
         FLOW(2) = DMIN1 ( SELMAX - FLOW(1), FLOMAX(I) )
         JPORT(2) = I
         JOPEN = 2
         IF ( FLOW(2) .GT. FMIN(I) ) GO TO 540
         JOPEN = 1
         FLOW(2) = 0.
         GO TO 540
 530     CONTINUE
 540     CONTINUE
         REST = REST - FLOW(2)
 545     CONTINUE
         JOPEN = JOPEN + 1
         FLOW(JOPEN) = DMIN1 ( FGMAX, REST )
         JPORT(JOPEN) = NFLOOD
         EXTRA = REST - FLOW(JOPEN)
         TFLOW = TFLOW - EXTRA
         M = 80
         GO TO 600
 550     CONTINUE
*         
*  THE FOLLOWING IS EXECUTED IF THE OBJECTIVE TEMPERATURE
*  IS LESS THAN THE LOWEST POSSIBLE WITHDRAWAL TEMPERATURE
*  BUT THE REQUIRED FLOW IS LESS THAN THE FLOOD GATE
*  MINIMUM CAPACITY OR THE FLOOD GATE DOES NOT EXIST. THE
*  FLOW IS TAKEN FROM THE LOWEST SELECTIVE WITHDRAWAL PORTS
*  IF POSSIBLE TO DO SO.
*         
         REST = RELE
         I = NPORTS
         IF ( QFLOOD ) GO TO 555
         FLW = DMIN1 ( REST, FLOMAX(I), SELMAX )
 555     CONTINUE
         IF ( .NOT. QD(I) )  GO TO 215
         PHLO = DMIN1 ( FLOMAX(I), FLW )
         IF ( PHLO .GE. FMIN(I) ) GO TO 560
         FLW = 0
         GO TO 320
 560     CONTINUE
         JPORT(1) = I
         FLOW(1) = PHLO
         FLOW(2) = 0.
         JOPEN = 1
         PHLO = FLW - PHLO
         IF ( PHLO .LE. 0. ) GO TO 590
         Q1 = QWELL(I)
*         
         DO 570 J = 1, NPORTS
         K = NPORTS - J + 1
         Q2 = QWELL(K)
         IF ( ( Q1 .AND. Q2 ) .OR. .NOT. ( Q1 .OR. Q2 ) ) GO TO 570
         IF ( .NOT. QD(K) ) GO TO 590
         GO TO 580
 570     CONTINUE
*         
         GO TO 590
 580     CONTINUE
         PHLO = DMIN1 ( PHLO, FLOMAX(K) )
         IF ( PHLO .LT. FMIN(K) ) GO TO 590
         JPORT(2) = K
         FLOW(2) = PHLO
         JOPEN = 2
 590     CONTINUE
         TFLOW = FLOW(1) + FLOW(2)
         EXTRA = REST - TFLOW
         M = 85
 600     CONTINUE
         IF ( .NOT. QMORE ) GO TO 650
         QMORE = .FALSE.
         IF ( M .LT. 45 .OR. M .GT. 60 ) GO TO 650
*         
*  COMPUTE RELEASE TEMPERATURE OF FLOW
*  THROUGH SELECTED PORT CONFIGURATION
*  AND AGAIN DETERMINE PORTS AND FLOWS
*         

        write(LogProgress,*) '     - START   calculating release temperature through a selected port configuration' 
         JXOPEN = JOPEN
         DO 610 K = 1, JXOPEN
         XFLOW(K) = FLOW(K)
         JXPORT(K) = JPORT(K)
 610     CONTINUE
*         
         DO 640 K = 1, JXOPEN
         J = JXPORT(K)
         JOPEN = 1
         FLOW(1) = XFLOW(K)
         JPORT(1) = JXPORT(K)
 640     CONTINUE  
         GO TO 200
 650     CONTINUE
         EXTRA = 0.
         SUMQ = 0.
         DO 655 I = 1, JOPEN
         SUMQ = SUMQ + FLOW(I)
 655     CONTINUE
         EXTRA = RELE - SUMQ
         FGMAX = FGMAX / FGCF
         FGMIN = FGMIN / FGCF
         RELE = RELE - EXTRA
         DO 702 JJ=1,9
         QFLOW(JJ)=0.
 702     CONTINUE
C
C    ASSIGN FLOWS TO SELECTED PORTS
C

        write(LogProgress,*) '     - START   calculating release temperature through a selected port configuration' 
         DO 705 JJ=1,JOPEN
         LL=JPORT(JJ)
         QFLOW(LL)=FLOW(JJ)
 705     CONTINUE                
        write(LogProgress,*) '     - START   calculating release flow through a selected port configuration'           
        write(LogProgress,*) '     - END     calculating release temperature through a selected port configuration' 
         RETURN
         END


         SUBROUTINE RADIATE(LogProgress)
         INCLUDE 'odu_com.f'
C
C*********************************************************************
C
C  S U B R O U T I N E  R A D I A T E                       NUMBER 3
C
C*********************************************************************
         DIMENSION A(4),B(4),GAMMA(8),SIGMA(8),ALPHA(8),BETA(8)
         DATA A/1.18,2.20,0.95,0.35/
         DATA B/-0.77,-0.97,-0.75,-0.45/
         DATA GAMMA/0.07298,0.07267,0.07204,0.07106,0.06971,0.06795,
     *              0.06579,0.06316/
         DATA SIGMA/0.00110,0.00116,0.00122,0.00129,0.00136,0.00142,
     *              0.00150,0.00157/
         RO(X,Y,Z)=1000.-(((X-3.98)**2*(X+283.))/(503.57*(X+67.26)))
     *             +0.00062*Y+0.00078*Z
         DATA ALPHA/6.05,5.10,2.65,-2.04,-9.94,-22.29,-40.63,-66.90/
         DATA BETA/0.522,0.710,0.954,1.265,1.659,2.151,2.761,3.511/
C
C  CALCULATE HOURLY SW RADIATION (KCAL/M2-HR)
C

Cy	write(6,*) 'LogProgress at RADIATE= ', LogProgress
Cy	stop
        write(LogProgress,*) '     - START   calculating shortwave radiation' 
         DELTS=DABS((DBLE(15*IDINT(XLON/15.))-XLON)/15.)
         DECL=0.4092*DCOS(0.01721*(172.-DBLE(MOD(NDAY,365))))
         T1=DSIN(DECL)*DSIN(.01745*XLAT)
         T2=DCOS(DECL)*DCOS(.01745*XLAT)
         HSR=(12./3.14159)*DACOS(-(T1/T2))
         SUNUP=12.-HSR+DELTS
         SUNSET=12.+HSR+DELTS
*************************************************************************
         REARTH=1.0+0.017*DCOS((2.*3.14159/365.)*(186.-DBLE(NDAY)))
         RR=REARTH**2.
         ALT=ELEMSL+RESEL
************************************************************************DH
       DO 10 I=1,NHOI
           QNS(I)=0.
           IF(DBLE(NHRS+I).LE.SUNUP.OR.DBLE(NHRS+I).GE.SUNSET)GO TO 10
           SINA=T1+T2*DCOS((3.14159/12.)*(DBLE(NHRS+I)-12.-DELTS))
           IF(SINA.LT.0.01)GO TO 10
           IF(CLD(I).LT.0.05)J=1
           IF(CLD(I).GE.0.05 .AND.CLD(I).LT.0.5)J=2
           IF(CLD(I).GE.0.5.AND.CLD(I).LT.0.95)J=3
           IF(CLD(I).GE.0.95)J=4
           ALBEDO=A(J )*(57.3*DASIN(SINA))**B(J)
*************************************************************************DH
C
C ALT AND DP(I) WERE CONVERTED TO FEET AND FAHRENHEIT RESPECTIVELY
C AND WERE USED IN THE FOLOWING EQUATIONS TO SOLVE FOR DIMENSIONLESS 
C QUANTITIES OF OPTICAL AIR MASS AND ATMOSPHERIC COEFFICIENTS (A1 AND A11).
C A1 AND A11 ARE USED TO SOLVE FOR THE ATMOSPHERIC TRANSMISSION TERM
C WHICH IS PART OF THE EQUATION SOLVING FOR RAD.
C
           WAT = 0.00614*DEXP(0.0489*((DP(I)*(9./5.))+32.))
           AMASS = DEXP(-(ALT*3.28)/2532.)/(SINA+
     *     (0.15*(DASIN(SINA)*(180.0/3.14159)+3.885)**(-1.253)))
           A1 = DEXP(-(0.465+0.0408*WAT)*(0.129+0.171*DEXP(- 0.88*
     *     AMASS))*AMASS)
           A11 = DEXP(-(0.465+0.0408*WAT)*(0.179+0.421* 
     *     DEXP(- 0.721*AMASS))*AMASS)
           RAD=(SINA/(3.*RR))*((A11+(0.5*(1.0-A1-TURB)))/(1.0-(0.5*
     *     ALBEDO*(1.0-A1+TURB))))*(1.-0.65*CLD(I)**2)
*************************************************************************DH
           QNS(I)=RAD*(1.-ALBEDO)*3600.
           IF(QNS(I).LT.0.)QNS(I)=0.
   10    CONTINUE
        write(LogProgress,*) '     - END     calculating shortwave radiation' 

C
C  COMPUTE HOURLY LW RADIATION (KCAL/M2-HR)
C

        write(LogProgress,*) '     - START   calculating longwave radiation' 
         DO 40 I=1,NHOI
           QNA(I)=1.23E-16*(1.+0.17*CLD(I)**2)*((DB(I)+273.)**6.)*3600.
   40    CONTINUE
        write(LogProgress,*) '     - END     calculating longwave radiation' 
C
C  AVERAGE HOURLY RADIATION AND METEOROLOGICAL QUANTITIES
C  OVER NHOI HOURS
C
         SUM1=0.
         SUM2=0.
         SUM3=0.
         SUM4=0.
         SUM5=0.
         SUM6=0.
         DO 60 I=1,NHOI
           SUM1=SUM1+DB (I)
           SUM2=SUM2+APR(I)
           SUM3=SUM3+WND(I)
           SUM4=SUM4+DP(I)
           SUM5=SUM5+QNS(I)
           SUM6=SUM6+QNA(I)
   60    CONTINUE
         XDBT=SUM1/DBLE(NHOI)
         XAPR=SUM2/DBLE(NHOI)
         XWND=SUM3/DBLE(NHOI)
         XDPT=SUM4/DBLE(NHOI)
         XQNS=SUM5/DBLE(NHOI)
         XQNA=SUM6/DBLE(NHOI)
C
C  COMPUTE VAPOR PRESSURE (MILLIBARS)
C
        write(LogProgress,*) '     - START   calculating vapor pressure' 
         EA=2.1718E+8*DEXP(-4157./(XDPT+239.09))
        write(LogProgress,*) '     - START   calculating vapor pressure'
C
C  COMPUTE SATURATION VAPOR PRESSURE (MILLIBARS)
C

        write(LogProgress,*) '     - START   calculating saturation vapor pressure' 
         I=IDINT(TEMP(NUME)/5.+1.)
         IF(I.GT.8)I=8
         IF(I.LT.1)I=1
         ES=ALPHA(I)+BETA(I)*TEMP(NUME)
        write(LogProgress,*) '     - END     calculating saturation vapor pressure' 
                 
C
C  COMPUTE EVAPORATION RATE  (METERS/HR)
C

        write(LogProgress,*) '     - START   calculating evaporation rate' 
         EV=(0.2778*XWND*BB+AA)*(ES-EA)*3600.
         IF(EV.LT.0.)EV=0.
         TEV=TEV+EV*DBLE(NHOI)
        write(LogProgress,*) '     - END     calculating evaporation rate' 
                 
C
C  COMPUTE NET RATE OF HEAT TRANSFER. (KCAL/M2/HR)  
C  NOTE-"FONE" AND "FTWO" ARE USED IN S/R TMPRTR.
C

        write(LogProgress,*) '     - START   calculating net heat transfer rate' 
         I=IDINT(TEMP(NUME)/5.+1.)
         IF(I.GT.8)I=8
         IF(I.LT.1)I=1
         ROL=RO(TEMP(NUME),SSOL(I),TDS(I))*(597.-0.57*TEMP(NUME))*
     *       (AA+BB*0.2778*XWND)
         FONE=XQNA-(GAMMA(I)+ROL*(ALPHA(I)-EA-6.1E-4
     *        *XAPR*XDBT))*3600.
         FTWO=(ROL*(BETA(I)+6.1E-4*XAPR)+SIGMA(I))*3600.
        write(LogProgress,*) '     - END     calculating net heat transfer rate' 
        
         RETURN
         END


         SUBROUTINE FLOWIN
         INCLUDE 'odu_com.f'
C
C*********************************************************************
C
C  S U B R O U T I N E  F L O W I N                         NUMBER 4
C
C*********************************************************************
         DIMENSION ARMID(70)
         RO(X,Y,Z)=1000.-(((X-3.98)**2*(X+283.))/(503.57*(X+67.26)))
     *             +0.00062*Y+0.00078*Z
C
C  INITIALIZE LAYER FLOWS AND TEMPERATURE SOURCE TERMS
C
         QI=0.
         DO 10 I=1,NUME
           QHI(I)=0.
           DO 11 J=1,3
             EQ3(I,J)=0.
   11      CONTINUE
   10    CONTINUE
C
C  BY TRIBUTARY FIND INFLOW ENTRY LAYER BY MATCHING DENSITIES
C  USE SECOND LAYER AS A DEFAULT.INITIALIZE INFLUENCE ZONE LIMITS
C
   06    DO 25 I=1,NTRIBS
           QI=QI+QIN(I)
C
C     IS THE DENSITY OF INFLOW LESS THAN THE SURFACE DENSITY ? OR
C     IS IT GREATER THAN THE HYPOLIMNION DENSITY ?
C
           IF(DENS(NUME)-RO(TEMPIN(I),SSOLIN(I),TDSIN(I)).GT.CDENS)
     *       GO TO 200
           IF(RO(TEMPIN(I),SSOLIN(I),TDSIN(I))-DENS(1).GT.CDENS)
     *       GO TO 300
           JMIN=1
           JMAX=NUME
           DO 30 J=1,NUME
             K=NUME+1-J
             IF(DENS(K).GE.RO(TEMPIN(I),SSOLIN(I),TDSIN(I)))GO TO 40
   30      CONTINUE
           K=2
C
C        IS THE ENTRY LAYER OUTSIDE OF THE MIXED ZONE ?
C
   40      IF(K.LT.IMIX)GO TO 50
C
C        ENTRY LAYER IS IN MIXED ZONE.
C        DOES THE INFLOW VOLUME FROM THIS TRIBUTARY
C        FIT INTO THE MIXED ZONE VOLUME ?
C
           JMIN=IMIX
           IF(VOL(NUME+1)-VOL(IMIX).GT.QIN(I)*DBLE(NHOI))GO TO 60
C
C        INFLOW VOLUME TOO BIG FOR MIXED ZONE.FIND NEXT LOWER
C        LAYER FOR VOLUME MATCH. (USE BOTTOM LAYER AS DEFAULT)
C
           JMIX=IMIX-1
           DO 70 J=1,JMIX
             JMIN=IMIX-J
             IF(VOL(NUME+1)-VOL(JMIN).GT.QIN(I)*DBLE(NHOI))GO TO 60
   70      CONTINUE
           GO TO 60
C
C     ENTRY LAYER IN STRATIFIED ZONE, CALCULATE UPPER AND
C     LOWER BOUNDARIES OF INFLOW ZONE SEPARATELY ACCORDING
C     TO DEBLER CRITERION.  USE THEORETICAL FROUDE NUMBER OF
C     1/PI.  ITERATIVELY WIDEN UPPER/LOWER INFLOW BOUNDARY
C     ONE LAYER UNTIL DISTANCE BETWEEN MIDPOINTS OF ENTRY
C     AND BOUNDARY LAYERS MATCHES CALCULATED DEBLER
C     HALF-ZONE THICKNESS TO WITHIN ONE-HALF AVERAGE
C     LAYER THICKNESS.  NOTE THAT ACTUAL DENSITY GRADIENT
C     OVER DEBLER HALF-ZONE THICKNESS USED RATHER THAN
C     SOME AVERAGE DENSITY GRADIENT.
C
   50      SUM=0.
           DO 55 J=1,NUME
             SUM=SUM+SDZ(J)
   55      CONTINUE
           SDZAVG=SUM/DBLE(NUME)
           MAX=K
           MIN=K
C
C     CALCULATE UPPER LIMIT TO INFLOW ZONE
C
   41      MAX=MAX+1
           IF(MAX.GT.NUME)GO TO 45
           IF(DENS(K)-DENS(MAX).LE.0.)GO TO 41
           ARMID(K)=(AREA(K)+AREA(K+1))/2.
           DBLRUP=1.35*((QIN(I)/3600.)*RLEN/(ARMID(K)*
     *            DSQRT(9.8*(DENS(K)-DENS(MAX))/DENS(K))))**(2./3.)
           TESTU=DBLRUP-(Z(MAX)+SDZ(MAX)/2.-Z(K)-SDZ(K)/2.)
           IF(DABS(TESTU).LE.SDZAVG/2.)GO TO 42
           IF(TESTU.LE.0.)GO TO 42
           GO TO 41
C
C     READJUST UPPER INFLOW BOUNDARY BY COMPARING UPPER
C     DEBLER HALF-ZONE THICKNESS WITH ACTUAL LAYER THICKNESSES
C     ABOVE INFLOW LAYER.
C
   42      DO 43 J=K,NUME
             IF(Z(J+1)-Z(K)-SDZ(K)/2..GE.DBLRUP)GO TO 44
   43      CONTINUE
   44      JMAX=J
C
C     CALCULATE LOWER LIMIT TO INFLOW ZONE
C
   45      MIN=MIN-1
           IF(MIN.LT.1)GO TO 51
           IF(DENS(MIN)-DENS(K).LE.0.)GO TO 45
           ARMID(K)=(AREA(K)+AREA(K+1))/2.
           DBLRLW=1.35*((QIN(I)/3600.)*RLEN/(ARMID(K)*
     *            DSQRT(9.8*(DENS(MIN)-DENS(K))/DENS(K))))**(2./3.)
           TESTL=DBLRLW-(Z(K)+SDZ(K)/2.-Z(MIN)-SDZ(MIN)/2.)
           IF(DABS(TESTL).LE.SDZAVG/2.)GO TO 46
           IF(TESTL.LE.0.)GO TO 46
           GO TO 45
C
C     READJUST LOWER INFLOW BOUNDARY BY COMPARING LOWER
C     DEBLER HALF-ZONE THICKNESS WITH ACTUAL LAYER
C     THICKNESSES BELOW INFLOW LAYER.
C
   46      DO 47 J=1,K
             JJ=K+1-J
             IF(Z(K)+SDZ(K)/2.-Z(JJ).GE.DBLRLW)GO TO 48
   47      CONTINUE
   48      JMIN=JJ
C
C        ADJUST INFLOWS TO MAXIMUM LAYER VOLUMES
C
   51      IF(JMAX.GE.NUME)GO TO 52
           IF(VOL(JMAX+1)-VOL(JMIN).GE.QIN(I)*DBLE(NHOI))GO TO 60
           JMAX=JMAX+1
           GO TO 51
   52      IF(JMIN.LE.1)GO TO 60
           IF(VOL(JMAX+1)-VOL(JMIN).GE.QIN(I)*DBLE(NHOI))GO TO 60
           JMIN=JMIN-1
           GO TO 52
  200      CONTINUE
C
C        INFLOW FLOATS ON WATER SURFACE. DISTRIBUTE INFLOW FROM
C        SURFACE DOWN.  USE BOTTOM LAYER AS DEFAULT
C
           JMAX=NUME
           DO 210 J=1,NUME
             JMIN = NUME+1-J
             IF(VOL(NUME+1)-VOL(JMIN).GT.QIN(I)*DBLE(NHOI)) GO TO 60
  210      CONTINUE
           GO TO 60
  300      CONTINUE
C
C        INFLOW SINKS TO BOTTOM. DISTRIBUTE INFLOW FROM BOTTOM UP.
C        USE TOP LAYER AS DEFAULT
C
           JMIN=1
           DO 310 J=1,NUME
             JMAX=J
             IF(VOL(J).GT.QIN(I)*DBLE(NHOI)) GO TO 60
  310      CONTINUE
C
C        DISTRIBUTE INFLOW AND TEMPERATURE SOURCE TERMS
C
   60      IF(JMIN.LT.1)JMIN=1
           IF(JMAX.LT.1)JMAX=1
           IF(JMAX.GT.NUME)JMAX=NUME
           IF(JMIN.GT.JMAX)JMIN=JMAX
           DO 120 J=JMIN,JMAX
             QHI(J)=QHI(J)+QIN(I)*(DVOL(J)/(VOL(JMAX+1)-VOL(JMIN)))
             FEE(J)=FEE(J)+QIN(I)*(DVOL(J)/(VOL(JMAX+1)-VOL(JMIN)))
     *              *RO(TEMPIN(I),SSOLIN(I),TDSIN(I))*TEMPIN(I)*1.
             DO 130 K=2,3
               EQ3(J,K)=EQ3(J,K)+QIN(I)
     *                  *(DVOL(J)/(VOL(JMAX+1)-VOL(JMIN)))
     *                  *EQ4(I,K)
  130        CONTINUE
  120      CONTINUE
   25    CONTINUE
         RETURN
         END
         SUBROUTINE CONTRL
         INCLUDE 'odu_com.f'
C
C*********************************************************************
C
C S U B R O U T I N E  C O N T R L                          NUMBER 5
C
C*********************************************************************
C  CONTROL GENERATION AND
C  PUMPBACK PROCESSES
C
         INTEGER CHDAY,OPCYCL
         CHARACTER*1 TYPE
         LOGICAL QOPCH
C
C  INITIALIZE COUNTER FOR
C  OPERATON CHANGE DAYS
C
         IF (NHOURS .GT. ISTART ) GO TO 120
         DO 100 M = 1, OPCH
           KOUNT = M - 2
           KDAY = FDAY(M)
           IF ( KDAY .GT. ISTART/24+1 ) GO TO 110
 100     CONTINUE
         KOUNT = OPCH - 1
 110     CONTINUE
         IF ( KOUNT .LT. 0 ) KOUNT = 0
         QOPCH = .TRUE.
         GO TO 130
 120     CONTINUE
         QOPCH = (NHOURS+NHOI)/24 .EQ. CHDAY
 130     CONTINUE
         IF ( .NOT. QOPCH ) GO TO 140
         KOUNT = KOUNT + 1
         OPCYCL = NSETS(KOUNT)
         CHDAY = FDAY(KOUNT + 1)
 140     CONTINUE
C
C  INITIATE CYCLE THROUGH
C  DATA SETS FOR CURRENT DAY
C
         RBVOL = 0.
         SUMGV = 0.
         SUMGTV = 0.
         SUMPTV = 0.
         SUMPV = 0.
         SUMSOL=0.
         SUMTDS=0.
         QO=0.
         PBFLOW=0.
         DO 10 I=1,NUME
           QHO(I)=0.
           SUMFLO(I)=0.
           OUTFLO(I)=0.
           PBENTR(I)=0.
   10    CONTINUE
         PHOURS = 0.
         GHOURS = 0.
         GVOLUME=0.
         PVOLUME=0.
         PGAMMA=0.
         BF=0.
         MF=0.
         DO 51 I=1,8
            QOT(I)=0.
   51    CONTINUE
           SUMTMP=0.
           SUMTDS=0.
           SUMSOL=0.
         DO 230 ICYCL = 1, OPCYCL
C
C  ASSIGN VALUES FOR
C  CURRENT DATA SET
C
           IF(FTYPE(KOUNT,ICYCL).EQ.'P')TYPE='P'
           IF(FTYPE(KOUNT,ICYCL).EQ.'G')TYPE='G'
           TIME = FTIME(KOUNT,ICYCL)
           RATE = FRATE(KOUNT,ICYCL)*3600.
           NNPORT=NPORTN(KOUNT,ICYCL)
C
C  COMPUTE VOLUME OF FLOW
C  FOR BUDGETING PROCESS
C  (FLOW IN M3, RATE IN M3/HR, TIME IN HRS)
C
           FLOVOL = RATE * TIME
           IF ( FLOVOL .LE. 0. ) GO TO 230
           IF ( TYPE .EQ. 'G' ) GVOLUME = FLOVOL
           IF ( TYPE .EQ. 'P' ) PVOLUME = FLOVOL
C
C  DISTINGUISH GENERATION
C  AND PUMPBACK PROCESSES
C
           IF ( TYPE .EQ. 'G' ) GO TO 160
           IF ( TYPE .EQ. 'P' ) GO TO 220
           WRITE(MoomawOut,3000)
 3000      FORMAT(' GENERATION OR PUMPBACK SPECIFICATION ERROR')
           STOP
 160       CONTINUE
C*
C*  GENERATION
C*
C  TRANSFER TO THE
C  APPROPRIATE SUBPROGRAMS
C  FOR GENERATION
C
           HGTPRT=ELOUT(NNPORT)
           DO 170 I=1,NUME
             IF(HGTPRT.GT.Z(I+1))GO TO 170
             LAYPRT=I
             GO TO 171
  170      CONTINUE
  171      FLORAT = RATE
           QOT(NNPORT)=RATE+QOT(NNPORT)
           NOUT(NNPORT)=LAYPRT
           DENPRT=DENS(LAYPRT)
           CALL VPORT
C
C  DETERMINE LAYER OUTFLOW VOLUMES (M3)
C  FOR THIS GENERATION EVENT
C
           SUM=0.
           DO 300 I=1,NUME
             OUTFLO(I)=V(I)*SDZ(I)*TIME
             SUM=SUM+OUTFLO(I)
  300      CONTINUE
           SCALE=FLOVOL/SUM
           DO 310 I=1,NUME
             OUTFLO(I)=OUTFLO(I)*SCALE
             SUMFLO(I)=SUMFLO(I)+OUTFLO(I)
  310      CONTINUE
C
C DETERMINE OUTFLOW QUALITIES (DEG C AND G/M3)
C FOR THIS GENERATION EVENT
C
           SUM=0.
           DO 320 I=1,NUME
             SUM=SUM+OUTFLO(I)
  320      CONTINUE
           GTEMP=0.
           GTDS=0.
           GSSOL=0.
           DO 330 I=1,NUME
             SUMTMP=SUMTMP+OUTFLO(I)*TEMP(I)
             SUMTDS=SUMTDS+OUTFLO(I)*TDS(I)
             SUMSOL=SUMSOL+OUTFLO(I)*SSOL(I)
             GTEMP=GTEMP+OUTFLO(I)*TEMP(I)
             GTDS=GTDS+OUTFLO(I)*TDS(I)
             GSSOL=GSSOL+OUTFLO(I)*SSOL(I)
  330      CONTINUE
           GTEMP=GTEMP/SUM
           GTDS=GTDS/SUM
           GSSOL=GSSOL/SUM
           SUMGV = SUMGV + GVOLUME
           SUMGTV = SUMGTV + GTEMP * GVOLUME
           GHOURS = GHOURS + TIME
C
C  BUDGET GENERATION VOLUME
C  INTO RELEASE BARREL
C
           RBTEMP = ( RBVOL * RBTEMP + FLOVOL * GTEMP ) /
     *              ( RBVOL + FLOVOL )
           RBSSOL=(RBVOL*RBSSOL+FLOVOL*GSSOL)/(RBVOL+FLOVOL)
           RBTDS=(RBVOL*RBTDS+FLOVOL*GTDS)/(RBVOL+FLOVOL)
           RBVOL = RBVOL + FLOVOL
C
C  WRITE GENERATION EVENT TO OUTPUT
C
           IF(MOD(NHOURS-ISTART+NHOI,IPRT).NE.0)GO TO 230
           CALL OUTPT3(1)
           GO TO 230
C*
C*  PUMPBACK
C*
 220       CONTINUE
           PHOURS = PHOURS + TIME
C
C  DETERMINE AMOUNT OF PREVIOUS RELEASE
C  VOLUME THAT CONTRIBUTES TO PUMPBACK
C
           RBPUMP = DMIN1 ( RBVOL, PBCOEF * PVOLUME )
           RBVOL = RBVOL - RBPUMP
C
C  DETERMINE AMOUNT OF AFTERBAY VOLUME
C  THAT CONTRIBUTES TO PUMPBACK
C
           ABPUMP = PVOLUME - RBPUMP
           ABVOL = ABVOL - ABPUMP
C
C  COMPUTE PUMPBACK QUALITIES
C
           PBTEMP = ( RBPUMP * RBTEMP + ABPUMP * ABTEMP ) / PVOLUME
           PBSSOL=(RBPUMP*RBSSOL+ABPUMP*ABSSOL)/PVOLUME
           PBTDS=(RBPUMP*RBTDS+ABPUMP*ABTDS)/PVOLUME
C
C  SIMULATE THE PUMPBACK PROCESSES.
C  WRITE PUMPBACK EVENT OUTPUT TEXT TO SCRATCH FILE.
C
          PBAREA=AROUT(NNPORT)
          PBHGT=ELOUT(NNPORT)
          BTM=ELOUT(NNPORT)-(.5*PVDIM(NNPORT))
          TOP=ELOUT(NNPORT)+(.5*PVDIM(NNPORT))
          CHBTM=0.0
           PBRATE = RATE
           CALL PUMPKN
           CALL INFLOP
           CALL BUCKET
           IF(MOD(NHOURS-ISTART+NHOI,IPRT).NE.0)GO TO 232
           CALL OUTPT3(2)
  232      SUMPV = SUMPV + PVOLUME
           SUMPTV = SUMPTV + PBTEMP * PVOLUME
  230    CONTINUE
C
C DETERMINE AVERAGE DAILY OUTFLOW QUALITIES
C OVER GENERATION CYCLES. DETERMINE AVERAGE DAILY
C TEMPERATURE AND FLOW RATE OVER PUMPBACK CYCLES.
C (THESE QUANTITIES AVAILABLE FOR OUTPUT)
C
         TEMPOU = 0.
         TDSOU=0.
         SSOLOU=0.
         IF ( SUMGV .GT. 0. ) TEMPOU = SUMGTV / SUMGV
         IF(SUMGV.GT.0.)TDSOU=SUMTDS/SUMGV
         IF(SUMGV.GT.0.)SSOLOU=SUMSOL/SUMGV
         APBRAT=0.
         IF(PHOURS.LE.0.)GO TO 410
         IF ( SUMPV .GT. 0. ) APBRAT = SUMPV
     *         / PHOURS * ( 1. + PGAMMA )
  410    APBTMP = 0.
         IF (SUMPV .GT. 0.) APBTMP = SUMPTV / SUMPV
C
C DETERMINE AVERAGE DAILY NET LAYER OUTFLOW RATE
C OVER GENERATION 
C
         IF(GHOURS.LE.0.)GO TO 400
         DO 340 I=1,NUME
           QHO(I)=SUMFLO(I)/GHOURS
  340    CONTINUE
  400    CONTINUE
C
C DETERMINE TOTAL AVERAGE OUTFLOW RATE
C
         DO 350 I=1,NUME
           QO=QO+QHO(I)
  350    CONTINUE
         RETURN
         END
         SUBROUTINE PUMPKN
         INCLUDE 'odu_com.f'
C
C*********************************************************************
C
C S U B R O U T I N E   P U M P K N                         NUMBER 6
C
C*********************************************************************
C  CALCULATE WITHDRAWAL FROM EACH LAYER,
C  FOR PUMPBACK ENTRAINMENT
C  DETERMINE ENTRAINED TEMPERATURE, QUALITIES, AND
C  PERFORM PARTIAL WATER BALANCE
C
         RO(X,Y,Z)=1000.-(((X-3.98)**2*(X+283.))/(503.57*(X+67.26)))
     *             +0.00062*Y+0.00078*Z
C
C  COMPUTE DENSITY PROFILE AND PUMPBACK DENSITY
C
         DO 90 I=1,NUME
           DENS(I)=RO(TEMP(I),SSOL(I),TDS(I))
  90     CONTINUE
         PBDEN=RO(PBTEMP,PBSSOL,PBTDS)
C
C  USE GENERAL ENTRAINMENT ALGORITHM
C
         QSBJET = .FALSE.
         CALL ENTRN
C
C  ** NOTE**  CONVERT ARRAY 'QE' FROM M3/HR TO M3
C
         DO 10 I=1,NUME
           QE(I)=QE(I)*TIME
   10    CONTINUE
C
C  SCALE ENTRAINED FLOW
C
         SUM=0.
         DO 127 I=1,NUME
           SUM=SUM+QE(I)
  127    CONTINUE
         SCALE=PGAMMA*FLOVOL/SUM
         DO 124 I = 1, NUME
           PBENTR(I) = QE(I)*SCALE
 124     CONTINUE
C
C  INITIALIZE OUTFLOW SUMMATIONS
C
         SUMF = 0.
         SUMTF = 0.
         SUMSOL=0.
         SUMTDS=0.
C
C  SUM ENTRAINED CHARACTERISTICS
C
         DO 240 I = 1, NUME
           IF ( I .GE. NUME) GO TO 250
           FLOW = PBENTR(I)
           IF ( FLOW .LE. 0. ) GO TO 240
           SUMF = SUMF + FLOW
           SUMTF = SUMTF + TEMP(I) * FLOW
           SUMSOL=SUMSOL+SSOL(I)*FLOW
           SUMTDS=SUMTDS+TDS(I)*FLOW
  240    CONTINUE
  250    CONTINUE
C
C  CALCULATE AVERAGE ENTRAINED CHARACTERISTICS
C
         ENTEMP=0.
         ENSSOL=0.
         ENTDS=0.
         IF ( SUMF .LE. 0. ) GO TO 270
         ENTEMP = SUMTF / SUMF
         ENSSOL=SUMSOL/SUMF
         ENTDS=SUMTDS/SUMF
C
C  COMPUTE RESULTANT DENSITY PROFILE
C
         DO 280 I = 1,NUME
           DENS(I)=RO(TEMP(I),SSOL(I),TDS(I))
  280    CONTINUE
  270    RETURN
         END
         SUBROUTINE INFLOP
         INCLUDE 'odu_com.f'
C
C*********************************************************************
C
C   S U B R O U T I N E   I N F L O P                       NUMBER 7
C
C*********************************************************************
C  PLACE PUMPBACK QUANTITY AND QUALITY
C  INTO LAKE AT LEVEL OF PUMPBACK DENSITY.
C
         INTEGER UPPER
         DATA DSMALL / 1.E - 03 /
         RO(X,Y,Z)=1000.-(((X-3.98)**2*(X+283.))/(503.57*(X+67.26)))
     *             +0.00062*Y+0.00078*Z
         IF ( FLOVOL .LE. 0. ) GO TO 170
C
C  CALCULATE MIXED TEMPERATURE AND QUALITIES
C  OF ENTRAINED VOLUME AND PUMPBACK VOLUME
C
         PBTV = PBTEMP * FLOVOL
         ENTV = ENTEMP * FLOVOL * PGAMMA
         VTOTAL = FLOVOL * ( 1. + PGAMMA )
         TPE = ( PBTV + ENTV ) / VTOTAL
         PBQSOL=PBSSOL*FLOVOL
         PBQTDS=PBTDS*FLOVOL
         ENQSOL=ENSSOL*FLOVOL*PGAMMA
         ENQTDS=ENTDS*FLOVOL*PGAMMA
         QMXSOL=(PBQSOL+ENQSOL)/VTOTAL
         QMXTDS=(PBQTDS+ENQTDS)/VTOTAL
C
C  CALCULATE DENSITY OF INFLOW
C
         DENMIX=RO(TPE,QMXSOL,QMXTDS)
C
C  DETERMINE LAYER OF PUMPBACK
C
         DO 100 I = 1, NUME
           PBLAYR = I
           IF ( DENMIX .GT. DENS(I) ) GO TO 110
 100     CONTINUE
         PBLAYR = NUME
 110     CONTINUE
C
C  IF LAYER OF PUMPBACK IS IN
C  AN ISOTHERMAL REGION THEN
C  CENTER PUMPBACK LOCATION
C
         LOWER = PBLAYR
         DO 120 I = LOWER, NUME
           IF ( DENS(LOWER) - DENS(I) .LT. DSMALL ) GO TO 120
           UPPER = I
           GO TO 130
 120     CONTINUE
         UPPER = NUME
 130     CONTINUE
         PBLAYR = ( UPPER + LOWER ) / 2
C
C DEFINE PUMPBACK FLOW
C
         PBFLOW=VTOTAL
  170    RETURN
         END
         SUBROUTINE BUCKET
         INCLUDE 'odu_com.f'
C
C*********************************************************************
C
C  S U B R O U T I N E   B U C K E T                        NUMBER 8
C
C*********************************************************************
C   THIS SUBROUTINE ADJUSTS THE VERTICAL PROFILES TO
C   ACCOUNT FOR THE EFFECT OF THE PUMPBACK CURRENT.
C
         INTEGER UPPER
         DATA  G /1.2714E+08/
         DATA C7, C8 / .1644, - 0.115 /
         DATA SMALL / 1.E - 03 /
         RO(X,Y,Z)=1000.-(((X-3.98)**2*(X+283.))/(503.57*(X+67.26)))
     *             +0.00062*Y+0.00078*Z
         DO 10 I=1,NUME
           ETA(I)=0.
   10    CONTINUE
C
C   COMPUTE THE THICKNESS OF THE PUMPBACK CURRENT
C   USING A MODIFIED FORM OF DEBLERS CRITERIA.
C
         CFLOW = PBRATE
         XXX = CFLOW / ( WIDTH(PBLAYR) * DSQRT ( G ) )
         DELRHO = DENS(1) - DENS(NUME)
         IF ( DELRHO .LT. SMALL ) GO TO 100
         Z32 = XXX / DSQRT( DELRHO/PBDEN )
         THICK = 4.1 * Z32 ** 0.6667
         IF ( THICK .GT. RESEL ) THICK = RESEL
         GO TO 110
 100     CONTINUE
         THICK = RESEL
 110     CONTINUE
C
C   COMPUTE THE NUMBER OF LAYERS TO MIX.
C
         SUM=0.
         DO 105 I=1,NUME
           SUM=SUM+SDZ(I)
  105    CONTINUE
         SDZAVG=SUM/DBLE(NUME)
         LAYRS=INT(0.5+THICK)/SDZAVG
 120     CONTINUE
         IF ( LAYRS .LT. 3 ) RETURN
         K = MOD ( 2, LAYRS )
         IF ( K .EQ. 0 ) LAYRS = LAYRS - 1
         NLAY = ( LAYRS - 1 ) / 2
         LOWER = PBLAYR - NLAY
         UPPER = PBLAYR + NLAY
C
C   CHECK FOR SURFACE OR BOTTOM BOUNDARY INTERFERENCE WITH
C   THE PUMPBACK CURRENT AND SHIFT THE LOCATION OF THE
C   CURRENT IF REQUIRED.
C
         LLDIF = 0
         LUDIF = 0
         IF ( LOWER .GE. 1 ) GO TO 130
         LLDIF = 1 - LOWER
         LOWER = 1
 130     CONTINUE
         IF ( UPPER .LE. NUME ) GO TO 140
         LUDIF = UPPER - NUME
         UPPER = NUME
 140     CONTINUE
         IF ( LLDIF .EQ. 0 .AND. LUDIF .EQ. 0 ) GO TO 180
         IF ( LLDIF .EQ. 0 ) GO TO 160
         NEW = UPPER + LLDIF
         IF ( NEW .LE. NUME ) GO TO 150
         UPPER = NUME
         LAYRS = LAYRS - ( NEW - NUME)
         GO TO 120
 150     CONTINUE
         UPPER = NEW
         IF ( LUDIF .EQ. 0 ) GO TO 180
 160     CONTINUE
         NEW = LOWER - LUDIF
         IF ( NEW .GE. 1 ) GO TO 170
         LOWER = 1
         LAYRS = LAYRS - ( 1 - NEW )
         GO TO 120
 170     CONTINUE
         LOWER = NEW
 180     CONTINUE
C
C   COMPUTE THE BUCKET MIXING COEFFICIENTS
C   FOR EACH LAYER TO BE MIXED.
C
         DO 200 I = LOWER, UPPER
           LAYDIF = IABS ( I - PBLAYR )
           IF ( LAYDIF .EQ. 0 ) GO TO 190
           DIST = DABS(Z(PBLAYR)-Z(I))
           ETA(I) = C7 * DEXP ( C8 * DIST )
           GO TO 200
  190      CONTINUE
           ETA(I)=0.
  200    CONTINUE
         ETA(NUME) = 0.
C
C  COMPUTE THE PORTION OF EACH LAYER TO GO IN THE
C  BUCKET AND DETERMINE THE MIXED TEMPERATURE
C  AND QUALITIES IN THE BUCKET.
C
         SUMVT = 0.
         SUMSOL=0.
         SUMTDS=0.
         SUMV = 0.
         DO 210 I = LOWER, UPPER
           VOLHGT = DVOL(I)
           SUMVT = SUMVT + ETA(I) * VOLHGT * TEMP(I)
           SUMSOL=SUMSOL+ETA(I)*VOLHGT*SSOL(I)
           SUMTDS=SUMTDS+ETA(I)*VOLHGT*TDS(I)
           SUMV = SUMV + ETA(I) * VOLHGT
 210     CONTINUE
         IF ( SUMV .LT. SMALL ) GO TO 220
         TMIX = SUMVT / SUMV
         QMXSOL=SUMSOL/SUMV
         QMXTDS=SUMTDS/SUMV
 220     CONTINUE
C
C   REFILL THE LAYERS WITH THE CONTENTS OF THE
C   BUCKET AND THEN MIX EACH LAYER.
C
         DO 230 I = LOWER, UPPER
         VOLHGT = DVOL(I)
         X = ETA(I) * VOLHGT * TMIX
         Y = ( 1.0 - ETA(I) ) * VOLHGT * TEMP(I)
         TEMP(I) = ( X + Y ) / VOLHGT
 230     CONTINUE
         DO 350 I = LOWER, UPPER
           VOLHGT=DVOL(I)
           X=ETA(I)*VOLHGT*QMXSOL
           Y=(1.-ETA(I))*VOLHGT*SSOL(I)
           SSOL(I)=(X+Y)/VOLHGT
           X=ETA(I)*VOLHGT*QMXTDS
           Y=(1.-ETA(I))*VOLHGT*TDS(I)
           TDS(I)=(X+Y)/VOLHGT
  350    CONTINUE
C
C   COMPUTE THE DENSITY IN THE MIXED LAYERS
C
       DO 240 I = LOWER, UPPER
         DENS(I)=RO(TEMP(I),SSOL(I),TDS(I))
 240   CONTINUE
       RETURN
       END
       SUBROUTINE ENTRN
       INCLUDE 'odu_com.f'
C
C*********************************************************************
C
C S U B R O U T I N E  E N T R N                            NUMBER 9
C
C*********************************************************************
C DETERMINES ENTRAINED VOLUME FOR PUMPACK OPERATION
C
C**  COMPUTE SLOPE OF AMBIENT DENSITY PROFILE FOR LAYERS ADJACENT TO
C**  JET BY METHOD OF LEAST SQUARES
C
C**  INITIALIZE ENTRAINED VOLUME TO ZERO
C
      DO 2 I =1,NUME
         QE(I) = 0.
 2    CONTINUE
      DO 10 I=1,NUME
        IF(BTM.GE.Z(I+1))GO TO 10
        IMIN=I
        GO TO 20
   10 CONTINUE
   20 CONTINUE
      DO 30 I=1,NUME
        IF(TOP.GE.Z(I+1))GO TO 30
        IMAX=I
        GO TO 40
   30 CONTINUE
   40 CONTINUE
      A =(DENS(IMAX)-DENS(IMIN))/(Z(IMAX)+SDZ(IMAX)/2.
     *   -Z(IMIN)-SDZ(IMIN)/2.)
      DO 50 I=1,NUME
        IF(PBHGT.GE.Z(I+1))GO TO 50
        IJET=I
        GO TO 60
   50 CONTINUE
   60 CONTINUE
      RO0 = DENS(IJET)
      E = -1.2714E+08*A/RO0
      IF ( E .LE. 0. ) E = 0.
C
C**  COMPUTE JET VOLUME, MOMENTUM, AND BUOYANCY FLUXES
C    ('Q' IN M3/HR, 'M' IN M4/HR2, 'B' IN M4/HR3)
C
      Q = PBRATE
      MF = Q**2/PBAREA
      BF= 1.2714E+08*(RO0-PBDEN)*Q/RO0
      IF(E.GT.0.)GO TO 999
      IF(BF.NE.0.)GO TO 998
      WRITE(MoomawOut,9999)
 9999 FORMAT(1X,' ENTRAINMENT CONDITIONS UNDEFINED')
      STOP
  998 CALL SBJET
      RETURN
C
C**  COMPUTE CHARACTERISTIC LENGTH SCALES AND RATIOS
C
  999 LQ = DSQRT(PBAREA)
      LM = MF**(0.75)/DSQRT(DABS(BF))
      LE = (MF/E)**(0.25)
      LQLE = LQ/LE
      LMLE = LM/LE
C
C**   COMPUTE ENTRAINMENT:
C**   IF JET STRONGLY BUOYANT (LM/LE < 2 ), CALL SBJET
C**   IF WEAKLY BUOYANT (LM/LE >= 2), CALL WBJET
C
      IF(LMLE.LT.2.)CALL SBJET
      IF(LMLE.GE.2.)CALL WBJET
      RETURN
      END
        SUBROUTINE SBJET
        INCLUDE 'odu_com.f'
C
C*********************************************************************
C
C  S U B R O U T I N E   S B J E T                         NUMBER 10
C
C*********************************************************************
C**  THIS SUBROUTINE COMPUTES THE ENTRAINMENT OF BUOYANT JETS IN A
C**  STRATIFIED ENVIRONMENT.
C**  THE PROGRAM IS ADAPTED FROM KOH AND FAN BY PHIL ROBERTS
C**  11/28/81
C
      DIMENSION D(70)
C
C**  CW IS A FACTOR TO MULTIPLY THE JET WIDTH BY TO DETERMINE THE WIDTH
C**  OF THE ENTRAINMENT LAYER. DILUTION LIMITED TO 10.
C
      DATA CW/0.25/,DMAX/10./
C
C**  JET SPACING, SPACJ, PUT VERY LARGE TO AVOID MERGING
C
C
C**  SPECIFY ENTRAINMENT COEFICIENTS
C**  SLOT = PLUME VALUES, TAKEN FROM BROOKS(1972)
C**  ROUND = JET VALUES, TAKEN FROM FISCHER, ET AL (1979), PAGE 371.
C
      DATA GRAVAC/1.2714E+08/
      DATA PAI/3.14159265D0/
      QSBJET=.TRUE.
C
C DETERMINE PERTINENT LENGTHS AND JET VELOCITY
C
      DO=SQRT(4.*PBAREA/PAI)
      DJ=RESEL-PBHGT
      UO=PBRATE/PBAREA
C
C COMPUTE DEPTHS FOR TEMPERATURES AND DENSITIES
C
      DO 1 I=1,NUME
        D(I)=RESEL-(Z(I)+SDZ(I)/2.)
    1 CONTINUE
      DO 999 I=1,NUME
        YTX(I)=DJ-D(I)
  999 CONTINUE
      THETA=THETAO*PAI/180.
      ICHEK=0
      LX=0
      SX=0.
C
C     TO FIND REFERENCE TEMPERATURE AND DENSITY
C
      IR=1
      IF (DJ-D(IR))  112,113,114
  113 TR=TEMP(IR)
      DENR=DENS(IR)
      GO TO 118
  112 IR=IR+1
      IF (DJ-D(IR)) 112,113,117
  114 WRITE(MoomawOut,3000)
 3000 FORMAT(' INSUFFICIENT DATA ON AMBIENT TEMPERATURE-SBJET')
      GO TO 204
  117 SL=(DJ-D(IR))/(D(IR-1)-D(IR))
      TR=TEMP(IR)+SL*(TEMP(IR-1)-TEMP(IR))
      DENR=DENS(IR)+SL*(DENS(IR-1)-DENS(IR))
C
C     INITIAL CONDITIONS
C
  118 YX(1)=PAI*DO*DO*UO*0.5
      MF=YX(1)*UO*0.5
C
C**  GET SOURCE VOLUME FLUX
C**  NOTE THAT THIS IS HALF THE AMOUNT SPECIFIED IN KOH AND FAN TO CHANGE
C**  THE DILUTION FROM CENTERLINE TO AVERAGE
C
      VOLFJ=YX(1)/2.
      HX=MF*DCOS(THETA)
      YX(2)=MF*DSIN(THETA)
      YX(3)=YX(1)*(DENR-PBDEN)/DENR*0.5
      YX(4)=YX(1)*(TR-PBTEMP)/TR*0.5
      YX(5)=6.2*DO*DCOS(THETA)
      YX(6)=6.2*DO*DSIN(THETA)
C
C**  DO ENTRAINMENT CALCULATIONS FOR ZONE OF FLOW ESTABLISHMENT
C
      ENTVOL = VOLFJ
      XC = YX(5)/2.
      YC = YX(6)/2.
      PHI = (90. - THETAO)*PAI/180.
      SINPHI = DSIN(PHI)
      R = (0.5*DO + 2.*CW*DO)/2.
      CIRC = 2.*PAI*R
      DTOP = PBHGT + YC + R*SINPHI
      DBTM = PBHGT + YC - R*SINPHI
      DO 400 I=1,NUME
        IF(DTOP.GE.Z(I+1))GO TO 400
        NDTOP=I
        GO TO 410
  400 CONTINUE
  410 CONTINUE
      DO 420 I=1,NUME
        IF(DBTM.GE.Z(I+1))GO TO 420
        NDBTM=I
        GO TO 430
  420 CONTINUE
  430 CONTINUE
C
C**  COMPUTE PERIMETERS AND ENTRAINMENTS OF TOP AND BOTTOM LAYERS
C**  OR AMOUNT CUT OFF BY BOUNDARIES
C**  IF IN AN OPEN LAYER, WITHDRAW FROM THAT LAYER
C**  IF IN A CUTOFF LAYER, WITHDRAW FROM ADJACENT LAYER
C
C    *** SMALL PLUME INCLINATION ASSUMED ***
C
C**  BOTTOM
C
      DO 440 I=1,NUME
        IF(CHBTM.GE.Z(I+1))GO TO 440
        ICH=I
        GO TO 450
  440 CONTINUE
  450 CONTINUE
      IF(DBTM.LT.CHBTM)GO TO 600
      DELTA1 = (Z(NDBTM+1) - DBTM)/SINPHI
      IE = NDBTM
      IBTM = NDBTM
      IMIN = NDBTM + 1
      GO TO 610
  600 DELTA1 = (Z(ICH+1) - DBTM)/SINPHI
      IE = ICH
      IBTM = ICH
      IMIN = ICH + 1
  610 CONTINUE
      ADJ = R - DELTA1
      ANGLE = 2.*DACOS(ADJ/R)
      PERIM = ANGLE*R
      QE(IE) = QE(IE) + ENTVOL*PERIM/CIRC
C
C** TOP
C
      IF (DTOP.GT.RESEL)GO TO 620
      DELTA1 = (DTOP - Z(NDTOP))/SINPHI
      IE = NDTOP
      ITOP = NDTOP
      IMAX = NDTOP - 1
      GO TO 630
  620 DELTA1 = (DTOP - Z(NUME))/SINPHI
      IE = NUME
      ITOP = NUME
      IMAX = NUME - 1
  630 CONTINUE
      ADJ = R - DELTA1
      ANGLE = 2.*DACOS(ADJ/R)
      PERIM = ANGLE*R
      QE(IE) = QE(IE) + ENTVOL*PERIM/CIRC
C
C**  COMPUTE ENTRAINED VOLUMES FOR EACH INTERMEDIATE LAYER
C
      DO 3 IL = IMIN,IMAX
        H2 = DABS(PBHGT + YC - Z(IL))
        H1 = DABS(H2 - SDZ(IL))
        DELTA2 = H2/SINPHI
        DELTA1 = H1/SINPHI
        ANGLE = DABS( DASIN(DELTA1/R) - DASIN(DELTA2/R))
        PERIM = 2.*ANGLE*R
        QE(IL) = QE(IL) + ENTVOL*PERIM/CIRC
 3    CONTINUE
      IQX=0
      IP=0
      IKX=2
      SQLAM=(1.+LAMBDR*LAMBDR)/(LAMBDR*LAMBDR)
      SQRLAM=SQRT(1.+LAMBDS*LAMBDS)/LAMBDS
C
C     CALCULATION OF DENSITY AND TEMPERATURE GRADIENTS
C
      NC1=NUME-1
      DO 912 I=1,NC1
        I1=I+1
        DP1=YTX(I1)-YTX(I)
        ETX(I)=(TEMP(I1)-TEMP(I))/(TR*DP1)
        EDX(I)=(DENS(I1)-DENS(I))/(DENR*DP1)
  912 CONTINUE
C
C     CHOICE OF INTEGRATION STEP
C
      DS1=DO/20.
      DS2=DJ/200.
      K=1
      IF (DS1-DS2) 301,301,302
  301 DSX=DS1
      GO TO 303
  302 DSX=DS2
C
C      INTEGRATION BY RUNGE-KUTTA METHOD
C
      K=1
  303 CALL RUNGS
  304 Y20=YX(2)
      VOL1 = YX(1)
      X1 = YX(5)
      Y1 = YX(6)
      CALL RUNGS
      VOL2 = YX(1)
      ENTVOL = (VOL2 - VOL1)
      X2 = YX(5)
      Y2 = YX(6)
      IF (YX(2)*Y20) 20,21,21
   20 K=K+1
      IF (K-3) 21,22,22
   22 IF (ICHEK-1) 204,511,204
   21 CONTINUE
C
C     LOOP FOR TRANSITION POINT TWO
C
      IF (ICHEK-2) 513,514,204
  513 IF (ICHEK-1) 203,206,206
  203 TRANW=SPACJ
C
C     ROUND JET SOLUTION
C
  514 IF (YX(6)-DJ) 530,531,531
  531 CONTINUE
      GO TO 204
  530 IF (IQX) 533,533,206
  533 MF=DSQRT(HX*HX+YX(2)*YX(2))
      XWIDTH=2.*YX(1)/DSQRT(PAI*MF)
      IF (XWIDTH-TRANW) 207,206,206
C
C     (PRINT SPACING CONTROL)
C
  207 SJP=5.*DO
      PI=IP*SJP
C
C**  COMPUTE ENTRAINED VOLUME AND DISTRIBUTION IN LAST STEP
C**  COMPUTE DISK RADIUS, CENTER COORDINATES, AND ANGLE OF INCLINATION
C
      R = CW*XWIDTH
      CIRC = 2.*PAI*R
      XC = (X1+X2)/2.
      YC = (Y1+Y2)/2.
      PHI = DATAN((X2-X1)/DABS(Y2-Y1))
      SINPHI = DSIN(PHI)
      HD = R*SINPHI
C
C**  COMPUTE HEIGHTS OF DISK TOP AND BOTTOM AND INTEGERS OF CONTAINING
C**  LAYERS
C
      DTOP = PBHGT + YC + R*SINPHI
      DBTM = PBHGT + YC - R*SINPHI
      DO 460 I=1,NUME
        IF(DTOP.GE.Z(I+1))GO TO 460
        NDTOP=I
        GO TO 470
  460 CONTINUE
  470 CONTINUE
      DO 480 I=1,NUME
        IF(DBTM.GE.Z(I+1))GO TO 480
        NDBTM=I
        GO TO 490
  480 CONTINUE
  490 CONTINUE
C
C**  COMPUTE PERIMETERS AND ENTRAINMENTS OF TOP AND BOTTOM LAYERS
C**  OR AMOUNT CUT OFF BY BOUNDARIES
C**  IF IN AN OPEN LAYER, WITHDRAW FROM THAT LAYER
C**  IF IN A CUTOFF LAYER, WITHDRAW FROM ADJACENT LAYER
C    NOTE PROVISIONS FOR POSSIBLE STEEP PLUME ANGLES
C
C**  BOTTOM
C
      IF(DBTM.LT.CHBTM)GO TO 640
      DELTA1 = (Z(NDBTM+1) - DBTM)/SINPHI
      IE = NDBTM
      IBTM = NDBTM
      IMIN = NDBTM + 1
      GO TO 650
  640 DELTA1 = (Z(ICH+1) - DBTM)/SINPHI
      IE = ICH
      IBTM = ICH
      IMIN = ICH + 1
  650 CONTINUE
      IF(DELTA1.LE.R)ANGLEB=2.*DACOS((R-DELTA1)/R)
      IF(R.LT.DELTA1.AND.DELTA1.LE.2.*R)
     *  ANGLEB=PAI+2.*DASIN((DELTA1-R)/R)
      IF(2.*R.LT.DELTA1)ANGLEB=2.*PAI
      PERIM = ANGLEB*R
      QE(IE) = QE(IE) + ENTVOL*PERIM/CIRC
      IF(2.*R.LT.DELTA1)GO TO 5
C
C** TOP
C
      IF (DTOP.GT.RESEL)GO TO 660
      DELTA1 = (DTOP - Z(NDTOP))/SINPHI
      IE = NDTOP
      ITOP = NDTOP
      IMAX = NDTOP - 1
      GO TO 670
  660 DELTA1 = (DTOP - Z(NUME))/SINPHI
      IE = NUME
      ITOP = NUME
      IMAX = NUME - 1
  670 CONTINUE
      IF(DELTA1.LE.R)ANGLET=2.*DACOS((R-DELTA1)/R)
      IF(R.LT.DELTA1.AND.DELTA1.LE.2.*R)
     *  ANGLET=PAI+2.*DASIN((DELTA1-R)/R)
      IF(2.*R.LT.DELTA1)ANGLET=2.*PAI
      PERIM = ANGLET*R
      QE(IE) = QE(IE) + ENTVOL*PERIM/CIRC
      IF(2.*R.LT.DELTA1)GO TO 5
C
C**  COMPUTE ENTRAINED VOLUMES FOR EACH INTERMEDIATE LAYER.
C    NOTE DILUTION LIMIT. 
C
      IF(ANGLET+ANGLEB.GE.2.*PAI)GO TO 5
      DO 2 IL = IMIN,IMAX
        H2 = ABS(PBHGT + YC - Z(IL))
        H1 = ABS(H2 - SDZ(IL))
        DELTA2 = H2/SINPHI
        DELTA1 = H1/SINPHI
        ANGLE =DABS( DASIN(DELTA1/R) - DASIN(DELTA2/R))
        PERIM = 2.*ANGLE*R
        QE(IL) = QE(IL) + ENTVOL*PERIM/CIRC
    2 CONTINUE
    5 DILU=YX(1)/VOLFJ
      IF(DILU.GT.DMAX)WRITE(MoomawOut,3010)
 3010 FORMAT(' DILUTION MAXIMUM')
      IF(DILU.GT.DMAX)GO TO 204
      IF (SX-PI)  220,221,221
  220 GO TO 304
  221 IP=IP+1
      DENDIF=SQLAM*DENR*YX(3)/YX(1)
      TDIF=SQLAM*TR*YX(4)/YX(1)
      DILU=YX(1)/VOLFJ
      IF (DENDIF) 401,920,920
  401 DENDIF=DENDIF*0.5
      TDIF=0.5*TDIF
C
C     TO FIND AMBIENT DENSITY AND TEMPERATURE VALUES
C
  920 IY=2
  906 IF (YX(6)-YTX(IY))  900,901,902
  901 DENAA=DENS(IY)
      TAA=TEMP(IY)
      IY=IY+1
      GO TO 909
  900 IY=IY-1
      IF (YX(6)-YTX(IY)) 900,901,905
  905 IYY=IY+1
      SYY=(YX(6)-YTX(IYY))/(YTX(IY)-YTX(IYY))
      TAA=SYY*(TEMP(IY)-TEMP(IYY))+TEMP(IYY)
      DENAA=SYY*(DENS(IY)-DENS(IYY))+DENS(IYY)
      GO TO 909
  902 IY=IY+1
      GO TO 906
  909 TJ=TAA-TDIF
      DENJ=DENAA-DENDIF
      TDIFM=-TDIF
      GO TO 304
C
C     SLOT JET SOLUITON
C     CHECK TRANSITION POINT ONE OR TWO
C
  206 IF (YX(6)-DJ) 522,511,511
  511 ICHEK=ICHEK+1
  522 IQX=1
      IF (ICHEK-1) 240,241,241
C
C     TRANSITION POINT ONE
C
  240 CONTINUE
C
C     STORE SOLUTIONS AS INITIAL CONDITIONS FOR TRANSITION POINT TWO
C
      SO=SX
      Y1=YX(1)
      Y2=YX(2)
      Y3=YX(3)
      Y4=YX(4)
      Y5=YX(5)
      Y6=YX(6)
      TRANW=2.*ALPHAS*SPACJ/(PAI*ALPHAR)
      IPC=IP
      KI=K
      IKC=IKX
      ICHEK=ICHEK+1
      IYC=IY
C
C    ( PRINT SPACING CONTROL )
C
  241 PI=IP*SJP
      IF (SX-PI)  304,501,501
  501 IP=IP+1
      MF=DSQRT(HX*HX+YX(2)*YX(2))
      XWIDTH=YX(1)*YX(1)/(DSQRT(PAI)*MF*SPACJ)*2.
      DENDIF=SQRLAM*DENR*YX(3)/YX(1)
      TDIF=SQRLAM*TR*YX(4)/YX(1)
      DILU=YX(1)/VOLFJ
      IF (DENDIF) 402, 906,906
  402 CONST=0.5*DSQRT(PAI*0.5)
      DENDIF=CONST*DENDIF
      TDIF=CONST*TDIF
      GO TO 906
 204  HT = YX(6) + PBHGT
      DILU = YX(1)/VOLFJ
      PGAMMA = DILU - 1.0
      RETURN
      END
      SUBROUTINE RUNGS
      INCLUDE 'odu_com.f'  
C
C*********************************************************************
C
C S U B R O U T I N E  R U N G S                           NUMBER 11
C
C*********************************************************************
      DIMENSION W1(7),W2(7),W3(7),W4(7)
      IF (LX) 5,5,1
    1 DO 2 I=1,6
        W1(I)=DSX*YPX(I)
        YX(I)=YX(I)+(W1(I)*.5)
    2 CONTINUE
      CALL DERIVE
      DO 3 I=1,6
        W2(I)=DSX*YPX(I)
        YX(I)=YX(I)+.5*W2(I)
    3 CONTINUE
      CALL DERIVE
      DO 4 I=1,6
        W3(I)=DSX*YPX(I)
        YX(I)=YX(I)+W3(I)
    4 CONTINUE
      CALL DERIVE
      DO 7 I=1,6
        W4(I)=DSX*YPX(I)
        YX(I)=YX(I)+(((2.*(W2(I)+W3(I)))+W1(I)+W4(I))/6.)
    7 CONTINUE
      CALL DERIVE
      SX=SX+DSX
      GO TO 6
    5 CALL DERIVE
      LX=1
    6 RETURN
      END
      SUBROUTINE DERIVE
      INCLUDE 'odu_com.f'
C
C*********************************************************************
C
C S U B R O U T I N E  D E R I V E                         NUMBER 12
C
C*********************************************************************
C CALLED BY 'RUNGS'
C
      DATA PAI/3.14159265D0/,GRAVAC/1.2714E+08/
C
C     COMPUTATION OF DENSITY AND TEMPERATURE GRADIENTS AT Y
C
  814 IF (YX(6)-YTX(1)) 811,811,812
  812 IF(YX(6)-YTX(NUME)) 806,813,813
  811 EDD=EDX(1)
      ETT=ETX(1)
      GO TO 70
  813 EDD=EDX(NUME-1)
      ETT=ETX(NUME-1)
      GO TO 70
  806 IF (YX(6)-YTX(IKX)) 800,801,802
  801 EDD=(EDX(IKX)+EDX(IKX-1))*0.5
      ETT=(ETX(IKX)+ETX(IKX-1))*0.5
      IKX=IKX+1
      GO TO 70
  800 IKX=IKX-1
      IF(YX(6)-YTX(IKX)) 800,801,805
  805 EDD=EDX(IKX)
      ETT=ETX(IKX)
      IKX=IKX+1
      GO TO 70
  802 IKX=IKX+1
      IF (IKX-NUME) 814,814,807
  807 CONTINUE
      RETURN
   70 IF (IQX) 71,71,72
C
C     ROUND JET SOLUTION
C
   71 ENTRAN=2.*ALPHAR*DSQRT(2.*PAI*MF)
      CLAM=(1.+LAMBDR*LAMBDR)/2.
      GO TO 73
C
C     SLOT JET SOLUTION
C
  72  ENTRAN=2.*DSQRT(2.D0)*ALPHAS*SPACJ*MF/YX(1)
      CLAM=DSQRT((1.+LAMBDS*LAMBDS)/2.)
   73 SQROTM=DSQRT(YX(2)*YX(2)+HX*HX)
      YPX(1)=ENTRAN
      YPX(2)=CLAM*GRAVAC*YX(1)*YX(3)/SQROTM
      YPX(3)=YX(1)*EDD*YX(2)/SQROTM
      YPX(4)=YX(1)*ETT*YX(2)/SQROTM
      YPX(5)=HX/SQROTM
      YPX(6)=YX(2)/SQROTM
      RETURN
      END
         SUBROUTINE WBJET
         INCLUDE 'odu_com.f'
C
C*********************************************************************
C
C  S U B R O U T I N E   W B J E T                         NUMBER 13
C
C*********************************************************************
C**  THIS SUBROUTINE COMPUTES THE ENTRAINMENT OF WEAKLY BUOYANT JETS
C**  IN A STRATIFIED ENVIRONMENT ACCORDING TO THE EXPERIMENTAL RESULTS
C**  OF ROBERTS AND MATTHEWS (1982).
C
      LOGICAL QTOP,QBOTM
C
C**  COMPUTE ENTRAINMENT WIDTH, WE, BOTTOM COORDINATE OF ENTRAINMENT
C**  WIDTH, ZE, CENTER OF GAUSSIAN ENTRAINMENT DISTRIBUTION, ZO, AND
C**  ENTRAINED VOLUME FLUX, MU.
C**  12/13/81.
C
      DATA PI/3.14159/
C
C  COMPUTE STRATIFICATION PARAMETER, E, BY LINEARIZING
C  OVER VERTICAL EXTENT OF JET INFLUENCE.
C
C  NOTE "THETAO" IN DEGREES
C
      LQ=DSQRT(PBAREA)
      LM=MF**(0.75)/DSQRT(DABS(BF))
      DO 10 I=1,NUME
        IF(PBHGT.GE.Z(I+1))GO TO 10
        IJET=I
        GO TO 20
   10 CONTINUE
   20 CONTINUE
      RO0=DENS(IJET)
      JJ=0
    3 EOLD=E
      JJ=JJ+1
      LE=(MF/E)**0.25
      LQLE=LQ/LE
      LMLE=LM/LE
      IF(BF.LT.0.)LMLE=-LMLE
      WE=(1.42+(1.07E-2)*THETAO)*LE
      ZE=(-0.71+(0.82/LMLE)+(2.13E-2+(8.7E-3/LMLE))*THETAO)*LE
      ZE=ZE+PBHGT
      ETOP=DMIN1((ZE+WE),RESEL)
      EBTM=DMAX1(ZE,CHBTM)
      DO 30 I=1,NUME
        IF(EBTM.GT.Z(I+1))GO TO 30
        IMIN=I
        GO TO 40
   30 CONTINUE
   40 CONTINUE
      DO 50 I=1,NUME
        IF(ETOP.GT.Z(I+1))GO TO 50
        IMAX=I
        GO TO 60
   50 CONTINUE
   60 CONTINUE
      A=(DENS(IMAX)-DENS(IMIN))/(Z(IMAX)+SDZ(IMAX)/2.-
     *   Z(IMIN)-SDZ(IMIN)/2.)
      E=-1.2714E+08*A/RO0
      IF(E.LT.0.)E=0.
      IF(JJ.LT.50.AND.DABS((E-EOLD)/E).GT.0.01)GO TO 3
      ETAO=0.8/LMLE+1.3*(THETAO/45.)
      ZO=ETAO*LE
      QOP=1.04-0.04*(THETAO/45.)
      QQO=QOP*DSQRT(MF)
      BBB=0.65+0.05*DABS(2./LMLE)+0.1*(THETAO/45.)
      SIGMA=BBB*LE/DSQRT(2.D0)
      ZO=ZO+PBHGT
      DO 70 I=1,NUME
        IF(ZO.GT.Z(I+1))GO TO 70
        IZO=I
        GO TO 80
   70 CONTINUE
   80 CONTINUE
      SQRT2S = DSQRT(2.D0)*SIGMA
C
C**  COMPUTE ENTRAINED VOLUME FLUX
C
C**  BOTTOM LAYER
C
      QOS = QQO*SIGMA*DSQRT(PI/2.)
      IF (ZE.LT.CHBTM)GO TO 610
      DO 90 I=1,NUME
        IF(ZE.GE.Z(I+1))GO TO 90
        IBTM=I
        GO TO 100
   90 CONTINUE
  100 CONTINUE
      QBOTM = .FALSE.
      A1 = (ZE - ZO)/SQRT2S
      A2 = (Z(IBTM+1)-ZO)/SQRT2S
      QE(IBTM) = QOS*(ERF(A2) - ERF(A1))
      IMIN = IBTM + 1
      GO TO 620
  610 DO 110 I=1,NUME
        IF(CHBTM.GE.Z(I+1))GO TO 110
        ICH=I
        GO TO 120
  110 CONTINUE
  120 CONTINUE
      QBOTM = .TRUE.
      IBTM = ICH
      A1 = (CHBTM - ZO)/SQRT2S
      A2 = (Z(ICH+1) - ZO)/SQRT2S
      QE(ICH) = QOS*(ERF(A2) - ERF(A1))
      IMIN = ICH + 1
  620 CONTINUE
C
C**  TOP LAYER
C
      IF((ZE+WE).GT.RESEL)GO TO 630
      DO 130 I=1,NUME
        IF(ZE+WE.GE.Z(I+1))GO TO 130
        ITOP=I
        GO TO 140
  130 CONTINUE
  140 CONTINUE
      QTOP = .FALSE.
      A1 = (Z(ITOP) - ZO)/SQRT2S
      A2 = (ZE + WE - ZO)/SQRT2S
      QE(ITOP) = QOS*(ERF(A2) - ERF(A1))
      IMAX = ITOP - 1
      GO TO 640
  630 ITOP = NUME
      QTOP = .TRUE.
      A1 = (Z(NUME) - ZO)/SQRT2S
      A2 = (RESEL - ZO)/SQRT2S
      QE(NUME) = QOS*(ERF(A2) - ERF(A1))
      IMAX = NUME - 1
  640 CONTINUE
C
C**  COMPUTE INTERMEDIATE LAYERS
C
      DO 1 I = IMIN,IMAX
         A1 = (Z(I) - ZO)/SQRT2S
         A2 = (Z(I+1) - ZO)/SQRT2S
         QE(I) = QOS*(ERF(A2) - ERF(A1))
   1  CONTINUE
      SUMQE=0.
      DO 2 I=1,NUME
        SUMQE=SUMQE+QE(I)
    2 CONTINUE
      PGAMMA=SUMQE/PBRATE
      RETURN
      END
C
         DOUBLE PRECISION FUNCTION ERF(X)
C
C  APPROXIMATES THE ERROR FUNCTION.
C
         IMPLICIT DOUBLE PRECISION (A-H,O-Z)
         Y=DABS(X)
         IF(Y.GT.2.0)GO TO 10
         IF(Y.GT.1.5)GO TO 20
         IF(Y.GT.1.0)GO TO 30
         ERF=1.1284*(Y-(Y**3./3.)+(Y**5./10.)-
     *       (Y**7./42.))
         GO TO 40
   10    ERF=1.
         GO TO 40
   20    ERF=0.9661+((Y-1.5)/0.5)*0.0339
         GO TO 40
   30    ERF=0.8427+((Y-1.0)/0.5)*0.1234
   40    IF(X.LT.0.)ERF=-ERF
         RETURN
         END
         SUBROUTINE OUTVEL(JUMP)
         INCLUDE 'odu_com.f'
C
C*********************************************************************
C
C   S U B R O U T I N E  O U T V E L ( J U M P )           NUMBER 14
C
C*********************************************************************
C  DETERMINES SELECTION OF PORT OR WEIR OUTFLOW
C
         DIMENSION VEL(70),WQSUM(3),VS(70,9)
         LOGICAL QPWEIR
         IF(JUMP.EQ.2)GO TO 400
C
C  INITIALIZE THE TOTAL VELOCITY PROFILE
C
         LB=NOUTS+1
         DO 100 I=1,NUME
           VEL(I)=0.
           DO 99 J=1,LB
  99       VS(I,J)=0.
 100     CONTINUE
C
C  DETERMINE TYPE OF WITHDRAWAL
C
         SUMOUT=0.
         IF(QPORT)GO TO 110
         IF(QWEIR)GO TO 140
C
C  SELECTIVE WITHDRAWAL FOR ORIFICE FLOW
C
 110     CONTINUE
         KK=NOUTS
         IF(.NOT.QSPEC)KK=NOUTS+1
         DO 130 K=1,KK
           QPWEIR=.FALSE.
           FLORAT=QOT(K)
           HINTER = 180. / WANGLE(K)
           SUMOUT=SUMOUT+FLORAT
           IF(FLORAT.LE.0.)GO TO 130
           VDIM=PVDIM(K)
           HDIM=PHDIM(K)
           HGTPRT=ELOUT(K)
           LAYPRT=NOUT(K)
           DENPRT=DENS(LAYPRT)
           IF(HGTPRT.GE.RESEL)WRITE(MoomawOut,3000)
 3000      FORMAT(' WATER SURFACE BELOW PORT-OUTVEL')
           IF(HGTPRT.GE.RESEL)STOP 2000
C
C  CHECK FOR PARTIALLY SUBMERGED PORT
C
           FLODEP=RESEL-HGTPRT+VDIM/2.
           IF(VDIM.LE.FLODEP)GO TO 115
           VW=FLORAT/(FLODEP*HDIM)
           VHL=(VW*FLODEP**.5)/HDIM
           IF(VHL.GT.0.5)GO TO 115
C
C  TREAT AS WEIR
C
           QPWEIR=.TRUE.
           QSUB=.TRUE.
           WLNGTH=HDIM
           CREST=HGTPRT-VDIM/2.
           DO 112 I=1,NUME
             IF(CREST.GT.Z(I+1))GO TO 112
             LCRST=I
             GO TO 113
 112       CONTINUE
 113       CONTINUE
           CALL VWEIR
           GO TO 116
 115       CONTINUE
           CALL VPORT(HINTER)
 116       CONTINUE
           DO 120 I=1,NUME
             VS(I,K)=V(I)
 120       CONTINUE
 130     CONTINUE
C
C  SELECTIVE WITHDRAWAL FOR WEIR FLOW
C
 140     CONTINUE
         IF(.NOT.QWEIR)GO TO 160
         FLORAT=WRFLOW
         SUMOUT=SUMOUT+FLORAT
         IF(FLORAT.LE.0.)GO TO 160
         WLNGTH=WRLNG
         CREST=WRHGT
         CALL VWEIR
         DO 150 I=1,NUME
           VS(I,NOUTS+1)=V(I)
 150     CONTINUE
 160     CONTINUE
C
C  DETERMINE TOTAL OUTFLOW VELOCITY DISTRIBUTION
C
         DO 180 I=1,NUME
            DO 170 J=1,KK
             VEL(I)=VEL(I)+VS(I,J)
 170       CONTINUE
         IF(QWEIR)VEL(I)=VEL(I)+VS(I,NOUTS+1)
 180     CONTINUE
C
C  SCALE THE WITHDRAWAL TO SATISFY CONTINUITY
C
         QO=0.
         SUM=0.
         DO 190 I=1,NUME
           QHO(I)=VEL(I)*SDZ(I)
           SUM=SUM+QHO(I)
 190     CONTINUE
         IF(SUM.LE.0.)GO TO 334
         SCALE=SUMOUT/SUM
         DO 200 I=1,NUME
           QHO(I)=QHO(I)*SCALE
           QO=QO+QHO(I)
 200     CONTINUE
C
C  ADJUST OUTFLOW BASED ON LAYER VOLUMES
C
         DO 209 I=1,NUME
           IF(DVOL(I).GE.QHO(I)*DBLE(NHOI))GO TO 209
           IF(I.EQ.NUME)GO TO 209
           XTRA=QHO(I)*DBLE(NHOI)-DVOL(I)
           QHO(I)=DVOL(I)/DBLE(NHOI)
           QHO(I+1)=QHO(I+1)+XTRA/DBLE(NHOI)
 209     CONTINUE
 334     RETURN
C
C  WITHDRAW FLOW FROM LAYERS
C    
 400     DO 300 J=1,3
           EQ5(J)=0.
           WQSUM(J)=0.
 300     CONTINUE
C
C  SUM FLOW-WEIGHTED OUTFLOW WATER QUALITIES PRIOR TO AVERAGING
C
         SUMF=0
         DO 310 I=1,NUME
         FLOW=QHO(I)
         SUMF=SUMF+FLOW 
           DO 320 J=1,3
             WQSUM(J)=WQSUM(J)+EQ1(I,J)*FLOW
 320       CONTINUE
 310     CONTINUE
C 
C   CALCULATE AVERAGE RELEASE QUALITIES
C   IF TOTAL OUTFLOW EQUALS ZERO, SET QUALITIES TO ZERO
C 
         IF(SUMF.LE.0.)GO TO 335
C 
C   CALCULATE AVERAGE RELEASE WATER QUALITIES
C 
         DO 330 I=1,3
           EQ5(I)=WQSUM(I)/SUMF
 330     CONTINUE
         GO TO 340
 335     DO 338 I=1,3
           EQ5(I)=0.
 338     CONTINUE
 340     CONTINUE
         RETURN
         END
         SUBROUTINE VPORT(HINTER)
C
C*********************************************************************
C
C   S U B R O U T I N E   V P O R T                        NUMBER 15
C
C*********************************************************************
C  CALCULATE WITHDRAWAL LIMITS
C  AND VELOCITY PROFILE FOR ORIFICE
C
         INCLUDE 'odu_com.f'
         LOGICAL Q1,Q2,Q3,QBLIM,QTLIM
         INTEGER XXX
         DATA MAX,VMAX,G/10,1.,1.2714E+08/
         DATA RHOCRI/0.0001/
         DATA SMALL /1.0E-8/
         DATA PI / 3.14159 /
C
C  FUNCTION STATEMENTS TO SOLVE
C  FOR ORIFICE WITHDRAWAL LIMITS
C
         FROUD(I)=SQRT(G*ABS(1.-DENS(I)/DENPRT))
         FPORT(I)=FLORAT*HINTER-FROUD(I)*THICK**2.5
         BFREQ(I)=SQRT(G*ABS((1.-DENS(I)/DENPRT)/(ZELE-HGTPRT+SMALL)))
         QSMITH(I)=FLORAT*HINTER-VINTER*BFREQ(I)*DPRIME**3.0
C-----------------------------------------------
         A1=1.0
C
C  CHECK FOR INTERFERENCE
C  FROM SURFACE OR BOTTOM
C
C
C  Determine Upper boudary interference.
C
           THICK = HGTPRT - Z(1)
C
           ZELE = Z(1)
           DPRIME = RESEL - Z(1)
           BTHICK = RESEL - HGTPRT
           BDRATIO = ( BTHICK / DPRIME ) / ( 1. - BTHICK / DPRIME ) 
           VINTER  =(0.5+0.5/PI*SIN(BDRATIO*PI)+0.5*BDRATIO)      
     &    / ( 1.+BDRATIO ) ** 3
C
         IF ( FPORT(1) .GE. 0.0 ) THEN
          QBLIM = .TRUE.
         ELSE IF ( QSMITH(1) .GE. 0.0 ) THEN
          QBLIM = .TRUE.
         ELSE
          QBLIM = .FALSE.
         END IF
C
C  Determine lower boudary interference.
C
           THICK = RESEL - HGTPRT
C
           ZELE = Z(NUME+1)
           DPRIME=Z(NUME+1)
           BTHICK=HGTPRT
           BDRATIO = ( BTHICK / DPRIME ) / ( 1. - BTHICK / DPRIME ) 
           VINTER  =(0.5+0.5/PI*SIN(BDRATIO*PI)+0.5*BDRATIO)      
     &    / ( 1.+BDRATIO ) ** 3
C
         IF ( FPORT(NUME) .GE. 0.0 ) THEN
          QTLIM = .TRUE.
         ELSE IF ( QSMITH(NUME) .GE. 0.0 ) THEN
          QTLIM = .TRUE.
         ELSE
          QTLIM = .FALSE.
         END IF

C
C  EMBARK ON DETERMINATION OF
C  LOWER WITHDRAWAL LIMIT
C
C
C  DETERMINE ELEVATION, LAYER, FUNCTION VALUE,
C  AND FUNCTION SIGN AT EACH SEARCH LIMIT
C  (1) BOTTOM OF POOL AND (2) PORT ELEVATION
C
         IF ( QTLIM .AND. .NOT. QBLIM ) THEN
C
C  Use the modified densimetric froude number relationship from Smith et. al.
C  in the determination of a free bottom withdrawal limit with surface interference.
C 
         DO I=LAYPRT,1,-1
C
           ZELE = Z(I)
           DPRIME=RESEL-Z(I)
           BTHICK=RESEL-HGTPRT
           BDRATIO = ( BTHICK / DPRIME ) / ( 1. - BTHICK / DPRIME ) 
           VINTER  =(0.5+0.5/PI*SIN(BDRATIO*PI)+0.5*BDRATIO)      
     &    / ( 1.+BDRATIO ) ** 3
C
          IF ( QSMITH(I) .LE. 0 ) THEN
C
           HGTLOW = Z(I)
           LOWLIM = I
           DENLOW = DENS(LOWLIM)
           GO TO 140
C
          END IF
C
         END DO
C
C  Use the densimetric froude number relationship from Bohan and Grace
C  in the determination of the bottom withdrawal limit.
C
         ELSE
C
         DO I=LAYPRT,1,-1
C
           THICK=HGTPRT-Z(I)
C
          IF ( FPORT(I) .LE. 0 ) THEN
C
           HGTLOW = Z(I)
           LOWLIM = I
           DENLOW = DENS(LOWLIM)
           GO TO 140
C
          END IF
C
         END DO
C
C  Boundary Interference.
C  Determine the phantom withdrawal limit.
C
           HGTLOW = HGTPRT - (FLORAT*HINTER/(FROUD(1)+SMALL))**0.4
           LOWLIM = 1
           DENLOW = DENPRT-(HGTPRT-HGTLOW)/(HGTPRT+SMALL)*
     &              (DENPRT-DENS(1))
C
 140     CONTINUE
c
         END IF
C
C  End of the determination of the bottom withdrawal limit.
C
C 
C
C
C  APPLY SAME PROCEDURE FOR DETERMINING
C  UPPER WITHDRAWAL LIMIT FOR ORIFICE
C
C
C  DETERMINE ELEVATION, LAYER, AND FUNCTION SIGN AT SEARCH
C  LIMITS - (1) ORIFICE ELEVATION AND (2) SURFACE
C
        IF ( QBLIM .AND. .NOT. QTLIM ) THEN
C
C  Use the modified densimetric froude number relationship from Smith et. al.
C  in the determination of a free upper withdrawal limit with bottom interference.
C 
C
         DO I=LAYPRT,NUME
C
           ZELE = Z(I+1)
           DPRIME=Z(I+1)
           BTHICK=HGTPRT
           BDRATIO = ( BTHICK / DPRIME ) / ( 1. - BTHICK / DPRIME ) 
           VINTER  =(0.5+0.5/PI*SIN(BDRATIO*PI)+0.5*BDRATIO)      
     &    / ( 1.+BDRATIO ) ** 3
C
          IF ( QSMITH(I) .LE. 0 ) THEN
           HGTTOP = Z(I+1)
           TOPLIM = I
           DENTOP = DENS(TOPLIM)
           GO TO 150
          END IF
         END DO
C
C  Use the densimetric froude number relationship from Bohan and Grace
C  in the determination of the bottom withdrawal limit.
C
         else
C
         DO I=LAYPRT,NUME
           THICK=Z(I+1)-HGTPRT
          IF ( FPORT(I) .LE. 0 ) THEN
           HGTTOP = Z(I+1)
           TOPLIM = I
           DENTOP = DENS(TOPLIM)
           GO TO 150
          END IF
         END DO
C
C  Boundary Interference.
C  Determine the phantom withdrawal limit.
C
           HGTTOP = HGTPRT + (FLORAT*HINTER/(FROUD(NUME)+SMALL))**0.4
           TOPLIM = NUME
           DENTOP = DENPRT+(HGTTOP-HGTPRT)/(RESEL-HGTPRT+SMALL)*
     &              (DENS(NUME)-DENPRT)
C
C

 150       CONTINUE
C
C  End of the determination of the bottom withdrawal limit.
c
           END IF
C
C  CALCULATE LOCATION OF MAXIMUM VELOCITY
C  AND THICKNESS OF WITHDRAWAL LIMITS
C
         ZONE=HGTTOP-HGTLOW
         ZTOP=HGTTOP-HGTPRT
         ZLOW=HGTPRT-HGTLOW
         YVMAX=ZONE*SIN(1.57*ZLOW/ZONE)**2.
C
         IF (YVMAX+HGTLOW .LT. 0.0 ) THEN
          LVMAX = 1
          ZVMAX = 0.0
         ELSE IF (YVMAX+HGTLOW .GT. RESEL ) THEN
          LVMAX = NUME
          ZVMAX = RESEL
         ELSE
C
          DO 70 I=1,NUME
           IF(YVMAX+HGTLOW.GT.Z(I+1))GO TO 70
           LVMAX=I
           ZVMAX = YVMAX+HGTLOW
           GO TO 71
 70       CONTINUE
C
         END IF
C
 71      CONTINUE


         DVMAX=DENS(LVMAX)
C
C  ZERO THE VELOCITY PROFILE
C  FOR THE CURRENT PORT
C
         DO 190 I=1,NUME
           V(I)=0.
 190     CONTINUE
C
C  IF LOWER WITHDRAWAL LAYERS ARE OF
C  OF CONSTANT DENSITY THEN ASSIGN
C  CONSTANT VELOCITY TO EACH LAYER
C
         DENDIF=DENLOW-DVMAX
         IF(DENDIF.GT.RHOCRI)GO TO 210
         DO 200 I=LOWLIM,LVMAX
           V(I)=VMAX
 200     CONTINUE
         GO TO 240
 210     CONTINUE
C
C  CALCULATE VELOCITY PROFILE FROM LAYER
C  OF MAXIMUM VELOCITY TO LOWER LIMIT
C
         YLOW=ZVMAX-HGTLOW
         IF(LOWLIM.EQ.LVMAX)GO TO 240
         DO 230 I=LOWLIM,LVMAX
	   Y = ZVMAX - Z(I)
           DELDEN = DENS(I) - DVMAX
           RATIO = Y * DELDEN / (YLOW * DENDIF + small)
           V(I) = VMAX*(1.-RATIO)**2.0

 230     CONTINUE
 240     CONTINUE

C
C  IF UPPER WITHDRAWAL LAYERS ARE
C  OF CONSTANT DENSITY THEN ASSIGN
C  CONSTANT VELOCITY TO EACH LAYER
C
         DENDIF=DVMAX-DENTOP
         IF(DENDIF.GT.RHOCRI)GO TO 260
         DO 250 I=LVMAX,TOPLIM
           V(I)=VMAX
 250     CONTINUE
         GO TO 300
 260     CONTINUE
C
C  DETERMINE VELOCITY PROFILE FROM LAYER
C  OF MAXIMUM VELOCITY TO UPPER LIMIT
C
         YTOP=HGTTOP-ZVMAX
         IF(LVMAX.EQ.TOPLIM)GO TO 300
         DO 280 I=LVMAX,TOPLIM
C
	   Y = Z(I) - ZVMAX
           DELDEN = DVMAX - DENS(I) 
           RATIO = Y * DELDEN / (YTOP * DENDIF + small)
           V(I) = VMAX*(1.-RATIO)**2.0
C
 280     CONTINUE
 300     CONTINUE
C
C  COMPUTE THE ACTUAL WITHDRAWAL VELOCITIES
C  RATHER THAN THE RELATIVE VELOCITIES
C
         SUM=0.
         DO 310 I=LOWLIM,TOPLIM
           IF(V(I).LE.0.)V(I)=0.
           IF(LOWLIM.EQ.TOPLIM)V(I)=VMAX
           SUM=SUM+V(I)*SDZ(I)
 310     CONTINUE
         DO 320 I=LOWLIM,TOPLIM
           V(I)=V(I)*FLORAT/(SUM+small)
 320     CONTINUE
         RETURN
         END
         SUBROUTINE VWEIR
         INCLUDE 'odu_com.f'
C
C*********************************************************************
C
C   S U B R O U T I N E   V W E I R                        NUMBER 16
C
C*********************************************************************
C  CALCULATE WITHDRAWAL LIMITS AND
C  VELOCITY PROFILE FOR WEIR FLOW.
C  NOTE-SITE SPECIFIC CONDITIONS MAY REQUIRE
C  WEIR LENGTH TO BE VARIABLE.
C
         LOGICAL QBLIM,QTLIM,Q1,Q2,Q3,QZ
         INTEGER XXX
         DATA A,B,G/4.35,-1.04,1.2714E+08/
         DATA VMAX,ITMAX/1.,10/
         DATA XSMALL/1.E-05/
         DATA RHOCRI/0.02/
C
C  FUNCTION STATEMENTS TO SOLVE
C  FOR LOWER WITHDRAWALS LIMIT
C
         RWEIR(Z)=DSQRT(Z+HEAD)*(1.+Z/HEAD)
         R2WEIR(Z)=DSQRT(Z+HEAD)
         FWEIR(I)=AVGVEL-C*RWEIR(SIZE)
     *            *DSQRT(G*DABS(1.-DENS(I)/WRDEN))
     *            +D*R2WEIR(SIZE)*
     *            DSQRT(G*DABS(1.-DENS(I)/WRDEN))
         EXPNT=A+B*COEF
         IF(DABS(COEF-3.00).LT..01)EXPNT=1.5
         IF(DABS(COEF-3.33).LT..01)EXPNT=0.5
         IF(DABS(COEF-4.10).LT..01)EXPNT=0.2
         C=.54
         D=0.
         QZ=.FALSE.
C
C  CALCULATE AVERAGE VELOCITY
C  OVER THE WEIR 
C
         VMAX=1.
         HEAD=RESEL-CREST
         IF(HEAD.LE.0.)WRITE(MoomawOut,3000)
 3000    FORMAT(' S/R VWEIR-SURFACE BELOW CREST')
         IF(HEAD.LE.0.)STOP
         AVGVEL=FLORAT/(HEAD*WLNGTH)
C
C  CHECK FOR INTERFERENCE FROM
C  BOTTOM. SURFACE WILL EXHIBIT
C  INTERFERENCE.
C
  90     CONTINUE
         DO 95 I=1,NUME
           IF(CREST.GT.Z(I+1))GO TO 95
           LCRST=I
           GO TO 96
  95     CONTINUE
  96     CONTINUE
         WRDEN=DENS(LCRST)
         SIZE=0.
         IF(LCRST.LT.2)GO TO 11
         DO 10 I=2,LCRST
           SIZE=SIZE+SDZ(I)
  10     CONTINUE
  11     CONTINUE
         QBLIM=FWEIR(1).GE.0.
         QTLIM=.TRUE.
C
C  EMBARK ON DETERMINATION OF
C  LOWER WITHDRAWAL LIMIT
C
         IF(.NOT.QBLIM)GO TO 100
C
C  IF BOTTOM INTERFERENCE EXISTS THEN
C  SET LOWER LIMIT AT THE BOTTOM
C
         HGTLOW=0.
         LOWLIM=1
         GO TO 140
 100     CONTINUE
C
C  IF LOWER LIMIT IS WITHIN THE POOL THEN
C  FIND IT WITH A HALF-INTERVAL SEARCH
C
C  DETERMINE ELEVATION, LAYER, FUNCTION VALUE,
C  AND FUNCTION SIGN AT EACH SEARCH LIMIT
C  (1) BOTTOM OF POOL AND (2) WEIR ELEVATION
C
         X1=0.
         L1=1
         SIZE=0.
         IF(LCRST.LT.2)GO TO 31
         DO 30 I=2,LCRST
           SIZE=SIZE+SDZ(I)
  30     CONTINUE
  31     CONTINUE
         F1=FWEIR(L1)
         Q1=F1.GT.0.
         X2=CREST
         L2=LCRST
         F2=AVGVEL
         Q2=F2.GT.0. 
C
C  FUNCTION MUST BE POSITIVE AT THE WEIR
C  LEVEL AND NEGATIVE AT THE BOTTOM
C
         IF(Q1.OR..NOT.Q2)WRITE(MoomawOut,3010)
 3010    FORMAT(' STOP IN VWEIR')
         IF(Q1.OR..NOT.Q2)STOP
C
C  INITIATE ITERATION PROCESS
C
         DO 120 I=1,ITMAX
C
C  ESTABLISH A THIRD POINT BETWEEN
C  THE TWO EXISTING POINTS
C
           X3=(X1+X2)/2.
           DO 40 J=1,NUME
             IF(X3.GT.Z(J+1))GO TO 40
             L3=J
             GO TO 41
  40       CONTINUE
  41       CONTINUE
C
C  CALCULATE FUNCTION SIGN AT NEW ELEVATION
C
           SIZE=0.
           IF(LCRST.EQ.L3)GO TO 51
           IF(LCRST.GT.L3)JJ1=L3+1
           IF(LCRST.GT.L3)JJ2=LCRST
           IF(LCRST.LT.L3)JJ1=LCRST
           IF(LCRST.LT.L3)JJ2=L3-1
           DO 50 J=JJ1,JJ2
             SIZE=SIZE+SDZ(J)
  50       CONTINUE
  51       CONTINUE
           F3=FWEIR(L3)
           Q3=F3.GT.0.
C
C  IF NEW POINT IS THE SAME AS A PREVIOUS
C  POINT THEN SEARCH IS COMPLETE
C
           IF(L3.EQ.L1.OR.L3.EQ.L2)GO TO 130
C
C  USE AS NEW SEARCH LIMITS THE MOST
C  RECENTLY COMPUTED POINT AND THE
C  REMAINING POINT OF OPPOSITE SIGN
C
           IF((Q1.AND.Q3).OR..NOT.(Q1.OR.Q3))GO TO 110
           X2=X3
           L2=L3
           Q2=Q3
           GO TO 120
 110       CONTINUE
           X1=X3
           L1=L3
           Q1=Q3 
 120     CONTINUE
C
C  CONVERGENCE HAS NOT BEEN REACHED 
C
         WRITE(MoomawOut,3020)
 3020    FORMAT(' STOP VWEIR')
         STOP 
 130     CONTINUE
C
C  CHECK FOR (Z+H)/H LESS THAN 2.0
C
         IF(QZ)GO TO 136
         ZLOW=CREST-X3
         XCHECK=(ZLOW + HEAD)/HEAD
         IF(XCHECK.GE.2.0)GO TO 135
         C=.78
         D=.70
         QZ=.TRUE.
         GO TO 90
 135     CONTINUE
 136     CONTINUE
C
C  SET LOWER LIMIT ELEVATION AND LAYER
C
         HGTLOW=X3
         LOWLIM=L3
 140     CONTINUE
C
C  SET UPPER LIMIT AT SURFACE
C
         HGTTOP=RESEL
         TOPLIM=NUME
C
C  CALCULATE LOCATION OF MAXIMUM VELOCITY
C
         ZONE=HGTTOP-HGTLOW
         ZLOW=CREST-HGTLOW
         IF(.NOT.QSUB)YVMAX=ZONE
         IF(QSUB)YVMAX=ZONE*DSIN(1.57*ZLOW/ZONE)**2.
C
C  COMPUTE THICKNESS OF WITHDRAWAL ZONE
C
         DO 70 I=1,NUME
           IF(YVMAX+HGTLOW.GT.Z(I+1))GO TO 70
           LVMAX=I
           GO TO 71
  70     CONTINUE
  71     CONTINUE
         IF(.NOT.QSUB)LVMAX=NUME
         DVMAX=DENS(LVMAX)
         YLOW=0.
         IF(LVMAX.EQ.LOWLIM)GO TO 81
         J=LOWLIM+1
         DO 80 I=J,LVMAX
           YLOW=YLOW+SDZ(I)
  80     CONTINUE
  81     CONTINUE
         YTOP=0.
         IF(TOPLIM.EQ.LVMAX)GO TO 91
         J=LVMAX+1
         DO 92 I=J,TOPLIM
           YTOP=YTOP+SDZ(I)
  92     CONTINUE
  91     CONTINUE
         DENLOW=DENS(LOWLIM)
         DENTOP=DENS(TOPLIM)
C
C  CALCULATE MAXIMUM VELOCITY
C
         VMAX=1.
C
C  ZERO THE VELOCITY PROFILE
C  FOR THE CURRENT WEIR
C
         DO 150 I=1,NUME
           V(I)=0.
 150     CONTINUE
C
C  IF LOWER WITHDRAWAL LAYERS ARE OF
C  CONSTANT DENSITY THEN ASSIGN
C  CONSTANT VELOCITY TO EACH LAYER
C
         IF(LVMAX.EQ.LOWLIM)GO TO 200
         DENDIF=DENLOW-DVMAX
         IF(DENDIF.GT.RHOCRI)GO TO 170
         DO 160 I=LOWLIM,LVMAX
           V(I)=VMAX
 160     CONTINUE
         GO TO 200
 170     CONTINUE
C
C  CALCULATE VELOCITY PROFILE FROM LAYER
C  OF MAXIMUM VELOCITY TO LOWER LIMIT
C
         DO 190 I=LOWLIM,LVMAX
           Y=0.
           IF(LVMAX.EQ.I)GO TO 176
           L=I+1
           DO 175 J=L,LVMAX
             Y=Y+SDZ(J)
 175       CONTINUE
 176       CONTINUE
           DELDEN=DENS(I)-DVMAX
           RATIO=Y*DELDEN/(YLOW*DENDIF)
           RATIO=DMIN1(1.D0,RATIO)
           IF(QBLIM)GO TO 180
           P=3.0
           IF(QSUB) V(I)=VMAX*(1.-RATIO)**P
           IF(.NOT.QSUB) V(I)=VMAX*(1.-RATIO**EXPNT)
           GO TO 190
 180       CONTINUE
           V(I)=VMAX*(1.-RATIO**2.)
 190     CONTINUE
 200     CONTINUE
C
C  IF UPPER WITHDRAWAL LAYERS ARE
C  OF CONSTANT DENSITY THEN ASSIGN
C  CONSTANT VELOCITY TO EACH LAYER
C
         IF(.NOT.QSUB)GO TO 260
         IF(LVMAX.EQ.TOPLIM)GO TO 260
         DENDIF=DVMAX-DENTOP
         IF(DENDIF.GT.RHOCRI)GO TO 220
         DO 210 I=LVMAX,TOPLIM
           V(I)=VMAX
 210     CONTINUE
         GO TO 250
 220     CONTINUE
C
C  DETERMINE VELOCITY PROFILE FROM LAYER
C  OF MAXIMUM VELOCITY TO UPPER LIMIT
C
 246     DO 240 I=LVMAX,TOPLIM
           Y=0.
           IF(LVMAX.EQ.I)GO TO 226
           L=LVMAX+1
           DO 225 J=L,I
             Y=Y+SDZ(J)
 225       CONTINUE
 226       CONTINUE
           DELDEN=DVMAX-DENS(I)
           RATIO=Y*DELDEN/(YTOP*DENDIF)
           RATIO=DMIN1(1.D0,RATIO)
           IF(QTLIM)GO TO 230
           V(I)=VMAX*(1.-RATIO)**2.
           GO TO 240
 230       CONTINUE
           V(I)=VMAX*(1.-RATIO**2.)
 240     CONTINUE
C
C  ENSURE SURFACE WITHDRAWAL FROM SUBMERGED WEIR
C
         IF(QSUB.AND.V(NUME).LE.0.)GO TO 245
         GO TO 250
 245     YTOP=YTOP+0.5
         GO TO 246         
 250     CONTINUE
 260     CONTINUE
C
C  COMPUTE THE ACTUAL WITHDRAWAL VELOCITIES
C  RATHER THAN THE RELATIVE VELOCITIES
C
         SUM=0.
         DO 270 I=LOWLIM,TOPLIM
           IF(V(I).LE.0.)V(I)=0.
           IF(LOWLIM.EQ.TOPLIM)V(I)=VMAX
           SUM=SUM+V(I)*SDZ(I)
 270     CONTINUE
         DO 280 I=LOWLIM,TOPLIM
           V(I)=V(I)*FLORAT/SUM
 280     CONTINUE
         RETURN
         END
         SUBROUTINE LAYERS(NZ)
         INCLUDE 'odu_com.f'
C
C*********************************************************************
C
C     S U B R O U T I N E   L A Y E R S ( NZ )             NUMBER 17
C
C*********************************************************************
C  RESIZES AND RENUMBERS LAYERS ACCORDING TO GEOMETRIC REQUIREMENTS
C  OF WATER BUDGET.  AS NECESSARY COMPUTES NEW LAYER INTERFACE
C  AREAS,ELEVATIONS, AND NEW LAYER VOLUMES,WIDTHS,AND THICKNESSES
C
         DIMENSION EQ1A(3),EQ1B(3),EQ2A(3),EQ2B(3),EQ3A(3),EQ3B(3)
         DIMENSION EQ1AB(3),EQ2AB(3),EQ3AB(3)
C
C         1. RESIZE LAYERS ACCORDING TO WATER BALANCE.
C            SCHEDULE FOR FULL AND PARTIAL WATER BALANCES--
C               NZ=1  CONTINUOUS INFLOW AND OUTFLOW
C               NZ=2  CONTINUOUS INFLOW,SCHEDULED GENERATION
C                    OUTFLOW AND PUMPBACK (PLUS ENTRAINED FLOW)
C
         DO 10 I=1,NUME
C
C         COMPUTE VOLUME INCREMENT. IF NEGATIVE CHECK AGAINST
C         AVAILABLE LAYER VOLUME
C         NOTE THAT ALL LAYERS MUST BE EXAMINED
C         EVEN WHEN VOLUME INCREMENT IS ZERO
C
           IF(NZ.EQ.1)VOLINC=(QHI(I)-QHO(I))*DBLE(NHOI)
           IF(NZ.EQ.2)VOLINC=QHI(I)*DBLE(NHOI)-SUMFLO(I)
     *                     -PBENTR(I)
           IF(NZ.EQ.2.AND.I.EQ.PBLAYR)VOLINC=VOLINC+PBFLOW
           IF(I.EQ.NUME)VOLINC=VOLINC-EV*AREA(NUME+1)*DBLE(NHOI)
C
C         LAYER COLLAPSES. REMOVE WATER FROM NEXT HIGHER LAYER
C                 LOOP CORRECTION DH-T 8-23-89
C
           IF(-VOLINC.GT.DVOL(I))THEN
             IF(I.EQ.NUME)GO TO 41
             DVOL(I+1)=DVOL(I+1)-(-VOLINC-DVOL(I))
             Z(I+1)=Z(I)
             GO TO 40
           ENDIF 
C
C         LAYER REMAINS INTACT. DETERMINE GEOMETRIC ATTRIBUTES
C
           VOLUME=VOL(I)+DVOL(I)+VOLINC
           ZI=Z(I)
           Z(I+1)=ZFN(NCURV,VOLUME,ZI,ACOEF)
   40      SDZ(I)=Z(I+1)-Z(I)
           WIDTH(I)=WFN(Z(I)+SDZ(I)/2.,WCOEF)
           AREA(I+1)=AFN(NCURV,Z(I+1),ACOEF)
           VOL(I+1)=VFN(NCURV,Z(I+1),ACOEF)
           DVOL(I)=VOL(I+1)-VOL(I)
   10    CONTINUE
         GO TO 50
C
C         TOP LAYER COLLAPSES. REMOVE WATER FROM NEXT LOWER LAYER
C
   41    DO 210 K=1,NUME
           J=NUME-K+1
           IF(J.EQ.1)WRITE(MoomawOut,3000)
 3000      FORMAT(' S/R LAYERS-RESERVOIR AT ONE LAYER')
           IF(J.EQ.1)STOP
           IF(-VOLINC.GT.DVOL(J))GO TO 195
           GO TO 250
  195      VOLINC=DVOL(J)+VOLINC
           DVOL(J)=0.
           N=J+1
           M=NUME+1
           DO 205 L=N,M
             Z(L)=Z(J)
  205      CONTINUE
  210    CONTINUE
  250    DVOL(J)=DVOL(J)+VOLINC
C
C         REDEFINE GEOMETRIC ATTRIBUTES FOLLOWING SURFACE WITHDRAWAL
C
         DO 230 M=1,NUME
           VOLUME=VOL(M)+DVOL(M)
           ZI=Z(I)
           Z(M+1)=ZFN(NCURV,VOLUME,ZI,ACOEF)
           SDZ(M)=Z(M+1)-Z(M)
           WIDTH(M)=WFN(Z(M)+SDZ(M)/2.,WCOEF)
           AREA(M+1)=AFN(NCURV,Z(M+1),ACOEF)
           VOL(M+1)=VFN(NCURV,Z(M+1),ACOEF)
           DVOL(M)=VOL(M+1)-VOL(M)
  230    CONTINUE
C
C         DETERMINE RESERVOIR ELEVATION
C
   50    RESEL=0.
         DO 60 I=1,NUME
           RESEL=RESEL+SDZ(I)
   60    CONTINUE
C
C         2. SCAN RESIZED LAYERS TO FIND THOSE WHOSE THICKNESS IS
C         TOO SMALL. MERGE WITH NEXT HIGHER LAYER
C
   71    J=NUME-1
         DO 70 I=1,J
           IF(SDZ(I).LT.SDZMIN)GO TO 75
   70    CONTINUE
         GO TO 72
C
C         DEFINE ATTRIBUTES OF LAYERS 'A' AND 'B' TO BE MERGED LATER.
C         LAYER 'A' IS THE ONE WHOSE THICKNESS IS TOO SMALL:
C         LAYER 'B' IS THE NEXT HIGHER LAYER
C
   75    DO 77 J=1,3
           EQ1A(J)=EQ1(I,J)
           EQ1B(J)=EQ1(I+1,J)
           EQ2A(J)=EQ2(I,J)
           EQ2B(J)=EQ2(I+1,J)
   77    CONTINUE
         SDZA=SDZ(I)
         SDZB=SDZ(I+1)
         DVOLA=DVOL(I)
         DVOLB=DVOL(I+1)
         QHOA=QHO(I)
         QHOB=QHO(I+1)
         QHIA=QHI(I)
         QHIB=QHI(I+1)
         PBENTA=PBENTR(I)
         PBENTB=PBENTR(I+1)
         SUMFLA=SUMFLO(I)
         SUMFLB=SUMFLO(I+1)
         DO 78 J=1,3
           EQ3A(J)=EQ3(I,J)
           EQ3B(J)=EQ3(I+1,J)
   78    CONTINUE
C
C         PRIOR TO MERGING LAYERS 'A' AND 'B', RENUMBER
C         HIGHER LAYERS (ORDER IMPORTANT)
C
         IF(I.EQ.NUME-1)AREA(I+1)=AREA(I+2)
         IF(I.EQ.NUME-1)GO TO 76
         L=I+1
         M=NUME-1
         DO 80 J=L,M
           DO 81 K=1,3
             EQ1(J,K)=EQ1(J+1,K)
             EQ2(J,K)=EQ2(J+1,K)
   81      CONTINUE
           QHO(J)=QHO(J+1)
           QHI(J)=QHI(J+1)
           PBENTR(J)=PBENTR(J+1)
           SUMFLO(J)=SUMFLO(J+1)
           DO 82 K=1,3
             EQ3(J,K)=EQ3(J+1,K)
   82      CONTINUE
           SDZ(J)=SDZ(J+1)
           WIDTH(J)=WIDTH(J+1)
           DVOL(J)=DVOL(J+1)
           Z(J)=Z(J+1)
           VOL(J)=VOL(J+1)
           AREA(J)=AREA(J+1)
   80    CONTINUE
         Z(NUME)=Z(NUME+1)
         VOL(NUME)=VOL(NUME+1)
         AREA(NUME)=AREA(NUME+1)
C
C         MERGE LAYERS 'A' AND 'B'. DEFINE ATTRIBUTES
C         NOTE BRANCH IF BOTH LAYERS EMPTY
C
   76    IF(DVOLA+DVOLB.LE.0.)GO TO 200
         DO 83 J=1,3
           EQ1(I,J)=(DVOLA*EQ1A(J)+DVOLB*EQ1B(J))/(DVOLA+DVOLB)
           EQ2(I,J)=(DVOLA*EQ2A(J)+DVOLB*EQ2B(J))/(DVOLA+DVOLB)
   83    CONTINUE
  200    QHO(I)=QHOA+QHOB
         QHI(I)=QHIA+QHIB
         PBENTR(I)=PBENTA+PBENTB
         SUMFLO(I)=SUMFLA+SUMFLB
         DO 84 J=1,3
           EQ3(I,J)=EQ3A(J)+EQ3B(J)
   84    CONTINUE
C
C      CORRECTION FOR SURFACE LAYER MERGING ERROR
C                   BWB 1-17-90
C
         IF(I.EQ.NUME-1)Z(NUME)=Z(NUME+1)
         SDZ(I)=SDZA+SDZB
         WIDTH(I)=WFN(Z(I)+SDZ(I)/2.,WCOEF)
         DVOL(I)=DVOLA+DVOLB
         NUME=NUME-1
         GO TO 71
   72    IF(SDZ(NUME).GE.SDZMIN)GO TO 91
C
C         MERGE SURFACE LAYER WITH NEXT LOWER LAYER
C          RETAIN SURFACE AREA
C
         I=NUME-1
         AREA(I+1)=AREA(I+2)
         GO TO 75
C
C        3. SCAN RESIZED LAYERS TO FIND THOSE WHOSE THICKNESS IS
C        TOO GREAT.  DIVIDE THESE IN HALF
C
   91    DO 90 I=1,NUME
           IF(SDZ(I).GE.SDZMAX)GO TO 95
   90    CONTINUE
         GO TO 92
C
C        DEFINE ATTRIBUTES OF LAYER TO BE HALVED LATER
C
   95    SDZAB=SDZ(I)/2.
         DVOLAB=DVOL(I)
         DO 97 J=1,3
           EQ1AB(J)=EQ1(I,J)
           EQ2AB(J)=EQ2(I,J)
   97    CONTINUE
         QHOAB=QHO(I)
         QHIAB=QHI(I)
         PBENAB=PBENTR(I)
         SUMFAB=SUMFLO(I)
         DO 98 J=1,3
           EQ3AB(J)=EQ3(I,J)
   98    CONTINUE
C
C        PRIOR TO HALVING LAYER, RENUMBER HIGHER LAYERS (ORDER IMPORTANT)
C
         Z(NUME+2)=Z(NUME+1)
         VOL(NUME+2)=VOL(NUME+1)
         AREA(NUME+2)=AREA(NUME+1)
         IF(I.EQ.NUME)GO TO 96
         M=I+1
         DO 110 J=M,NUME
           K=NUME-J+I+1
           DO 99 L=1,3
             EQ1(K+1,L)=EQ1(K,L)
             EQ2(K+1,L)=EQ2(K,L)
   99      CONTINUE
           QHO(K+1)=QHO(K)
           QHI(K+1)=QHI(K)
           PBENTR(K+1)=PBENTR(K)
           SUMFLO(K+1)=SUMFLO(K)
           DO 100 L=1,3
             EQ3(K+1,L)=EQ3(K,L)
  100      CONTINUE
           Z(K+1)=Z(K)
           WIDTH(K+1)=WIDTH(K)
           AREA(K+1)=AREA(K)
           VOL(K+1)=VOL(K)
           DVOL(K+1)=DVOL(K)
           SDZ(K+1)=SDZ(K)
  110    CONTINUE
C
C         DIVIDE LAYER IN HALF: DEFINE ATTRIBUTES
C
   96    SDZ(I)=SDZAB
         SDZ(I+1)=SDZAB
         Z(I+1)=Z(I)+SDZ(I)
         VOL(I+1)=VFN(NCURV,Z(I+1),ACOEF)
         AREA(I+1)=AFN(NCURV,Z(I+1),ACOEF)
         WIDTH(I)=WFN(Z(I)+SDZ(I)/2.,WCOEF)
         WIDTH(I+1)=WFN(Z(I+1)+SDZ(I+1)/2.,WCOEF)
         DVOL(I+1)=DVOLAB-(VOL(I+1)-VOL(I))
         DVOL(I)=VOL(I+1)-VOL(I)
         QHO(I+1)=DVOL(I+1)*QHOAB/(DVOL(I)+DVOL(I+1))
         QHO(I)=DVOL(I)*QHOAB/(DVOL(I)+DVOL(I+1))
         DO 101 J=1,3
           EQ1(I,J)=EQ1AB(J)
           EQ1(I+1,J)=EQ1AB(J)
           EQ2(I,J)=EQ2AB(J)
           EQ2(I+1,J)=EQ2AB(J)
  101    CONTINUE
         QHI(I+1)=DVOL(I+1)*QHIAB/(DVOL(I)+DVOL(I+1))
         QHI(I)=DVOL(I)*QHIAB/(DVOL(I)+DVOL(I+1))
         PBENTR(I+1)=DVOL(I+1)*PBENAB/(DVOL(I)+DVOL(I+1))
         PBENTR(I)=DVOL(I)*PBENAB/(DVOL(I)+DVOL(I+1))
         SUMFLO(I+1)=DVOL(I+1)*SUMFAB/(DVOL(I)+DVOL(I+1))
         SUMFLO(I)=DVOL(I)*SUMFAB/(DVOL(I)+DVOL(I+1))
         DO 102 J=1,3
           EQ3(I,J)=DVOL(I)*EQ3AB(J)/(DVOL(I)+DVOL(I+1))
           EQ3(I+1,J)=DVOL(I+1)*EQ3AB(J)/(DVOL(I)+DVOL(I+1))
  102    CONTINUE
         NUME=NUME+1
         IF(NUME.GT.70)WRITE(MoomawOut,3020)
 3020    FORMAT(' TOO MANY LAYERS-LAYERS')
         IF(NUME.GT.70)STOP
         GO TO 91
   92    DO 300 I=1,NUME
           FRACT(I)=AREA(I)/AREA(I+1)
  300    CONTINUE
         RETURN
         END
C
         DOUBLE PRECISION FUNCTION ZFN(NC,VTARGT,ZEE,COEF)
         IMPLICIT DOUBLE PRECISION (A-H,O-Z)
         DIMENSION COEF(3)
         LOGICAL QSTART
C
C   RECEIVES VOLUME, RETURNS CORRESPONDING ELEVATION.
C   TWO OPTION AVAILABLE.
C
         IF(NC.EQ.2)GO TO 40
C
C   1.   QUADRATIC FUNCTION  -  USES APPROXIMATE SOLUTION
C             
         QSTART = .TRUE.
   10    V=COEF(3) * ZEE * ZEE * ZEE / 3. + COEF(2) * ZEE * ZEE / 2. + 
     1   COEF(1) * ZEE
         IF (DABS(VTARGT-V) .LT. 0.00001 * VTARGT) GO TO 30
         IF (VTARGT - V .LT. 0.) GO TO 20
         ZLOWER = ZEE
         IF (QSTART) ZUPPER = ZEE + 1.
         ZEE = ( ZUPPER + ZLOWER) / 2.
         GO TO 10
   20    QSTART = .FALSE.
         ZUPPER = ZEE
         ZEE = (ZUPPER + ZLOWER) / 2.
         GO TO 10
   30    ZFN = ZEE
         RETURN
C
C   2.   POWER FUNCTION  -  USES EXACT SOLUTION
C
   40    ELV=(VTARGT / (COEF(1) / (COEF(2) + 1.)))**(1./(COEF(2) + 1.))
         ZFN = ELV
         RETURN
         END
C
         DOUBLE PRECISION FUNCTION WFN(ZEE,COEF)
         IMPLICIT DOUBLE PRECISION (A-H,O-Z)
         DIMENSION COEF(2)
         IF(ZEE.LE.0D0)WIDTH=0.
         IF(ZEE.LE.0D0)GO TO 10
         WIDTH=COEF(1)*(ZEE**COEF(2))
         IF(WIDTH.LT.0.)WIDTH=0.
   10    WFN=WIDTH
         RETURN
         END

         DOUBLE PRECISION FUNCTION AFN(NC,ZEE,COEF)
         IMPLICIT DOUBLE PRECISION (A-H,O-Z)
         DIMENSION COEF(3)
         IF (NC .EQ. 2) GO TO 40
cy
cy  Add more Polynomial terms
cy
         AREA = COEF(3) * ZEE * ZEE + COEF(2) * ZEE + COEF(1)
     * 		+ COEF(4) * ZEE * ZEE * ZEE
     * 		+ COEF(5) * ZEE * ZEE * ZEE * ZEE
     * 		+ COEF(6) * ZEE * ZEE * ZEE * ZEE * ZEE
     * 		+ COEF(7) * ZEE * ZEE * ZEE * ZEE * ZEE * ZEE
                                
         IF (AREA .LT. 1.) AREA = 1.
         AFN = AREA
         RETURN
   40    AREA=COEF(1)*(ZEE**COEF(2))
         AFN=AREA
         RETURN
         END
C                  
         DOUBLE PRECISION FUNCTION VFN(NC,ZEE,COEF)
         IMPLICIT DOUBLE PRECISION (A-H,O-Z)
         DIMENSION COEF(3)
         IF (NC .EQ. 2) GO TO 40
cy
cy  Add more Polynomial terms
cy
         VOL=COEF(3)*ZEE*ZEE*ZEE/3. + COEF(2)*ZEE*ZEE/2. + COEF(1)*ZEE
     * 		+ (COEF(4)*(ZEE * ZEE * ZEE * ZEE))/4.
     * 		+ (COEF(5)*(ZEE * ZEE * ZEE * ZEE * ZEE))/5.
     * 		+ (COEF(6)*(ZEE * ZEE * ZEE * ZEE * ZEE * ZEE))/6.
     * 		+ (COEF(7)*(ZEE * ZEE * ZEE * ZEE * ZEE * ZEE * ZEE))/7.        

         IF (VOL . LT. 0.) VOL = 0.
         VFN = VOL
         RETURN
   40    VOL=(COEF(1)/(COEF(2)+1.))*(ZEE**(COEF(2)+1.))
         VFN=VOL
         RETURN
         END
         SUBROUTINE MIXING
         INCLUDE 'odu_com.f'
C
C*********************************************************************
C
C   S U B R O U T I N E   M I X I N G                      NUMBER 18
C
C*********************************************************************
C  CALCULATES DEPTH OF UPPER MIXED REGION BASED ON
C  MECHANICAL ENERGY AVAILABLE FROM WIND SHEAR AND
C  TURBULENT KINETIC ENERGY RELEASED DURING PENE-
C  TRATIVE CONVECTION
C
         DIMENSION TT(70),TDENS(70)
         DATA RHOA,RHOW,HCAP,GRAV/1.177,1000.,1.,1.27008E+08/
         RO(X,Y,Z)=1000.-(((X-3.98)**2*(X+283.))/(503.57*(X+67.26)))
     *             +0.00062*Y+0.00078*Z
         CTHRMX(X)=1.E-06*(-67.3349+17.8359*X
     *             -0.255587*X*X+0.00243466*X*X*X)
C
C  CALCULATE LAYER WATER DENSITIES
C
CB
CB   INITIALIZE ARRAYS DIMENSIONED THIS SUBROUTINE  BWB 3/21/90
CB
         DO 1 I=1,70
          TT(I)=0.
          TDENS(I)=0.
    1    CONTINUE
CB
         DO 05 I=1,NUME
           DENS(I)=RO(TEMP(I),SSOL(I),TDS(I))
   05    CONTINUE
C
C  CALCULATE RATE OF WIND WORK (WIND POWER)
C
C     CALCULATE WIND SHEAR STRESS ON WATER SURFACE,
C     USE DRAG COEFFICIENT OF WU(1969)
C     CONVERT WIND SPEED FROM KM/HR TO M/HR
C
         XWIND=WIND*1000.
         CD=0.0005*(XWIND/3600.)**0.5
         IF(XWIND/3600..GE.15.)CD=0.0026
         TAU=RHOA*CD*XWIND*XWIND
C
C     CALCULATE SHEAR VELOCITY OF WATER (M/HR)
C
         SVEL=(TAU/RHOW)**0.5
C
C     CALCULATE TURBULENT KINETIC ENERGY DUE TO WIND
C
         TKEW=SHELCF*TAU*SVEL*AREA(NUME+1)*DBLE(NHOI)
C
C  CALCULATE TURBULENT KINETIC ENERGY AVAILABLE
C  FOR MIXING FROM PENETRATIVE CONVECTION
C
C     ESTIMATE NET HEAT TRANSFER AT AIR-WATER INTERFACE
C     BASED ON PREVIOUS DAY'S TEMPERATURE. IF POSITIVE
C     NO PENETRATIVE CONVECTION OCCURS
C
         QNET=XQNS+FONE-FTWO*TEMP(NUME)
         TKEC=PEFRAC*ABS(QNET)*AREA(NUME+1)*ZMIX
     *        *GRAV*DBLE(NHOI)*CTHRMX(TEMP(NUME))/HCAP
         IF(QNET.GE.0.)TKEC=0.
C
C     SUM SOURCES OF TURBULENT KINETIC ENERGY AVAILABLE FOR MIXING
C
         TKE=TKEW+TKEC
C
C  ESTIMATE NEW TEMPERATURE STRUCTURE BASED ON THAT OF
C  PREVIOUS COMPUTATION INTERVAL
C
         CALL HEAT
         TT(NUME)=TEMP(NUME)+(SW(NUME)
     *            +(FONE-FTWO*TEMP(NUME))*AREA(NUME+1)
     *            +FEE(NUME)
     *            -QHO(NUME)*TEMP(NUME)*DENS(NUME)*HCAP)
     *            /(DENS(NUME)*HCAP*DVOL(NUME))*DBLE(NHOI)
         J=NUME-1
         DO 200 I=1,J
           TT(I)=TEMP(I)+(SW(I)
     *           +FEE(I)
     *           -QHO(I)*TEMP(I)*DENS(I)*HCAP)
     *           /(DENS(I)*HCAP*DVOL(I))*DBLE(NHOI)
  200    CONTINUE
C
C  CALCULATE TEMPORARY DENSITY STRUCTURE
C
         DO 300 I=1,NUME
           TDENS(I)= RO(TT(I),SSOL(I),TDS(I))
  300    CONTINUE
C
C  RE-INITIALIZE BOTTOMMOST MODEL LAYER IN MIXED REGION,
C  RE-INITIALIZE MIXED REGION DEPTH
C
         IMIX=NUME
         ZMIX=SDZ(NUME)
         DO 10 I=1,NUME
           CMZ(I)= (Z(I)+Z(I+1))/2.
   10    CONTINUE
         CMZMIX=CMZ(IMIX)
C
C  MODIFY TURBULENT KINETIC ENERGY AVAILABLE FOR ENTRAINMENT BY
C  RICHARDSON NUMBER (BLOSS AND HARLEMAN)
C
   20    IF(IMIX.LE.1)RETURN
         DELRHO=TDENS(IMIX-1)-TDENS(IMIX)
         IF(DELRHO.LE.0.)GO TO 30
         RI=GRAV*DELRHO*ZMIX/(RHOW*SVEL*SVEL)
         TKE=TKE*0.057*RI*((29.46-DSQRT(RI))/(14.2+RI))
C
C  CALCULATE BUOYANT ENERGY THAT MUST BE OVERCOME
C  FOR ENTRAINMENT TO OCCUR
C
          WL=GRAV*DELRHO
     *      *DVOL(IMIX-1)*(CMZMIX-CMZ(IMIX-1))
C
C  DETERMINE IF AVAILABLE KINETIC ENERGY IS SUFFICIENT
C  FOR ENTRAINMENT
C
         IF(WL.GE.TKE)RETURN
         IF(IMIX.EQ.1)RETURN
C
C     ENTRAINMENT OCCURS
C
         CALL ENTRAIN(TDENS)
C
C     DECREASE ENERGY AVAILABLE FOR ENTRAINMENT BY
C     BUOYANT ENERGY
C
         TKE=TKE-WL
         IF(TKE.GT.0.)GO TO 20
         RETURN
C
C   CALL 'ENTRAIN' IF UNSTABLE DENSITY
C   STEP IS ENCOUNTERED
C
   30    IF(IMIX.LE.1)RETURN
         CALL ENTRAIN(TDENS)
         IF(TKE.GT.0.)GO TO 20
         RETURN
         END
         SUBROUTINE HEAT
         INCLUDE 'odu_com.f'
C
C*********************************************************************
C
C   S U B R O U T I N E   H E A T                          NUMBER 19
C
C*********************************************************************
C  CALCULATES THE SOLAR RADIATION ABSORBED IN EACH LAYER
C  (OTHER HEAT TRANSFER TERMS ARE COMPUTED IN S/R 'RADIATE')
C
         DATA HDEPTH/0.61/
C
C  MODIFY FRACTION OF SOLAR RADIATION ABSORBED IN TOP LAYER
C  AS A FUNCTION OF ITS THICKNESS.  'SURFRAC' CORRESPONDS
C  TO A TOP-LAYER THICKNESS OF 'HDEPTH'
C
         DO 35 I=1,NUME
           SWS(I)=0.
           SW(I)=0.
   35    CONTINUE
         IF(XQNS.LE.0.)GO TO 100
         K=0
         TOPZ=RESEL-Z(NUME)
   40    IF(TOPZ.GE.HDEPTH)GO TO 45
         K=K+1
         TOPZ=RESEL-Z(NUME-K)
         GO TO 40
   45    CONTINUE
C
C  DETERMINE AVERAGE CONCENTRATION OF SUSPENDED SOLIDS
C
         SSSUM=0.
         L=NUME-K
         DO 47 I=L,NUME
             SSSUM=SSSUM+SSOL(I)*DVOL(I)
   47    CONTINUE
         SSSUM=SSSUM/(VOL(NUME+1)-VOL(NUME-K))
C
C  MODIFY EXTINCTION COEFFICIENT FOR SELF-SHADING BY SUSPENDED
C  SOLIDS
C
         TEXCO=EXCO+EXTINS*SSSUM
         ZSOL=(1.-SURFRAC)*XQNS*DEXP(-TEXCO*((RESEL-
     *        Z(NUME-K))-HDEPTH))
         TSURFR=1.-ZSOL/XQNS
         TVOL=VOL(NUME+1)-VOL(NUME-K)
C
C  COMPUTE SOLAR RADIATION ABSORBED IN MIXED LAYER
C
         THEAT=XQNS*AREA(NUME+1)-(1.-TSURFR)*XQNS*AREA(NUME-K)
         J=NUME-K
         DO 50 I=J,NUME
           SW(I)=THEAT*DVOL(I)/TVOL
   50    CONTINUE
C
C  COMPUTE SOLAR RADIATION TRANSMITTED TO DEEPER STRATA
C
         QSW=(1.-TSURFR)*XQNS
         SWS(NUME+1)=XQNS
         SWS(NUME-K)=QSW
         IF(K.EQ.0)GO TO 65
         DO 55 I=1,K
           II=NUME-I+1
           SWS(II)=(AREA(II+1)*SWS(II+1)-SW(II))/AREA(II)
   55    CONTINUE
   65    CONTINUE
C
C  COMPUTE SHORTWAVE RADIATION FLUXES IN UNDERLYING LAYERS WITH
C  SELFSHADING DEPENDENT ON BIOMASS IN EACH LAYER
C
         L=NUME-K-1
         DO 70 J=1,L
           I=(NUME-K)-J+1
           TEXCO=EXCO+EXTINS*SSOL(I)
           SWS(I-1)=SWS(I)*DEXP(-TEXCO*(Z(I)-Z(I-1)))
   70    CONTINUE
C
C  COMPUTE SOLAR RADIATION ABSORBED IN EACH LAYER
C
         J=NUME-K-1
         DO 80 I=1,J
           SW(I)=AREA(I+1)*SWS(I+1)-AREA(I)*SWS(I)
   80    CONTINUE
  100    RETURN
         END
         SUBROUTINE ENTRAIN(TDENS)
         INCLUDE 'odu_com.f'
C
C*********************************************************************
C
C  S U B R O U T I N E   E N T R A I N ( T D E N S )       NUMBER 20
C
C*********************************************************************
C  RESIZES,DEFINES ATTRIBUTES AND CALCULATES CENTER OF MASS
C  OF UPPER MIXED LAYER WHEN ENTRAINMENT OCCURS
C
         DIMENSION TDENS(70),EQ1MIX(3),EQ2MIX(3),EQ3MIX(3)
C
C  COMPUTE MIXED QUANTITIES.
C
         TDENSM=((VOL(NUME+1)-VOL(IMIX))*TDENS(NUME)
     *          +(DVOL(IMIX-1)*TDENS(IMIX-1)))
     *          /(VOL(NUME+1)-VOL(IMIX-1))
         DO 05 I=1,3
           EQ1MIX(I)=((VOL(NUME+1)-VOL(IMIX))*EQ1(NUME,I)
     *               +(DVOL(IMIX-1)*EQ1(IMIX-1,I)))
     *               /(VOL(NUME+1)-VOL(IMIX-1))
           EQ2MIX(I)=((VOL(NUME+1)-VOL(IMIX))*EQ2(NUME,I)
     *               +(DVOL(IMIX-1)*EQ2(IMIX-1,I)))
     *               /(VOL(NUME+1)-VOL(IMIX-1))
           EQ3MIX(I)=0.
   05    CONTINUE
C
C  ENTRAIN ANOTHER MODEL LAYER,
C  COMPUTE TOTAL W/Q INFLOWS
C
         IMIX=IMIX-1
         DO 10 J=IMIX,NUME
           DO 11 K=1,3
             EQ3MIX(K)=EQ3MIX(K)+EQ3(J,K)
   11      CONTINUE
   10    CONTINUE
C
C  REDEFINE ATTRIBUTES OF MIXED LAYERS
C  VOLUME WEIGHT TOTAL INFLOWS AMONG ENTRAINED LAYERS
C
         DO 20 K=IMIX,NUME
           TDENS(K)=TDENSM
           DO 25 L=1,3
             EQ1(K,L)=EQ1MIX(L)
             EQ2(K,L)=EQ2MIX(L)
             EQ3(K,L)=EQ3MIX(L)*DVOL(K)/(VOL(NUME+1)-VOL(IMIX))
   25      CONTINUE
   20    CONTINUE
C
C  CALCULATE NEW CENTER OF MASS FOR UPPER
C  MIXED LAYER BY VOLUME WEIGHTING
C
         VOLMIX=0.
         DO 30 L=IMIX,NUME
           CMZMIX=(CMZMIX*VOLMIX+CMZ(L)*DVOL(L))
     *            /(VOLMIX+DVOL(L))
           VOLMIX=VOLMIX+DVOL(L)
   30    CONTINUE
C
C  CALCULATE DEPTH OF MIXED LAYER
C
         ZMIX=Z(NUME+1)-Z(IMIX)
         RETURN
         END
         SUBROUTINE TRNSPT
         INCLUDE 'odu_com.f'
C
C*********************************************************************
C
C  S U B R O U T I N E  T R N S P T                        NUMBER 21
C
C*********************************************************************
C  COMPUTES THE DIFFUSION COEFFICIENTS
C  AND SETS UP THE INVARIANT TRANSPORT
C  MATRIX COEFFICIENTS
C
         DIMENSION AKEF(70),DISF(70),Q(70)
         DATA GRAV,RHOA,RHOW/1.27008E+08,1.177,1000./
         DATA DCMOLE/5.148E-04/ 
         DATA DCMAX/20./
C
C  THE DIFFUSION COEFFICIENTS FOR THE AIR-WATER AND WATER-SEDIMENT
C  INTERFACES ARE SET TO ZERO
C
         DC(1)=0.
         DC(NUME+1)=0.
C
C  THE DIFFUSION COEFFICIENTS ARE AFFECTED BY
C  WIND, INFLOWS, AND OUTFLOWS
C
C     COMPUTE RATE OF DISSIPATION OF TURBULENT
C     KINETIC ENERGY DUE TO WIND
C
         DISW=TKEW/(RHOW*VOL(NUME+1)*NHOI)
C
C     COMPUTE AVERAGE KINETIC ENERGY OF INFLOWS
C     AND OUTFLOWS AND ITS RATE OF DISSIPATION
C
         Q(1)=QHI(1)+QHO(1)
         AKEF(1)=0.5*RHOW*Q(1)*NHOI
     *           *(Q(1)/(WIDTH(1)*SDZ(1)))**2.
         DISF(1)=AKEF(1)/(RHOW*DVOL(1)*NHOI)
         DO 10 I=2,NUME
           Q(I)=QHI(I)+QHO(I)
           IF(Q(I).LE.0.001)Q(I)=0.
           AKEF(I)=0.5*RHOW*Q(I)*NHOI
     *             *(Q(I)/(WIDTH(I)*SDZ(I)))**2.
           DISF(I)=AKEF(I)/(RHOW*DVOL(I)*NHOI)
C
C     COMPUTE BUOYANCY
C
           DELRHO=DENS(I-1)-DENS(I)
           IF(DELRHO.LE.0.)GO TO 20
           BN2=GRAV/RHOW*DELRHO/
     *         ((SDZ(I)+SDZ(I-1))/2.)
           GO TO 25
   20      BN2=0.
C
C  COMPUTE RICHARDSON NUMBER
C
   25      IF(SVEL.LE.0.)GO TO 30
           RI=BN2/((SVEL/(0.4*(Z(NUME+1)-Z(I))))**2.)
           GO TO 35
   30      RI=0.
C
C  COMPUTE DENSIMETRIC FROUDE NUMBER
C  (SQUARED AND INVERTED)
C
   35      IF(Q(I).LE.0.)GO TO 40
           IF(DELRHO.LE.0.) GO TO 40
           FA=(AREA(I)*SDZ(I))/RLEN
           FR=((GRAV/RHOW)*DELRHO*SDZ(I))/
     *        (Q(I)**2/FA**2)   
           GO TO 45
   40      FR=0.
C
C  COMPUTE DIFFUSION COEFFICIENTS
C
   45      DC(I)=(CDIFW*DISW)/(1.+RI)+
     *           (CDIFF*(DISF(I)+DISF(I-1))/2.)/(1.+FR)
           DC(I)=DC(I)*DBLE(NHOI)*DBLE(NHOI)
           IF(DC(I).LE.DCMOLE)DC(I)=DCMOLE
           IF(DC(I).GT.DCMAX)DC(I)=DCMAX
           IF(QCALBR)DC(I)=7.772E-03
   10    CONTINUE
C
C  COMPUTE INVARIANT MATRIX ELEMENTS
C
         XX(1,1)=0.
         XX(1,2)=AREA(2)*DC(2)/((SDZ(1)+SDZ(2))/2.)+QHO(1)
         IF(PHOURS.GT.0.)XX(1,2)=XX(1,2)+PBENTR(1)/PHOURS
         XX(1,3)=AREA(2)*DC(2)/((SDZ(1)+SDZ(2))/2.)
         J=NUME-1
         DO 50 I=2,J
           XX(I,1)=AREA(I)*DC(I)/((SDZ(I-1)+SDZ(I))/2.)
           XX(I,2)=AREA(I)*DC(I)/((SDZ(I-1)+SDZ(I))/2.)
     *             +AREA(I+1)*DC(I+1)/((SDZ(I)+SDZ(I+1))/2.)+QHO(I)
           IF(PHOURS.GT.0.)XX(I,2)=XX(I,2)+PBENTR(I)/PHOURS
           XX(I,3)=AREA(I+1)*DC(I+1)/((SDZ(I)+SDZ(I+1))/2.)
   50    CONTINUE
         XX(NUME,1)=AREA(NUME)*DC(NUME)/((SDZ(NUME-1)+SDZ(NUME))/2.)
         XX(NUME,2)=AREA(NUME)*DC(NUME)/((SDZ(NUME-1)+SDZ(NUME))/2.)
     *              +AREA(NUME+1)*DC(NUME+1)/SDZ(NUME)+QHO(NUME)
         IF(PHOURS.GT.0.)XX(NUME,2)=XX(NUME,2)+PBENTR(NUME)/PHOURS
         XX(NUME,3)=0.
         RETURN
         END
         SUBROUTINE TMPRTR
         INCLUDE 'odu_com.f'
C
C*********************************************************************
C
C  S U B R O U T I N E   T M P R T R                       NUMBER 22
C
C*********************************************************************
C  DEFINE BIO-CHEMICAL RATE ARRAY (ZERO FOR THIS COMPARTMENT)
C
         DO 10 I=1,NUME
           SORS(I,1)=0.
           SORS(I,2)=0.
           SORS(I,3)=0.
   10    CONTINUE
C
C  DEFINE CONCENTRATION-INDEPENDENT TERM
C
         DO 20 I=1,NUME
           FEE(I)=(FEE(I)+SW(I))/(DENS(I)*1.)
           IF(I.EQ.PBLAYR.AND.PHOURS.GT.0.)
     *       FEE(I)=FEE(I)+(PBFLOW/PHOURS)*TPE
   20    CONTINUE
C
C  REFINE SURFACE LAYER TERMS
C
         FEE(NUME)=FEE(NUME)+FONE*AREA(NUME+1)/(DENS(NUME)*1.)
         SORS(NUME,2)=-FTWO*AREA(NUME+1)/(DENS(NUME)*1.)
C
C  INCLUDE DVDT TERM
C
         DO 40 I=1,NUME
           SORS(I,2)=SORS(I,2)-(QHI(I)-QHO(I))
           IF(PHOURS.GT.0.)SORS(I,2)=SORS(I,2)+(PBENTR(I)/PHOURS)
           IF(I.EQ.PBLAYR.AND.PHOURS.GT.0.)
     *       SORS(I,2)=SORS(I,2)-(PBFLOW/PHOURS)
           IF(I.EQ.NUME)SORS(I,2)=SORS(I,2)-(-EV*AREA(NUME+1))
   40    CONTINUE
C
C  INTEGRATE
C
         CALL INTEGR(TEMP,TEMPDT,FEE,DVOL,DBLE(NHOI)/2.,NUME)
C
C NEGATIVE HEDGE
C
         DO 30 I=1,NUME
           IF(TEMP(I).LT.0.)TEMP(I)=0.
   30    CONTINUE
         RETURN
         END
         SUBROUTINE SOLIDS
         INCLUDE 'odu_com.f'
C
C*********************************************************************
C
C  S U B R O U T I N E  S O L I D S                        NUMBER 23
C
C*********************************************************************
C  DEFINE BIOCHEMICAL RATE ARRAY
C
         DO 10 I=1,NUME
           SORS(I,1)=0.
           SORS(I,2)=-DVOL(I)*SSETL/SDZ(I)-(QHI(I)-QHO(I))
           IF(QPMPBK.AND.PHOURS.GT.0.)
     *       SORS(I,2)=SORS(I,2)+PBENTR(I)/PHOURS
           IF(QPMPBK.AND.PHOURS.GT.0..AND.I.EQ.PBLAYR)
     *       SORS(I,2)=SORS(I,2)-PBFLOW/PHOURS
           IF(I.EQ.NUME)SORS(I,2)=SORS(I,2)-(-EV*AREA(NUME+1))
           IF(I.LT.NUME)SORS(I,3)=DVOL(I+1)*SSETL*FRACT(I+1)/SDZ(I+1)
   
C
C  CONCENTRATION-INDEPENDENT TERM
C
           IF(QPMPBK.AND.PHOURS.GT.0..AND.I.EQ.PBLAYR)
     *       PSSOL(I)=PSSOL(I)+PBFLOW*QMXSOL/PHOURS
   10    CONTINUE
         SORS(NUME,3)=0.
C
C  INTEGRATE
C
         CALL INTEGR(SSOL,SSOLDT,PSSOL,DVOL,DBLE(NHOI)/2.,NUME)
         RETURN
         END
          SUBROUTINE TDSOL
          INCLUDE 'odu_com.f'
C
C*********************************************************************
C
C   S U B R O U T I N E   T D S O L                        NUMBER 24
C
C*********************************************************************
C   DEFINE BIO-CHEMICAL RATE DECAY
C   INCLUDES DVDT TERM
C
         DO 10 I=1,NUME
           SORS(I,1)=0.
           SORS(I,2)=-(QHI(I)-QHO(I))
           IF(QPMPBK.AND.PHOURS.GT.0.)
     *       SORS(I,2)=SORS(I,2)+PBENTR(I)/PHOURS
           IF(QPMPBK.AND.PHOURS.GT.0..AND.I.EQ.PBLAYR)
     *       SORS(I,2)=SORS(I,2)-PBFLOW/PHOURS
           IF(I.EQ.NUME)SORS(I,2)=SORS(I,2)-(-EV*AREA(NUME+1))
           SORS(I,3)=0
 
C
C  CONCENTRATION-INDEPENDENT TERM
C
           IF(QPMPBK.AND.PHOURS.GT.0..AND.I.EQ.PBLAYR)
     *       PTDS(I)=PTDS(I)+PBFLOW*QMXTDS/PHOURS
   10    CONTINUE
C
C  INTEGRATE
C
         CALL INTEGR(TDS,TDSDT,PTDS,DVOL,DBLE(NHOI)/2.,NUME)
         RETURN
         END
         SUBROUTINE CONMIX
         INCLUDE 'odu_com.f'
C
C*********************************************************************
C
C  S U B R O U T I N E  C O N M I X                        NUMBER 25
C
C*********************************************************************
         DIMENSION  WQSUM(3),WQMIX(3)
         RO(X,Y,Z)=1000.-(((X-3.98)**2*(X+283.))/(503.57*(X+67.26)))
     *              +0.00062*Y+0.00078*Z
C
C  DETERMINE IF AN INSTABILITY EXISTS
C
         K=1
  500    CONTINUE
         IF(K.GE.NUME) GO TO 560
         IF(DENS(K).LT.DENS(K+1)) GO TO 510
         K=K+1
         GO TO 500
  510    CONTINUE
C
C  SUCCESSIVELY MIX LAYERS ABOVE THE LEVEL OF INSTABILITY
C  UNTIL A STABLE DENSITY GRADIENT IS OBTAINED
C
         MIXLOW=K
         MIXTOP=MIXLOW
         SUMVOL=DVOL(MIXTOP)
         DO 515 J=1,3
           WQSUM(J)=EQ1(MIXTOP,J)*DVOL(MIXTOP)
  515    CONTINUE
  520    CONTINUE
         MIXTOP=MIXTOP+1
         VLMXTP=DVOL(MIXTOP)
         SUMVOL=SUMVOL+VLMXTP
C
C  COMPUTE WATER QUALITY VALUES FOR MIXED LAYERS
C
         DO 530 J=1,3
           WQSUM(J)=WQSUM(J)+EQ1(MIXTOP,J)*VLMXTP
           WQMIX(J)=WQSUM(J)/SUMVOL
  530    CONTINUE
C
C  COMPUTE DENSITY OF MIXED LAYERS
C
         DENST=RO(WQMIX(1),WQMIX(3),WQMIX(2))
         DENMIX=DENST
         IF(MIXTOP.EQ.NUME) GO TO 540
         IF(DENMIX.LT.DENS(MIXTOP+1)) GO TO 520
  540    CONTINUE
         IF(MIXLOW.LE.1) GO TO 550
C
C  DETERMINE IF AN INSTABILITY EXISTS BELOW THE MIXED LEVEL
C
         IF(DENS(MIXLOW-1).GE.DENMIX) GO TO 550
C
C  SUCCESSIVELY MIX LAYERS BELOW THE
C  MIXED LEVEL IF AN INSTABILITY EXISTS
C
         MIXLOW=MIXLOW-1
C
C  COMPUTE TEMPERATURE FOR MIXED LAYER
C
         VLMXLW=DVOL(MIXLOW)
         SUMVOL=SUMVOL+VLMXLW
C
C  COMPUTE WATER QUALITY FOR MIXED LAYER
C
         DO 545 J=1,3
           WQSUM(J)=WQSUM(J)+EQ1(MIXLOW,J)*VLMXLW
           WQMIX(J)=WQSUM(J)/SUMVOL
  545    CONTINUE
C
C  COMPUTE DENSITY OF MIXED LAYER
C
         DENST=RO(WQMIX(1),WQMIX(3),WQMIX(2))
         DENMIX=DENST
         GO TO 540
  550    CONTINUE
C
C  SET DENSITY TEMPERATURES AND THERMAL ENERGIES FOR MIXED LAYER
C
         DO 555 I=MIXLOW,MIXTOP
           DENS(I)=DENMIX
C
C  SET WATER QUALITY FOR MIXED LAYER
C
           DO 554 J=1,3
             EQ1(I,J)=WQMIX(J)
  554      CONTINUE
  555    CONTINUE
         K=MIXTOP
         GO TO 500
  560    CONTINUE
         RETURN
         END
         SUBROUTINE REREG
         INCLUDE 'odu_com.f'
C
C*********************************************************************
C
C S U B R O U T I N E   R E R E G                          NUMBER 26
C
C*********************************************************************
C  COMPUTE TEMPERATURE OF AFTERBAY
C  AFTER HEAT EXCHANGE AND
C  ADVECTION PROCESSES
C
         DATA RHO /1000./
C
C  MIX AFTERBAY VOLUME
C  AND RELEASE VOLUME
C
         VTOTAL = ABVOL + RBVOL
         ABTEMP = ( ABVOL * ABTEMP +
     *              RBVOL * RBTEMP ) / VTOTAL
         ABSSOL=(ABVOL*ABSSOL+RBVOL*RBSSOL)/VTOTAL
         ABTDS=(ABVOL*ABTDS+RBVOL*RBTDS)/VTOTAL
         ABVOL = VTOTAL
         IF(NFTRBY.EQ.1)ABRELT=ABTEMP
C
C  COMPUTE SURFACE AREA OF
C  AFTERBAY IN M2
C
         ABAREA=AFBCOF(1)+AFBCOF(2)*ABVOL+AFBCOF(3)*ABVOL*ABVOL
C
C
C  COMPUTE HEAT IN AFTERBAY
C  (THIS IS HEAT CONTENT IN KILOCALORIES IN EXCESS
C   OF THAT CORRESPONDING TO 0 DEG C )
C
         ABHEAT = 1. * RHO * ABTEMP * ABVOL
C
C  COMPUTE HEAT CHANGE DUE TO
C  SURFACE HEAT EXCHANGE
C
         HDELTA = (XQNS+FONE-FTWO*ABTEMP)*ABAREA
     *            *DBLE(NHOI)
C
C  COMPUTE NEW TEMPERATURE
C  (CANNOT BE NEGATIVE; IF SO, REMARK AND CONTINUE) 
C
         ABTEMP = ( ABHEAT + HDELTA ) /
     *            ( 1. * RHO * ABVOL )
         IF(ABTEMP.LE.0.)WRITE(MoomawOut,1000)
 1000    FORMAT(' ERRONEOUS AFTERBAY HEAT BALANCE')
         IF(ABTEMP.LE.0.)ABTEMP=0.
         IF(NFTRBY.NE.1)ABRELT=ABTEMP
         ABVOL = ABVOL - ABFLOW*DBLE(NHOI)
         RETURN
         END
         SUBROUTINE OBLOUT
         INCLUDE 'odu_com.f'
C
C*********************************************************************
C
C  S U B R O U T I N E   O B L O U T                       NUMBER 27
C
C*********************************************************************
C  PRINTS OBLIGATORY OUTPUT EACH COMPUTATION INTERVAL
C
         CHARACTER*3 WHICH
         CHARACTER*7 PORT(3),FLOW(3),TARGT
         DIMENSION QTEST(70)
C
C  PUT DATA IN SIMULATION OUTPUT FILES.
C
C         WATER COLUMN DATA   -  TAPE89
C         OUTFLOW DATA        -  TAPE90
C         INFLOW DATA PER TRIB-  TAPE91-96
C
C  A. DETERMINE COMPUTATION INTERVAL.
C
         IF(NHOURS.EQ.ISTART)INTCMP=0
         INTCMP=INTCMP+1
C
C  B. WRITE DATA FOR THIS COMPUTATION INTERVAL.
C
         WRITE(89)INTCMP
         WRITE(89)NHOURS+NHOI,NUME
         WRITE(89)(SNGL(Z(I))+SNGL(SDZ(I))/2.,I=1,NUME)
         WRITE(89)(SNGL(TEMP(I)),I=1,NUME)
         DO 110 I=1,16
           WRITE(89)
  110    CONTINUE
         WRITE(89)(SNGL(TDS(I)),I=1,NUME)
         WRITE(89)(SNGL(SSOL(I)),I=1,NUME)
         DO 115 I=1,13
           WRITE(89)
  115    CONTINUE
         WRITE(89)(SNGL(QHI(I))/3600.,I=1,NUME)
         WRITE(89)(SNGL(QHO(I))/3600.,I=1,NUME)
         WRITE(89)(SNGL(DC(I))/3600.,I=1,NUME)
         WRITE(89)SNGL(RESEL)
         WRITE(89)(SNGL(AREA(I)),I=1,NUME)
         WRITE(89)(SNGL(WIDTH(I)),I=1,NUME)
         WRITE(89)(SNGL(SWS(I)),I=1,NUME)
C
         WRITE(90)INTCMP
         WRITE(90)NHOURS+NHOI
         WRITE(90)SNGL(TEMPOU)
         DO 120 I=1,16
           WRITE(90)
  120    CONTINUE
         WRITE(90)SNGL(TDSOU)
         WRITE(90)SNGL(SSOLOU)
         DO 125 I=1,7
           WRITE(90)
  125    CONTINUE
         WRITE(90)SNGL(QO)/3600.
         WRITE(90)
C
         DO 100 I=1,NTRIBS
           J=90+I
           WRITE(J)INTCMP
           WRITE(J)NHOURS+NHOI,I
           WRITE(J)SNGL(TEMPIN(I))
           DO 130 K=1,16
             WRITE(J)
  130      CONTINUE
           WRITE(J)SNGL(TDSIN(I))
           WRITE(J)SNGL(SSOLIN(I))
           DO 135 K=1,7
             WRITE(J)
  135      CONTINUE
           WRITE(J)SNGL(QIN(I))/3600.
  100    CONTINUE
         DO 05 I=1,3
           PORT(I)='       '
           FLOW(I)='       '
   05    CONTINUE
         TARGT='       '
C
C  PRINT DAILY INFORMATION
C
         IF(IPRT.EQ.NHOI)GO TO 70
         IF(.NOT. QNORM) GO TO 200
         IF(MOD(NHOURS-ISTART+NHOI,IPRT).NE.0)GO TO 20
         GO TO 70
C  LOCATE NON-ZERO PORT FLOWS,STEPPING FROM BOTTOM.
C  ENCODE FIRST THREE FOR PRINTING.
C
   20    I=0
         NN=NOUTS
         IF(.NOT.QSPEC)NN=NOUTS+1
         DO 30 J=1,NN
           IF(QOT(J).GT.0.)GO TO 40
           GO TO 30
   40      I=I+1
           IF(I.EQ.4)GO TO 50
           WRITE(PORT(I),1010)J
           WRITE(FLOW(I),1015)QOT(J)/3600.
 1010      FORMAT(I2)
 1015      FORMAT(F7.1)
   30    CONTINUE
         WHICH=' NO'
         GO TO 60
   50    WHICH='YES'
C
C  PRINT INTERIM DATA
   60    CONTINUE
         IF(.NOT.QSPEC)WRITE(TARGT,1015)TARGET
         WRITE(MoomawOut,1020)NHOURS+NHOI,(NHOURS+NHOI)/24,
     *                 (NHRS/NHOI)+1,
     *                 RESEL,QI/3600.,TEMPIN(1),QO/3600.,TEMPOU,
     *                 TARGT,(PORT(I),FLOW(I),I=1,3),WHICH
 1020    FORMAT(1X,I4,2X,I3,3X,I4,3X,F6.1,1X,F7.1,F7.1,1X,F7.1,
     *         F7.1,5X,A7,8X,A2,3X,A7,4X,A2,3X,A7,4X,A2,4X,A7,
     *         2X,A3)
         GO TO 70
  200    IF(MOD(NHOURS-ISTART+NHOI,IPRT).NE.0)GO TO 220
         GO TO 70
  220    WRITE(MoomawOut,225)NHOURS+NHOI,(NHOURS+NHOI)/24,
     *		RESEL,QI/3600.,
     *         TEMPIN(1),QO/3600.,TEMPOU,ABFLOW/3600.,ABTEMP,
     *         ABVOL
  225    FORMAT(2X,I4,3X,I3,3X,F5.1,3X,F6.0,3X,F4.1,3X,F6.0,3X
     *         F4.1,3X,F7.0,7X,F4.1,5X,F10.0)
 70      RETURN
         END


         SUBROUTINE OUTPT1
         INCLUDE 'odu_com.f'
C
C*********************************************************************
C
C  S U B R O U T I N E  O U T P T 1                        NUMBER 28
C
C*********************************************************************
C

Cy	 write(LogProgress,*) 'MOO-MAW OUT=', MoomawOut
Cy	 stop
         WRITE(MoomawOut,1000)
 1000    FORMAT(1H1)
         WRITE(MoomawOut,1010)
 1010    FORMAT(33X,43HTHIS IS 'CE-THERM-R1',THE THERMAL ANALYSIS ,
     *         23HPORTION OF 'CE-QUAL-R1',//,
     *         11X,34HCE-QUAL-R1 IS A RESEARCH TOOL FOR ,
     *         55HRESERVOIR ECOSYSTEM ANALYSIS USED BY THE WATER QUALITY ,
     *         25HMODELING GROUP, WATERWAYS/,12X,19HEXPERIMENT STATION.,
     *         50H  NOTE THAT ORGANIZATIONAL AND PROCEDURAL CLARITY ,
     *         43HHAVE PRIORITY OVER COMPUTATIONAL EFFICIENCY,/,12X,
     *         40HVAX VERSION. LAST UPDATE = JAN 27, 1986.,//)
         WRITE(MoomawOut,1015)(TITLE(I),I=1,90)
 1015    FORMAT(29X,18A4)
         WRITE(MoomawOut,1020)(IFIRST/24)+1,(ISTART/24)+1,ILAST/24,NHOI,IPRT,
     *                 NOUTS,NTRIBS,XLAT,XLON,TURB,AA,
     *                 BB,SDZMIN,SDZMAX,RESEL,RLEN,
     *                 PEFRAC,SHELCF,CDIFW,CDIFF,
     *                 EXCO,CDENS,SURFRAC,PBCOEF,
     *                 (ACOEF(I),I=1,3),EXTINS,(WCOEF(I),I=1,2),TSSETL
 1020    FORMAT(//,1X,13HDATA SUMMARY:,/,107X,9HSTART DAY,11X,I4,/,3X,
     *   18HINITIALIZATION DAY,2X,I4,2X,8HSTOP DAY,12X,I4,2X,
     *   17HCOMP.INTERVAL,HRS,5X,I2,2X,19HOUTPUT INTERVAL,HRS,1X,I5,2X,
     *   17HNUMBER OF OUTLETS,5X,I2,/,3X,21HNUMBER OF TRIBUTARIES,1X,
     *   I2,2X,12HLATITUDE,DEG,2X,F10.2,2X,13HLONGITUDE,DEG,1X,F10.2,
     *   2X,16HTURBIDITY FACTOR,5X,F3.1,2X,16HEMP.WIND COEF,AA,E8.2,/,
     *   3X,16HEMP.WIND COEF,BB,E8.2,2X,17HMIN.LAYER THKNS,M,2X,F5.1,
     *   2X,17HMAX.LAYER THKNS,M,2X,F5.1,2X,15HINIT.POOL HGT,M,3X,
     *   F6.1,2X,16HEFF.RES.LENGTH,M,1X,F7.0,/,3X,7HMIXING ,
     *   17HPARAMETERS.......,2X,9H'PEFRAC' ,6X,F9.2,2X,
     *   8H'SHELCF',7X,F9.2,2X,7H'CDIFW',8X,E9.2,2X,7H'CDIFF',8X,E9.2,
     *   /,3X,15HEXTINC.COEF,1/M,4X,F5.3,2
     *   X,17HINFLO CRIT(KG/M3),F7.4,2X,18HSURFACE RAD.FRACT.,F6.3,
     *   2X,15HPUMPBACK COEF .,F9.2,/,3X,
     *   24HAREA COEFFICIENTS.......,2X,8HACOEF(1),F16.3,2X,
     *   8HACOEF(2),F16.3,2X,8HACOEF(3),F16.3,2X,
     *   15HEXTINS,1/M-MG/L,F9.3,
     *   /,3X,24HWIDTH COEFFICIENTS......,2X,8HWCOEF(1),F16.3,2X,
     *   8HWCOEF(2),F16.3,2X,12HTSSETL,M/DAY,8X,F4.1//)
         WRITE(MoomawOut,1030)
 1030    FORMAT(1X,45HINITIAL GEOMETRIC ATTRIBUTES AND TEMPERATURE ,
     *   8HPROFILE:,//,5X,5HLAYER,8X,5HLOWER,8X,5HUPPER,
     *   8X,5HLAYER,8X,5HLOWER,8X,5HUPPER,8X,5HLAYER,8X,5HTOTAL,
     *   8X,5HLAYER,5X,11HTEMPERATURE,/,5X,6HNUMBER,6X,
     *   7HSURFACE,6X,7HSURFACE,5X,9HTHICKNESS,5X,7HSURFACE,
     *   6X,7HSURFACE,6X,6HVOLUME,7X,6HVOLUME,8X,5HWIDTH,7X,
     *   5HDEG C,/,16X,9HELEVATION,4X,9HELEVATION,7X,1HM,11X,
     *   4HAREA,9X,4HAREA,10X,2HM3,10X,5HUP TO,10X,1HM,/,
     *   20X,1HM,12X,1HM,24X,2HM2,11X,2HM2,23X,5HLOWER,/,
     *   95X,7HSURFACE,/,97X,2HM3,/)
         DO 10 I=1,NUME
           WRITE(MoomawOut,1035)NUME-I+1,Z(NUME-I+1),Z(NUME-I+2),
     *                   SDZ(NUME-I+1),AREA(NUME-I+1),
     *                   AREA(NUME-I+2),DVOL(NUME-I+1),
     *                   VOL(NUME-I+1),WIDTH(NUME-I+1),
     *                   TEMP(NUME-I+1)
 1035      FORMAT(6X,I2,9X,F6.2,7X,F6.2,7X,F6.2,5X,F10.0,
     *            3X,F10.0,2X,F12.0,1X,F12.0,2X,F8.2,
     *            7X,F6.2)
   10    CONTINUE
         IF(QSPEC)GO TO 20
         WRITE(MoomawOut,1040)
 1040    FORMAT(//,1X,17HOUTLET STRUCTURE:,//,13X,11HPORT NUMBER,
     *      6X,14HWETWELL NUMBER,6X,11HELEVATION,M,9X,7HAREA,M2,
     *      6X,15HMIN.FLOW,M3/SEC,2X,15HMAX.FLOW,M3/SEC,//)
         DO 30 I=1,NOUTS
           WRITE(MoomawOut,1050)I,NWELL(I),ELOUT(I),AROUT(I),
     *		FMIN(I)/3600.,FMAX(I)/3600.
 1050      FORMAT(17X,I2,16X,I2,14X,F5.1,13X,F6.1,9X,F8.1,9X,F8.1)
   30    CONTINUE
         WRITE(MoomawOut,1060)ELOUT(NOUTS+1),AROUT(NOUTS+1),
     *                 FMIN(NOUTS+1)/3600.,FMAX(NOUTS+1)/3600.,
     *                 SELMAX/3600.
 1060    FORMAT(13X,9HFLOODGATE,13X,2H--,14X,F5.1,13X,F6.1,9X,F8.1,
     *         9X,F8.1,//,13X,
     *         46HMAXIMUM FLOW UNDER SELECTIVE WITHDRAWAL,M3/SEC,2X,
     *         F10.1)
   20    IF(QWEIR.AND..NOT.QPORT)GO TO 40
         WRITE(MoomawOut,1070)
 1070    FORMAT(//,1X,16HOUTLET STRUCTURE,//,13X,11HPORT NUMBER,
     *         6X,11HELEVATION,M,9X,7HAREA,M2,//)
         DO 50 I=1,NOUTS
           WRITE(MoomawOut,1080)I,ELOUT(I),AROUT(I)
 1080      FORMAT(17X,I2,14X,F5.1,12X,F6.1)
   50    CONTINUE
         IF(.NOT.QWEIR)RETURN
   40    WRITE(MoomawOut,1090)
 1090    FORMAT(//,1X,14HWEIR STRUCTURE,//,16X,8HHEIGHT,M,
     *          9X,8HLENGTH,M,10X,4HTYPE,//)
         IF(QSUB)WRITE(MoomawOut,1100)WRHGT,WRLNG
 1100    FORMAT(16X,F5.1,11X,F7.1,9X,9HSUBMERGED)
         IF(.NOT.QSUB)WRITE(MoomawOut,1110)WRHGT,WRLNG
 1110    FORMAT(16X,F5.1,11X,F7.1,12X,4HFREE)
         RETURN
         END


         SUBROUTINE OUTPT2
         INCLUDE 'odu_com.f'
C
C*********************************************************************
C
C  S U B R O U T I N E   O U T P T 2                       NUMBER 29
C
C*********************************************************************
         DIMENSION JDAY(12),MONTH(12),LDAY(12),DAY(12)
         INTEGER DAY
         CHARACTER*1 GRAFF(35)
         DATA  JDAY/1,32,60,91,121,152,182,213,244,
     *             274,305,335/
         DATA  MONTH/'JAN','FEB','MAR','APR','MAY',
     *         'JUN','JUL','AUG','SEP','OCT','NOV','DEC'/
         DATA  LDAY/1,32,61,92,122,153,183,214,245,
     *             275,306,336/
         IF(QIC)GO TO 25
C
C  COMPUTE SIMULATION YEAR.  CHECK FOR LEAP YEAR
C
         IF(MOD(NHOURS,8760).EQ.0.AND.(.NOT.QLEAP))GO TO 100
         IF(MOD(NHOURS,8784).EQ.0.AND.QLEAP)GO TO 100
         GO TO 110
  100    IYEAR=IYEAR+1
         QLEAP=.FALSE.
         IF(MOD(IYEAR,4).EQ.0)QLEAP=.TRUE.
C
C  SELECT DAY ARRAY
C
  110    DO 120 I=1,12
           IF(QLEAP)DAY(I)=LDAY(I)
           IF(.NOT.QLEAP)DAY(I)=JDAY(I)
  120    CONTINUE
C
C  CONVERT JULIAN DAY TO CALENDAR DAY
C
         DO 130 I=1,11
           IF((NHOURS+NHOI)/24.GE.DAY(I).AND.
     *        (NHOURS+NHOI)/24.LT.DAY(I+1))GO TO 140
  130    CONTINUE
         I=12
C
  140    WRITE(MoomawOut,1000)
 1000    FORMAT(1H1)
         WRITE(MoomawOut,1010)NHOURS+NHOI,(NHOURS+NHOI)/24,
     *		(NHOURS+NHOI)/24-DAY(I)+1,MONTH(I),IYEAR
 1010    FORMAT(1X,32HSTATUS AT END OF SIMULATION HOUR,1X,I5,48X,
     *         18HTHIS IS JULIAN DAY,1X,I3,14H, CALENDAR DAY,
     *         1X,I2,A3,I2,//,1X,34HAVERAGE METEOROLOGICAL QUANTITIES ,
     *          28HFOR THIS COMPUTATION PERIOD:,/)
         ELASL=ELEMSL+RESEL
         WRITE(MoomawOut,1020)CLOUD,APRES,WIND,DBT,DPT,XQNS,XQNA,
     *		EA,ES,EV,TEV,RESEL,ELASL
 1020    FORMAT(3X,11HCLOUD COVER,7X,F6.2,2X,15HAIR PRESSURE,MB,
     *   1X,F8.2,2X,14HWIND SPEED,KPH,3X,F7.2,2X,7HDRYBULB,
     *   11H TEMP,DEGC,1X,F5.1,2X,19HDEWPOINT TEMP,DEGC,F5.1,/,
     *   3X,16HS/W RAD,KC/M2/HR,1X,F7.1,2X,16HL/W RAD,KC/M2/HR,1X,
     *   F7.1,2X,17HVAPOR PRESSURE,MB,1X,F6.1,2X,15HSAT.VAP.PRES,MB,
     *   3X,F6.1,2X,14HEVAP.RATE,M/HR,F10.4,/, 
     *   107X,15HTOTAL EVAP., M.,F9.2,/,1X,20HSURFACE ELEVATION,M:,
     *   F6.1,1X,15HEL.ABOVE MSL,M.,F9.1,
     *   //,1X,10HINFLOWING ,
     *   41HQUANTITIES FOR THIS COMPUTATION INTERVAL:,/)
         WRITE(MoomawOut,1025)
 1025    FORMAT(20X,9HTRIBUTARY,13X,6HINFLOW,12X,
     *         11HTEMPERATURE,6X,15HTOT.DISS.SOLIDS,
     *         5X,16HSUSPENDED SOLIDS,/,42X,
     *         6HM3/SEC,15X,5HDEG C,15X,4HG/M3,
     *         16X,4HG/M3,/)
         DO 10 I=1,NTRIBS
           WRITE(MoomawOut,1030)I,QIN(I)/3600.,TEMPIN(I),TDSIN(I),SSOLIN(I)
 1030      FORMAT(24X,I1,16X,F7.2,15X,F4.1,14X,F7.1,13X,F7.1)
   10    CONTINUE
         IF(QWEIR.AND..NOT.QPORT)GO TO 40
         IF(.NOT.QNORM)GO TO 40
         WRITE(MoomawOut,1040)
 1040    FORMAT(/,1X,43HOUTFLOWING QUANTITIES FOR THIS COMPUTATION ,
     *   9HINTERVAL:,/,37X,4HPORT,23X,5HLAYER,17X,14HOUTFLOW,M3/SEC,/)
         NN=NOUTS
         IF(.NOT.QSPEC)NN=NOUTS+1
         DO 20 I=1,NN
           WRITE(MoomawOut,1050)I,NOUT(I),QOT(I)/3600.
 1050      FORMAT(38X,I2,25X,I3,18X,F12.2)
   20    CONTINUE
   40    WRITE(MoomawOut,1060)QO/3600.,TEMPOU,TDSOU,SSOLOU
 1060    FORMAT(//,1X,20HTOTAL OUTFLOW,M3/SEC,1X,
     *     F7.2,2X,17HTEMPERATURE,DEG C,7X,
     *     F4.1,2X,20HTOT.DISS.SOLIDS,G/M3,1X,F7.1,
     *     2X,16HSUSP.SOLIDS,G/M3,5X,F7.1)
         IF(.NOT.QAFTER)GO TO 21
         WRITE(MoomawOut,1064)ABFLOW/3600.,ABRELT,ABTDS,ABSSOL
 1064    FORMAT(//,1X,23HAFTERBAY RELEASE,M3/SEC,F5.1,
     *     2X,17HTEMPERATURE,DEG C,7X,
     *     F4.1,2X,20HTOT.DISS.SOLIDS,G/M3,1X,F7.1,
     *     2X,16HSUSP.SOLIDS,G/M3,5X,F7.1)
   21    IF(QSPEC)GO TO 25
         WRITE(MoomawOut,1065)TARGET
 1065    FORMAT(36X,24HTARGET TEMPERATURE,DEG C,1X,F6.2)
   25    WRITE(MoomawOut,1070)
         DO 4 I=1,35
            GRAFF(I)=' '
    4    CONTINUE
 1070    FORMAT(//)
         IF(.NOT.QNORM)WRITE(MoomawOut,1071)
 1071    FORMAT(87X,9HTRIBUTARY,2X,10HGENERATION)
         WRITE(MoomawOut,1072)
 1072    FORMAT(54X,9HTOT.DISS.,2X,9HSUSPENDED,5X,
     *       3HS/W,7X,5HLAYER,6X,5HLAYER,4X,
     *       9HDIFFUSION,4X,5HUPPER,/,4X,1H0,4X,
     *       1H5,3X,2H10,3X,2H15,3X,2H20,3X,2H25,
     *       3X,2H30,3X,2H35,5X,5HTEMP.,5X,
     *       6HSOLIDS,5X,6HSOLIDS,4X,9HRADIATION,4X,
     *       6HINFLOW,4X,7HOUTFLOW,5X,5HCOEF.,4X,
     *       9HELEVATION,/,45X,5HDEG.C,6X,4HG/M3,
     *       7X,4HG/M3,6X,8HKC/M2/HR,4X,6HM3/SEC,
     *       5X,6HM3/SEC,5X,5HM2/HR,8X,1HM,//)
         NTEMP=1
         DO 30 I=1,NUME
           ITEMP=INT(TEMP(NUME-I+1)+0.5)+1
           IF(ITEMP.GT.34)ITEMP=35
           GRAFF(ITEMP)='*'
           IF(VERIFY.NE.'     YES')GO TO 28
           IF((NHOURS+NHOI)/24.NE.NVDAY)GO TO 28
           DO 35 J=1,NVTMPS
             IF((Z(NUME+1)-Z(NUME-I+1)-SDZ(NUME-I+1).LE.
     *         VELEV(J)).AND.(Z(NUME+1)-Z(NUME-I+1).GT.
     *         VELEV(J)))GO TO 36
             GO TO 35
   36        NTEMP=INT(VTEMP(J)+0.5)+1
             GO TO 38
   35      CONTINUE
           GO TO 28
   38      GRAFF(NTEMP)='D'
   28      WRITE(MoomawOut,1080)NUME-I+1,(GRAFF(K),K=1,35),
     *	      TEMP(NUME-I+1),
     *        TDS(NUME-I+1),SSOL(NUME-I+1),
     *        SWS(NUME-I+1),QHI(NUME-I+1)/3600.,QHO(NUME-I+1)/3600.,
     *        DC(NUME-I+1),Z(NUME-I+2)
 1080      FORMAT(1X,I3,35A1,5X,F4.1,4X,
     *       F7.1,5X,F7.1,5X,F6.2,4X,F7.2,4X,F7.2,5X,F7.4,
     *       4X,F5.1)
           GRAFF(ITEMP)=' '
           GRAFF(NTEMP)=' '
   30    CONTINUE
C 
C  PRINT A HEADING FOR DAILY OUTPUT
C
         IF(IPRT.EQ.NHOI)GO TO 290
         IF(.NOT.QNORM) GO TO 240
         WRITE(MoomawOut,660)
  660    FORMAT(1H1,////,53X,17HDAILY INFORMATION,//,
     *         1X,4HHOUR,2X,3HDAY,2X,8HSIM.INT.,2X,4HELEV,3X,
     *         6HINFLOW,2X,4HTEMP,2X,7HOUTFLOW,2X,4HTEMP,
     *         1X,15H IF REGULATION ,3(4X,4HPORT,4X,4HFLOW),
     *         3X,5HMORE?,/,24X,2HM ,3X,6H M3/S ,4X,2HC ,
     *         3X,5H M3/S,5X,2HC ,15H  TARGET T. C. ,1X,
     *         3(12X,4HM3/S),//)
         GO TO 290
  240    WRITE(MoomawOut,215)
  215    FORMAT(1H1,//,38X,17HDAILY INFORMATION,//,
     *         1X,/,2X,4HHOUR,3X,3HDAY,3X,5H POOL,3X,6HINFLOW,3X,
     *         4HTEMP,3X,7HOUTFLOW,3X,4HTEMP,3X,8HAFTERBAY,
     *         3X,8HAFTERBAY,3X,8HAFTERBAY,/,16X,5HELEV.,2X,6H M3/S ,
     *         3X,4H  C ,3X,7HAVERAGE,3X,4HAVE.,3X,8H  FLOW  ,
     *         3X,8H  TEMP  ,3X,8H VOLUME ,/15X,5H  M  ,10X,7X,
     *         3X,4HM3/S,7X,1HC,6X,4HM3/S,7X,6H   C  ,3X,8H   M3   ,/)
  290    RETURN
         END


         SUBROUTINE OUTPT3(N)
         INCLUDE 'odu_com.f'
C
C*********************************************************************
C
C      S U B R O U T I N E  O U T P T 3 ( N )              NUMBER 30
C
C*********************************************************************
C USAGE SCHEDULE--
C
C          N=1    FROM 'CONTRL' FOLLOWING GENERATION EVENT
C          N=2    FROM 'CONTRL' FOLLOWING PUMPBACK EVENT
C
         CHARACTER*6 WHICH,WEAK,STRONG
         DATA WEAK/'  WEAK'/,STRONG/'STRONG'/
         GO TO(10,20),N
C
C GENERATION
C
   10    WRITE(MoomawOut,1000)(NHOURS+NHOI)/24,TIME,FLOVOL,GTEMP
 1000    FORMAT(1X,/,1X,10HJULIAN DAY,I3,5X,20HGENERATION EVENT FOR,
     *       1X,F4.1,1X,5HHOURS,4X,14HTOTAL VOL,M3 =,F11.0,5X,
     *       22HTEMPERATURE,DEGREES C.,F5.1,/)
         RETURN
C
C PUMPBACK PLACEMENT
C
   20    WHICH=WEAK
         IF(QSBJET)WHICH=STRONG
         WRITE(MoomawOut,1020) (NHOURS+NHOI)/24,TIME,FLOVOL,PGAMMA,WHICH,
     *                 PBFLOW,PBLAYR,PBTEMP
 1020    FORMAT(/,1X,10HJULIAN DAY,I3,5X,18HPUMPBACK EVENT FOR,1X,
     *       F4.1,1X,5HHOURS,/,1X,13HJET VOLUME,M3,F11.0,3X,
     *       17HENTRAINMENT COEF.,F4.1,3X,12HJET BUOYANCY,1X,A6,4X,
     *       18HPUMPBACK:  VOL. M3,F11.0,2X,5HLAYER,I3,2X,
     *       10HTEMP.DEG.C,F4.1,/)
         RETURN
         END
         SUBROUTINE INTEGR(C,CDOT,P,DELVOL,DTBY2,NS)
         INCLUDE 'odu_com.f'
C
C*********************************************************************
C
C   S U B R O U T I N E   I N T E G R                      NUMBER 31
C
C*********************************************************************         
         DIMENSION B(70),S(70,3),C(70),CDOT(70),P(70),DELVOL(71)
         IF(NHOURS.NE.ISTART)GO TO 20
         CDOT(1)=(C(1)*(-XX(1,2)+SORS(1,2))
     *          +C(2)*(XX(1,3)+SORS(1,3))+P(1))/DELVOL(1)
         DO 10 I=2,NUME
           CDOT(I)=(C(I-1)*(XX(I,1)+SORS(I,1))
     *             +C(I)*(-XX(I,2)+SORS(I,2))
     *             +C(I+1)*(XX(I,3)+SORS(I,3))+P(I))/DELVOL(I)
   10    CONTINUE
   20    CONTINUE
C
C                            PROGRAM STEP 1
C                            FORM THE MATRICES A, P, AND S FOR
C                            EQUATION SOLUTION...
      B(NS+1)=0.0
      DO 2810 J = 1, NS
        B(J) = C(J) + DTBY2 * CDOT(J)
        S(J,1) = XX(J,1) + SORS(J,1)
        S(J,2) = - XX(J,2) + SORS(J,2)
        S(J,3) = XX(J,3) + SORS(J,3)
 2810 CONTINUE
      P(1) = S(1,2) * B(1) + S(1,3) * B(2) + P(1)
      DO 2830 J = 2, NS
        TA = 0.0
        DO 2820 K = 1, 3
          N = J + K - 2
          TA = S(J,K) * B(N) + TA
 2820   CONTINUE
      P(J) = P(J) + TA
 2830 CONTINUE
      DO 2840 J = 1, NS
        S(J,1) = - DTBY2 * S(J,1)
        S(J,2) =DELVOL(J)- DTBY2 * S(J,2)
        S(J,3) = - DTBY2 * S(J,3)
C
C                            PROGRAM STEP 2
C                            SOLVE FOR TIME RATES OF CHANGE AND
C                            FINAL CONCENTRATIONS...
 2840 CONTINUE
      P(1) = P(1) / S(1,2)
      S(1,3) = S(1,3) / S(1,2)
      DO 2850 J = 2, NS
       TA = S(J,2) - S(J,1) * S(J-1,3)
        P(J) = ( P(J) - S(J,1) * P(J-1) ) / TA
        S(J,3) = S(J,3) / TA
 2850 CONTINUE
      CDOT(NS) = P(NS)
      C(NS) = B(NS) + DTBY2 * CDOT(NS)
      DO 2860 J = 2, NS
        N = NS + 1 - J
        CDOT(N) = P(N) - S(N,3) * CDOT(N+1)
        C(N) = B(N) + DTBY2 * CDOT(N)
 2860 CONTINUE
C                            PROGRAM STEP 3
C                            RETURN TO CALLING PROGRAM...
      RETURN
      END
