      subroutine DRIVER(Y,RUNOPT)
      include 'SIZE.INC'
      include 'GLOBAL.INC'
      include 'LOCAL.INC'
      include 'UNITS.INC'
      include 'INPAR.INC'
      include 'LOCAL1.INC'
      dimension Y(KOUNT,KCHEM)
      double precision Y
      real LOGP(NCHEM)
      real OUTVAR(10)
      real CONC(3,NCHEM),PLANFW
      integer RUNOPT,K,I,IVAR
      character DUMMY*1,TUNITS*6,OUTCHR*25
      include 'WORK.INC'
      if (ABSERG.lt.sngl(FOURU)) then
         ABSERG = sngl(FOURU)
         write (TTYOUT(MACHNO),5000)
         write (TTYOUT(MACHNO),5010) ABSERG
5000     format (/' The requested absolute error tolerance is too')
5010  format (' stringent for the precision of this computer.'/' It has 
     &been increased to:',1PE9.2,'.')
      endif
      if (RELERG.lt.sngl(FOURU)) then
         RELERG = sngl(FOURU)
         write (TTYOUT(MACHNO),5020)
5020     format (/' The requested relative error tolerance is too')
         write (TTYOUT(MACHNO),5010) RELERG
      endif
      ABSERR = dble(ABSERG)
      RELERR = dble(RELERG)
      if (MODEG.lt.1.or.MODEG.gt.3) go to 140
      ISOO = 0
      IBACK = 1
      KEQN = KCHEM*KOUNT
      if (RUNOPT.eq.0) then
         if (MACHNO.eq.11) then
            open (unit=KINLUN(MACHNO),status='new',access='sequential',
     &         form='unformatted',file='KINOUT.PLT')
         else
      open (unit=KINLUN(MACHNO),status='unknown',access='sequential',
     &form='unformatted',file='KINOUT.PLT')
            if (.not.(TOPOPN(MACHNO))) rewind KINLUN(MACHNO)
         endif
         write (KINLUN(MACHNO)) KCHEM,MODEG,KOUNT,TCODEG,YEAR1G
         do 100 K = 1, KCHEM
            write (KINLUN(MACHNO)) (CHEMNA(I,K),I=1,50)
100      continue
         write (KINLUN(MACHNO)) (ECONAM(I),I=1,50)
         write (KINLUN(MACHNO)) (TYPEG(I),I=1,KOUNT)
         open (unit=FG1LUN(MACHNO),status='unknown',access='sequential',
     &   form='formatted', file='FGETSEXP.XMS')
         open (unit=FG2LUN(MACHNO),status='unknown',access='sequential',
     &   form='formatted', file='FGETSCMD.XMS')
         write (FG1LUN(MACHNO),5030)
5030     format(                                                        
     &' ! File FGETSEXP.XMS for exams to fgets exposure data transfer'/ 
     &' ! Data fields are time in "tunits", temperature in degrees C,'/ 
     &' ! plankton standing stock in units of mg(fw)/L ,'/              
     &' ! aqueous concentrations of N chemicals in units of mg/L,'/     
     &' ! N toxicant concentrations in benthos in units of mg/kg (fw),'/
     &' ! N toxicant concentrations in plankton in units of mg/kg (fw)')
      if (MODEG.eq.2) then
         OUTVAR(1)=TINITG
         OUTVAR(2)=TENDG
         OUTCHR='segmented_initial_value'
            if (TCODEG.eq.1) then
               tunits='hours'
            elseif (TCODEG.eq.2) then
               tunits='days'
            elseif (TCODEG.eq.3) then
               tunits='months'
            elseif (TCODEG.eq.4) then
               tunits='years'
            else
               tunits='error'
            endif
      elseif (MODEG.eq.1) then
         tunits='years'
         OUTVAR(1)=0.0
         OUTVAR(2)=1.0
         OUTCHR='steady_state'
      elseif (MODEG.eq.3) then
         OUTCHR='seasonal_dynamics'
         OUTVAR(1)=TINITG
         OUTVAR(2)=real(NYEARG)*365.
         tunits='days'
      else
         OUTVAR(1)=0
         OUTVAR(2)=0
         tunits='error'
         OUTCHR='error_in_mode'
      endif
      do 102 I=1,KCHEM
         if (KOWG(I).gt.0) then
            LOGP(I) = alog10(KOWG(I))
         else
            LOGP(I) = -999
         endif
102   continue
         write (FG2LUN(MACHNO),5040) (ECONAM(I),I=1,50), TUNITS,
     & OUTVAR(1), OUTVAR(2), KCHEM, MODEG, OUTCHR
5040  format(                                                           
     &' /title "',50a1,'" ',/                                           
     &' /tunits ',A6/                                                   
     &' /tstart', 1PE12.5,/                                             
     &' /tend'  , E12.5,/                                               
     &' /cwunits mg/L'/                                                 
     &' /cfunits mg/L'/                                                 
     &' /chemicals ',I3/                                                
     &' /exams_mode ',I3,' ! ',A25)
      do 104 K=1,KCHEM
      if (K.eq.1) then
         if (KCHEM.eq.1) then
            write (FG2LUN(MACHNO),5042) (CHEMNA(I,K),I=1,50)
         else
            write (FG2LUN(MACHNO),5043) (CHEMNA(I,K),I=1,50)
         endif
      elseif (K.lt.KCHEM) then
         write (FG2LUN(MACHNO),5044) (CHEMNA(I,K),I=1,50)
      else
         write (FG2LUN(MACHNO),5045) (CHEMNA(I,K),I=1,50)
      endif
104   continue
5042  format(' /toxlab "',50A1,'"')
5043  format(' /toxlab "',50A1,'" &')
5044  format('         "',50A1,'" &')
5045  format('         "',50A1,'"')
      write (FG2LUN(MACHNO),5046) (MWTG(I),I=1,KCHEM)
5046  format(' /molwt', 10(1X,e12.5))
      write (FG2LUN(MACHNO),5047) (LOGP(I),I=1,KCHEM)
5047  format(' /logp ', 10(1x,e12.5))
         do 105 K = 1, KCHEM
            write (FG1LUN(MACHNO),5048) K,(CHEMNA(I,K),I=1,50)
105      continue
         write (FG1LUN(MACHNO),5049) (ECONAM(I),I=1,50)
5048  format(' ! Chemical No.',I2,': ',50A1)
5049  format(' ! Ecosystem:      ',50A1/' !')
      IF (MODEG.eq.1) then
      do 106 K=1,KCHEM
        CONC(1,K)=ALPHA(1,1,K)*dabs(Y(1,K))
106   continue
      do 107 K=1,KCHEM
      CONC(2,K)=ALPHA(32,2,K)*dabs(Y(2,K))/(BIOTOL(2)*10.0)
107   continue
      do 108 K=1,KCHEM
      CONC(3,K)=ALPHA(32,1,K)*dabs(Y(1,K))/(BIOTOL(1)*10.0)
108   continue
      PLANFW=PLMASG(1,MONTHG)/0.10
      write (FG1LUN(MACHNO),fmt=5050) OUTVAR(1),TCELG(1,MONTHG),PLANFW,
     &(CONC(1,K),K=1,KCHEM),(CONC(2,K),K=1,KCHEM),(CONC(3,K),K=1,KCHEM)
      write (FG1LUN(MACHNO),fmt=5050) OUTVAR(2),TCELG(1,MONTHG),PLANFW,
     &(CONC(1,K),K=1,KCHEM),(CONC(2,K),K=1,KCHEM),(CONC(3,K),K=1,KCHEM)
5050  format(1x,1pe12.5,1x,0pf5.1,1x,1pe9.2,30(1x,e9.2))
      ENDIF
      elseif (RUNOPT.eq.1) then
         open (unit=KINLUN(MACHNO),status='old',access='sequential',
     &   form='unformatted',file='KINOUT.PLT')
         open (unit=FG1LUN(MACHNO),status='old',access='sequential',
     &   form='formatted', file='FGETSEXP.XMS')
         open (unit=FG2LUN(MACHNO),status='old',access='sequential',
     &   form='formatted', file='FGETSCMD.XMS')
         if (TOPOPN(MACHNO)) then
110         continue
            read (KINLUN(MACHNO),end=112) DUMMY
            go to 110
112         continue
            backspace KINLUN(MACHNO)
114         continue
            read (FG1LUN(MACHNO),fmt=5059,end=116) DUMMY
            go to 114
116         continue
            backspace FG1LUN(MACHNO)
118         continue
            read (FG2LUN(MACHNO),fmt=5059,end=120) DUMMY
            go to 118
120         continue
            backspace FG2LUN(MACHNO)
            if (MODEG.eq.2) then
               OUTVAR(2) = TENDG
             else
               OUTVAR(2) = real(LASTYR-YEAR1G+NYEARG+1)*365.
             endif
            write (FG2LUN(MACHNO),5057) OUTVAR(2)
5057  format(' /tend ',1PE12.5)
122         continue
         endif
      else
5059  format(1A1)
         write (TTYOUT(MACHNO),5060) RUNOPT
5060     format (' Command cancelled; RUNOPT =',I2)
         go to 160
      endif
130   continue
      if (MODEG.eq.1) call DRIVM1 (Y,RUNOPT)
      if (MODEG.eq.2) call DRIVM2 (Y,RUNOPT)
      call DRIVM3 (Y,RUNOPT)
      if (ISOO.eq.0) go to 150
      go to 130
140   continue
      write (TTYOUT(MACHNO),5070) MODEG
5070  format (' MODE has a value of ',I5/' RUN aborted.')
      IFLAG = 8
150   continue
      endfile KINLUN(MACHNO)
      endfile FG1LUN(MACHNO)
      endfile FG2LUN(MACHNO)
      close (unit=KINLUN(MACHNO))
      close (unit=FG1LUN(MACHNO))
      close (unit=FG2LUN(MACHNO))
160   return
      end
