        subroutine FLXOUT(Y)
      include 'SIZE.INC'
      include 'GLOBAL.INC'
      include 'LOCAL.INC'
      include 'UNITS.INC'
      include 'LOCAL1.INC'
      include 'LOCAL2.INC'
        dimension Y(KOUNT,KCHEM)
        double precision Y
        real BIO, CHE, GNDOUT, HAFLS, HAFLT, HAFLW, PERCET, SUM, TIME1,
     &  TIME2, SOCACU, SOCBIO(2), SOCCHE, SOCDP, SOCHYD, SOCOUT, SOCOX,
     &  SOCPHO, SOCSOX, SOCVOL, TOTBIO, SOCRED, TOTLOS, VOL, TOTLOD
        real AUTOLD, ALLOLD, SURWAT, TEMP, HAFTMP(NCHEM), TLOCAL(4)
        integer J, K, K2, III(2), IV, VRAIL
        character KOUT*2, NAMTIM(4)*6
        data TLOCAL/1.0,24.0,730.5,8766./
        data NAMTIM/' hours','  days','months',' years'/
      III(1) = VRAIL(ECONAM)
      do 120 K2 = 1, KCHEM
         III(2) = VRAIL(CHEMNA(1,K2))
         write (KOUT,5000) K2
5000     format (I2)
         if (KOUT(1:1).eq.' ') KOUT(1:1) = '0'
         write (RPTLUN(MACHNO),5010) VERSN,MODEG,(ECONAM(IV),IV=1,III(1)
     &      )
         write (RPTLUN(MACHNO),5020) (CHEMNA(IV,K2),IV=1,III(2))
         write (RPTLUN(MACHNO),5030)
5010  format ('1','Exposure Analysis Modeling System -- EXAMS Version ',
     &F4.2,', Mode',I2/' Ecosystem: ',50A1)
5020     format (' Chemical:  ',50A1)
5030     format (1X,63('-'))
         write (RPTLUN(MACHNO),5040) KOUT
5040  format (' Table 18.',A2,'. Analysis of steady-state fate of organi
     &c chemical.')
         write (RPTLUN(MACHNO),5240)
         write (RPTLUN(MACHNO),5050)
5050     format (2X,'Steady-state Values',8X,'Mass Flux',4X,'% of Load',
     &      3X,'Half-Life*')
         SOCOUT = 0.0
         GNDOUT = 0.0
         SURWAT = 0.0
         do 100 J = 1, KOUNT
            TEMP = 1.0E-06*Y(J,K2)*EXPOKL(J,K2)
            SOCOUT = SOCOUT+TEMP
            if (TYPEG(J).eq.'B'.and.TYPEG(J-1).eq.'B') then
               GNDOUT = GNDOUT+TEMP
            else
               SURWAT = SURWAT+TEMP
            endif
100      continue
         SOCVOL = 0.0
         SOCCHE = 0.0
         SOCHYD = 0.0
         SOCOX = 0.0
         SOCDP = 0.0
         SOCSOX = 0.0
         SOCBIO(1) = 0.0
         SOCBIO(2) = 0.0
         SOCRED = 0.0
         do 110 J = 1, KOUNT
            VOL = VOLKL(J,K2)*Y(J,K2)
            SOCVOL = SOCVOL+1.0E-06*VOL*WATVOL(J)
            CHE = HYDRKL(J,K2)*Y(J,K2)
            SOCCHE = SOCCHE+CHE*WATVOL(J)
            SOCHYD = SOCHYD+1.0E-06*CHE*WATVOL(J)
            CHE = OXIDKL(J,K2)*Y(J,K2)
            SOCCHE = SOCCHE+CHE*WATVOL(J)
            SOCOX = SOCOX+1.0E-06*CHE*WATVOL(J)
            CHE = PHOTKL(J,K2)*Y(J,K2)
            SOCCHE = SOCCHE+CHE*WATVOL(J)
            SOCDP = SOCDP+1.0E-06*CHE*WATVOL(J)
            CHE = S1O2KL(J,K2)*Y(J,K2)
            SOCCHE = SOCCHE+CHE*WATVOL(J)
            SOCSOX = SOCSOX+1.E-06*CHE*WATVOL(J)
            CHE = REDKL(J,K2)*Y(J,K2)
            SOCCHE = SOCCHE+CHE*WATVOL(J)
            SOCRED = SOCRED+1.0E-06*CHE*WATVOL(J)
            if (TYPEG(J).ne.'B') then
               BIO = Y(J,K2)*BIOLKL(J,K2)
               SOCBIO(1) = SOCBIO(1)+1.0E-06*BIO*WATVOL(J)
            else
               BIO = Y(J,K2)*BIOLKL(J,K2)
               SOCBIO(2) = SOCBIO(2)+1.E-06*BIO*WATVOL(J)
            endif
110      continue
         SOCCHE = SOCCHE*1.0E-06
         TOTLOS = SOCOUT+SOCVOL+SOCBIO(1)+SOCBIO(2)+SOCCHE
         SOCACU = abs((TRANLD(K2)+SYSLDL(K2))-TOTLOS)
         HAFLT = 168.00
         if (TOTLOS.ne.0.0) HAFLT = 0.69315*(Z(5,K2)+Z(6,K2))/TOTLOS
         HAFTMP(K2) = HAFLT
         TENDL = 0.0D+00
         TENDL = 2.*HAFLT
         KDTIME = 1
         if (TENDL.le.288) then
            KDTIME = 1
         elseif (TENDL.le.8766.) then
            KDTIME = 2
         elseif (TENDL.le.105192.) then
            KDTIME = 3
         else
            KDTIME = 4
         endif
         TFACTR = TLOCAL(KDTIME)
         write (RPTLUN(MACHNO),5060) NAMTIM(KDTIME),NAMTIM(KDTIME)
5060     format (7X,'by Process',13X,'Kg/',A5,18X,A6)
         write (RPTLUN(MACHNO),5070)
5070     format (1X,21('-'),7X,10('-'),3X,9('-'),3X,10('-'))
         TOTLOD = SYSLDL(K2)+TRANLD(K2)
         ALLOLD = SYSLDL(K2)
         AUTOLD = TRANLD(K2)
         if (TOTLOD.eq.0.0) TOTLOD = 1.0
         if (KDTIME.gt.1) then
            SOCHYD = SOCHYD*TFACTR
            SOCOX = SOCOX*TFACTR
            SOCDP = SOCDP*TFACTR
            SOCSOX = SOCSOX*TFACTR
            SOCBIO(1) = SOCBIO(1)*TFACTR
            SOCBIO(2) = SOCBIO(2)*TFACTR
            SOCRED = SOCRED*TFACTR
            SOCVOL = SOCVOL*TFACTR
            SOCOUT = SOCOUT*TFACTR
            SOCCHE = SOCCHE*TFACTR
            SOCACU = SOCACU*TFACTR
            GNDOUT = GNDOUT*TFACTR
            SURWAT = SURWAT*TFACTR
            TOTLOD = TOTLOD*TFACTR
            ALLOLD = ALLOLD*TFACTR
            AUTOLD = AUTOLD*TFACTR
         endif
         if (SOCHYD.eq.0.0) then
            write (RPTLUN(MACHNO),5080)
         else
            PERCET = 100.*SOCHYD/TOTLOD
            HAFLT = 0.69315*(Z(5,K2)+Z(6,K2))/SOCHYD
            write (RPTLUN(MACHNO),5080) SOCHYD,PERCET,HAFLT
         endif
5080     format (' Hydrolysis',:,17X,1PG11.4,4X,0PF6.2,4X,1PG11.4)
         if (SOCRED.eq.0.0) then
            write (RPTLUN(MACHNO),5090)
         else
            PERCET = 100.*SOCRED/TOTLOD
            HAFLT = 0.69315*(Z(5,K2)+Z(6,K2))/SOCRED
            write (RPTLUN(MACHNO),5090) SOCRED,PERCET,HAFLT
         endif
5090     format (' Reduction',:,18X,1PG11.4,4X,0PF6.2,4X,1PG11.4)
         if (SOCOX.eq.0.0) then
            write (RPTLUN(MACHNO),5100)
         else
            PERCET = 100.*SOCOX/TOTLOD
            HAFLT = 0.69315*(Z(5,K2)+Z(6,K2))/SOCOX
            write (RPTLUN(MACHNO),5100) SOCOX,PERCET,HAFLT
         endif
5100     format (' Radical oxidation',:,10X,1PG11.4,4X,0PF6.2,4X,1PG11.4
     &      )
         SOCPHO = SOCDP
         if (SOCPHO.eq.0.0) then
            write (RPTLUN(MACHNO),5110)
         else
            PERCET = 100.*SOCPHO/TOTLOD
            HAFLT = 0.69315*(Z(5,K2)+Z(6,K2))/SOCPHO
            write (RPTLUN(MACHNO),5110) SOCPHO,PERCET,HAFLT
         endif
5110     format (' Direct photolysis',:,10X,1PG11.4,4X,0PF6.2,4X,1PG11.4
     &      )
         if (SOCSOX.eq.0.0) then
            write (RPTLUN(MACHNO),5120)
         else
            PERCET = 100.*SOCSOX/TOTLOD
            HAFLT = 0.69315*(Z(5,K2)+Z(6,K2))/SOCSOX
            write (RPTLUN(MACHNO),5120) SOCSOX,PERCET,HAFLT
         endif
5120     format (' Singlet oxygen oxidation',:,3X,1PG11.4,4X,0PF6.2,4X, 
     &      1PG11.4)
         CHEMPC(K2) = 100.*SOCCHE/TOTLOD
         if (SOCBIO(1).eq.0.0) then
            write (RPTLUN(MACHNO),5130)
         else
            PERCET = 100.*SOCBIO(1)/TOTLOD
            HAFLW = 0.69315*(Z(5,K2)+Z(6,K2))/SOCBIO(1)
            write (RPTLUN(MACHNO),5130) SOCBIO(1),PERCET,HAFLW
         endif
5130     format (' Bacterioplankton',:,11X,1PG11.4,4X,0PF6.2,4X,1PG11.4)
         if (SOCBIO(2).eq.0.0) then
            write (RPTLUN(MACHNO),5140)
         else
            PERCET = 100.*SOCBIO(2)/TOTLOD
            HAFLS = 0.69315*(Z(5,K2)+Z(6,K2))/SOCBIO(2)
            write (RPTLUN(MACHNO),5140) SOCBIO(2),PERCET,HAFLS
         endif
5140     format (' Benthic Bacteria',:,11X,1PG11.4,4X,0PF6.2,4X,1PG11.4)
         TOTBIO = SOCBIO(1)+SOCBIO(2)
         BIOPCT(K2) = 100.*TOTBIO/TOTLOD
         EXPPCT(K2) = 100.*SOCOUT/TOTLOD
         if (SURWAT.eq.0.0) then
            write (RPTLUN(MACHNO),5150)
         else
            PERCET = 100.*SURWAT/TOTLOD
            HAFLT = 0.69315*(Z(5,K2)+Z(6,K2))/SURWAT
            write (RPTLUN(MACHNO),5150) SURWAT,PERCET,HAFLT
         endif
5150     format (' Surface Water-borne Export',:,1X,1PG11.4,4X,0PF6.2,4X
     &      ,1PG11.4)
         if (GNDOUT.eq.0.0) then
            write (RPTLUN(MACHNO),5160)
         else
            PERCET = 100.*GNDOUT/TOTLOD
            HAFLT = 0.69315*(Z(5,K2)+Z(6,K2))/SURWAT
            write (RPTLUN(MACHNO),5160) GNDOUT,PERCET,HAFLT
         endif
5160     format (' Seepage export',:,13X,1PG11.4,4X,0PF6.2,4X,1PG11.4)
         VOLPCT(K2) = 100.*SOCVOL/TOTLOD
         if (SOCVOL.eq.0.0) then
            write (RPTLUN(MACHNO),5170)
         else
            HAFLT = 0.69315*(Z(5,K2)+Z(6,K2))/SOCVOL
            write (RPTLUN(MACHNO),5170) SOCVOL,VOLPCT(K2),HAFLT
         endif
5170     format (' Volatilization',13X,1PG11.4,4X,0PF6.2,4X,1PG11.4)
         write (RPTLUN(MACHNO),5240)
         TOTLOS = SOCOUT+SOCVOL+TOTBIO+SOCCHE
         write (RPTLUN(MACHNO),5180) TOTLOS
5180     format (' Chemical Mass Balance:'/3X,' Sum of fluxes =',9X,    
     &      1PG11.4)
         write (RPTLUN(MACHNO),5190) TOTLOD
5190     format (3X,' Sum of loadings =',7X,1PG11.4)
         PERCET = 100.*ALLOLD/TOTLOD
         write (RPTLUN(MACHNO),5200) PERCET
5200     format (6X,' Allochthonous load:',16X,F6.1)
         PERCET = 100.*AUTOLD/TOTLOD
         write (RPTLUN(MACHNO),5210) PERCET
5210     format (6X,' Autochthonous load:',16X,F6.1)
         PERCET = 100.*SOCACU/TOTLOD
         write (RPTLUN(MACHNO),5220) SOCACU,PERCET
5220     format ('    Residual Accumulation =',3X,1PG9.2,3X,0PF6.1)
         write (RPTLUN(MACHNO),5240)
         write (RPTLUN(MACHNO),5230)
5230  format (1X,'* Pseudo-first-order estimates based on flux/','reside
     &nt mass.')
5240     format (1X,63('-'))
120   continue
      SUM = 0.0
      do 130 K2 = 1, KCHEM
         SUM = SUM+HAFTMP(K2)
130   continue
      HAFLT = SUM/float(KCHEM)
      TENDL = 0.0D+00
      TENDL = 2.*HAFLT
      KDTIME = 1
      if (TENDL.le.288.) then
         KDTIME = 1
      elseif (TENDL.le.8766.) then
         KDTIME = 2
      elseif (TENDL.le.105192.) then
         KDTIME = 3
      else
         KDTIME = 4
      endif
      TFACTR = TLOCAL(KDTIME)
      TIME1 = TENDL/12./TFACTR
      TIME2 = float(ifix(TIME1))
      if ((TIME1-TIME2).ge.0.5) TIME2 = TIME2+1.0
      TINCRL = 0.0D+00
      TINCRL = TFACTR*TIME2
      if (TINCRL.lt.1.) TINCRL = 1.0D+00
      TENDL = 0.0D+00
      TENDL = TINCRL*12.0D+00
      T = 0.0D+00
      TCODEG = KDTIME
      CINTG = TINCRL
      TINITG = T
      TENDG = TENDL
      do 140 K = 1, KCHEM
         SYSLDL(K) = SYSLDL(K)*TFACTR
         TRANLD(K) = TRANLD(K)*TFACTR
140   continue
      return
      end
