      subroutine M3FLUX
      include 'SIZE.INC'
      include 'GLOBAL.INC'
      include 'LOCAL.INC'
      include 'UNITS.INC'
      include 'LOCAL1.INC'
      real PCTSED, PCTWAT
      real GNDOUT,HAFLS,HAFLT,HAFLW,PERCET
     &,SOCBIO(2),SOCCHE,SOCDP,SOCHYD,SOCOUT,SOCOX,SOCPHO
     &,SOCSOX, SOCVOL, SURWAT, TOTBIO, SOCRED, TOTFLX, TFIN
     &,TLOCAL(4)
      integer I, K, III(2), IV, VRAIL
      character KOUT*2, YRCH(2)*4, ITIME(4)*6
      logical MULTYR
      data TLOCAL/1.0,24.0,730.5,8766./
      data ITIME/' hours','  days','months',' years'/
      MULTYR = .false.
      if (LASTYR.gt.FRSTYR) MULTYR = .true.
      write (YRCH(1),5000) FRSTYR
5000  format (I4)
      if (MULTYR) then
         write (YRCH(2),5000) LASTYR
         do 110 K = 1, 2
            do 100 I = 1, 4
               if (YRCH(K)(I:I).eq.' ') YRCH(K)(I:I) = '0'
100         continue
110      continue
      else
         do 120 I = 1, 4
            if (YRCH(1)(I:I).eq.' ') YRCH(1)(I:I) = '0'
120      continue
      endif
      III(1) = VRAIL(ECONAM)
      do 140 K = 1, KCHEM
         III(2) = VRAIL(CHEMNA(1,K))
         write (KOUT,5010) K
5010     format (I2)
         if (KOUT(1:1).eq.' ') KOUT(1:1) = '0'
         write (RPTLUN(MACHNO),5020) VERSN,MODEG,(ECONAM(IV),IV=1,III(1)
     &      )
         write (RPTLUN(MACHNO),5030) (CHEMNA(IV,K),IV=1,III(2))
         write (RPTLUN(MACHNO),5040)
5020  format ('1','Exposure Analysis Modeling System -- EXAMS Version ',
     &F4.2,', Mode',I2/' Ecosystem: ',50A1)
5030     format (' Chemical:  ',50A1)
5040     format (1X,63('-'))
         if (MULTYR) write (RPTLUN(MACHNO),5050) KOUT,YRCH(1),YRCH(2)
5050  format (' Table 18.',A2,'.  Sensitivity analysis of chemical fate:
     & ',A4,'-',A4,'.')
         if (.not.MULTYR) write (RPTLUN(MACHNO),5060) KOUT,YRCH(1)
5060  format (' Table 18.',A2,'.  Sensitivity analysis of chemical fate:
     & ',A4,'.')
         write (RPTLUN(MACHNO),5240)
         write (RPTLUN(MACHNO),5070)
5070     format ('    Mean Values by',11X,'Mass Flux',4X,'% of Total',2X
     &      ,'Half-Life*')
         SOCOUT = 1.E-06*YEXPO(K)/FLUXCT
         GNDOUT = 1.E-06*YGWAT(K)/FLUXCT
         SURWAT = SOCOUT-GNDOUT
         SOCVOL = 1.0E-06*YVOLK(K)/FLUXCT
         SOCHYD = 1.0E-06*YHYDR(K)/FLUXCT
         SOCOX = 1.0E-06*YOXID(K)/FLUXCT
         SOCDP = 1.0E-06*YPHOT(K)/FLUXCT
         SOCSOX = 1.E-06*YS1O2(K)/FLUXCT
         SOCRED = 1.0E-06*YRED(K)/FLUXCT
         SOCBIO(1) = 1.0E-06*YBIOW(K)/FLUXCT
         SOCBIO(2) = 1.0E-06*YBIOS(K)/FLUXCT
         SOCCHE = SOCHYD+SOCOX+SOCDP+SOCSOX+SOCRED
         TOTFLX = SOCOUT+SOCVOL+SOCBIO(1)+SOCBIO(2)+SOCCHE
         HAFLT = 168.00
         if (TOTFLX.ne.0.0) HAFLT = 0.69315*(Z(5,K)+Z(6,K))/TOTFLX
         TFIN = 2.*HAFLT
         if (TFIN .le. 288.) KDTIME = 1
         if (TFIN .gt. 288. .and. TFIN .le. 8766.) KDTIME = 2
         if (TFIN .gt. 8766. .and. TFIN .le. 105192.) KDTIME = 3
         if (TFIN .gt. 105192.) KDTIME = 4
         TFACTR = TLOCAL(KDTIME)
         write (RPTLUN(MACHNO),5080) ITIME(KDTIME),ITIME(KDTIME)
5080     format (8X,'Process',14X,'Kg/',A5,8X,'Flux',6X,A6)
         write (RPTLUN(MACHNO),5090)
5090     format (3X,16('-'),10X,10('-'),3X,10('-'),2X,10('-'))
         if (KDTIME.eq.1) go to 130
         SOCHYD = SOCHYD*TFACTR
         SOCOX = SOCOX*TFACTR
         SOCDP = SOCDP*TFACTR
         SOCSOX = SOCSOX*TFACTR
         SOCBIO(1) = SOCBIO(1)*TFACTR
         SOCBIO(2) = SOCBIO(2)*TFACTR
         SOCRED = SOCRED*TFACTR
         SOCVOL = SOCVOL*TFACTR
         SOCOUT = SOCOUT*TFACTR
         SOCCHE = SOCCHE*TFACTR
         GNDOUT = GNDOUT*TFACTR
         TOTFLX = TOTFLX*TFACTR
         SURWAT = SURWAT*TFACTR
130      continue
         if (TOTFLX.eq.0.0) TOTFLX = 1.0
         if (SOCHYD.eq.0.0) then
            write (RPTLUN(MACHNO),5100)
         else
            PERCET = 100.*SOCHYD/TOTFLX
            HAFLT = 0.69315*(Z(5,K)+Z(6,K))/SOCHYD
            write (RPTLUN(MACHNO),5100) SOCHYD,PERCET,HAFLT
         endif
5100     format (' Hydrolysis',:,17X,1PG11.4,4X,0PF6.2,4X,1PG11.4)
         if (SOCRED.eq.0.) then
            write (RPTLUN(MACHNO),5110)
         else
            PERCET = 100.*SOCRED/TOTFLX
            HAFLT = 0.69315*(Z(5,K)+Z(6,K))/SOCRED
            write (RPTLUN(MACHNO),5110) SOCRED,PERCET,HAFLT
         endif
5110     format (' Reduction',:,18X,1PG11.4,4X,0PF6.2,4X,1PG11.4)
         if (SOCOX.eq.0.0) then
            write (RPTLUN(MACHNO),5120)
         else
            PERCET = 100.*SOCOX/TOTFLX
            HAFLT = 0.69315*(Z(5,K)+Z(6,K))/SOCOX
            write (RPTLUN(MACHNO),5120) SOCOX,PERCET,HAFLT
         endif
5120  format(' Radical oxidation',:,10X,1PG11.4,4X,0PF6.2,4X,1PG11.4)
         SOCPHO = SOCDP
         if (SOCPHO.eq.0.0) then
            write (RPTLUN(MACHNO),5130)
         else
            PERCET = 100.*SOCPHO/TOTFLX
            HAFLT = 0.69315*(Z(5,K)+Z(6,K))/SOCPHO
            write (RPTLUN(MACHNO),5130) SOCPHO,PERCET,HAFLT
         endif
5130     format(' Direct photolysis',:,10X,1PG11.4,4X,0PF6.2,4X,1PG11.4)
         if (SOCSOX.eq.0.0) then
            write (RPTLUN(MACHNO),5140)
         else
            PERCET = 100.*SOCSOX/TOTFLX
            HAFLT = 0.69315*(Z(5,K)+Z(6,K))/SOCSOX
            write (RPTLUN(MACHNO),5140) SOCSOX,PERCET,HAFLT
         endif
5140     format (' Singlet oxygen oxidation',:,3X,1PG11.4,4X,0PF6.2,4X, 
     &      1PG11.4)
         CHEMPC(K) = 100.*SOCCHE/TOTFLX
         if (SOCCHE.eq.0.0) then
            write (RPTLUN(MACHNO),5150)
         else
            HAFLT = 0.69315*(Z(5,K)+Z(6,K))/SOCCHE
            write (RPTLUN(MACHNO),5150) SOCCHE,CHEMPC(K),HAFLT
         endif
5150     format ('   All Chemical Processes',:,3X,1PG11.4,4X,0PF6.2,4X, 
     &      1PG11.4)
         if (SOCBIO(1).eq.0.0) then
            write (RPTLUN(MACHNO),5160)
         else
            PERCET = 100.*SOCBIO(1)/TOTFLX
            HAFLW = 0.69315*(Z(5,K)+Z(6,K))/SOCBIO(1)
            write (RPTLUN(MACHNO),5160) SOCBIO(1),PERCET,HAFLW
         endif
5160     format (' Bacterioplankton',:,11X,1PG11.4,4X,0PF6.2,4X,1PG11.4)
         PERCET = 0.0
         if (TOTFLX.ne.0.0) PERCET = 100.*SOCBIO(2)/TOTFLX
         if (SOCBIO(2).eq.0.0) then
            write (RPTLUN(MACHNO),5170)
         else
            HAFLS = 0.69315*(Z(5,K)+Z(6,K))/SOCBIO(2)
            write (RPTLUN(MACHNO),5170) SOCBIO(2),PERCET,HAFLS
         endif
5170     format (' Benthic Bacteria',:,11X,1PG11.4,4X,0PF6.2,4X,1PG11.4)
         TOTBIO = SOCBIO(1)+SOCBIO(2)
         BIOPCT(K) = 100.*TOTBIO/TOTFLX
         if (TOTBIO.eq.0.0) then
            write (RPTLUN(MACHNO),5180)
         else
            HAFLT = 0.69315*(Z(5,K)+Z(6,K))/TOTBIO
            write (RPTLUN(MACHNO),5180) TOTBIO,BIOPCT(K),HAFLT
         endif
5180     format ('   Total Biolysis',:,11X,1PG11.4,4X,0PF6.2,4X,1PG11.4)
         EXPPCT(K) = 100.*SOCOUT/TOTFLX
         if (SURWAT.eq.0.0) then
            write (RPTLUN(MACHNO),5190)
         else
            PERCET = 100.*SURWAT/TOTFLX
            HAFLT = 0.69315*(Z(5,K)+Z(6,K))/SURWAT
            write (RPTLUN(MACHNO),5190) SURWAT,PERCET,HAFLT
         endif
5190     format (' Surface Water-borne Export',:,1X,1PG11.4,4X,0PF6.2,4X
     &      ,1PG11.4)
         if (GNDOUT.eq.0.0) then
            write (RPTLUN(MACHNO),5200)
         else
            PERCET = 100.*GNDOUT/TOTFLX
            HAFLT = 0.69315*(Z(5,K)+Z(6,K))/SURWAT
            write (RPTLUN(MACHNO),5200) GNDOUT,PERCET,HAFLT
         endif
5200     format (' Seepage export',:,13X,1PG11.4,4X,0PF6.2,4X,1PG11.4)
         VOLPCT(K) = 100.*SOCVOL/TOTFLX
         if (SOCVOL.eq.0.0) then
            write (RPTLUN(MACHNO),5210)
         else
            HAFLT = 0.69315*(Z(5,K)+Z(6,K))/SOCVOL
            write (RPTLUN(MACHNO),5210) SOCVOL,VOLPCT(K),HAFLT
         endif
5210     format (' Volatilization',:,13X,1PG11.4,4X,0PF6.2,4X,1PG11.4)
         write (RPTLUN(MACHNO),5220) TOTFLX
5220     format (29X,10('=')/' Total mass flux:',11X,1PG11.4)
         write (RPTLUN(MACHNO),5240)
         write (RPTLUN(MACHNO),5230)
5230  format (' * Pseudo-first-order estimates based on flux','/resident
     & mass;',/,'   assumes transport delays will not throttle fluxes.')
5240     format (1X,63('-'))
         write (RPTLUN(MACHNO),5020)VERSN,MODEG,(ECONAM(IV),IV=1,III(1))
         write (RPTLUN(MACHNO),5030) (CHEMNA(IV,K),IV=1,III(2))
         write (RPTLUN(MACHNO),5040)
         if (MULTYR) write (RPTLUN(MACHNO),5250) KOUT,YRCH(1),YRCH(2)
5250  format (' Table 20.',A2,'.  Exposure analysis summary: ',A4,'--', 
     &A4,'.')
         if (.not.MULTYR) write (RPTLUN(MACHNO),5260) KOUT,YRCH(1)
5260     format (' Table 20.',A2,'.  Exposure analysis summary: ',A4,'.'
     &      )
         write (RPTLUN(MACHNO),5240)
         PCTWAT = 0.0
         PCTSED = 0.0
         QTSAV(K) = Z(5,K)+Z(6,K)
         QWSAV(K) = Z(5,K)
         QSSAV(K) = Z(6,K)
         if (QTSAV(K).ne.0.0) then
            PCTWAT = 100.*QWSAV(K)/QTSAV(K)
            PCTSED = 100.*QSSAV(K)/QTSAV(K)
         endif
         write (RPTLUN(MACHNO),5270)
5270     format (                                                       
     &' Exposure Concentrations    96-h Acute  21-d Chronic   Long-Term'
     &/1X,26('='),1X,10('-'),2X,12('-'),3X,9('-'))
         write (RPTLUN(MACHNO),5272) YMIN96(2,K),YMIN21(2,K),YMINLT(2,K)
         write (RPTLUN(MACHNO),5274) YBAR96(2,K),YBAR21(2,K),YBARLT(2,K)
         write (RPTLUN(MACHNO),5276) PEAK96(2,K),PEAK21(2,K),PEAKLT(2,K)
5272     format (' Water Column      Baseline',1X,1PG10.3,2(3X,G10.3))
5274     format ('  dissolved plus   Average ',1X,1PG10.3,2(3X,G10.3))
5276     format ('  complexed mg/L   Peak    ',1X,1PG10.3,2(3X,G10.3))
         write (RPTLUN(MACHNO),5282) YMIN96(4,K),YMIN21(4,K),YMINLT(4,K)
         write (RPTLUN(MACHNO),5284) YBAR96(4,K),YBAR21(4,K),YBARLT(4,K)
         write (RPTLUN(MACHNO),5286) PEAK96(4,K),PEAK21(4,K),PEAKLT(4,K)
5282     format (' Water Column      Baseline',1X,1PG10.3,2(3X,G10.3))
5284     format ('  plankton         Average ',1X,1PG10.3,2(3X,G10.3))
5286     format ('  ug/g dry weight  Peak    ',1X,1PG10.3,2(3X,G10.3))
         write (RPTLUN(MACHNO),5292) YMIN96(7,K),YMIN21(7,K),YMINLT(7,K)
         write (RPTLUN(MACHNO),5294) YBAR96(7,K),YBAR21(7,K),YBARLT(7,K)
         write (RPTLUN(MACHNO),5296) PEAK96(7,K),PEAK21(7,K),PEAKLT(7,K)
5292     format(/' Benthic Sediment  Baseline',1X,1PG10.3,2(3X,G10.3))
5294     format ('  dissolved in     Average ',1X,1PG10.3,2(3X,G10.3))
5296     format ('  pore water mg/L  Peak    ',1X,1PG10.3,2(3X,G10.3))
         write (RPTLUN(MACHNO),5302) YMIN96(9,K),YMIN21(9,K),YMINLT(9,K)
         write (RPTLUN(MACHNO),5304) YBAR96(9,K),YBAR21(9,K),YBARLT(9,K)
         write (RPTLUN(MACHNO),5306) PEAK96(9,K),PEAK21(9,K),PEAKLT(9,K)
5302     format (' Benthic Sediment  Baseline',1X,1PG10.3,2(3X,G10.3))
5304     format ('  benthos          Average ',1X,1PG10.3,2(3X,G10.3))
5306     format ('  ug/g dry weight  Peak    ',1X,1PG10.3,2(3X,G10.3))
         write (RPTLUN(MACHNO),5340) QTSAV(K),PCTWAT,PCTSED
5340  format (/1X,'Fate:  Average Resident Mass -- kg',12X,1PG10.3,/1X,4
     &('='),6X,'Water Column',12(' .'),3X,0PF7.2,' %'/11X,'Benthic Sedim
     &ents',1X,9(' .'),3X,0PF7.2,' %')
         write (RPTLUN(MACHNO),5350) ITIME(KDTIME),TOTFLX
5350     format (8X,'Total Flux of Chemical -- kg /',A5,4X,1PG10.3)
         write (RPTLUN(MACHNO),5360) CHEMPC(K),BIOPCT(K),VOLPCT(K),
     &      EXPPCT(K)
5360  format (11X,'Chemical Transformations: ',5(' .'),2X,F8.2,' %'/11X,
     &'Biological Transformations: ',4(' .'),2X,F8.2,' %'/11X,'Volatiliz
     &ation: ',10(' .'),2X,F8.2,' %'/11X,'Water-borne Export: ',8(' .'),
     &2X,F8.2,' %')
140   continue
      return
      end
