        subroutine SUMUP
      include 'SIZE.INC'
      include 'GLOBAL.INC'
      include 'LOCAL.INC'
      include 'UNITS.INC'
        real AKS, AKW, DECTIM, HAFLS, HAFLW, PCTSED, PCTTOT
     &, PCTWAT, TIMEPR, TOTLOD
        integer III, ITIME, K2, IV, VRAIL
        character KOUT*2, PRTIME(4)*7, OUTLIN*64
        data PRTIME/' hours.','  days.','months.',' years.'/
      do 140 K2 = 1, KCHEM
         write (KOUT,5000) K2
5000     format (I2)
         if (KOUT(1:1).eq.' ') KOUT(1:1) = '0'
         III = VRAIL(ECONAM)
         write (RPTLUN(MACHNO),5010) VERSN,MODEG,(ECONAM(IV),IV=1,III)
         III = VRAIL(CHEMNA(1,K2))
         write (RPTLUN(MACHNO),5020) (CHEMNA(IV,K2),IV=1,III)
         write (RPTLUN(MACHNO),5030)
5010  format ('1','Exposure Analysis Modeling System -- EXAMS Version ',
     &F4.2,', Mode',I2/' Ecosystem: ',50A1)
5020     format (' Chemical:  ',50A1)
5030     format (1X,63('-'))
         write (RPTLUN(MACHNO),5040) KOUT
5040  format (' Table 20.',A2,'.  Exposure analysis summary.'/1X,63('-')
     &)
         if (QTSAV(K2).ne.0.0) then
            PCTWAT = 100.*QWSAV(K2)/QTSAV(K2)
            PCTSED = 100.*QSSAV(K2)/QTSAV(K2)
         else
            PCTWAT = 0.0
            PCTSED = 0.0
         endif
         write (RPTLUN(MACHNO),5050) DOMAX(2,K2),DOMAX(1,K2),DOMAX(7,K2)
     &      ,DOMAX(6,K2)
5050  format (1X,'Exposure (maximum steady-state concentrations):'/2X,'W
     &ater column:',1PG10.3,' mg/L dissolved; total =',G10.3,' mg/L'/2X,
     &'Benthic sediments:',G10.3,' mg/L dissolved in pore water;'/4X,'ma
     &ximum total concentration =',G10.3,' mg/kg (dry weight).')
         write (OUTLIN,5060) DOMAX(4,K2),DOMAX(9,K2)
5060  format ('  Biota (ug/g dry weight): Plankton:',1PG9.2,' Benthos:',
     &G9.2)
         if (DOMAX(4,K2).eq.0.0) OUTLIN(37:45) = '         '
         if (DOMAX(9,K2).eq.0.0) OUTLIN(55:63) = '         '
         write (RPTLUN(MACHNO),5070) OUTLIN
5070     format (A64)
         write (RPTLUN(MACHNO),5080) QTSAV(K2),PCTWAT,PCTSED
5080     format (/1X,'Fate:'/1X,' Total steady-state accumulation:',    
     &      1PG10.3,' kg, with',0PF7.2,'%'/4X,'in the water column and',
     &      F6.2,'% in the benthic',' sediments.')
         TOTLOD = SYSLDL(K2)+TRANLD(K2)
         write (RPTLUN(MACHNO),5090) TOTLOD,PRTIME(KDTIME),CHEMPC(K2)
5090  format ('  Total chemical load:',1PG9.2,' kg/',A5,'.  Disposition:
     &',0PF7.2,'%')
         write (RPTLUN(MACHNO),5100) BIOPCT(K2),VOLPCT(K2),EXPPCT(K2)
5100  format (4X,'chemically transformed,',F7.2,'% biotransformed,',F7.2
     &,'%'/4X,'volatilized, and',F7.2,'% exported via other pathways.')
         if (IFLAG.ge.8) go to 130
         HAFLW = 0.
         HAFLS = 0.
         if (Z(5,K2).lt.0.0) Z(5,K2) = 0.0
         if (Z(6,K2).lt.0.0) Z(6,K2) = 0.0
         if (Z(5,K2).gt.QWSAV(K2)) Z(5,K2) = QWSAV(K2)
         if (Z(6,K2).gt.QSSAV(K2)) Z(6,K2) = QSSAV(K2)
         if (Z(5,K2).gt.0.) AKW = TFACTR*(-alog(Z(5,K2)/QWSAV(K2)))/
     &      TENDL
         if (Z(6,K2).gt.0.) AKS = TFACTR*(-alog(Z(6,K2)/QSSAV(K2)))/
     &      TENDL
         if (Z(5,K2).gt.0..and.AKW.ne.0.) HAFLW = 0.69315/AKW
         if (Z(6,K2).gt.0..and.AKS.ne.0.) HAFLS = 0.69315/AKS
         TIMEPR = TENDL/TFACTR
         write (RPTLUN(MACHNO),5110) TIMEPR,PRTIME(KDTIME)
5110  format (/1X,'Persistence:'/2X,'After',1PG10.3,' ',A6,' of recovery
     & time, the water column had')
         DECTIM = 5.*((PCTWAT/100.)*HAFLW+(PCTSED/100.)*HAFLS)
         PCTWAT = 0.0
         PCTSED = 0.0
         PCTTOT = 0.0
         if (QWSAV(K2).ne.0.0) PCTWAT = 100.*(1.-(Z(5,K2)/QWSAV(K2)))
         if (QSSAV(K2).ne.0.0) PCTSED = 100.*(1.-(Z(6,K2)/QSSAV(K2)))
         if (QTSAV(K2).ne.0.0) PCTTOT = 100.*(1.-((Z(5,K2)+Z(6,K2))/
     &      QTSAV(K2)))
         write (RPTLUN(MACHNO),5120) PCTWAT,PCTSED,PCTTOT
5120  format (2X,'lost',F7.2,'% of its initial chemical burden;',' the b
     &enthic zone'/2X,'had lost',F7.2,'%;',' system-wide total loss of c
     &hemical =',F6.1,'%.')
         ITIME = KDTIME
         if (ITIME.eq.1.and.DECTIM.le.96.) go to 120
         if (ITIME.ne.1) go to 100
         DECTIM = DECTIM/24.
         ITIME = 2
100      continue
         if (ITIME.eq.2.and.DECTIM.le.90.) go to 120
         if (ITIME.ne.2) go to 110
         DECTIM = DECTIM/30.4375
         ITIME = 3
110      continue
         if (ITIME.eq.3.and.DECTIM.le.96.) go to 120
         if (ITIME.ne.3) go to 120
         DECTIM = DECTIM/12.
         ITIME = 4
120      continue
         if (Z(5,K2).eq.QWSAV(K2).or.Z(6,K2).eq.QSSAV(K2)) go to 140
         write (RPTLUN(MACHNO),5130) DECTIM,PRTIME(ITIME)
5130     format ('  Five half-lives (>95% cleanup) thus require ca.',   
     &      F7.0,1X,A7)
130      continue
140   continue
      return
      end
