@ECHO OFF
CLS
ECHO #
ECHO ##  FEMWATER CLFEMW3D batch command file.
ECHO #
REM 
ECHO #                                           >CLFEMW3D.LOG
ECHO ##  FEMWATER CLFEMW3D batch command file.  >>CLFEMW3D.LOG
ECHO #   Lahey FORTRAN F77L-EM/32 version 5.01. >>CLFEMW3D.LOG            
ECHO #                                          >>CLFEMW3D.LOG
GOTO START
REM 
REM  ****************** \FEMWATER\CLFEMW3D.BAT ******************
REM  *        Author: D.W. Disney, Computer Scientist           *
REM  *                Computer Sciences Corporation             *
REM  *          Date: Friday, 2 July 1993.  Time: 08:08:08.     *
REM  *   Environment: Microway 486-B2T under MS DOS 5.0         *
REM  *  Installation: Computer Sciences Corporation             *
REM  *                U.S. Environmental Protection Agency      *
REM  *                Athens ERL - Athens, Georgia              *
REM  *      Function: To complile and link all FORTRAN 77       *
REM  *                source code files for the FEMWATER model. *
REM  *      Calling                                             *
REM  *      Sequence: CLFEMW3D                                  *
REM  *         Input: None                                      *
REM  ************************************************************
REM
REM **************************************************************
REM *         Maintenance History - \FEMWATER\CLFEMW3D.BAT       *
REM *------------------------------------------------------------*
REM *  1) Initial coding                                         *
REM *     Date: Friday, 2 July 1993.  Time: 08:08:37.            *
REM **************************************************************
REM *  Compile and link the FEMWATER model under Lahey FORTRAN   *
REM *  F77L-EM/32 compiler and Phar Lap Linker 386LINK for       *
REM *  32-bit extended (protected) mode execution environment.   *
REM *                                                            *
REM *       Program       Version                                *
REM *       -------       -------                                *
REM *       F77L3       -   5.01                                 *
REM *       INTERACTER  -   x.xx                                 *
REM *       386LINK     -   4.1L                                 *
REM *       MS DOS      -   5.01                                 *
REM **************************************************************
REM *  \FEMWATER\CLFEMW3D.BAT                                    *
REM *------------------------------------------------------------*
REM *  The program assumes that                                  *
REM *       1)  All F77L3 commands and files are stored in the   *
REM *           root sub-directory \F77L3 on drive D:.           *
REM *       2)  All Phar Lap commands and files are stored in    *
REM *           the root sub-directory \F77L3 on drive D:.       *
REM *       3)  All INTERACTER libraries are in the root sub-    *
REM *           directory \INTERACT on drive D:.                 *
REM *       4)  All FEMWATER command files are in the sub-       *
REM *           directory \FEMWATER on drive E:.                 *
REM *       5)  All FEMWATER source code files (*.FOR) and       *
REM *           source code include files (*.INC) are stored in  *
REM *           the \FEMWATER\FEMWCODE sub-directory on drive E:.*
REM *       6)  The compile and link edit command file           *
REM *           CLFEMW3D.BAT is stored in the sub-directory      *
REM *           \FEMWATER on drive E:.                           *
REM *       7)  The FEMWATER link edit command file FEMWF77L.LNK *
REM *           is stored in the sub-directory \FEMWATER on      *
REM *           drive E:.                                        *
REM *       8)  The FEMWATER object code files (*.OBJ) are       *
REM *           stored in the \FEMWATER\FEMW_OBJ sub-directory   *
REM *           on drive E:.                                     *
REM **************************************************************
REM
:START
CLS
ECHO #
ECHO ##  Setting system environment variables.
ECHO #
PATH C:.;C:\;D:\F77L3;D:\F77L3\BIN;C:\DOS;D:\UTIL;C:\BRIEF;C:\WP51 >NUL
SET OBJ=
SET PROFORT.ERR=
SET LIB=
SET TMP=
SET RMFORT.CER=
SET RMFORT.CER=
SET \RMFORT.CER=
SET \RMFORT.ERR=
SET \F77L.CER=
SET \F77L.EER=
SET TMP=
SET OBJ=D:\F77L3\BIN;F:\FEMWATER\FEMW_OBJ
SET LFDIR=D:\F77L3\BIN
SET INIT=D:\F77L3\BIN
SET LBDIR=D:\F77L3\BIN
SET LBCFG=D:\F77L3\BIN\LB.CFG
SET LBKEY=D:\F77L3\BIN\LB.KEY
SET LBMAC=D:\F77L3\BIN\LB.MAC
SET LBPST=D:\F77L3\BIN\LB.PST
SET LBLNG=D:\F77L3\BIN\LB.LNG
REM
CLS
ECHO #
ECHO ##  Cleaning up extra work files...wait.
ECHO #
IF EXIST FEMWATER.MAP DEL FEMWATER.MAP >>CLFEMW3D.LOG
IF EXIST XFEMWATX.EXE DEL XFEMWATX.EXE >>CLFEMW3D.LOG
IF EXIST        *.OBJ DEL        *.OBJ >>CLFEMW3D.LOG
REM IF EXIST        *.LST DEL        *.LST >>CLFEMW3D.LOG
REM
IF NOT EXIST FEMW_OBJ\NUL MKDIR FEMW_OBJ >>CLFEMW3D.LOG
REM
IF "%1"=="Y" GOTO YESDEL
IF "%1"=="y" GOTO YESDEL
IF "%1"=="N" GOTO NODEL
IF "%1"=="n" GOTO NODEL
:GETANS
SET ANSWER=
ANSWER     Delete existing FEMWATER program object files (*.OBJ)? (Y/N) 
IF "%ANSWER%"=="N" GOTO NODEL
IF "%ANSWER%"=="n" GOTO NODEL
IF "%ANSWER%"==""  GOTO NODEL
IF "%ANSWER%"=="Y" GOTO YESDEL
IF "%ANSWER%"=="y" GOTO YESDEL
GOTO GETANS
:YESDEL
IF EXIST FEMW_OBJ\*.OBJ DEL FEMW_OBJ\*.OBJ >>CLFEMW3D.LOG
IF EXIST          *.OBJ DEL          *.OBJ >>CLFEMW3D.LOG
:NODEL
SET ANSWER=
REM IF EXIST *.LST DEL *.LST >>CLFEMW3D.LOG
CLS
VERIFY OFF
BREAK ON
ECHO #
ECHO ##  Ready to begin FEMWATER compile and link edit.
ECHO #   Press "<Ctrl><P>" to echo results to printer.
ECHO #
ECHO #   Press the "<Enter>" key to continue.
PAUSE >NUL
CLS
REM
ECHO #
ECHO ##  Copying all FEMWATER source code INCLUDE files to \FEMWATER directory.
ECHO #
IF EXIST FEMWCODE\*.INC COPY FEMWCODE\*.INC /V >>CLFEMW3D.LOG
CLS
REM
ECHO #
ECHO ##  Compile for FEMWATER in progress with F77L3 FORTRAN.
ECHO #
REM
ECHO #                                                        >>CLFEMW3D.LOG
ECHO ## FEMWATER CLFEMW3D batch command file begin execution. >>CLFEMW3D.LOG
ECHO #                                                        >>CLFEMW3D.LOG
ECHO #                                                        >>CLFEMW3D.LOG
ECHO ## Start date and time.                                  >>CLFEMW3D.LOG
ECHO #                                                        >>CLFEMW3D.LOG
ECHO # -------- DATE ---------                                >>CLFEMW3D.LOG
ECHO #                                                        >>CLFEMW3D.LOG
DATE <RETURN1.ANS | FIND "C"                                  >>CLFEMW3D.LOG
ECHO #                                                        >>CLFEMW3D.LOG
ECHO # -------- TIME ---------                                >>CLFEMW3D.LOG
ECHO #                                                        >>CLFEMW3D.LOG
TIME <RETURN1.ANS | FIND "C"                                  >>CLFEMW3D.LOG
ECHO #                                                        >>CLFEMW3D.LOG
ECHO # -----------------------                                >>CLFEMW3D.LOG
ECHO #                                                        >>CLFEMW3D.LOG
CLS
REM IF NOT EXIST FEMWATER\FEMWATER_OBJ\source.OBJ   F77L3 FEMWATER\source.FOR, FEMWATER\FEMWATER_OBJ\source.OBJ, listfile, SOLDfile /O
REM --------------------------------------------------------------------------
@ECHO ON
REM --------------------------------------------------------
IF NOT EXIST FEMW_OBJ\FEMWAT3D.OBJ F77L3 FEMWCODE\FEMWAT3D.FOR, FEMW_OBJ\FEMWAT3D.OBJ,, /O >>CLFEMW3D.LOG
IF NOT EXIST FEMW_OBJ\ALLFCT.OBJ   F77L3 FEMWCODE\ALLFCT.FOR, FEMW_OBJ\ALLFCT.OBJ,, >>CLFEMW3D.LOG
IF NOT EXIST FEMW_OBJ\ASEMBL.OBJ   F77L3 FEMWCODE\ASEMBL.FOR, FEMW_OBJ\ASEMBL.OBJ,, >>CLFEMW3D.LOG
IF NOT EXIST FEMW_OBJ\BASE.OBJ     F77L3 FEMWCODE\BASE.FOR, FEMW_OBJ\BASE.OBJ,, >>CLFEMW3D.LOG
IF NOT EXIST FEMW_OBJ\BC.OBJ       F77L3 FEMWCODE\BC.FOR, FEMW_OBJ\BC.OBJ,, >>CLFEMW3D.LOG
IF NOT EXIST FEMW_OBJ\BCPREP.OBJ   F77L3 FEMWCODE\BCPREP.FOR, FEMW_OBJ\BCPREP.OBJ,, >>CLFEMW3D.LOG
IF NOT EXIST FEMW_OBJ\BLKITR.OBJ   F77L3 FEMWCODE\BLKITR.FOR, FEMW_OBJ\BLKITR.OBJ,, >>CLFEMW3D.LOG
IF NOT EXIST FEMW_OBJ\CLRSCR.OBJ   F77L3 FEMWCODE\CLRSCR.FOR, FEMW_OBJ\CLRSCR.OBJ,, >>CLFEMW3D.LOG
IF NOT EXIST FEMW_OBJ\DATAIN.OBJ   F77L3 FEMWCODE\DATAIN.FOR, FEMW_OBJ\DATAIN.OBJ,, >>CLFEMW3D.LOG
IF NOT EXIST FEMW_OBJ\GW3D.OBJ     F77L3 FEMWCODE\GW3D.FOR, FEMW_OBJ\GW3D.OBJ,, >>CLFEMW3D.LOG
IF NOT EXIST FEMW_OBJ\PAGEN.OBJ    F77L3 FEMWCODE\PAGEN.FOR, FEMW_OBJ\PAGEN.OBJ,, >>CLFEMW3D.LOG
IF NOT EXIST FEMW_OBJ\PRINTT.OBJ   F77L3 FEMWCODE\PRINTT.FOR, FEMW_OBJ\PRINTT.OBJ,, >>CLFEMW3D.LOG
IF NOT EXIST FEMW_OBJ\Q4S.OBJ      F77L3 FEMWCODE\Q4S.FOR, FEMW_OBJ\Q4S.OBJ,, >>CLFEMW3D.LOG
IF NOT EXIST FEMW_OBJ\Q8.OBJ       F77L3 FEMWCODE\Q8.FOR, FEMW_OBJ\Q8.OBJ,, >>CLFEMW3D.LOG
IF NOT EXIST FEMW_OBJ\Q8DV.OBJ     F77L3 FEMWCODE\Q8DV.FOR, FEMW_OBJ\Q8DV.OBJ,, >>CLFEMW3D.LOG
IF NOT EXIST FEMW_OBJ\Q8TH.OBJ     F77L3 FEMWCODE\Q8TH.FOR, FEMW_OBJ\Q8TH.OBJ,, >>CLFEMW3D.LOG
IF NOT EXIST FEMW_OBJ\READN.OBJ    F77L3 FEMWCODE\READN.FOR, FEMW_OBJ\READN.OBJ,, >>CLFEMW3D.LOG
IF NOT EXIST FEMW_OBJ\READR.OBJ    F77L3 FEMWCODE\READR.FOR, FEMW_OBJ\READR.OBJ,, >>CLFEMW3D.LOG
IF NOT EXIST FEMW_OBJ\SFLOW.OBJ    F77L3 FEMWCODE\SFLOW.FOR, FEMW_OBJ\SFLOW.OBJ,, >>CLFEMW3D.LOG
IF NOT EXIST FEMW_OBJ\SOLVE.OBJ    F77L3 FEMWCODE\SOLVE.FOR, FEMW_OBJ\SOLVE.OBJ,, >>CLFEMW3D.LOG
IF NOT EXIST FEMW_OBJ\SPROP.OBJ    F77L3 FEMWCODE\SPROP.FOR, FEMW_OBJ\SPROP.OBJ,, >>CLFEMW3D.LOG
IF NOT EXIST FEMW_OBJ\STORE.OBJ    F77L3 FEMWCODE\STORE.FOR, FEMW_OBJ\STORE.OBJ,, >>CLFEMW3D.LOG
IF NOT EXIST FEMW_OBJ\SURF.OBJ     F77L3 FEMWCODE\SURF.FOR, FEMW_OBJ\SURF.OBJ,, >>CLFEMW3D.LOG
IF NOT EXIST FEMW_OBJ\VELT.OBJ     F77L3 FEMWCODE\VELT.FOR, FEMW_OBJ\VELT.OBJ,, >>CLFEMW3D.LOG
REM --------------------------------------------------------
@ECHO OFF
REM -----------------------------------------------------------------------------------
CLS
ECHO #
ECHO ##  FEMWATER compilation complete with F77L3 FORTRAN.
ECHO #
ECHO #                                 >>CLFEMW3D.LOG
ECHO ## FEMWATER compilation complete. >>CLFEMW3D.LOG
ECHO #                                 >>CLFEMW3D.LOG
ECHO #                                 >>CLFEMW3D.LOG
ECHO ## End date and time.             >>CLFEMW3D.LOG
ECHO #                                 >>CLFEMW3D.LOG
ECHO # -------- DATE ---------         >>CLFEMW3D.LOG
ECHO #                                 >>CLFEMW3D.LOG
DATE <RETURN1.ANS | FIND "C"           >>CLFEMW3D.LOG
ECHO #                                 >>CLFEMW3D.LOG
ECHO # -------- TIME ---------         >>CLFEMW3D.LOG
ECHO #                                 >>CLFEMW3D.LOG
TIME <RETURN1.ANS | FIND "C"           >>CLFEMW3D.LOG
ECHO #                                 >>CLFEMW3D.LOG
ECHO # -----------------------         >>CLFEMW3D.LOG
ECHO #                                 >>CLFEMW3D.LOG
ECHO #
IF EXIST *.INC DEL *.INC
CLS
REM
ECHO #
ECHO ##  Ready to link FEMWATER.
ECHO #
ECHO #   Press the "<Enter>" key to continue.
PAUSE >NUL
REM
IF NOT EXIST FEMW_OBJ\*.OBJ GOTO NOLINK
REM
CLS
ECHO #   
ECHO ##  Beginning 386LINK for FEMWATER code...wait.
ECHO #   
ECHO #                                       >>CLFEMW3D.LOG
ECHO ## Beginning 386LINK for FEMWATER code. >>CLFEMW3D.LOG
ECHO #                                       >>CLFEMW3D.LOG
ECHO #                                       >>CLFEMW3D.LOG
ECHO ## Begin date and time.                 >>CLFEMW3D.LOG
ECHO #                                       >>CLFEMW3D.LOG
ECHO # -------- DATE ---------               >>CLFEMW3D.LOG
ECHO #                                       >>CLFEMW3D.LOG
DATE <RETURN1.ANS | FIND "C"                 >>CLFEMW3D.LOG
ECHO #                                       >>CLFEMW3D.LOG
ECHO # -------- TIME ---------               >>CLFEMW3D.LOG
ECHO #                                       >>CLFEMW3D.LOG
TIME <RETURN1.ANS | FIND "C"                 >>CLFEMW3D.LOG
ECHO #                                       >>CLFEMW3D.LOG
ECHO # -----------------------               >>CLFEMW3D.LOG
ECHO #                                       >>CLFEMW3D.LOG
ECHO #
SET LIB=D:\F77L3\LIB
CLS
@ECHO ON
@ECHO.
REM ----------------------------------------------------------
IF NOT EXIST XFEMWATX.EXE 386LINK @FEMWF77L.LNK >>CLFEMW3D.LOG
REM ----------------------------------------------------------
@ECHO OFF
SET LIB=
ECHO #
ECHO # -----------------
ECHO #   
ECHO ##  386LINK complete for FEMWATER code.
ECHO #   
ECHO #                                   >>CLFEMW3D.LOG
ECHO ## Link complete for FEMWATER code. >>CLFEMW3D.LOG
ECHO #                                   >>CLFEMW3D.LOG
ECHO #                                   >>CLFEMW3D.LOG
ECHO ## End date and time.               >>CLFEMW3D.LOG
ECHO #                                   >>CLFEMW3D.LOG
ECHO # -------- DATE ---------           >>CLFEMW3D.LOG
ECHO #                                   >>CLFEMW3D.LOG
DATE <RETURN1.ANS | FIND "C"             >>CLFEMW3D.LOG
ECHO #                                   >>CLFEMW3D.LOG
ECHO # -------- TIME ---------           >>CLFEMW3D.LOG
ECHO #                                   >>CLFEMW3D.LOG
TIME <RETURN1.ANS | FIND "C"             >>CLFEMW3D.LOG
ECHO #                                   >>CLFEMW3D.LOG
ECHO # -----------------------           >>CLFEMW3D.LOG
ECHO #                                   >>CLFEMW3D.LOG
ECHO #   Press the "<Enter>" key to continue.
PAUSE >NUL
:NOLINK
CLS
ECHO #
ECHO ##  FEMWATER compilation/link complete...deleting work files...wait.
ECHO #
REM
ECHO #                                               >>CLFEMW3D.LOG
ECHO ## FEMWATER CLFEMW3D.BAT command file complete. >>CLFEMW3D.LOG
ECHO #                                               >>CLFEMW3D.LOG
ECHO #                                               >>CLFEMW3D.LOG
ECHO ## End date and time.                           >>CLFEMW3D.LOG
ECHO #                                               >>CLFEMW3D.LOG
ECHO # -------- DATE ---------                       >>CLFEMW3D.LOG
ECHO #                                               >>CLFEMW3D.LOG
DATE <RETURN1.ANS | FIND "C"                         >>CLFEMW3D.LOG
ECHO #                                               >>CLFEMW3D.LOG
ECHO # -------- TIME ---------                       >>CLFEMW3D.LOG
ECHO #                                               >>CLFEMW3D.LOG
TIME <RETURN1.ANS | FIND "C"                         >>CLFEMW3D.LOG
ECHO #                                               >>CLFEMW3D.LOG
ECHO # -----------------------                       >>CLFEMW3D.LOG
ECHO #                                               >>CLFEMW3D.LOG
ECHO #
REM
REM PRINT CLFEMW3D.LOG <RETURN1.ANS >NUL
REM
CLS
ECHO #
ECHO ##  Compilation and link for all FEMWATER code complete.
ECHO #   Press "<Ctrl><P>" if previously selected for printing.
ECHO #
ECHO #   Press the "<Enter>" key to continue.
PAUSE >NUL
CLS
IF NOT EXIST *.EXE GOTO NOEXE
ECHO #
ECHO ##  FEMWATER task image ready for test execution.
ECHO #
ECHO.
DIR *.EXE | FIND " EXE"
ECHO.
ECHO #   To execute FEMWATER, type
ECHO #
ECHO #                       FEMWATER
ECHO #
ECHO #   at the DOS system prompt, then press the "<Enter>" key.
ECHO.
:NOEXE
REM
REM ********************************************************
REM *  End compile batch command E:\FEMWATER\CLFEMW3D.BAT. *
REM ********************************************************
