@ECHO OFF
CLS
ECHO #
ECHO ##  LEWAST3D CLLEWT3D batch command file.
ECHO #
REM 
ECHO #                                           >CLLEWT3D.LOG
ECHO ##  LEWAST3D CLLEWT3D batch command file.  >>CLLEWT3D.LOG
ECHO #   Lahey FORTRAN F77L-EM/32 version 5.01. >>CLLEWT3D.LOG            
ECHO #                                          >>CLLEWT3D.LOG
GOTO START
REM 
REM  ****************** \FEMWATER\CLLEWT3D.BAT ******************
REM  *        Author: D.W. Disney, Computer Scientist           *
REM  *                Computer Sciences Corporation             *
REM  *          Date: Friday, 2 July 1993.  Time: 08:08:08.     *
REM  *   Environment: Microway 486-B2T under MS DOS 5.0         *
REM  *  Installation: Computer Sciences Corporation             *
REM  *                U.S. Environmental Protection Agency      *
REM  *                Athens ERL - Athens, Georgia              *
REM  *      Function: To complile and link all FORTRAN 77       *
REM  *                source code files for the LEWAST3D model. *
REM  *      Calling                                             *
REM  *      Sequence: CLLEWT3D                                  *
REM  *         Input: None                                      *
REM  ************************************************************
REM
REM **************************************************************
REM *         Maintenance History - \FEMWATER\CLLEWT3D.BAT       *
REM *------------------------------------------------------------*
REM *  1) Initial coding                                         *
REM *     Date: Wednesday, 21 July 1993.  Time: 08:13:14.        *
REM **************************************************************
REM *  Compile and link the LEWAST3D model under Lahey FORTRAN   *
REM *  F77L-EM/32 compiler and Phar Lap Linker 386LINK for       *
REM *  32-bit extended (protected) mode execution environment.   *
REM *                                                            *
REM *       Program       Version                                *
REM *       -------       -------                                *
REM *       F77L3       -   5.01                                 *
REM *       INTERACTER  -   x.xx                                 *
REM *       386LINK     -   4.1L                                 *
REM *       MS DOS      -   5.01                                 *
REM **************************************************************
REM *  \FEMWATER\CLLEWT3D.BAT                                    *
REM *------------------------------------------------------------*
REM *  The program assumes that                                  *
REM *       1)  All F77L3 commands and files are stored in the   *
REM *           root sub-directory \F77L3 on drive D:.           *
REM *       2)  All Phar Lap commands and files are stored in    *
REM *           the root sub-directory \F77L3 on drive D:.       *
REM *       3)  All INTERACTER libraries are in the root sub-    *
REM *           directory \INTERACT on drive D:.                 *
REM *       4)  All LEWAST3D command files are in the sub-       *
REM *           directory \FEMWATER on drive E:.                 *
REM *       5)  All LEWAST3D source code files (*.FOR) and       *
REM *           source code include files (*.INC) are stored in  *
REM *           the \FEMWATER\LEWTCODE sub-directory on drive E:.*
REM *       6)  The compile and link edit command file           *
REM *           CLLEWT3D.BAT is stored in the sub-directory      *
REM *           \FEMWATER on drive E:.                           *
REM *       7)  The LEWAST3D link edit command file LEWTF77L.LNK *
REM *           is stored in the sub-directory \FEMWATER on      *
REM *           drive E:.                                        *
REM *       8)  The LEWAST3D object code files (*.OBJ) are       *
REM *           stored in the \FEMWATER\LEWT_OBJ sub-directory   *
REM *           on drive E:.                                     *
REM **************************************************************
REM
:START
CLS
ECHO #
ECHO ##  Setting system environment variables.
ECHO #
PATH C:.;C:\;D:\F77L3;D:\F77L3\BIN;C:\DOS;D:\UTIL;C:\BRIEF;C:\WP51 >NUL
SET OBJ=
SET PROFORT.ERR=
SET LIB=
SET TMP=
SET RMFORT.CER=
SET RMFORT.CER=
SET \RMFORT.CER=
SET \RMFORT.ERR=
SET \F77L.CER=
SET \F77L.EER=
SET TMP=
SET OBJ=D:\F77L3\BIN;F:\FEMWATER\LEWT_OBJ
SET LFDIR=D:\F77L3\BIN
SET INIT=D:\F77L3\BIN
SET LBDIR=D:\F77L3\BIN
SET LBCFG=D:\F77L3\BIN\LB.CFG
SET LBKEY=D:\F77L3\BIN\LB.KEY
SET LBMAC=D:\F77L3\BIN\LB.MAC
SET LBPST=D:\F77L3\BIN\LB.PST
SET LBLNG=D:\F77L3\BIN\LB.LNG
REM
CLS
ECHO #
ECHO ##  Cleaning up extra work files...wait.
ECHO #
IF EXIST LEWAST3D.MAP DEL LEWAST3D.MAP >>CLLEWT3D.LOG
IF EXIST XLEWASTX.EXE DEL XLEWASTX.EXE >>CLLEWT3D.LOG
IF EXIST        *.OBJ DEL        *.OBJ >>CLLEWT3D.LOG
REM IF EXIST        *.LST DEL        *.LST >>CLLEWT3D.LOG
REM
IF NOT EXIST LEWT_OBJ\NUL MKDIR LEWT_OBJ >>CLLEWT3D.LOG
REM
IF "%1"=="Y" GOTO YESDEL
IF "%1"=="y" GOTO YESDEL
IF "%1"=="N" GOTO NODEL
IF "%1"=="n" GOTO NODEL
:GETANS
SET ANSWER=
ANSWER     Delete existing LEWASTE program object files (*.OBJ)? (Y/N) 
IF "%ANSWER%"=="N" GOTO NODEL
IF "%ANSWER%"=="n" GOTO NODEL
IF "%ANSWER%"==""  GOTO NODEL
IF "%ANSWER%"=="Y" GOTO YESDEL
IF "%ANSWER%"=="y" GOTO YESDEL
GOTO GETANS
:YESDEL
IF EXIST LEWT_OBJ\*.OBJ DEL LEWT_OBJ\*.OBJ >>CLLEWT3D.LOG
IF EXIST          *.OBJ DEL          *.OBJ >>CLLEWT3D.LOG
:NODEL
SET ANSWER=
REM IF EXIST *.LST DEL *.LST >>CLLEWT3D.LOG
CLS
VERIFY OFF
BREAK ON
ECHO #
ECHO ##  Ready to begin LEWAST3D compile and link edit.
ECHO #   Press "<Ctrl><P>" to echo results to printer.
ECHO #
ECHO #   Press the "<Enter>" key to continue.
PAUSE >NUL
CLS
REM
ECHO #
ECHO ##  Copying all LEWAST3D source code INCLUDE files to \FEMWATER directory.
ECHO #
IF EXIST LEWTCODE\*.INC COPY LEWTCODE\*.INC /V >>CLLEWT3D.LOG
CLS
REM
ECHO #
ECHO ##  Compile for LEWAST3D in progress with F77L3 FORTRAN.
ECHO #
REM
ECHO #                                                        >>CLLEWT3D.LOG
ECHO ## LEWAST3D CLLEWT3D batch command file begin execution. >>CLLEWT3D.LOG
ECHO #                                                        >>CLLEWT3D.LOG
ECHO #                                                        >>CLLEWT3D.LOG
ECHO ## Start date and time.                                  >>CLLEWT3D.LOG
ECHO #                                                        >>CLLEWT3D.LOG
ECHO # -------- DATE ---------                                >>CLLEWT3D.LOG
ECHO #                                                        >>CLLEWT3D.LOG
DATE <RETURN1.ANS | FIND "C"                                  >>CLLEWT3D.LOG
ECHO #                                                        >>CLLEWT3D.LOG
ECHO # -------- TIME ---------                                >>CLLEWT3D.LOG
ECHO #                                                        >>CLLEWT3D.LOG
TIME <RETURN1.ANS | FIND "C"                                  >>CLLEWT3D.LOG
ECHO #                                                        >>CLLEWT3D.LOG
ECHO # -----------------------                                >>CLLEWT3D.LOG
ECHO #                                                        >>CLLEWT3D.LOG
CLS
REM IF NOT EXIST FEMWATER\LEWAST3D_OBJ\source.OBJ   F77L3 FEMWATER\source.FOR, FEMWATER\LEWAST3D_OBJ\source.OBJ, listfile, SOLDfile /O
REM --------------------------------------------------------------------------
@ECHO ON
REM --------------------------------------------------------
IF NOT EXIST LEWT_OBJ\LEWAST3D.OBJ F77L3 LEWTCODE\LEWAST3D.FOR, LEWT_OBJ\LEWAST3D.OBJ,, /O >>CLLEWT3D.LOG
IF NOT EXIST LEWT_OBJ\ADVBC.OBJ    F77L3 LEWTCODE\ADVBC.FOR, LEWT_OBJ\ADVBC.OBJ,, >>CLLEWT3D.LOG
IF NOT EXIST LEWT_OBJ\AFABTA.OBJ   F77L3 LEWTCODE\AFABTA.FOR, LEWT_OBJ\AFABTA.OBJ,, >>CLLEWT3D.LOG
IF NOT EXIST LEWT_OBJ\ALLFCT.OBJ   F77L3 LEWTCODE\ALLFCT.FOR, LEWT_OBJ\ALLFCT.OBJ,, >>CLLEWT3D.LOG
IF NOT EXIST LEWT_OBJ\ASEMBL.OBJ   F77L3 LEWTCODE\ASEMBL.FOR, LEWT_OBJ\ASEMBL.OBJ,, >>CLLEWT3D.LOG
IF NOT EXIST LEWT_OBJ\BC.OBJ       F77L3 LEWTCODE\BC.FOR, LEWT_OBJ\BC.OBJ,, >>CLLEWT3D.LOG
IF NOT EXIST LEWT_OBJ\BLKITR.OBJ   F77L3 LEWTCODE\BLKITR.FOR, LEWT_OBJ\BLKITR.OBJ,, >>CLLEWT3D.LOG
IF NOT EXIST LEWT_OBJ\BTGN.OBJ     F77L3 LEWTCODE\BTGN.FOR, LEWT_OBJ\BTGN.OBJ,, >>CLLEWT3D.LOG
IF NOT EXIST LEWT_OBJ\CLRSCR.OBJ   F77L3 LEWTCODE\CLRSCR.FOR, LEWT_OBJ\CLRSCR.OBJ,, >>CLLEWT3D.LOG
IF NOT EXIST LEWT_OBJ\DATAIN.OBJ   F77L3 LEWTCODE\DATAIN.FOR, LEWT_OBJ\DATAIN.OBJ,, >>CLLEWT3D.LOG
IF NOT EXIST LEWT_OBJ\FLUX.OBJ     F77L3 LEWTCODE\FLUX.FOR, LEWT_OBJ\FLUX.OBJ,, >>CLLEWT3D.LOG
IF NOT EXIST LEWT_OBJ\GM3D.OBJ     F77L3 LEWTCODE\GM3D.FOR, LEWT_OBJ\GM3D.OBJ,, >>CLLEWT3D.LOG
IF NOT EXIST LEWT_OBJ\LOCQ8.OBJ    F77L3 LEWTCODE\LOCQ8.FOR, LEWT_OBJ\LOCQ8.OBJ,, >>CLLEWT3D.LOG
IF NOT EXIST LEWT_OBJ\PAGEN.OBJ    F77L3 LEWTCODE\PAGEN.FOR, LEWT_OBJ\PAGEN.OBJ,, >>CLLEWT3D.LOG
IF NOT EXIST LEWT_OBJ\PLANE.OBJ    F77L3 LEWTCODE\PLANE.FOR, LEWT_OBJ\PLANE.OBJ,, >>CLLEWT3D.LOG
IF NOT EXIST LEWT_OBJ\PRINTT.OBJ   F77L3 LEWTCODE\PRINTT.FOR, LEWT_OBJ\PRINTT.OBJ,, >>CLLEWT3D.LOG
IF NOT EXIST LEWT_OBJ\Q4ADB.OBJ    F77L3 LEWTCODE\Q4ADB.FOR, LEWT_OBJ\Q4ADB.OBJ,, >>CLLEWT3D.LOG
IF NOT EXIST LEWT_OBJ\Q4BB.OBJ     F77L3 LEWTCODE\Q4BB.FOR, LEWT_OBJ\Q4BB.OBJ,, >>CLLEWT3D.LOG
IF NOT EXIST LEWT_OBJ\Q4CNVB.OBJ   F77L3 LEWTCODE\Q4CNVB.FOR, LEWT_OBJ\Q4CNVB.OBJ,, >>CLLEWT3D.LOG
IF NOT EXIST LEWT_OBJ\Q8.OBJ       F77L3 LEWTCODE\Q8.FOR, LEWT_OBJ\Q8.OBJ,, >>CLLEWT3D.LOG
IF NOT EXIST LEWT_OBJ\Q8DV.OBJ     F77L3 LEWTCODE\Q8DV.FOR, LEWT_OBJ\Q8DV.OBJ,, >>CLLEWT3D.LOG
IF NOT EXIST LEWT_OBJ\Q8R.OBJ      F77L3 LEWTCODE\Q8R.FOR, LEWT_OBJ\Q8R.OBJ,, >>CLLEWT3D.LOG
IF NOT EXIST LEWT_OBJ\READN.OBJ    F77L3 LEWTCODE\READN.FOR, LEWT_OBJ\READN.OBJ,, >>CLLEWT3D.LOG
IF NOT EXIST LEWT_OBJ\READR.OBJ    F77L3 LEWTCODE\READR.FOR, LEWT_OBJ\READR.OBJ,, >>CLLEWT3D.LOG
IF NOT EXIST LEWT_OBJ\SFLOW.OBJ    F77L3 LEWTCODE\SFLOW.FOR, LEWT_OBJ\SFLOW.OBJ,, >>CLLEWT3D.LOG
IF NOT EXIST LEWT_OBJ\SHAPE.OBJ    F77L3 LEWTCODE\SHAPE.FOR, LEWT_OBJ\SHAPE.OBJ,, >>CLLEWT3D.LOG
IF NOT EXIST LEWT_OBJ\SOLVE.OBJ    F77L3 LEWTCODE\SOLVE.FOR, LEWT_OBJ\SOLVE.OBJ,, >>CLLEWT3D.LOG
IF NOT EXIST LEWT_OBJ\STORE.OBJ    F77L3 LEWTCODE\STORE.FOR, LEWT_OBJ\STORE.OBJ,, >>CLLEWT3D.LOG
IF NOT EXIST LEWT_OBJ\SURF.OBJ     F77L3 LEWTCODE\SURF.FOR, LEWT_OBJ\SURF.OBJ,, >>CLLEWT3D.LOG
IF NOT EXIST LEWT_OBJ\THNODE.OBJ   F77L3 LEWTCODE\THNODE.FOR, LEWT_OBJ\THNODE.OBJ,, >>CLLEWT3D.LOG
IF NOT EXIST LEWT_OBJ\TRACK1H.OBJ  F77L3 LEWTCODE\TRACK1H.FOR, LEWT_OBJ\TRACK1H.OBJ,, >>CLLEWT3D.LOG
IF NOT EXIST LEWT_OBJ\TRACK2H.OBJ  F77L3 LEWTCODE\TRACK2H.FOR, LEWT_OBJ\TRACK2H.OBJ,, >>CLLEWT3D.LOG
IF NOT EXIST LEWT_OBJ\XSI3D.OBJ    F77L3 LEWTCODE\XSI3D.FOR, LEWT_OBJ\XSI3D.OBJ,, >>CLLEWT3D.LOG
REM --------------------------------------------------------
@ECHO OFF
REM -----------------------------------------------------------------------------------
CLS
ECHO #
ECHO ##  LEWAST3D compilation complete with F77L3 FORTRAN.
ECHO #
ECHO #                                 >>CLLEWT3D.LOG
ECHO ## LEWAST3D compilation complete. >>CLLEWT3D.LOG
ECHO #                                 >>CLLEWT3D.LOG
ECHO #                                 >>CLLEWT3D.LOG
ECHO ## End date and time.             >>CLLEWT3D.LOG
ECHO #                                 >>CLLEWT3D.LOG
ECHO # -------- DATE ---------         >>CLLEWT3D.LOG
ECHO #                                 >>CLLEWT3D.LOG
DATE <RETURN1.ANS | FIND "C"           >>CLLEWT3D.LOG
ECHO #                                 >>CLLEWT3D.LOG
ECHO # -------- TIME ---------         >>CLLEWT3D.LOG
ECHO #                                 >>CLLEWT3D.LOG
TIME <RETURN1.ANS | FIND "C"           >>CLLEWT3D.LOG
ECHO #                                 >>CLLEWT3D.LOG
ECHO # -----------------------         >>CLLEWT3D.LOG
ECHO #                                 >>CLLEWT3D.LOG
ECHO #
IF EXIST *.INC DEL *.INC
CLS
REM
ECHO #
ECHO ##  Ready to link LEWAST3D.
ECHO #
ECHO #   Press the "<Enter>" key to continue.
PAUSE >NUL
REM
IF NOT EXIST LEWT_OBJ\*.OBJ GOTO NOLINK
REM
CLS
ECHO #   
ECHO ##  Beginning 386LINK for LEWAST3D code...wait.
ECHO #   
ECHO #                                       >>CLLEWT3D.LOG
ECHO ## Beginning 386LINK for LEWAST3D code. >>CLLEWT3D.LOG
ECHO #                                       >>CLLEWT3D.LOG
ECHO #                                       >>CLLEWT3D.LOG
ECHO ## Begin date and time.                 >>CLLEWT3D.LOG
ECHO #                                       >>CLLEWT3D.LOG
ECHO # -------- DATE ---------               >>CLLEWT3D.LOG
ECHO #                                       >>CLLEWT3D.LOG
DATE <RETURN1.ANS | FIND "C"                 >>CLLEWT3D.LOG
ECHO #                                       >>CLLEWT3D.LOG
ECHO # -------- TIME ---------               >>CLLEWT3D.LOG
ECHO #                                       >>CLLEWT3D.LOG
TIME <RETURN1.ANS | FIND "C"                 >>CLLEWT3D.LOG
ECHO #                                       >>CLLEWT3D.LOG
ECHO # -----------------------               >>CLLEWT3D.LOG
ECHO #                                       >>CLLEWT3D.LOG
ECHO #
SET LIB=D:\F77L3\LIB
CLS
@ECHO ON
@ECHO.
REM ----------------------------------------------------------
IF NOT EXIST XLEWASTX.EXE 386LINK @LEWTF77L.LNK >>CLLEWT3D.LOG
REM ----------------------------------------------------------
@ECHO OFF
SET LIB=
ECHO #
ECHO # -----------------
ECHO #   
ECHO ##  386LINK complete for LEWAST3D code.
ECHO #   
ECHO #                                   >>CLLEWT3D.LOG
ECHO ## Link complete for LEWAST3D code. >>CLLEWT3D.LOG
ECHO #                                   >>CLLEWT3D.LOG
ECHO #                                   >>CLLEWT3D.LOG
ECHO ## End date and time.               >>CLLEWT3D.LOG
ECHO #                                   >>CLLEWT3D.LOG
ECHO # -------- DATE ---------           >>CLLEWT3D.LOG
ECHO #                                   >>CLLEWT3D.LOG
DATE <RETURN1.ANS | FIND "C"             >>CLLEWT3D.LOG
ECHO #                                   >>CLLEWT3D.LOG
ECHO # -------- TIME ---------           >>CLLEWT3D.LOG
ECHO #                                   >>CLLEWT3D.LOG
TIME <RETURN1.ANS | FIND "C"             >>CLLEWT3D.LOG
ECHO #                                   >>CLLEWT3D.LOG
ECHO # -----------------------           >>CLLEWT3D.LOG
ECHO #                                   >>CLLEWT3D.LOG
ECHO #   Press the "<Enter>" key to continue.
PAUSE >NUL
:NOLINK
CLS
ECHO #
ECHO ##  LEWAST3D compilation/link complete...deleting work files...wait.
ECHO #
REM
ECHO #                                               >>CLLEWT3D.LOG
ECHO ## LEWAST3D CLLEWT3D.BAT command file complete. >>CLLEWT3D.LOG
ECHO #                                               >>CLLEWT3D.LOG
ECHO #                                               >>CLLEWT3D.LOG
ECHO ## End date and time.                           >>CLLEWT3D.LOG
ECHO #                                               >>CLLEWT3D.LOG
ECHO # -------- DATE ---------                       >>CLLEWT3D.LOG
ECHO #                                               >>CLLEWT3D.LOG
DATE <RETURN1.ANS | FIND "C"                         >>CLLEWT3D.LOG
ECHO #                                               >>CLLEWT3D.LOG
ECHO # -------- TIME ---------                       >>CLLEWT3D.LOG
ECHO #                                               >>CLLEWT3D.LOG
TIME <RETURN1.ANS | FIND "C"                         >>CLLEWT3D.LOG
ECHO #                                               >>CLLEWT3D.LOG
ECHO # -----------------------                       >>CLLEWT3D.LOG
ECHO #                                               >>CLLEWT3D.LOG
ECHO #
REM
REM PRINT CLLEWT3D.LOG <RETURN1.ANS >NUL
REM
CLS
ECHO #
ECHO ##  Compilation and link for all LEWAST3D code complete.
ECHO #   Press "<Ctrl><P>" if previously selected for printing.
ECHO #
ECHO #   Press the "<Enter>" key to continue.
PAUSE >NUL
CLS
IF NOT EXIST *.EXE GOTO NOEXE
ECHO #
ECHO ##  LEWAST3D task image ready for test execution.
ECHO #
ECHO.
DIR *.EXE | FIND " EXE"
ECHO.
ECHO #   To execute LEWAST3D, type
ECHO #
ECHO #                       LEWASTE
ECHO #
ECHO #   at the DOS system prompt, then press the "<Enter>" key.
ECHO.
:NOEXE
REM
REM ********************************************************
REM *  End compile batch command E:\FEMWATER\CLLEWT3D.BAT. *
REM ********************************************************
