      SUBROUTINE   BASE
     I                 (XQ,YQ,ZQ,SS,TT,UU,
     O                  N,DNX,DNY,DNZ,DJAC)
C
C     + + + PURPOSE + + +
C     To evaluate the base functions and their derivatives with respect
C     to x, y, and z, and the determinant of the Jacobian at a Gaussian
C     point
C
C     + + + DUMMY ARGUMENTS + + +
      DOUBLE PRECISION   XQ(8),YQ(8),ZQ(8),SS,TT,UU,
     >                   N(8),DNX(8),DNY(8),DNZ(8),DJAC
C
C     + + + ARGUMENT DEFINITIONS + + +
C     XQ    - X-coordinate at eight nodes of the element
C     YQ    - Y-coordinate at eight nodes of the element
C     ZQ    - Z-coordinate at eight nodes of the element
C     SS    - Xsi-coordinate of the Gaussian point
C     TT    - Eta-coordinate of the Gaussian point
C     UU    - Zeta-coordinate of the Gaussian point
C     N     - Base functions associated with eight nodes of the element
C     DNX   - Partial derivative of the base function with respect to x
C     DNY   - Partial derivative of the base function with respect to y
C     DNZ   - Partial derivative of the base function with respect to z
C     DJAC  - Determinant of the Jacobian
C
C     + + + LOCAL VARIABLES + + +
      INTEGER            I
      DOUBLE PRECISION   SM,SP,TM,TP,UM,UP,DJACI,
     >                   SUM1,SUM2,SUM3,SUM4,SUM5,SUM6,SUM7,SUM8,SUM9,
     >                   SUMI1,SUMI2,SUMI3,SUMI4,SUMI5,SUMI6,SUMI7,
     >                   SUMI8,SUMI9,DNSS(8),DNTT(8),DNUU(8)
C
C     + + + END SPECIFICATIONS + + +
C
C     compute some grouped variables
      SM  = 1.0D0 - SS
      SP  = 1.0D0 + SS
      TM  = 1.0D0 - TT
      TP  = 1.0D0 + TT
      UM  = 1.0D0 - UU
      UP  = 1.0D0 + UU
C
C     compute base functions
      N(1) = .125D0*SM*TM*UM
      N(2) = .125D0*SP*TM*UM
      N(3) = .125D0*SP*TP*UM
      N(4) = .125D0*SM*TP*UM
      N(5) = .125D0*SM*TM*UP
      N(6) = .125D0*SP*TM*UP
      N(7) = .125D0*SP*TP*UP
      N(8) = .125D0*SM*TP*UP
C
C     compute the partial derivatives of base functions with respect to
C     local coordinates xsi
      DNSS(1) = -.125D0*TM*UM
      DNSS(2) =  .125D0*TM*UM
      DNSS(3) =  .125D0*TP*UM
      DNSS(4) = -.125D0*TP*UM
      DNSS(5) = -.125D0*TM*UP
      DNSS(6) =  .125D0*TM*UP
      DNSS(7) =  .125D0*TP*UP
      DNSS(8) = -.125D0*TP*UP
C
C     compute the partial derivatives of base functions with respect to
C     local coordinates eta
      DNTT(1) = -.125D0*SM*UM
      DNTT(2) = -.125D0*SP*UM
      DNTT(3) =  .125D0*SP*UM
      DNTT(4) =  .125D0*SM*UM
      DNTT(5) = -.125D0*SM*UP
      DNTT(6) = -.125D0*SP*UP
      DNTT(7) =  .125D0*SP*UP
      DNTT(8) =  .125D0*SM*UP
C
C     compute the partial derivatives of base functions with respect to
C     local coordinates zeta
      DNUU(1) = -.125D0*SM*TM
      DNUU(2) = -.125D0*SP*TM
      DNUU(3) = -.125D0*SP*TP
      DNUU(4) = -.125D0*SM*TP
      DNUU(5) =  .125D0*SM*TM
      DNUU(6) =  .125D0*SP*TM
      DNUU(7) =  .125D0*SP*TP
      DNUU(8) =  .125D0*SM*TP
C
C     initiate the nine entries of the Jacobian matrix
      SUM1 = 0.0
      SUM2 = 0.0
      SUM3 = 0.0
      SUM4 = 0.0
      SUM5 = 0.0
      SUM6 = 0.0
      SUM7 = 0.0
      SUM8 = 0.0
      SUM9 = 0.0
C
C     compute the nine entries of the Jacobian matrix
      DO 290 I = 1,8
        SUM1 = SUM1 + XQ(I)*DNSS(I)
        SUM2 = SUM2 + YQ(I)*DNSS(I)
        SUM3 = SUM3 + ZQ(I)*DNSS(I)
        SUM4 = SUM4 + XQ(I)*DNTT(I)
        SUM5 = SUM5 + YQ(I)*DNTT(I)
        SUM6 = SUM6 + ZQ(I)*DNTT(I)
        SUM7 = SUM7 + XQ(I)*DNUU(I)
        SUM8 = SUM8 + YQ(I)*DNUU(I)
        SUM9 = SUM9 + ZQ(I)*DNUU(I)
  290 CONTINUE
C
C     compute the determinant of the Jacobian matrix
      DJAC = SUM1*(SUM5*SUM9-SUM6*SUM8) + SUM2*(SUM6*SUM7-SUM4*SUM9) +
     >       SUM3*(SUM4*SUM8-SUM5*SUM7)
C
C     compute the inverse of the determinant of the Jacobian matrix
      DJACI = 1.0D0/DJAC
C
C     compute the nine entries of the inverse Jacobian matrix
      SUMI1 = DJACI*(SUM5*SUM9 - SUM6*SUM8)
      SUMI2 = DJACI*(SUM3*SUM8 - SUM2*SUM9)
      SUMI3 = DJACI*(SUM2*SUM6 - SUM3*SUM5)
      SUMI4 = DJACI*(SUM6*SUM7 - SUM4*SUM9)
      SUMI5 = DJACI*(SUM1*SUM9 - SUM3*SUM7)
      SUMI6 = DJACI*(SUM3*SUM4 - SUM1*SUM6)
      SUMI7 = DJACI*(SUM4*SUM8 - SUM5*SUM7)
      SUMI8 = DJACI*(SUM2*SUM7 - SUM1*SUM8)
      SUMI9 = DJACI*(SUM1*SUM5 - SUM2*SUM4)
C
C     compute the partial derivatives of base functions with respect to
C     global coordinate x, y, and z.
      DO 390 I = 1,8
        DNX(I) = SUMI1*DNSS(I) + SUMI2*DNTT(I) + SUMI3*DNUU(I)
        DNY(I) = SUMI4*DNSS(I) + SUMI5*DNTT(I) + SUMI6*DNUU(I)
        DNZ(I) = SUMI7*DNSS(I) + SUMI8*DNTT(I) + SUMI9*DNUU(I)
  390 CONTINUE
C
      RETURN
      END
