      SUBROUTINE   BC
     I               (LRN,IE,X,Y,Z, AKR,PROP, DCOSB,ISB, QCB,ISC,ICTYP,
     I                QNB,ISN,INTYP, FLX,HCON,HMIN,NPFLX,NPCON,NPMIN,
     I                HDB,IDTYP,NPDB,
     M                CMATRX,RLD)
C
C     + + + PURPOSE + + +
C     To apply Cauchy, Neuman, Variable, and Dirichlet boundary
C     conditions
C
C     + + + COMMON BLOCKS + + +
      INCLUDE 'CSGEOM.INC'
      INCLUDE 'CGEOM.INC'
      INCLUDE 'CCBC.INC'
      INCLUDE 'CNBC.INC'
      INCLUDE 'CVBC.INC'
      INCLUDE 'CDBC.INC'
      INCLUDE 'CSMTL.INC'
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER            LRN(MXJBD,MAXNP),IE(MAXEL,9),ISB(6,MAXBES),
     >                   ISC(5,MXCES),ICTYP(MXCES),ISN(5,MXNES),
     >                   INTYP(MXNES),NPFLX(MXVNP),NPCON(MXVNP),
     >                   NPMIN(MXVNP),IDTYP(MXDNP),NPDB(MXDNP)
      DOUBLE PRECISION   X(MAXNP),Y(MAXNP),Z(MAXNP),AKR(8,MAXEL),
     >                   PROP(MXMPPM,MAXMAT),DCOSB(3,MAXBES),
     >                   QCB(MXCPR),QNB(MXNPR),FLX(MXVNP),HCON(MXVNP),
     >                   HMIN(MXVNP),HDB(MXDPR),CMATRX(MAXNP,MXJBD),
     >                   RLD(MAXNP)
C
C     + + + ARGUMENT DEFINITIONS + + +
C     LRN(I,N)    - global node number of the I-th connecting node to
C                   the N-th node
C     IE(M,I)     - global node number of I-th node of the M-th element
C                   if I = 1 to 8, material type of the M0th element if
C                   I = 9
C     X(N)        - x-coordinate of the N-th node
C     Y(N)        - y-coordinate of the N-th node
C     Z(N)        - z-coordinate of the N-th node
C
C     PROP(I,J)   - I-th material property of the J-th material;
C                     I = 1 = saturated xx-hydraulic conductivity
C                     I = 2 = saturated yy-hydraulic conductivity
C                     I = 3 = saturated zz-hydraulic conductivity
C                     I = 4 = saturated xy-hydraulic conductivity
C                     I = 5 = saturated xz-hydraulic conductivity
C                     I = 6 = saturated yz-hydraulic conductivity
C     AKR(I,M)    - relative conductivity at I-th node of M-th element
C
C     DCOSB(1,I)  - directional cosine of the I-th boundary side with x
C     DCOSB(2,I)  - directional cosine of the I-th boundary side with y
C     DCOSB(3,I)  - directional cosine of the I-th boundary side with z
C     ISB(1,I)    - boundary node number of the first node of the I-th
C                   boundary side
C     ISB(2,I)    - boundary node number of the second node of the I-th
C                   boundary side
C     ISB(3,I)    - boundary node number of the third node of the I-th
C                   boundary side
C     ISB(4,I)    - boundary node number of the fourth node of the I-th
C                   boundary side
C     ISB(5,I)    - element side index of the I-th boundary side;
C                   1 = left side, 2 = front side, 3 = right side,
C                   4 = back side, 5 = bottom side, 6 = top side
C     ISB(6,I)    - global element number to which the I-th boundary
C                   side belong
C
C     QCB(J)      - Cauchy flux of the J-th profile at the present time
C     ICTYP(MP)   - flux type assigned to the MP-th Cauchy side
C     ISC(1,MP)   - global node number of the first node of the MP-th
C                   Cauchy side
C     ISC(2,MP)   - global node number of the second node of the MP-th
C                   Cauchy side
C     ISC(3,MP)   - global node number of the third node of the MP-th
C                   Cauchy side
C     ISC(4,MP)   - global node number of the fourth node of the MP-th
C                   Cauchy side
C     ISC(5,MP)   - boundary side number of the MP-th Cauchy side
C
C     QNB(J)      - Neuman flux of the J-th profile at the present time
C     ISN(1,MP)   - global node number of the first node of the MP-th
C                   Neuman side
C     ISN(2,MP)   - global node number of the second node of the MP-th
C                   Neuman side?
C     ISN(3,MP)   - global node number of the third node of the MP-th
C                   Neuman side
C     ISN(4,MP)   - global node number of the fourth node of the MP-th
C                   Neuman side
C     ISN(5,MP)   - boundary node number of the MP-th Neuman side
C     INTYP(MP)   - flux type assigned to the MP-th Neuman side
C
C     FLX(NP)     - rainfall flux through the NP-th VB node
C     HCON(NP)    - ponding depth of the NP-th variable boundary node
C     HMIN(NP)    - minimum pressure allowed for the NP-th VB node
C     NPFLX(NP)   - flux boundary condition indicator of the NP-th
C                   VB node; 0 = this is not a flux-condition node for
C                   the present time step, globan node number = this
C                   is a flux-condition node for the present time
C     NPCON(NP)   - ponding condition indicator of the NP-th VB node:
C                   0 = this is not a ponding-condition node for the
C                   present time step, global node number = this is
C                   a ponding-condition node for the present time
C     NPMIN(NP)   - minimum-pressure condition indicator of NP-th VB
C                   node; 0 = this is not a minimum-pressure-condition
C                   node for the present time step, global node number =
C                   this is a minimum-pressure-condition node for the
C                   present time step
C
C     HDB(J)      - total head of the J-th profile at the present time
C     IDTYP(NP)   - total head profile type assigned to NP-th
C                   Dirichlet node
C     NPDB(NP)    - global node number of the NP-th Dirichlet node.
C
C     CMATRX(N,I) - an array to store the assembled global matrix
C     RLD(N)      - an array to store the assembled global load vector
C
C     + + + LOCAL VARIABLES + + +
      INTEGER            MP,ITYP,MPB,LS,M,IQ,I,NI,MTYP,NPP,NP,IB,
     >                   KGB(4,6)
      DOUBLE PRECISION   AGRAV,QCBMP,QNBMP,AKZX,AKZY,AKZZ,BB,R1Q(4),
     >                   R2Q(4),XQ(4),YQ(4),ZQ(4),F1Q(4),F2Q(4)
C
C     + + + INTRINSICS + + +
      INTRINSIC   DBLE
C
C     + + + EXTERNALS + + +
      EXTERNAL    Q4S
C
C     + + + DATA INITIALIZATIONS + + +
      DATA KGB/1,4,8,5, 1,2,6,5, 2,3,7,6, 4,3,7,8, 1,2,3,4, 5,6,7,8/
C
C     + + + END SPECIFICATIONS + + +
C
      AGRAV = DBLE(KGRAV)
C
      IF (NCES .GT. 0) THEN
C
C       *** Apply Cauchy boundary conditions
C
        DO 260 MP = 1,NCES
C         obtain Cauchy normal flux
          ITYP  = ICTYP(MP)
          QCBMP = QCB(ITYP)
C
C         compute boundary side number, side number, and element number
          MPB = ISC(5,MP)
          LS  = ISB(5,MPB)
          M   = ISB(6,MPB)
C
C         put global variables into local variables
          DO 210 IQ = 1,4
            I       = KGB(IQ,LS)
            NI      = IE(M,I)
            XQ(IQ)  = X(NI)
            YQ(IQ)  = Y(NI)
            ZQ(IQ)  = Z(NI)
            F1Q(IQ) = QCBMP
            F2Q(IQ) = 0.0
  210     CONTINUE
C
C         perform surface integration
          CALL Q4S
     I            (XQ,YQ,ZQ,F1Q,F2Q,
     O             R1Q,R2Q)
C
C         put boundary load into global load
          DO 230 IQ = 1,4
            I       = KGB(IQ,LS)
            NI      = IE(M,I)
            RLD(NI) = RLD(NI) - R1Q(IQ)
  230     CONTINUE
C
  260   CONTINUE
      END IF
C
      IF (NNES .NE. 0) THEN
C
C       *** Apply Neuman boundary conditions
C
        DO 390 MP = 1,NNES
C         obtain Neuman flux
          ITYP  = INTYP(MP)
          QNBMP = QNB(ITYP)
C
C         compute boundary number, side number, and element number
          MPB = ISN(5,MP)
          LS  = ISB(5,MPB)
          M   = ISB(6,MPB)
C
C         compute material type
          MTYP  = IE(M,9)
          AKZX  = PROP(5,MTYP)
          AKZY  = PROP(6,MTYP)
          AKZZ  = PROP(3,MTYP)
C
          DO 310 IQ = 1,4
            I       = KGB(IQ,LS)
            NI      = IE(M,I)
            XQ(IQ)  = X(NI)
            YQ(IQ)  = Y(NI)
            ZQ(IQ)  = Z(NI)
            F1Q(IQ) = QNBMP
            F2Q(IQ) = AKR(IQ,M)*(DCOSB(1,MPB)*AKZX + DCOSB(2,MPB)*
     >                AKZY + DCOSB(3,MPB)*AKZZ)
  310     CONTINUE
C
C         perform surface integration
          CALL Q4S
     I            (XQ,YQ,ZQ,F1Q,F2Q,
     O             R1Q,R2Q)
C
C         put element boundary flux to global load vector
          DO 360 IQ = 1,4
            I       = KGB(IQ,LS)
            NI      = IE(M,I)
            RLD(NI) = RLD(NI) - R1Q(IQ) + R2Q(IQ)
  360     CONTINUE
C
  390   CONTINUE
      END IF
C
      IF (NVES .NE. 0) THEN
C
C       *** Apply Variable boundary conditions
C
C       flux part of the variable boundary conditions
        DO 410 NPP = 1,NVNP
          NP = NPFLX(NPP)
          IF (NP .NE. 0) THEN
C           this is a flux node
            RLD(NP) = RLD(NP) - FLX(NPP)
          END IF
  410   CONTINUE
C
C       Dirichelt part of the variable boundary conditions
        DO 490 NPP = 1,NVNP
C
          NI = NPCON(NPP)
          IF (NI .EQ. 0) THEN
C           this is not a ponding depth node
            NI = NPMIN(NPP)
            IF (NI .NE. 0) THEN
C             this is a minimum pressure node
              BB = HMIN(NPP)
            END IF
          ELSE
C           this is a ponding depth node
            BB = HCON(NPP)
          END IF
C
          IF (NI .NE. 0) THEN
C           put the boundary values to the load vector
            RLD(NI) = BB
            DO 480 I = 1,MXJBD
              CMATRX(NI,I) = 0.0
              IB           = LRN(I,NI)
              IF (IB .EQ. NI) THEN
C               for the Dirichlet node, set up identity matrix
                CMATRX(NI,I) = 1.0D0
              END IF
  480       CONTINUE
          END IF
C
  490   CONTINUE
      END IF
C
      IF (NDNP .NE. 0) THEN
C
C       *** Apply Dirichlet boundary conditions
C
        DO 740 NPP = 1,NDNP
          NI      = NPDB(NPP)
          ITYP    = IDTYP(NPP)
          BB      = HDB(ITYP) - Z(NI)*AGRAV
          RLD(NI) = BB
C         set up an identity matrix for a Dirichlet node
          DO 710 I = 1,MXJBD
            CMATRX(NI,I) = 0.0
            IB           = LRN(I,NI)
            IF (IB .EQ. NI) THEN
              CMATRX(NI,I) = 1.0D0
            END IF
  710     CONTINUE
  740   CONTINUE
      END IF
C
      RETURN
      END
