      SUBROUTINE   BLKITR
     I                   (MAXNP,MXJBD,LTMXNP,LMXNP,LMXBW,MXREGN,LUOUT,
     I                    NNP,NREGN,
     I                    CMTRXG,RLDG,GNLR,LNOJCN,
     I                    NNPLR,LMAXDF,TOLB,NITER,IBUG,KPR,OME,
     M                    CW,CMTRXL,RLDL,
     O                    C)
C
C     + + + PURPOSE + + +
C     To solve the matrix equation with block iteration.  First, the
C     block matrix equation is assembled out the global marix equation.
C     Then the intra-boundary conditions are implemented.  Finally, the
C     block matrix equation is solved with direct band matrix solver.
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER            MAXNP,MXJBD,LTMXNP,LMXNP,LMXBW,MXREGN,LUOUT,
     >                   NNP,NREGN,NITER,IBUG,KPR
      INTEGER            GNLR(LTMXNP,MXREGN),LNOJCN(MXJBD,LMXNP,MXREGN),
     >                   NNPLR(MXREGN),LMAXDF(MXREGN)
      DOUBLE PRECISION   CMTRXG(MAXNP,MXJBD),RLDG(MAXNP),TOLB,OME,
     >                   CW(MAXNP),CMTRXL(LMXNP,LMXBW),RLDL(LMXNP),
     >                   C(MAXNP)
C
C     + + + ARGUEMENT DEFINITIONS + + +
C     MAXNP  - maximum number of nodal points
C     MXJBD  - maximum number of nodes connecting to any node
C     LTMXNP - maximum number of total nodal points in a subregion
C              (= LMXNP plus Intra-boundary nodes)
C     LMXNP  - maximum number of nodal points in a subregion
C     LMXBW  - maximum band width in a subregion
C     MXREGN - maximum number of subregions
C     LUOUT  - logical unit for output
C     NNP    - no. of nodal points
C     NREGN  - no. of subregions
C     CMTRXG - global matrix
C     RLDG   - glabal load vector
C     GNLR   - mapping between global and subreginal node numbers
C     LNOJCN - node stencil in the k-th subregion
C     NNPLR  - no. of nodal points in the k-th subregion
C     LMAXDF - maximum difference of ndoes for any element in the
C              k-th subregion
C     TOLB   - tolerance for solving the matrix equation
C     NITER  - no. of iterations allowed for solving the matrix
C              equation
C     IBUG   - diagnostic print out indicator
C     KPR    - solution print out indicator
C     OME    - relaxation factor for iteration
C     CW     - iterate
C     CMTRXL - subregion matrix
C     RLDL   - subregion load vector
C     C      - final solution
C
C     + + + LOCAL VARIABLES + + +
      INTEGER            NP,IT,K,LHALFB,LIHBP,IBAND,LNNP,DONFG,
     >                   LI,J,NI,LJ,NJ,LJB,NOCCUR
      DOUBLE PRECISION   DIFMAX,DIF
C
C     + + + EXTERNALS + + +
      EXTERNAL  SOLVE
C
C     + + + INTRINSIC + + +
      INTRINSIC DABS
C
C     + + + OUTPUT FORMATS + + +
 2000 FORMAT(///,5X,'   IT   DIFMAX       TOLB        NOCCUR',/,
     >           5X,'   --   ------       ----        ------')
 2010 FORMAT(    5X,I5,2D12.4,I10)
 2020 FORMAT(//10X,' *** WARNING: NO CONVERGENCE IN BLKITR AFTER  ',I4,
     > '   ITERATIONS',/,
     >         10X,'     NITER =',I4,'  DIFMAX =',D11.4,
     >             '     TOLB  =',D11.4,'  NOCCUR =',I4)
C
C     + + + END SPECIFICATIONS + + +
C
C     put the zero-th iterate into array C
      DO 110 NP = 1,NNP
        C(NP) = CW(NP)
 110  CONTINUE
C
      IF (IBUG .NE. 0 .AND. KPR .NE. 0) THEN
C       write debug heading
        WRITE(LUOUT,2000)
      END IF
C
C     *** Start Iteration Loop
C
      DONFG = 0
      IT    = 0
C
 150  CONTINUE
        IT = IT+ 1
C
C       for eact iteration, solve for NREGN subregions
        DO 590 K= 1,NREGN
C
          LHALFB = LMAXDF(K)
          LIHBP  = LHALFB + 1
          IBAND  = 2*LHALFB + 1
          LNNP   = NNPLR(K)
C
C         put global load vector into corresponding local load vector
C         and initiate the lcoal matrix.
          DO 210 LI = 1,LNNP
            NP       = GNLR(LI,K)
            RLDL(LI) = RLDG(NP)
            DO 200 J = 1,IBAND
              CMTRXL(LI,J) = 0.0
 200        CONTINUE
 210      CONTINUE
C
C         assemble local coefficient matrix from the global coefficient
C         matrix and incorporate intrafacial Dirichlet boundary
C         conditions
          DO 490 LI = 1,LNNP
            NI = GNLR(LI,K)
C
C           obtain all column entries for each row of the block matrix
            DO 390 J = 1,MXJBD
              LJ = LNOJCN(J,LI,K)
C
              IF (LJ .GT. 0) THEN
C               load the local matrix and incorporate intra-B.C.
                NJ = GNLR(LJ,K)
                IF (LJ .LE. LNNP) THEN
C                 load the local matrix
                  LJB = LJ - LI + LIHBP
                  CMTRXL(LI,LJB) = CMTRXG(NI,J)
                ELSE
C                 incorporate intra-boundary Dirichlet values
                  RLDL(LI) = RLDL(LI) - CMTRXG(NI,J)*C(NJ)
                END IF
              END IF
  390       CONTINUE
  490     CONTINUE
C
C         solve the block equations
          CALL SOLVE
     I              (1,LNNP,LHALFB,LMXNP,LMXBW,
     M               CMTRXL,RLDL)
C         backward subtittuiton
          CALL SOLVE
     I              (2,LNNP,LHALFB,LMXNP,LMXBW,
     M               CMTRXL,RLDL)
C
C         put the newly obtained block solution into the global soltuion
          DO 560 LI = 1,LNNP
            NP    = GNLR(LI,K)
            C(NP) = RLDL(LI)*OME + (1.0D0 - OME)*C(NP)
  560     CONTINUE
  590   CONTINUE
C
C       have finished all subregions, check if the convergent
C       solution is achieved?
        DIFMAX = 0.0
        NOCCUR = 1
C
        DO 660 NP = 1,NNP
          DIF = C(NP) - CW(NP)
          DIF = DABS(DIF)
          IF (DIF .GT. DIFMAX) THEN
C           new maximum difference
            DIFMAX = DIF
            NOCCUR = NP
          END IF
  660   CONTINUE
C
C       update iterate
        DO 680 NP = 1,NNP
          CW(NP) = C(NP)
  680   CONTINUE
C
C       print iteration information if desired
        IF (IBUG .NE. 0 .AND. KPR .NE. 0) THEN
C         write debug details
          WRITE(LUOUT,2010) IT,DIFMAX,TOLB,NOCCUR
        END IF
C
        IF (IT .GT. 1) THEN
C         check maximum difference less than tolerance?
          IF (DIFMAX .LT. TOLB) THEN
C           convergent solution has been obtained, set done flag
            DONFG = 1
          END IF
        END IF
      IF (IT .LT. NITER .AND. DONFG .EQ. 0) THEN
        GO TO 150
      END IF
C
      IF (DONFG .EQ. 0) THEN
C       non-convergent solution, print message
        WRITE(LUOUT,2020) IT,NITER,DIFMAX,TOLB,NOCCUR
      END IF
C
      RETURN
      END
