      SUBROUTINE DATAIN
     I                 (LUINP,LUOUT,LUBAR,
     O                  KPR,KDSK,TDTCH, PROP,THPROP,AKPROP,CAPROP,
     O                  HPROP,X,Y,Z,IE, NNPLR,GNLR, DCOSB,ISB,NPBB,
     O                  H,SOSF,TSOSF,ISTYP,LES,
     O                  WSSF,TWSSF,IWTYP,NPW, QCBF,TQCBF,ICTYP,ISC,NPCB,
     O                  QNBF,TQNBF,INTYP,ISN,NPNB, RF,TRF,IRTYP,ISV,
     O                  NPVB,HCON,HMIN,HDBF,THDBF,IDTYP,NPDB,
     O                  LRN,LRL,NLRL,LNOJCN,LMAXDF,NTNPLR)
C
C
C     + + + PURPOSE + + +
C     To read and print all input
C
C     + + + COMMON BLOCKS + + +
      INCLUDE 'CSGEOM.INC'
      INCLUDE 'CGEOM.INC'
      INCLUDE 'CLGEOM.INC'
      INCLUDE 'CINTE.INC'
      INCLUDE 'CREAL.INC'
      INCLUDE 'CS.INC'
      INCLUDE 'CW.INC'
      INCLUDE 'CCBC.INC'
      INCLUDE 'CNBC.INC'
      INCLUDE 'CVBC.INC'
      INCLUDE 'CDBC.INC'
      INCLUDE 'CSMTL.INC'
      INCLUDE 'CMTL.INC'
      INCLUDE 'COPTN.INC'
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER            KPR(MAXNTI),KDSK(MAXNTI),IE(MAXEL,9),
     >                   ISB(6,MAXBES),NPBB(MAXBNP),ISTYP(MXSEL),
     >                   LES(MXSEL),IWTYP(MXWNP),NPW(MXWNP),
     >                   ICTYP(MXCES),ISC(5,MXCES),NPCB(MXCNP),
     >                   INTYP(MXNES),ISN(5,MXNES),NPNB(MXNNP),
     >                   IRTYP(MXVES),ISV(5,MXVES),NPVB(MXVNP),
     >                   IDTYP(MXDNP),NPDB(MXDNP),NNPLR(MXREGN),
     >                   LRN(MXJBD,MAXNP),LRL(MXKBD,MAXNP),NLRL(MAXNP),
     >                   LNOJCN(MXJBD,LMXNP,MXREGN),LMAXDF(MXREGN),
     >                   NTNPLR(MXREGN),
     >                   GNLR(LTMXNP,MXREGN), LUINP,LUOUT,LUBAR
      DOUBLE PRECISION   TDTCH(MXNDTC),PROP(MXMPPM,MAXMAT),
     >                   THPROP(MXSPPM,MAXMAT),AKPROP(MXSPPM,MAXMAT),
     >                   CAPROP(MXSPPM,MAXMAT),HPROP(MXSPPM,MAXMAT),
     >                   X(MAXNP),Y(MAXNP),Z(MAXNP),H(MAXNP),
     >                   DCOSB(3,MAXBES),SOSF(MXSDP,MXSPR),
     >                   TSOSF(MXSDP,MXSPR),WSSF(MXWDP,MXWPR),
     >                   TWSSF(MXWDP,MXWPR),QCBF(MXCDP,MXCPR),
     >                   TQCBF(MXCDP,MXCPR),QNBF(MXNDP,MXNPR),
     >                   TQNBF(MXNDP,MXNPR),RF(MXRDP,MXRPR),
     >                   TRF(MXRDP,MXRPR),HCON(MXVNP),HMIN(MXVNP),
     >                   HDBF(MXDDP,MXDPR),THDBF(MXDDP,MXDPR)
C
C     + + + ARGUMENT DEFINITIONS + + +
C     LUINP       - logical unit for data input
C     LUOUT       - logical unit for data output
C     LUBAR       - logical unit for store binary boundary arrays
C
C     KPR(I)      - line-printer control for the I-th time step
C                    0 = print nothing,
C                    1 = print system mass balance plus above
C                    2 = print pressure head plus above
C                    3 = print total head plus above
C                    4 = print moisture content plus above
C                    5 = print Darcy velocity plus above
C     KDSK(I)     - auxilliary output control for the I-th time step;
C                    0 = no auxilliary output, 1 = auxilliary output
C     TDTCH(I)    - time of the I-th time to reset time step size to
C                   initial time step size.
C
C     PROP(I,J)   - I-th material property of the J-th material;
C                     I = 1 = saturated xx-hydraulic conductivity
C                     I = 2 = saturated yy-hydraulic conductivity
C                     I = 3 = saturated zz-hydraulic conductivity
C                     I = 4 = saturated xy-hydraulic conductivity
C                     I = 5 = saturated xz-hydraulic conductivity
C                     I = 6 = saturated yz-hydraulic conductivity
C     THPROP(I,J) - I-th parameter to describe the moisture content as
C                   function of pressure head for the J-th material or
C                   I-th data point of moisture content for the J-th
C                   material.
C     AKPROP(I,J) - I-th parameter to describe the relative
C                   conductivity as function of pressure head for the
C                   J-th material or I-th data point of relative
C                   conductivity for the J-th material
C     CAPROP(I,J) - I-th data point of water capacity for the J-th
C                   material
C     HPROP(I,J)  - I-th data point of pressure for the J-th material
C
C     X(N)        - x-coordinate of the N-th node
C     Y(N)        - y-coordinate of the N-th node
C     Z(N)        - z-coordinate of the N-th node
C     IE(M,I)     - global node number of I-th node of the M-th element
C                   if I = 1 to 8, material type of the M0th element if
C     NNPLR(K)    - number of node points in the K-th subregion
C     GNLR(I,K)   - global node number of the I-th node in the K-th
C                   I = 9
C     DCOSB(1,I)  - directional cosine of the I-th boundary side with x
C     DCOSB(2,I)  - directional cosine of the I-th boundary side with y
C     DCOSB(3,I)  - directional cosine of the I-th boundary side with z
C     ISB(1,I)    - boundary node number of the first node of the I-th
C                   boundary side
C     ISB(2,I)    - boundary node number of the second node of the I-th
C                   boundary side
C     ISB(3,I)    - boundary node number of the third node of the I-th
C                   boundary side
C     ISB(4,I)    - boundary node number of the fourth node of the I-th
C                   boundary side
C     ISB(5,I)    - element side index of the I-th boundary side;
C                   1 = left side, 2 = front side, 3 = right side,
C                   4 = back side, 5 = bottom side, 6 = top side
C     ISB(6,I)    - global element number to which the I-th boundary
C                   side belong
C     NPBB(I)     - global node number of the I-th boundary node
C
C     H(N)        - pressure head at the present time
C
C     SOSF(I,J)   - s/s rate of the I-th data point in the J-th profile
C     TSOSF(I,J)  - time of the I-th data point in the J-th profile
C     ISTYP(MP)   - source/sink type assigned to the MP-th s/s element
C     LES(MP)     - global element number of the MP-th s/s element
C     WSSF(I,J)   - s/s rate of the I-th data point in the J-th profile
C     TWSSF(I,J)  - time of the I-th data point in the J-th profile
C     IWTYP(NP)   - source/sink type assigned to the NP-th well node
C     NPW(NP)     - global node number of the NP-th s/s well node
C
C     QCBF(I,J)   - Cauchy flux of the I-th data point in J-th profile
C     TQCBF(I,J)  - time of the I-th data point in J-th Cauchy profile
C     ICTYP(MP)   - flux type assigned to the MP-th Cauchy side
C     ISC(1,MP)   - global node number of the first node of the MP-th
C                   Cauchy side
C     ISC(2,MP)   - global node number of the second node of the MP-th
C                   Cauchy side
C     ISC(3,MP)   - global node number of the third node of the MP-th
C                   Cauchy side
C     ISC(4,MP)   - global node number of the fourth node of the MP-th
C                   Cauchy side
C     ISC(5,MP)   - boundary side number of the MP-th Cauchy side
C     NPCB(NP)    - Global node number of the MP-th Cauchy node on input
C                   then is changed to contain boundary node number
C
C     QNBF(I,J)   - Neuman flux of the I-th data point in J-th profile
C     TQNBF(I,J)  - time of the I-th data point in J-th Neuman profile
C     INTYP(MP)   - flux type assigned to the MP-th Neuman side
C     ISN(1,MP)   - global node number of the first node of the MP-th
C                   Neuman side
C     ISN(2,MP)   - global node number of the second node of the MP-th
C                   Neuman side?
C     ISN(3,MP)   - global node number of the third node of the MP-th
C                   Neuman side
C     ISN(4,MP)   - global node number of the fourth node of the MP-th
C                   Neuman side
C     ISN(5,MP)   - boundary node number of the MP-th Neuman side
C     NPNB(NP)    - global node number of the MP-th Neuman node on input
C                   then is changed to contain boundary node number
C
C     RF(I,J)     - rainfall rate of I-th data point in J-th profile
C     TRF(I,J)    - time of the I-th data point in J-th rainfall profile
C     IRTYP(MP)   - type of rainfall profile assigned to MP-th VB side
C     ISV(1,MP)   - global node number of the first node of the MP-th
C                   variable boundary side
C     ISV(2,MP)   - global node number of the second node of the MP-th
C                   variable boundary side
C     ISV(3,MP)   - global node number of the third node of the MP-th
C                   variable boundary side
C     ISV(4,MP)   - global node number of the fourth node of the MP-th
C                   variable boundary side
C     ISV(5,MP)   - boundary node number of the MP-th VB side
C     NPVB(NP)    - global node number of NP-th VB node on input,
C                   then is changed to contain boundary node number
C     HCON(NP)    - ponding depth of the NP-th variable boundary node
C     HMIN(NP)    - minimum pressure allowed for the NP-th VB node
C
C     HDBF(I,J)   - total head of the I-th data point in J-th profile
C     THDBF(I,J)  - time of the I-th data point in J-th head profile
C     IDTYP(NP)   - total head profile type assigned to NP-th
C                   Dirichlet node
C     NPDB(NP)    - global node number of the NP-th Dirichlet node.
C                   subregion
C
C     + + + LOCAL VARIABLES + + +
      INTEGER            NCM,ITM,I,J,KCP,NPI,NI,NSEQ,NIAD,NJ,NP,LINE,
     >                   NJMN,NJMX,K,LNNP,MMP,MI,MIAD,IEMAD,MJ,MP,M,IQ,
     >                   MTYP,MPI,I1,I2,I3,I4,I1AD,I2AD,I3AD,I4AD,JQ,IJ,
     >                   IEQ,NII,MPB,NB,DONEFG,MJDO,IQDO,JQDO,IDO
      DOUBLE PRECISION   RHO,GRAV,VISC,PKCF,XI,YI,ZI,XIAD,YIAD,ZIAD,
     >                   NIMI(4),NJMJ(4),IEM(8)
      CHARACTER*1        DATNAM
C
C     + + + INTRINSICS + + +
      INTRINSIC   DBLE,MOD,MIN0
C
C     + + + EXTERNALS + + +
      EXTERNAL    READN,SURF,READR,PAGEN
C
C     + + + INPUT FORMATS + + +
 1000 FORMAT(A1)
 1010 FORMAT(80I1)
C
C     + + + OUTPUT FORMATS + + +
 2000 FORMAT(/'     **** BASIC INTEGER PARAMETERS ****'//5X,
     > ' NUMBER OF NODAL POINTS. . . . . . . . .',I5/ 5X,
     > ' NUMBER OF ELEMENTS. . . . . . . . . . .',I5/ 5X,
     > ' NUMBER OF DIFFERENT MATERIALS . . . . .',I5/ 5X,
     > ' NUMBER OF CORRECTION MATERIALS. . . . .',I5/ 5X,
     > ' NUMBER OF TIME INCREMENTS . . . . . . .',I5//5X,
     > ' STEADY-STATE I.C. CONTROL . . . . . . .',I5/ 5X,
     > ' NUMBER OF MATERIAL PROPERTIES . . . . .',I5//5X,
     > ' GRAVITY CONTROL . . . . . . . . . . . .',I5/ 5X,
     > ' LUMPING INDICATOR . . . . . . . . . . .',I5/ 5X,
     > ' MID-DIFFERENCE INDICATOR, IMID  . . . .',I5/ 5X,
     > ' NO. OF ITERATIONS PER CYCLE . . . . . .',I5/ 5X,
     > ' NO. OF CYCLES PER TIME STEP . . . . . .',I5/ 5X,
     > ' NO. OF TIMES TO RESET TIME STEP SIZE  .',I5/ 5X,
     > ' NO. OF BLOCKWISE ITERATIONS ALLOWED . .',I5/)
 2010 FORMAT(5X,' TIME INCREMENT. . . . . . . . . . . . .',E15.6/ 5X,
     > ' MULTIPLIER FOR INCREASING DELT. . . . .',E15.6/ 5X,
     > ' MAXIMUM VALUE OF DELT . . . . . . . . .',E15.6/ 5X,
     > ' MAXIMUM VALUE OF TIME . . . . . . . . .',E15.6//5X,
     > ' STEADY-STATE TOLERANCE. . . . . . . . .',E15.6/ 5X,
     > ' TRANSIENT-STATE TOLERANCE . . . . . . .',E15.6//5X,
     > ' DENSITY OF WATER. . . . . . . . . . . .',E15.6/ 5X,
     > ' ACCELERATION OF GRAVITY . . . . . . . .',E15.6/ 5X,
     > ' VISCOSITY OF WATER. . . . . . . . . . .',E15.6//5X,
     > ' TIME-INTEGRATION PARAMETER. . . . . . .',E15.6/ 5X,
     > ' ITERATION PARAMETER FOR NONLINEAR EQ.  ',E15.6/ 5X,
     > ' RELAXATION PARAMETER FOR POINTWISE SOL.',E15.6//)
 2020 FORMAT(//6X,'OUTPUT CONTROL')
 2030 FORMAT(10X,30I2)
 2040 FORMAT(//6X,'DISK OUTPUT CONTROL')
 2050 FORMAT(/7X,'TIME OF CHANGING DELT'/(8X,5D12.4))
 2060 FORMAT('1','     **** MATERIAL PROPERTIES **** ',//' MAT NO.',
     > '    SKXX        SKYY        SKZZ        SKXY    '/1x,
     > '    SKXZ        SXYZ    ')
 2070 FORMAT(I8,6D12.4)
 2080 FORMAT('1','**** SOIL PROPERTY PARAMETERS ****'//5X,
     > 'SOIL PROPERTY TABULAR INPUT CONTROL, KSP . .',I5/5X,
     > 'NUMBER OF SOIL PROPERTY PARAMETERS, NSPPM  .',I5/5X,
     > 'PERMEABILITY INPUT CONTROL, KCP  . . . . . .',I5/)
 2090 FORMAT(/' INPUT TABLE 3A.  MOISTURE-CONTENT PARAMETERS'//
     > ' MAT NO.','     TH1         TH2         TH3    '/1X,
     > '     TH4         TH5         TH6    ')
 2100 FORMAT(I8,6D12.4/(8X,6D12.4))
 2110 FORMAT(/' INPUT TABLE 3B.  CONDUCTIVITY PARAMETERS'//
     > ' MAT NO.','     AK1         AK2         AK3    '/1x,
     > '     AK4         AK5         AK6    ')
 2120 FORMAT('0 INPUT TABLE 3.  SOIL PROPERTY INTERPOLATION VALUES'//1X,
     > ' MAT. NO.',9X,'PRESSURE',13X,'MOISTURE CONTENT',4X,
     > '   RELATIVE CONDUCTIVITY ',6X,'WATER CAPACITY')
 2130 FORMAT(I8,D19.4,3D25.4/(2X,4D25.4))
 2140 FORMAT(//5X,'*** ERROR IN READING COORDINATE STOP ***'/)
 2150 FORMAT('1','     **** NODAL COORDINATE DATA **** '//
     > 2(1X,' NODE','     X     ','     Y     ','     Z     ',1X)/
     > 2(1X,' ----',' ---------  ---------  --------- ',1X))
 2160 FORMAT(2(1X,I5,3D11.3,1X))
 2170 FORMAT('1'/5X,' *** OUTPUT GNLR(I,K) ***'//5X,'NREGN =',I5)
 2180 FORMAT(/6X,' ---- SUBREGION NUMBER K =',I4/(6X,10I5))
 2190 FORMAT('1','     **** ELEMENT DATA: GLOBAL INDICES OF ELEMENT ',
     > 'NODES **** '//5X,'  ELM',' NOD1',' NOD2',' NOD3',' NOD4',
     > ' NOD5',' NOD6',' NOD7',' NOD8',' MTYP'/5X,'  ---',' ----',
     > ' ----',' ----',' ----',' ----',' ----',' ----',' ----',' ----')
 2200 FORMAT(////'ERROR IN READING IE, MMP =',I5,' NEL =',I5,' STOP')
 2210 FORMAT(5X,10I5)
 2220 FORMAT(////' ERROR IN MATERIAL TYPE CODE FOR ELEMENT',I5///)
 2230 FORMAT('1','NSPPM = ',I5,' which is less than 0: STOP')
 2240 FORMAT('1    **** SOURCE/SINK AND B.C. CONTROL INTEGERS ***'//5X,
     > 'NO. OF ELEMENT-SOURCE/SINK ELEMENTS, NSEL . . . . .',I5/5X,
     > 'NO. OF ELEMENT-SOURCE/SINK PROFILES, NSPR . . . . .',I5/5X,
     > 'NO. OF DATA POINTS ON ELEMENT-SOURCE/SINK PROFILE .',I5/5X,
     > 'ANALYTICAL ELEMENT-SOURCE/SINK INPUT CONTROL  . . .',I5//5X,
     > 'NO. OF WELL-SOURCE/SINK NODES, NWNP . . . . . . . .',I5/5X,
     > 'NO. OF WELL-SOURCE/SINK PROFILES, NWPR  . . . . . .',I5/5X,
     > 'NO. OF DATA POINTS ON WELL-SOURCE/SINK PROFILE  . .',I5/5X,
     > 'ANALYTICAL WELL-SOURCE/SINK INPUT CONTROL . . . . .',I5//5X,
     > 'NO. OF DIRICHLET NODES, NDNP . . . . . . . . . . . ',I5/5X,
     > 'NO. OF DIRICHLET PROFILES, NDPR  . . . . . . . . . ',I5/5X,
     > 'NO. OF DATA POINTS ON DIRICHLET PROFILES, NDDP . . ',I5/5X,
     > 'ANALYTICAL DIRICHLET BV INPUT CONTROL  . . . . . . ',I5//)
 2250 FORMAT(1H /5X,
     > 'NO. OF VARIABLE BOUNDARY ELEMENT SIDES, NVES . . . ',I5/5X,
     > 'NO. OF VARIABLE BOUNDARY NODAL POINTS, NVNP  . . . ',I5/5X,
     > 'NO. OF RAINFALL PROFILES, NRPR . . . . . . . . . . ',I5/5X,
     > 'NO. OF DATA POINTS ON RAINFALL PROFILES, NRDP  . . ',I5/5X,
     > 'ANLYTICAL RAINFALL INPUT CONTROL . . . . . . . . . ',I5//5X,
     > 'NO. OF CAUCHY BOUNDARY ELEMENT SIDES, NCES . . . . ',I5/5X,
     > 'NO. OF CAUCHY BOUNDARY NODAL POINTS, NCNP  . . . . ',I5/5X,
     > 'NO. OF CAUCHY FLUX PROFILES, NCPR  . . . . . . . . ',I5/5X,
     > 'NO. OF DATA POINTS ON CAUCHY FLUX PROFILES, NCDP . ',I5/5X,
     > 'ANALYTICAL CAUCHY FLUX INPUT CONTROL . . . . . . . ',I5//5X,
     > 'NO. OF NEUMANN BOUNDARY ELEMENT SIDES, NNES  . . . ',I5/5X,
     > 'NO. OF NEUMANN BOUNDARY NODAL POINTS, NNNP . . . . ',I5/5X,
     > 'NO. OF NEUMANN FLUX PROFILES, NNPR . . . . . . . . ',I5/5X,
     > 'NO. OF DATA POINTS ON NEUMANN FLUX PROFILES, NNDP. ',I5/5X,
     > 'ANALYTICAL NEUMANN FLUX INPUT CONTROL  . . . . . . ',I5//)
 2260 FORMAT('1',/5X,' *** SOURCE INFORMATION ***')
 2270 FORMAT(//5X,' PROFILE NO.',I2,/ 3(4X,'TIME',6X,'SOURCE',2X)/
     > 3(4X,'----',6X,'------',2X))
 2280 FORMAT(' ',3(2D11.3))
 2290 FORMAT(///10X,' ELEMENT NUMBER AND PROFILE TYPES OF ELEMENT ',
     > '                 '//5X,5('    I','  LES',' STYP',5X))
 2300 FORMAT(' ',4X,5(3I5,5X))
 2310 FORMAT(////5X,' *** WELL SOURCE/SINK INFORMATION ***')
 2320 FORMAT(//5X,' PROFILE NO.',I2/ 4(4X,'TIME',6X,'SOURCE',2X)/
     >  4(4X,'----',6X,' -----',2X))
 2330 FORMAT(///10X,' GLOBAL NODAL NUMBER AND PROFILE TYPE OF WELLS ',
     > 'SOUCE/SINK NODES   '//5X,5('    I','  NPW',' WTYP',5X))
 2340 FORMAT(' ',4X,5(3I5,5X))
 2350 FORMAT('1'/5X,' **** RAINFALL-SEEPAGE BOUNDARY CONDITIONS ***')
 2360 FORMAT(////10X,' --- RAINFALL PROFILE ---')
 2370 FORMAT(//5X,' PROFILE NO.',I2,//3(4X,'TIME',6X,' RAINS',2X)/
     > 3(4X,'----',6X,'------',2X))
 2380 FORMAT(/10X,' *** ERROR IN READING RAINFALL-SEEPAGE ELEMENT ',
     > 'SIDE STOP ***')
 2390 FORMAT(//10X,' --- INPUTTED VARIABLE SIDE DATA ---'//5X,
     > 2('   MP  GN1  GN2  GN3  GN4 RTYP',5X)/5X,
     > 2('   --  ---  ---  ---  --- ----',5X))
 2400 FORMAT(' ',4X,2(6I5,5X))
 2410 FORMAT(//10X,' --- INPUTTED VARIABLE NODE DATA ---'//1X,
     > 2(1X,'    I NPVB     HCON        HMIN   ',1X)/1X,
     > 2(1X,'    - ----     ----        ----   ',1X))
 2420 FORMAT(' ',2(1X,2I5,2D12.4,1X))
 2430 FORMAT('1'/5X,' CANNOT FIND A BOUNDARY SIDE COINCIDING WITH '/1X,
     > I3,'-TH VARIABLE BOUNDARY SIDE: STOP ***')
 2440 FORMAT('1'/5X,' *** CANNOT FIND A BOUNDARY NODAL NUMBER FOR '/1X,
     > I3,'-TH VARIABLE BOUNDARY NODE STOP')
 2450 FORMAT(///10X,' COMPUTED BOUNDARY NODAL NUMBER OF ALL VB NODES ',
     > //5X,6('    I NPVB',2X)/5X,6('    - ----',2X))
 2460 FORMAT(' ',4X,6(2I5,2X))
 2470 FORMAT(/,5X,' *** CAN NOT FIND A COMPRESSED RS NODE FOR '/1X,
     > I2,'-TH POINT OF,I4,20H-TH RS SIDE STOP ***')
 2480 FORMAT(//10X,' --- COMPUTED VB SIDE DATA ---',//1X,
     > 2('   MP CNP1 CNP2 CNP3 CNP4  MPB RTYP',1X)/1X,
     > 2('   -- ---- ---- ---- ---- ---- ----',1X))
 2490 FORMAT(' ',2(7I5,1X))
 2500 FORMAT('1'/5X,' **** DIRICHLET BOUNDARY CONDITIONS ****')
 2510 FORMAT(//5X,' PROFILE NO.',I2,/ 3(4X,'TIME',6X,' HEAD ',2X)/
     > 3(4X,'----',6X,' ---- ',2X))
 2520 FORMAT(///10X,' GLOBAL NODAL NUMBER AND PROFILE TYPE OF DIRICH ',
     > 'LET BOUNDARY NODES'//5X,3('    I NPDB TYPE',5X)/
     > 5X,3('    - ---- ----',5X))
 2530 FORMAT(' ',4X,3(3I5,5X))
 2540 FORMAT('1'/5X,' **** CAUCHY  BOUNDARY CONDITIONS ****')
 2550 FORMAT(//5X,' PROFILE NO.',I2/ 3(4X,'TIME',6X,' FLUX ',2X)/
     > 3(4X,'----',6X,' ---- ',2X))
 2560 FORMAT(/,10X,' *** ERROR IN READING  CAUCHY  BOUNDARY ELEMENT ',
     > 'SIDE STOP *')
 2570 FORMAT(//10X,' --- INPUTTED CAUCHY SIDE DATA ---'//5X,
     > 2('   MP  GN1  GN2  GN3  GN4 CTYP',5X)/5X,
     > 2('   --  ---  ---  ---  --- ----',5X))
 2580 FORMAT(' ',4X,2(6I5,5X))
 2590 FORMAT(//10X,' --- INPUTTED CAUCHY NODE DATA ---'//5X,
     > 6('    I NPCB',2X)/5X,6('    - ----',2X))
 2600 FORMAT(' ',4X,6(2I5,2X))
 2610 FORMAT('1'/5X,' CANNOT FIND A BOUNDARY SIDE COINCIDING WITH ',
     > I3,'-TH CAUCY BOUNDARY SIDE:    STOP ***')
 2620 FORMAT('1'/5X,' *** CANNOT FIND A BOUNDARY NODAL NUMBER FOR ',
     > I3,'-TH CAUCHY BOUNDARY NODE:  STOP')
 2630 FORMAT(//10X,' --- COMPUTED CAUCHY NODE DATA ---'//5X,
     > 6('    I NPCB',2X)/5X,6('    - ----',2X))
 2640 FORMAT(' ',4X,6(2I5,2X))
 2650 FORMAT('1'/5X,' **** NEUMANN BOUNDARY CONDITIONS ****')
 2660 FORMAT(//5X,' PROFILE NO.',I2/ 3(4X,'TIME',6X,' FLUX ',2X)/
     > 3(4X,'----',6X,' ---- ',2X))
 2670 FORMAT(/,10X,' *** ERROR IN READING  NEUMANN BOUNDARY ELEMENT ',
     > 'SIDE STOP *')
 2680 FORMAT(//10X,' --- INPUTTED NEUMANN SIDE DATA ---'//5X,
     > 2('   MP  GN1  GN2  GN3  GN4 NTYP',5X)/5X,
     > 2('   --  ---  ---  ---  ---  ---',5X))
 2690 FORMAT(' ',4X,2(6I5,5X))
 2700 FORMAT(//10X,' --- INPUTTED NEUMANN NODE DATA ---'//5X,
     > 6('    I NPNB',2X)/5X,6('    - ----',2X))
 2710 FORMAT(' ',4X,6(2I5,2X))
 2720 FORMAT('1'/5X,' CANNOT FIND A BOUNDARY SIDE COINCIDING WITH ',
     > I3,'-TH NEUMANN BOUNDARY SIDE:   STOP ***')
 2730 FORMAT('1'/5X,' *** CANNOT FIND A BOUNDARY NODAL NUMBER FOR ',
     > I3,'-TH NEUMANN BOUNDARY NODE: STOP')
 2740 FORMAT(//10X,' --- COMPUTED NEUMANN NODE DATA ---'//5X,
     > 6('    I NPNB',2X)/5X,6('    - ----',2X))
 2750 FORMAT(' ',4X,6(2I5,2X))
C
C     + + + END SPECIFICATIONS + + +
C
C
C     ******* Data Set 2:  Basic Integer Parameters
C
      READ(LUINP,1000) DATNAM
      READ(LUINP,*) NNP,NEL,NMAT,NCM,NTI,KSS,NMPPM,KGRAV,
     >              ILUMP,IMID,NITER,NCYL,NDTCHG,NPITER
      IF (NDTCHG .LE. 0) THEN
C       NDTCHG must be at least equal to 1.
        NDTCHG = 1
      END IF
      WRITE(LUOUT,2000) NNP,NEL,NMAT,NCM,NTI,KSS,NMPPM,KGRAV,
     >                  ILUMP,IMID,NITER,NCYL,NDTCHG,NPITER
C
C     ******* Data SEt 3:  Basic Real Parameters
C
      READ(LUINP,1000) DATNAM
      READ(LUINP,*) DELT,CHNG,DELMAX,TMAX,TOLA,TOLB,RHO,GRAV,VISC,W,
     >              OME,OMI
C
      DELT0 = DELT
      IF (TMAX .LE. 0.0) THEN
C       Error in reading TMAX, set TMAX to 1.0D38
        TMAX = 1.0D38
      END IF
C
      WRITE(LUOUT,2010) DELT,CHNG,DELMAX,TMAX,TOLA,TOLB,RHO,GRAV,VISC,
     >              W,OME,OMI
C
C     ******* Data Set 4:  Line Printer, Disk Output, Time Step Change
C
      READ(LUINP,1000) DATNAM
C
      READ (LUINP,1010) KPR0,(KPR(ITM),ITM = 1,NTI)
      WRITE(LUOUT,2020)
      WRITE(LUOUT,2030) KPR0,(KPR(ITM),ITM = 1,NTI)
C
      READ (LUINP,1010) KDSK0,(KDSK(ITM),ITM = 1,NTI)
      WRITE(LUOUT,2040)
      WRITE(LUOUT,2030) KDSK0,(KDSK(ITM),ITM = 1,NTI)
C
      READ (LUINP,*)    (TDTCH(I),I = 1,NDTCHG)
      WRITE(LUOUT,2050) (TDTCH(I),I = 1,NDTCHG)
C
C     ******* Data Set 5:  Material Properties
C
      READ (LUINP,1000) DATNAM
      WRITE(LUOUT,2060)
      DO 100 I = 1,NMAT
        READ (LUINP,*)      (PROP(J,I),J = 1,NMPPM)
        WRITE(LUOUT,2070) I,(PROP(J,I),J = 1,NMPPM)
  100 CONTINUE
C
C     ******* Data Set 6:  Soil Properties
C
      READ (LUINP,1000) DATNAM
      READ (LUINP,*)    KSP,NSPPM,KCP
      WRITE(LUOUT,2080) KSP,NSPPM,KCP
C
      IF (KSP .NE. 1) THEN
C       Soil properties are read via analytical functions
        IF (NSPPM .GT. 0) THEN
C         moisture-content parameters
          WRITE(LUOUT,2090)
          DO 105 I = 1,NMAT
            READ (LUINP,*)      (THPROP(J,I),J = 1,NSPPM)
            WRITE(LUOUT,2100) I,(THPROP(J,I),J = 1,NSPPM)
  105     CONTINUE
C         conductivity parameters
C         WRITE(LUOUT,2110)
C         DO 110 I = 1,NMAT
C           READ (LUINP,*)      (AKPROP(J,I),J = 1,NSPPM)
C           WRITE(LUOUT,2100) I,(AKPROP(J,I),J = 1,NSPPM)
C 110     CONTINUE
        ELSE
C         print error message
          WRITE(LUOUT,2230) NSPPM
          STOP
        END IF
C
      ELSE
C       Soil properties are read via tabulet
C
        IF (NSPPM .GT. 0) THEN
C         read pressure head
          DO 130 I = 1,NMAT
            READ(LUINP,*) (HPROP(J,I),J = 1,NSPPM)
  130     CONTINUE
C         read mositure content
          DO 140 I = 1,NMAT
            READ(LUINP,*) (THPROP(J,I),J = 1,NSPPM)
  140     CONTINUE
C         read relative conductivity or relative permeability
          DO 150 I = 1,NMAT
            READ(LUINP,*) (AKPROP(J,I),J = 1,NSPPM)
  150     CONTINUE
C         read water capacity
          DO 160 I = 1,NMAT
            READ(LUINP,*) (CAPROP(J,I),J = 1,NSPPM)
  160     CONTINUE
C         print tabulet soil properties
          DO 170 I = 1,NMAT
            WRITE(LUOUT,2120)
            WRITE(LUOUT,2130) I,(HPROP(J,I),THPROP(J,I),AKPROP(J,I),
     >                        CAPROP(J,I),J = 1,NSPPM)
  170     CONTINUE
        ELSE
C         print error message
          WRITE(LUOUT,2230) NSPPM
          STOP
        END IF
C
      END IF
C
      IF (KCP .NE. 0) THEN
C       Convert from saturated permeability to saturated conductivity
        DO 190 I = 1,NMAT
          PKCF = RHO*GRAV/VISC
          DO 180 J = 1,6
            PROP(J,I) = PROP(J,I)*PKCF
  180     CONTINUE
  190   CONTINUE
      END IF
C
C     ******* Data Set 7:  Nodal Coordinates
C
      NPI = 0
      READ(LUINP,1000) DATNAM
      DONEFG = 0
  210 CONTINUE
        READ(LUINP,*) NI,NSEQ,NIAD,XI,YI,ZI,XIAD,YIAD,ZIAD
        IF (NI .EQ. 0) THEN
C         completed reading of nodal coordinates
          DONEFG = 1
        END IF
        IF (DONEFG .EQ. 0) THEN
C         more coordinates to process
          NJ = NI + NSEQ
          DO 220 NP = NI,NJ
            I    = NI + NIAD*(NP - NI)
            X(I) = XI + XIAD*DBLE(NP - NI)
            Y(I) = YI + YIAD*DBLE(NP - NI)
            Z(I) = ZI + ZIAD*DBLE(NP - NI)
            NPI  = NPI + 1
  220     CONTINUE
        END IF
      IF (DONEFG .EQ. 0) THEN
        GO TO 210
      END IF
C
      IF (NPI .NE. NNP) THEN
C       check error
        WRITE(LUOUT,2140)
        STOP
      END IF
C
C     print coordinate data
      IF (MOD(IGEOM,2) .NE. 0) THEN
        LINE = 0
        DO 265 NP = 1,NNP,2
          NJMN = NP
          NJMX = MIN0(NP + 1,NNP)
          IF (MOD(LINE,50) .EQ. 0) THEN
C           need a new header
            WRITE(LUOUT,2150)
          END IF
          LINE = LINE + 1
          WRITE(LUOUT,2160) (NJ,X(NJ),Y(NJ),Z(NJ),NJ = NJMN,NJMX)
  265   CONTINUE
      END IF
C
C     ******* Data Set 6:  Subregion Data
C
      READ(LUINP,1000) DATNAM
      READ(LUINP,*) NREGN
C     Read subregion data
      CALL READN(LUINP,LUOUT,MXREGN,NREGN,NNPLR)
      IF (MOD(IGEOM,2) .NE. 0) THEN
C       print number of subregions
        WRITE(LUOUT,2170) NREGN
      END IF
      DO 280 K = 1,NREGN
        LNNP = NNPLR(K)
C       read the mapping between global and local node number
        CALL READN(LUINP,LUOUT,LTMXNP,LNNP,GNLR(1,K))
        IF(MOD(IGEOM,2) .NE. 0) THEN
C         print the mapping between global and local node number
          WRITE(LUOUT,2180) K,(GNLR(I,K),I = 1,LNNP)
        END IF
  280 CONTINUE
C
C     ******* Data Set 9:  Element Data
C
      READ(LUINP,1000) DATNAM
      MMP    = 0
      DONEFG = 0
  300 CONTINUE
        READ(LUINP,*) MI,NSEQ,MIAD,(IEM(I),I = 1,8),IEMAD
        IF (MI .EQ. 0) THEN
C         done with element data
          DONEFG = 1
        END IF
        IF (DONEFG .EQ. 0) THEN
C         fill the gap between elements
          MJ = MI + NSEQ
          DO 320 MP = MI,MJ
            M = MI + (MP - MI)*MIAD
            DO 310 IQ = 1,8
              NI       = IEM(IQ) + (MP - MI)*IEMAD
              IE(M,IQ) = NI
  310       CONTINUE
            MMP = MMP + 1
  320     CONTINUE
        END IF
      IF (DONEFG .EQ. 0) THEN
        GO TO 300
      END IF
C
      IF (MMP .NE. NEL) THEN
C       check error
        WRITE(LUOUT,2200) MMP,NEL
        STOP
      END IF
C
C     Set default material type to 1
      DO 360 M = 1,NEL
        IE(M,9) = 1
  360 CONTINUE
C
C     ******* Data Set 10:  Material Corrections
C
      IF (NCM .GT. 0) THEN
C       read elements that require material correction
        READ(LUINP,1000) DATNAM
        CALL READN(LUINP,LUOUT,MAXEL,NCM,IE(1,9))
      END IF
C
      IF (MOD(IGEOM,2) .NE. 0) THEN
C       print element data
        LINE = 0
        DO 410 NI = 1,NEL
          IF (MOD(LINE,50) .EQ. 0) THEN
C           need a new header
            WRITE(LUOUT,2190)
          END IF
          LINE = LINE + 1
          WRITE(LUOUT,2210) NI,(IE(NI,K),K = 1,9)
  410   CONTINUE
      END IF
C
C     check material type error
      DO 420 M = 1,NEL
        MTYP = IE(M,9)
        IF (MTYP .LE. 0 .OR. MTYP .GT. NMAT) THEN
C         found material type error
          WRITE(LUOUT,2220) M
          STOP
        END IF
  420 CONTINUE
C
      IF(IGEOM .LE. 3) THEN
        CALL PAGEN
     I            (IE,NNPLR,LUOUT,
     M             GNLR,
     O             LRN,LRL,NLRL,LNOJCN,LMAXDF,NTNPLR)
      END IF
      IF (IGEOM .LE. 1) THEN
C       identify boundary sides and boundary nodes
        CALL SURF
     I           (LUOUT, X,Y,Z,IE,LRL,NLRL,
     O            DCOSB,ISB,NPBB)
      END IF
C
      REWIND(UNIT=LUBAR)
C
      IF (IGEOM .LE. 1) THEN
C       write binary boundary arrays
        WRITE(LUBAR) NBES,NBNP,((DCOSB(J,I),J = 1,3),
     >  I = 1,NBES),((ISB(J,I),J = 1,6),I = 1,NBES),(NPBB(I),I = 1,NBNP)
      ELSE IF (IGEOM .GT. 1) THEN
C       read binary boundary arrays
        READ(LUBAR) NBES,NBNP,((DCOSB(J,I),J = 1,3),
     >  I = 1,NBES),((ISB(J,I),J = 1,6),I = 1,NBES),(NPBB(I),I = 1,NBNP)
      END IF
C
C     ******* Data Set 11:  Initial Conditions Data
C
      READ(LUINP,1000) DATNAM
      CALL READR(LUINP,LUOUT,MAXNP,NNP,H)
C
C     ******* Data Set 12:  Source/sink and BC Control Integers
C
      READ (LUINP,1000) DATNAM
      READ (LUINP,*)    NSEL,NSPR,NSDP,KSAI,NWNP,NWPR,NWDP,KWAI,
     >                  NDNP,NDPR,NDDP,KDAI,
     >                  NVES,NVNP,NRPR,NRDP,KRAI,NCES,NCNP,NCPR,NCDP,
     >                  KCAI, NNES,NNNP,NNPR,NNDP,KNAI
      WRITE(LUOUT,2240) NSEL,NSPR,NSDP,KSAI,NWNP,NWPR,NWDP,KWAI,
     >                  NDNP,NDPR,NDDP,KDAI
      WRITE(LUOUT,2250) NVES,NVNP,NRPR,NRDP,KRAI,NCES,NCNP,NCPR,NCDP,
     >                  KCAI, NNES,NNNP,NNPR,NNDP,KNAI
C
C     ******* Data Set 13:  Source/sink Data
C
      IF (NSEL .NE. 0 .OR. NWNP .NE. 0) THEN
C       read data set name
        READ(LUINP,1000) DATNAM
      END IF
C
      IF (NSEL .NE. 0) THEN
C
C       element source/sink data
        WRITE(LUOUT,2260)
C       profile data
        DO 510 I = 1,NSPR
          READ (LUINP,*)    (TSOSF(J,I),SOSF(J,I),J = 1,NSDP)
          WRITE(LUOUT,2270) I
          WRITE(LUOUT,2280) (TSOSF(J,I),SOSF(J,I),J = 1,NSDP)
  510   CONTINUE
C       source element
        READ(LUINP,*) (LES(M),M = 1,NSEL)
C       profile type assigned to each element
        CALL READN(LUINP,LUOUT,MXSEL,NSEL,ISTYP)
C       print source/sink data
        LINE = 0
        DO 520 I = 1,NSEL,5
          IF (MOD(LINE,50) .EQ. 0) THEN
C           need a new header
            WRITE(LUOUT,2290)
          END IF
          LINE = LINE + 1
          NJMN = I
          NJMX = MIN0(I + 4,NSEL)
          WRITE(LUOUT,2300) (J,LES(J),ISTYP(J),J = NJMN,NJMX)
  520   CONTINUE
      END IF
C
      IF (NWNP .NE. 0) THEN
C       well source/sink data
        WRITE(LUOUT,2310)
C       profile data
        DO 570 I = 1,NWPR
          READ (LUINP,*)    (TWSSF(J,I),WSSF(J,I),J = 1,NWDP)
          WRITE(LUOUT,2320) I
          WRITE(LUOUT,2280) (TWSSF(J,I),WSSF(J,I),J = 1,NWDP)
  570   CONTINUE
C       well source/sink nodes
        READ(LUINP,*) (NPW(I),I = 1,NWNP)
C       profile type assigned to each well source/sink node
        CALL READN(LUINP,LUOUT,MXWNP,NWNP,IWTYP)
C       print well source/sink data
        LINE = 0
        DO 590 I = 1,NWNP,5
          IF (MOD(LINE,50) .EQ. 0) THEN
C           need a new header
            WRITE(LUOUT,2330)
          END IF
          LINE = LINE + 1
          NJMN = I
          NJMX = MIN0(I + 4,NWNP)
          WRITE(LUOUT,2340) (J,NPW(J),IWTYP(J),J = NJMN,NJMX)
  590   CONTINUE
      END IF
C
C     ******* Data Set 14:  Variable Boundary Conditions
C
      IF (NVES .NE. 0) THEN
C       variable boundary element sides
        READ(LUINP,1000) DATNAM
        WRITE(LUOUT,2350)
C
C       read and write rainfall (+)/evaporation (-) profiles
        WRITE(LUOUT,2360)
        DO 610 I = 1,NRPR
          READ (LUINP,*)    (TRF(J,I),RF(J,I),J = 1,NRDP)
          WRITE(LUOUT,2370) I
          WRITE(LUOUT,2280) (TRF(J,I),RF(J,I),J = 1,NRDP)
  610   CONTINUE
C
C       read rainfall/evaporation type assigned to VB sides
        CALL READN(LUINP,LUOUT,MXVES,NVES,IRTYP)
C
C       read four global nodes for all variable boundary sides
        MPI    = 0
        DONEFG = 0
  620   CONTINUE
          READ(LUINP,*) MI,NSEQ,MIAD,I1,I2,I3,I4,I1AD,I2AD,I3AD,I4AD
          IF (MI .EQ. 0) THEN
C           completed reading of variable boundary element sides
            DONEFG = 1
          END IF
          IF (DONEFG .EQ. 0) THEN
C           process additional variable boundary element side
            MJ = MI + NSEQ
            DO 625 MP = MI,MJ
              I        = MI + (MP - MI)*MIAD
              ISV(1,I) = I1 + (MP - MI)*I1AD
              ISV(2,I) = I2 + (MP - MI)*I2AD
              ISV(3,I) = I3 + (MP - MI)*I3AD
              ISV(4,I) = I4 + (MP - MI)*I4AD
              MPI      = MPI + 1
  625       CONTINUE
          END IF
        IF (DONEFG .EQ. 0) THEN
          GO TO 620
        END IF
C
        IF (MPI .NE. NVES) THEN
C         check errors
          WRITE(LUOUT,2380)
          STOP
        END IF
C
C       print input global node numbers and profile types of all VB
C       sides
        LINE = 0
        DO 640 MP = 1,NVES,2
          IF (MOD(LINE,50) .EQ. 0) THEN
C           need a new header
            WRITE(LUOUT,2390)
          END IF
          LINE = LINE + 1
          NJMN = MP
          NJMX = MIN0(MP+1,NVES)
          WRITE(LUOUT,2400) (J,(ISV(I,J),I=1,4),IRTYP(J),J=NJMN,NJMX)
  640   CONTINUE
C
C       read global node number of all VB nodes
        CALL READN(LUINP,LUOUT,MXVNP,NVNP,NPVB)
C
C       read ponding depth of all VB nodes
        CALL READR(LUINP,LUOUT,MXVNP,NVNP,HCON)
C
C       read minimum pressure allowed for all VB nodes
        CALL READR(LUINP,LUOUT,MXVNP,NVNP,HMIN)
C
C       print global node number, ponding depth, minimum pressure
C       for all VB nodes
C
        LINE = 0
        DO 645 I = 1,NVNP,2
          IF (MOD(LINE,50) .EQ. 0) THEN
C           need a new header
            WRITE(LUOUT,2410)
          END IF
          LINE = LINE + 1
          NJMN = I
          NJMX = MIN0(I + 1,NVNP)
          WRITE(LUOUT,2420) (J,NPVB(J),HCON(J),HMIN(J),J = NJMN,NJMX)
  645   CONTINUE
C
C       compute boundary side number for all VB sides
C
        MI = 0
  650   CONTINUE
          MI = MI + 1
C         store four nodes of the side MI in NIMI for comparison
c         with four nodes of the side MJ
          DO 651 IQ = 1,4
            NIMI(IQ) = ISV(IQ,MI)
  651     CONTINUE
          MJ   = 0
          MJDO = 1
C         loop over the side MJ
  652     CONTINUE
            MJ = MJ + 1
C           Put four nodes of the side MJ in NJMJ for comparison with
C           four nodes already stored in NIMI
            DO 653 JQ = 1,4
              IJ       = ISB(JQ,MJ)
              NJMJ(JQ) = NPBB(IJ)
  653       CONTINUE
C           start the loop to compare if four nodes in NIMI are the same
c           four nodes in NJMJ
            IEQ  = 0
            IQ   = 0
            IQDO = 1
C           loop over four nodes in NIMI
  656       CONTINUE
              IQ   = IQ + 1
              NI   = NIMI(IQ)
              JQ   = 0
              JQDO = 1
C             loop over four nodes in NJMJ
  657         CONTINUE
                JQ = JQ + 1
                NJ = NJMJ(JQ)
                IF (NJ .EQ. NI) THEN
C                 accumuate the number of nodes that appear in both
C                 NIMI and NJMJ
                  IEQ  = IEQ + 1
                  JQDO = 0
                END IF
              IF (JQDO .EQ. 1 .AND. JQ .LT. 4) THEN
C             JQ is not the same node as IQ, search for another JQ
                GO TO 657
              END IF
              IF (JQDO .EQ. 1) THEN
C               None of the four nodes in NJMJ is node IQ, set IQDO
C               to 0 because there is not need to search IQ anymore
                IQDO = 0
              END IF
C           One of the four nodes in NJMJ is the same node as IQ-th node
C           Search for another node IQ
            IF (IQDO .EQ. 1 .AND. IQ .LT. 4) THEN
              GO TO 656
            ENDIF
            IF (IQDO .EQ. 1 .AND. IEQ .EQ. 4) THEN
C             Four nodes in NIMI are the same four ndoes in NJMJ
C             set MJDO to zero because there is no need to search
C             another side MJ.  We have already found the side MJ
C             coinciding with the side MI
              MJDO = 0
            END IF
C
          IF (MJDO .EQ. 1 .AND. MJ .LT. NBES) THEN
C           We have not found a MJ containing the same four nodes in MI
C           search for another MJ
            GO TO 652
          END IF
          IF (MJDO .EQ. 1) THEN
C           None of the MJ has the same four nodes in MI, error and stop.
            WRITE(LUOUT,2430) MI
            STOP
          END IF
          ISV(5,MI) = MJ
        IF (MI .LT. NVES) THEN
C       We have not finish all variable-boundary sides yet,
C       do for another side MI
          GO TO 650
        END IF
C
C       change NPVB from containing global nodal number to
C       containing boundary nodal number
C
        NP = 0
  665   CONTINUE
C         Loop over all NVNP nodes
          NP = NP + 1
          NI = NPVB(NP)
C
          I   = 0
          IDO = 1
  667     CONTINUE
C           loop over all boundary nodes to see which boundary node has
C           the same global node as the NP-th variable boundary node.
            I  = I + 1
            NJ = NPBB(I)
c
            IF (NJ .EQ. NI) THEN
C             we have found the boundary node which has the same
c             global node as the NP-th variable boundary node, set
c             IDo to zero since we no longer need to search another
C             boundary node
              NII = I
              IDO = 0
            END IF
C
          IF (IDO .EQ. 1 .AND. I .LT. NBNP) THEN
            GO TO 667
          END IF
C
          IF (IDO .EQ. 1) THEN
C           cant find boundary node that has the same global node
C           as the NP-th variable boundary node
C           print error message
            WRITE(LUOUT,2440) NP
            STOP
          END IF
          NPVB(NP) = NII
        IF (NP .LT. NVNP) THEN
          GO TO 665
        END IF
C
C
C       print computed boundary nodal number for all VB nodes
        LINE = 0
        DO 670 I = 1,NVNP,6
          IF (MOD(LINE,50) .EQ. 0) THEN
C           need a new header
            WRITE(LUOUT,2450)
          END IF
          LINE = LINE + 1
          NJMN = I
          NJMX = MIN0(I + 5,NVNP)
          WRITE(LUOUT,2460) (J,NPVB(J),J = NJMN,NJMX)
  670   CONTINUE
C
C       change ISV(I,NP) I=1,4 from containing global nodal number
C       to containing compressed varible-boundary nodal number
C
        MP = 0
  675   CONTINUE
C         loop over all variable-boundary sides
          MP  = MP + 1
          MPB = ISV(5,MP)
          IQ  = 0
  685     CONTINUE
C           for each variable-boundary side, loop over its four nodes
            IQ  = IQ + 1
            NB  = ISB(IQ,MPB)
C
            I   = 0
            IDO = 1
  690       CONTINUE
C             loop over all variable boundary nodes to see if any of
C             them has the same boundary node number as that of the
C             IQ-th node of the MP-th variable-boundary side
              I  = I + 1
              NI = NPVB(I)
              IF (NI .EQ. NB) THEN
C               we have found a variable-boundary node that has the same
c               boundary node as that of IQ, record this information
                NII = I
                IDO = 0
              END IF
            IF (IDO .EQ. 1 .AND. I .LT. NVNP) THEN
              GO TO 690
            END IF
            IF (IDO .EQ. 1) THEN
C             print error message
              WRITE(LUOUT,2470) IQ,MP
              STOP
            END IF
            ISV(IQ,MP) = NII
          IF (IQ .LT. 4) THEN
            GO TO 685
          END IF
        IF (MP .LT. NVES) THEN
          GO TO 675
        END IF
C
C       print computed boundary nodal number and side number and
C       rainfall types for all VB sides
        LINE = 0
        DO 695 MP = 1,NVES,2
          IF (MOD(LINE,50) .EQ. 0) THEN
C           need a new header
            WRITE(LUOUT,2480)
          END IF
          LINE = LINE + 1
          NJMN = MP
          NJMX = MIN0(MP + 1,NVES)
          WRITE(LUOUT,2490) (J,(ISV(I,J),I=1,5),IRTYP(J),J=NJMN,NJMX)
  695   CONTINUE
C
      END IF
C
C     ******* Data Set 14:  Dirichlet Boundary Conditions
C
      IF (NDNP .NE. 0) THEN
C
C       read and write total head profiles
        READ (LUINP,1000) DATNAM
        WRITE(LUOUT,2500)
        DO 710 I = 1,NDPR
          READ (LUINP,*)    (THDBF(J,I),HDBF(J,I),J = 1,NDDP)
          WRITE(LUOUT,2510) I
          WRITE(LUOUT,2280) (THDBF(J,I),HDBF(J,I),J = 1,NDDP)
  710   CONTINUE
C
C       read global nodal number for all Dirichlet nodes
        READ(LUINP,*) (NPDB(I),I = 1,NDNP)
C
C       read total head profile type assigned to all Dirichlet nodes
        CALL READN(LUINP,LUOUT,MXDNP,NDNP,IDTYP)
C
C       print global nodal number and total head profiles for all
C       Dirichlet nodes
        LINE = 0
        DO 720 I = 1,NDNP,3
          IF (MOD(LINE,50) .EQ. 0) THEN
C           need a new header
            WRITE(LUOUT,2520)
          END IF
          LINE = LINE + 1
          NJMN = I
          NJMX = MIN0(I + 2,NDNP)
          WRITE(LUOUT,2530) (J,NPDB(J),IDTYP(J),J = NJMN,NJMX)
  720   CONTINUE
      END IF
C
C     ******* Data Set 16:  Cauchy Boundary Conditions
C
      IF (NCES .NE. 0) THEN
C
        READ (LUINP,1000) DATNAM
        WRITE(LUOUT,2540)
C
C       read and write Cauchy profiles
        DO 810 I = 1,NCPR
          READ (LUINP,*)    (TQCBF(J,I),QCBF(J,I),J = 1,NCDP)
          WRITE(LUOUT,2550) I
          WRITE(LUOUT,2280) (TQCBF(J,I),QCBF(J,I),J = 1,NCDP)
  810   CONTINUE
C
C       read Cauchy type assigned to Cauchy sides
        CALL READN(LUINP,LUOUT,MXCES,NCES,ICTYP)
C
C       read four global nodes for all Cauchy boundary sides
        MPI    = 0
        DONEFG = 0
  820   CONTINUE
          READ(LUINP,*) MI,NSEQ,MIAD,I1,I2,I3,I4,I1AD,I2AD,I3AD,I4AD
          IF (MI .EQ. 0) THEN
C           all done Cauchy boundary sides
            DONEFG = 1
          END IF
          IF (DONEFG .EQ. 0) THEN
C           process Cauchy boundary sides
            MJ = MI + NSEQ
            DO 825 MP = MI,MJ
              I = MI + (MP - MI)*MIAD
              ISC(1,I) = I1 + (MP - MI)*I1AD
              ISC(2,I) = I2 + (MP - MI)*I2AD
              ISC(3,I) = I3 + (MP - MI)*I3AD
              ISC(4,I) = I4 + (MP - MI)*I4AD
              MPI = MPI + 1
  825       CONTINUE
          END IF
        IF (DONEFG .EQ. 0) THEN
          GO TO 820
        END IF
C
        IF (MPI .NE. NCES) THEN
C         check errors
          WRITE(LUOUT,2560)
          STOP
        END IF
C
C       print input global node numbers and profile types of all
C       Cauchy sides
C
        LINE = 0
        DO 840 MP = 1,NCES,2
          IF (MOD(LINE,50) .EQ. 0) THEN
C           need a new header
            WRITE(LUOUT,2570)
          END IF
          LINE = LINE + 1
          NJMN = MP
          NJMX = MIN0(MP + 2,NCES)
          WRITE(LUOUT,2580) (J,(ISC(I,J),I=1,4),ICTYP(J),J=NJMN,NJMX)
  840   CONTINUE
C
C       read global nodal number of all Cauchy nodes
        READ(LUINP,*) (NPCB(I),I = 1,NCNP)
C
C       print global nodal number of all Cauchy nodes
        LINE = 0
        DO 845 I = 1,NCNP,6
          IF (MOD(LINE,50) .EQ. 0) THEN
C           need a new header
            WRITE(LUOUT,2590)
          END IF
          LINE = LINE + 1
          NJMN = I
          NJMX = MIN0(I + 5,NCNP)
          WRITE(LUOUT,2600) (J,NPCB(J),J = NJMN,NJMX)
  845   CONTINUE
C
C       compute boundary side number for all Cahchy sides
C
        MI = 0
  850   CONTINUE
          MI = MI + 1
C         store four nodes of the side MI in NIMI for comparison
c         with four nodes of the side MJ
          DO 851 IQ = 1,4
            NIMI(IQ) = ISC(IQ,MI)
  851     CONTINUE
          MJ   = 0
          MJDO = 1
c         loop over the side MJ
  852     CONTINUE
C           Put four nodes of the side MJ in NJMJ for comparison with
C           four nodes already stored in NIMI
            MJ = MJ + 1
            DO 853 JQ = 1,4
              IJ       = ISB(JQ,MJ)
              NJMJ(JQ) = NPBB(IJ)
  853       CONTINUE
C           start the loop to compare if four nodes in NIMI are the same
c           four nodes in NJMJ
            IEQ  = 0
            IQ   = 0
            IQDO = 1
c           loop over four nodes in NIMI
  856       CONTINUE
              IQ   = IQ + 1
              NI   = NIMI(IQ)
              JQ   = 0
              JQDO = 1
C             loop over four nodes in NJMJ
  857         CONTINUE
                JQ = JQ + 1
                NJ = NJMJ(JQ)
                IF (NJ .EQ. NI) THEN
C                 accumuate the number of nodes that appear in both
C                 NIMI and NJMJ
                  IEQ  = IEQ + 1
                  JQDO = 0
                END IF
              IF (JQDO .EQ. 1 .AND. JQ .LT. 4) THEN
C             JQ is not the same node as IQ, search for another JQ
                GO TO 857
              END IF
              IF (JQDO .EQ. 1) THEN
C               None of the four nodes in NJMJ is node IQ, set IQDO
C               to 0 because there is not need to search IQ anymore
                IQDO = 0
              END IF
            IF (IQDO .EQ. 1 .AND. IQ .LT. 4) THEN
C           One of the four nodes in NJMJ is the same node as IQ-th node
C           Search for another node IQ
              GO TO 856
            ELSE IF (IQDO .EQ. 1 .AND. IEQ .EQ. 4) THEN
C             Four nodes in NIMI are the same four ndoes in NJMJ
C             set MJDO to zero because there is no need to search
C             another side MJ.  We have already found the side MJ
C             coinciding with the side MI
              MJDO = 0
            END IF
C
          IF (MJDO .EQ. 1 .AND. MJ .LT. NBES) THEN
C           We have not found a MJ containing the same four nodes in MI
C           search for another MJ
            GO TO 852
          END IF
          IF (MJDO .EQ. 1) THEN
C           None of the MJ has the same four nodes in MI, error and stop.
            WRITE(LUOUT,2610) MI
            STOP
          END IF
          ISC(5,MI) = MJ
        IF (MI .LT. NCES) THEN
C       We have not finish all Cauchy-boundary sides yet,
C       do for another side MI
          GO TO 850
        END IF
C
C       change NPCB from containing global nodal number to
C       containing boundary nodal number
C
        NP = 0
  865   CONTINUE
C         Loop over all NCNP nodes
          NP = NP + 1
          NI = NPCB(NP)
C                                           ???
          I   = 0
          IDO = 0
C
  867     CONTINUE
C           loop over all boundary nodes to see which boundary node has
C           the same global node as the NP-th Cauchy boundary node.
            I  = I + 1
            NJ = NPBB(I)
C
            IF (NJ .EQ. NI) THEN
C             we have found the boundary node which has the same
c             global node as the NP-th variable boundary node, set
c             IDo to zero since we no longer need to search another
C             boundary node
              NII = I
              IDO = 0
            END IF
C
          IF (IDO .EQ. 1 .AND. I .LT. NBNP) THEN
            GO TO 867
          END IF
          IF (IDO .EQ. 1) THEN
C           cant find boundary node that has the same global node
C           as the NP-th Cauchy-boundary node
C           print error message
            WRITE(LUOUT,2620) NP
            STOP
          END IF
          NPCB(NP) = NII
        IF (NP .LT. NCNP) THEN
          GO TO 865
        END IF
C
C       print computed boundary nodal number of all Cauchy nodes
        LINE = 0
        DO 870 I = 1,NCNP,6
          IF (MOD(LINE,50) .EQ. 0) THEN
C           need a new header
            WRITE(LUOUT,2630)
          END IF
          LINE = LINE +  1
          NJMN = I
          NJMX = MIN0(I + 5,NCNP)
          WRITE(LUOUT,2640) (J,NPCB(J),J = NJMN,NJMX)
  870   CONTINUE
      END IF
C
C     ******* Data Set 17:  Neuman boundary conditions
C
      IF (NNES .NE. 0) THEN
C
        READ (LUINP,1000) DATNAM
        WRITE(LUOUT,2650)
C
C       read and write Neuman profiles
        DO 910 I = 1,NNPR
          READ (LUINP,*)    (TQNBF(J,I),QNBF(J,I),J = 1,NNDP)
          WRITE(LUOUT,2660) I
          WRITE(LUOUT,2280) (TQNBF(J,I),QNBF(J,I),J = 1,NNDP)
  910   CONTINUE
C
C       read Neuman flux type assigned to all Neuman sides
        CALL READN(LUINP,LUOUT,MXNES,NNES,INTYP)
C
C       read four global nodal numbers for all Neuman sides
        MPI    = 0
        DONEFG = 0
  920   CONTINUE
          READ(LUINP,*) MI,NSEQ,MIAD,I1,I2,I3,I4,I1AD,I2AD,I3AD,I4AD
          IF (MI .EQ. 0) THEN
C           done reading Neuman profiles
            DONEFG = 1
          END IF
          IF (DONEFG .EQ. 0) THEN
C           process another Neuman
            MJ = MI + NSEQ
            DO 925 MP = MI,MJ
              I        = MI + (MP - MI)*MIAD
              ISN(1,I) = I1 + (MP - MI)*I1AD
              ISN(2,I) = I2 + (MP - MI)*I2AD
              ISN(3,I) = I3 + (MP - MI)*I3AD
              ISN(4,I) = I4 + (MP - MI)*I4AD
              MPI      = MPI + 1
  925       CONTINUE
          END IF
        IF (DONEFG .EQ. 0) THEN
          GO TO 920
        END IF
C
        IF (MPI .NE. NNES) THEN
C         check errors
          WRITE(LUOUT,2670)
          STOP
        END IF
C
C       print input global nodal numbers and profile types of all
C       Neuman sides
        LINE = 0
        DO 940 MP = 1,NNES,2
          IF (MOD(LINE,50) .EQ. 0) THEN
C           need a new header
            WRITE(LUOUT,2680)
          END IF
          LINE = LINE + 1
          NJMN = MP
          NJMX = MIN0(MP + 1,NNES)
          WRITE(LUOUT,2690) (J,(ISN(I,J),I=1,4),INTYP(J),J=NJMN,NJMX)
  940   CONTINUE
C
C       read global nodal numbers for all Neuman nodes
        READ(LUINP,*) (NPNB(I),I = 1,NNNP)
C
C       print global nodal number for all Neuman nodes
        LINE = 0
        DO 945 I = 1,NNNP,6
          IF (MOD(LINE,50) .EQ. 0) THEN
C           need a new header
            WRITE(LUOUT,2700)
          END IF
          LINE = LINE + 1
          NJMN = I
          NJMX = MIN0(I + 5,NNNP)
          WRITE(LUOUT,2710) (J,NPNB(J),J = NJMN,NJMX)
  945   CONTINUE
C
C       compute boundary side number for all Neuman sides
C
        MI = 0
  950   CONTINUE
C         store four nodes of the side MI in NIMI for comparison
c         with four nodes of the side MJ
          MI = MI + 1
          DO 951 IQ = 1,4
            NIMI(IQ) = ISN(IQ,MI)
  951     CONTINUE
          MJ   = 0
          MJDO = 1
c         loop over the side MJ
  952     CONTINUE
C           Put four nodes of the side MJ in NJMJ for comparison with
C           four nodes already stored in NIMI
            MJ = MJ + 1
            DO 953 JQ = 1,4
              IJ       = ISB(JQ,MJ)
              NJMJ(JQ) = NPBB(IJ)
  953       CONTINUE
C           start the loop to compare if four nodes in NIMI are the same
c           four nodes in NJMJ
            IEQ  = 0
            IQ   = 0
            IQDO = 1
C           loop over four nodes in NIMI
  956       CONTINUE
              IQ   = IQ + 1
              NI   = NIMI(IQ)
              JQ   = 0
              JQDO = 1
C             loop over four nodes in NJMJ
  957         CONTINUE
                JQ = JQ + 1
                NJ = NJMJ(JQ)
                IF (NJ .EQ. NI) THEN
C                 accumuate the number of nodes that appear in both
C                 NIMI and NJMJ
                  IEQ  = IEQ + 1
                  JQDO = 0
                END IF
              IF (JQDO .EQ. 1 .AND. JQ .LT. 4) THEN
C             JQ is not the same node as IQ, search for another JQ
                GO TO 957
              END IF
              IF (JQDO .EQ. 1) THEN
C               None of the four nodes in NJMJ is node IQ, set IQDO
C               to 0 because there is not need to search IQ anymore
                IQDO = 0
              END IF
            IF (IQDO .EQ. 1 .AND. IQ .LT. 4) THEN
C           One of the four nodes in NJMJ is the same node as IQ-th node
C           Search for another node IQ
              GO TO 956
            ELSE IF (IQDO .EQ. 1 .AND. IEQ .EQ. 4) THEN
C             Four nodes in NIMI are the same four ndoes in NJMJ
C             set MJDO to zero because there is no need to search
C             another side MJ.  We have already found the side MJ
C             coinciding with the side MI
              MJDO = 0
            END IF
C
          IF (MJDO .EQ. 1 .AND. MJ .LT. NBES) THEN
C           We have not found a MJ containing the same four nodes in MI
C           search for another MJ
            GO TO 952
          END IF
          IF (MJDO .EQ. 1) THEN
C           None of the MJ has the same four nodes in MI, error and stop.
            WRITE(LUOUT,2720) MI
            STOP
          END IF
          ISN(5,MI) = MJ
        IF (MI .LT. NNES) THEN
C       We have not finish all Neumann-boundary sides yet,
C       do for another side MI
          GO TO 950
        END IF
C
C       change NPNB from containing global nodal number to
C       containing boundary nodal number
C
        NP = 0
  965   CONTINUE
C         Loop over all NNNP nodes
          NP = NP + 1
          NI = NPNB(NP)
C
          I   = 0
          IDO = 0
  967     CONTINUE
C           loop over all boundary nodes to see which boundary node has
C           the same global node as the NP-th Neumann boundary node.
            I  = I + 1
            NJ = NPBB(I)
C
            IF (NJ .EQ. NI) THEN
C             we have found the boundary node which has the same
c             global node as the NP-th variable boundary node, set
c             IDo to zero since we no longer need to search another
C             boundary node
              NII = I
              IDO = 0
            END IF
C
          IF (IDO .EQ. 1 .AND. I .LT. NBNP) THEN
            GO TO 967
           END IF
          IF (IDO .EQ. 1) THEN
C           cant find boundary node that has the same global node
C           as the NP-th Neumann-boundary node
C           print error message
            WRITE(LUOUT,2730) NP
            STOP
          END IF
          NPNB(NP) = NII
        IF (NP .LT. NNNP) THEN
          GO TO 965
        END IF
C
C       print computed boundary nodal number for all Neuman nodes
        LINE = 0
        DO 970 I = 1,NNNP,6
          IF (MOD(LINE,50) .EQ. 0) THEN
C           need a new header
            WRITE(LUOUT,2740)
          END IF
          LINE = LINE + 1
          NJMN = I
          NJMX = MIN0(I + 5,NNNP)
          WRITE(LUOUT,2750) (J,NPNB(J),J = NJMN,NJMX)
  970   CONTINUE
      END IF
C
      RETURN
      END
