      SUBROUTINE   GW3D
     I            (LUINP,LUOUT,LUSTO,LUBAR,LUPAR,
     M             X,Y,Z,IE,CMATRX,LRN,RLD,RI,RL,HP,HW,HT,TH,DTH,AKR,
     M             NPCNV,DCOSB,ISB,NPBB,BFLX,BFLXP, SOS,SOSF,TSOSF,
     M             ISTYP,LES,WSS,WSSF,TWSSF,IWTYP,NPW, QCB,QCBF,
     M             TQCBF,ICTYP,ISC,NPCB,QNB,QNBF,TQNBF,INTYP,ISN,
     M             NPNB,RFALL,RF,TRF,IRTYP,ISV,NPVB,DCYFLX,FLX,HCON,
     M             HMIN,NPFLX,NPCON,NPMIN,HDB,HDBF,THDBF,IDTYP,NPDB,
     M             PROP,THPROP,AKPROP,CAPROP,HPROP, KPR,KDSK,TDTCH,
     M             NTNPLR,NNPLR,LMAXDF,GNLR,LNOJCN,CMTRXL,RLDL,LRL,NLRL,
     O             H,VX,VY,VZ)
C
C     + + + PURPOSE + + +
C     To control operational sequence of 3DFEMWATER.  It permits steady
C        state simulation, transient simulation using input initial
C        conditions, and transient state simulation using steady state
C        solution as initial conditions.
C
C     + + + COMMON BLOCKS + + +
      INCLUDE 'CSGEOM.INC'
      INCLUDE 'CGEOM.INC'
      INCLUDE 'CLGEOM.INC'
      INCLUDE 'CINTE.INC'
      INCLUDE 'CREAL.INC'
      INCLUDE 'CS.INC'
      INCLUDE 'CW.INC'
      INCLUDE 'CCBC.INC'
      INCLUDE 'CNBC.INC'
      INCLUDE 'CVBC.INC'
      INCLUDE 'CDBC.INC'
      INCLUDE 'CSMTL.INC'
      INCLUDE 'CMTL.INC'
      INCLUDE 'COPTN.INC'
      INCLUDE 'CFLOW.INC'
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER            IE(MAXEL,9),NPCNV(MAXNP),ISB(6,MAXBES),
     >                   NPBB(MAXBNP),ISTYP(MXSEL),LES(MXSEL),
     >                   IWTYP(MXWNP),NPW(MXWNP),ICTYP(MXCES),
     >                   ISC(5,MXCES),NPCB(MXCNP),INTYP(MXNES),
     >                   ISN(5,MXNES),NPNB(MXNNP),IRTYP(MXVES),
     >                   ISV(5,MXVES),NPVB(MXVNP),NPFLX(MXVNP),
     >                   NPCON(MXVNP),NPMIN(MXVNP),IDTYP(MXDNP),
     >                   NPDB(MXDNP),KPR(MAXNTI),KDSK(MAXNTI),
     >                   NTNPLR(MXREGN),NNPLR(MXREGN),LMAXDF(MXREGN),
     >                   LNOJCN(MXJBD,LMXNP,MXREGN),LRN(MXJBD,MAXNP),
     >                   LRL(MXKBD,MAXNP),GNLR(LTMXNP,MXREGN),
     >                   NLRL(MAXNP),LUINP,LUOUT,LUSTO,LUBAR,LUPAR
C
      DOUBLE PRECISION   X(MAXNP),Y(MAXNP),Z(MAXNP),CMATRX(MAXNP,MXJBD),
     >                   RLD(MAXNP),RI(MAXNP),RL(MAXNP),HP(MAXNP),
     >                   HW(MAXNP),HT(MAXNP),TH(8,MAXEL),DTH(8,MAXEL),
     >                   AKR(8,MAXEL),DCOSB(3,MAXBES),BFLX(MAXBNP),
     >                   BFLXP(MAXBNP),SOS(MXSPR),SOSF(MXSDP,MXSPR),
     >                   TSOSF(MXSDP,MXSPR),WSS(MXWPR),
     >                   WSSF(MXWDP,MXWPR),TWSSF(MXWDP,MXWPR),
     >                   QCB(MXCPR),QCBF(MXCDP,MXCPR),
     >                   TQCBF(MXCDP,MXCPR),QNB(MXNPR),
     >                   QNBF(MXNDP,MXNPR),TQNBF(MXNDP,MXNPR),
     >                   RFALL(MXRPR),RF(MXRDP,MXRPR),TRF(MXRDP,MXRPR),
     >                   DCYFLX(MXVNP),FLX(MXVNP),HCON(MXVNP),
     >                   HMIN(MXVNP),HDB(MXDPR),HDBF(MXDDP,MXDPR),
     >                   THDBF(MXDDP,MXDPR),PROP(MXMPPM,MAXMAT),
     >                   THPROP(MXSPPM,MAXMAT),AKPROP(MXSPPM,MAXMAT),
     >                   CAPROP(MXSPPM,MAXMAT),HPROP(MXSPPM,MAXMAT),
     >                   TDTCH(MXNDTC),CMTRXL(LMXNP,LMXBW),RLDL(LMXNP),
     >                   H(MAXNP),VX(MAXNP),VY(MAXNP),VZ(MAXNP)
C
C       + + + ARGUMENT DEFINITIONS + + +
C     LUINP       - logical unit for input data
C     LUOUT       - logical unit for output data
C     LUSTO       - logical unit for store binary output
C     LUBAR       - logical unit for store binary boundary arrays
C     LUPAR       - logical unit for store binary pointer arrays
C
C     X(N)        - x-coordinate of the N-th node
C     Y(N)        - y-coordinate of the N-th node
C     Z(N)        - z-coordinate of the N-th node
C     IE(M,I)     - global node number of I-th node of the M-th element
C                   if I = 1 to 8, material type of the M0th element if
C                   I = 9
C
C     CMATRX(N,I) - an array to store the assembled global matrix
C     LRN(I,N)    - global node number of the I-th connecting node to
C                   the N-th node
C     NLRL(N)     - number of global elements connected to the N-th node
C     LRL(I,N)    - global element number of the I-th connecting element
C                   to the N-th node
C     RLD(N)      - an array to store the assembled global load vector
C     RI(N)       - pressure head iterate in BLKITR
C     RL(N)       - a working array to contain final solution of the
C                   pressure head in BLKITR
C
C     HP(N)       - previous-time pressure head at the N-th node
C     HW(N)       - nonlinear pressure head iterate at the N-th node
C     HT(N)       - total head at the N-th node
C     TH(I,M)     - moisture content at the I-th node of M-th element
C     DTH(I,M)    - water capacity at the I-th node of the M-th element
C     AKR(I,M)    - relative conductivity at I-th node of M-th element
C     NPCNV(I)    - global node number of the I-th nonconvergent node
C
C     DCOSB(1,I)  - directional cosine of the I-th boundary side with x
C     DCOSB(2,I)  - directional cosine of the I-th boundary side with y
C     DCOSB(3,I)  - directional cosine of the I-th boundary side with z
C     ISB(1,I)    - boundary node number of the first node of the I-th
C                   boundary side
C     ISB(2,I)    - boundary node number of the second node of the I-th
C                   boundary side
C     ISB(3,I)    - boundary node number of the third node of the I-th
C                   boundary side
C     ISB(4,I)    - boundary node number of the fourth node of the I-th
C                   boundary side
C     ISB(5,I)    - element side index of the I-th boundary side;
C                   1 = left side, 2 = front side, 3 = right side,
C                   4 = back side, 5 = bottom side, 6 = top side
C     ISB(6,I)    - global element number to which the I-th boundary
C                   side belong
C     NPBB(I)     - global node number of the I-th boundary node
C     BFLX(I)     - present time flux at the I-th boundary node
C     BFLXP(I)    - previous time flux at the I-th boundary node
C
C     SOS(J)      - value of J-th element source/sink at present time
C     SOSF(I,J)   - s/s rate of the I-th data point in the J-th profile
C     TSOSF(I,J)  - time of the I-th data point in the J-th profile
C     ISTYP(MP)   - source/sink type assigned to the MP-th s/s element
C     LES(MP)     - global element number of the MP-th s/s element
C     WSS(J)      - value of the J-th well source/sink at present time
C     WSSF(I,J)   - s/s rate of the I-th data point in the J-th profile
C     TWSSF(I,J)  - time of the I-th data point in the J-th profile
C     IWTYP(NP)   - source/sink type assigned to the NP-th well node
C     NPW(NP)     - global node number of the NP-th s/s well node
C
C     QCB(J)      - Cauchy flux of the J-th profile at the present time
C     QCBF(I,J)   - Cauchy flux of the I-th data point in J-th profile
C     TQCBF(I,J)  - time of the I-th data point in J-th Cauchy profile
C     ICTYP(MP)   - flux type assigned to the MP-th Cauchy side
C     ISC(1,MP)   - global node number of the first node of the MP-th
C                   Cauchy side
C     ISC(2,MP)   - global node number of the second node of the MP-th
C                   Cauchy side
C     ISC(3,MP)   - global node number of the third node of the MP-th
C                   Cauchy side
C     ISC(4,MP)   - global node number of the fourth node of the MP-th
C                   Cauchy side
C     ISC(5,MP)   - boundary side number of the MP-th Cauchy side
C     NPCB(MP)    - Global node number of the MP-th Cauchy node on input
C                   then is changed to contain boundary node number
C
C     QNB(J)      - Neuman flux of the J-th profile at the present time
C     QNBF(I,J)   - Neuman flux of the I-th data point in J-th profile
C     TQNBF(I,J)  - time of the I-th data point in J-th Neuman profile
C     INTYP(MP)   - flux type assigned to the MP-th Neuman side
C     ISN(1,MP)   - global node number of the first node of the MP-th
C                   Neuman side
C     ISN(2,MP)   - global node number of the second node of the MP-th
C                   Neuman side?
C     ISN(3,MP)   - global node number of the third node of the MP-th
C                   Neuman side
C     ISN(4,MP)   - global node number of the fourth node of the MP-th
C                   Neuman side
C     ISN(5,MP)   - boundary node number of the MP-th Neuman side
C     NPNB(MP)    - global node number of the MP-th Neuman node on input
C                   then is changed to contain boundary node number
C
C     RFALL(J)    - rainfall rate of J-th profile at the present time
C     RF(I,J)     - rainfall rate of I-th data point in J-th profile
C     TRF(I,J)    - time of the I-th data point in J-th rainfall profile
C     IRTYP(MP)   - type of rainfall profile assigned to MP-th VB side
C     ISV(1,MP)   - global node number of the first node of the MP-th
C                   variable boundary side
C     ISV(2,MP)   - global node number of the second node of the MP-th
C                   variable boundary side
C     ISV(3,MP)   - global node number of the third node of the MP-th
C                   variable boundary side
C     ISV(4,MP)   - global node number of the fourth node of the MP-th
C                   variable boundary side
C     ISV(5,MP)   - boundary node number of the MP-th VB side
C     NPVB(NP)    - global node number of NP-th VB node on input,
C                   then is changed to contain boundary node number
C     DCYFLX(NP)  - Darcy flux through the NP-th variable boundary node
C     FLX(NP)     - rainfall flux through the NP-th VB node
C     HCON(NP)    - ponding depth of the NP-th variable boundary node
C     HMIN(NP)    - minimum pressure allowed for the NP-th VB node
C     NPFLX(NP)   - flux boundary condition indicator of the NP-th
C                   VB node; 0 = this is not a flux-condition node for
C                   the present time step, globan node number = this
C                   is a flux-condition node for the present time
C     NPCON(NP)   - ponding condition indicator of the NP-th VB node:
C                   0 = this is not a ponding-condition node for the
C                   present time step, global node number = this is
C                   a ponding-condition node for the present time
C     NPMIN(NP)   - minimum-pressure condition indicator of NP-th VB
C                   node; 0 = this is not a minimum-pressure-condition
C                   node for the present time step, global node number =
C                   this is a minimum-pressure-condition node for the
C                   present time step
C
C     HDB(J)      - total head of the J-th profile at the present time
C     HDBF(I,J)   - total head of the I-th data point in J-th profile
C     THDBF(I,J)  - time of the I-th data point in J-th head profile
C     IDTYP(NP)   - total head profile type assigned to NP-th
C                   Dirichlet node
C     NPDB(NP)    - global node number of the NP-th Dirichlet node.
C
C     PROP(I,J)   - I-th material property of the J-th material;
C                     I = 1 = saturated xx-hydraulic conductivity
C                     I = 2 = saturated yy-hydraulic conductivity
C                     I = 3 = saturated zz-hydraulic conductivity
C                     I = 4 = saturated xy-hydraulic conductivity
C                     I = 5 = saturated xz-hydraulic conductivity
C                     I = 6 = saturated yz-hydraulic conductivity
C     THPROP(I,J) - I-th parameter to describe the moisture content as
C                   function of pressure head for the J-th material or
C                   I-th data point of moisture content for the J-th
C                   material.
C     AKPROP(I,J) - I-th parameter to describe the relative
C                   conductivity as function of pressure head for the
C                   J-th material or I-th data point of relative
C                   conductivity for the J-th material
C     CAPROP(I,J) - I-th data point of water capacity for the J-th
C                   material
C     HPROP(I,J)  - I-th data point of pressure for the J-th material
C
C     KPR(I)      - line-printer control for the I-th time step
C                    0 = print nothing,
C                    1 = print system mass balance plus above
C                    2 = print pressure head plus above
C                    3 = print total head plus above
C                    4 = print moisture content plus above
C                    5 = print Darcy velocity plus above
C     KDSK(I)     - auxilliary output control for the I-th time step;
C                    0 = no auxilliary output, 1 = auxilliary output
C     TDTCH(I)    - time of the I-th time to reset time step size to
C                   initial time step size.
C
C     NTNPLR(K)   - total number of node points in the K-th subregion
C                   = NNPLR(K) + intra-boundary nodes
C     NNPLR(K)    - number of node points in the K-th subregion
C     LMAXDF(K)   - maximum difference between eight nodes of any
C                   element
C     GNLR(I,K)   - global node number of the I-th node in the K-th
C                   subregion
C     LNOJCN((J,I,K) - local node number of the J-th compressed number
C                      connecting to the I-th local node in the K-th
C                      subregion
C     CMTRXL(N,I) - an array to store the assembled matrix for subregion
C     RLDL(N)     - an array to store the assembled load vector for
C                   a subregion
C
C     H(N)        - pressure head at the present time
C     VX(N)       - x-component of Darcy velocity
C     VY(N)       - y-component of Darcy velocity
C     VZ(N)       - z-component of Darcy velocity
C
C     + + + LOCAL VARIABLES + + +
      INTEGER            KOUT,I,J,K,KDIG,KFLOW,KDIAG,NPP,NCHG,NPROB,ICY,
     >                   ICYDO,IBUG,NI,ITYP,NP,IT,IDONFG,NNCVN,ICHNG,
     >                   IDELT,ITM,ITMITM
      DOUBLE PRECISION   TIME,EPS,RD,RES,W1,W2,RESNP
      CHARACTER*70       TITLE
      CHARACTER*32       SUBHD(3)
C
C     + + + INTRINSICS + + +
      INTRINSIC  DBLE,DABS,DMAX1,DMIN1
C
C     + + + EXTERNALS + + +
      EXTERNAL   DATAIN,ALLFCT,SPROP,VELT,SFLOW,PRINTT,STORE,
     >           BCPREP,ASEMBL,BC,BLKITR
C
C     + + + DATA INITIALIZATIONS + + +
      DATA SUBHD/'INPUT INITIAL CONDITIONS        ',
     >           'STEADY-STATE INITIAL CONDITIONS ',
     >           '                                '/
C
C     + + + INPUT FORMATS + + +
 1000 FORMAT(I5,A70,2X,3I1)
C
C     + + + OUTPUT FORMATS + + +
 2000 FORMAT('1 PROBLEM',I5/1H ,A70,2X,3I1/)
 2010 FORMAT(5X,I10,3X,E12.4,3X,E12.4,15X,I10)
 2020 FORMAT('1','****************************************************',
     > '*****'///' DIAGNOSTIC TABLE',I4,'.. AT TIME =',1PD12.4,
     > ', (DELT =',1PD12.4,')')
 2030 FORMAT(//' TABLE OF ITERATIVE PARAMETERS FOR',I3,'-TH CYCLE'//6X,
     > 'ITERATION',7X,'RESIDUAL',6X,'DEVIATION',6X,
     > 'NO. NON-CONV. NODES')
 2040 FORMAT(//' TABLE OF RAINFALL/EVAPORATION-SEEPAGE B. C. USED FOR',
     > I3,'-TH CYCLE'//5X,' I NPVB NPCON     HCON    NPMIN     HMIN',
     > '    NPFLX       FLX       DCYFLX'/5X,
     > ' - ---- -----     ----    -----     ----',
     > '    -----       ---       ------')
 2050 FORMAT(' ',I6,I5,I6,1PD12.4,I6,1PD12.4,I6,1PD12.4,1PD12.4)
 2060 FORMAT(//' TABLE OF NON-CONVERGING NODES')
 2070 FORMAT(/(5X,15I5))
 2080 FORMAT(/' WARNING: NON-CONVERGENCE OCCUR DURING STEADY STATE SOL
     >UTION AT',I3,' -TH CYCLE'/' ','IT = ',I3,'  .GT.  MAXIT = ',I3,
     > ',  RES =',D12.5,',  RD =',D12.4/'   NNCVN =',I4)
 2090 FORMAT(/' ABSOLUTELY WARNING: STEADY STATE SOLUTION IS NG'/' ',
     > 'ICY = ',I3,'  IT = ',I3,'  MAXCY = ',I3,'  MAXIT = ',I3/
     > '   RES =',D12.4,',  RD =',D12.4,',  NNCVN =',I4)
 2100 FORMAT(/' WARNING: NON-CONVERGENCE OCCUR AT',I5,' -TH TIME STEP'
     >,I3,' -TH CYCLE'/' ','IT = ',I3,'  .GT.  MAXIT = ',I3,2D12.4,I5)
 2110 FORMAT(/' ABSOLUTELY WARNING: TRANSIENT SOLUTION IS NG AT ',I5,
     > ' -TH TIME STEP'/' ','ICY = ',I3,'  IT = ',I3,'  MAXCY = ',I3,
     > '  MAXIT = ',I3,',  RES =',D12.4,',  RD =',D12.4/'   NNCVN =',I4)
C
C     + + + END SPECIFICATIONS + + +
C
C
C     read problem number, problem description, and control numbers
      READ(LUINP,1000) NPROB,TITLE,IGEOM,IBUG,ICHNG
C
C     print problem number, problem description, and control integers
      WRITE(LUOUT,2000) NPROB,TITLE,IGEOM,IBUG,ICHNG
C
C     set print-out tables and initial time to 0
      KOUT = 0
      TIME = 0.D0
C
C     read and print input data
      CALL DATAIN
     I           (LUINP,LUOUT,LUBAR,
     O            KPR,KDSK,TDTCH, PROP,THPROP,AKPROP,CAPROP,
     O            HPROP,X,Y,Z,IE, NNPLR,GNLR, DCOSB,ISB,NPBB,
     O            H,SOSF,TSOSF,ISTYP,LES,
     O            WSSF,TWSSF,IWTYP,NPW, QCBF,TQCBF,ICTYP,ISC,NPCB,
     O            QNBF,TQNBF,INTYP,ISN,NPNB, RF,TRF,IRTYP,ISV,
     O            NPVB,HCON,HMIN,HDBF,THDBF,IDTYP,NPDB,
     O            LRN,LRL,NLRL,LNOJCN,LMAXDF,NTNPLR)
C
C     position pointer array file at start
      REWIND(UNIT=LUPAR)
C
C
      IF (IGEOM .LE. 3) THEN
C       write the processed pointer arrays on pointer array file
C       for next job
        WRITE(LUPAR) ((LRN(J,I),J = 1,MXJBD),I = 1,NNP)
        WRITE(LUPAR) ((LRL(J,I),J=1,MXKBD),I=1,NNP),(NLRL(I),I=1,NNP)
        WRITE(LUPAR) (NTNPLR(K),K = 1,MXREGN)
        WRITE(LUPAR) (LMAXDF(K),K = 1,MXREGN)
        DO 110 K= 1,MXREGN
          WRITE(LUPAR) ((LNOJCN(J,I,K),J = 1,MXJBD),I = 1,LMXNP)
 110    CONTINUE
        WRITE(LUPAR) ((GNLR(I,K),I = 1,LTMXNP),K = 1,MXREGN)
        WRITE(LUPAR) (NNPLR(K),K = 1,MXREGN)
      ELSE IF (IGEOM .GT. 3) THEN
C       read the pointer arrays on pointer array file from the
C       previous job
        READ(LUPAR) ((LRN(J,I),J = 1,MXJBD),I = 1,NNP)
        READ(LUPAR) ((LRL(J,I),J=1,MXKBD),I=1,NNP),(NLRL(I),I=1,NNP)
        READ(LUPAR) (NTNPLR(K),K = 1,MXREGN)
        READ(LUPAR) (LMAXDF(K),K = 1,MXREGN)
        DO 120 K= 1,MXREGN
          READ(LUPAR) ((LNOJCN(J,I,K),J = 1,MXJBD),I = 1,LMXNP)
 120    CONTINUE
        READ(LUPAR) ((GNLR(I,K),I = 1,LTMXNP),K = 1,MXREGN)
        READ(LUPAR) (NNPLR(K),K = 1,MXREGN)
      END IF
C
C     set the diagnostic table number to 0
      KDIG = 0
C
C     prepare initial or pre-initial conditions
C
C     compute source and boundary conditions at initial or pre-initial
C     time
      IF (NSEL .NE. 0) THEN
C       source sink elements
        CALL ALLFCT
     I             (TSOSF,SOSF,TIME,MXSPR,MXSDP,NSPR,NSDP,KSAI,
     O              SOS)
      END IF
C
      IF (NWNP .NE. 0) THEN
C       well or point source/sink points
        CALL ALLFCT
     I             (TWSSF,WSSF,TIME,MXWPR,MXWDP,NWPR,NWDP,KWAI,
     O              WSS)
      END IF
C
      IF (NCES .NE. 0) THEN
C       cauchy boundary element sides
        CALL ALLFCT
     I             (TQCBF,QCBF,TIME,MXCPR,MXCDP,NCPR,NCDP,KCAI,
     O              QCB)
      END IF
C
      IF (NNES .NE. 0) THEN
C       neumann boundary element sides
        CALL ALLFCT
     I             (TQNBF,QNBF,TIME,MXNPR,MXNDP,NNPR,NNDP,KNAI,
     O              QNB)
      END IF
C
      IF (NVES .NE. 0) THEN
C       variable boundary element sides
        CALL ALLFCT
     I             (TRF,RF,TIME,MXRPR,MXRDP,NRPR,NRDP,KRAI,
     O              RFALL)
      END IF
C
      IF (NDNP .NE. 0) THEN
C       dirichlet nodal points
        CALL ALLFCT
     I             (THDBF,HDBF,TIME,MXDPR,MXDDP,NDPR,NDDP,KDAI,
     O              HDB)
      END IF
C
C     put Dirichlet boundary values to initial or pre-initial conditions
      DO 130 I = 1,NDNP
        NP   = NPDB(I)
        ITYP = IDTYP(I)
        H(NP)= HDB(ITYP)-Z(NP)*DBLE(KGRAV)
  130 CONTINUE
C
C     compute soil properties based on initial or pre-initial conditions
      CALL SPROP
     I          (MAXEL,MAXNP,MXSPPM,MAXMAT,NEL,NSPPM,
     I           IE,H,THPROP,AKPROP,CAPROP,HPROP,KSP,
     O           TH,DTH,AKR)
C
C     compute velocity based on initial or pre-initial conditions
      CALL VELT
     I         (X,Y,Z,IE,H,AKR, PROP,
     O          VX,VY,VZ,CMATRX,HT)
C
C     set KFLOW to -1 for preparing the mass balance compution of pre-
C     initial conditions
      KFLOW = -1
C
C     compute mass balance based on initial or pre-initial conditions
      CALL SFLOW
     I          (X,Y,Z,IE,H,HP,VX,VY,VZ,TH,DTH,DCOSB,
     I           ISB,NPBB,LES,SOS,ISTYP,WSS,IWTYP,
     I           NPVB,NPDB,NPCB,NPNB,DELT,KFLOW,
     M           BFLX,BFLXP)
C
C     Initiate flow arrays
      DO 140 I = 1,8
        FLOW(I)  = 0.0
        TFLOW(I) = 0.0
  140 CONTINUE
      FLOW(9) = 0.0
C
      KDIAG   = 0
C
C     write a ASC file to storage disk
      CALL PRINTT
     I           (LUOUT,MAXNP,MAXEL,MAXBNP,MXVNP,
     I            MXJBD,NNP,NEL,NVNP,
     I            VX,VY,VZ,H,HT,TH,BFLX,NPVB,DCYFLX,NPCON,
     I            NPFLX,NPMIN,SUBHD(1),TIME,DELT,KPR0,-1,
     M            KOUT,KDIAG)
C
      IF (KSS .EQ. 1 .AND. KDSK0 .EQ. 1) THEN
C       write a binary file to storage disk
        CALL STORE
     I            (LUSTO,MAXEL,MAXNP,MAXBES,MAXBNP,
     I             NNP,NEL,NBNP,NBES,NTI,LTMXNP,MXREGN,NREGN,
     I             X,Y,Z,IE,H,HT,TH,VX,VY,VZ,DCOSB,
     I             ISB,NPBB,NNPLR,GNLR,TITLE,TIME,NPROB)
      END IF
C
C     start job
      IF (KSS .EQ. 0) THEN
C       Perform Steady State Calculations
        IF (NVES .NE. 0) THEN
C         variable boundary elements
          DO 150 NPP = 1,NVNP
            NI         = NPVB(NPP)
            NPCON(NPP) = NPBB(NI)
            NPMIN(NPP) = 0
            NPFLX(NPP) = 0
  150     CONTINUE
C
C         Set NCHg = -1 for the first time to compute boundary condition
          NCHG = -1
          CALL BCPREP
     I              (IE,X,Y,Z,H,VX,VY,VZ,DCOSB,ISB,ISV,HCON,HMIN,
     I               IRTYP,RFALL,
     O               DCYFLX,FLX,NPFLX,NPCON,NPMIN,NCHG)
C
        END IF
C
C       Update HP
        DO 180 NP = 1,NNP
          HP(NP) = H(NP)
  180   CONTINUE
C
        KDIG = KDIG + 1
        IF (IBUG .NE. 0) THEN
C         diagnostic table header
          WRITE(LUOUT,2020) KDIG,TIME,DELT
        END IF
C
C       compute error tolerance for block iteration
        EPS = 0.5D0*TOLA
C
C       begin iteration loop of boundary conditions
        ICYDO = 1
        ICY   = 0
        NNCVN = 0
  200   CONTINUE
          ICY = ICY+1
C         take initial guess HW and RI
          DO 210 NP = 1,NNP
            IF(NNCVN .EQ. 0) THEN
              HW(NP) = OME*H(NP) + (1.0D0 - OME)*HP(NP)
              RI(NP) = HW(NP)
            ELSE
              HW(NP) = HP(NP)
              RI(NP) = HP(NP)
            ENDIF
  210     CONTINUE
C
          IF (IBUG .NE. 0) THEN
C           print diagonstic information
            WRITE(LUOUT,2030) ICY
          END IF
C
          IF (NVES .NE. 0) THEN
C           variable boundary elements, check extreme condition at var.
C           bound elements
            DO 230 NPP = 1,NVNP
              NI = NPMIN(NPP)
              IF (NI .NE. 0) THEN
C               at minimum pressure
                H(NI)  = HMIN(NPP)
                RI(NI) = HMIN(NPP)
                HW(NI) = HMIN(NPP)
                RL(NI) = HMIN(NPP)
              ELSE
C               ponding at this node
                NI = NPCON(NPP)
                IF (NI .NE. 0) THEN
C                 Implement ponding depth boundary condtions
                  H(NI)  = HCON(NPP)
                  RI(NI) = HCON(NPP)
                  HW(NI) = HCON(NPP)
                  RL(NI) = HCON(NPP)
                END IF
              END IF
  230       CONTINUE
          END IF
C
C         nonlinear iteration loop
          IT     = 0
          IDONFG = 0
  350     CONTINUE
            IT = IT + 1
C
C           compute the moisture content, water capacity, and relative
C           hydraulic conductivity or relative permeability
            CALL SPROP
     I                (MAXEL,MAXNP,MXSPPM,MAXMAT,NEL,NSPPM,
     I                 IE,HW,THPROP,AKPROP,CAPROP,HPROP,KSP,
     O                 TH,DTH,AKR)
C
C           aseemble global matrix and load vector
            CALL ASEMBL
     I                 (X,Y,Z,IE,LRN, HP,DTH,AKR, PROP,
     I                  SOS,LES,ISTYP, WSS,NPW,IWTYP, KSS,W,DELT,LUOUT,
     O                  CMATRX,RLD)
C
C           incorporate boundary conditions
            CALL BC
     I             (LRN,IE,X,Y,Z,AKR,PROP,DCOSB,ISB, QCB,ISC,ICTYP,
     I              QNB,ISN,INTYP, FLX,HCON,HMIN,NPFLX,NPCON,NPMIN,
     I              HDB,IDTYP,NPDB,
     M              CMATRX,RLD)
C
C           solve the matrix equation with bloci iteration method
            CALL BLKITR
     I                 (MAXNP,MXJBD,LTMXNP,LMXNP,LMXBW,MXREGN,LUOUT,
     I                  NNP,NREGN,
     I                  CMATRX,RLD,GNLR,LNOJCN,
     I                  NNPLR,LMAXDF,EPS,NPITER,IBUG,KPR0,OMI,
     M                  RI,CMTRXL,RLDL,
     O                  RL)
C
C           compute maximum relative deviation from previous iteration
            NPP = 0
            RD  = -1.0D0
            RES = -1.0D0
            DO 320 NP = 1,NNP
C             Compute the residuals
              RESNP = DABS(RL(NP) - H(NP))
              RES   = DMAX1(RES,RESNP)
              IF (DABS(H(NP)) .GT. 1.0D-30) THEN
C               Obtain the maximu residuals
                RD = DMAX1(RD,DABS(RESNP/H(NP)))
              END IF
              IF (RESNP .GT. TOLA) THEN
C               Accumulate no-convergent nodes
                NPP        = NPP + 1
                NPCNV(NPP) = NP
              END IF
  320       CONTINUE
C
            NNCVN = NPP
C
C           update pressure with current iterate
            DO 330 NP = 1,NNP
              H(NP)  = OME*RL(NP) + (1.0D0 - OME)*H(NP)
              RI(NP) = H(NP)
              HW(NP) = H(NP)
  330       CONTINUE
C
            IF (IBUG .NE. 0) THEN
C             print diagonstic information
              WRITE(LUOUT,2010) IT,RES,RD,NNCVN
            END IF
C
            IF (IT .EQ .1 .AND. IT .LT. NITER) THEN
              GO TO 350
            END IF
C
C           if the maximum residual is sufficiently small, escape the
C           nonlinear iteration loop
            IF (RES .LT. TOLA .OR. RES .GT. 1.0D38) THEN
              IDONFG = 1
            END IF
C
C           if maximum residual is not sufficiently small and IT is
C           less than NITER, do another iteration by going to 350
          IF (IT .LT. NITER .AND. IDONFG .EQ. 0) THEN
            GO TO 350
          END IF
C
          IF (IDONFG .EQ. 0 .OR. RES .GT. 1.0D38) THEN
C           maximum residual is not sufficiently small and the
C           allowed iteration number has been reached, print
C           non-convergent nodes and issue warning message
            WRITE(LUOUT,2080) ICY,IT,NITER,RES,RD,NNCVN
            IF (IBUG .NE. 0) THEN
C             print diagonstic information
              WRITE(LUOUT,2060)
              WRITE(LUOUT,2070) (NPCNV(NPP),NPP = 1,NNCVN)
            END IF
          END IF
C
C         Convergent solution has been obtained for the assumed boundary
C         conditions
          IF (ICHNG*NVES .NE. 0) THEN
C
C           print rainfall-seepage-evaporation boundary condition change
C           information
            WRITE(LUOUT,2040) ICY
            DO 370 I = 1,NVNP
              NI = NPVB(I)
              NP = NPBB(NI)
              WRITE(LUOUT,2050) I,NP,NPCON(I),HCON(I),NPMIN(I),HMIN(I),
     >                         NPFLX(I),FLX(I),DCYFLX(I)
  370       CONTINUE
          END IF
C
C         compute soil properties
          CALL SPROP
     I              (MAXEL,MAXNP,MXSPPM,MAXMAT,NEL,NSPPM,
     I               IE,H,THPROP,AKPROP,CAPROP,HPROP,KSP,
     O               TH,DTH,AKR)
C
C         compute Darcy velocity or the specific discharge
          CALL VELT
     I             (X,Y,Z,IE,H,AKR, PROP,
     O              VX,VY,VZ,CMATRX,HT)
C
C         if there is no variable boundary, escape the boundary
C         condition loop
          IF (NVES .EQ. 0) THEN
            ICYDO = 0
          END IF
C
          IF (ICYDO .EQ. 1) THEN
C
C           prepare boundary conditions on the variable-type boundary
C           for next cycle computations
            CALL BCPREP
     I                 (IE,X,Y,Z,H,VX,VY,VZ,DCOSB,ISB,ISV,HCON,HMIN,
     I                  IRTYP,RFALL,
     O                  DCYFLX,FLX,NPFLX,NPCON,NPMIN,NCHG)
          END IF
C
C         if the prepared boundary conditions are the same as those just
C         have been used, escape the boundary condition loop
        IF (NCHG .NE. 0 .AND. ICYDO .EQ. 1 .AND. ICY .LT. NCYL) THEN
          GO TO 200
        END IF
C
C
        IF (NCHG .NE. 0 .AND. ICYDO .EQ. 1) THEN
C         after NCYL cycles on the boundary condition loop, we still do
C         not have correct boundary conditions yet, print the
C         information and issue absolute warning
          WRITE(LUOUT,2090) ICY,IT,NCYL,NITER,RES,RD,NNCVN
        END IF
C
C       before NCYL cycles have been reached, we have the correct
C       boundary condiitons.
        IF (NNCVN .NE. 0) THEN
          WRITE(LUOUT,2090) ICY,IT,NCYL,NITER,RES,RD,NNCVN
        END IF
C
C       set KFLOW to 0 to indicate mass flow balance at steady state
        KFLOW = 0
C
C       compute mass balance
        CALL SFLOW
     I            (X,Y,Z,IE,H,HP,VX,VY,VZ,TH,DTH,DCOSB,
     I             ISB,NPBB,LES,SOS,ISTYP,WSS,IWTYP,
     I             NPVB,NPDB,NPCB,NPNB,DELT,KFLOW,
     M             BFLX,BFLXP)
C
        DO 450 I = 1,8
          FLOW(I)  = 0.0
          TFLOW(I) = 0.0
  450   CONTINUE
        FLOW(9) = 0.0
C
C       print steady state solution
        CALL PRINTT
     I             (LUOUT,MAXNP,MAXEL,MAXBNP,MXVNP,
     I              MXJBD,NNP,NEL,NVNP,
     I              VX,VY,VZ,H,HT,TH,BFLX,NPVB,DCYFLX,NPCON,
     I              NPFLX,NPMIN,SUBHD(2),TIME,DELT,KPR0,0,
     M              KOUT,KDIAG)
C
C       store steady state solution
        IF (KDSK0 .EQ. 1) THEN
          CALL STORE
     I              (LUSTO,MAXEL,MAXNP,MAXBES,MAXBNP,
     I               NNP,NEL,NBNP,NBES,NTI,LTMXNP,MXREGN,NREGN,
     I               X,Y,Z,IE,H,HT,TH,VX,VY,VZ,DCOSB,
     I               ISB,NPBB,NNPLR,GNLR,TITLE,TIME,NPROB)
        END IF
C
C       end steady state simulation
      END IF
C
C     check to see if transient state solution is wanted
      IF (NTI .NE. 0) THEN
C       perform transient state or transient simulation
        KSS = 1
C
        IF (NVES .NE. 0) THEN
C         set the intial variable boundary conditions as ponding
          DO 510 NPP = 1,NVNP
            NI         = NPVB(NPP)
            NPCON(NPP) = NPBB(NI)
            NPMIN(NPP) = 0
            NPFLX(NPP) = 0
  510     CONTINUE
C
C         Set NCHG = -1 when you compute boundary conditions for
c         the first time
          NCHG = -1
C
        END IF
C
C       Accumulate simulation time
        TIME     = TIME + DELT
        W1       = W
        W2       = 1.0D0 - W
        KFLOW    = 1
        TFLOW(9) = 0.0
C
C       begin the time marching
        EPS   = 0.5D0*TOLB
        IDELT = 0
C        WRITE(22,9998) NTI
C 9998   FORMAT(1X,'NTI=',I4)
        DO 890 ITM = 1,NTI
C          WRITE(22,9997)ITM,TIME,TMAX
C 9997     FORMAT(1X,'ITM=',I4,/,'   TIME=',D24.17,/,'   TMAX=',D24.17)
          IF (TIME .LE. TMAX) THEN
C           do the simulation
            ITMITM = ITM
C
C           compute source/sink and boundary condition values
            IF (NSEL .NE. 0) THEN
C             source sink elements
              CALL ALLFCT
     I                   (TSOSF,SOSF,TIME,MXSPR,MXSDP,NSPR,NSDP,KSAI,
     O                    SOS)
            END IF
C
            IF (NWNP .NE. 0) THEN
C             well or point source/sink points
              CALL ALLFCT
     I                   (TWSSF,WSSF,TIME,MXWPR,MXWDP,NWPR,NWDP,KWAI,
     O                    WSS)
            END IF
C
            IF (NCES .NE. 0) THEN
C             cauchy boundary element sides
              CALL ALLFCT
     I                   (TQCBF,QCBF,TIME,MXCPR,MXCDP,NCPR,NCDP,KCAI,
     O                    QCB)
            END IF
C
            IF (NNES .NE. 0) THEN
C             neumann boundary element sides
              CALL ALLFCT
     I                   (TQNBF,QNBF,TIME,MXNPR,MXNDP,NNPR,NNDP,KNAI,
     O                    QNB)
            END IF
C
            IF (NVES .NE. 0) THEN
C             variable boundary element sides
              CALL ALLFCT
     I                   (TRF,RF,TIME,MXRPR,MXRDP,NRPR,NRDP,KRAI,
     O                    RFALL)
            END IF
C
            IF (NDNP .NE. 0) THEN
C             dirichlet nodal points
              CALL ALLFCT
     I                   (THDBF,HDBF,TIME,MXDPR,MXDDP,NDPR,NDDP,KDAI,
     O                    HDB)
            END IF
C
            IF (NVES .NE. 0) THEN
C             prepare guessed boundary conditions for the present
C             time step
              NCHG = -1
              CALL BCPREP
     I                   (IE,X,Y,Z,H,VX,VY,VZ,DCOSB,ISB,ISV,HCON,HMIN,
     I                    IRTYP,RFALL,
     O                    DCYFLX,FLX,NPFLX,NPCON,NPMIN,NCHG)
            END IF
C
C           Update HP for the next time step
C
            DO 570 NP = 1,NNP
              RL(NP) = H(NP)
              HP(NP) = H(NP)
  570       CONTINUE
C
            KDIG = KDIG + 1
            IF (IBUG .NE. 0 .AND. KPR(ITM) .NE. 0 ) THEN
C             print diagonstic information
              WRITE(LUOUT,2020) KDIG,TIME,DELT
            END IF
C
C           begin iteration loop on the seepage-rainfall-evaporation
C           boundry conditions
            ICYDO = 1
            ICY   = 0
            NNCVN = 0
  575       CONTINUE
C             Increase iteration cycle on boundary conditions
              ICY = ICY + 1
              IF (IBUG .NE. 0 .AND. KPR(ITM) .NE. 0) THEN
C               print diagonstic information
                WRITE(LUOUT,2030) ICY
              END IF
C
C             Update the nonlinear iterate
              DO 580 NP = 1,NNP
                IF(NNCVN .EQ. 0) THEN
                  H(NP)  = OME*RL(NP) + (1.0D0 - OME)*H(NP)
                  RI(NP) = H(NP)
                  HW(NP) = W1*(OME*H(NP)+(1.0D0-OME)*HP(NP))+W2*HP(NP)
                ELSE
                  H(NP) = HP(NP)
                  RI(NP) = HP(NP)
                  HW(NP) = HP(NP)
                ENDIF
  580         CONTINUE
C
              IF (NVES .NE. 0) THEN
C               put Dirichlet boundary values of the variable boundary
C               into H, RI, HW, and RL.
                DO 590 NPP = 1,NVNP
                  NI = NPMIN(NPP)
                  IF (NI .NE. 0) THEN
C                   Implement minimum pressure boundary conditions
                    H(NI)  = HMIN(NPP)
                    RI(NI) = HMIN(NPP)
                    HW(NI) = HMIN(NPP)
                    RL(NI) = HMIN(NPP)
                  ELSE
                    NI = NPCON(NPP)
                    IF (NI .NE. 0) THEN
C                     Implement ponding depth boundary conditions
                      H(NI)  = HCON(NPP)
                      RI(NI) = HCON(NPP)
                      HW(NI) = HCON(NPP)
                      RL(NI) = HCON(NPP)
                    END IF
                  END IF
  590           CONTINUE
              END IF
C
C             nonlinear iteration loop
              IT     = 0
              IDONFG = 0
  650         CONTINUE
                IT = IT + 1
C
C               evaluate soil properties based on the iterate
                CALL SPROP
     I                    (MAXEL,MAXNP,MXSPPM,MAXMAT,NEL,NSPPM,
     I                     IE,HW,THPROP,AKPROP,CAPROP,HPROP,KSP,
     O                     TH,DTH,AKR)
C
C               assemble the global matrix
                CALL ASEMBL
     I                     (X,Y,Z,IE,LRN, HP,DTH,AKR, PROP,
     I                      SOS,LES,ISTYP, WSS,NPW,IWTYP, KSS,W,DELT,
     I                      LUOUT,
     O                      CMATRX,RLD)
C
C               incorporate boundary conditions
                CALL BC
     I                 (LRN,IE,X,Y,Z, AKR,PROP, DCOSB,ISB, QCB,ISC,
     I                  ICTYP,QNB,ISN,INTYP, FLX,HCON,HMIN,NPFLX,NPCON,
     I                  NPMIN,HDB,IDTYP,NPDB,
     M                  CMATRX,RLD)
C
C               solve the matrix equation by block iteration method
                CALL BLKITR
     I                     (MAXNP,MXJBD,LTMXNP,LMXNP,LMXBW,MXREGN,
     I                      LUOUT,NNP,NREGN,
     I                      CMATRX,RLD,GNLR,LNOJCN,
     I                      NNPLR,LMAXDF,EPS,NPITER,IBUG,KPR(ITM),OMI,
     M                      RI,CMTRXL,RLDL,
     O                      RL)
C
C               compute maximum relative deviation from previous iterate
                NPP = 0
                RD  = -1.0D0
                RES = -1.0D0
                DO 620 NP = 1,NNP
                  RESNP = DABS(RL(NP) - H(NP))
                  RES   = DMAX1(RES,RESNP)
                  IF (DABS(H(NP)) .GT. 1.0D-30) THEN
C                   compute the residuals
                    RD = DMAX1(RD,DABS(RESNP/H(NP)))
                  END IF
C
                  IF (RESNP .GT. TOLB) THEN
C                   accumulate non-convergent nodes
                    NPP        = NPP + 1
                    NPCNV(NPP) = NP
                  END IF
  620           CONTINUE
                NNCVN = NPP
C
C               update pressure with current iterate
                DO 630 NP = 1,NNP
                  H(NP)  = OME*RL(NP) + (1.0D0 - OME)*H(NP)
                  RI(NP) = H(NP)
                  HW(NP) = W1*H(NP) + W2*HP(NP)
  630           CONTINUE
C
                IF (IBUG.NE.0 .AND. KPR(ITM).NE.0) THEN
C                 print diagonstic information
                  WRITE(LUOUT,2010) IT,RES,RD,NNCVN
                END IF
C
                IF (IT .EQ. 1 .AND. ITM .EQ. 1 .AND. IT .LT. NITER) THEN
                  GO TO 650
                END IF
C
C               if the maximum residual is sufficiently small, escape
C               the nonliear iteration loop
                IF (RES .LT. TOLB .OR. RES .GT. 1.0D38) THEN
                  IDONFG = 1
                END IF
C
C               if the maximum residual is not sufficiently small and
C               IT is less than NITER, do another iteration by going 650
              IF (IT .LT. NITER .AND. IDONFG .EQ. 0) THEN
                GO TO 650
              END IF
C
              IF (IDONFG .EQ. 0 .OR. RES .GT. 1.0D38) THEN
C               maximum residual is not sufficiently small and the
C               allowed iteration number has been reached, print
C               non-convergent nodes and issue warning message
                WRITE(LUOUT,2100) ITM,ICY,IT,NITER,RES,RD,NNCVN
                IF (IBUG .NE. 0 .AND. KPR(ITM) .NE. 0) THEN
C                 print diagonstic information
                  WRITE(LUOUT,2060)
                  WRITE(LUOUT,2070) (NPCNV(NPP),NPP = 1,NNCVN)
                END IF
C
              END IF
C
C             Convergent solution has been obtained for the assumed
C             boundary conditions
              IF (ICHNG*KPR(ITM)*NVES .NE. 0) THEN
C               print rainfall-seepage-evaporation boundary condition
C               change iformation
                WRITE(LUOUT,2040) ICY
                DO 670 I = 1,NVNP
                  NI = NPVB(I)
                  NP = NPBB(NI)
                  WRITE(LUOUT,2050) I,NP,NPCON(I),HCON(I),NPMIN(I),
     >                           HMIN(I),NPFLX(I),FLX(I),DCYFLX(I)
  670           CONTINUE
              END IF
C
C             compute soil properties
              CALL SPROP
     I                  (MAXEL,MAXNP,MXSPPM,MAXMAT,NEL,NSPPM,
     I                   IE,H,THPROP,AKPROP,CAPROP,HPROP,KSP,
     O                   TH,DTH,AKR)
C
C             compute Darcy velocity or the specific discharge
              CALL VELT
     I                 (X,Y,Z,IE,H,AKR, PROP,
     O                  VX,VY,VZ,CMATRX,HT)
C
              IF (NVES .EQ. 0) THEN
C               no variable boundry, escape the boundary condition loop
                ICYDO = 0
              END IF
C
              IF (ICYDO .EQ. 1) THEN
C
C               prepare boundary conditions on the variable-type
C               boundary for the next cycle computation
                CALL BCPREP
     I                     (IE,X,Y,Z, H,VX,VY,VZ, DCOSB,ISB, ISV,HCON,
     I                      HMIN,IRTYP,RFALL,
     O                      DCYFLX,FLX,NPFLX,NPCON,NPMIN,NCHG)
C
C               if the prepared boundary conditions are the same as
C               those just have been used,
C               escape the boundary condition loop
              END IF
            IF (NCHG .NE. 0 .AND. ICYDO .EQ. 1 .AND. ICY .LT. NCYL) THEN
              GO TO 575
            END IF
C
            IF (NCHG .NE. 0 .AND. ICYDO .EQ. 1) THEN
C             after NCYL cylces on the boundary condition loop, we still
C             do not have correct boundary conditions yet, print the
C             information and issue absolute warining
              WRITE(LUOUT,2110) ITM,ICY,IT,NCYL,NITER,RES,RD,NNCVN
            END IF
C
            IF (NNCVN .NE. 0) THEN
C             before NCYL cycles have been reached, we have the correct
C             boundary conditions.
              WRITE(LUOUT,2110) ITM,ICY,IT,NCYL,NITER,RES,RD,NNCVN
            END IF
C
            IF (IMID .NE. 0) THEN
C             for the case of mid-difference
              DO 720 NP = 1,NNP
                H(NP) = 2.0D0*H(NP) - HP(NP)
  720         CONTINUE
              DO 730 I = 1,NDNP
                NP    = NPDB(I)
                ITYP  = IDTYP(I)
                H(NP) = HDB(ITYP) - Z(NP)*DBLE(KGRAV)
  730         CONTINUE
            END IF
C
C           compute mass balance
            CALL SFLOW
     I                (X,Y,Z,IE,H,HP,VX,VY,VZ,TH,DTH,DCOSB,
     I                 ISB,NPBB,LES,SOS,ISTYP,WSS,IWTYP,
     I                 NPVB,NPDB,NPCB,NPNB,DELT,KFLOW,
     M                 BFLX,BFLXP)
C
C           print solution at the present time
C            WRITE(22,9999)ITM,KPR(ITM)
C 9999       FORMAT(1X,'KPR(',I4,')=',I4)
            CALL PRINTT
     I                 (LUOUT,MAXNP,MAXEL,MAXBNP,MXVNP,
     I                  MXJBD,NNP,NEL,NVNP,
     I                  VX,VY,VZ,H,HT,TH,BFLX,NPVB,DCYFLX,NPCON,
     I                  NPFLX,NPMIN,SUBHD(3),TIME,DELT,KPR(ITM),
     I                  ITMITM,
     M                  KOUT,KDIAG)
C
C
            IF (KDSK(ITM) .EQ. 1) THEN
C             store the soltuion of the present time step
              CALL STORE
     I                  (LUSTO,MAXEL,MAXNP,MAXBES,MAXBNP,
     I                   NNP,NEL,NBNP,NBES,NTI,LTMXNP,MXREGN,NREGN,
     I                   X,Y,Z,IE,H,HT,TH,VX,VY,VZ,DCOSB,
     I                   ISB,NPBB,NNPLR,GNLR,TITLE,TIME,NPROB)
            END IF
C
C           prepare for the next time step
C
            DELT = DELT*(1.0D0 + CHNG)
            DELT = DMIN1(DELT,DELMAX)
            IF (IDELT .NE. 0) THEN
              IF (DABS(TIME-TDTCH(IDELT)) .LT. 1.0D-30) THEN
C               Reset time step-size at desired time
                DELT = DELT0
              END IF
            END IF
            TIME = TIME + DELT
            IF (TIME .GE. TDTCH(IDELT + 1)) THEN
C             To tell when we need to change the time-step size again
c             next time.
              IDELT = IDELT + 1
              TIME  = TIME - DELT
              DELT  = TDTCH(IDELT) - TIME
              IF (DELT .LE. 0.D0) THEN
C               reset time-step size to DELT0
                DELT = DELT0
              END IF
              TIME = TIME + DELT
            END IF
C
          END IF
  890   CONTINUE
C
      END IF
C
      RETURN
      END
