      SUBROUTINE   PRINTT
     I                   (LUOUT,MAXNP,MAXEL,MAXBNP,MXVNP,
     I                    MXJBD,NNP,NEL,NVNP,
     I                    VX,VY,VZ,H,HT,TH,BFLX,NPVB,DCYFLX,NPCON,
     I                    NPFLX,NPMIN,SUBHD,TIME,DELT,KPR,ITIM,
     M                    KOUT,KDIAG)
C
C     + + + PURPOSE + + +
C     To print out the solution
C
C     + + + COMMON BLOCKS + + +
      INCLUDE 'CFLOW.INC'
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER            LUOUT,MAXNP,MAXEL,MAXBNP,MXVNP,KPR,ITIM,KOUT,
     >                   KDIAG,MXJBD,NNP,NEL,NVNP
      INTEGER            NPVB(MXVNP),NPCON(MXVNP),NPFLX(MXVNP),
     >                   NPMIN(MXVNP)
      DOUBLE PRECISION   TIME,DELT,VX(MAXNP),VY(MAXNP),VZ(MAXNP),
     >                   H(MAXNP),HT(MAXNP),TH(8,MAXEL),
     >                   BFLX(MAXBNP),DCYFLX(MXVNP)
      CHARACTER*32       SUBHD
C
C     + + + ARGUMENT DEFINITIONS + + +
C     LUOUT  - logical unit for output
C     MAXNP  - maximum number of nodal points
C     MAXEL  - maximum number of elements
C     MAXBNP - maximum number of boundary nodal points
C     MXVNP  - maximum number of variable boundary nodal points
C     MXJBD  - maximum number of nodes connecting to any node
C     NNP    - no. of nodal points
C     NEL    - no. of elements
C     NVNP   - no. variable boundary nodal points
C     VX     - x-component of Darcy's velocity
C     VY     - y-component of Darcy's velocity
C     VZ     - z-component of Darcy's velocity
C     H      - pressure head
C     HT     - total head
C     TH     - moisture conent
C     BFLX   - boundary flux
C     NPVB   - node number of a variable boundary node
C     DCYFLX - Darcy flux
C     NPCON  - ponding depth node indicator
C     NPFLX  - flux node indicator
C     NPMIN  - minimum pressure node indicator
C     SUBHD  - suhheading
C     TIME   - real time
C     DELT   - time step size
C     KPR    - print indicator
C     ITIM   - time step number
C     KOUT   - print out table number
C     KDIAG  - diagnostic print out table number
C
C     + + + LOCAL VARIABLES + + +
      INTEGER   KDIA,I,NPP,NKK,LINE,NI,NJMN,NJMX,NJ,M,IQ,NP
C
C     + + + INTRINSICS + + +
      INTRINSIC MIN0,MOD
C
C     + + + OUTPUT FORMATS + + +
 1000 FORMAT('1',' TABLE OF SYSTEM-FLOW PARAMETERS',2X,'TABLE: ',I4,
     > '.. AT TIME =',1PD12.4/' (DELT =',1PD12.4,')',' ITIM=',I4//1X,
     > ' TYPE OF FLOW',27X,'RATE',7X,'INC. FLOW',4X,'TOTAL FLOW'/
     1 '  1. FLOW THROUGH DIRICHLET NODES .. ',3(E12.4,2X)/
     2 '  2. FLOW THROUGH CAUCHY NODES . . . ',3(E12.4,2X)/
     3 '  3. FLOW THROUGH NEUMANN NODES .  . ',3(E12.4,2X)/
     4 '  4. FLOW THROUGH SEEPAGE NODES .. . ',3(E12.4,2X)/
     5 '  5. FLOW THROUGH INFILTRATION NODES ',3(E12.4,2X)/
     6 '  6. FLOW THROUGH UNSPECIFIED NODES  ',3(E12.4,2X)/
     7 '  7. NET FLOW THROUGH ENTIRE BOUNDARY',3(E12.4,2X)/
     8 '  8. ARTIFICIAL SOURCES/SINKS . . . .',3(E12.4,2X)/
     9 '  9. INCREASE IN WATER CONTENT . . . ',3(E12.4,2X)/
     A ' *** NOTE: (+) = OUT FROM, (-) = INTO THE REGION. '//)
 1100 FORMAT(/' RAINFALL-SEEPAGE NODAL FLOWS (L**3/T)')
 1110 FORMAT(5D15.4)
 1120 FORMAT(/' VALUES OF NPCON'/(5I15))
 1125 FORMAT(/' VALUES OF NPMIN'/(5I15))
 1130 FORMAT(/' VALUES OF NPFLX'/(5I15))
 2000 FORMAT('1 OUTPUT TABLE',I4,'.. PRESSURE HEADS(L) AT TIME =',
     1 1PD12.4/' (DELT =',1PD12.4,'),(BAND WIDTH =',I4,')','  IT =',
     2 I5//1X,A32/1X,' NODE I',5X,'PRESSURE HEAD (L) OF NODES I,I+1,.',
     3 ',I+4 '/)
 2100 FORMAT(I7,5(1PD14.4))
 3000 FORMAT('1 OUTPUT TABLE',I4,'. TOTAL HEADS(L) AT TIME =',1PD12.4/
     1 ' (DELT =',1PD12.4,'),(BAND WIDTH =',I4,')','  IT =',I5//1X,A32,
     2 /1X,' NODE I',5X,'TOTAL HEAD (L) OF NODES I,I+1,...,I+4'/)
 4000 FORMAT('1 OUTPUT TABLE',I4,'. WATER CONTENT(L**3/L**3) AT TIME =',
     1 1PD12.4/' (DELT =',1PD12.4,'),(BAND WIDTH =',I4,')','  IT =',
     3 I5//1X,A32//30X,' GAUSSIAN POINTS'/15X,'1',7X,'2',7X,'3',7X,
     4 '4',7X,'5',7X,'6',7X,'7',7X,'8'/1X,'ELEMENT',2X,'---------',
     5 '-----------------------------------------------------')
 4100 FORMAT(' ',I7,2X,8(F8.5))
 5000 FORMAT('1 OUTPUT TABLE',I4,'.. DARCY VELOCITIES (L/T) AT TIME =',
     1 1PD12.4/' (DELT =',1PD12.4,'),(BAND WIDTH =',I4,')','  IT =',
     2 I5//1X,A32//1X,2(' NODE     VX         VY         VZ     ')/1X,
     3 2(' ------------------------------------- ')/)
 5100 FORMAT(' ',2(I5,1PD11.3,1PD11.3,1PD11.3,1X))
C
C     + + + END SPECIFICATIONS + + +
C
      IF (KPR .GE. 1) THEN
C
C       ***** Print mass balance information
C
        KDIAG = KDIAG + 1
        KDIA  = KDIAG - 1
        WRITE(LUOUT,1000) KDIA,TIME,DELT,ITIM,
     >                    (FRATE(I),FLOW(I),TFLOW(I),I = 1,9)
        IF (NVNP .GT. 0) THEN
C
C         variable boundary condition information
          DO 120 NPP = 1,NVNP
            NKK         = NPVB(NPP)
            DCYFLX(NPP) = BFLX(NKK)
 120      CONTINUE
          WRITE(LUOUT,1100)
          WRITE(LUOUT,1110) (DCYFLX(NPP),NPP = 1,NVNP)
          WRITE(LUOUT,1120) (NPCON(NPP),NPP = 1,NVNP)
          WRITE(LUOUT,1125) (NPMIN(NPP),NPP = 1,NVNP)
          WRITE(LUOUT,1130) (NPFLX(NPP),NPP = 1,NVNP)
        END IF
      END IF
C
      IF (KPR .GE. 2) THEN
C
C       ***** Print pressure head
C
        KOUT = KOUT + 1
        LINE = 0
        DO 210 NI = 1,NNP,5
          NJMN = NI
          NJMX = MIN0(NI + 4,NNP)
          IF (MOD(LINE,50) .EQ. 0) THEN
C           need a new header
            WRITE(LUOUT,2000) KOUT,TIME,DELT,MXJBD,ITIM,SUBHD
          END IF
          LINE = LINE + 1
          WRITE(LUOUT,2100) NI,(H(NJ),NJ = NJMN,NJMX)
  210   CONTINUE
      END IF
C
      IF (KPR .GE. 3) THEN
C
C       ***** Print total head
C
        KOUT = KOUT + 1
        LINE = 0
        DO 310 NI = 1,NNP,5
          NJMN = NI
          NJMX = MIN0(NI + 4,NNP)
          IF (MOD(LINE,50) .EQ. 0) THEN
C           need a new header
            WRITE(LUOUT,3000) KOUT,TIME,DELT,MXJBD,ITIM,SUBHD
          END IF
          LINE = LINE + 1
          WRITE(LUOUT,2100) NI,(HT(NJ),NJ = NJMN,NJMX)
  310   CONTINUE
      END IF
C
      IF (KPR .GE. 4) THEN
C
C       ***** Print moisture content
C
        KOUT = KOUT + 1
        LINE = 0
        DO 410 M = 1,NEL
          IF (MOD(LINE,50-1) .EQ. 0) THEN
C           need a new header
            WRITE(LUOUT,4000) KOUT,TIME,DELT,MXJBD,ITIM,SUBHD
          END IF
          WRITE(LUOUT,4100) M,(TH(IQ,M),IQ = 1,8)
          LINE = LINE + 1
 410    CONTINUE
      END IF
C
      IF (KPR .GE. 5) THEN
C
C       ***** Print Darcy velocity
C
        KOUT = KOUT + 1
        LINE = 0
        DO 510 NP = 1,NNP,2
          IF (MOD(LINE,50) .EQ. 0) THEN
C           need a new header
            WRITE(LUOUT,5000) KOUT,TIME,DELT,MXJBD,ITIM,SUBHD
          END IF
          LINE = LINE + 1
          NJMN = NP
          NJMX = MIN0(NP + 1,NNP)
          WRITE(LUOUT,5100) (NJ,VX(NJ),VY(NJ),VZ(NJ),NJ = NJMN,NJMX)
 510    CONTINUE
      END IF
C
      RETURN
      END
