      SUBROUTINE   Q4S
     I                (XQ,YQ,ZQ,F1Q,F2Q,
     O                 R1Q,R2Q)
C
C     + + + PURPOSE + + +
C     To evaluate boundary surface load vector over a boundary segment
C
C     + + + DUMMY ARGUMENTS + + +
      DOUBLE PRECISION   XQ(4),YQ(4),ZQ(4),F1Q(4),F2Q(4),R1Q(4),R2Q(4)
C
C     + + + ARGUMENT DEFINITIONS + + +
C     XQ    - x-coordinate at four nodes of the surface segment
C     YQ    - y-coordinate at four nodes of the surface segment
C     ZQ    - z-coordinate at four nodes of the surface segment
C     F1Q   - Specified normal flux at four nodes of the surface
C     F2Q   - Gravity flux at four nodes of a Neumann surface
C     R1Q   - Integration of N(I)*F1Q over the boundary segment
C     R2Q   - Integration of N(I)*F2Q over the boundary segment
C
C     + + + LOCAL VARIABLES + + +
      INTEGER            IQ,KG
      DOUBLE PRECISION   P,SS,TT,SM,SP,TM,TP,
     >                   DXDSS,DYDSS,DZDSS,DXDTT,DYDTT,DZDTT,
     >                   DETZ,DETY,DETX,DET,F1K,F2K,
     >                   N(4),S(4),T(4),DNSS(4),DNTT(4)
C
C     + + + INTRINSICS + + +
      INTRINSIC DSQRT
C
C     + + + DATA INITIALIZATIONS + + +
      DATA P/ 0.577350269189626D0/
      DATA S/-1.0D+00, 1.0D+00, 1.0D+00,-1.0D+00/
      DATA T/-1.0D+00,-1.0D+00, 1.0D+00, 1.0D+00/
C
C     + + + END SPECIFICATIONS + + +
C
C     initiate surface flux vector
      DO 100 IQ = 1,4
        R1Q(IQ) = 0.0
        R2Q(IQ) = 0.0
 100  CONTINUE
C
C     *** Perform integration with Gaussian quadrature
C
      DO 490 KG = 1,4
C
C       determine local coordinate at the Gaussian point KG
        SS = P*S(KG)
        TT = P*T(KG)
C
C       compute some grouped variables
        SM  = 1.0D0 - SS
        SP  = 1.0D0 + SS
        TM  = 1.0D0 - TT
        TP  = 1.0D0 + TT
C
C       compute base functions
        N(1) = 0.25D0*SM*TM
        N(2) = 0.25D0*SP*TM
        N(3) = 0.25D0*SP*TP
        N(4) = 0.25D0*SM*TP
C
C       compute partial derivatives of base functions with respect to
C       local coordinate xi
        DNSS(1) = -0.25D0*TM
        DNSS(2) =  0.25D0*TM
        DNSS(3) =  0.25D0*TP
        DNSS(4) = -0.25D0*TP
C
C       compute partial derivatives of base functions with respect to
C       local coordinate eta
        DNTT(1) = -0.25D0*SM
        DNTT(2) = -0.25D0*SP
        DNTT(3) =  0.25D0*SP
        DNTT(4) =  0.25D0*SM
C
C       initiate six entries of the
C       (partial r/partial xsi) X (partial r/partial eta).
        DXDSS = 0.0D0
        DYDSS = 0.0D0
        DZDSS = 0.0D0
        DXDTT = 0.0D0
        DYDTT = 0.0D0
        DZDTT = 0.0D0
C
C       compute six entries of the
C       (partial r/partial xsi) X (partial r/partial eta).
        DO 290 IQ = 1,4
          DXDSS = DXDSS + XQ(IQ)*DNSS(IQ)
          DYDSS = DYDSS + YQ(IQ)*DNSS(IQ)
          DZDSS = DZDSS + ZQ(IQ)*DNSS(IQ)
          DXDTT = DXDTT + XQ(IQ)*DNTT(IQ)
          DYDTT = DYDTT + YQ(IQ)*DNTT(IQ)
          DZDTT = DZDTT + ZQ(IQ)*DNTT(IQ)
  290   CONTINUE
C
C       compute the determinant of the Jacobian matrix
        DETZ =  DXDSS*DYDTT - DYDSS*DXDTT
        DETY = -DXDSS*DZDTT + DZDSS*DXDTT
        DETX =  DYDSS*DZDTT - DZDSS*DYDTT
        DET  =  DSQRT(DETX*DETX + DETY*DETY + DETZ*DETZ)
C
C       evaluate normal flux at the Gaussian points
        F1K = 0.0D0
        F2K = 0.0D0
        DO 350 IQ = 1,4
          F1K = F1K + F1Q(IQ)*N(IQ)
          F2K = F2K + F2Q(IQ)*N(IQ)
  350   CONTINUE
C
C       sum the contribution to surface flux due to the
C       Gaussian point KG
        DO 390 IQ = 1,4
          R1Q(IQ) = R1Q(IQ) + N(IQ)*F1K*DET
          R2Q(IQ) = R2Q(IQ) + N(IQ)*F2K*DET
  390   CONTINUE
  490 CONTINUE
C
      RETURN
      END
