      SUBROUTINE   Q8
     I               (ILUMP,DTHG,AKXG,AKYG,AKZG,AKXYG,AKXZG,AKYZG,
     I                XQ,YQ,ZQ,SOSM,AGRAV,
     O                QA,QB,RQ)
C
C     + + + PURPOSE + + +
C     To compute elment matrices and element load vector given by
C        QA(I,J) = integration of N(I)*DTH/DH*N(J)
C        QB(I,J) = integration of Grad(N(I)).K.Grad(N(j))
C        RQ(I)   = integration of N(I).K.(Unit Vector in Z)
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER            ILUMP
      DOUBLE PRECISION   DTHG(8),AKXG(8),AKYG(8),AKZG(8),
     >                   AKXYG(8),AKXZG(8),AKYZG(8),
     >                   XQ(8),YQ(8),ZQ(8),SOSM,AGRAV,
     >                   QA(8,8),QB(8,8),RQ(8)
C
C     + + + ARGUMENT DEFINITIONS + + +
C     ILUMP  - Mass matrix lumping option, 0 = no lump, 1 = lump.
C     DTHG   - Water capacity at eight Gaussian point of the element
C     AKXG   - XX- conductivity at eight Gaussian points of the element
C     AKYG   - YY- conductivity at eight Gaussian points of the element
C     AKZG   - ZZ- conductivity at eight Gaussian points of the element
C     AKXYG  - XY- conductivity at eight Gaussian points of the element
C     AKXZG  - XZ- conductivity at eight Gaussian points of the element
C     AKYZG  - YZ- conductivity at eight Gaussian points of the element
C     XQ     - X-coordinate at eight nodes of the elements
C     YQ     - Y-coordinate at eight nodes of the elements
C     ZQ     - Z-coordinate at eight nodes of the elements
C     SOSM   - Source/sink strength of the element
C     AGRAV  - Gravity term included? 0.0 = no, 1.0 = yes.
C     QA     - Integration of N(I)*DTH/DH*N(J)
C     QB     - Integration of Grad(N(I)).K.Grad(N(j))
C     RQ     - Integration of N(I).K.(Unit Vector in Z)
C
C     + + + LOCAL VARIABLES + + +
      INTEGER            IQ,JQ,KG,I,J
      DOUBLE PRECISION   P,SS,TT,UU,DJAC,SUM,
     >                   AKXQP,AKYQP,AKZQP,AKXYQP,AKXZQP,AKYZQP,DTHQP,
     >                   SOSMQP,N(8),DNX(8),DNY(8),DNZ(8),S(8),T(8),U(8)
C
C     + + + EXTERNALS + + +
      EXTERNAL  BASE
C
C     + + + DATA INITIALIZATIONS + + +
      DATA P / 0.577350269189626D0/
      DATA S/-1.0D0, 1.0D0, 1.0D0,-1.0D0,-1.0D0, 1.0D0,1.0D0,-1.0D0/
      DATA T/-1.0D0,-1.0D0, 1.0D0, 1.0D0,-1.0D0,-1.0D0,1.0D0, 1.0D0/
      DATA U/-1.0D0,-1.0D0,-1.0D0,-1.0D0, 1.0D0, 1.0D0,1.0D0, 1.0D0/
C
C     + + + END SPECIFICATIONS + + +
C
C     *** Initiate the element matrices and load vector
C
      DO 110 IQ = 1,8
        RQ(IQ) = 0.0
        DO 100 JQ = 1,8
          QA(IQ,JQ) = 0.0
          QB(IQ,JQ) = 0.0
  100   CONTINUE
  110 CONTINUE
C
C     *** Perform integration by Gaussian quadrature
C
      DO 490 KG = 1,8
C
C       compute the local coordinate of the Gaussian point KG
        SS = P*S(KG)
        TT = P*T(KG)
        UU = P*U(KG)
C
C       compute base functions and their derivatives with respect to
C       x, y, and z, and the determinant of the Jacobian
        CALL BASE
     I           (XQ,YQ,ZQ,SS,TT,UU,
     O            N,DNX,DNY,DNZ,DJAC)
C
C       compute the prduct of hydraulic conductivity, water capacity,
C       and source/sink with Jacobian determinant
        AKXQP  = AKXG(KG)*DJAC
        AKYQP  = AKYG(KG)*DJAC
        AKZQP  = AKZG(KG)*DJAC
        AKXYQP = AKXYG(KG)*DJAC
        AKXZQP = AKXZG(KG)*DJAC
        AKYZQP = AKYZG(KG)*DJAC
        DTHQP  = DTHG(KG)*DJAC
        SOSMQP = SOSM*DJAC
C
C       sum the contribution to element matrices and load vector due
C       the Gaussian point KG
        DO 390 IQ = 1,8
          RQ(IQ) = RQ(IQ) + AGRAV*(DNX(IQ)*AKXZQP + AKYZQP*DNY(IQ) +
     >             AKZQP*DNZ(IQ)) + N(IQ)*SOSMQP
          DO 380 JQ = 1,8
            QA(IQ,JQ) = QA(IQ,JQ) + DTHQP*N(IQ)*N(JQ)
            QB(IQ,JQ) = QB(IQ,JQ) +
     >        DNX(IQ)*(AKXQP *DNX(JQ)+ AKXYQP*DNY(JQ)+ AKXZQP*DNZ(JQ))+
     >        DNY(IQ)*(AKXYQP*DNX(JQ)+ AKYQP *DNY(JQ)+ AKYZQP*DNZ(JQ))+
     >        DNZ(IQ)*(AKXZQP*DNX(JQ)+ AKYZQP*DNY(JQ)+ AKZQP *DNZ(JQ))
  380     CONTINUE
  390   CONTINUE
C
  490 CONTINUE
C
C     *** Determine if the mass matrix is to be lumped?
C
      IF (ILUMP .NE. 0) THEN
C       lump the mass matrix
        DO 640 I = 1,8
          SUM = 0.0
          DO 620 J = 1,8
            SUM     = SUM + QA(I,J)
            QA(I,J) = 0.0
  620     CONTINUE
          QA(I,I) = SUM
  640   CONTINUE
      END IF
C
      RETURN
      END
