      SUBROUTINE   Q8DV
     I                 (XQ,YQ,ZQ,HTQ,AKXG,AKYG,AKZG,AKXYG,AKXZG,AKYZG,
     O                  QB,QRX,QRY,QRZ)
C
C     + + + PURPOSE + + +
C     To compute the integration of N(I)*N(J) and -N(I)*K.Grad(HT)
C
C     + + + DUMMY ARGUMENTS + + +
      DOUBLE PRECISION   XQ(8),YQ(8),ZQ(8),HTQ(8),
     >                   AKXG(8),AKYG(8),AKZG(8),AKXYG(8),AKXZG(8),
     >                   AKYZG(8),QB(8,8),QRX(8),QRY(8),QRZ(8)
C
C     + + + ARGUMENT DEFINITIONS + + +
C     XQ    - X-coordinate at eight nodes of the element
C     YQ    - Y-coordinate at eight nodes of the element
C     ZQ    - Z-coordinate at eight nodes of the element
C     HTQ   - Total head at eight ndoes of the element
C     AKXG  - XX- hydraulic conductivity at eight Gaussian points
C     AKYG  - YY- hydraulic conductivity at eight Gaussian points
C     AKZG  - ZZ- hydraulic conductivity at eight Gaussian points
C     AKXYG - XY- hydraulic conductivity at eight Gaussian points
C     AKXZG - XZ- hydraulic conductivity at eight Gaussian points
C     AKYZG - YZ- hydraulic conductivity at eight Gaussian points
C     QB    - 8 x 8 element matrix
C     QRX   - X-veolcity element vector
C     QRY   - Y-veolcity element vector
C     QRZ   - Z-veolcity element vector
C
C     + + + LOCAL VARIABLES + + +
      INTEGER            IQ,JQ,KG
      DOUBLE PRECISION   P,SS,TT,UU,DJAC,
     >                   AKXK,AKYK,AKZK,AKXYK,AKXZK,AKYZK,
     >                   N(8),S(8),T(8),U(8),DNX(8),DNY(8),DNZ(8)
C
C     + + + EXTERNALS + + +
      EXTERNAL  BASE
C
C     + + + DATA INITIALIZATIONS + + +
      DATA P /0.577350269189626D0/
      DATA S/-1.0D0,1.0D0,1.0D0,-1.0D0, -1.0D0,1.0D0,1.0D0,-1.0D0/
      DATA T/-1.0D0,-1.0D0,1.0D0,1.0D0, -1.0D0,-1.0D0,1.0D0,1.0D0/
      DATA U/-1.0D0,-1.0D0,-1.0D0,-1.0D0, 1.0D0,1.0D0,1.0D0,1.0D0/
C
C     + + + END SPECIFICATIONS + + +
C
C
C     initiate element vectors and element matrix
      DO 110 IQ = 1,8
        QRX(IQ) = 0.0
        QRY(IQ) = 0.0
        QRZ(IQ) = 0.0
        DO 100 JQ = 1,8
          QB(IQ,JQ) = 0.0
 100    CONTINUE
 110  CONTINUE
C
C     *** Perform integration by Gaussian quadrature
C
      DO 490 KG = 1,8
C
C       determine local coordinate of Gaussian point KG
        SS = P*S(KG)
        TT = P*T(KG)
        UU = P*U(KG)
C
C       calculate base functions and their derivatives with respect to
C       x, y, and z at the Gaussian point KG
        CALL BASE
     I           (XQ,YQ,ZQ,SS,TT,UU,
     O            N,DNX,DNY,DNZ,DJAC)
C
C       put the hydraulic conductivity components into local vaiables
        AKXK  = AKXG(KG)
        AKYK  = AKYG(KG)
        AKZK  = AKZG(KG)
        AKXYK = AKXYG(KG)
        AKXZK = AKXZG(KG)
        AKYZK = AKYZG(KG)
C
C       sum the contribution to element matrix and vectors due to the
C       Gaussian point KG
        DO 390 IQ = 1,8
          DO 290 JQ = 1,8
            QB(IQ,JQ) = QB(IQ,JQ) + (N(IQ)*N(JQ)*DJAC)
            QRX(IQ)   = QRX(IQ) - N(IQ)*HTQ(JQ)*(AKXK*DNX(JQ) +
     1                  AKXYK*DNY(JQ) + AKXZK*DNZ(JQ))*DJAC
            QRY(IQ)  = QRY(IQ) - N(IQ)*HTQ(JQ)*(AKXYK*DNX(JQ) +
     1                 AKYK*DNY(JQ) + AKYZK*DNZ(JQ))*DJAC
            QRZ(IQ)  = QRZ(IQ) - N(IQ)*HTQ(JQ)*(AKXZK*DNX(JQ) +
     1                 AKYZK*DNY(JQ) + AKZK*DNZ(JQ))*DJAC
  290     CONTINUE
  390   CONTINUE
  490 CONTINUE
C
      RETURN
      END
