      SUBROUTINE   SOLVE
     I                  (KKK,NNP,IHALFB,MAXNP,MAXBW,
     M                   C,R)
C
C     + + + PURPOSE + + +
C     To solve matrix equation with direct band method
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER            KKK,NNP,IHALFB,MAXNP,MAXBW
      DOUBLE PRECISION   C(MAXNP,MAXBW),R(MAXNP)
C
C     + + + ARGUMENT DEFINITIONS + + +
C     KKK    - Decomposition or back substitution indicator
C              1 = decompoisiton, 2= back substituion
C     NNP    - number of equations
C     IHALFB - half band with plus 1
C     MAXNP  - maximum number of equations
C     MAXBW  - maximum number of band width
C     C      - coefficient matrix
C     R      - load vector
C
C     + + + LOCAL VARIABLES + + +
      INTEGER            IHBP,NU,NI,NJ,IB,NK,NL,JB,KB,LB,MB,NB,NR,IBAND
      DOUBLE PRECISION   PIVOTI,A,SUM
C
C     + + + END SPECIFICATIONS + + +
C
C
      IHBP = IHALFB + 1
      IF (KKK .EQ. 1) THEN
C
C       ***** LU decomposition of the matrix
C
        NU = NNP - IHALFB
        DO 20 NI = 1,NU
C         put pivoting
          PIVOTI = 1.0D0/C(NI,IHBP)
          NJ     = NI + 1
          IB     = IHBP
          NK     = NI + IHALFB
          DO 15 NL = NJ,NK
C           eliminate rows
            IB       = IB - 1
            A        = -C(NL,IB)*PIVOTI
            C(NL,IB) = A
            JB       = IB + 1
            KB       = IB + IHALFB
            LB       = IHBP - IB
C           eliminate column
            DO 10 MB = JB,KB
              NB       = LB + MB
              C(NL,MB) = C(NL,MB) + A*C(NI,NB)
   10       CONTINUE
   15     CONTINUE
   20   CONTINUE
C
        NR = NU + 1
        NU = NNP - 1
        NK = NNP
C
        IF (NR .LE. NU) THEN
          DO 40 NI = NR,NU
            PIVOTI = 1.0D0/C(NI,IHBP)
            NJ = NI + 1
            IB = IHBP
C           eliminate row
            DO 35 NL = NJ,NK
              IB       = IB - 1
              A        = -C(NL,IB)*PIVOTI
              C(NL,IB) = A
              JB       = IB + 1
              KB       = IB + IHALFB
              LB       = IHBP - IB
C             eliminate column
              DO 30 MB = JB,KB
                NB       = LB + MB
                C(NL,MB) = C(NL,MB) + A*C(NI,NB)
   30         CONTINUE
   35       CONTINUE
   40     CONTINUE
        END IF
C
      ELSE
C
C       ***** Back solve
C
        NU    = NNP + 1
        IBAND = 2*IHALFB + 1
C
        DO 70 NI = 2,IHBP
          IB  = IHBP - NI + 1
          NJ  = 1
          SUM = 0.0
C
          DO 60 JB = IB,IHALFB
            SUM = SUM + C(NI,JB)*R(NJ)
            NJ  = NJ + 1
 60       CONTINUE
          R(NI) = R(NI) + SUM
 70     CONTINUE
        IB = 1
        NL = IHBP + 1
C
        DO 90 NI = NL,NNP
          NJ  = NI - IHBP + 1
          SUM = 0.0
C
          DO 80 JB = IB,IHALFB
            SUM = SUM + C(NI,JB)*R(NJ)
            NJ  = NJ + 1
  80      CONTINUE
          R(NI) = R(NI) + SUM
  90    CONTINUE
C
        R(NNP) = R(NNP)/C(NNP,IHBP)
C
        DO 110 IB = 2,IHBP
          NI  = NU - IB
          NJ  = NI
          MB  = IHALFB + IB
          SUM = 0.0
C
          DO 100 JB = NL,MB
            NJ  = NJ + 1
            SUM = SUM + C(NI,JB)*R(NJ)
 100      CONTINUE
          R(NI) = (R(NI) - SUM)/C(NI,IHBP)
 110    CONTINUE
C
        MB = IBAND
C
        DO 130 IB = NL,NNP
          NI  = NU - IB
          NJ  = NI
          SUM = 0.0
C
          DO 120 JB = NL,MB
            NJ  = NJ + 1
            SUM = SUM + C(NI,JB)*R(NJ)
 120      CONTINUE
          R(NI) = (R(NI) - SUM)/C(NI,IHBP)
 130    CONTINUE
      END IF
C
      RETURN
      END
                                                                                                