      SUBROUTINE   ASEMBL
     I                   (X,Y,Z,IE,LRN, HP,DTH,AKR, PROP,
     I                    SOS,LES,ISTYP, WSS,NPW,IWTYP,
     I                    KSS,W,DELT,LUOUT,
     O                    CMATRX,RLD)
C
C     + + + PURPOSE + + +
C     To assemble the global coefficient matrix and global load
C     vector in compressed form
C
C     + + + COMMON BLOCKS + + +
      INCLUDE 'CSGEOM.INC'
      INCLUDE 'CGEOM.INC'
      INCLUDE 'CS.INC'
      INCLUDE 'CW.INC'
      INCLUDE 'CSMTL.INC'
      INCLUDE 'COPTN.INC'
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER            IE(MAXEL,9),LRN(MXJBD,MAXNP),LES(MXSEL),
     >                   ISTYP(MXSEL),NPW(MXWNP),IWTYP(MXWNP),KSS,LUOUT
      DOUBLE PRECISION   X(MAXNP),Y(MAXNP),Z(MAXNP),HP(MAXNP),
     >                   DTH(8,MAXEL),AKR(8,MAXEL),PROP(MXMPPM,MAXMAT),
     >                   SOS(MXSPR),WSS(MXWPR),W,DELT,
     >                   CMATRX(MAXNP,MXJBD),RLD(MAXNP)
C
C     + + + ARGUMENT DEFINITIONS + + +
C     X(N)        - x-coordinate of the N-th node
C     Y(N)        - y-coordinate of the N-th node
C     Z(N)        - z-coordinate of the N-th node
C     IE(M,I)     - global node number of I-th node of the M-th element
C                   if I = 1 to 8, material type of the M0th element if
C                   I = 9
C     LRN(I,N)    - global node number of the I-th connecting node to
C                   the N-th node
C
C     HP(N)       - previous-time pressure heat at the N-th node
C     DTH(I,M)    - water capacity at the I-th node of the M-th element
C     AKR(I,M)    - relative conductivity at I-th node of M-th element
C
C     PROP(I,J)   - I-th material property of the J-th material;
C                     I = 1 = saturated xx-hydraulic conductivity
C                     I = 2 = saturated yy-hydraulic conductivity
C                     I = 3 = saturated zz-hydraulic conductivity
C                     I = 4 = saturated xy-hydraulic conductivity
C                     I = 5 = saturated xz-hydraulic conductivity
C                     I = 6 = saturated yz-hydraulic conductivity
C
C     SOS(J)      - value of J-th element source/sink at present time
C     LES(MP)     - global element number of the MP-th s/s element
C     ISTYP(MP)   - source/sink type assigned to the MP-th s/s element
C     WSS(J)      - value of the J-th well source/sink at present time
C     NPW(NP)     - global node number of the NP-th s/s well node
C     IWTYP(NP)   - source/sink type assigned to the NP-th well node
C
C     KSS         - steady state simulation control
C     W           - time integration parameter
C     DELT        - time step size
C     LUOUT       - logical unit for output data
C
C     CMATRX(N,I) - an array to store the assembled global matrix
C
C
C     + + + LOCAL VARIABLES + + +
      INTEGER            NP,I,M,MTYP,IQ,KG,ITYP,NI,JQ,NJ,LNODE,IEM(8),
     >                   DONEFG
      DOUBLE PRECISION   AGRAV,SOSM,DELTI,W1,W2,SAKX,SAKY,SAKZ,SAKXY,
     >                   SAKXZ,SAKYZ,DTHG(8),AKXG(8),AKYG(8),AKZG(8),
     >                   AKXYG(9),AKXZG(8),AKYZG(8),XQ(8),YQ(8),ZQ(8),
     >                   QA(8,8),QB(8,8),RQ(8)
C
C     + + + INTRINSICS + + +
      INTRINSIC  DBLE
C
C     + + + EXTERNALS + + +
      EXTERNAL   Q8
C
C     + + + OUTPUT FORMATS + + +
 2000 FORMAT('1'/5X,'*** WARNING: NONE OF THE LOWER-LEFT NODE IN EQUATIO
     >N',I3,/5X,'***  IS CORRESPONDING TO ',I5,'-TH ELEMENT-S',I2,
     >'-TH NODE; STOP  ****')
C
C     + + + END SPECIFICATIONS + + +
C
      AGRAV = DBLE(KGRAV)
C
      IF (KSS .NE. 0) THEN
C       for the case transient simulation
        DELTI = 1.0D0/DELT
        W1    = W
        W2    = 1.0D0 - W
      ELSE
C       for the case of steady state simulation
        DELTI = 0.D0
        W1    = 1.0D0
        W2    = 0.
      END IF
C
C     initiate matrices and load vector CMATRIX and RLD
      DO 150 NP = 1,NNP
        RLD(NP) = 0.0
        DO 140 I = 1,MXJBD
          CMATRX(NP,I) = 0.0
  140   CONTINUE
  150 CONTINUE
C
C     *** Start to assemble over all elements
C
      DO 490 M = 1,NEL
C
C       put material properties in local variables
        MTYP  = IE(M,9)
        SAKX  = PROP(1,MTYP)
        SAKY  = PROP(2,MTYP)
        SAKZ  = PROP(3,MTYP)
        SAKXY = PROP(4,MTYP)
        SAKXZ = PROP(5,MTYP)
        SAKYZ = PROP(6,MTYP)
C
C       put nodal coordinates in global variables in local variables
        DO 210 IQ = 1,8
          NP      = IE(M,IQ)
          IEM(IQ) = NP
          XQ(IQ)  = X(NP)
          YQ(IQ)  = Y(NP)
          ZQ(IQ)  = Z(NP)
  210   CONTINUE
C
C       put moisture content into local variables and
C       compute hydraulic conductivity
        DO 220 KG = 1,8
          DTHG(KG)  = DTH(KG,M)
          AKXG(KG)  = SAKX*AKR(KG,M)
          AKYG(KG)  = SAKY*AKR(KG,M)
          AKZG(KG)  = SAKZ*AKR(KG,M)
          AKXYG(KG) = SAKXY*AKR(KG,M)
          AKXZG(KG) = SAKXZ*AKR(KG,M)
          AKYZG(KG) = SAKYZ*AKR(KG,M)
  220   CONTINUE
C
C       check if the element is an source/sink element
        SOSM = 0.0
        IF (NSEL .GT. 0) THEN
C         set flag
          DONEFG = 0
          I      = 0
  240     CONTINUE
C           loop over all source/sink elements to see if any one of
C           them is element M
            I = I + 1
            IF (LES(I) .EQ. M) THEN
C             one of the source/sink element is element M
              ITYP   = ISTYP(I)
              SOSM   = SOS(ITYP)
              DONEFG = 1
            END IF
          IF (I .LT. NSEL .AND. DONEFG .EQ. 0) THEN
            GO TO 240
          END IF
        END IF
C
C       compute element matrices QA and QB, and element load vector RQ
        CALL Q8
     I         (ILUMP,DTHG,AKXG,AKYG,AKZG,AKXYG,AKXZG,AKYZG,
     I          XQ,YQ,ZQ,SOSM,AGRAV,
     O          QA,QB,RQ)
C
C       put the contribution of element M to global matrices
C       CMATRIX(NP,IB) = QB(IQ,JQ) + QA(IQ,JQ)/DELT
C
C       loop over eight rows of the element matrices
        DO 390 IQ = 1,8
          NI      = IEM(IQ)
          RLD(NI) = RLD(NI) - RQ(IQ)
C         loop over eight columns of the element matrices
          DO 340 JQ = 1,8
            NJ = IEM(JQ)
            IF (IMID .NE. 0) THEN
C             for the case of mid-difference
              QA(IQ,JQ) = 2.0D0*QA(IQ,JQ)*DELTI
            ELSE
C             for the case of non-mid-difference
              QA(IQ,JQ) = QA(IQ,JQ)*DELTI
            END IF
            RLD(NI) = RLD(NI) + (QA(IQ,JQ) - W2*QB(IQ,JQ))*HP(NJ)
C
C           check which compressed entries of the global matrix we
C           should put the element matrices to it?
            I      = 0
            DONEFG = 0
  325       CONTINUE
              I     = I + 1
              LNODE = LRN(I,NI)
              IF (LNODE .EQ. NJ) THEN
C               we have found the compressted entry, set done flag
                DONEFG = 1
              END IF
            IF (DONEFG .EQ. 0 .AND. I .LT. MXJBD) THEN
              GO TO 325
            END IF
C
            IF (DONEFG .EQ. 0) THEN
C             we cannot find the compressed entry, print error message
              WRITE(LUOUT,2000) NI,M,JQ
              STOP
            ELSE
C             put the element matrices to the I-th compressed entry
              CMATRX(NI,I) = CMATRX(NI,I) + QA(IQ,JQ) + W1*QB(IQ,JQ)
            END IF
C
  340     CONTINUE
  390   CONTINUE
  490 CONTINUE
C
      IF (NWNP .NE. 0) THEN
C
C       Incorporate well source-sink
C
        DO 790 I = 1,NWNP
          NI      = NPW(I)
          ITYP    = IWTYP(I)
          RLD(NI) = RLD(NI) + WSS(ITYP)
  790   CONTINUE
      END IF
C
      RETURN
      END
