      SUBROUTINE   BCPREP
     I                   (IE,X,Y,Z,H,VX,VY,VZ,DCOSB,ISB,ISV,HCON,HMIN,
     I                    IRTYP,RFALL,
     O                    DCYFLX,FLX,NPFLX,NPCON,NPMIN,NCHG)
C
C     + + + PURPOSE + + +
C     To determine whether the Dirichlet BC with ponding depth, or the
C     Dirichlet BC with minimum pressure head, or flux BC with rainfall,
C     or the flux BC with potential evaporation rate is to be applied
C     to variable boundaries
C
C     + + + COMMON BLOCKS + + +
      INCLUDE 'CSGEOM.INC'
      INCLUDE 'CVBC.INC'
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER            IE(MAXEL,9),ISB(6,MAXBES),ISV(5,MXVES),
     >                   IRTYP(MXVES),NPFLX(MXVNP),NPCON(MXVNP),
     >                   NPMIN(MXVNP),NCHG
      DOUBLE PRECISION   X(MAXNP),Y(MAXNP),Z(MAXNP),H(MAXNP),VX(MAXNP),
     >                   VY(MAXNP),VZ(MAXNP),DCOSB(3,MAXBES),
     >                   HCON(MXVNP),HMIN(MXVNP),RFALL(MXRPR),
     >                   DCYFLX(MXVNP),FLX(MXVNP)
C
C     + + + ARGUMENT DEFINITIONS + + +
C     IE(M,I)     - global node number of I-th node of the M-th element
C                   if I = 1 to 8, material type of the M0th element if
C                   I = 9
C     X(N)        - x-coordinate of the N-th node
C     Y(N)        - y-coordinate of the N-th node
C     Z(N)        - z-coordinate of the N-th node
C
C     H(N)        - pressure head at the N-th node
C     VX(N)       - x-component of Darcy velocity at the N-th node
C     VY(N)       - y-component of Darcy velocity at the N-th node
C     VZ(N)       - z-component of Darcy velocity at the N-th node
C
C     DCOSB(1,I)  - directional cosine of the I-th boundary side with x
C     DCOSB(2,I)  - directional cosine of the I-th boundary side with y
C     DCOSB(3,I)  - directional cosine of the I-th boundary side with z
C     ISB(1,I)    - boundary node number of the first node of the I-th
C                   boundary side
C     ISB(2,I)    - boundary node number of the second node of the I-th
C                   boundary side
C     ISB(3,I)    - boundary node number of the third node of the I-th
C                   boundary side
C     ISB(4,I)    - boundary node number of the fourth node of the I-th
C                   boundary side
C     ISB(5,I)    - element side index of the I-th boundary side;
C                   1 = left side, 2 = front side, 3 = right side,
C                   4 = back side, 5 = bottom side, 6 = top side
C     ISB(6,I)    - global element number to which the I-th boundary
C                   side belong
C
C     ISV(1,MP)   - global node number of the first node of the MP-th
C                   variable boundary side
C     ISV(2,MP)   - global node number of the second node of the MP-th
C                   variable boundary side
C     ISV(3,MP)   - global node number of the third node of the MP-th
C                   variable boundary side
C     ISV(4,MP)   - global node number of the fourth node of the MP-th
C                   variable boundary side
C     ISV(5,MP)   - boundary node number of the MP-th VB side
C     HCON(NP)    - ponding depth of the NP-th variable boundary node
C     HMIN(NP)    - minimum pressure allowed for the NP-th VB node
C     IRTYP(MP)   - type of rainfall profile assigned to MP-th VB side
C     RFALL(J)    - rainfall rate of J-th profile at the present time
C     DCYFLX(NP)  - Darcy flux through the NP-th variable boundary node
C     FLX(NP)     - rainfall flux through the NP-th VB node
C     NPFLX(NP)   - flux boundary condition indicator of the NP-th
C                   VB node; 0 = this is not a flux-condition node for
C                   the present time step, globan node number = this
C                   is a flux-condition node for the present time
C     NPCON(NP)   - ponding condition indicator of the NP-th VB node:
C                   0 = this is not a ponding-condition node for the
C                   present time step, global node number = this is
C                   a ponding-condition node for the present time
C     NPMIN(NP)   - minimum-pressure condition indicator of NP-th VB
C                   node; 0 = this is not a minimum-pressure-condition
C                   node for the present time step, global node number =
C                   this is a minimum-pressure-condition node for the
C                   present time step
C     RF(I,J)     - rainfall rate of I-th data point in J-th profile
C     TRF(I,J)    - time of the I-th data point in J-th rainfall profile
C     NCHG        - number of variable boundary nodes that has changed
C                   boundary conditions
C
C     + + + LOCAL VARIABLES + + +
      INTEGER            NP,MP,ITYP,MPB,LS,M,IQ,I,NI,NPP,IDO
      DOUBLE PRECISION   RFMP,PROJ,RFMPN,DCYNNP,FLXNNP,HCONNP,HMINNP,
     >                   R1Q(4),R2Q(4),XQ(4),YQ(4),ZQ(4),F1Q(4),F2Q(4),
     >                   KGB(4,6)
C
C     + + + EXTERNALS + + +
      EXTERNAL   Q4S
C
C     + + + DATA INITIALIZATIONS + + +
      DATA KGB/1,4,8,5, 1,2,6,5, 2,3,7,6, 4,3,7,8, 1,2,3,4, 5,6,7,8/
C
C     + + + END SPECIFICATIONS + + +
C
C     *** Initiate normal rainfall flux FLX and Darcy flux DCYFLX
C
      DO 210 NP = 1,NVNP
         FLX(NP)    = 0.
         DCYFLX(NP) = 0.
  210 CONTINUE
C
C     *** Compute normal rainfall FLX(I) and Darcy flux DCYFLX(I) for
C     *** each nodal point on the variable boundary element side
C
      DO 290 MP = 1,NVES
        ITYP = IRTYP(MP)
        RFMP = RFALL(ITYP)
C
        MPB  = ISV(5,MP)
        LS   = ISB(5,MPB)
        M    = ISB(6,MPB)
C
        PROJ  = DCOSB(3,MPB)
        RFMPN = -RFMP*PROJ
C
        DO 230 IQ = 1,4
          I       = KGB(IQ,LS)
          NI      = IE(M,I)
          XQ(IQ)  = X(NI)
          YQ(IQ)  = Y(NI)
          ZQ(IQ)  = Z(NI)
          F1Q(IQ) = RFMPN
          F2Q(IQ) = VX(NI)*DCOSB(1,MPB) + DCOSB(2,MPB)*VY(NI) +
     >              DCOSB(3,MPB)*VZ(NI)
  230   CONTINUE
C
C       compute surface integral of N(IQ).F
        CALL Q4S
     I          (XQ,YQ,ZQ,F1Q,F2Q,
     O           R1Q,R2Q)
C
C       sum the contribution from each of the four nodes
        DO 270 IQ = 1,4
          I         = ISV(IQ,MP)
          FLX(I)    = FLX(I) + R1Q(IQ)
          DCYFLX(I) = DCYFLX(I) + R2Q(IQ)
  270   CONTINUE
C
  290 CONTINUE
C
C     change to flux or head conditions, as necessary, and so
C     indicate in teh arrays NPFLX(NPP), NPCON(NPP), and NPMIN(NPP)
      IF (NCHG .EQ. (-1)) THEN
C       set NCHG to zero for next iteration
        NCHG = 0
C
      ELSE
C
        NCHG = 0
        DO 390 NPP = 1,NVNP
          DCYNNP = DCYFLX(NPP)
          FLXNNP = FLX(NPP)
          HCONNP = HCON(NPP)
          HMINNP = HMIN(NPP)
          IDO    = 1
C
          IF (FLXNNP .LE. 0.0) THEN
C
C           ***** Infiltration-seepage conditions during rainfall period
C
C           check if the change from rainfall-flux condition to ponding
C           condition is necessary?
            NP = NPFLX(NPP)
            IF (NP .NE. 0) THEN
              IDO = 0
C             need to check
              IF (HCONNP .LT. H(NP)) THEN
C               switch from raifall-flux condition to ponding conditions
                NPCON(NPP) = NPFLX(NPP)
                NPFLX(NPP) = 0
                NCHG       = NCHG + 1
              END IF
            END IF
C
C           check if the change from ponding condition to rainfall-flux
C           condition is necessary?
            IF(IDO .EQ. 1) THEN
              NP = NPCON(NPP)
              IF (NP .NE. 0) THEN
                IDO = 0
C               need to check
                IF (FLXNNP .GT. DCYNNP) THEN
C                 switch from ponding to flux conditions
                  NPFLX(NPP) = NPCON(NPP)
                  NPCON(NPP) = 0
                  NCHG       = NCHG + 1
                END IF
              END IF
            END IF
C
C           change mimimum pressure condition to rainfall-flux condition
C           since a minimum pressure condition is not likely to be during
C           rainfall period
C
            IF(IDO .EQ. 1) THEN
              NP = NPMIN(NPP)
              IF (NP .NE. 0) THEN
                IDO = 0
C             switch from minimum pressure condition to flux condition
                NPFLX(NPP) = NPMIN(NPP)
                NPMIN(NPP) = 0
                NCHG       = NCHG + 1
              END IF
            END IF
C
          ELSE
C
C           ***** Evaporation-seepage conditions during non-rainfall period
C
C           check if the change from evaporation-flux condition to
C           minimum pressure condition is necessary
            NP = NPFLX(NPP)
            IF (NP .NE. 0) THEN
              IDO = 0
C             need to check
              IF (HMINNP .GT. H(NP)) THEN
C               switch from flux condition to mimimum prssure condition
                NPMIN(NPP) = NPFLX(NPP)
                NPFLX(NPP) = 0
                NCHG       = NCHG + 1
              END IF
            END IF
C
C           check if the change from ponding condition to evaporation-flux
C           condition is necessary?
            IF(IDO .EQ. 1) THEN
              NP = NPCON(NPP)
              IF (NP .NE. 0) THEN
                IDO = 0
C               need to check
                IF (DCYNNP .LT. 0.0) THEN
C                 switch from poinding condition to flux condition
                  NPFLX(NPP) = NPCON(NPP)
                  NPCON(NPP) = 0
                  NCHG       = NCHG + 1
                END IF
              END IF
            END IF
C
C           check if the change from minimum pressure condition to
C           evaporation-flux condition is necessary?
            IF(IDO .EQ. 1) THEN
              NP = NPMIN(NPP)
              IF (NP .NE. 0) THEN
                IDO = 0
C               need to check
                IF (DCYNNP .GE. FLXNNP) THEN
C                 switch from minimum pressure condition to flux condition
                  NPFLX(NPP) = NPMIN(NPP)
                  NPMIN(NPP) = 0
                  NCHG       = NCHG + 1
                END IF
              END IF
            END IF
C
          END IF
  390   CONTINUE
C
      END IF
C
      RETURN
      END
