      PROGRAM   FEMWAT3D
C
C --------------------------------------------------------------------------
C Date: Monday, 9 August 1993.  Time: 11:27:49.
C --------------------------------------------------------------------------
C User recompiling and re-linking any portion of FEMWATER model code
C must search all source code files (*.INC, *.FOR) to locate system and/or
C compiler specific statements.  Search on the following character strings:
C      CPC - statements used for standard microcomputer for Lahey FORTRAN
C      NDP - statements used for microcomputer for NDP FORTRAN
C FEMWATER code has not be run time tested under any other microcomputer
C FORTRAN development tools.
C --------------------------------------------------------------------------
C
C     + + + PURPOSE + + +
C     3dfemwater - block iteration method.
C
C     + + + PARAMETERS + + +
      INCLUDE 'PMXSD.INC'
      INCLUDE 'PMXTD.INC'
      INCLUDE 'PMXSR.INC'
      INCLUDE 'PMXSS.INC'
      INCLUDE 'PMXCB.INC'
      INCLUDE 'PMXNB.INC'
      INCLUDE 'PMXRSB.INC'
      INCLUDE 'PMXDB.INC'
      INCLUDE 'PMXMS.INC'
C
C     + + + COMMON BLOCKS + + +
      INCLUDE 'CSGEOM.INC'
      INCLUDE 'CGEOM.INC'
      INCLUDE 'CLGEOM.INC'
      INCLUDE 'CINTE.INC'
      INCLUDE 'CREAL.INC'
      INCLUDE 'CS.INC'
      INCLUDE 'CW.INC'
      INCLUDE 'CCBC.INC'
      INCLUDE 'CNBC.INC'
      INCLUDE 'CVBC.INC'
      INCLUDE 'CDBC.INC'
      INCLUDE 'CSMTL.INC'
      INCLUDE 'CMTL.INC'
      INCLUDE 'COPTN.INC'
      INCLUDE 'CFLOW.INC'
C
C     + + + VARIABLES + + +
      INTEGER        IE(MAXELK,9),LRN(MXJBDK,MAXNPK),NLRL(MAXNPK),
     >               NTNPLR(MXRGNK),NNPLR(MXRGNK),LMAXDF(MXRGNK),
     >               GNLR(LTMXNK,MXRGNK),LNOJCN(MXJBDK,
     >               LMXNPK,MXRGNK),NPCNV(MAXNPK),LRL(MXKBDK,MAXNPK),
     >               ISB(6,MXBESK),NPBB(MXBNPK),ISTYP(MXSELK),
     >               LES(MXSELK),IWTYP(MXWNPK),NPW(MXWNPK),
     >               ICTYP(MXCESK),ISC(5,MXCESK),NPCB(MXCNPK),
     >               INTYP(MXNESK),ISN(5,MXNESK),NPNB(MXNNPK),
     >               IRTYP(MXVESK),ISV(5,MXVESK),NPVB(MXVNPK),
     >               NPFLX(MXVNPK),NPCON(MXVNPK),NPMIN(MXVNPK),
     >               IDTYP(MXDNPK),NPDB(MXDNPK), KPR(MXNTIK),
     >               KDSK(MXNTIK),LUINP,LUOUT,LUSTO,LUBAR,LUPAR
C
C     + + + VARIABLE DEFINITION + + +
C     IE(M,I)     - global node number of I-th node of the M-th element
C                   if I = 1 to 8, material type of the M0th element if
C                   I = 9
C     LRN(I,N)    - global node number of the I-th connecting node to
C                   the N-th node
C     NLRL(N)     - number of global elements connected to the N-th node
C     LRL(I,N)    - global element number of the I-th connecting element
C                   to the N-th node
C     NTNPLR(K)   - total number of node points in the K-th subregion
C                   = NNPLR(K) + intra-boundary nodes
C     NNPLR(K)    - number of node points in the K-th subregion
C     LMAXDF(K)   - maximum difference between eight nodes of any
C                   element
C     GNLR(I,K)   - global node number of the I-th node in the K-th
C                   subregion
C     LNOJCN((J,I,K) - local node number of the J-th compressed number
C                      connecting to the I-th local node in the K-th
C                      subregion
C     NPCNV(I)    - global node number of the I-th nonconvergent node
C     ISB(1,I)    - boundary node number of the first node of the I-th
C                   boundary side
C     ISB(2,I)    - boundary node number of the second node of the I-th
C                   boundary side
C     ISB(3,I)    - boundary node number of the third node of the I-th
C                   boundary side
C     ISB(4,I)    - boundary node number of the fourth node of the I-th
C                   boundary side
C     ISB(5,I)    - element side index of the I-th boundary side;
C                   1 = left side, 2 = front side, 3 = right side,
C                   4 = back side, 5 = bottom side, 6 = top side
C     ISB(6,I)    - global element number to which the I-th boundary
C                   side belong
C     NPBB(I)     - global node number of the I-th boundary node
C     ISTYP(MP)   - source/sink type assigned to the MP-th s/s element
C     LES(MP)     - global element number of the MP-th s/s element
C     IWTYP(NP)   - source/sink type assigned to the NP-th well node
C     NPW(NP)     - global node number of the NP-th s/s well node
C     ICTYP(MP)   - flux type assigned to the MP-th Cauchy side
C     ISC(1,MP)   - global node number of the first node of the MP-th
C                   Cauchy side
C     ISC(2,MP)   - global node number of the second node of the MP-th
C                   Cauchy side
C     ISC(3,MP)   - global node number of the third node of the MP-th
C                   Cauchy side
C     ISC(4,MP)   - global node number of the fourth node of the MP-th
C                   Cauchy side
C     ISC(5,MP)   - boundary side number of the MP-th Cauchy side
C     NPCB(MP)    - Global node number of the MP-th Cauchy node on input
C                   then is changed to contain boundary node number
C     INTYP(MP)   - flux type assigned to the MP-th Neuman side
C     ISN(1,MP)   - global node number of the first node of the MP-th
C                   Neuman side
C     ISN(2,MP)   - global node number of the second node of the MP-th
C                   Neuman side
C     ISN(3,MP)   - global node number of the third node of the MP-th
C                   Neuman side
C     ISN(4,MP)   - global node number of the fourth node of the MP-th
C                   Neuman side
C     ISN(5,MP)   - boundary node number of the MP-th Neuman side
C     NPNB(MP)    - global node number of the MP-th Neuman node on input
C                   then is changed to contain boundary node number
C     IRTYP(MP)   - type of rainfall profile assigned to MP-th VB side
C     ISV(1,MP)   - global node number of the first node of the MP-th
C                   variable boundary side
C     ISV(2,MP)   - global node number of the second node of the MP-th
C                   variable boundary side
C     ISV(3,MP)   - global node number of the third node of the MP-th
C                   variable boundary side
C     ISV(4,MP)   - global node number of the fourth node of the MP-th
C                   variable boundary side
C     ISV(5,MP)   - boundary node number of the MP-th VB side
C     NPVB(NP)    - global node number of NP-th VB node on input,
C                   then is changed to contain boundary node number
C     NPFLX(NP)   - flux boundary condition indicator of the NP-th
C                   VB node; 0 = this is not a flux-condition node for
C                   the present time step, global node number = this
C                   is a flux-condition node for the present time
C     NPCON(NP)   - ponding condition indicator of the NP-th VB node:
C                   0 = this is not a ponding-condition node for the
C                   present time step, global node number = this is
C                   a ponding-condition node for the present time
C     NPMIN(NP)   - minimum-pressure condition indicator of NP-th VB
C                   node; 0 = this is not a minimum-pressure-condition
C                   node for the present time step, global node number =
C                   this is a minimum-pressure-condition node for the
C                   present time step
C     IDTYP(NP)   - total head profile type assigned to NP-th
C                   Dirichlet node
C     NPDB(NP)    - global node number of the NP-th Dirichlet node.
C     KPR(I)      - line-printer control for the I-th time step
C                    0 = print nothing,
C                    1 = print system mass balance
C                    2 = print pressure head plus above
C                    3 = print total head plus above
C                    4 = print moisture content plus above
C                    5 = print Darcy velocity plus above
C     KDSK(I)     - auxilliary output control for the I-th time step;
C                    0 = no auxilliary output, 1 = auxilliary output
C     LUINP       - logical unit for input data
C     LUOUT       - logical unit for output data
C     LUSTO       - logical unit for store binary output
C     LUBAR       - logical unit for store binary boundary arrays
C     LUPAR       - logical unit for store binary pointer arrays
C
      DOUBLE PRECISION   X(MAXNPK),Y(MAXNPK),Z(MAXNPK),
     >                   CMATRX(MAXNPK,MXJBDK),RLD(MAXNPK),RI(MAXNPK),
     >                   RL(MAXNPK),CMTRXL(LMXNPK,LMXBWK),RLDL(LMXNPK),
     >                   H(MAXNPK),HP(MAXNPK),HW(MAXNPK),HT(MAXNPK),
     >                   VX(MAXNPK),VY(MAXNPK),VZ(MAXNPK),
     >                   TH(8,MAXELK),DTH(8,MAXELK),AKR(8,MAXELK),
     >                   DCOSB(3,MXBESK),BFLX(MXBNPK),BFLXP(MXBNPK),
     >                   SOS(MXSELK),SOSF(MXSDPK,MXSPRK),
     >                   TSOSF(MXSDPK,MXSPRK),WSS(MXWPRK),
     >                   WSSF(MXWDPK,MXWPRK),TWSSF(MXWDPK,MXWPRK),
     >                   QCB(MXCPRK),QCBF(MXCDPK,MXCPRK),
     >                   TQCBF(MXCDPK,MXCPRK),QNB(MXNPRK),
     >                   QNBF(MXNDPK,MXNPRK),TQNBF(MXNDPK,MXNPRK),
     >                   RFALL(MXVPRK),RF(MXVDPK,MXVPRK),
     >                   TRF(MXVDPK,MXVPRK),DCYFLX(MXVNPK),FLX(MXVNPK),
     >                   HCON(MXVNPK),HMIN(MXVNPK),HDB(MXDPRK),
     >                   HDBF(MXDDPK,MXDPRK),THDBF(MXDDPK,MXDPRK),
     >                   PROP(MXMPMK,MXMATK),THPROP(MXSPMK,MXMATK),
     >                   AKPROP(MXSPMK,MXMATK),CAPROP(MXSPMK,MXMATK),
     >                   HPROP(MXSPMK,MXMATK),TDTCH(MXDTCK)
C
C     + + + VARIABLE DEFINITION + + +
C     X(N)        - x-coordinate of the N-th node
C     Y(N)        - y-coordinate of the N-th node
C     Z(N)        - z-coordinate of the N-th node
C     CMATRX(N,I) - an array to store the assembled global matrix
C     RLD(N)      - an array to store the assembled global load vector
C     RI(N)       - pressure head iterate in BLKITR
C     RL(N)       - a working array to contain final solution of the
C                   pressure head in BLKITR
C     CMTRXL(N,I) - an array to store the assembled matrix for subregion
C     RLDL(N)     - an array to store the assembled load vector for
C                   a subregion
C     H(N)        - pressure head at the present time
C     HW(N)       - nonlinear pressure head iterate at the N-th node
C     HT(N)       - total head at the N-th node
C     VX(N)       - x-component of Darcy velocity
C     VY(N)       - y-component of Darcy velocity
C     VZ(N)       - z-component of Darcy velocity
C     HP(N)       - previous-time pressure head at the N-th node
C     TH(I,M)     - moisture content at the I-th node of M-th element
C     DTH(I,M)    - water capacity at the I-th node of the M-th element
C     AKR(I,M)    - relative conductivity at I-th node of M-th element
C     DCOSB(1,I)  - directional cosine of the I-th boundary side with x
C     DCOSB(2,I)  - directional cosine of the I-th boundary side with y
C     DCOSB(3,I)  - directional cosine of the I-th boundary side with z
C     BFLX(I)     - present time flux at the I-th boundary node
C     BFLXP(I)    - previous time flux at the I-th boundary node
C     SOS(J)      - value of J-th element source/sink at present time
C     SOSF(I,J)   - s/s rate of the I-th data point in the J-th profile
C     TSOSF(I,J)  - time of the I-th data point in the J-th profile
C     WSS(J)      - value of the J-th well source/sink at present time
C     WSSF(I,J)   - s/s rate of the I-th data point in the J-th profile
C     TWSSF(I,J)  - time of the I-th data point in the J-th profile
C     QCB(J)      - Cauchy flux of the J-th profile at the present time
C     QCBF(I,J)   - Cauchy flux of the I-th data point in J-th profile
C     TQCBF(I,J)  - time of the I-th data point in J-th Cauchy profile
C     QNB(J)      - Neuman flux of the J-th profile at the present time
C     QNBF(I,J)   - Neuman flux of the I-th data point in J-th profile
C     TQNBF(I,J)  - time of the I-th data point in J-th Neuman profile
C     RFALL(J)    - rainfall rate of J-th profile at the present time
C     RF(I,J)     - rainfall rate of I-th data point in J-th profile
C     TRF(I,J)    - time of the I-th data point in J-th rainfall profile
C     DCYFLX(NP)  - Darcy flux through the NP-th variable boundary node
C     FLX(NP)     - rainfall flux through the NP-th VB node
C     HCON(NP)    - ponding depth of the NP-th variable boundary node
C     HMIN(NP)    - minimum pressure allowed for the NP-th VB node
C     HDB(J)      - total head of the J-th profile at the present time
C     HDBF(I,J)   - total head of the I-th data point in J-th profile
C     THDBF(I,J)  - time of the I-th data point in J-th head profile
C     PROP(I,J)   - I-th material property of the J-th material;
C                     I = 1 = saturated xx-hydraulic conductivity
C                     I = 2 = saturated yy-hydraulic conductivity
C                     I = 3 = saturated zz-hydraulic conductivity
C                     I = 4 = saturated xy-hydraulic conductivity
C                     I = 5 = saturated xz-hydraulic conductivity
C                     I = 6 = saturated yz-hydraulic conductivity
C     THPROP(I,J) - I-th parameter to describe the moisture content as
C                   function of pressure head for the J-th material or
C                   I-th data point of moisture content for the J-th
C                   material.
C     AKPROP(I,J) - I-th parameter to describe the relative
C                   conductivity as function of pressure head for the
C                   J-th material or I-th data point of relative
C                   conductivity for the J-th material
C     CAPROP(I,J) - I-th data point of water capacity for the J-th
C                   material
C     HPROP(I,J)  - I-th data point of pressure for the J-th material
C     TDTCH(I)    - time of the I-th time to reset time step size to
C                   initial time step size.
C
      CHARACTER*1        ANS
      CHARACTER*26       VERNUM
      CHARACTER*80       DATAFL,OUTFL,STORFL,BNDARFL,PNTARFL
C
C     + + + EXTERNALS + + +
      EXTERNAL   GW3D, CLRSCR
C
C     + + + END SPECIFICATIONS + + +
C
      ANS    = ' '
      VERNUM = ' Version 1.00 / July 1993 '
      MAXNP  = MAXNPK
      MAXEL  = MAXELK
      MAXBNP = MXBNPK
      MAXBES = MXBESK
      MXJBD  = MXJBDK
      MXKBD  = MXKBDK
      MAXNTI = MXNTIK
      MXNDTC = MXDTCK
      LTMXNP = LTMXNK
      LMXNP  = LMXNPK
      LMXBW  = LMXBWK
      MXREGN = MXRGNK
      MXSEL  = MXSELK
      MXSPR  = MXSPRK
      MXSDP  = MXSDPK
      MXWNP  = MXWNPK
      MXWPR  = MXWPRK
      MXWDP  = MXWDPK
      MXCNP  = MXCNPK
      MXCES  = MXCESK
      MXCPR  = MXCPRK
      MXCDP  = MXCDPK
      MXNNP  = MXNNPK
      MXNES  = MXNESK
      MXNPR  = MXNPRK
      MXNDP  = MXNDPK
      MXVNP  = MXVNPK
      MXVES  = MXVESK
      MXRPR  = MXVPRK
      MXRDP  = MXVDPK
      MXDNP  = MXDNPK
      MXDPR  = MXDPRK
      MXDDP  = MXDDPK
      MAXMAT = MXMATK
      MXSPPM = MXSPMK
      MXMPPM = MXMPMK
C
C     unit numbers for file units
      LUINP  = 15
      LUOUT  = 16
      LUSTO  = 11
      LUBAR  = 13
      LUPAR  = 14
C
      CALL CLRSCR
      INCLUDE 'ANNOUN.INC'
      CALL CLRSCR
      WRITE (*,10)
   10 FORMAT(//,1X,'FEMWATER Program')
      WRITE (*,12)
   12 FORMAT(1X,'Run-time Input Parameter Screen')
      WRITE (*,14)
   14 FORMAT(1X,'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~',/)
C
C     query names of required files
CNDP
      WRITE(*,100)
  100 FORMAT(/,' Type input data file name, then press <Enter> key: ',$)
CNDP
CPC      PRINT *,' Type input data file name, then press <Enter> key: ',$
C
      READ(*,'(A80)') DATAFL
C
CNDP
      WRITE(*,200)
  200 FORMAT(/,' Type output file name, then press <Enter> key: ',$)
CNDP
CPC      PRINT *,' Type output file name, then press <Enter> key: '
      READ(*,'(A80)') OUTFL
C
CNDP
      WRITE(*,300)
  300 FORMAT(/,' Type output storage file name, then press <Enter> key: 
     1',$)
CNDP
CPC      PRINT *,' Type output storage file name, then press <Enter> key: '
      READ(*,'(A80)') STORFL
C
CNDP
      WRITE(*,400)
  400 FORMAT(/,' Type output boundary array file name, then press <Enter
     1> key: ',$)
CNDP
CPC      PRINT *,' Type output boundary array file name, then press <Enter>
CPC     1 key: '
      READ(*,'(A80)') BNDARFL
C
CNDP
      WRITE(*,500)
  500 FORMAT(/,' Type output pointer array file name, then press <Enter>
     1 key: ',$)
CNDP
CPC      PRINT *,' Type output pointer array file name, then press <Enter>
CPC     1key: '
      READ(*,'(A80)') PNTARFL
C
      CALL CLRSCR
      WRITE (*,16)
   16 FORMAT(///////////,1X,
     1 '                       Executing FEMWATER program...wait.')
C
C     query names of required files
C      PRINT *,' PLEASE INPUT YOUR INPUT DATA FILE NAME.'
C      READ(*,'(A80)') DATAFL
C      PRINT *,' THEN, YOUR OUTPUT FILE NAME.'
C      READ(*,'(A80)') OUTFL
C      PRINT *,' THEN, YOUR STORAGE FILE NAME.'
C      READ(*,'(A80)') STORFL
C      PRINT *,' THEN, YOUR BOUNDARY ARRAY FILE NAME.'
C      READ(*,'(A80)') BNDARFL
C      PRINT *,' THEN, YOUR POINTER ARRAY FILE NAME.'
C      READ(*,'(A80)') PNTARFL
C
C     open required files
      OPEN(UNIT=LUINP,FILE=DATAFL,STATUS='UNKNOWN',ACCESS='SEQUENTIAL',
     1                FORM='FORMATTED',CARRIAGECONTROL='LIST')
      OPEN(UNIT=LUOUT,FILE=OUTFL,STATUS='UNKNOWN')
      OPEN(UNIT=LUSTO,FILE=STORFL,FORM='UNFORMATTED',STATUS='UNKNOWN')
      OPEN(UNIT=LUBAR,FILE=BNDARFL,FORM='UNFORMATTED',STATUS='UNKNOWN')
      OPEN(UNIT=LUPAR,FILE=PNTARFL,FORM='UNFORMATTED',STATUS='UNKNOWN')
C      OPEN(UNIT=22,FILE='DEBUG.OUT',FORM='FORMATTED',STATUS='UNKNOWN')
C
C     pass the program to GW3d
      CALL GW3D
     I         (LUINP,LUOUT,LUSTO,LUBAR,LUPAR,
     M          X,Y,Z,IE,CMATRX,LRN,RLD,RI,RL,HP,HW,HT,TH,DTH,AKR,NPCNV,
     M          DCOSB,ISB,NPBB,BFLX,BFLXP, SOS,SOSF,TSOSF,ISTYP,LES,
     M          WSS,WSSF,TWSSF,IWTYP,NPW, QCB,QCBF,TQCBF,ICTYP,ISC,NPCB,
     M          QNB,QNBF,TQNBF,INTYP,ISN,NPNB, RFALL,RF,TRF,IRTYP,ISV,
     M          NPVB,DCYFLX,FLX,HCON,HMIN,NPFLX,NPCON,NPMIN,
     M          HDB,HDBF,THDBF,IDTYP,NPDB,
     M          PROP,THPROP,AKPROP,CAPROP,HPROP, KPR,KDSK,TDTCH,
     M          NTNPLR,NNPLR,LMAXDF,GNLR,LNOJCN,CMTRXL,RLDL,LRL,NLRL,
     O          H,VX,VY,VZ)
C
      CALL CLRSCR
      WRITE (*,18)
   18 FORMAT(///////////,1X,
     1 '                           FEMWATER program complete.')
C
      CLOSE(UNIT=LUINP)
      CLOSE(UNIT=LUOUT)
      CLOSE(UNIT=LUSTO)
      CLOSE(UNIT=LUBAR)
      CLOSE(UNIT=LUPAR)
C      CLOSE(UNIT=22)
C
      STOP
      END
