      SUBROUTINE   Q8TH
     I                 (DHQ,THG,XQ,YQ,ZQ,SOURCE,
     O                  QTHM,QSOSM)
C
C     + + + PURPOSE + + +
C     To evaluate the integration of moisture content and source/sink
C     over an element
C
C     + + + DUMMY ARGUMENTS + + +
      DOUBLE PRECISION DHQ(8),THG(8),XQ(8),YQ(8),ZQ(8),SOURCE,
     >                 QTHM,QSOSM
C
C     + + + ARGUMENT DEFINITIONS + + +
C     DHQ    - Pressure difference between the present time step and
C              the previous time step at eight nodes of the element
C     THG    - Moisture content at eight Gaussian point of the element
C     XQ     - x-coordinate at eight nodes of the element
C     YQ     - y-coordinate at eight nodes of the element
C     ZQ     - z-coordinate at eight nodes of the element
C     SOURCE - element source/sink strength
C     QTHM   - integration of DHQ*THG
C     QSOSM  - integration of SOURCE
C
C     + + + LOCAL VARIABLES
      INTEGER            I,J,IQ,KG
      DOUBLE PRECISION   P,SS,TT,UU,SM,SP,TM,TP,UM,UP,DJAC,DHQP,THQP,
     >                   S(8),T(8),U(8),N(8),PJAB(3,3),DNSS(8),DNTT(8),
     >                   DNUU(8)
C
C     + + + DATA INITIALIZATIONS + + +
      DATA P / 0.577350269189626D0/
      DATA S/-1.0D0,1.0D0,1.0D0,-1.0D0, -1.0D0,1.0D0,1.0D0,-1.0D0/
      DATA T/-1.0D0,-1.0D0,1.0D0,1.0D0, -1.0D0,-1.0D0,1.0D0,1.0D0/
      DATA U/-1.0D0,-1.0D0,-1.0D0,-1.0D0, 1.0D0,1.0D0,1.0D0,1.0D0/
C
C     + + + END SPECIFICATIONS + + +
C
      QSOSM = 0.0
      QTHM  = 0.0
C
C     *** Perform integration with Gaussian quadrature
C
      DO 490 KG = 1,8
C
C       determine local coordinate at the Gaussian point KG
        SS = P*S(KG)
        TT = P*T(KG)
        UU = P*U(KG)
C
C       compute some grouped variables
        SM = 1.0D0 - SS
        SP = 1.0D0 + SS
        TM = 1.0D0 - TT
        TP = 1.0D0 + TT
        UM = 1.0D0 - UU
        UP = 1.0D0 + UU
C
C       Compute base functions
C
        N(1) = 0.125D0*SM*TM*UM
        N(2) = 0.125D0*SP*TM*UM
        N(3) = 0.125D0*SP*TP*UM
        N(4) = 0.125D0*SM*TP*UM
        N(5) = 0.125D0*SM*TM*UP
        N(6) = 0.125D0*SP*TM*UP
        N(7) = 0.125D0*SP*TP*UP
        N(8) = 0.125D0*SM*TP*UP
C
C       compute partial derivatives of base functions with respect to
C       local coordiante xsi
        DNSS(1) = -0.125D0*TM*UM
        DNSS(2) =  0.125D0*TM*UM
        DNSS(3) =  0.125D0*TP*UM
        DNSS(4) = -0.125D0*TP*UM
        DNSS(5) = -0.125D0*TM*UP
        DNSS(6) =  0.125D0*TM*UP
        DNSS(7) =  0.125D0*TP*UP
        DNSS(8) = -0.125D0*TP*UP
C
C       compute partial derivatives of base functions with respect to
C       local coordiante eta
        DNTT(1) = -0.125D0*SM*UM
        DNTT(2) = -0.125D0*SP*UM
        DNTT(3) =  0.125D0*SP*UM
        DNTT(4) =  0.125D0*SM*UM
        DNTT(5) = -0.125D0*SM*UP
        DNTT(6) = -0.125D0*SP*UP
        DNTT(7) =  0.125D0*SP*UP
        DNTT(8) =  0.125D0*SM*UP
C
C       compute partial derivatives of base functions with respect to
C       local coordiante zeta
        DNUU(1) = -0.125D0*SM*TM
        DNUU(2) = -0.125D0*SP*TM
        DNUU(3) = -0.125D0*SP*TP
        DNUU(4) = -0.125D0*SM*TP
        DNUU(5) =  0.125D0*SM*TM
        DNUU(6) =  0.125D0*SP*TM
        DNUU(7) =  0.125D0*SP*TP
        DNUU(8) =  0.125D0*SM*TP
C
C       initialize the Jacobian
        DO 215 J = 1,3
          DO 210 I = 1,3
            PJAB(I,J) = 0.0
 210      CONTINUE
 215    CONTINUE
C
C       compute the Jacobian
        DO 220 I = 1,8
          PJAB(1,1) = PJAB(1,1) + XQ(I)*DNSS(I)
          PJAB(1,2) = PJAB(1,2) + YQ(I)*DNSS(I)
          PJAB(1,3) = PJAB(1,3) + ZQ(I)*DNSS(I)
          PJAB(2,1) = PJAB(2,1) + XQ(I)*DNTT(I)
          PJAB(2,2) = PJAB(2,2) + YQ(I)*DNTT(I)
          PJAB(2,3) = PJAB(2,3) + ZQ(I)*DNTT(I)
          PJAB(3,1) = PJAB(3,1) + XQ(I)*DNUU(I)
          PJAB(3,2) = PJAB(3,2) + YQ(I)*DNUU(I)
          PJAB(3,3) = PJAB(3,3) + ZQ(I)*DNUU(I)
  220   CONTINUE
C
C       compute the determinant of the Jacobian
        DJAC = PJAB(1,1)*(PJAB(2,2)*PJAB(3,3) - PJAB(2,3)*PJAB(3,2)) -
     >         PJAB(1,2)*(PJAB(2,1)*PJAB(3,3) - PJAB(2,3)*PJAB(3,1)) +
     >         PJAB(1,3)*(PJAB(2,1)*PJAB(3,2) - PJAB(2,2)*PJAB(3,1))
C
C       compute the pressure difference at the Gaussian point
        DHQP = 0.0
        DO 390 IQ = 1,8
          DHQP = DHQP + DHQ(IQ)*N(IQ)
  390   CONTINUE
C
C       sum the contribution to the integration due to the KG-th
C       Gaussian point
C
        THQP  = DHQP*THG(KG)
        QSOSM = QSOSM + SOURCE*DJAC
        QTHM  = QTHM + THQP*DJAC
  490 CONTINUE
C
      RETURN
      END
