      SUBROUTINE   READN
     I                  (LUINP,LUOUT,MXTYP,NTYPE,
     O                   INDTYP)
C
C     + + + PURPOSE + + +
C     To automatically generate integer input
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER   LUINP,LUOUT,MXTYP,NTYPE
      INTEGER   INDTYP(MXTYP)
C
C     + + + ARGUMENT DEFINITIONS + + +
C     LUINP  - Logical unit for input
C     LUOUT  - Logical unit for line print
C     MXTYP  - maximum number of integers allowed to be read
C     NTYPE  - number of integers to be read
C     INDTYP - array of integers that are to be read or
C              generated automatically
C
C     + + + LOCAL VARIABLES + + +
      INTEGER   NTYPES,DONFG,NI,NSEQ,NAD,NITYP,NTYPAD,NJ,N,I
C
C     + + + OUTPUT FORMATS + + +
 2000 FORMAT(///,' **** ERROR IN READN: NTYPES .NE. NTYPE',/,
     >           ' ****                 ',I6,'     ',I5,/,
     >           ' **** FATAL ERROR, MUST STOP')
 2010 FORMAT(///,' **** ERROR IN READN: NTYPE .GT. MXTYP',/,
     >           ' ****                ',I6,'      ',I5,/,
     >           ' **** FATAL ERROR, MUST STOP')
C
C     + + + END SPECIFICATIONS + + +
C
      NTYPES = 0
      DONFG  = 0
C
  110 CONTINUE
        READ(LUINP,*) NI,NSEQ,NAD,NITYP,NTYPAD
        IF (NI .GT. 0) THEN
C         automatically generate integer input
          NJ = NI + NSEQ
          DO 120 N = NI,NJ
            I         = NI + (N - NI)*NAD
            INDTYP(I) = NITYP + (N - NI)* NTYPAD
            NTYPES    = NTYPES + 1
  120     CONTINUE
        ELSE
C         complete input
          DONFG = 1
        END IF
      IF (DONFG .EQ. 0) THEN
        GO TO 110
      END IF
C
C     look for for errors
      IF (NTYPES .NE. NTYPE) THEN
C       number of data points read is not the same as those to be read
        WRITE (LUOUT,2000) NTYPES,NTYPE
        STOP
      ELSE IF (NTYPE .GT. MXTYP) THEN
C       number of data points to be read is greater than the maximum
C       allowed
        WRITE (LUOUT,2010) NTYPE,MXTYP
        STOP
      END IF
C
      RETURN
      END
