      SUBROUTINE   SFLOW
     I                  (X,Y,Z,IE,H,HP,VX,VY,VZ,TH,DTH,DCOSB,
     I                   ISB,NPBB,LES,SOS,ISTYP,WSS,IWTYP,
     I                   NPVB,NPDB,NPCB,NPNB,DELT,KFLOW,
     M                   BFLX,BFLXP)
C
C     + + + PURPOSE + + +
C     To compute water fluxes, incremental flow, and accumulated flow
C     through all types of boundaries, and change of water stored in
C     the region of interest.
C
C     + + + COMMON BLOCKS + + +
      INCLUDE 'CSGEOM.INC'
      INCLUDE 'CGEOM.INC'
      INCLUDE 'CS.INC'
      INCLUDE 'CW.INC'
      INCLUDE 'CCBC.INC'
      INCLUDE 'CNBC.INC'
      INCLUDE 'CVBC.INC'
      INCLUDE 'CDBC.INC'
      INCLUDE 'CFLOW.INC'
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER            IE(MAXEL,9),ISB(6,MAXBES),NPBB(MAXBNP),
     >                   LES(MXSEL),ISTYP(MAXEL),IWTYP(MXWNP),
     >                   NPVB(MXVNP),NPDB(MXDNP),NPCB(MXCNP),
     >                   NPNB(MXNNP),KFLOW
      DOUBLE PRECISION   X(MAXNP),Y(MAXNP),Z(MAXNP),H(MAXNP),
     >                   HP(MAXNP),VX(MAXNP),VY(MAXNP),VZ(MAXNP),
     >                   TH(8,MAXEL),DTH(8,MAXEL),BFLX(MAXBNP),
     >                   BFLXP(MAXBNP),DCOSB(3,MAXBES),SOS(MXSPR),
     >                   WSS(MXWPR),DELT
C
C     + + + ARGUMENT DEFINITIONS + + +
C     X(N)        - x-coordinate of the N-th node
C     Y(N)        - y-coordinate of the N-th node
C     Z(N)        - z-coordinate of the N-th node
C     IE(M,I)     - global node number of I-th node of the M-th element
C                   if I = 1 to 8, material type of the M0th element if
C                   I = 9
C     H(N)        - pressure head at the present time
C     HP(N)       - previous-time pressure heat at the N-th node
C     VX(N)       - x-component of Darcy velocity
C     VY(N)       - y-component of Darcy velocity
C     VZ(N)       - z-component of Darcy velocity
C     TH(I,M)     - moisture content at the I-th node of M-th element
C     DTH(I,M)    - water capacity at the I-th node of the M-th element
C     DCOSB(1,I)  - directional cosine of the I-th boundary side with x
C     DCOSB(2,I)  - directional cosine of the I-th boundary side with y
C     DCOSB(3,I)  - directional cosine of the I-th boundary side with z
C     ISB(1,I)    - boundary node number of the first node of the I-th
C                   boundary side
C     ISB(2,I)    - boundary node number of the second node of the I-th
C                   boundary side
C     ISB(3,I)    - boundary node number of the third node of the I-th
C                   boundary side
C     ISB(4,I)    - boundary node number of the fourth node of the I-th
C                   boundary side
C     ISB(5,I)    - element side index of the I-th boundary side;
C                   1 = left side, 2 = front side, 3 = right side,
C                   4 = back side, 5 = bottom side, 6 = top side
C     ISB(6,I)    - global element number to which the I-th boundary
C                   side belong
C     NPBB(I)     - global node number of the I-th boundary node
C
C     LES(MP)     - global element number of the MP-th s/s element
C     SOS(J)      - value of J-th element source/sink at present time
C     ISTYP(MP)   - source/sink type assigned to the MP-th s/s element
C     WSS(J)      - value of the J-th well source/sink at present time
C     IWTYP(NP)   - source/sink type assigned to the NP-th well node
C
C     NPVB(NP)    - boundary node number of the NP-th VB node
C     NPDB(NP)    - global node number of the NP-th Dirichlet node.
C     NPCB(NP)    - boundary node number of the NP-th Cauchy node
C     NPNB(NP)    - boundary node number of the NP-th Neuman node
C
C     DELT        - time step size
C     KFLOW       - system flow counter
C     BFLX(I)     - present time flux at the I-th boundary node
C     BFLXP(I)    - previous time flux at the I-th boundary node
C
C     + + + LOCAL VARIABLES + + +
      INTEGER            NP,MP,LS,M,IQ,I,NI,NII,NPP,IJ,MS,ITYP
      DOUBLE PRECISION   QSOS,SUM,SUMP,SUMS,SUMSP,SUMR,SUMRP,BFLXA,
     >                   QSOSP,QTH,SOURCE,QTHM,QSOSM,XQ(8),YQ(8),ZQ(8),
     >                   DHQ(8),THG(8),R1Q(4),R2Q(4),XXQ(4),YYQ(4),
     >                   ZZQ(4),F1Q(4),F2Q(4),KGB(4,6)
C
C     + + + EXTERNALS + + +
      EXTERNAL   Q4S,Q8TH
C
C     + + + DATA INITIALIZATIONS + + +
      DATA KGB/1,4,8,5, 1,2,6,5, 2,3,7,6, 4,3,7,8, 1,2,3,4, 5,6,7,8/
      DATA QSOS/0.0D0/
C
C     + + + END SPECIFICATIONS + + +
C
      DO 110 NP = 1,NBNP
C       put new flux into array bflxp
        BFLXP(NP) = BFLX(NP)
        BFLX(NP)  = 0.0
  110 CONTINUE
C
C     *** Calculate volumetric flow rate through all boundary nodes
C
      DO 170 MP = 1,NBES
        LS = ISB(5,MP)
        M  = ISB(6,MP)
C       put global variables into local variables
        DO 120 IQ = 1,4
          I       = KGB(IQ,LS)
          NI      = IE(M,I)
          XXQ(IQ) = X(NI)
          YYQ(IQ) = Y(NI)
          ZZQ(IQ) = Z(NI)
          F1Q(IQ) = DCOSB(1,MP)*VX(NI) + DCOSB(2,MP)*VY(NI) +
     >              DCOSB(3,MP)*VZ(NI)
          F2Q(IQ) = 0.0
  120   CONTINUE
C
C       compute surface integral
        CALL Q4S
     I          (XXQ,YYQ,ZZQ,F1Q,F2Q,
     O           R1Q,R2Q)
C
C       sum over the contribution from all four nodes of the surface
        DO 140 IQ = 1,4
          NII       = ISB(IQ,MP)
          BFLX(NII) = BFLX(NII) + R1Q(IQ)
  140   CONTINUE
  170 CONTINUE
C
      IF (KFLOW .LE. 0) THEN
C       for the case of steady state
        DO 180 NP = 1,NBNP
          BFLXP(NP) = BFLX(NP)
  180   CONTINUE
C       initiate the total flow to zero
        DO 190 I = 1,9
          TFLOW(I) = 0.0
  190   CONTINUE
      END IF
C
C     *** Determine total flow and total flow rates through various
C     *** types of boundaries, starting with the net flow through the
C     *** entire boundary
C
      SUM  = 0.
      SUMP = 0.
      DO 210 NP = 1,NBNP
        SUM  = SUM + BFLX(NP)
        SUMP = SUMP + BFLXP(NP)
  210 CONTINUE
      FRATE(7) = SUM
      FLOW(7)  = 0.5D0*(SUM + SUMP)*DELT
C
C     *** Through the Dirichlet boundary
C
      FRATE(1) = 0.
      FLOW(1)  = 0.
      IF (NDNP .GT. 0) THEN
        SUM  = 0.
        SUMP = 0.
C
        DO 330 NPP = 1,NDNP
          NP = NPDB(NPP)
          I  = 0
  310     CONTINUE
            I  = I + 1
            IJ = NPBB(I)
          IF (IJ .NE. NP .AND. I .LT. NBNP) THEN
            GO TO 310
          END IF
          NII  = I
          SUM  = SUM + BFLX(NII)
          SUMP = SUMP + BFLXP(NII)
  330   CONTINUE
        FRATE(1) = SUM
        FLOW(1)  = 0.5D0*(SUM + SUMP)*DELT
      END IF
C
C     *** Through Cauchy boundary
C
      FRATE(2) = 0.0
      FLOW(2)  = 0.0
      IF (NCNP .GT. 0) THEN
        SUM  = 0.0
        SUMP = 0.0
C
        DO 430 NPP = 1,NCNP
          NII  = NPCB(NPP)
          SUM  = SUM + BFLX(NII)
          SUMP = SUMP + BFLXP(NII)
  430   CONTINUE
        FRATE(2) = SUM
        FLOW(2)  = 0.5D0*(SUM + SUMP)*DELT
      END IF
C
C     *** Through Neuman boundary
C
      FRATE(3) = 0.
      FLOW(3)  = 0.
      IF (NNNP .GT. 0) THEN
        SUM  = 0.
        SUMP = 0.
C
        DO 530 NPP = 1,NNNP
          NII  = NPNB(NPP)
          SUM  = SUM + BFLX(NII)
          SUMP = SUMP + BFLXP(NII)
  530   CONTINUE
        FRATE(3) = SUM
        FLOW(3)  = 0.5D0*(SUM + SUMP)*DELT
      END IF
C
C     *** Through rainfall-seepage-evaporation boundary
C
      FRATE(4) = 0.
      FLOW(4)  = 0.
      FRATE(5) = 0.
      FLOW(5)  = 0.
      IF (NVNP .GT. 0) THEN
        SUMS  = 0.
        SUMSP = 0.
        SUMR  = 0.
        SUMRP = 0.
C
        DO 640 NPP = 1,NVNP
          NII   = NPVB(NPP)
          BFLXA = BFLX(NII)
          IF (BFLXA .GE. 0.D0) THEN
C
            SUMS  = SUMS + BFLX(NII)
            SUMSP = SUMSP + BFLXP(NII)
          ELSE
C
            SUMR  = SUMR + BFLX(NII)
            SUMRP = SUMRP + BFLXP(NII)
          END IF
  640   CONTINUE
        FRATE(4) = SUMS
        FLOW(4)  = 0.5D0*(SUMS + SUMSP)*DELT
        FRATE(5) = SUMR
        FLOW(5)  = 0.5D0*(SUMR + SUMRP)*DELT
      END IF
C
C     *** Through unspecified boundary, i.e., boundary with zero flux
C
      SUM  = 0.
      SUMP = 0.
C
      DO 710 I = 1,5
        SUM  = SUM + FRATE(I)
        SUMP = SUMP + FLOW(I)
  710 CONTINUE
      FRATE(6) = FRATE(7) - SUM
      FLOW(6)  = FLOW(7) - SUMP
C
C     *** Compute the increase in water content and source/sink
C
      QSOSP = QSOS
      QSOS  = 0.0
      QTH   = 0.
C
      DO 850 M = 1,NEL
        SOURCE = 0.0
        IF (NSEL .NE. 0) THEN
C
          MP = 0
  810     CONTINUE
            MP = MP + 1
            MS = LES(MP)
          IF (MS .NE. M .AND. MP .LT. NSEL) THEN
            GO TO 810
          END IF
          ITYP   = ISTYP(MP)
          SOURCE = SOS(ITYP)
        END IF
C
C
        DO 840 IQ = 1,8
          NP      = IE(M,IQ)
          XQ(IQ)  = X(NP)
          YQ(IQ)  = Y(NP)
          ZQ(IQ)  = Z(NP)
          DHQ(IQ) = H(NP) - HP(NP)
          IF (KFLOW .LE. 0) THEN
C
            DHQ(IQ) = 1.0D0
          END IF
          THG(IQ) = TH(IQ,M)
          IF (KFLOW .GT. 0) THEN
C
            THG(IQ) = DTH(IQ,M)
          END IF
  840   CONTINUE
C
C       compute element integration
        CALL Q8TH
     I           (DHQ,THG,XQ,YQ,ZQ,SOURCE,
     O            QTHM,QSOSM)
C
        QSOS = QSOS - QSOSM
        QTH  = QTH + QTHM
  850 CONTINUE
C
      IF (NWNP .NE. 0) THEN
C       incorporate well source/sink
        DO 860 I = 1,NWNP
          ITYP = IWTYP(I)
          QSOS = QSOS - WSS(ITYP)
  860   CONTINUE
      END IF
C
      IF (KFLOW .LE. 0) THEN
        QSOSP = QSOS
      END IF
C
      FRATE(8) = QSOS
      FLOW(8)  = 0.5D0*(QSOS + QSOSP)*DELT
      FLOW(9)  = QTH
      FRATE(9) = FLOW(9)/DELT
      IF (KFLOW .LE. 0) THEN
        FRATE(9) = -(FRATE(7) + FRATE(8))
      END IF
      DO 910 I = 1,9
        TFLOW(I) = TFLOW(I) + FLOW(I)
  910 CONTINUE
C
      RETURN
      END
