      SUBROUTINE   SPROP
     I                  (MAXEL,MAXNP,MXSPPM,MAXMAT,NEL,NSPPM,
     I                   IE,H,THPROP,AKPROP,CAPROP,HPROP,KSP,
     O                   TH,DTH,AKR)
C
C     + + + PURPOSE + + +
C     To compute the moisture content, relative hydraulic conductivity,
C     and water capacity as functions of pressure head.
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER            MAXEL,MAXNP,MXSPPM,MAXMAT,NEL,NSPPM
      INTEGER            IE(MAXEL,9),KSP
      DOUBLE PRECISION   H(MAXNP),THPROP(MXSPPM,MAXMAT),
     >                   AKPROP(MXSPPM,MAXMAT),CAPROP(MXSPPM,MAXMAT),
     >                   HPROP(MXSPPM,MAXMAT),TH(8,MAXEL),DTH(8,MAXEL),
     >                   AKR(8,MAXEL)
C
C     + + + ARGUMENT DEFINITIONS + + +
C     MAXEL  - Maximum number of elements
C     MAXNP  - Maximum number of nodal points
C     MXSPPM - Maximum number of soil parameters per material
C     MAXMAT - Maximum number of materials
C     NEL    - Number of elements
C     NSPPM  - Number of soil paramters per material
C     IE     - Incidence of elements
C     H      - Pressure head
C     THPROP - Tabulate values of moisture content or
C              parameters used to compute moisture content.
C     AKPROP - Tabulate values of relative conductivity or
C              parameters used to compute relative conductivity
C     CAPROP - Tabulate values of water capacity
C     HPROP  - Tabulate values of pressure head
C     KSP    - Soil property computation indicator
C     TH     - Moisture content
C     DTH    - Water capacity
C     AKR    - Relative hydraulic conductivity
C
C     + + + LOCAL VARIABLES + + +
      INTEGER            M,IQ,NP,KG,MTYP,JL,JU,J
      DOUBLE PRECISION   P,SS,TT,UU,SM,SP,TM,TP,UM,UP,HNP,A,
     >                   WCR,WCS,HAA,THMKG,HAB,
     >                   ALPHA,BETA,DNOM,
     >                   N(8),HQ(8),S(8),T(8),U(8),HKG(8)
C
C     + + + DATA INITIALIZATIONS + + +
      DATA P/0.577350269189626/
      DATA S/-1.0D0, 1.0D0, 1.0D0,-1.0D0,-1.0D0, 1.0D0, 1.0D0,-1.0D0/
      DATA T/-1.0D0,-1.0D0, 1.0D0, 1.0D0,-1.0D0,-1.0D0, 1.0D0, 1.0D0/
      DATA U/-1.0D0,-1.0D0,-1.0D0,-1.0D0, 1.0D0, 1.0D0, 1.0D0, 1.0D0/
C
C     + + + END SPECIFICATIONS + + +
C
      DO 900 M = 1,NEL
C
        DO 110 IQ = 1,8
          NP     = IE(M,IQ)
          HQ(IQ) = H(NP)
 110    CONTINUE
C
C       ****  Evaluate pressure at eight Gaussian points
C
        DO 150 KG = 1,8
C         compute the local coordinate at Gaussian point KG
          SS = P*S(KG)
          TT = P*T(KG)
          UU = P*U(KG)
C         compute some grouped variables
          SM  = 1.0D0-SS
          SP  = 1.0D0+SS
          TM  = 1.0D0-TT
          TP  = 1.0D0+TT
          UM  = 1.0D0-UU
          UP  = 1.0D0+UU
C         compute base functions
          N(1) = 0.125D0*SM*TM*UM
          N(2) = 0.125D0*SP*TM*UM
          N(3) = 0.125D0*SP*TP*UM
          N(4) = 0.125D0*SM*TP*UM
          N(5) = 0.125D0*SM*TM*UP
          N(6) = 0.125D0*SP*TM*UP
          N(7) = 0.125D0*SP*TP*UP
          N(8) = 0.125D0*SM*TP*UP
C         obtain pressre head at the Gaussian point by interpolation
          HKG(KG) = 0.0
          DO 120 IQ = 1,8
            HKG(KG) = HKG(KG) + HQ(IQ)*N(IQ)
  120     CONTINUE
  150   CONTINUE
C
        MTYP = IE(M,9)
        IF (KSP .NE. 0) THEN
C
C         ******* Compute TH, DTH/DH, and AKR by tabulate interpolation
C
          DO 500 KG = 1,8
            HNP = HKG(KG)
            IF (HNP .LE. HPROP(1,MTYP)) THEN
C             for the case when the pressure is less than the
C             minimum tabulet value
              JL = 1
              JU = 2
              A  = 0.0
            ELSE IF (HNP .GE. HPROP(NSPPM,MTYP)) THEN
C             for the case when the pressure is greater than the
C             maximum tabulet value
              JL = NSPPM
              JU = 1
              A  = 0.0
            ELSE
C             for the case when pressure lies between tabulet values
              J = 1
  300         CONTINUE
                J = J+ 1
              IF (HPROP(J,MTYP).LE.HNP .AND. J.LT.NSPPM) GO TO 300
              JU = J
              JL = JU - 1
              A  = (HNP-HPROP(JL,MTYP))/(HPROP(JU,MTYP)-HPROP(JL,MTYP))
            END IF
C           merge three cases and perform interpolation
            TH(KG,M) = THPROP(JL,MTYP) +
     >                 A*(THPROP(JU,MTYP) - THPROP(JL,MTYP))
            DTH(KG,M)= CAPROP(JL,MTYP) +
     >                 A*(CAPROP(JU,MTYP) - CAPROP(JL,MTYP))
            AKR(KG,M)= AKPROP(JL,MTYP) +
     >                 A*(AKPROP(JU,MTYP) - AKPROP(JL,MTYP))
  500     CONTINUE
C
        ELSE
C
C         ******* Compute TH, DTH/DH, and AKR by analytic functions.
C
C ------ for example 1
C        WCR=THPROP(1,MTYP)                                             SPRO 640
C        WCS=THPROP(2,MTYP)                                             SPRO 645
C        HAA=THPROP(3,MTYP)                                             SPRO 650
C        HAB=THPROP(4,MTYP)                                             SPRO 655
C ------ for example 2
C        WCR=THPROP(1,MTYP)
C        WCS=THPROP(2,MTYP)
C        HAA=THPROP(3,MTYP)
C        THAA=THPROP(4,MTYP)
C        THBB=THPROP(5,MTYP)
C        POWER=AKPROP(1,MTYP)
C
          WCR = THPROP(1,MTYP)
          WCS = THPROP(2,MTYP)
          HAA = THPROP(3,MTYP)
          ALPHA= THPROP(4,MTYP)
          BETA = THPROP(5,MTYP)
C         GAMMA = 1.0D0-(1.0D0/BETA)
          DO 800 KG = 1,8
            HNP =  HKG(KG)
            HNP = -HNP
            IF (HNP .LE. 0.0) THEN
C             for the saturaed conditions
              TH(KG,M)  = WCS
              DTH(KG,M) = 0.0D0
              AKR(KG,M) = 1.0D0
            ELSE
C             for the unsatuated conditions
C ------- for example 1                                                 SPRO 735
C           THMKG=WCS-(WCS-WCR)*(-HNP-HAA)/(HAB-HAA)                    SPRO 740
C           TH(KG,M)=THMKG                                              SPRO 745
C           DTH(KG,M)=-(WCS-WCR)/(HAB-HAA)                              SPRO 750
C           AKR(KG,M)=(THMKG-WCR)/(WCS-WCR)                                SPRO
C ------ for example 2
C           THMKG=WCR+(WCS-WCR)*THAA/(THAA+(DABS(-HNP-HAA))**THBB)
C           TH(KG,M)=THMKG
C           AKR(KG,M)=((THMKG-WCR)/(WCS-WCR))**POWER
C           DNOM=THAA+(DABS(-HNP-HAA))**THBB
C           DTH(KG,M)=(WCS-WCR)*THAA*(DABS(-HNP-THAA))**(THBB-1.0D0)/
C    >                DNOM**2
C
C             THMKG     = WCR + (WCS - WCR)/(1.0D0+(ALPHA*DABS(
C    >                    -HNP-HAA))**BETA)**GAMMA
C             TH(KG,M)  = THMKG
C             FTHETA = ((THMKG-WCR)/(WCS-WCR))**(1.0D0/GAMMA)
C             AKR(KG,M) = (((THMKG - WCR)/(WCS - WCR))**0.5)
C    >                    *(1.0D0-(1.0D0-FTHETA)**GAMMA)**2.0
C             DNOM = 1.0D0+(ALPHA*DABS(-HNP-HAA))**BETA
C             DTH(KG,M) = ALPHA*(BETA-1.0D0)*((1.0D0-FTHETA)
C    >                    **GAMMA)*FTHETA*(WCS-WCR)
              THMKG     = WCR + (WCS - WCR)/(1.0D0+(ALPHA*DABS(
     >                    -HNP-HAA))**BETA)       
              TH(KG,M)  = THMKG
              AKR(KG,M) = ((THMKG - WCR)/(WCS - WCR))**2    
              DNOM = 1.0D0+(ALPHA*DABS(-HNP-HAA))**BETA
              DTH(KG,M) = (WCS-WCR)*(ALPHA*DABS(-HNP-HAA))**(BETA-
     >                     1.0D0)/DNOM**2
            END IF
  800     CONTINUE
C
        END IF
  900 CONTINUE
C
      RETURN
      END
