      SUBROUTINE   STORE
     I                  (LUSTO,MAXEL,MAXNP,MAXBES,MAXBNP,
     I                   NNP,NEL,NBNP,NBES,NTI,LTMXNP,MXREGN,NREGN,
     I                   X,Y,Z,IE,H,HT,TH,VX,VY,VZ,DCOSB,
     I                   ISB,NPBB,NNPLR,GNLR,TITLE,TIME,NPROB)
C
C     + + + PURPOSE + + +
C     To store the solution in binary on logical unit LUSTO
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER            LUSTO,MAXEL,MAXNP,MAXBES,MAXBNP,NNP,NEL,NBNP,
     >                   NBES,NTI,LTMXNP,MXREGN,NREGN,NPROB
      INTEGER            IE(MAXEL,9),ISB(6,MAXBES),NPBB(MAXBNP),
     >                   NNPLR(MXREGN),GNLR(LTMXNP,MXREGN)
      DOUBLE PRECISION   X(MAXNP),Y(MAXNP),Z(MAXNP),
     >                   H(MAXNP),HT(MAXNP),VX(MAXNP),VY(MAXNP),
     >                   VZ(MAXNP),TH(8,MAXEL),DCOSB(3,MAXBES),TIME
      CHARACTER          TITLE*70
C
C     + + + ARGUMENT DEFINITIONS + + +
C     LUSTO  - logical unit on which the solution in binary is stored
C     MAXEL  - maximum number of elements
C     MAXNP  - maximum number of nodal points
C     MAXBES - maximum number of boundary element sides
C     MAXBNP - maximum number of boundary nodal points
C     NNP    - no. of nodal points
C     NEL    - no. of elements
C     NBNP   - no. of boundary nodal points
C     NBES   - no. of boundary element sides
C     NTI    - no. of time increments
C     LTMXNP - maximum number of total nodal points in a subregion
C              ( = maximum no. of nodal points in a subregion
C                  + Intra-boundary nodes)
C     MXREGN - maximum number of subregions
C     NREGN  - no. of subregions
C     X      - x-coordinate
C     Y      - y-coordinate
C     Z      - z-coordinate
C     IE     - incidence of elements
C     H      - pressure head
C     HT     - total head
C     TH     - moisture content
C     VX     - x-component Darcy velocity
C     VY     - y-component Darcy velocity
C     VZ     - z-component Darcy velocity
C     DCOSB  - directional cosine of the unit outward vector normal to
C              the surface segment
C     ISB    - contains boundary node number of the four nodes of the
C              surface segment, the side number (1 to 6) of the element
C              to which the surface segment belong, and the global
C              element number to which the surface segment belong
C     NPBB   - contains global node number of all boundary nodes
C     NNPLR  - contains number of nodes of all subregions
C     GNLR   - contains the mapping between global node number and
C              subregional node number for all subregions
C     TITLE  - title of the problem
C     TIME   - real simulation time
C     NPROB  - problem number
C
C     + + + SAVES + + +
      INTEGER   NPPROB
      SAVE      NPPROB
C
C     + + + LOCAL VARIABLES + + +
      INTEGER   N,I,M
C
C     + + + DATA INITIALIZATIONS + + +
      DATA NPPROB/-1/
C
C     + + + END SPECIFICATIONS + + +
C
      IF (NPPROB .EQ. (-1)) THEN
C
C       rewind logical unit LUSTO
        REWIND (UNIT = LUSTO)
      END IF
C
      IF (NPPROB .NE. NPROB) THEN
C
C       write geometrical information
        WRITE(LUSTO) TITLE,NPROB,NNP,NEL,NBNP,NBES,NTI,NREGN
        WRITE(LUSTO) (X(N),N=1,NNP),(Y(N),N=1,NNP),(Z(N),N=1,NNP),
     >   ((IE(M,I),M=1,NEL),I=1,9),((DCOSB(I,M),I=1,3),M=1,NBES),
     >   ((ISB(I,M),I=1,6),M=1,NBES),(NPBB(N),N=1,NBNP),
     >   (NNPLR(N),N=1,NREGN),((GNLR(N,I),N=1,LTMXNP),I=1,NREGN)
C
C       set problem number counter to NPROB
        NPPROB = NPROB
      END IF
C
C     write hydrological variables
      WRITE(LUSTO) TIME,(H(N),N=1,NNP),
     >              (HT(N),N=1,NNP),((TH(I,M),I=1,8),M=1,NEL),
     >              (VX(N),N=1,NNP),(VY(N),N=1,NNP),(VZ(N),N=1,NNP)
C
      RETURN
      END
