      SUBROUTINE   VELT
     I                 (X,Y,Z,IE,H,AKR, PROP,
     O                  VX,VY,VZ,CMATRX,HT)
C
C     + + + PURPOSE + + +
C     To compute Darcy velocity or the specific discharge by applying
C     Finite Element Method (FEM) to Darcy's law.
C
C     + + + COMMON BLOCKS + + +
      INCLUDE 'CSGEOM.INC'
      INCLUDE 'CGEOM.INC'
      INCLUDE 'CSMTL.INC'
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER            IE(MAXEL,9)
      DOUBLE PRECISION   X(MAXNP),Y(MAXNP),Z(MAXNP),H(MAXNP),
     >                   AKR(8,MAXEL),PROP(MXMPPM,MAXMAT),VX(MAXNP),
     >                   VY(MAXNP),VZ(MAXNP),CMATRX(MAXNP,MXJBD),
     >                   HT(MAXNP)
C
C     + + + ARGUMENT DEFINITIONS + + +
C     MAXEL  - Maximum number of elements
C     MAXNP  - Maximum number of nodal points
C     MXJBD  - Maximum number of nodes connecting to any node
C     NNP    - No. of nodal points
C     NEL    - No. of elements
C     KGRAV  - Gravity included? 1 = yes, 0 =no.
C     MAXMAT - Maximum number of materials
C     MXMPPM - Maximum number of material proerties per mateial
C     X      - X-coordinate
C     Y      - Y-coordinate
C     Z      - Z-coordinate
C     IE     - Incidence of the elements
C     H      - Pressure head
C     AKR    - Relative conductivity or relative permeability
C     PROP   - Material propertiy
C     VX     - X-component Darcy velocity
C     VY     - Y-component Darcy velocity
C     VZ     - Z-component Darcy velocity
C     CMATRX - Global matrix
C     HT     - Total head
C
C     + + + LOCAL VARIABLES + + +
      INTEGER            NP, M, MTYP, IQ, KG, NI, JQ
      DOUBLE PRECISION   AGRAV,QB(8,8),QRX(8),QRY(8),QRZ(8),XQ(8),
     >                   YQ(8),ZQ(8),HTQ(8),AKXG(8),AKYG(8),AKZG(8),
     >                   AKXYG(8),AKXZG(9),AKYZG(8)
C
C     + + + INTRINSICS + + +
      INTRINSIC DBLE
C
C     + + + EXTERNALS + + +
      EXTERNAL  Q8DV
C
C     + + + END SPECIFICATIONS + + +
C
      AGRAV = DBLE(KGRAV)
C
C     Initiate the Darcy velocity components
      DO 100 NP = 1,NNP
        VX(NP) = 0.0
        VY(NP) = 0.0
        VZ(NP) = 0.0
100   CONTINUE
C
C     Calculate the total head
      DO 105 NP = 1,NNP
        HT(NP) = H(NP) + (AGRAV*Z(NP))
105   CONTINUE
C
C     Initial the matrix
      DO 160 NP = 1,NNP
        CMATRX(NP,1) = 0.0
160   CONTINUE
C
C     ####### Assemble the matrix equation element by element
C
      DO 290 M = 1,NEL
        MTYP = IE(M,9)
C
C       Put the values in global variables into local variables
        DO 210 IQ = 1,8
          NP      = IE(M,IQ)
          XQ(IQ)  = X(NP)
          YQ(IQ)  = Y(NP)
          ZQ(IQ)  = Z(NP)
          HTQ(IQ) = HT(NP)
210     CONTINUE
        DO 215 KG = 1,8
C         compute hydraulic conductivity components
          AKXG(KG)  = AKR(KG,M)*PROP(1,MTYP)
          AKYG(KG)  = AKR(KG,M)*PROP(2,MTYP)
          AKZG(KG)  = AKR(KG,M)*PROP(3,MTYP)
          AKXYG(KG) = AKR(KG,M)*PROP(4,MTYP)
          AKXZG(KG) = AKR(KG,M)*PROP(5,MTYP)
          AKYZG(KG) = AKR(KG,M)*PROP(6,MTYP)
215     CONTINUE
C
C       Compute the derivatives of total head
        CALL Q8DV
     I           (XQ,YQ,ZQ,HTQ,AKXG,AKYG,AKZG,AKXYG,AKXZG,AKYZG,
     O            QB,QRX,QRY,QRZ)
C
C       Put the element matrix and vector into global matrix and vector
C       Note:  the matrix is lumped for fast solving.
        DO 280 IQ = 1,8
          NI = IE(M,IQ)
          DO 240 JQ = 1,8
            CMATRX(NI,1) = CMATRX(NI,1) + QB(IQ,JQ)
  240     CONTINUE
          VX(NI) = VX(NI) + QRX(IQ)
          VY(NI) = VY(NI) + QRY(IQ)
          VZ(NI) = VZ(NI) + QRZ(IQ)
  280   CONTINUE
  290 CONTINUE
C
C     ####### Solve the matrix equation for velocity components.
C     ####### The matrix equations can be solved point by point because
C     ####### the matrix has been lumped as stated earlier.
C
      DO 370 NP = 1,NNP
        VX(NP) = VX(NP)/CMATRX(NP,1)
        VY(NP) = VY(NP)/CMATRX(NP,1)
        VZ(NP) = VZ(NP)/CMATRX(NP,1)
370   CONTINUE
C
      RETURN
      END
