      SUBROUTINE ADVBC
     I                (THN,IE,X,Y,Z,VX,VY,VZ,VXP,VYP,VZP,DCOSB,ISB,
     I                 NPBB,CVB,IVTYP,ISV,NPVB,CDB,IDTYP,NPDB,QCB,
     I                 ICTYP,ISC,NPCB,
     M                 RI,RL,
     O                 CSTAR)
C
C     + + + PURPOSE + + +
C     To apply Cauchy, vairable, and Dirichlet boundary conditions
C
C     + + + COMMON BLOCKS + + +
      INCLUDE 'SGEOM.INC'
      INCLUDE 'CGEOM.INC'
      INCLUDE 'CCBC.INC'
      INCLUDE 'CVBC.INC'
      INCLUDE 'CDBC.INC'
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER            IE(MAXEL,9),ISB(6,MAXBES),NPBB(MAXBNP),
     >                   IVTYP(MXVES),ISV(5,MXVES),NPVB(MXVNP),
     >                   IDTYP(MXDNP),NPDB(MXDNP),ICTYP(MXCES),
     >                   ISC(5,MXCES),NPCB(MXCNP)
      DOUBLE PRECISION   THN(MAXNP),X(MAXNP),Y(MAXNP),Z(MAXNP),
     >                   VX(MAXNP),VY(MAXNP),VZ(MAXNP),VXP(MAXNP),
     >                   VYP(MAXNP),VZP(MAXNP),DCOSB(3,MAXBES),
     >                   CVB(MXRPR),CDB(MXDPR),QCB(MXCPR),RI(MAXNP),
     >                   RL(MAXNP),CSTAR(MAXNP)
C
C     + + + ARGUMENT DEFINITIONS + + +
C     THN(N)   - moisture content at the N-th node
C     IE(M,I)  - global node number of the I-th node of the M-th element
C                if I is between 1 and 8
C     IE(M,9)  - integer to indicate the material type of the M-th
C                element
C     X(N)     - x-coordiante of the N-th node
C     Y(N)     - y-coordinate of the N-th node
C     Z(N)     - z-coordinate of the N-th node
C
C     VX(N)      - x-component velocity at the N-th node
C     VY(N)      - y-component velocity at the N-th node
C     VZ(N)      - z-component velocity at the N-th node
C     VXP(N)     - value of VX(N) at previous time
C     VYP(N)     - value of VY(N) at previous time
C     VZP(N)     - value of VZ(N) at previous time
C
C     DCOSB(1,I) - x-directional cosine of the I-th boundary side
C     DCOSB(2,I) - y-directional cosine of the I-th boundary side
C     DCOSB(3,I) - z-directional cosine of the I-th boundary side
C     ISB(1,I)   - boundary node number of the first node of the I-th
C                  boundary side
C     ISB(2,I)   - boundary node number of the second node of the I-th
C                  boundary side
C     ISB(3,I)   - boundary node number of the third node of the I-th
C                  boundary side
C     ISB(4,I)   - boundary node number of the fourth node of the I-th
C                  boundary side
C     ISB(5,I)   - element side index of the I-th boundary side
C                  1=left side, 2=front side, 3=right side,
C                  4=back side, 5=bottom side, 6=top side
C     ISB(6,I)   - element number to which the I-th boundary side belong
C     NPBB(I)    - global node number of the I-the boundary node
C     CVB(I)     - variable concentration of the I-th profile
C                  at the present time
C     IVTYP(MP)  - type of variable concentration profile assigned to
C                  the MP-th variable side
C     ISV(1,MP)  - global node number of the first node of the Mp-th
C                  Variable side
C     ISV(2,MP)  - global node number of the second node of the Mp-th
C                  variable side
C     ISV(3,MP)  - global node number of the third node of the Mp-th
C                  variable side
C     ISV(4,MP)  - global node number of the fourth node of the Mp-th
C                  variable side
C     ISV(5,MP)  - boundary side number of the MP-th variable side
C     NPVB(NP)   - global nodal number of the NP-variable node on input
C                  Then is changed to contain boundary node number
C     CDB(I)     - Dirichlet concentration of the I-th profile
C                  at the present time
C     IDTYP(NP)  - type of Dirichlet concentration profile assigned to
C                  the NP-th Dirichlet node
C     NPDB(NP)   - global nodal number of the NP-Dirichlet node on input
C                  Then is changed to contain boundary node number
C     QCB(I)     - Value of Cauchy flux at the presnet time of the
C                  I-th Cauchy flux profile
C     ICTYP(MP)  - type of Cauchy flux profile assigned to the MP-th
C                  Cauchy side
C     ISC(1,MP)  - global node number of the first node of the Mp-th
C                  Cauchy side
C     ISC(2,MP)  - global node number of the second node of the Mp-th
C                  Cauchy side
C     ISC(3,MP)  - global node number of the third node of the Mp-th
C                  Cauchy side
C     ISC(4,MP)  - global node number of the fourth node of the Mp-th
C                  Cauchy side
C     ISC(5,MP)  - boundary side number of the MP-th Cauchy side
C     NPCB(NP)   - global nodal number of the NP-Cauchy node on input
C                  Then is changed to contain boundary node number
C     RI(N)       - a working array
C     RL(N)       - a working array
C     CSTAR(N)    - Lagrangian concentration at the N-th node
C
C     + + + LOCAL VARIABLES + + +
      INTEGER            NI,MP,ITYP,MPB,LS,M,IQ,I,NPP,NP,KGB(4,6)
      DOUBLE PRECISION   QCBMP,CINMP,BB,RQI(4),RQL(4),XQ(4),
     >                     YQ(4),ZQ(4),VXQ(4),VYQ(4),VZQ(4)
C
C     + + + EXTERNALS + + +
      EXTERNAL     Q4ADB
C
C     + + + DATA INITIALIZATIONS + + +
      DATA KGB/1,4,8,5, 1,2,6,5, 2,3,7,6, 4,3,7,8, 1,2,3,4, 5,6,7,8/
C
C     + + + END SPECIFICATIONS + + +
C
C ******* Apply Cauchy condition: QC=V.N.C - N.(THETA)D.GRAD(C)
C
      IF (NCES .NE. 0) THEN
        DO 110 NI = 1,NNP
          RI(NI) = 0.0
          RL(NI) = 0.0
  110   CONTINUE
C
        DO 150 MP = 1,NCES
C         obtain Cauchy flux for the side
          ITYP  = ICTYP(MP)
          QCBMP = QCB(ITYP)
C
          MPB   = ISC(5,MP)
          LS    = ISB(5,MPB)
          M     = ISB(6,MPB)
C
          DO 130 IQ = 1,4
            I  = KGB(IQ,LS)
            NI = IE(M,I)
            XQ(IQ) = X(NI)
            YQ(IQ) = Y(NI)
            ZQ(IQ) = Z(NI)
            VXQ(IQ) = ((VX(NI) + VXP(NI))*0.5D0)/THN(NI)
            VYQ(IQ) = ((VY(NI) + VYP(NI))*0.5D0)/THN(NI)
            VZQ(IQ) = ((VZ(NI) + VZP(NI))*0.5D0)/THN(NI)
  130     CONTINUE
C
C         peform boundary integration to obtain flow rate and material
C         flux due to the side
C
          CALL Q4ADB
     I              (XQ,YQ,ZQ,VXQ,VYQ,VZQ,DCOSB(1,MPB),QCBMP,1,
     O               RQL,RQI)
C
C         contribution from the side to the node
          DO 140 IQ = 1,4
            I      = KGB(IQ,LS)
            NI     = IE(M,I)
            RL(NI) = RL(NI) - RQL(IQ)
            RI(NI) = RI(NI) - RQI(IQ)
  140     CONTINUE
  150   CONTINUE
C
C       Lagrangian concentrations at all Cauchy nodes
        DO 190 NPP = 1,NCNP
          NI = NPCB(NPP)
          NP = NPBB(NI)
          IF (RL(NP) .NE. 0.0) THEN
            CSTAR(NP) = RI(NP)/RL(NP)
          END IF
  190   CONTINUE
      END IF
C
C ******* Apply variable boundary conditions
C
      IF (NVES .NE. 0) THEN
        DO 510 NP = 1,NNP
          RI(NP) = 0.0
          RL(NP) = 0.0
  510   CONTINUE
C
        DO 550 MP = 1,NVES
C         obtain concentration on the variable boundary side
          ITYP  = IVTYP(MP)
          CINMP = CVB(ITYP)
C
          MPB   = ISV(5,MP)
          LS    = ISB(5,MPB)
          M     = ISB(6,MPB)
C
          DO 530 IQ = 1,4
            I       = KGB(IQ,LS)
            NI      = IE(M,I)
            XQ(IQ)  = X(NI)
            YQ(IQ)  = Y(NI)
            ZQ(IQ)  = Z(NI)
            VXQ(IQ) = ((VX(NI) + VXP(NI))*0.5D0)/THN(NI)
            VYQ(IQ) = ((VY(NI) + VYP(NI))*0.5D0)/THN(NI)
            VZQ(IQ) = ((VZ(NI) + VZP(NI))*0.5D0)/THN(NI)
  530     CONTINUE
C
C         peform boundary integration to obtain flow rate and material
C         flux due to the side
C
          CALL Q4ADB
     I              (XQ,YQ,ZQ,VXQ,VYQ,VZQ,DCOSB(1,MPB),CINMP,3,
     O               RQL,RQI)
C
C         contribution from the side to node
          DO 540 IQ = 1,4
            I      = KGB(IQ,LS)
            NI     = IE(M,I)
            RL(NI) = RL(NI) - RQL(IQ)
            RI(NI) = RI(NI) - RQI(IQ)
  540     CONTINUE
  550   CONTINUE
C
C       Lagrangian concentrations at all variable nodes
        DO 590 NPP = 1,NVNP
          NI = NPVB(NPP)
          NP = NPBB(NI)
          IF (RL(NP) .NE. 0.0) THEN
            CSTAR(NP) = RI(NP)/RL(NP)
          END IF
  590   CONTINUE
      END IF
C
C ******* apply Dirichlet boundary condition
C
      IF (NDNP .NE. 0) THEN
        DO 790 NPP = 1,NDNP
C         obtaine Dirichlet concentration at the node
          NP        = NPDB(NPP)
          ITYP      = IDTYP(NPP)
          BB        = CDB(ITYP)
          CSTAR(NP) = BB
  790   CONTINUE
      END IF
C
      RETURN
      END
