      SUBROUTINE AFABTA
     I                 (X,Y,Z,IE,VX,VXP,VY,VYP,VZ,VZP,PROP,IOPTIM,
     O                  WETAB)
C
C     + + + PURPOSE + + +
C     To calculate the weighting factors on twelve sides of each element
C
C     + + + COMMON BLOCKS + + +
      INCLUDE 'SGEOM.INC'
      INCLUDE 'CGEOM.INC'
      INCLUDE 'MATL.INC'
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER            IE(MAXEL,9),IOPTIM
      DOUBLE PRECISION   X(MAXNP),Y(MAXNP),Z(MAXNP),VX(MAXNP),
     >                   VXP(MAXNP),VY(MAXNP),VYP(MAXNP),VZ(MAXNP),
     >                   VZP(MAXNP),PROP(MXMPPM,MAXMAT),
     >                   WETAB(12,MAXEL)
C
C     + + + ARGUMENT DEFINITIONS + + +
C     X(N)       - x-coordiante of the N-th node
C     Y(N)       - y-coordinate of the N-th node
C     Z(N)       - z-coordinate of the N-th node
C     IE(M,I)    - global node number of the I-th node of the M-th
C                  element if I is between 1 and 8
C     IE(M,9)    - integer to indicate the material type of the M-th
C                  element
C     VX(N)      - x-component velocity at the N-th node
C     VXP(N)     - value of VX(N) at previous time
C     VY(N)      - y-component velocity at the N-th node
C     VYP(N)     - value of VY(N) at previous time
C     VZ(N)      - z-component velocity at the N-th node
C     VZP(N)     - value of VZ(N) at previous time
C     PROP(J,I)  - J-the material property of the I-th material
C                  PROP(1,I) = distribution coefficient or
C                              Freundlich K or Langmuir K
C                  PROP(2,I) = bulk density
C                  PROP(3,I) = longitudinal dispersivity
C                  PROP(4,I) = lateral dispersivity
C                  PROP(5,I) = molecular diffusion coefficient
C                  PROP(6,I) = tortuosity
C                  PROP(7,I) = decay constant
C                  PROP(8,I) = Freundlich N or Langmuir SMAX
C     IOPTIM     - weighting factor optimization indicator
C     WETAB(J,M) - weighting factor for the J-the side of the M-th
C                  element
C
C     + + + LOCAL VARIABLES + + +
      INTEGER            NODE(8),M,MTYP,IQ,I,N1,N2
      DOUBLE PRECISION   AL,AT,AM,TAU,DD,DISTX,DISTY,DISTZ,DIST,
     >                   DCSX,DCSY,DCSZ,VXX,VYY,VZZ,VV,VAL,VEL,
     >                   VVI,DXX,DXY,DXZ,DYY,DYZ,DZZ,DAL,DISP
C
C     + + + INTRINSICS + + +
      INTRINSIC     DSQRT,DABS,DTANH
C
C     + + + END SPECIFICATIONS + + +
C
      DO 490 M = 1,NEL
C       put material properties into local variables
        MTYP = IE(M,9)
        AL   = PROP(3,MTYP)
        AT   = PROP(4,MTYP)
        AM   = PROP(5,MTYP)
        TAU  = PROP(6,MTYP)
        DD   = TAU*AM
C
        DO 210 IQ = 1,8
          NODE(IQ) = IE(M,IQ)
  210   CONTINUE
C
C       compute weighting factors for 12 sides.
        DO 390 I = 1,12
          IF (I .EQ. 1) THEN
C           for side 1-2
            N1 = NODE(1)
            N2 = NODE(2)
          ELSE IF (I .EQ. 2) THEN
C           for side 4-3
            N1 = NODE(4)
            N2 = NODE(3)
          ELSE IF (I .EQ. 3) THEN
C           for side 5-6
            N1 = NODE(5)
            N2 = NODE(6)
          ELSE IF (I .EQ. 4) THEN
C           for side 8-7
            N1 = NODE(8)
            N2 = NODE(7)
          ELSE IF (I .EQ. 5) THEN
C           for side 1-4
            N1 = NODE(1)
            N2 = NODE(4)
          ELSE IF (I .EQ. 6) THEN
C           for side 2-3
            N1 = NODE(2)
            N2 = NODE(3)
          ELSE IF (I .EQ. 7) THEN
C           for side 5-8
            N1 = NODE(5)
            N2 = NODE(8)
          ELSE IF (I .EQ. 8) THEN
C           for side 6-7
            N1 = NODE(6)
            N2 = NODE(7)
          ELSE IF (I .EQ. 9) THEN
C           for side 1-5
            N1 = NODE(1)
            N2 = NODE(5)
          ELSE IF (I .EQ. 10) THEN
C           for side 2-6
            N1 = NODE(2)
            N2 = NODE(6)
          ELSE IF (I .EQ. 11) THEN
C           for side 3-7
            N1 = NODE(3)
            N2 = NODE(7)
          ELSE
C           for side 4-8
            N1 = NODE(4)
            N2 = NODE(8)
          END IF
C
          DISTX = X(N2) - X(N1)
          DISTY = Y(N2) - Y(N1)
          DISTZ = Z(N2) - Z(N1)
          DIST  = DSQRT(DISTX*DISTX + DISTY*DISTY + DISTZ*DISTZ)
          DCSX  = DISTX/DIST
          DCSY  = DISTY/DIST
          DCSZ  = DISTZ/DIST
C         compute average velocity for the side
          VXX = 0.5D0*((VX(N1) + VX(N2))*0.5D0 + (VXP(N1) +
     >          VXP(N2))*0.5D0)
          VYY = 0.5D0*((VY(N1) + VY(N2))*0.5D0 + (VYP(N1) +
     >          VYP(N2))*0.5D0)
          VZZ = 0.5D0*((VZ(N1) + VZ(N2))*0.5D0 + (VZP(N1) +
     >          VZP(N2))*0.5D0)
C         compute absoute velocity for the side
          VV  = DSQRT(VXX*VXX + VYY*VYY + VZZ*VZZ)
C
C ####### For the Case Velocity Equal to 0
C
          IF (VV .EQ. 0.0) THEN
            WETAB(I,M) = 0.0
C
          ELSE
C
C ####### For the Case Velocity not equal to 0
C
            VAL  = VXX*DCSX + VYY*DCSY + VZZ*DCSZ
            VEL  = DIST*VAL
            VVI  = 1.0D0/VV
C
            DXX  = (AL*VXX*VXX + AT*(VYY*VYY + VZZ*VZZ))*VVI + DD
            DXY  = (AL - AT)*VXX*VYY*VVI
            DXZ  = (AL - AT)*VXX*VZZ*VVI
            DYY  = (AL*VYY*VYY + AT*(VZZ*VZZ + VXX*VXX))*VVI + DD
            DYZ  = (AL - AT)*VYY*VZZ*VVI
            DZZ  = (AL*VZZ*VZZ + AT*(VXX*VXX + VYY*VYY))*VVI + DD
            DAL  = DABS(DCSX*(DCSX*DXX + DCSY*DXY + DCSZ*DXZ) +
     >             DCSY*(DCSX*DXY + DCSY*DYY + DCSZ*DYZ) +
     >             DCSZ*(DCSX*DXZ + DCSY*DYZ + DCSZ*DZZ))
            DISP = 2.0D0*DAL
C
C $$$$$$$$$ For the case IOPTIM equal to 0
            IF (IOPTIM .EQ. 0) THEN
C
              WETAB(I,M) = 1.0D0
              IF (VEL .LT. 0.0) THEN
                WETAB(I,M) = -1.0D0
              END IF
              IF (VEL .EQ. 0.0) THEN
                WETAB(I,M) = 0.0
              END IF
              IF (DISP .NE. 0.0) THEN
                IF (DABS(VEL/DISP) .LT. 1.0D - 10) THEN
                  WETAB(I,M) = 0.0
                END IF
              END IF
C
C $$$$$$$$$ For the case IOPTIM not equal to 0
            ELSE
C
              IF (DISP .EQ. 0.0 .OR. VEL .EQ. 0.0) THEN
                IF (VEL .EQ. 0.0) THEN
                  WETAB(I,M) = 0.0
                END IF
                IF (VEL .GT. 0.0) THEN
                  WETAB(I,M) = 1.0D0
                END IF
                IF (VEL .LT. 0.0) THEN
                  WETAB(I,M) = -1.0D0
                END IF
              ELSE
                WETAB(I,M) = 1.0D0/DTANH(VEL/DISP) - DISP/VEL
              END IF
C
C $$$$$$$$$ End of IOPTIM branch
            END IF
C
C ####### End of Velocity Branch
C
          END IF
C
  390   CONTINUE
  490 CONTINUE
C
      RETURN
      END
