      SUBROUTINE ALLFCT
     I                 (TPRF,PRF,T,MXPR,MXDP,NPR,NDP,KANALY,
     O                  PR)
C
C     + + + PURPOSE + + +
C     To compute source/sink or boundary values
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER            MXPR,MXDP,NPR,NDP,KANALY
      DOUBLE PRECISION   TPRF(MXDP,MXPR),PRF(MXDP,MXPR),T,PR(MXPR)
C
C     + + + ARGUMENT DEFINITIONS + + +
C     MXPR   - maximum number of profiles
C     MXDP   - maximum number of data points in any profile
C     NPR    - number of profiles
C     NDP    - number of data points in any profile
C     KANALY - analytical input control
C     TPRF   - time of the data point on the profile
C     PRF    - profile value of the data point on the profile
C     T      - time
C     PR     - profile values at T
C
C     + + + LOCAL VARIABLES + + +
      INTEGER            I,J,DONFG
      DOUBLE PRECISION   RFJM1,TRFJM1,RFJ,TRFJ,ABC,ABCD,A1,A2,A3,A4,A5
C
C     + + + END SPECIFICATIONS + + +
C
      IF (KANALY .NE. 1 ) THEN
C
C ***** Compute profile values with tabulet input
C
        DO 160 I= 1,NPR
C
          DONFG= 0
          J    = 1
 120      CONTINUE
            J= J+ 1
            IF (TPRF(J-1,I) .LE. T .AND. T .LE. TPRF(J,I)) THEN
              DONFG= 1
            END IF
          IF (DONFG .EQ. 0 .AND. J .LT. NDP) GO TO 120
          IF (DONFG .EQ. 1) THEN
C           interpolate the value
            RFJM1 = PRF(J-1,I)
            TRFJM1= TPRF(J-1,I)
            RFJ   = PRF(J,I)
            TRFJ  = TPRF(J,I)
            ABC   = RFJ - RFJM1
            ABCD  = TRFJ- TRFJM1
            PR(I) = RFJM1+(T-TRFJM1)*ABC/ABCD
          ELSE
C           outside the tabulet range, set profile values to 0
            PR(I) = 0.0
          END IF
  160   CONTINUE
      ELSE
C
C ***** Compute profile values with analytic funcitons
C
        DO 260 I= 1,NPR
          A1   = PRF(1,I)
          A2   = PRF(2,I)
          A3   = PRF(3,I)
          A4   = PRF(4,I)
          A5   = PRF(5,I)
          PR(I)= A1 + A2*T + A3*T*T + A4*T*T*T + A5*T*T*T*T
  260   CONTINUE
      END IF
C
      RETURN
      END
