      SUBROUTINE ASEMBL
     I                 (LUOUT,CW,CP,CSTAR,X,Y,Z,IE,LRN,WETAB,VX,VY,VZ,
     I                  VXP,VYP,VZP,TH,THP,DTH,LES,ISTYP,SOS,NPW,
     I                  IWTYP,WSS,PROP,DELT,KSS,DTI,
     O                  CMATRX,RLD)
C
C     + + + PURPOSE + + +
C     To assemble the global coefficient matrix and global load vector
C
C     + + + COMMON BLOCKS + + +
      INCLUDE 'SGEOM.INC'
      INCLUDE 'CGEOM.INC'
      INCLUDE 'CELS.INC'
      INCLUDE 'CNPS.INC'
      INCLUDE 'MATL.INC'
      INCLUDE 'OPTN.INC'
      INCLUDE 'WETX.INC'
      INCLUDE 'WETY.INC'
      INCLUDE 'WETZ.INC'
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER            LUOUT,IE(MAXEL,9),LRN(MXJBD,MAXNP),LES(MXSEL),
     >                   ISTYP(MXSEL),NPW(MXWNP),IWTYP(MXWNP),KSS
      DOUBLE PRECISION   CW(MAXNP),CP(MAXNP),CSTAR(MAXNP),X(MAXNP),
     >                   Y(MAXNP),Z(MAXNP),WETAB(12,MAXEL),VX(MAXNP),
     >                   VY(MAXNP),VZ(MAXNP),VXP(MAXNP),VYP(MAXNP),
     >                   VZP(MAXNP),TH(8,MAXEL),THP(8,MAXEL),
     >                   WSS(MXWPR,2),PROP(MXMPPM,MAXMAT),DELT,
     >                   DTH(8,MAXEL),SOS(MXSPR,2),
     >                   CMATRX(MAXNP,MXJBD),RLD(MAXNP),DTI(MAXNP)
C
C     + + + ARGUMENT DEFINITIONS + + +
C     LUOUT    - logical unit for output data
C     CW(N)    - Nonlinear iterate of concentration at the N-th node
C     CP(N)    - Concentration of the N-th node at previous time
C     CSTAR(N) - Lagrangian concentration at the N-th node
C     X(N)     - x-coordiante of the N-th node
C     Y(N)     - y-coordinate of the N-th node
C     Z(N)     - z-coordinate of the N-th node
C     IE(M,I)  - global node number of the I-th node of the M-th element
C                if I is between 1 and 8
C     IE(M,9)  - integer to indicate the material type of the M-th
C                element
C     LRN(I,N) - global node number of the I-th node connecting
C                to the N-th global node
C
C     WETAB(J,M) - weighting factor for the J-the side of the M-th
C                  element
C     VX(N)      - x-component velocity at the N-th node
C     VY(N)      - y-component velocity at the N-th node
C     VZ(N)      - z-component velocity at the N-th node
C     VXP(N)     - value of VX(N) at previous time
C     VYP(N)     - value of VY(N) at previous time
C     VZP(N)     - value of VZ(N) at previous time
C     TH(I,M)    - moisture content at the I-th node of the M-th element
C     THP(I,M)   - value of TH(I,M) at the previous time
C     DTH(I,M)   - (TH(I,M)-THP(I,M))/DELT
C     THN(N)     - moisture content at the N-th node
C
C     LES(I)      - global element number of the I-th element-source
C     ISTYP(M)    - type of source profile assigned to the M-th element
C     SOS(I,1)    - source flow rate of the I-th profile at time t
C     SOS(I,2)    - source concentration of the I-th profile at time t
C     NPW(I)      - global node number of the I-th well node
C     IWTYP(I)    - type of source profile assigned to the I-th node
C     WSS(I,1)    - well source flow rate of the I-th profile at time t
C     WSS(I,2)    - well source concentration of the I-th profile
C
C     PROP(J,I) - J-the material property of the I-th material
C                 PROP(1,I) = distribution coefficient or
C                             Freundlich K or Langmuir K
C                 PROP(2,I) = bulk density
C                 PROP(3,I) = longitudinal dispersivity
C                 PROP(4,I) = lateral dispersivity
C                 PROP(5,I) = molecular diffusion coefficient
C                 PROP(6,I) = tortuosity
C                 PROP(7,I) = decay constant
C                 PROP(8,I) = Freundlich N or Langmuir SMAX
C
C     DELT        - time-step size
C     KSS         - steady state control parameter
C     CMATRX(N,I) - an array to store the I-th non-zero entry of the
C                   N-th equation of the assembled global matrix
C     RLD(N)      - an array to store the right hand side of the N-th
C                   equation of the assembled global load vector
C     DTI(N)      - the reciprocal of real diffusion time of the
C                   N-th global node
C
C     + + + LOCAL VARIABLES + + +
      INTEGER            NP,I,M,ITYP,MTYP,IQ,KG,NI,JQ,NJ,LNODE,J,IDO
      DOUBLE PRECISION   SOSQ,SOSC,RHOB,AL,AT,AM,TAU,DKSS,
     >                   FNLS,CWW,CPNJ,WSSQ,WSSC,QA(8,8),QAA(8,8),
     >                   QB(8,8),QC(8,8),QV(8,8),QR(8),XQ(8),
     >                   YQ(8),ZQ(8),VXQ(8),VYQ(8),VZQ(8),THG(8),
     >                   DTHG(8),DSDCQ(8),SWQ(8),CWQ(8),KD,LAMBDA
C
C     + + + INTRINSICS + + +
      INTRINSIC     DBLE
C
C     + + + EXTERNALS + + +
      EXTERNAL      Q8
C
C     + + + OUTPUT FORMATS + + +
 2000 FORMAT('1'/5X,'*** WARNING: NONE OF THE LOWER-LEFT NODE IN EQUATIO
     >N',I3,/5X,'***  IS CORRESPONDING TO ',I5,'-TH ELEMENT-S',I2,
     >'-TH NODE; STOP  ****')
C
C     + + + END SPECIFICATIONS + + +
C
      DKSS  = DBLE(KSS)
      IF (KSS .EQ. 0) THEN
        DO 100 NP = 1,NNP
          DTI(NP)=0.0D0
  100   CONTINUE
      END IF
C
C     Initiate matrices CMATRX(NP,IB) and RLD(NP)
      DO 150 NP = 1,NNP
        RLD(NP) = 0.0
        DO 140 I = 1,MXJBD
          CMATRX(NP,I) = 0.0
  140   CONTINUE
  150 CONTINUE
C
C *** Loop over all elements to form the global matrix equation.
C
      DO 690 M = 1,NEL
C       obtain source flow rate and concentration for the element
        SOSQ = 0.0
        SOSC = 0.0
        IF (NSEL .GT. 0) THEN
C         perform source computation
          IDO = 1
          I = 0
  210     CONTINUE
            I = I + 1
            IF (LES(I) .EQ. M) THEN
C             a source element amoung LES(I)'s equal to M is found.
              ITYP  = ISTYP(I)
              SOSQ  = SOS(ITYP,1)
              SOSC  = SOS(ITYP,2)
              IDO   = 0
            END IF
            IF (I .LT. NSEL .AND. IDO .EQ. 1) THEN
C             up to I, none of the LES(I)'s equal to M, go to 210
C             to search for another element among LES(I)'s.
              GO TO 210
            END IF
        END IF
C
C       put weighting factors in local variables
        APHA1 = WETAB(1,M)
        APHA2 = WETAB(2,M)
        APHA3 = WETAB(3,M)
        APHA4 = WETAB(4,M)
        BETA1 = WETAB(5,M)
        BETA2 = WETAB(6,M)
        BETA3 = WETAB(7,M)
        BETA4 = WETAB(8,M)
        GAMA1 = WETAB(9,M)
        GAMA2 = WETAB(10,M)
        GAMA3 = WETAB(11,M)
        GAMA4 = WETAB(12,M)
C
C       put material properties in local variables
        MTYP   = IE(M,9)
        KD     = PROP(1,MTYP)
        RHOB   = PROP(2,MTYP)
        AL     = PROP(3,MTYP)
        AT     = PROP(4,MTYP)
        LAMBDA = PROP(7,MTYP)
        AM     = PROP(5,MTYP)
        TAU    = PROP(6,MTYP)
        FNLS   = PROP(8,MTYP)
C
        DO 250 IQ = 1,8
          NP      = IE(M,IQ)
C         put global coordinates, velocity components, and concentration
C         iterates into local variables
          XQ(IQ)  = X(NP)
          YQ(IQ)  = Y(NP)
          ZQ(IQ)  = Z(NP)
          VXQ(IQ) = (VX(NP) + VXP(NP))*0.5D0
          VYQ(IQ) = (VY(NP) + VYP(NP))*0.5D0
          VZQ(IQ) = (VZ(NP) + VZP(NP))*0.5D0
          CWW     = CW(NP)
          CWQ(IQ) = CWW
C         compute dS/dC and S for a given adsorption model
          IF (KSORP .EQ. 1) THEN
C           for linear isotherm model
            DSDCQ(IQ) = KD
            SWQ(IQ)   = KD*CWW
          ELSE IF (KSORP .EQ. 2) THEN
C           for Freundlich non-linear isotherm
            DSDCQ(IQ) = FNLS*KD*CWW**(FNLS - 1.0D0)
            SWQ(IQ)   = KD*CWW**FNLS
          ELSE
C           for Langmuir non-linear isotherm
            DSDCQ(IQ) = KD*FNLS/((1.0D0 + KD*CWW)*(1.0D0 + KD*CWW))
            SWQ(IQ)   = KD*FNLS*CWW/(1.0D0 + KD*CWW)
          END IF
  250   CONTINUE
C
C       compute TH, and put it and dTH/dt into local variables
        DO 260 KG = 1,8
          THG(KG)  = (TH(KG,M) + THP(KG,M))*0.5D0
          DTHG(KG) = DTH(KG,M)
  260   CONTINUE
C
C       Compute matrices QA(IQ,JQ), QAA(IQ,JQ), QB(IQ,JQ), QV(IQ,JQ),
C       and QC(IQ,JQ), and the load vector QR(IQ) for the element M.
        CALL Q8
     I         (VXQ,VYQ,VZQ,THG,DTHG,RHOB,AL,AT,LAMBDA,
     I          AM,TAU,SOSQ,SOSC,DSDCQ,SWQ,CWQ,
     O          QA,QAA,QB,QC,QV,QR,XQ,YQ,ZQ)
C
C       Form the global matrix by CMATRX(NP,I) =QB+QC+(QA+QAA)/DELT.
C       Form the load vector by RLD(NP)=QR+QA/DELT*CSTAR+QAA/DELT*CP.
C
        DO 390 IQ = 1,8
C         for the NI-th equation
          NI      = IE(M,IQ)
          RLD(NI) = RLD(NI) + QR(IQ)
          DO 340 JQ = 1,8
C           for the NJ-th entry in the NI-th equation
            NJ         = IE(M,JQ)
            QA(IQ,JQ)  = QA(IQ,JQ)*DTI(NI)
            QAA(IQ,JQ) = QAA(IQ,JQ)*DTI(NI)
            CPNJ       = CP(NJ)
            IF (KSORP .EQ. 1) THEN
C             for the case of linear isotherm
              CPNJ = CSTAR(NJ)
            END IF
            RLD(NI) = RLD(NI) + QA(IQ,JQ)*CSTAR(NJ) + QAA(IQ,JQ)*CPNJ
C
            IDO   = 1
            I     = 0
  325       CONTINUE
              I     = I + 1
              LNODE = LRN(I,NI)
              IF (NJ .EQ. LNODE) THEN
C               LRN(I,NI) is found equal to NJ, set flag IDO = 0
C               no need to search for another LRN(?,NI).
                IDO = 0
              END IF
              IF (IDO .EQ. 1 .AND. I .LT. MXJBD) THEN
C               up to I, non of LRN(I,NI)'s equal to NJ, search for
C               another LRN(?,NI).
                GO TO 325
              END IF
              IF (IDO .EQ. 1 .AND. I .GE. MXJBD) THEN
C               have searched all LRN(I,NI)'s and none of them equals
C               NJ, error and stop
                WRITE(LUOUT,2000) NI,M,JQ
                STOP
              END IF
C
C             one of the LRN(I,NI)'s is equal to NJ, o.k.
              CMATRX(NI,I) = CMATRX(NI,I) + QA(IQ,JQ) + QAA(IQ,JQ) +
     >                     QB(IQ,JQ) + QC(IQ,JQ) + (1.0D0 - DKSS)*
     >                     QV(IQ,JQ)
  340     CONTINUE
  390   CONTINUE
  690 CONTINUE
C
C *** Incorporate Well Source Conditions
C
      IF (NWNP .NE. 0) THEN
        DO 790 I = 1,NWNP
          NI   = NPW(I)
          ITYP = IWTYP(I)
          WSSQ = WSS(ITYP,1)
          WSSC = WSS(ITYP,2)
          IF (WSSQ .GT. 0.0) THEN
            RLD(NI) = RLD(NI) + WSSQ*WSSC
            DO 760 J = 1,MXJBD
              LNODE = LRN(J,NI)
              IF (LNODE .EQ. NI) THEN
                CMATRX(NI,J) = CMATRX(NI,J) + WSSQ
              END IF
  760       CONTINUE
          END IF
  790   CONTINUE
      END IF
C
      RETURN
      END
