      SUBROUTINE BC
     I             (X,Y,Z,IE,LRN,DCOSB,ISB,VX,VY,VZ,VXP,VYP,VZP,
     I              QCB,ISC,ICTYP,QNB,ISN,INTYP,CVB,ISV,IVTYP,CDB,
     I              IDTYP,NPDB,
     O              CMATRX,RLD)
C
C     + + + PURPOSE + + +
C     To apply Cauchy, Neumann, variable, and Dirichlet boundary
C        conditions
C
C     + + + COMMON BLOCKS + + +
      INCLUDE 'SGEOM.INC'
      INCLUDE 'CCBC.INC'
      INCLUDE 'CNBC.INC'
      INCLUDE 'CVBC.INC'
      INCLUDE 'CDBC.INC'
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER            IE(MAXEL,9),LRN(MXJBD,MAXNP),ISB(6,MAXBES),
     >                   ISC(5,MXCES),ICTYP(MXCES),ISN(5,MXNES),
     >                   INTYP(MXNES),ISV(5,MXVES),IVTYP(MXVES),
     >                   IDTYP(MXDNP),NPDB(MXDNP)
      DOUBLE PRECISION   X(MAXNP),Y(MAXNP),Z(MAXNP),DCOSB(3,MAXBES),
     >                   VX(MAXNP),VY(MAXNP),VZ(MAXNP),
     >                   VXP(MAXNP),VYP(MAXNP),VZP(MAXNP),QCB(MXCPR),
     >                   QNB(MXNPR),CVB(MXRPR),CDB(MXDPR),
     >                   CMATRX(MAXNP,MXJBD),RLD(MAXNP)
C
C     + + + ARGUMENT DEFINITIONS + + +
C     X(N)     - x-coordiante of the N-th node
C     Y(N)     - y-coordinate of the N-th node
C     Z(N)     - z-coordinate of the N-th node
C     IE(M,I)  - global node number of the I-th node of the M-th element
C                if I is between 1 and 8
C     IE(M,9)  - integer to indicate the material type of the M-th
C                element
C     LRN(I,N) - global node number of the I-th node connecting
C                to the N-th global node
C
C     DCOSB(1,I) - x-directional cosine of the I-th boundary side
C     DCOSB(2,I) - y-directional cosine of the I-th boundary side
C     DCOSB(3,I) - z-directional cosine of the I-th boundary side
C     ISB(1,I)   - boundary node number of the first node of the I-th
C                  boundary side
C     ISB(2,I)   - boundary node number of the second node of the I-th
C                  boundary side
C     ISB(3,I)   - boundary node number of the third node of the I-th
C                  boundary side
C     ISB(4,I)   - boundary node number of the fourth node of the I-th
C                  boundary side
C     ISB(5,I)   - element side index of the I-th boundary side
C                  1=left side, 2=front side, 3=right side,
C                  4=back side, 5=bottom side, 6=top side
C     ISB(6,I)   - element number to which the I-th boundary side belong
C
C     VX(N)      - x-component velocity at the N-th node
C     VY(N)      - y-component velocity at the N-th node
C     VZ(N)      - z-component velocity at the N-th node
C     VXP(N)     - value of VX(N) at previous time
C     VYP(N)     - value of VY(N) at previous time
C     VZP(N)     - value of VZ(N) at previous time
C
C     QCB(I)     - Value of Cauchy flux at the presnet time of the
C                  I-th Cauchy flux profile
C     ISC(1,MP)  - global node number of the first node of the Mp-th
C                  Cauchy side
C     ISC(2,MP)  - global node number of the second node of the Mp-th
C                  Cauchy side
C     ISC(3,MP)  - global node number of the third node of the Mp-th
C                  Cauchy side
C     ISC(4,MP)  - global node number of the fourth node of the Mp-th
C                  Cauchy side
C     ISC(5,MP)  - boundary side number of the MP-th Cauchy side
C     ICTYP(MP)  - type of Cauchy flux profile assigned to the MP-th
C                  Cauchy side
C     QNB(I)     - Value of Neumann flux at the presnet time of the
C                  I-th Neumann flux profile
C     ISN(1,MP)  - global node number of the first node of the Mp-th
C                  Neumann side
C     ISN(2,MP)  - global node number of the second node of the Mp-th
C                  Neumann side
C     ISN(3,MP)  - global node number of the third node of the Mp-th
C                  Neumann side
C     ISN(4,MP)  - global node number of the fourth node of the Mp-th
C                  Neumann side
C     ISN(5,MP)  - boundary side number of the MP-th Neumann side
C     INTYP(MP)  - type of Neumann flux profile assigned to the MP-th
C                  Neumann side
C     CVB(I)     - variable concentration of the I-th profile
C                  at the present time
C     ISV(1,MP)  - global node number of the first node of the Mp-th
C                  Variable side
C     ISV(2,MP)  - global node number of the second node of the Mp-th
C                  variable side
C     ISV(3,MP)  - global node number of the third node of the Mp-th
C                  variable side
C     ISV(4,MP)  - global node number of the fourth node of the Mp-th
C                  variable side
C     ISV(5,MP)  - boundary side number of the MP-th variable side
C     IVTYP(MP)  - type of variable concentration profile assigned to
C                  the MP-th variable side
C     CDB(I)     - Dirichlet concentration of the I-th profile
C                  at the present time
C     IDTYP(NP)  - type of Dirichlet concentration profile assigned to
C                  the NP-th Dirichlet node
C     NPDB(NP)   - global nodal number of the NP-Dirichlet node on input
C                  Then is changed to contain boundary node number
C
C     CMATRX(N,I) - an array to store the I-th non-zero entry of the
C                   N-th equation of the assembled global matrix
C     RLD(N)      - an array to store the right hand side of the N-th
C                   equation of the assembled global load vector
C
C     + + + LOCAL VARIABLES + + +
      INTEGER            MP,ITYP,MPB,LS,M,IQ,I,NI,JQ,J,NJ,JJ,LNODE,NPP,
     >                   IB,KGB(4,6),DONFG
      DOUBLE PRECISION   QCBMP,QNBMP,CINMP,BB,BQ(4,4),RQ(4),
     >                   XQ(4),YQ(4),ZQ(4),VXQ(4),VYQ(4),VZQ(4)
C
C     + + + EXTERNALS + + +
      EXTERNAL    Q4CNVB
C
C     + + + DATA INITIALIZATIONS + + +
      DATA KGB/1,4,8,5, 1,2,6,5, 2,3,7,6, 4,3,7,8, 1,2,3,4, 5,6,7,8/
C
C     + + + OUTPUT FORMATS + + +
 2000 FORMAT(/,'FOR',I4,'-TH CAUCHY SIDE',I2,'-TH NODE EQUATION NO.',
     > I4,'  WE CANNOT FIND THE COEFFICIENT FOR THE',I2,'-TH NODE',
     > ' UNKNOWN NO.',I4,'   STOP')
 2010 FORMAT(/,'FOR',I4,'-TH VB SIDE',I2,'-TH NODE EQUATION NO.',
     > I4,'  WE CANNOT FIND THE COEFFICIENT FOR THE',I2,'-TH NODE',
     > ' UNKNOWN NO.',I4,'   STOP')
C
C     + + + END SPECIFICATIONS + + +
C
C *** Apply Cauchy Conditions: QC=V.n*C - n.(THETA)D.GRAD(C)
C
      IF (NCES .NE. 0) THEN
        DO 190 MP = 1,NCES
C         obtain Cauchy normal flux
          ITYP  = ICTYP(MP)
          QCBMP = QCB(ITYP)
C
          MPB   = ISC(5,MP)
          LS    = ISB(5,MPB)
          M     = ISB(6,MPB)
          DO 130 IQ = 1,4
            I       = KGB(IQ,LS)
            NI      = IE(M,I)
            XQ(IQ)  = X(NI)
            YQ(IQ)  = Y(NI)
            ZQ(IQ)  = Z(NI)
            VXQ(IQ) = (VX(NI) + VXP(NI))*0.5D0
            VYQ(IQ) = (VY(NI) + VYP(NI))*0.5D0
            VZQ(IQ) = (VZ(NI) + VZP(NI))*0.5D0
  130     CONTINUE
C
C         perform surface integration of -N(I)*QC and -N(I)*V.n*N(J)
          CALL Q4CNVB
     I               (XQ,YQ,ZQ,VXQ,VYQ,VZQ,DCOSB(1,MPB),QCBMP,1,
     O                BQ,RQ)
C
C         put boundary matrix and load into global matrix and load
          DO 180 IQ = 1,4
            I       = KGB(IQ,LS)
            NI      = IE(M,I)
            RLD(NI) = RLD(NI) + RQ(IQ)
C
            DO 160 JQ = 1,4
              J     = KGB(JQ,LS)
              NJ    = IE(M,J)
C
C             find which compressed entry of the NI-th row
C             corresponds of to NJ?
              DONFG = 0
              JJ    = 0
  140         CONTINUE
                JJ    = JJ + 1
                LNODE = LRN(JJ,NI)
                IF (LNODE .EQ. NJ) THEN
                  DONFG = 1
                END IF
              IF (DONFG .EQ. 0 .AND. JJ .LT. MXJBD) THEN
                GO TO 140
              END IF
C
              IF (DONFG .EQ. 0 .AND. JJ .GE. MXJBD) THEN
C               none of the compressed entries of the NI-th row
C               corresponds to NJ, error and stop.
                WRITE (6,2000) MP,IQ,NI,JQ,NJ
                STOP
              END IF
C
C             one of the compressed entries of the NI-th row
C             does correspond to NJ as signified by DONFG = 1.
              CMATRX(NI,JJ) = CMATRX(NI,JJ) + BQ(IQ,JQ)
  160       CONTINUE
  180     CONTINUE
  190   CONTINUE
      END IF
C
C *** Apply Neumann Condition: QN= - n.(THETA)D.GRAD(C)
C
      IF (NNES .NE. 0) THEN
        DO 390 MP = 1,NNES
C         obtain Neumann normal flux
          ITYP  = INTYP(MP)
          QNBMP = QNB(ITYP)
C
          MPB   = ISN(5,MP)
          LS    = ISB(5,MPB)
          M     = ISB(6,MPB)
          DO 330 IQ = 1,4
            I       = KGB(IQ,LS)
            NI      = IE(M,I)
            XQ(IQ)  = X(NI)
            YQ(IQ)  = Y(NI)
            ZQ(IQ)  = Z(NI)
            VXQ(IQ) = (VX(NI) + VXP(NI))*0.5D0
            VYQ(IQ) = (VY(NI) + VYP(NI))*0.5D0
            VZQ(IQ) = (VZ(NI) + VZP(NI))*0.5D0
  330     CONTINUE
C
C         perform surface integration of -N(I)*QN
          CALL Q4CNVB
     I               (XQ,YQ,ZQ,VXQ,VYQ,VZQ,DCOSB(1,MPB),QNBMP,2,
     O                BQ,RQ)
C
C         put element-boundary flux into global flux
          DO 380 IQ = 1,4
            I       = KGB(IQ,LS)
            NI      = IE(M,I)
            RLD(NI) = RLD(NI) + RQ(IQ)
  380     CONTINUE
  390   CONTINUE
      END IF
C
C *** Apply variable boundary conditions
C
      IF (NVES .NE. 0) THEN
        DO 590 MP = 1,NVES
C         obtain concentration on the variable boundary
          ITYP  = IVTYP(MP)
          CINMP = CVB(ITYP)
C
          MPB   = ISV(5,MP)
          LS    = ISB(5,MPB)
          M     = ISB(6,MPB)
          DO 530 IQ = 1,4
            I       = KGB(IQ,LS)
            NI      = IE(M,I)
            XQ(IQ)  = X(NI)
            YQ(IQ)  = Y(NI)
            ZQ(IQ)  = Z(NI)
            VXQ(IQ) = (VX(NI) + VXP(NI))*0.5D0
            VYQ(IQ) = (VY(NI) + VYP(NI))*0.5D0
            VZQ(IQ) = (VZ(NI) + VZP(NI))*0.5D0
  530     CONTINUE
C
C         perform surface integration of -N(I)*V.n*Cv and -N(I)*V.n*N(J)
          CALL Q4CNVB
     I               (XQ,YQ,ZQ,VXQ,VYQ,VZQ,DCOSB(1,MPB),CINMP,3,
     O                BQ,RQ)
C
C         put boundary flux load and matrix into global load and matrix
          DO 580 IQ = 1,4
            I       = KGB(IQ,LS)
            NI      = IE(M,I)
            RLD(NI) = RLD(NI) + RQ(IQ)
C
            DO 560 JQ = 1,4
              J     = KGB(JQ,LS)
              NJ    = IE(M,J)
C
C             find which compressed entry of the NI-th row
C             corresponds of to NJ?
              DONFG = 0
              JJ    = 0
  540         CONTINUE
                JJ    = JJ + 1
                LNODE = LRN(JJ,NI)
                IF (LNODE .EQ. NJ) THEN
                  DONFG = 1
                END IF
              IF (DONFG .EQ. 0 .AND. JJ .LT. MXJBD) THEN
                GO TO 540
              END IF
C
              IF (DONFG .EQ. 0 .AND. JJ .GE. MXJBD) THEN
C               none of the compressed entries of the NI-th row
C               corresponds to NJ, error and stop.
                WRITE (6,2010) MP,IQ,NI,JQ,NJ
                STOP
              END IF
C
C             one of the compressed entries of the NI-th row
C             does correspond to NJ as signified by DONFG = 1.
              CMATRX(NI,JJ) = CMATRX(NI,JJ) + BQ(IQ,JQ)
  560       CONTINUE
  580     CONTINUE
  590   CONTINUE
      END IF
C
C *** Apply Dirichlet Boundary Conditions
C
      IF (NDNP .NE. 0) THEN
        DO 720 NPP = 1,NDNP
          NI      = NPDB(NPP)
          ITYP    = IDTYP(NPP)
          BB      = CDB(ITYP)
          RLD(NI) = BB
C
          DO 710 I = 1,MXJBD
            CMATRX(NI,I) = 0.0
            IB           = LRN(I,NI)
            IF (IB .EQ. NI) THEN
              CMATRX(NI,I) = 1.0D0
            END IF
  710     CONTINUE
  720   CONTINUE
      END IF
C
      RETURN
      END
