      SUBROUTINE BLKITR
     I                 (LUOUT,CMTRXL,RLDL, CMTRXG,RLDG, GNLR,LNOJCN,
     I                  NNPLR,LMAXDF, TOLB,NITER,IBUG,KPR,OME,
     O                  C,RI)
C
C     + + + PURPOSE + + +
C     To solve the matrix equation with block iteration.  First, the
C       bock matrix equation is pull out of the global matrix
C       equation.  Then the intra-boundary conditions are implemented.
C       Finally, the block matrix equation is solved with direct band
C       matrxi solver.
C
C     + + + COMMON BLOCKS + + +
      INCLUDE 'SGEOM.INC'
      INCLUDE 'CGEOM.INC'
      INCLUDE 'LGEOM.INC'
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER            GNLR(LTMXNP,MXREGN),LNOJCN(MXJBD,LMXNP,MXREGN),
     >                   NNPLR(MXREGN),LMAXDF(MXREGN),NITER,IBUG,KPR,
     >                   LUOUT
      DOUBLE PRECISION   CMTRXL(LMXNP,LMXBW),RLDL(LMXNP),
     >                   CMTRXG(MAXNP,MXJBD),RLDG(MAXNP),
     >                   TOLB,OME,C(MAXNP),RI(MAXNP)
C
C     + + + ARGUMENT DEFINITIONS + + +
C     LUOUT  - logical unit for output data
C     CMTRXL - block matrix
C     RLDL   - block load vector
C     CMTRXG - global matrix
C     RLDG   - global load vector
C     GNLR   - mapping between global nodes and local nodes
C     LNOJCN - node connectivity of the local region
C     NNPLR  - number of nodes in all subregions
C     LMAXDF - maximum difference of nodes in any element in local
C              region
C     TOLB   - error tolerance
C     NITER  - no. of iterations allowed
C     IBUG   - debugging indicator
C     KPR    - line printout indicator
C     OME    - relaxation parameter
C     C      - concentration
C     RI     - concentration iterate
C
C     + + + LOCAL VARIABLES + + +
      INTEGER            NP,IT,K,LHALFB,LIHBP,IBAND,LNNP,LI,J,NI,LJ,NJ,
     >                   LJB,NOCCUR
      DOUBLE PRECISION   DIFMAX,DIF
C
C     + + + EXTERNALS + + +
      EXTERNAL     SOLVE
C
C     + + + INTRINSICS + + +
      INTRINSIC    DABS
C
C     + + + OUTPUT FORMATS + + +
 2000 FORMAT(///35X,'   IT   DIFMAX       TOLB        NOCCUR'/35X,
     > '   --   ------       ----        ------')
 2020 FORMAT(' ',34X,I5,2D12.4,I10)
 2030 FORMAT(// 1X,' *** WARNING: NO CONVERGENCE IN BLKI AFTER  ',I4,
     > '   ITERATIONS'/ 1X,'  NITER =',I4,'  DIFMAX =',D11.4,
     > '   TOLB  =',D11.4,'  NOCCUR =',I4)
C
C     + + + END SPECIFICATIONS + + +
C
C
C     put the zero-th iterate into array C
      DO 110 NP = 1,NNP
        C(NP) = RI(NP)
  110 CONTINUE
C
      IF (IBUG .NE. 0 .AND. KPR .NE. 0) THEN
C       write debug heading
        WRITE(LUOUT,2000)
      END IF
C
C *** Start Iteration Loop
C
      DONFG = 0
      IT = 0
C
  150 CONTINUE
        IT = IT + 1
C
C       For each iteration, solve NREGN subregions
        DO 590 K = 1,NREGN
C
          LHALFB = LMAXDF(K)
          LIHBP  = LHALFB + 1
          IBAND  = 2*LHALFB + 1
          LNNP   = NNPLR(K)
C
C         put global load vector into corresponding local load vector
C         and initiate the local matrix
          DO 210 LI = 1,LNNP
            NP       = GNLR(LI,K)
            RLDL(LI) = RLDG(NP)
            DO 200 J = 1,IBAND
              CMTRXL(LI,J) = 0.0
  200       CONTINUE
  210     CONTINUE
C
C         assemble local coefficient matrix from the global coefficient
C         matrix and incorporate interfacial Dirichlet boundary
C         conditions.
          DO 490 LI = 1,LNNP
            NI = GNLR(LI,K)
C
            DO 390 J = 1,MXJBD
              LJ = LNOJCN(J,LI,K)
C
              IF (LJ.GT.0) THEN
C               load the local matrix and incorporate intre-B.C.
                NJ = GNLR(LJ,K)
                IF (LJ .LE. LNNP) THEN
C                 load the local matrix
                  LJB            = LJ - LI + LIHBP
                  CMTRXL(LI,LJB) = CMTRXG(NI,J)
                ELSE
C                 incorporate intra-boundary Dirichlet values
                  RLDL(LI) = RLDL(LI) - CMTRXG(NI,J)*C(NJ)
                END IF
              END IF
  390       CONTINUE
  490     CONTINUE
C
C         solve the block equations
          CALL SOLVE
     I              (1,LNNP,LHALFB,LMXNP,LMXBW,
     M               CMTRXL,RLDL)
          CALL SOLVE
     I              (2,LNNP,LHALFB,LMXNP,LMXBW,
     M               CMTRXL,RLDL)
C
C         put the newly obtained block solution into the global solution
          DO 560 LI = 1,LNNP
            NP    = GNLR(LI,K)
            C(NP) = RLDL(LI)*OME + (1.0D0 - OME)*C(NP)
  560     CONTINUE
  590   CONTINUE
C
C       have finished all subregions, check if the convergent
C       solution is achieved?
        DIFMAX = 0.0
        NOCCUR = 1
C
        DO 660 NP = 1,NNP
          IF (RI(NP) .NE. 0.0) THEN
            DIF=(C(NP)-RI(NP))/RI(NP)
            DIF=DABS(DIF)
            IF (DIF .GT. DIFMAX) THEN
              DIFMAX=DIF
              NOCCUR=NP
            END IF
          END IF
  660   CONTINUE
C
C       update the iterate
        DO 680 NP = 1,NNP
          RI(NP) = C(NP)
  680   CONTINUE
C
C       print iteration information if desired
        IF (IBUG .NE. 0 .AND. KPR .NE. 0) THEN
C         write debug details
          WRITE(LUOUT,2020) IT,DIFMAX,TOLB,NOCCUR
        END IF
C
        IF (IT .GT. 1) THEN
          IF (DIFMAX .LT. TOLB) THEN
            DONFG = 1
          END IF
        END IF
      IF (IT .LT. NITER .AND. DONFG .EQ. 0) GO TO 150
C
      IF (DONFG .EQ. 0) THEN
        WRITE(LUOUT,2030) IT,NITER,DIFMAX,TOLB,NOCCUR
      END IF
C
      RETURN
      END
