      SUBROUTINE BTGN
     I               (X,Y,Z,VX,VY,VZ,IB,NLRL,LRL,IE,CP,MAXNP,MAXEL,DELT,
     I                NNP,LUOUT,NTI,MXKBD,
     M                CS,DTI)
C
C----------------------------------------------------------------------C
C          PURPOSE: FOR 3DLEWAST ONLY                                  C
C                                                                      C
C         IT CALLS:                                                    C
C                                                                      C
C  IT IS CALLED BY:                                                    C
C                                                                      C
C----------------------------------------------------------------------C
C
      IMPLICIT REAL*8(A-H,O-Z)
C
      DIMENSION X(MAXNP),Y(MAXNP),Z(MAXNP),VX(MAXNP),VY(MAXNP),VZ(MAXNP)
      DIMENSION CP(MAXNP),CS(MAXNP),IE(MAXEL,9),DTI(MAXNP)
      DIMENSION XX(8),YY(8),ZZ(8),VXX(8),VYY(8),VZZ(8),MK(8),CC(8),DL(8)
      DIMENSION IB(MAXNP),NLRL(MAXNP),LRL(MXKBD,MAXNP)
C
      DATA EPSX/1.0D-8/,EPST/1.0D-6/
C
      TIM=DBLE(NTI)*DELT
      KKOUNT=0
      NKC1=0
C
C $$$$$ START TRACKINGS
C
      DO 950 N=1,NNP
        KCOUNT=0
C
C ***** CHECK IF THIS POINT HAS ZERO VELOCITY OR IT IS NEGLIGIBLE
C
        VPX=VX(N)
        VPY=VY(N)
        VPZ=VZ(N)
        D1=SQRT(VPX**2+VPY**2+VPZ**2)*TIM
        IF(DABS(D1).LE.EPSX)THEN
          CS(N)=CP(N)
          IF(ITEST.EQ.2)THEN
            WRITE(LUOUT,1001)N,X(N),Y(N),Z(N),CS(N)
 1001       FORMAT(I6,2X,3F12.3,2X,E12.4,'----- THIS NODE HAS ZERO',
     >             ' VELOCITY OR IT IS NEGLIGIBLE')
          ENDIF
          GOTO 950
        ENDIF
C
C ***** TRACK GLOBAL NODE N, THEN PREPARE DATA FOR TRACK1
C
        XP=X(N)
        YP=Y(N)
        ZP=Z(N)
        NLREN=NLRL(N)
        SDT=DELT
C
C *** DETERMINE HOW TO TRACK THIS POINT
C
        IJUDGE=1
C
   80   CONTINUE
C
        DO 250 I=1,NLREN
          M=LRL(I,N)
          DO I1=1,8
            II=IE(M,I1)
            XX(I1)=X(II)
            YY(I1)=Y(II)
            ZZ(I1)=Z(II)
            VXX(I1)=VX(II)
            VYY(I1)=VY(II)
            VZZ(I1)=VZ(II)
          ENDDO
          DO 90 J=1,8
            IF(N.EQ.IE(M,J))GOTO 100
  90      CONTINUE
 100      CONTINUE
C
          CALL TRACK1H
     I                (XP,YP,ZP,VPX,VPY,VPZ,XX,YY,ZZ,VXX,
     I                 VYY,VZZ,SDT,M,IE,IJUDGE,
     I                 KCOUNT,J,MAXEL,TIM,LUOUT,
     O                 XQ,YQ,ZQ,VQX,VQY,VQZ,N1,N2,N3,N4,
     O                 XSI,ETA,SDT1)
C
          IF(SDT1.EQ.0.)GOTO 500
          IF(SDT1.NE.SDT)GOTO 260
  250   CONTINUE
C
        IF(IJUDGE.EQ.1)THEN
 
          KCOUNT=KCOUNT+1
          IJUDGE=2
          GOTO 80
        ENDIF
C
        IF(IB(N).NE.0)THEN
          DTI(N)=1.0D30
          CS(N)=CS(N)
          GOTO 950
        ENDIF
        WRITE(LUOUT,*)'ERROR MESSAGE 1 AT BTGN --- NODE',N,
     >                ' CAN NOT BE TRACKED'
        WRITE(LUOUT,1006)X(N),Y(N),Z(N),VX(N),VY(N),VZ(N)
        WRITE(LUOUT,1007)XP,YP,ZP,VPX,VPY,VPZ
 1006   FORMAT('X(N)=',F12.6,2X,'Y(N)=',F12.6,2X,'Z(N)=',F12.6,2X,
     >         'VX(N)=',F12.6,2X,'VY(N)=',F12.6,2X,'VZ(N)=',F12.6,2X)
 1007   FORMAT('XP=',F12.6,2X,'YP=',F12.6,2X,'ZP=',F12.6,2X,'VPX=',
     >         F12.6,2X,'VPY=',F12.6,2X,'VPZ=',F12.6,2X)
        WRITE(LUOUT,*)'SDT=',SDT
        STOP
C
C $$$$$ START THE CONSEQUENT TRACKINGS
C
  260   CONTINUE
        SDT=SDT1
        XP=XQ
        YP=YQ
        ZP=ZQ
        VPX=VQX
        VPY=VQY
        VPZ=VQZ
        NN1=N1
        NN2=N2
        NN3=N3
        NN4=N4
C
C ***** CHECK IF POINT P COINSIDES WITH ANY GLOBAL NODES
C
        IF(DABS(XP-X(N1)).LE.EPSX .AND. DABS(YP-Y(N1)).LE.EPSX .AND.
     1     DABS(ZP-Z(N1)).LE.EPSX)THEN
          NN=N1
          NLRNN=NLRL(N1)
        ELSEIF(DABS(XP-X(N2)).LE.EPSX .AND. DABS(YP-Y(N2)).LE.EPSX .AND.
     1     DABS(ZP-Z(N2)).LE.EPSX)THEN
          NN=N2
          NLRNN=NLRL(N2)
        ELSEIF(DABS(XP-X(N3)).LE.EPSX .AND. DABS(YP-Y(N3)).LE.EPSX .AND.
     1     DABS(ZP-Z(N3)).LE.EPSX)THEN
          NN=N3
          NLRNN=NLRL(N3)
        ELSEIF(DABS(XP-X(N4)).LE.EPSX .AND. DABS(YP-Y(N4)).LE.EPSX .AND.
     1     DABS(ZP-Z(N4)).LE.EPSX)THEN
          NN=N4
          NLRNN=NLRL(N4)
        ELSE
          GOTO 400
        ENDIF
C
C ***** YES, P COINSIDES WITH NODE NN, THEN PREPARE DATA FOR TRACK1
C
C
C *** DETERMINE HOW TO TRACK THIS POINT
C
        IJUDGE=1
C
  300   CONTINUE
C
        DO 350 I=1,NLREN
          M=LRL(I,NN)
          DO I1=1,8
            II=IE(M,I1)
            XX(I1)=X(II)
            YY(I1)=Y(II)
            ZZ(I1)=Z(II)
            VXX(I1)=VX(II)
            VYY(I1)=VY(II)
            VZZ(I1)=VZ(II)
          ENDDO
          DO 305 J=1,8
            IF(NN.EQ.IE(M,J))GOTO 310
  305     CONTINUE
C
  310     CONTINUE
C
          CALL TRACK1H
     I                (XP,YP,ZP,VPX,VPY,VPZ,XX,YY,ZZ,VXX,
     I                 VYY,VZZ,SDT,M,IE,IJUDGE,
     I                 KCOUNT,J,MAXEL,TIM,LUOUT,
     O                 XQ,YQ,ZQ,VQX,VQY,VQZ,N1,N2,N3,N4,
     O                 XSI,ETA,SDT1)
C
          IF(SDT1.EQ.0.)GOTO 500
          IF(SDT1.NE.SDT)GOTO 260
  350   CONTINUE
C
        IF(IJUDGE.EQ.1)THEN
          KCOUNT=KCOUNT+1
          IJUDGE=2
          GOTO 300
        ENDIF
C
        IF(IB(NN).NE.0)THEN
          DTREAL=DELT-SDT1
          IF(DTREAL.LE.EPST)THEN
            DTI(N)=1.0D30
          ELSE
            DTI(N)=1.0D0/DTREAL
          ENDIF
          KCOUNT=KCOUNT-1
          CS(N)=(CP(NN)+(CS(NN)-CP(NN))*SDT1/DELT)
          IF(KCOUNT.GT.0)KKOUNT=KKOUNT+1
          GOTO 950
        ENDIF
        WRITE(LUOUT,*)'ERROR MESSAGE 2 AT BTGN --- NODE',N,
     >                ' CAN NOT BE TRACKED'
        WRITE(LUOUT,1006)X(N),Y(N),Z(N),VX(N),VY(N),VZ(N)
        WRITE(LUOUT,1007)XP,YP,ZP,VPX,VPY,VPZ
        WRITE(LUOUT,*)'SDT=',SDT
        STOP
C
C ***** NO, P DOESN'T COINSIDE WITH ANY NODES, THEN PREPARE DATA FOR
C       TRACK2
C
  400   CONTINUE
C *** CHECK IF P IS ON ANY SIDES OF TETRAGON N1,N2,N3,N4
C
        DO 401 I=1,4
          IF(I.EQ.1)THEN
            J1=N1
            J2=N2
          ELSEIF(I.EQ.2)THEN
            J1=N2
            J2=N3
          ELSEIF(I.EQ.3)THEN
            J1=N3
            J2=N4
          ELSE
            J1=N4
            J2=N1
          ENDIF
          A1=X(J2)-X(J1)
          A2=Y(J2)-Y(J1)
          A3=Z(J2)-Z(J1)
          B1=XP-X(J1)
          B2=YP-Y(J1)
          B3=ZP-Z(J1)
          C1=A2*B3-A3*B2
          C2=A3*B1-A1*B3
          C3=A1*B2-A2*B1
          D1=SQRT(C1**2+C2**2+C3**2)
          D2=SQRT(A1**2+A2**2+A3**2)
          IF(D1.LE.EPSX*D2)GOTO 491
  401   CONTINUE
C
C *** NO, IT IS NOT ON ANY SIDE
C
C === CHECK IF N1,N2,N3,N4 ARE ON A BOUNDARY PLANE
C
        KOUNT=0
        NLRN1=NLRL(N1)
        NLRN2=NLRL(N2)
        NLRN3=NLRL(N3)
        NLRN4=NLRL(N4)
        DO 264 I1=1,NLRN1
          M1=LRL(I1,N1)
          DO 263 I2=1,NLRN2
            M2=LRL(I2,N2)
            DO 262 I3=1,NLRN3
              M3=LRL(I3,N3)
              IF(M3.EQ.M2 .AND. M2.EQ.M1)THEN
                KOUNT=KOUNT+1
                IF(M1.NE.M)ME1=M1
              ENDIF
 262        CONTINUE
 263      CONTINUE
 264    CONTINUE
        IF(KOUNT.EQ.1)GOTO 490
C
C === N1,N2,N3,N4 ARE NOT ON A BOUNDARY PLANE
C
C --- ELEMENT M1 IS WHAT WE NEED, THEN CHECK WHICH PLANE POINT P IS
C --- ONTO
C
        ME=M
        M=ME1
C
  431   CONTINUE
C
        DO I1=1,8
          II=IE(M,I1)
          XX(I1)=X(II)
          YY(I1)=Y(II)
          ZZ(I1)=Z(II)
          VXX(I1)=VX(II)
          VYY(I1)=VY(II)
          VZZ(I1)=VZ(II)
        ENDDO
C
  490   CONTINUE
C
        ID=1
c       DO I1=1,8
c         IF(IE(M,I1).EQ.N1)N1=I1
c         IF(IE(M,I1).EQ.N2)N2=I1
c         IF(IE(M,I1).EQ.N3)N3=I1
c         IF(IE(M,I1).EQ.N4)N4=I1
c       ENDDO
C
C *** DETERMINE HOW TO TRACK THIS POINT
C
  484   CONTINUE
        IJUDGE=1
  485   CONTINUE
C
        CALL TRACK2H
     I              (XP,YP,ZP,VPX,VPY,VPZ,XX,YY,ZZ,
     I               VXX,VYY,VZZ,SDT,M,IE,IJUDGE,
     I               ID,MAXEL,TIM,LUOUT,
     M               N1,N2,N3,N4,
     O               XQ,YQ,ZQ,VQX,VQY,VQZ,
     O               XSI,ETA,SDT1)
C
        IF(SDT1.EQ.0.)GOTO 500
        IF(SDT1.NE.SDT)GOTO 260
C
        IF(IJUDGE.EQ.1)THEN
          KCOUNT=KCOUNT+1
          IJUDGE=2
          GOTO 485
        ENDIF
C
C
C *** CHECK IF P IS ON THE BOUNDARY PLANE N1,N2,N3,N4
C
        IF(KOUNT.EQ.1)THEN
          DTREAL=DELT-SDT1
          IF(DTREAL.LE.EPST)THEN
            DTI(N)=1.0D30
          ELSE
            DTI(N)=1.0D0/DTREAL
          ENDIF
          KCOUNT=KCOUNT-1
          C1=CP(NN1)+(CS(NN1)-CP(NN1))*SDT1/DELT
          C2=CP(NN2)+(CS(NN2)-CP(NN2))*SDT1/DELT
          C3=CP(NN3)+(CS(NN3)-CP(NN3))*SDT1/DELT
          C4=CP(NN4)+(CS(NN4)-CP(NN4))*SDT1/DELT
          CS(N)=(0.25*((1-XSI)*(1-ETA)*C1+(1+XSI)*(1-ETA)*C2+
     1                  (1+XSI)*(1+ETA)*C3+(1-XSI)*(1+ETA)*C4))
C
          IF(KCOUNT.GT.0)KKOUNT=KKOUNT+1
          GOTO 950
        ENDIF
C
        IF(M.EQ.ME1)THEN
          M=ME
          GOTO 431
        ENDIF
C
        WRITE(LUOUT,*)'ERROR MESSAGE 3 AT BTGN --- NODE',N,
     >  ' CAN NOT BE TRACKED'
        WRITE(LUOUT,1006)X(N),Y(N),Z(N),VX(N),VY(N),VZ(N)
        WRITE(LUOUT,1007)XP,YP,ZP,VPX,VPY,VPZ
        WRITE(LUOUT,*)'SDT=',SDT
        STOP
C
C *** YES, IT IS ON J1,J2 SIDE
C
  491   CONTINUE
C
        ID=2
        NLRE1=NLRL(J1)
        NLRE2=NLRL(J2)
        KOUNT=0
        DO 493 I1=1,NLRE1
          M1=LRL(I1,J1)
          DO 492 I2=1,NLRE2
            M2=LRL(I2,J2)
            IF(M1.EQ.M2)THEN
              KOUNT=KOUNT+1
              MK(KOUNT)=M1
            ENDIF
  492     CONTINUE
  493   CONTINUE
C
C === DETERMINE HOW TO TRACK THIS POINT
C
        IJUDGE=1
  494   CONTINUE
C
        DO 499 I=1,KOUNT
          M=MK(I)
          DO I1=1,8
            II=IE(M,I1)
            XX(I1)=X(II)
            YY(I1)=Y(II)
            ZZ(I1)=Z(II)
            VXX(I1)=VX(II)
            VYY(I1)=VY(II)
            VZZ(I1)=VZ(II)
          ENDDO
C
c         DO I1=I,8
c           IF(IE(M,I1).EQ.J1)N1=I1
c           IF(IE(M,I1).EQ.J2)N2=I1
c         ENDDO
          n1=j1
          n2=j2
C
          CALL TRACK2H
     I                (XP,YP,ZP,VPX,VPY,VPZ,XX,YY,ZZ,
     I                 VXX,VYY,VZZ,SDT,M,IE,IJUDGE,
     I                 ID,MAXEL,TIM,LUOUT,
     M                 N1,N2,N3,N4,
     O                 XQ,YQ,ZQ,VQX,VQY,VQZ,
     O                 XSI,ETA,SDT1)
C
          IF(SDT1.EQ.0.)GOTO 500
          IF(SDT1.NE.SDT)GOTO 260
  499   CONTINUE
C
        IF(IJUDGE.EQ.1)THEN
          KCOUNT=KCOUNT+1
          IJUDGE=2
          GOTO 494
        ENDIF
C
        IF(IB(J1)*IB(J2).NE.0)THEN
          DTREAL=DELT-SDT1
          IF(DTREAL.LE.EPST)THEN
            DTI(N)=1.0D30
          ELSE
            DTI(N)=1.0D0/DTREAL
          ENDIF
          KCOUNT=KCOUNT-1
          D1=SQRT((XP-X(J1))**2+(YP-Y(J1))**2+(ZP-Z(J1))**2)
          D2=SQRT((X(J2)-X(J1))**2+(Y(J2)-Y(J1))**2+(Z(J2)-Z(J1))**2)
          DLUMDA=D1/D2
          C1=CP(J1)+(CS(J1)-CP(J1))*SDT1/DELT
          C2=CP(J2)+(CS(J2)-CP(J2))*SDT1/DELT
          CS(N)=(C1*(1.-DLUMDA)+C2*DLUMDA)
          IF(KCOUNT.GT.0)KKOUNT=KKOUNT+1
          GOTO 950
        ELSE
          WRITE(LUOUT,*)'ERROR MESSAGE 4 AT BTGN --- NODE',N,
     >                  ' CAN NOT BE TRACKED'
          WRITE(LUOUT,1006)X(N),Y(N),Z(N),VX(N),VY(N),VZ(N)
          WRITE(LUOUT,1007)XP,YP,ZP,VPX,VPY,VPZ
          WRITE(LUOUT,*)'SDT=',SDT
          STOP
        ENDIF
C
C ***** DETERMINE CONCENTRATION
C
  500   CONTINUE
        DO 501 KK=1,8
          K=IE(M,KK)
          IF(DABS(XQ-X(K)).LE.EPSX .AND. DABS(YQ-Y(K)).LE.EPSX .AND.
     >       DABS(ZQ-Z(K)).LE.EPSX)THEN
            CS(N)=CP(K)
            GOTO 900
          ENDIF
  501   CONTINUE
        DO 505 J=1,8
          IEM=IE(M,J)
          CC(J)=CP(IEM)
  505   CONTINUE
C
C ***** DETERMINE PARAMETERS SS,TT,UU IN LOCAL COORDINATE
C
        CALL XSI3D
     I            (LUOUT,XX,YY,ZZ,XQ,YQ,ZQ,M,
     O             SS,TT,UU)
C
C ***** COMPUTE THE BASE FUNCTIONS
C
        SM=1.0D0-SS
        SP=1.0D0+SS
        TM=1.0D0-TT
        TP=1.0D0+TT
        UM=1.0D0-UU
        UP=1.0D0+UU
        DL(1)=0.125D0*SM*TM*UM
        DL(2)=0.125D0*SP*TM*UM
        DL(3)=0.125D0*SP*TP*UM
        DL(4)=0.125D0*SM*TP*UM
        DL(5)=0.125D0*SM*TM*UP
        DL(6)=0.125D0*SP*TM*UP
        DL(7)=0.125D0*SP*TP*UP
        DL(8)=0.125D0*SM*TP*UP
C
C ***** CALCULATE CONCENTRATION OF CS
C
        CS(N)=0.0
        DO 510 I=1,8
          CS(N)=CS(N)+DL(I)*CC(I)
  510   CONTINUE
        IF(KCOUNT.NE.0)KKOUNT=KKOUNT+1
  900   CONTINUE
C
        IF(KCOUNT.NE.0)KKOUNT=KKOUNT+1
 950  CONTINUE
C
      WRITE(LUOUT,*)'--------------------'
      WRITE(LUOUT,960)KKOUNT
 960  FORMAT('NOTE || THERE ARE ',I6,' NODES WHICH ARE NOT TRACKED',
     >       ' WITH THE AVERAGE VELOCITY IN THIS TIME STEP -- IN BTGN')
      RETURN
      END
