      SUBROUTINE DATAIN
     I                 (LUINP,LUOUT,LUFLW,LUBAR,
     O                  KPR,KDSK,TDTCH,PROP,X,Y,Z,IE,CP,DCOSB,ISB,
     O                  NPBB,SOSF,TSOSF,ISTYP,LES,WSSF,TWSSF,IWTYP,
     O                  NPW,QCBF,TQCBF,ICTYP,ISC,NPCB,QNBF,TQNBF,
     O                  INTYP,ISN,NPNB,CVBF,TCVBF,IVTYP,ISV,NPVB,
     O                  CDBF,TCDBF,IDTYP,NPDB,NNPLR,GNLR,TIME,
     O                  nlrl,LRN,LRL,LNOJCN,LMAXDF,NTNPLR)
C
C     + + + PURPOSE + + +
C     To read and print system parameters, geometry, boundary and
C     inital conditions, and properties of solutes and media.
C
C     + + + COMMON BLOCKS + + +
      INCLUDE 'SGEOM.INC'
      INCLUDE 'CGEOM.INC'
      INCLUDE 'LGEOM.INC'
      INCLUDE 'CINTE.INC'
      INCLUDE 'CREAL.INC'
      INCLUDE 'CELS.INC'
      INCLUDE 'CNPS.INC'
      INCLUDE 'CCBC.INC'
      INCLUDE 'CNBC.INC'
      INCLUDE 'CVBC.INC'
      INCLUDE 'CDBC.INC'
      INCLUDE 'MATL.INC'
      INCLUDE 'OPTN.INC'
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER            LUINP,LUOUT,LUFLW,LUBAR,
     >                   KPR(MXNTI),KDSK(MXNTI),IE(MAXEL,9),
     >                   ISB(6,MAXBES),NPBB(MAXBNP),ISTYP(MXSEL),
     >                   LES(MXSEL),IWTYP(MXWNP),NPW(MXWNP),
     >                   ICTYP(MXCES),ISC(5,MXCES),NPCB(MXCNP),
     >                   INTYP(MXNES),ISN(5,MXNES),NPNB(MXNNP),
     >                   IVTYP(MXVES),ISV(5,MXVES),NPVB(MXVNP),
     >                   IDTYP(MXDNP),NPDB(MXDNP),NNPLR(MXREGN),
     >                   LRN(MXJBD,MAXNP),LRL(MXKBD,MAXNP),
     >                   LNOJCN(MXJBD,LMXNP,MXREGN),LMAXDF(MXREGN),
     >                   NTNPLR(MXREGN),nlrl(maxnp),
     >                   GNLR(LTMXNP,MXREGN)
      DOUBLE PRECISION   TDTCH(MXDTC),PROP(MXMPPM,MAXMAT),X(MAXNP),
     >                   Y(MAXNP),Z(MAXNP),CP(MAXNP),DCOSB(3,MAXBES),
     >                   SOSF(MXSDP,MXSPR,2),TSOSF(MXSDP,MXSPR),
     >                   WSSF(MXWDP,MXWPR,2),TWSSF(MXWDP,MXWPR),
     >                   QCBF(MXCDP,MXCPR),TQCBF(MXCDP,MXCPR),
     >                   QNBF(MXNDP,MXNPR),TQNBF(MXNDP,MXNPR),
     >                   CVBF(MXRDP,MXRPR),TCVBF(MXRDP,MXRPR),
     >                   CDBF(MXDDP,MXDPR),TCDBF(MXDDP,MXDPR),
     >                   TIME
C
C     + + + ARGUMENT DEFINITIONS + + +
C     LUINP  - logical unit for input data
C     LUOUT  - logical unit for output data
C     LUFLW  - logical unit for flow data
C     LUBAR  - logical unit for store binary boundary arrays
C --- Time Control Arrays
C     KPR(I)   - line printing indicator for the I-th time step
C                 0 = print nothing
C                 1 = print fluxes through all types of boundaries
C                 2 = print concentration also
C                 3 = print mateiral flux also
C     KDSK(I)  - store results on logical unit 12? 0=no, 1=yes
C     TDTCH(I) - time of the I-th time to reset time-step size = DELT0
C --- Material Arrays
C     PROP(J,I) - J-the material property of the I-th material
C                 PROP(1,I) = distribution coefficient or
C                             Freundlich K or Langmuir K
C                 PROP(2,I) = bulk density
C                 PROP(3,I) = longitudinal dispersivity
C                 PROP(4,I) = lateral dispersivity
C                 PROP(5,I) = molecular diffusion coefficient
C                 PROP(6,I) = tortuosity
C                 PROP(7,I) = decay constant
C                 PROP(8,I) = Freundlich N or Langmuir SMAX
C --- Arrays of Discretization
C     X(N)     - x-coordiante of the N-th node
C     Y(N)     - y-coordinate of the N-th node
C     Z(N)     - z-coordinate of the N-th node
C     IE(M,I)  - global node number of the I-th node of the M-th element
C                if I is between 1 and 8
C     IE(M,9)  - integer to indicate the material type of the M-th
C                element
C     LRN(I,N) - global node number of the I-th node connecting
C                to the N-th global node
C     LRL(I,N) - global element number of the I-th element connecting
C                to the N-th global node
C     NLRL(N)  - total number of elements connecting to the N-th global
C                node
C --- Solution Arrays for Concentrations and Fluxes
C     CP(N)    - Concentration of the N-th node at previous time
C --- Boundary Arryas
C     DCOSB(1,I) - x-directional cosine of the I-th boundary side
C     DCOSB(2,I) - y-directional cosine of the I-th boundary side
C     DCOSB(3,I) - z-directional cosine of the I-th boundary side
C     ISB(1,I)   - boundary node number of the first node of the I-th
C                  boundary side
C     ISB(2,I)   - boundary node number of the second node of the I-th
C                  boundary side
C     ISB(3,I)   - boundary node number of the third node of the I-th
C                  boundary side
C     ISB(4,I)   - boundary node number of the fourth node of the I-th
C                  boundary side
C     ISB(5,I)   - element side index of the I-th boundary side
C                  1=left side, 2=front side, 3=right side,
C                  4=back side, 5=bottom side, 6=top side
C     ISB(6,I)   - element number to which the I-th boundary side belong
C     NPBB(I)    - global node number of the I-the boundary node
C --- Source Arrays
C     SOSF(I,J,1) - source flow rate of the I-th data point in
C                   the J-th profile
C     SOSF(I,J,2) - source concentration of the I-th data point in
C                   the J-th profile
C     TSOSF(I,J)  - time of the I-th data point in the J-the profile
C     ISTYP(M)    - type of source profile assigned to the M-th element
C     LES(I)      - global element number of the I-th element-source
C     WSSF(J,I,1) - well-source flow rate of the I-th data point in
C                   the J-th profile
C     WSSF(J,I,2) - well-source concentration of the I-th data point in
C                   the J-th profile
C     TWSSF(J,I)  - time of the J-th data point in the J-th profile
C     IWTYP(I)    - type of source profile assigned to the I-th node
C     NPW(I)      - global node number of the I-th well node
C --- Cauchy Boundary Condition Arrays
C     QCBF(I,J)  - Flux of the I-th data point in the J-th
C                  Cauchy flux vs time profile
C     TQCBF(I,J) - time of the I-th data point in the J-th
C                  Cauchy flux vs time profile
C     ICTYP(MP)  - type of Cauchy flux profile assigned to the MP-th
C                  Cauchy side
C     ISC(1,MP)  - global node number of the first node of the Mp-th
C                  Cauchy side
C     ISC(2,MP)  - global node number of the second node of the Mp-th
C                  Cauchy side
C     ISC(3,MP)  - global node number of the third node of the Mp-th
C                  Cauchy side
C     ISC(4,MP)  - global node number of the fourth node of the Mp-th
C                  Cauchy side
C     ISC(5,MP)  - boundary side number of the MP-th Cauchy side
C     NPCB(NP)   - global nodal number of the NP-Cauchy node on input
C                  Then is changed to contain boundary node number
C --- Neumann Boundary Arrays
C     QNBF(I,J)  - Flux of the I-th data point in the J-th
C                  Neumann flux vs time profile
C     TQNBF(I,J) - time of the I-th data point in the J-th
C                  Neumann flux vs time profile
C     INTYP(MP)  - type of Neumann flux profile assigned to the MP-th
C                  Neumann side
C     ISN(1,MP)  - global node number of the first node of the Mp-th
C                  Neumann side
C     ISN(2,MP)  - global node number of the second node of the Mp-th
C                  Neumann side
C     ISN(3,MP)  - global node number of the third node of the Mp-th
C                  Neumann side
C     ISN(4,MP)  - global node number of the fourth node of the Mp-th
C                  Neumann side
C     ISN(5,MP)  - boundary side number of the MP-th Neumann side
C     NPNB(NP)   - global nodal number of the NP-Neumann node on input
C                  Then is changed to contain boundary node number
C --- Variable Boundary Arrays
C     CVBF(I,J)  - concentration of the I-th data point in the J-th
C                  variable concentration vs time profile
C     TCVBF(I,J) - time of the I-th data point in the J-th
C                  variable concentration vs time profile
C     IVTYP(MP)  - type of variable concentration profile assigned to
C                  the MP-th variable side
C     ISV(1,MP)  - global node number of the first node of the Mp-th
C                  Variable side
C     ISV(2,MP)  - global node number of the second node of the Mp-th
C                  variable side
C     ISV(3,MP)  - global node number of the third node of the Mp-th
C                  variable side
C     ISV(4,MP)  - global node number of the fourth node of the Mp-th
C                  variable side
C     ISV(5,MP)  - boundary side number of the MP-th variable side
C     NPVB(NP)   - global nodal number of the NP-variable node on input
C                  Then is changed to contain boundary node number
C --- Dirichlet Boundary Arrays
C     CDBF(I,J)  - concentration of the I-th data point in the J-th
C                  Dirichlet concentration vs time profile
C     TCDBF(I,J) - time of the I-th data point in the J-th
C                  Dirichlet concentration vs time profile
C     IDTYP(NP)  - type of Dirichlet concentration profile assigned to
C                  the NP-th Dirichlet node
C     NPDB(NP)   - global nodal number of the NP-Dirichlet node on input
C                  Then is changed to contain boundary node number
C --- Subregion Arrays
C     NNPLR(K)      - number of nodes for the K-th subregion including
C                     interior and global boundary nodes
C     GNLR(I,K)     - global nodal number of the I-th local nodal
C                     number in the K-th subregion.  This array is an
C                     input for I = 1, 2, ..,  NNPLR(K).
C                     For = NNPLR(K)+1, ... NTNPLR(K), this array is
C                     generated based on IE(NEL,8) and inputted GNLR.
C     LNOJCN(J,I,K) - local node number of the J-th node connecting to
C                     the I-th local node for the K-th subregion.
C                     This array is genereated from GNLR and IE.
C                     I = 1, 2, 3, ...., NNPLR(K).
C     TIME  - time
C
C     + + + LOCAL VARIABLES + + +
      INTEGER            I,J,NPROBM,NTIM,N,M,NPI,NI,NSEQ,NIAD,NJ,NP,MMP,
     >                   MI,MIAD,IEMAD,MJ,MP,IQ,LINE,NJMN,NJMX,K,LNNP,
     >                   MTYP,MPI,I1,I2,I3,I4,I1AD,I2AD,I3AD,I4AD,JQ,
     >                   IJ,IEQ,NII,IEM(8),NIMI(4),NJMJ(4),
     >                   IQDO,JQDO,MJDO
      DOUBLE PRECISION   XI,YI,ZI,XIAD,YIAD,ZIAD
      CHARACTER TITLEM*70, DATNAM*1
C
C     + + + INTRINSICS + + +
      INTRINSIC    DBLE,MOD,MIN0
C
C     + + + EXTERNALS + + +
      EXTERNAL     SURF,PAGEN,READN,READR
C
C     + + + INPUT FORMATS + + +
 1000 FORMAT(A1)
 1010 FORMAT(80I1)
C
C     + + + OUTPUT FORMATS + + +
 2000 FORMAT('0     **** BASIC INTEGER PARAMETERS ****'/5X,
     > 'NO. OF NODAL POINTS, NNP . . . . . . . . . . . . .',I5/5X,
     > 'NO. OF ELEMENTS, NEL . . . . . . . . . . . . . . .',I5/5X,
     > 'NO. OF DIFFERENT MATERIALS, NMAT . . . . . . . . .',I5/5X,
     > 'NO. OF ELEMENTS CORRECTED FOR MATERIALS, NCM . . .',I5/5X,
     > 'NO. OF TIME INCREMENTS, NTI  . . . . . . . . . . .',I5/5X,
     > 'STEADY STATE CONTROL, KSS  . . . . . . . . . . . .',I5/5X,
     > 'NO. OF MATERIAL PROPERTIES PER MATERIAL, NMPPM . .',I5/5X,
     > 'VELOCITY INPUT CONTROL, KVI  . . . . . . . . . . .',I5/5X,
     > 'LUMPING INDICATOR, ILUMP . . . . . . . . . . . . .',I5/5X,
     > 'UPSTREAM WEIGHTING INDICATOR, IWET . . . . . . . .',I5/5X,
     > 'WEIGHTING FACTOR OPTIMIZING INDICATOR, IOPTIM  . .',I5/5X,
     > 'NO. OF ITERATIONS TO SOLVE NONLINEAR EQ., NITER  .',I5/5X,
     > 'NO. OF TIMES TO RESET INITIAL DELT, NDTCHG . . . .',I5/5X,
     > 'NO. OF BLOCK ITERATIONS ALLOWED, NPITER  . . . . .',I5/5X,
     > 'SORPTION MODEL CONTROL, KSROP  . . . . . . . . . .',I5/)
 2010 FORMAT(///5X,
     > ' TIME INCREMENT. . . . . . . . . . . . .',E15.6/ 5X,
     > ' MULTIPLIER FOR INCREASING DELT. . . . .',E15.6/ 5X,
     > ' MAXIMUM VALUE OF DELT . . . . . . . . .',E15.6/ 5X,
     > ' MAXIMUM VALUE OF TIME . . . . . . . . .',E15.6/ 5X,
     > ' ITERATION PARAMETER FOR NONLINEAR EQ. .',E15.6/ 5X,
     > ' RELAXATION PARAMETER FOR POINTWISE SOL.',E15.6/ 5X,
     > ' ERROR ALLOWANCE FOR STEADY STATE SOL  .',E15.6/ 5X,
     > ' ERROR ALLOWANCE FOR TRANSIENT SOL . . .',E15.6/)
 2020 FORMAT(//1X,' LINE-PRINT OUTPUT CONTROL')
 2030 FORMAT((1X,30I2))
 2040 FORMAT(//1X,' WRITE ON DISK CONTROL')
 2050 FORMAT(//1X,' TIME OF CHANGING DELT'/(1X,5D12.4))
 2060 FORMAT('1'/1X,' **** MATERIAL PROPERTIES ***'//1X,
     > 'MAT. NO.    KD       RHOB       AL        AT        AM    '/1X,
     > '-------- --------  --------  --------  --------  -------- '/1X,
     > '            TAU     LAMADA   N OR SMAX '/1X,
     > '         --------  --------  --------- '//)
 2070 FORMAT(1X,I8, 5(1PD10.3)/1X,8X, 3(1PD10.3))
 2080 FORMAT(///1X,'*** ERROR: TOTAL NUMBER OF NODES READ .NE. NNP',
     > ' - STOP ***')
 2090 FORMAT(///1X,'*** ERROR: TOTAL NODAL NUMBER .GT. MAXNP',
     > ' - STOP ***')
 2100 FORMAT(///1X,'*** ERROR: TOTAL NUMBER OF ELEMENTS READ .NE. ',
     > 'NEL - STOP ***')
 2110 FORMAT(///1X,'*** ERROR: TOTAL NUMBER OF ELEMENTS .GT. MAXEL',
     > ' - STOP ***')
 2120 FORMAT('1     **** NODAL COORDINATE ****'//1X,
     > 2(1X,' NODE     X          Y          Z     ',1X)/1X,
     > 2(1X,' **** ********** ********** **********',1X))
 2130 FORMAT(' ',2(1X,I5,3(1PD11.3),1X))
 2140 FORMAT('1'/5X,' *** OUTPUT GNLR(I,K) ',10X,' NREGN =',I3,' ***')
 2150 FORMAT(/5X,' ---- SUBREGION NUMBER K =',I4/(6X,10I5))
 2160 FORMAT('1'//1X,'*** ELEMENT INCIDENCES AND MATERIAL TYPE ***'//1X,
     > '  ELM NOD1 NOD2 NOD3 NOD4 NOD5 NOD6 NOD7 NOD8 MTYP'/1X,
     > '  --- ---- ---- ---- ---- ---- ---- ---- ---- ----')
 2170 FORMAT(1X,10I5)
 2180 FORMAT(///1X,' ERROR IN MATERIAL TYPE FOR ELEMENT',I4,'  STOP')
 2190 FORMAT('1'/1X,'*** S/S AND B. C. CONTROL INTEGERS ***'//5X,
     > 'NO. OF ELEMENT-SOURCE/SINK ELEMENTS . . . . . . . . . .',I5/5X,
     > 'NO. OF ELEMENT-SOURCE/SINK PROFILES . . . . . . . . . .',I5/5X,
     > 'NO. OF DATA POINTS ON ELEMENT-SOURCE/SINK PROFILES  . .',I5/5X,
     > 'ANALYTICAL ELEMENT-SOURCE/SINK INPUT CONTROL  . . . . .',I5//5X,
     > 'NO. OF WELL-SOURCE/SINK NODAL POINTS  . . . . . . . . .',I5/5X,
     > 'NO. OF WELL-SOURCE/SINK PROFILES  . . . . . . . . . . .',I5/5X,
     > 'NO. OF DATA POINTS ON WELL-SOURCE/SINK PROFILES . . . .',I5/5X,
     > 'ANALYTICAL WELL-SOURCE/SINK INPUT CONTROL . . . . . . .',I5//5X,
     > 'NO. OF DIRICHLET NODAL POINTS . . . . . . . . . . . . .',I5/5X,
     > 'NO. OF DIRICHELT CONCENTRATION PROFILES . . . . . . . .',I5/5X,
     > 'NO. OF DATA POINTS ON DIRICHELT CONCENTRATION PROFILES.',I5/5X,
     > 'ANALYTICAL DIRICHLET BV INPUT CONTROL . . . . . . . . .',I5//)
 2200 FORMAT(' '/5X,
     > 'NO. OF VARIABLE BOUNDARY ELEMENT SIDES  . . . . . . . .',I5/5X,
     > 'NO. OF VARIABLE BOUNDARY NODAL POINTS . . . . . . . . .',I5/5X,
     > 'NO. OF VARIABLE FLUX PROFILES . . . . . . . . . . . . .',I5/5X,
     > 'NO. OF DATA POINTS ON VARIABLE FLUX PROFILES. . . . . .',I5/5X,
     > 'ANALYTICAL VARIABLE FLUX INPUT CONTROL  . . . . . . . .',I5//5X,
     > 'NO. OF CAUCHY BOUNDARY ELEMENT SIDES  . . . . . . . . .',I5/5X,
     > 'NO. OF CAUCHY BOUNDARY NODAL POINTS . . . . . . . . . .',I5/5X,
     > 'NO. OF CAUCHY FLUX PROFILES   . . . . . . . . . . . . .',I5/5X,
     > 'NO. OF DATA POINTS ON CAUCHY FLUX PROFILES  . . . . . .',I5/5X,
     > 'ANALYTICAL CAUCHY FLUX INPUT CONTROL  . . . . . . . . .',I5//5X,
     > 'NO. OF NEUMANN BOUNDARY ELEMENT SIDES . . . . . . . . .',I5/5X,
     > 'NO. OF NEUMANN BOUNDARY NODAL POINTS  . . . . . . . . .',I5/5X,
     > 'NO. OF NEUMANN FLUX PROFILES  . . . . . . . . . . . . .',I5/5X,
     > 'NO. OF DATA POINTS ON NEUMANN FLUX PROFILES . . . . . .',I5/5X,
     > 'ANALYTICAL NEUMANN FLUX INPUT CONTROL . . . . . . . . .',I5//)
 2210 FORMAT('1'/5X,' *** ELEMENT SOURCE INFORMATION ***')
 2220 FORMAT(//5X,' PROFILE NO.',I2,//2('    TIME        SOSQ  ',
     > '     SOSC  ')/2('     -----      SOSQ       SOSQC  '))
 2230 FORMAT(' ',2(3D11.3))
 2240 FORMAT(///9X,'ELEMENT NUMBER AND PROFILE TYPES OF SOURCE'//5X,
     > 3('    I  LES STYP',5X)/5X,3('    -  --- ----',5X))
 2250 FORMAT(' ',4X,3(3I5,5X))
 2260 FORMAT(////5X,' *** WELL SOURCE/SINK INFORMATION ***')
 2270 FORMAT(//5X,' PROFILE NO.',I2//2('     TIME       WSSQ  ',
     > '     WSSC  ')/2('     ----       ----       ----  '))
 2280 FORMAT(///10X,' NODEL NUMBER AND PROFILE TYPE OF SOURCE'//5X,
     > 3('    I  NPW  TYP',5X)/5X,3('    -  ---  ----',5X))
 2290 FORMAT(' ',4X,3(3I5,5X))
 2300 FORMAT('1'/5X,' **** VARIABLE BOUNDARY CONDITIONS ****')
 2310 FORMAT(////10X,
     > ' --- INCOMING FLUID CONCENTRATION PROFILE ---')
 2320 FORMAT(//5X,' PROFILE NO.',I2//3(4X,'TIME',6X,' RCIN ',2X)/
     > 3(4X,'----',6X,' ---- ',2X))
 2330 FORMAT(' ',3(2D11.3))
 2340 FORMAT('1'/5X,' ERROR IN READING VB-ELEMENT-SIDES')
 2350 FORMAT(////10X,' --- INPUTTED VB SIDE INFORMATION ---'//5X,
     > 2('   MP  GN1  GN2  GN3  GN4 CTYP',5X)/5X,
     > 2('   --  ---  ---  ---  --- ----',5X))
 2360 FORMAT(' ',4X,2(6I5,5X))
 2370 FORMAT(//10X,' --- INPUTTED VARIABLE NODE DATA ---'//5X,
     > 6('    I NPVB  ')/5X,6('    - ----  '))
 2380 FORMAT(' ',4X,6(2I5,2X))
 2390 FORMAT('1'/5X,' CANNOT FIND A BOUNDARY SIDE COINCIDING WITH',
     > I3,'-TH VARIABLE BOUNDARY SIDE: STOP ***')
 2400 FORMAT('1'/5X,' *** CANNOT FIND A BOUNDARY NODAL NUMBER FOR',
     > I3,'-TH VARIABLE BOUNDARY NODE: STOP')
 2410 FORMAT(///10X,' --- COMPUTTED BOUNDARY NODE NUMBER OF VB NODE'//
     > 5X,6('    I NPVB',2X)/5X,6('    - ----',2X))
 2420 FORMAT('1'/5X,' **** DIRICHLET BOUNDARY CONDITIONS ****')
 2430 FORMAT(//5X,' PROFILE NO.',I2,//3(4X,'TIME',6X,' CONC ',2X)/
     > 3(4X,'----',6X,' ---- ',2X))
 2440 FORMAT(///10X,' GLOBAL NODAL NUMBER AND PROFILE TYPE OF ',
     > 'DIRICHLET BOUNDARY NODES'//5X,3('    I NPDB DTYP',5X)/5X,
     > 3('    - ---- ----',5X))
 2450 FORMAT(' ',4X,3(3I5,5X))
 2460 FORMAT('1'/5X,' **** CAUCHY  BOUNDARY CONDITIONS ****')
 2470 FORMAT(//5X,' PROFILE NO.',I2//3(4X,'TIME',6X,' FLUX ',2X)/
     > 3(4X,'----',6X,' ---- ',2X))
 2480 FORMAT(/,10X,' *** ERROR IN READING CAUCHY BOUNDARY ELEMENT',
     > ' SIDE: STOP ***')
 2490 FORMAT(//10X,' --- INPUTTED CAUCHY SIDE DATA ---'//5X,
     > 2('   MP  GN1  GN2  GN3  GN4 CTYP',5X)/5X,
     > 2('   --  ---  ---  ---  --- ----',5X))
 2500 FORMAT(//10X,' --- INPUTTED CAUCHY NODE DATA ---'//5X,
     > 6('    I NPCB',2X)/5X,16('    - ----',2X))
 2510 FORMAT('1'/5X,' CANNOT FIND A BOUNDARY SIDE COINCIDING WITH',
     > I3,'-TH CAUCHY SIDE: STOP ***')
 2520 FORMAT('1'/5X,' *** CANNOT FIND A BOUNDARY NODAL NUMBER FOR',
     > I3,'-TH CAUCHY BOUNDARY NODE:  STOP')
 2530 FORMAT(//10X,' --- COMPUTED CAUCHY NODE DATA ---'//5X,
     > 6('    I NPCB',2X)/5X,6('    - ----',2X))
 2540 FORMAT('1'/5X,' **** NEUMANN BOUNDARY CONDITIONS ****')
 2550 FORMAT(//5X,' PROFILE NO.',I2//3(4X,'TIME',6X,' FLUX ',2X)/
     > 3(4X,'----',6X,' ---- ',2X))
 2560 FORMAT(/,10X,' *** ERROR IN READING NEUMANN BOUNDARY ELEMENT',
     > ' SIDE: STOP ***')
 2570 FORMAT(//10X,' --- INPUTTED NEUMANN SIDE DATA ---'//5X,
     > 2('   MP  GN1  GN2  GN3  GN4 CTYP',5X)/5X,
     > 2('   --  ---  ---  ---  --- ----',5X))
 2580 FORMAT(//10X,' --- INPUTTED NEUMANN NODE DATA ---'//5X,
     > 6('    I NPCB',2X)/5X,6('    - ----',2X))
 2590 FORMAT('1'/5X,' CANNOT FIND A BOUNDARY SIDE COINCIDING WITH',
     > I3,'-TH NEUMANN SIDE: STOP ***')
 2600 FORMAT('1'/5X,' *** CANNOT FIND A BOUNDARY NODAL NUMBER FOR',
     > I3,'-TH NEUMANN BOUNDARY NODE: STOP')
 2610 FORMAT(//10X,' --- COMPUTED NEUMANN NODE DATA ---'//5X,
     > 6('    I NPCB',2X)/5X,6('    - ----',2X))
C
C     + + + END SPECIFICATIONS + + +
C
C
C ******* DATA SET 2: basic integers
C
      READ(LUINP,1000) DATNAM
      READ(LUINP,*) NNP,NEL,NMAT,NCM,NTI,KSS,NMPPM,KVI,ILUMP,
     >           IWET,IOPTIM,NITER,NDTCHG,NPITER,KSORP
C
      IF (NDTCHG .LE. 0) THEN
        NDTCHG = 1
      END IF
C
      WRITE(LUOUT,2000) NNP,NEL,NMAT,NCM,NTI,KSS,NMPPM,KVI,ILUMP,
     >               IWET,IOPTIM,NITER,NDTCHG,NPITER,KSORP
C
C ******* DATA SET 3: basic real parameters
C
      READ(LUINP,1000) DATNAM
      READ(LUINP,*) DELT,CHNG,DELMAX,TMAX,OME,OMI,TOLA,TOLB
C
      IF (TMAX .LE. 0.0) THEN
        TMAX = 1.0D38
      END IF
C
      DELT0 = DELT
      WRITE(LUOUT,2010) DELT,CHNG,DELMAX,TMAX,OME,OMI,TOLA,TOLB
C
C ******* DATA SET 4: printer and auxiliary storage control
C
      READ(LUINP,1000) DATNAM
      READ(LUINP,1010) KPR0,(KPR(I),I = 1,NTI)
      WRITE(LUOUT,2020)
      WRITE(LUOUT,2030) KPR0,(KPR(I),I = 1,NTI)
      READ(LUINP,1010) KDSK0,(KDSK(I),I = 1,NTI)
      WRITE(LUOUT,2040)
      WRITE(LUOUT,2030) KDSK0,(KDSK(I),I = 1,NTI)
      READ(LUINP,*) (TDTCH(I),I = 1,NDTCHG)
      WRITE(LUOUT,2050) (TDTCH(I),I = 1,NDTCHG)
C
C ******* DATA SET 5: material properties
C
      READ(LUINP,1000) DATNAM
      WRITE(LUOUT,2060)
      DO 110 I = 1,NMAT
        READ(LUINP,*) (PROP(J,I),J = 1,NMPPM)
        WRITE(LUOUT,2070) I,(PROP(J,I),J = 1,NMPPM)
  110 CONTINUE
C
C $$$ Begin of reading geometric data
      IF (KVI .GT. 0) THEN
C       read node, element, and subregion data via unit 11 if KVI.GT.0
        REWIND(UNIT=LUFLW)
        READ(LUFLW) TITLEM,NPROBM,NNP,NEL,NBNP,NBES,NTIM,NREGN
        READ(LUFLW) (X(N),N = 1,NNP),(Y(N),N = 1,NNP),(Z(N),N = 1,NNP),
     >           ((IE(M,I),M = 1,NEL),I = 1,9),((DCOSB(I,M),I = 1,3),
     >           M = 1,NBES),((ISB(I,M),I = 1,6),M = 1,NBES),(NPBB(N),
     >           N = 1,NBNP),(NNPLR(N),N = 1,NREGN),((GNLR(N,I),N = 1,
     >           LTMXNP),I = 1,NREGN)
      ELSE
C
C ******* DATA SET 6: node coordinate via card if KVI.LE.0
C
        NPI = 0
        READ(LUINP,1000) DATNAM
  205   CONTINUE
          READ(LUINP,*) NI,NSEQ,NIAD,XI,YI,ZI,XIAD,YIAD,ZIAD
          IF (NI .NE. 0) THEN
            NJ = NI + NSEQ
            DO 210 NP = NI,NJ
              I    = NI + NIAD*(NP - NI)
              X(I) = XI + XIAD*DBLE(NP - NI)
              Y(I) = YI + YIAD*DBLE(NP - NI)
              Z(I) = ZI + ZIAD*DBLE(NP - NI)
              NPI  = NPI + 1
  210       CONTINUE
            GO TO 205
          END IF
C
        IF (NPI .NE. NNP) THEN
C         print error message and stop
          WRITE(LUOUT,2080)
          STOP
        END IF
        IF (NPI .GT. MAXNP) THEN
C         print error message and stop
          WRITE(LUOUT,2090)
          STOP
        END IF
C
C ******* DATA SET 7: element incidences via card if KVI.LE.0
C
        READ(LUINP,1000) DATNAM
        MMP = 0
  230   CONTINUE
          READ(LUINP,*) MI,NSEQ,MIAD,(IEM(I),I = 1,8),IEMAD
          IF (MI .NE. 0) THEN
            MJ = MI + NSEQ
            DO 240 MP = MI,MJ
              M = MI + (MP - MI)*MIAD
              DO 235 IQ = 1,8
                NI       = IEM(IQ) + (MP - MI)*IEMAD
                IE(M,IQ) = NI
  235         CONTINUE
              MMP = MMP + 1
  240       CONTINUE
            GO TO 230
          END IF
C
        IF (MMP .NE. NEL) THEN
C         print error message and stop
          WRITE(LUOUT,2100) MMP, NEL
          STOP
        END IF
        IF (MMP .GT. MAXEL) THEN
C         print error message and stop
          WRITE(LUOUT,2110)
          STOP
        END IF
C
C       Set material type to 1 for all elements
        DO 285 M = 1,NEL
          IE(M,9) = 1
  285   CONTINUE
C
C       Print node coordinate
        IF (MOD(IGEOM,2) .NE. 0) THEN
          LINE = 0
          DO 310 NP = 1,NNP,2
            NJMN = NP
            NJMX = MIN0(NP + 1,NNP)
            LINE = LINE + 1
            IF (MOD(LINE - 1,50) .EQ. 0) THEN
              WRITE(LUOUT,2120)
            END IF
            WRITE(LUOUT,2130) (NJ,X(NJ),Y(NJ),Z(NJ),NJ = NJMN,NJMX)
  310     CONTINUE
        END IF
C
C
C ******* DATA SET 8: subregional data vis card if KVI.LE.0
C
        READ(LUINP,1000) DATNAM
        READ(LUINP,*) NREGN
        CALL READN
     I            (LUINP,LUOUT,MXREGN,NREGN,
     O             NNPLR)
        IF (MOD(IGEOM,2) .NE. 0) THEN
          WRITE(LUOUT,2140) NREGN
        END IF
        DO 320 K = 1,NREGN
          LNNP = NNPLR(K)
          CALL READN
     I              (LUINP,LUOUT,LTMXNP,LNNP,
     O               GNLR(1,K))
C
          IF (MOD(IGEOM,2) .NE. 0) THEN
C           print mapping between global and local nodes
            WRITE(LUOUT,2150) K,(GNLR(I,K),I = 1,LNNP)
          END IF
  320   CONTINUE
C
        IF(IGEOM .LE. 3) THEN
          CALL PAGEN
     I              (IE,NNPLR,LUOUT,
     M               GNLR,
     O               NLRL,LRN,LRL,LNOJCN,LMAXDF,NTNPLR)
        END IF
        IF (IGEOM .LE. 1) THEN
C         identify boundary elements and compute directional cosines of
C         boundary sides if geometrics are read via cards
          CALL SURF
     I             (LUOUT, X,Y,Z,IE,lrl,
     O              DCOSB,ISB,NPBB)
        END IF
C
        REWIND(UNIT=LUBAR)
        IF (IGEOM .LE. 1) THEN
C         write boundary arrays onto logical unit LUBAR
          WRITE(LUBAR) NBES,NBNP,((DCOSB(J,I),J = 1,3),I = 1,NBES),
     >              ((ISB(J,I),J = 1,6),I = 1,NBES),(NPBB(I),I = 1,NBNP)
        END IF
        IF (IGEOM .GT. 1) THEN
C         read boundary arrays from logical unit LUBAR
          READ(LUBAR) NBES,NBNP,((DCOSB(J,I),J = 1,3),I = 1,NBES),
     >             ((ISB(J,I),J = 1,6),I = 1,NBES),(NPBB(I),I = 1,NBNP)
        END IF
C
C ******* DATA SET 9: material corrections via card if KVI.LE.0
C
        IF (NCM .GT. 0) THEN
          READ(LUINP,1000) DATNAM
          CALL READN
     I              (LUINP,LUOUT,MAXEL,NCM,
     O               IE(1,9))
        END IF
C
C       Print element information
        IF (MOD(IGEOM,2) .NE. 0) THEN
          LINE = 0
          DO 340 NI = 1,NEL
            LINE = LINE + 1
            IF (MOD(LINE - 1,50) .EQ. 0) THEN
              WRITE(LUOUT,2160)
            END IF
            WRITE(LUOUT,2170) NI,(IE(NI,K),K = 1,9)
  340     CONTINUE
        END IF
C
C       Check material types for each element
        DO 420 M = 1,NEL
          MTYP = IE(M,9)
          IF (MTYP .LE. 0 .OR. MTYP .GT. NMAT) THEN
C           print error message and stop
            WRITE(LUOUT,2180) M
            STOP
          END IF
  420   CONTINUE
C
C $$$ End of reading geometric data
      END IF
C
C ******* DATA SET 10: Initial or pre-initial conditions
C
      TIME = 0.0
      READ(LUINP,1000) DATNAM
      CALL READR
     I          (LUINP,LUOUT,MAXNP,NNP,
     O           CP)
C
C ******* DATA SET 11: control integers for transient input
C
      READ(LUINP,1000) DATNAM
      READ(LUINP,*) NSEL,NSPR,NSDP,KSAI,NWNP,NWPR,NWDP,KWAI,NDNP,NDPR,
     >           NDDP,KDAI,NVES,NVNP,NRPR,NRDP,KRAI,NCES,NCNP,
     >           NCPR,NCDP,KCAI,NNES,NNNP,NNPR,NNDP,KNAI
C
      WRITE(LUOUT,2190) NSEL,NSPR,NSDP,KSAI,NWNP,NWPR,NWDP,KWAI,
     >               NDNP,NDPR,NDDP,KDAI
      WRITE(LUOUT,2200) NVES,NVNP,NRPR,NRDP,KRAI,NCES,NCNP,NCPR,NCDP,
     > KCAI,NNES,NNNP,NNPR,NNDP,KNAI
C
C ******* DATA SET 12: Source/sink
C
      IF (NSEL .NE. 0 .OR. NWNP .NE. 0) THEN
C       read dataname for source/sink
        READ(LUINP,1000) DATNAM
      END IF
C
C     element source
      IF (NSEL .NE. 0) THEN
        WRITE(LUOUT,2210)
C       profile data
        DO 510 I = 1,NSPR
          READ(LUINP,*) (TSOSF(J,I),SOSF(J,I,1),SOSF(J,I,2),J = 1,NSDP)
          WRITE(LUOUT,2220) I
          WRITE(LUOUT,2230) (TSOSF(J,I),SOSF(J,I,1),SOSF(J,I,2),
     >                       J = 1,NSDP)
  510   CONTINUE
C       source element
        READ(LUINP,*) (LES(I),I = 1,NSEL)
C       profile type assigned to each element
        CALL READN
     I            (LUINP,LUOUT,MXSEL,NSEL,
     O             ISTYP)
C       print source data
        WRITE(LUOUT,2240)
        WRITE(LUOUT,2250) (I,LES(I),ISTYP(I),I = 1,NSEL)
      END IF
C
C     well source
      IF (NWNP .NE. 0) THEN
C       profile data
        WRITE(LUOUT,2260)
        DO 580 I = 1,NWPR
          READ(LUINP,*) (TWSSF(J,I),WSSF(J,I,1),WSSF(J,I,2),J = 1,NWDP)
          WRITE(LUOUT,2270) I
          WRITE(LUOUT,2230) (TWSSF(J,I),WSSF(J,I,1),WSSF(J,I,2),
     >                       J = 1,NWDP)
  580   CONTINUE
C
C       well source nodes
        READ(LUINP,*) (NPW(I),I = 1,NWNP)
C       profile type assigned to each well source node
        CALL READN
     I            (LUINP,LUOUT,MXWNP,NWNP,
     O             IWTYP)
C
C       print well source data
C       to well nodes
        WRITE(LUOUT,2280)
        WRITE(LUOUT,2290) (I,NPW(I),IWTYP(I),I = 1,NWNP)
      END IF
C
C ******* DATA SET 13: variable boundary conditions
C
      IF (NVES .GT. 0) THEN
        READ(LUINP,1000) DATNAM
        WRITE(LUOUT,2300)
C
C       read and print variable-concentration profiles
        WRITE(LUOUT,2310)
        DO 610 I = 1,NRPR
          READ(LUINP,*) (TCVBF(J,I),CVBF(J,I),J = 1,NRDP)
          WRITE(LUOUT,2320) I
          WRITE(LUOUT,2330) (TCVBF(J,I),CVBF(J,I),J = 1,NRDP)
  610   CONTINUE
C
C       read profile types assigned to variable boundary sides
        CALL READN
     I            (LUINP,LUOUT,MXVES,NVES,
     O             IVTYP)
C
C       read four global node numbers of all variable boundary sides
        MPI = 0
  620   CONTINUE
        READ(LUINP,*) MI,NSEQ,MIAD,I1,I2,I3,I4,I1AD,I2AD,I3AD,I4AD
        IF (MI .NE. 0) THEN
          MJ = MI + NSEQ
          DO 625 MP = MI,MJ
            I        = MI + (MP - MI)*MIAD
            ISV(1,I) = I1 + I1AD*(MP - MI)
            ISV(2,I) = I2 + I2AD*(MP - MI)
            ISV(3,I) = I3 + I3AD*(MP - MI)
            ISV(4,I) = I4 + I4AD*(MP - MI)
            MPI      = MPI + 1
  625     CONTINUE
          GO TO 620
        END IF
C
        IF (MPI .NE. NVES) THEN
C         print error message and stop
          WRITE(LUOUT,2340)
          STOP
        END IF
C
C       print input global node number and profile types of all VB sides
        LINE = 0
        DO 640 MP = 1,NVES,2
          LINE = LINE + 1
          IF (MOD(LINE - 1,50) .EQ. 0) THEN
            WRITE(LUOUT,2350)
          END IF
          NJMN = MP
          NJMX = MIN0(MP + 1,NVES)
          WRITE(LUOUT,2360) (J,(ISV(I,J),I = 1,4),IVTYP(J),
     >                       J = NJMN,NJMX)
  640   CONTINUE
C
C       read global node number of all variable boundary nodes
        CALL READN
     I            (LUINP,LUOUT,MXVNP,NVNP,
     O             NPVB)
C
C       print global node number of all variable-boundary nodes
        LINE = 0
        DO 645 I = 1,NVNP,6
          LINE = LINE + 1
          IF (MOD(LINE - 1,50) .EQ. 0) THEN
            WRITE(LUOUT,2370)
          END IF
          NJMN = I
          NJMX = MIN0(I + 5,NVNP)
          WRITE(LUOUT,2380) (J,NPVB(J),J = NJMN,NJMX)
  645   CONTINUE
C
C       Compute boundary side numbers of all variable-boundary sides
C
        MI=0
  650   CONTINUE
          MI=MI+1
          DO 651 IQ = 1,4
            NIMI(IQ) = ISV(IQ,MI)
  651     CONTINUE
          MJ=0
          MJDO=1
  652     CONTINUE
            MJ=MJ+1
            DO 653 JQ = 1,4
              IJ = ISB(JQ,MJ)
              NJMJ(JQ) = NPBB(IJ)
  653       CONTINUE
C
            IEQ=0
            IQ=0
            IQDO=1
  656       CONTINUE
              IQ=IQ+1
              NI=NIMI(IQ)
              JQ=0
              JQDO=1
  657         CONTINUE
                JQ=JQ+1
                NJ = NJMJ(JQ)
                IF(NJ.EQ.NI) THEN
                  IEQ=IEQ+1
                  JQDO=0
                ENDIF
              IF(JQDO.EQ.1) THEN
                IF(JQ.LT.4) THEN
                  GO TO 657
                ELSE
                  IQDO=0
                ENDIF
              ENDIF
            IF(IQDO.EQ.1) THEN
              IF(IQ.LT.4) THEN
                GO TO 656
              ELSE IF (IEQ.EQ.4) THEN
                MJDO=0
              ENDIF
            ENDIF
          IF(MJDO .EQ. 1) THEN
            IF(MJ.LT.NBES) THEN
              GO TO 652
            ELSE
              WRITE(LUOUT,2390) MI
              STOP
            ENDIF
          ENDIF
          ISV(5,MI)=MJ
        IF(MI.LT.NVES) GO TO 650
C
C       change NPVB from containing global nodal number to
C       containing boundary nodal number
C
        NP=0
  665   CONTINUE
          NP=NP+1
          NI = NPVB(NP)
C
          I=0
          IDO=1
  667     CONTINUE
            I=I+1
            NJ = NPBB(I)
C
            IF (NJ .EQ. NI) THEN
              NII = I
              IDO = 0
            END IF
C
          IF (IDO .EQ. 1 .AND. I .LT. NBNP) GO TO 667
          IF (IDO .EQ. 1) THEN
c           print error message
            WRITE(LUOUT,2400) NP
            STOP
          ENDIF
          NPVB(NP)=NII
        IF (NP .LT. NVNP) GO TO 665
C
C       print computed boundary nodal number for all VB nodes
        LINE = 0
        DO 670 I = 1,NVNP,6
          LINE = LINE + 1
          IF (MOD(LINE - 1,50) .EQ. 0) THEN
            WRITE(LUOUT,2410)
          END IF
          NJMN = I
          NJMX = MIN0(I + 5,NVNP)
          WRITE(LUOUT,2380) (J,NPVB(J),J = NJMN,NJMX)
  670   CONTINUE
      END IF
C
C ******* Data Set 14:  Dirichlet Boundary Conditions
C
      IF (NDNP .NE. 0) THEN
C
C       read and write Dirichlet concentration profiles
        READ(LUINP,1000) DATNAM
        WRITE(LUOUT,2420)
        DO 710 I = 1,NDPR
          READ(LUINP,*) (TCDBF(J,I),CDBF(J,I),J = 1,NDDP)
          WRITE(LUOUT,2430) I
          WRITE(LUOUT,2330) (TCDBF(J,I),CDBF(J,I),J = 1,NDDP)
  710   CONTINUE
C
C       read global nodal number of all Dirichlet nodes
        READ(LUINP,*) (NPDB(I),I = 1,NDNP)
C
C       read Dirichlet concentration profile types assinged to all
C       Dirichlet nodes
        CALL READN
     I            (LUINP,LUOUT,MXDNP,NDNP,
     O             IDTYP)
C
C       print global nodal number and profile types of Dirichlet nodes
        LINE = 0
        DO 720 I = 1,NDNP,3
          LINE = LINE + 1
          IF (MOD(LINE - 1,50) .EQ. 0) THEN
            WRITE(LUOUT,2440)
          END IF
          NJMN = I
          NJMX = MIN0(I + 2,NDNP)
          WRITE(LUOUT,2450) (J,NPDB(J),IDTYP(J),J = NJMN,NJMX)
  720   CONTINUE
      END IF
C
C ******* Data Set 15: Cauchy Boundary Conditions
C
      IF (NCES .NE. 0) THEN
C
        READ(LUINP,1000) DATNAM
        WRITE(LUOUT,2460)
C
C       read and write Cauchy profiles
        DO 810 I = 1,NCPR
          READ(LUINP,*) (TQCBF(J,I),QCBF(J,I),J = 1,NCDP)
          WRITE(LUOUT,2470) I
          WRITE(LUOUT,2330) (TQCBF(J,I),QCBF(J,I),J = 1,NCDP)
  810   CONTINUE
C
C       read Cauchy type assigned to Cauchy sides
        CALL READN
     I            (LUINP,LUOUT,MXCES,NCES,
     O             ICTYP)
C
C       read four global nodal numbers of all Cauchy sides
        MPI = 0
  820   CONTINUE
        READ(LUINP,*) MI,NSEQ,MIAD,I1,I2,I3,I4,I1AD,I2AD,I3AD,I4AD
        IF (MI .NE. 0) THEN
          MJ = MI + NSEQ
          DO 825 MP = MI,MJ
            I        = MI + (MP - MI)*MIAD
            ISC(1,I) = I1 + I1AD*(MP - MI)
            ISC(2,I) = I2 + I2AD*(MP - MI)
            ISC(3,I) = I3 + I3AD*(MP - MI)
            ISC(4,I) = I4 + I4AD*(MP - MI)
            MPI      = MPI + 1
  825     CONTINUE
          GO TO 820
        END IF
        IF (MPI .EQ. NCES) THEN
          WRITE(LUOUT,2480)
          STOP
        END IF
C
C       print input global nodal numbers and profile types of all
C       Cauchy sides
C
        LINE = 0
        DO 840 MP = 1,NCES,2
          LINE = LINE + 1
          IF (MOD(LINE - 1,50) .EQ. 0) THEN
            WRITE(LUOUT,2490)
          END IF
          NJMN = MP
          NJMX = MIN0(MP + 1,NCES)
          WRITE(LUOUT,2360) (J,(ISC(I,J),I = 1,4),ICTYP(J),
     >                       J = NJMN,NJMX)
  840   CONTINUE
C
C       read global nodal numbers of all Cauchy nodes
        CALL READN
     I            (LUINP,LUOUT,MXCNP,NCNP,
     O             NPCB)
C
C       print global nodal number of all Cauchy nodes
        LINE = 0
        DO 845 I = 1,NCNP,6
          LINE = LINE + 1
          IF (MOD(LINE - 1,50) .EQ. 0) THEN
            WRITE(LUOUT,2500)
          END IF
          NJMN = I
          NJMX = MIN0(I + 5,NCNP)
          WRITE(LUOUT,2380) (J,NPCB(J),J = NJMN,NJMX)
  845   CONTINUE
C
C       Compute boundary side number for all all Cauchy sides
C
        MI=0
  850   CONTINUE
          MI=MI+1
          DO 851 IQ = 1,4
            NIMI(IQ) = ISC(IQ,MI)
  851     CONTINUE
          MJ=0
          MJDO=1
  852     CONTINUE
            MJ=MJ+1
            DO 853 JQ = 1,4
              IJ = ISB(JQ,MJ)
              NJMJ(JQ) = NPBB(IJ)
  853       CONTINUE
C
            IEQ=0
            IQ=0
            IQDO=1
  856       CONTINUE
              IQ=IQ+1
              NI=NIMI(IQ)
              JQ=0
              JQDO=1
  857         CONTINUE
                JQ=JQ+1
                NJ = NJMJ(JQ)
                IF(NJ.EQ.NI) THEN
                  IEQ=IEQ+1
                  JQDO=0
                ENDIF
              IF(JQDO.EQ.1) THEN
                IF(JQ.LT.4) THEN
                  GO TO 857
                ELSE
                  IQDO=0
                ENDIF
              ENDIF
            IF(IQDO.EQ.1) THEN
              IF(IQ.LT.4) THEN
                GO TO 856
              ELSE IF (IEQ.EQ.4) THEN
                MJDO=0
              ENDIF
            ENDIF
          IF(MJDO .EQ. 1) THEN
            IF(MJ.LT.NBES) THEN
              GO TO 852
            ELSE
              WRITE(LUOUT,2510) MI
              STOP
            ENDIF
          ENDIF
          ISC(5,MI)=MJ
        IF(MI.LT.NCES) GO TO 850
C
C       change NPCB from containing global nodal number to
c       containing boundary nodal number
C
        NP=0
  865   CONTINUE
          NP=NP+1
          NI = NPCB(NP)
C
          I=0
          IDO=0
  867     CONTINUE
            I=I+1
            NJ = NPBB(I)
C
            IF (NJ .EQ. NI) THEN
              NII = I
              IDO = 0
            END IF
C
          IF (IDO .EQ. 1) THEN
            IF (I .LT. NBNP) GO TO 867
          ELSE
C         print error message
            WRITE(LUOUT,2520) NP
            STOP
          ENDIF
          NPCB(NP)=NII
        IF (NP .LT. NCNP) GO TO 865
C
C       print computed boundary nodal number of all Cauchy nodes
        LINE = 0
        DO 870 I = 1,NCNP,6
          LINE = LINE + 1
          IF (MOD(LINE - 1,50) .EQ. 0) THEN
            WRITE(LUOUT,2530)
          END IF
          NJMN = I
          NJMX = MIN0(I + 5,NCNP)
          WRITE(LUOUT,2380) (J,NPCB(J),J = NJMN,NJMX)
  870   CONTINUE
      END IF
C
C ******* Data Set 6:  Neumann Boundary Conditions
C
      IF (NNNP .NE. 0) THEN
C
        READ(LUINP,1000) DATNAM
        WRITE(LUOUT,2540)
C
C       read and write Neumann profiles
        DO 910 I = 1,NNPR
          READ(LUINP,*) (TQNBF(J,I),QNBF(J,I),J = 1,NNDP)
          WRITE(LUOUT,2550) I
          WRITE(LUOUT,2330) (TQNBF(J,I),QNBF(J,I),J = 1,NNDP)
  910   CONTINUE
C
C       read Neumann flux type assigned to each Neumann side
        CALL READN
     I            (LUINP,LUOUT,MXNES,NNES,
     O             INTYP)
C
C       read four global nodal numbers of all Neumann sides
        MPI = 0
  920   CONTINUE
          READ(LUINP,*) MI,NSEQ,MIAD,I1,I2,I3,I4,I1AD,I2AD,I3AD,I4AD
          IF (MI .NE. 0) THEN
            MJ = MI + NSEQ
            DO 925 MP = MI,MJ
              I        = MI + (MP - MI)*MIAD
              ISN(1,I) = I1 + I1AD*(MP - MI)
              ISN(2,I) = I2 + I2AD*(MP - MI)
              ISN(3,I) = I3 + I3AD*(MP - MI)
              ISN(4,I) = I4 + I4AD*(MP - MI)
              MPI      = MPI + 1
  925       CONTINUE
            GO TO 920
          END IF
        IF (MPI .NE. NNES) THEN
C         check errors
          WRITE(LUOUT,2560)
          STOP
        END IF
C
C       print input global nodal numbers and flux types of all
C       Neumann sides
        LINE = 0
        DO 940 MP = 1,NNES,2
          LINE = LINE + 1
          IF (MOD(LINE - 1,50) .EQ. 0) THEN
            WRITE(LUOUT,2570)
          END IF
          NJMN = MP
          NJMX = MIN0(MP + 1,NNES)
          WRITE(LUOUT,2360) (J,(ISN(I,J),I = 1,4),INTYP(J),
     >                       J = NJMN,NJMX)
  940   CONTINUE
C
C       read global nodal number for all Neumann nodes
        CALL READN
     I            (LUINP,LUOUT,MXNNP,NNNP,
     O             NPNB)
C
C       print global nodal numbers of all Neumann nodes
        LINE = 0
        DO 945 I = 1,NNNP,6
          LINE = LINE + 1
          IF (MOD(LINE - 1,50) .EQ. 0) THEN
            WRITE(LUOUT,2580)
          END IF
          NJMN = I
          NJMX = MIN0(I + 5,NNNP)
          WRITE(LUOUT,2380) (J,NPNB(J),J = NJMN,NJMX)
  945   CONTINUE
C
C       Compute boundary side number for all Neumann sides
C
        MI=0
  950   CONTINUE
          MI=MI+1
          DO 951 IQ = 1,4
            NIMI(IQ) = ISN(IQ,MI)
  951     CONTINUE
          MJ=0
          MJDO=1
  952     CONTINUE
            MJ=MJ+1
            DO 953 JQ = 1,4
              IJ = ISB(JQ,MJ)
              NJMJ(JQ) = NPBB(IJ)
  953       CONTINUE
C
            IEQ=0
            IQ=0
            IQDO=1
  956       CONTINUE
              IQ=IQ+1
              NI=NIMI(IQ)
              JQ=0
              JQDO=1
  957         CONTINUE
                JQ=JQ+1
                NJ = NJMJ(JQ)
                IF(NJ.EQ.NI) THEN
                  IEQ=IEQ+1
                  JQDO=0
                ENDIF
              IF(JQDO.EQ.1) THEN
                IF(JQ.LT.4) THEN
                  GO TO 957
                ELSE
                  IQDO=0
                ENDIF
              ENDIF
            IF(IQDO.EQ.1) THEN
              IF(IQ.LT.4) THEN
                GO TO 956
              ELSE IF (IEQ.EQ.4) THEN
                MJDO=0
              ENDIF
            ENDIF
          IF(MJDO .EQ. 1) THEN
            IF(MJ.LT.NBES) THEN
              GO TO 952
            ELSE
              WRITE(LUOUT,2590) MI
              STOP
            ENDIF
          ENDIF
          ISN(5,MI)=MJ
        IF(MI.LT.NNES) GO TO 950
C
C       change NPNB from containing global nodal number to
C       containing boundary nodal number
C
        NP=0
  965   CONTINUE
          NP=NP+1
          NI = NPNB(NP)
C
          I=0
          IDO=0
  967     CONTINUE
            I=I+1
            NJ = NPBB(I)
C
            IF (NJ .EQ. NI) THEN
              NII = I
              IDO = 0
            END IF
C
          IF (IDO .EQ. 1) THEN
            IF (I .LT. NBNP) GO TO 967
          ELSE
C           print error message
            WRITE(LUOUT,2600) NP
            STOP
          ENDIF
          NPNB(NP)=NII
        IF (NP .LT. NNNP) GO TO 965
C
C       print computed boundary nodal numbers for all Neumann nodes
        LINE = 0
        DO 970 I = 1,NNNP,6
          LINE = LINE + 1
          IF (MOD(LINE - 1,50) .EQ. 0) THEN
            WRITE(LUOUT,2610)
          END IF
          NJMN = I
          NJMX = MIN0(I + 5,NNNP)
          WRITE(LUOUT,2380) (J,NPNB(J),J = NJMN,NJMX)
  970   CONTINUE
      END IF
C
      RETURN
      END
