      SUBROUTINE FLUX
     I               (C,X,Y,Z,IE,WETAB,VX,VY,VZ,TH,PROP,
     O                FX,FY,FZ,CMATRX)
C
C     + + + PURPOSE + + +
C ------- TO COMPUTE THE MATERIAL FLUXES.
C
C     + + + COMMON BLOCKS + + +
      INCLUDE 'SGEOM.INC'
      INCLUDE 'CGEOM.INC'
      INCLUDE 'MATL.INC'
      INCLUDE 'WETX.INC'
      INCLUDE 'WETY.INC'
      INCLUDE 'WETZ.INC'
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER            IE(MAXEL,9)
      DOUBLE PRECISION   C(MAXNP),X(MAXNP),Y(MAXNP),Z(MAXNP),
     >                   WETAB(12,MAXEL),VX(MAXNP),VY(MAXNP),
     >                   VZ(MAXNP),TH(8,MAXEL),PROP(MXMPPM,MAXMAT),
     >                   FX(MAXNP),FY(MAXNP),FZ(MAXNP),
     >                   CMATRX(MAXNP,MXJBD)
C
C     + + + ARGUMENT DEFINITIONS + + +
C     C      - concentration
C     X      - x-coordinate
C     Y      - y-coordinate
C     Z      - z-coordinate
C     IE     - incidence of elements
C     WETAB  - weighting factors
C     VX     - x-component of the velocity
C     VY     - y-component of the velocity
C     VZ     - z-component of the velocity
C     TH     - moisture content
C     PROP   - material properties
C     FX     - x-component of the material flux
C     FY     - y-component of the material flux
C     FZ     - z-component of the material flux
C     CMATRX - matrix for computing fluxes
C
C     + + + LOCAL VARIABLES + + +
      INTEGER            NP,M,MTYP,IQ,NI,JQ
      DOUBLE PRECISION   AL,AT,AM,TAU,DD,THQ(8),XQ(8),YQ(8),ZQ(8),
     >                   CQ(8),VXQ(8),VYQ(8),VZQ(8),QB(8,8),QRX(8),
     >                   QRY(8),QRZ(8)
C
C     + + + EXTERNALS + + +
      EXTERNAL     Q8DV
C
C     + + + END SPECIFICATIONS + + +
C
C     Initiate the flux components.
      DO 100 NP = 1,NNP
        FX(NP) = 0.0
        FY(NP) = 0.0
        FZ(NP) = 0.0
  100 CONTINUE
C
C     initiate the matrix
      DO 160 NP = 1,NNP
        CMATRX(NP,1) = 0.0
  160 CONTINUE
C
C *** Assemble the matrix equation element by element
C
      DO 290 M = 1,NEL
C       obtain weighting factors
        APHA1 = WETAB(1,M)
        APHA2 = WETAB(2,M)
        APHA3 = WETAB(3,M)
        APHA4 = WETAB(4,M)
        BETA1 = WETAB(5,M)
        BETA2 = WETAB(6,M)
        BETA3 = WETAB(7,M)
        BETA4 = WETAB(8,M)
        GAMA1 = WETAB(9,M)
        GAMA2 = WETAB(10,M)
        GAMA3 = WETAB(11,M)
        GAMA4 = WETAB(12,M)
C
        MTYP  = IE(M,9)
C
C       put material properties in local variables
        AL    = PROP(3,MTYP)
        AT    = PROP(4,MTYP)
        AM    = PROP(5,MTYP)
        TAU   = PROP(6,MTYP)
        DD    = AM*TAU
C
C       put coordinates, velocity components, concentrations, and
C       moisture content in local variables
        DO 210 IQ = 1,8
          NP      = IE(M,IQ)
          XQ(IQ)  = X(NP)
          YQ(IQ)  = Y(NP)
          ZQ(IQ)  = Z(NP)
          CQ(IQ)  = C(NP)
          VXQ(IQ) = VX(NP)
          VYQ(IQ) = VY(NP)
          VZQ(IQ) = VZ(NP)
          THQ(IQ) = TH(IQ,M)
  210   CONTINUE
C
C       compute the derivatives of concentration
        CALL Q8DV
     I           (CQ,XQ,YQ,ZQ,VXQ,VYQ,VZQ,THQ,DD,AL,AT,
     O            QB,QRX,QRY,QRZ)
C
C       Put the element matrix and vector into global matrix and vector
C       Note:  the matrix is lumped for fast solving.
        DO 280 IQ = 1,8
          NI = IE(M,IQ)
          DO 240 JQ = 1,8
            CMATRX(NI,1) = CMATRX(NI,1) + QB(IQ,JQ)
  240     CONTINUE
          FX(NI) = FX(NI) + QRX(IQ)
          FY(NI) = FY(NI) + QRY(IQ)
          FZ(NI) = FZ(NI) + QRZ(IQ)
  280   CONTINUE
  290 CONTINUE
C
C *** Solve the matrix equation for flux components.
C
      DO 370 NP = 1,NNP
        FX(NP) = FX(NP)/CMATRX(NP,1)
        FY(NP) = FY(NP)/CMATRX(NP,1)
        FZ(NP) = FZ(NP)/CMATRX(NP,1)
  370 CONTINUE
C
C *** Add the advection flux to dispersion flux
C
      DO 380 NP = 1,NNP
        FX(NP) = FX(NP) + VX(NP)*C(NP)
        FY(NP) = FY(NP) + VY(NP)*C(NP)
        FZ(NP) = FZ(NP) + VZ(NP)*C(NP)
  380 CONTINUE
C
      RETURN
      END
