      SUBROUTINE GM3D
     I               (LUINP,LUOUT,LUFLW,LUSTO,LUBAR,LUPAR,
     M                WWRK,RI,RL,X,Y,Z,IE,IB,LRL,NLRL,LRN,CMATRX,RLD,
     M                NTNPLR,NNPLR,LMAXDF,GNLR,LNOJCN,CMTRXL,RLDL,
     M                DCOSB,ISB,NPBB,BFLX,BFLXP,WETAB,VXBAR,VYBAR,VZBAR,
     M                VX,VY,VZ,DTI,
     M                VXP,VYP,VZP,TH,THP,DTH,THN,LES,SOS,SOSF,
     M                TSOSF,ISTYP,NPW,WSS,WSSF,TWSSF,IWTYP,QCB,
     M                QCBF,TQCBF,ICTYP,ISC,NPCB,QNB,QNBF,TQNBF,
     M                INTYP,ISN,NPNB,CVB,CVBF,TCVBF,IVTYP,ISV,
     M                NPVB,CDB,CDBF,TCDBF,IDTYP,NPDB,PROP,
     M                KPR,KDSK,TDTCH,
     O                C,CP,CW,CSTAR,FX,FY,FZ)
C
C     + + + PURPOSE + + +
C     To control the sequence of operation
C
C     + + + COMMON BLOCKS + + +
      INCLUDE 'SGEOM.INC'
      INCLUDE 'CGEOM.INC'
      INCLUDE 'LGEOM.INC'
      INCLUDE 'CINTE.INC'
      INCLUDE 'CREAL.INC'
      INCLUDE 'CELS.INC'
      INCLUDE 'CNPS.INC'
      INCLUDE 'CCBC.INC'
      INCLUDE 'CNBC.INC'
      INCLUDE 'CVBC.INC'
      INCLUDE 'CDBC.INC'
      INCLUDE 'MATL.INC'
      INCLUDE 'OPTN.INC'
      INCLUDE 'WETX.INC'
      INCLUDE 'WETY.INC'
      INCLUDE 'WETZ.INC'
      INCLUDE 'CFLOW.INC'
C
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER            LUINP,LUOUT,LUFLW,LUSTO,LUBAR,LUPAR,
     >                   IE(MAXEL,9),LRL(MXKBD,MAXNP),LRN(MXJBD,MAXNP),
     >                   NTNPLR(MXREGN),NNPLR(MXREGN),LMAXDF(MXREGN),
     >                   GNLR(LTMXNP,MXREGN),LNOJCN(MXJBD,LMXNP,MXREGN),
     >                   ISB(6,MAXBES),NPBB(MAXBNP),LES(MXSEL),
     >                   ISTYP(MXSEL),NPW(MXWNP),IWTYP(MXWNP),
     >                   ICTYP(MXC ES),ISC(5,MXCES),NPCB(MXCNP),
     >                   INTYP(MXNES),ISN(5,MXNES),NPNB(MXNNP),
     >                   IVTYP(MXVES),ISV(5,MXVES),NPVB(MXVNP),
     >                   IDTYP(MXDNP),NPDB(MXDNP),KPR(MXNTI),
     >                   KDSK(MXNTI),IB(MAXNP),NLRL(MAXNP)
      DOUBLE PRECISION   WWRK(MAXNP),RI(MAXNP),RL(MAXNP),X(MAXNP),
     >                   Y(MAXNP),Z(MAXNP),CMATRX(MAXNP,MXJBD),
     >                   RLD(MAXNP),CMTRXL(LMXNP,LMXBW),RLDL(LMXNP),
     >                   DCOSB(3,MAXBES),BFLX(MAXBNP),BFLXP(MAXBNP),
     >                   WETAB(12,MAXEL),VX(MAXNP),VY(MAXNP),
     >                   VZ(MAXNP),VXBAR(MAXNP),VYBAR(MAXNP),
     >                   VZBAR(MAXNP),VXP(MAXNP),VYP(MAXNP),
     >                   VZP(MAXNP),TH(8,MAXEL),THP(8,MAXEL),
     >                   DTH(8,MAXEL),THN(MAXNP),SOS(MXSPR,2),
     >                   SOSF(MXSDP,MXSPR,2),TSOSF(MXSDP,MXSPR),
     >                   WSS(MXWPR,2),WSSF(MXWDP,MXWPR,2),
     >                   TWSSF(MXWDP,MXWPR),QCB(MXCPR),
     >                   QCBF(MXCDP,MXCPR),TQCBF(MXCDP,MXCPR),
     >                   QNB(MXNPR),QNBF(MXNDP,MXNPR),
     >                   TQNBF(MXNDP,MXNPR),CVB(MXRPR),
     >                   CVBF(MXRDP,MXRPR),TCVBF(MXRDP,MXRPR),
     >                   CDB(MXDPR),CDBF(MXDDP,MXDPR),
     >                   TCDBF(MXDDP,MXDPR),PROP(MXMPPM,MAXMAT),
     >                   TDTCH(MXDTC),C(MAXNP),CP(MAXNP),CW(MAXNP),
     >                   CSTAR(MAXNP),FX(MAXNP),FY(MAXNP),FZ(MAXNP),
     >                   DTI(MAXNP)
C
C     + + + ARGUMENT DEFINITIONS + + +
C     LUINP  - logical unit for input data
C     LUOUT  - logical unit for output data
C     LUFLW  - logical unit for flow data
C     LUSTO  - logical unit for store binary output
C     LUBAR  - logical unit for store binary boundary arrays
C     LUPAR  - logical unit for store binary pointer arrays
C
C --- Working Arrays
C     WWRK   - A working array used in subroutine THNODE
C     RI(N)  - A working array used in subroutines BLKITR and ADVBC
C     RL     - A working array used in subroutine ADVBC
C --- Arrays of Discretization
C     X(N)     - x-coordiante of the N-th node
C     Y(N)     - y-coordinate of the N-th node
C     Z(N)     - z-coordinate of the N-th node
C     IE(M,I)  - global node number of the I-th node of the M-th element
C                if I is between 1 and 8
C     IE(M,9)  - integer to indicate the material type of the M-th
C                element
C     LRL(I,N) - global element number of the I-th element connecting
C                to the N-th global node
C     NLRL(N)  - total number of elements connecting to the N-th global
C                node
C     LRN(I,N) - global node number of the I-th node connecting
C                to the N-th global node
C     IB(I)    - boundary index of global nodes; 0=inner nodes,
C                 1=boundary nodes
C---- Global Matrix Arrays
C     CMATRX(N,I) - an array to store the I-th non-zero entry of the
C                   N-th equation of the assembled global matrix
C     RLD(N)      - an array to store the right hand side of the N-th
C                   equation of the assembled global load vector
C --- Subregion Arrays
C     NTNPLR(K)     - total number of nodes for the K-th subregion
C                     including interior, global boundary, and intra-
C                     boundary nodes
C     NNPLR(K)      - number of nodes for the K-th subregion including
C                     interior and global boundary nodes
C     LMAXDF(K)     - maximum number of difference between nodes for
C                     any element in the K-th local region.
C                     This array is genereated from the array LNOJCN.
C     GNLR(I,K)     - global nodal number of the I-th local nodal
C                     number in the K-th subregion.  This array is an
C                     input for I = 1, 2, ..,  NNPLR(K).
C                     For = NNPLR(K)+1, ... NTNPLR(K), this array is
C                     generated based on IE(NEL,8) and inputted GNLR.
C     LNOJCN(J,I,K) - local node number of the J-th node connecting to
C                     the I-th local node for the K-th subregion.
C                     This array is genereated from GNLR and IE.
C                     I = 1, 2, 3, ...., NNPLR(K).
C     CMTRXL(N,I)   - assembled matrix for a subregion
C     RLDL(N)       - assembled load vector for a subregion
C     DTI(N)        - the reciprocal of real diffusion time of the
C                     N-th global node
C --- Boundary Arryas
C     DCOSB(1,I) - x-directional cosine of the I-th boundary side
C     DCOSB(2,I) - y-directional cosine of the I-th boundary side
C     DCOSB(3,I) - z-directional cosine of the I-th boundary side
C     ISB(1,I)   - boundary node number of the first node of the I-th
C                  boundary side
C     ISB(2,I)   - boundary node number of the second node of the I-th
C                  boundary side
C     ISB(3,I)   - boundary node number of the third node of the I-th
C                  boundary side
C     ISB(4,I)   - boundary node number of the fourth node of the I-th
C                  boundary side
C     ISB(5,I)   - element side index of the I-th boundary side
C                  1=left side, 2=front side, 3=right side,
C                  4=back side, 5=bottom side, 6=top side
C     ISB(6,I)   - element number to which the I-th boundary side belong
C     NPBB(I)    - global node number of the I-the boundary node
C     BFLX(I)    - boundary flux at the I-th boundary node
C     BFLXP(I)   - value of BFLX(I) at previous time
C --- Hydrologic-Variables Arrays
C     WETAB(J,M) - weighting factor for the J-the side of the M-th
C                  element
C     VX(N)      - x-component velocity at the N-th node
C     VY(N)      - y-component velocity at the N-th node
C     VZ(N)      - z-component velocity at the N-th node
C     VXBAR(N)   - average value of vx(n) between two time steps
C     VYBAR(N)   - average value of vy(n) between two time steps
C     VZBAR(N)   - average value of vz(n) between two time steps
C     VXP(N)     - value of VX(N) at previous time
C     VYP(N)     - value of VY(N) at previous time
C     VZP(N)     - value of VZ(N) at previous time
C     TH(I,M)    - moisture content at the I-th node of the M-th element
C     THP(I,M)   - value of TH(I,M) at the previous time
C     DTH(I,M)   - (TH(I,M)-THP(I,M))/DELT
C     THN(N)     - moisture content at the N-th node
C --- Source Arrays
C     LES(I)      - global element number of the I-th element-source
C     SOS(I,1)    - source flow rate of the I-th profile at time t
C     SOS(I,2)    - source concentration of the I-th profile at time t
C     SOSF(I,J,1) - source flow rate of the I-th data point in
C                   the J-th profile
C     SOSF(I,J,2) - source concentration of the I-th data point in
C                   the J-th profile
C     TSOSF(I,J)  - time of the I-th data point in the J-the profile
C     ISTYP(M)    - type of source profile assigned to the M-th element
C     NPW(I)      - global node number of the I-th well node
C     WSS(I,1)    - well source flow rate of the I-th profile at time t
C     WSS(I,2)    - well source concentration of the I-th profile
C     WSSF(J,I,1) - well-source flow rate of the I-th data point in
C                   the J-th profile
C     WSSF(J,I,2) - well-source concentration of the I-th data point in
C                   the J-th profile
C     TWSSF(J,I)  - time of the J-th data point in the J-th profile
C     IWTYP(I)    - type of source profile assigned to the I-th node
C --- Cauchy Boundary Condition Arrays
C     QCB(I)     - Value of Cauchy flux at the presnet time of the
C                  I-th Cauchy flux profile
C     QCBF(I,J)  - Flux of the I-th data point in the J-th
C                  Cauchy flux vs time profile
C     TQCBF(I,J) - time of the I-th data point in the J-th
C                  Cauchy flux vs time profile
C     ICTYP(MP)  - type of Cauchy flux profile assigned to the MP-th
C                  Cauchy side
C     ISC(1,MP)  - global node number of the first node of the Mp-th
C                  Cauchy side
C     ISC(2,MP)  - global node number of the second node of the Mp-th
C                  Cauchy side
C     ISC(3,MP)  - global node number of the third node of the Mp-th
C                  Cauchy side
C     ISC(4,MP)  - global node number of the fourth node of the Mp-th
C                  Cauchy side
C     ISC(5,MP)  - boundary side number of the MP-th Cauchy side
C     NPCB(NP)   - global nodal number of the NP-Cauchy node on input
C                  Then is changed to contain boundary node number
C --- Neumann Boundary Arrays
C     QNB(I)     - Value of Neumann flux at the presnet time of the
C                  I-th Neumann flux profile
C     QNBF(I,J)  - Flux of the I-th data point in the J-th
C                  Neumann flux vs time profile
C     TQNBF(I,J) - time of the I-th data point in the J-th
C                  Neumann flux vs time profile
C     INTYP(MP)  - type of Neumann flux profile assigned to the MP-th
C                  Neumann side
C     ISN(1,MP)  - global node number of the first node of the Mp-th
C                  Neumann side
C     ISN(2,MP)  - global node number of the second node of the Mp-th
C                  Neumann side
C     ISN(3,MP)  - global node number of the third node of the Mp-th
C                  Neumann side
C     ISN(4,MP)  - global node number of the fourth node of the Mp-th
C                  Neumann side
C     ISN(5,MP)  - boundary side number of the MP-th Neumann side
C     NPNB(NP)   - global nodal number of the NP-Neumann node on input
C                  Then is changed to contain boundary node number
C --- Variable Boundary Arrays
C     CVB(I)     - variable concentration of the I-th profile
C                  at the present time
C     CVBF(I,J)  - concentration of the I-th data point in the J-th
C                  variable concentration vs time profile
C     TCVBF(I,J) - time of the I-th data point in the J-th
C                  variable concentration vs time profile
C     IVTYP(MP)  - type of variable concentration profile assigned to
C                  the MP-th variable side
C     ISV(1,MP)  - global node number of the first node of the Mp-th
C                  Variable side
C     ISV(2,MP)  - global node number of the second node of the Mp-th
C                  variable side
C     ISV(3,MP)  - global node number of the third node of the Mp-th
C                  variable side
C     ISV(4,MP)  - global node number of the fourth node of the Mp-th
C                  variable side
C     ISV(5,MP)  - boundary side number of the MP-th variable side
C     NPVB(NP)   - global nodal number of the NP-variable node on input
C                  Then is changed to contain boundary node number
C --- Dirichlet Boundary Arrays
C     CDB(I)     - Dirichlet concentration of the I-th profile
C                  at the present time
C     CDBF(I,J)  - concentration of the I-th data point in the J-th
C                  Dirichlet concentration vs time profile
C     TCDBF(I,J) - time of the I-th data point in the J-th
C                  Dirichlet concentration vs time profile
C     IDTYP(NP)  - type of Dirichlet concentration profile assigned to
C                  the NP-th Dirichlet node
C     NPDB(NP)   - global nodal number of the NP-Dirichlet node on input
C                  Then is changed to contain boundary node number
C --- Material Arrays
C     PROP(J,I) - J-the material property of the I-th material
C                 PROP(1,I) = distribution coefficient or
C                             Freundlich K or Langmuir K
C                 PROP(2,I) = bulk density
C                 PROP(3,I) = longitudinal dispersivity
C                 PROP(4,I) = lateral dispersivity
C                 PROP(5,I) = molecular diffusion coefficient
C                 PROP(6,I) = tortuosity
C                 PROP(7,I) = decay constant
C                 PROP(8,I) = Freundlich N or Langmuir SMAX
C --- Time Control Arrays
C     KPR(I)   - line printing indicator for the I-th time step
C                 0 = print nothing
C                 1 = print fluxes through all types of boundaries
C                 2 = print concentration also
C                 3 = print mateiral flux also
C     KDSK(I)  - store results on logical unit 12? 0=no, 1=yes
C     TDTCH(I) - time of the I-th time to reset time-step size = DELT0
C --- Solution Arrays for Concentrations and Fluxes
C     C(N)     - Concentration of the N-th node at the present time
C     CP(N)    - Concentration of the N-th node at previous time
C     CSTAR(N) - Lagrangian concentration at the N-th node
C     CW(N)    - Nonlinear iterate of concentration at the N-th node
C     FX(N)    - x-direction material flux at the N-th node
C     FY(N)    - y-direction material flux at the N-th node
C     FZ(N)    - z-direction material flux at the N-th node
C
C     + + + LOCAL VARIABLES + + +
      INTEGER    NPROB,I,IBUG,KOUT,J,K,KDIG,NPP,NP,ITYP,NPI,NI,NSEQ,
     >           NAD,NJ,LINE,NJMN,NJMX,IQ,M,MP,KFLOW,KDIAG,ITER,NOCCUR,
     >           IDELT,ITM,JTM,KPRZ,KDSZ,NTAU,NOCR,DONEFG
      DOUBLE PRECISION   TIME,VXNI,VYNI,VZNI,VXAD,VYAD,VZAD,THNI,
     >                   THNIAD,TIMEM,H,HT,EPS,DIFMAX,DIF,DTAU
      CHARACTER   TITLE*70, DATNAM*1
C
C     + + + INTRINSICS + + +
      INTRINSIC    DBLE,MOD,MIN0,DABS,DMIN1
C
C     + + + EXTERNALS + + +
      EXTERNAL   DATAIN,PAGEN,ALLFCT,THNODE,AFABTA,FLUX,SFLOW,
     >            PRINTT,STORE,ASEMBL,BC,BLKITR,BTGN,ADVBC
C
C     + + + INPUT FORMATS + + +
 1000 FORMAT(A1)
 1010 FORMAT(I5,A70,3X,2I1)
C
C     + + + OUTPUT FORMATS + + +
 2000 FORMAT('1 PROBLEM',I5,'..'/1X,A70,3X,2I1/)
 2010 FORMAT(/1X,' *** ERROR IN READING VELOCITY STOP ')
 2020 FORMAT('1'/5X,' **** CARD INPUTTED VELOCITY ****'///1X,
     1 2('    N     VX         VY         VZ    ')/1X,
     2 2('  ------------------------------------')/)
 2030 FORMAT(' ',2(I5,3D11.4))
 2040 FORMAT(/1X,' *** ERROR IN READING MOISTURE STOP')
 2050 FORMAT('1'/5X,' **** CARD INPUTTED MOISTURE CONTENT ***'///1X,
     1 '    M    1       2       3       4      5       6       7   ',
     3 '    8   '/1X,'  ---',8(' -------'))
 2060 FORMAT(' ',I5,8F8.5)
 2070 FORMAT('1','TABLE OF WEIGHTING FACTORS OF EVERY ELEMENTS'//)
 2080 FORMAT(' ',I5,12F6.2)
 2090 FORMAT(//1X,'*** ITM = ',I4,' NTAU = ',I3,'  DTAU = ',1PD12.4)
 2100 FORMAT('1'//1X,'***********************************************',
     1 '******************************'///' DIAGNOSTIC TABLE',I4,
     2 '.. AT TIME =',1PD12.4,', (DELT =', 1PD12.4,')')
 2110 FORMAT(///' TABLE OF ITERATIVE PARAMETERS'// 6X,
     1 'ITERATION',7X,' MAX DIF',6X,'TOLERANCE',6X,
     > ' MAX OCCURANCE NODE')
 2120 FORMAT(5X,I10,3X,E12.4,3X,E12.4,15X,I10)
 2130 FORMAT(/1X,'** WARNING: NO CONVERGENCE AFTER',I4,' ITERATIONS'/1X,
     1 'NITER =',I4,' DIFMAX =',D12.4,' TOLA =',D12.4,' NOCCUR =',I4/1X,
     2 ' STOP ***')
 2140 FORMAT(/1X,'** WARNING: NO CONVERGENCE AT',I4,'-TH TIME STEP',
     1 ' AFTER',I4,' ITERATIONS'/1X,'NITER =',I4,' DIFMAX =',D12.4,
     2 ' TOLB =',D12.4,' NOCCUR =',I4)
C
C     + + + END SPECIFICATIONS + + +
C
C ******* DATA SET 1: Problem Identification and Description.
C
      READ(LUINP,1010) NPROB,TITLE,IGEOM,IBUG
      WRITE(LUOUT,2000) NPROB,TITLE,IGEOM,IBUG
C     Initiate number of output table count KOUT, time TIME, and
C     number of diagonstic table count KDIG.
      KOUT = 0
      TIME = 0.0
      KDIG = 0
C
C ******* DATA SETS 2 through 16 are read in DATAIN
C
      CALL DATAIN
     I           (LUINP,LUOUT,LUFLW,LUBAR,
     O            KPR,KDSK,TDTCH,PROP,X,Y,Z,IE,CP,DCOSB,ISB,
     O            NPBB,SOSF,TSOSF,ISTYP,LES,WSSF,TWSSF,IWTYP,
     O            NPW,QCBF,TQCBF,ICTYP,ISC,NPCB,QNBF,TQNBF,
     O            INTYP,ISN,NPNB,CVBF,TCVBF,IVTYP,ISV,NPVB,
     O            CDBF,TCDBF,IDTYP,NPDB,NNPLR,GNLR,TIME,
     O            NLRL,LRN,LRL,LNOJCN,LMAXDF,NTNPLR)
C
C ------- COMPUTE ARRAY IB TO INDICATE IF ANY NODE IS A BOUNDARY NODE
C
      DO 20 I=1,NNP
        IB(I)=0
   20 CONTINUE
      DO 40 I=1,NBNP
        NI=NPBB(I)
        IB(NI)=1
        BFLX(I)=0.0
   40 CONTINUE
C
      REWIND(UNIT=LUPAR)
      IF (IGEOM .LE. 3) THEN
C       Put pointer arrays on logical unit LUPAR
        WRITE(LUPAR) ((LRN(J,I),J = 1,MXJBD),I = 1,NNP)
        WRITE(LUPAR) ((LRL(J,I),J=1,MXKBD),I=1,NNP),(NLRL(I),I=1,NNP)
        WRITE(LUPAR) (NTNPLR(K),K = 1,MXREGN)
        WRITE(LUPAR) (LMAXDF(K),K = 1,MXREGN)
        DO K=1,MXREGN
          WRITE(LUPAR)((LNOJCN(J,I,K),J = 1,MXJBD),I = 1,LMXNP)
        ENDDO
        WRITE(LUPAR) ((GNLR(I,K),I = 1,LTMXNP),K = 1,MXREGN)
        WRITE(LUPAR) (NNPLR(K),K = 1,MXREGN)
      END IF
C
      IF (IGEOM .GT. 3) THEN
C       Obtain pointer arrays from logical unit LUPAR
        READ(LUPAR)((LRN(J,I),J=1,MXJBD),I=1,NNP)
        READ(LUPAR)((LRL(J,I),J=1,MXKBD),I=1,NNP),(NLRL(I),I=1,NNP)
        READ(LUPAR)(NTNPLR(K),K=1,MXREGN)
        READ(LUPAR)(LMAXDF(K),K=1,MXREGN)
        DO 50 K=1,MXREGN
          READ(LUPAR)((LNOJCN(J,I,K),J=1,MXJBD),I=1,LMXNP)
  50    CONTINUE
        READ(LUPAR)((GNLR(I,K),I=1,LTMXNP),K=1,MXREGN)
        READ(LUPAR)(NNPLR(K),K=1,MXREGN)
      END IF
C
C ------- Prepare Initial or Pre-initial Variables.
C
      IF (NSEL .NE. 0) THEN
C       Compute element-wide source at the time by interpolating
C       the element-source profiles.
        CALL ALLFCT
     I             (TSOSF,SOSF(1,1,1),TIME,MXSPR,MXSDP,NSPR,NSDP,KSAI,
     O              SOS(1,1))
        CALL ALLFCT
     I             (TSOSF,SOSF(1,1,2),TIME,MXSPR,MXSDP,NSPR,NSDP,KSAI,
     O              SOS(1,2))
      END IF
C
      IF (NWNP .NE. 0) THEN
C       Compute point source at the time by interpolating point source
C       profiles.
        CALL ALLFCT
     I             (TWSSF,WSSF(1,1,1),TIME,MXWPR,MXWDP,NWPR,NWDP,KWAI,
     O              WSS(1,1))
        CALL ALLFCT
     I             (TWSSF,WSSF(1,1,2),TIME,MXWPR,MXWDP,NWPR,NWDP,KWAI,
     O              WSS(1,2))
      END IF
C
      IF (NDNP .NE. 0) THEN
C       Compute Dirichlet boundary value at the time by interpolating
C       Dirichlet concentration profiles.
        CALL ALLFCT
     I             (TCDBF,CDBF,TIME,MXDPR,MXDDP,NDPR,NDDP,KDAI,
     O              CDB)
      END IF
C
      IF (NVES .NE. 0) THEN
C       Compute variable boundary value at the time by interpolating
C       variable-concentration profiles.
        CALL ALLFCT
     I             (TCVBF,CVBF,TIME,MXRPR,MXRDP,NRPR,NRDP,KRAI,
     O              CVB)
      END IF
C
      IF (NCNP .NE. 0) THEN
C       Compute Cauchy flux at the time by interpolating Caculy-flux
C       profiles.
        CALL ALLFCT
     I             (TQCBF,QCBF,TIME,MXCPR,MXCDP,NCPR,NCDP,KCAI,
     O              QCB)
      END IF
C
      IF (NNNP .NE. 0) THEN
C       Compute Neumann flux at the time by interpolating Neumann-flux
C       profiles.
        CALL ALLFCT
     I             (TQNBF,QNBF,TIME,MXNPR,MXNDP,NNPR,NNDP,KNAI,
     O              QNB)
      END IF
C
C ------- Apply Dirichlet Boundary Conditions to Initial Conditions.
C
      DO 105 NPP = 1,NDNP
C       Put the Dirichlet concentrations into Dirichlet global nodes.
        NP     = NPDB(NPP)
        ITYP   = IDTYP(NPP)
        CP(NP) = CDB(ITYP)
  105 CONTINUE
C
C ------ Initiate the Solution Array C(NP).
C
      DO 110 NP = 1,NNP
C       Put initial concentrations CP(NP) into array C(NP).
        C(NP) = CP(NP)
  110 CONTINUE
C
C ******* DATA SET 17:  Hydrologic Data
C
      IF (KVI .LE. 0) THEN
C
C       Obtain Flow Variables From Cards
C
C       Read velocity
        READ(LUINP,1000) DATNAM
        NPI = 0
        DONEFG = 0
  120   CONTINUE
          READ(LUINP,*) NI,NSEQ,NAD,VXNI,VYNI,VZNI,VXAD,VYAD,VZAD
          IF (NI .EQ. 0) THEN
            DONEFG = 1
          END IF
          IF (DONEFG .EQ. 0) THEN
C           Automatically generate the velocity.
            NJ = NI + NSEQ
            DO 130 NP = NI,NJ
              I     = NI + (NP - NI)*NAD
              VX(I) = VXNI + VXAD*DBLE(NP - NI)
              VY(I) = VYNI + VYAD*DBLE(NP - NI)
              VZ(I) = VZNI + VZAD*DBLE(NP - NI)
              NPI   = NPI + 1
  130       CONTINUE
            GO TO 120
          ELSE IF (NPI .NE. NNP) THEN
C           Print error message and stop
            WRITE(LUOUT,2010)
            STOP
          END IF
C
C       Print velcoity.
        LINE = 0
        DO 150 NP = 1,NNP,2
          LINE = LINE + 1
          IF (MOD(LINE - 1,50) .EQ. 0) WRITE(LUOUT,2020)
          NJMN = NP
          NJMX = MIN0(NP + 1,NNP)
          WRITE(LUOUT,2030) (NJ,VX(NJ),VY(NJ),VZ(NJ),NJ = NJMN,NJMX)
  150   CONTINUE
C
C       Read moisture
        NPI = 0
        DONEFG = 0
  160   CONTINUE
          READ(LUINP,*) NI,NSEQ,NAD,THNI,THNIAD
          IF (NI .EQ. 0) THEN
            DONEFG = 1
          END IF
          IF (DONEFG .EQ. 0) THEN
            NJ = NI + NSEQ
            DO 175 NP = NI,NJ
              I = NI + (NP - NI)*NAD
              DO 170 IQ = 1,8
                TH(IQ,I) = THNI + THNIAD*DBLE(NP - NI)
  170         CONTINUE
              NPI = NPI + 1
  175       CONTINUE
            GO TO 160
          ELSE IF (NPI .NE. NEL) THEN
C         print error message and stop.
            WRITE(LUOUT,2040)
            STOP
          END IF
C
C       Print moisture content
        LINE = 0
        DO 190 NP = 1,NEL
          LINE = LINE + 1
          IF (MOD(LINE - 1,50) .EQ. 0) WRITE(LUOUT,2050)
          WRITE(LUOUT,2060) NP,(TH(IQ,NP),IQ = 1,8)
  190   CONTINUE
C
      ELSE
C
C       Read Flow Variables from Logical Unit LUFLW when KVI .GT. 0.
C
        READ(LUFLW) TIMEM,(H,NP = 1,NNP),(HT,NP = 1,NNP),((TH(IQ,M),
     >         IQ = 1,8),M = 1,NEL),(VX(NP),NP = 1,NNP),(VY(NP),
     >         NP = 1,NNP),(VZ(NP),NP = 1,NNP)
      END IF
C
C     Put the velocity VX(NP), VY(NP), and VZ(NP) into
C     VXP(NP), VYP(NP), and VZP(N), respectively.
      DO 310 NP = 1,NNP
        VXP(NP) = VX(NP)
        VYP(NP) = VY(NP)
        VZP(NP) = VZ(NP)
  310 CONTINUE
C
C     Put the moisture content TH(IQ,M) into THP(IQ,M)
      DO 330 M = 1,NEL
        DO 320 IQ = 1,8
          THP(IQ,M) = TH(IQ,M)
  320   CONTINUE
  330 CONTINUE
C
C     Compute the Moisture Content at All Nodes.
      CALL THNODE
     I           (TH,THP,PROP,IE,X,Y,Z,KSORP,
     O            THN,WWRK)
C
C     Compute Weighting Factors
      CALL AFABTA
     I           (X,Y,Z,IE,VX,VXP,VY,VYP,VZ,VZP,PROP,IOPTIM,
     O            WETAB)
C
C     Print Weighting Factors
      LINE = 0
      DO 340 MP = 1,NEL
        LINE = LINE + 1
        IF (MOD(LINE - 1,50) .EQ. 0) WRITE(LUOUT,2070)
        WRITE(LUOUT,2080) MP, (WETAB(IQ,MP),IQ = 1,12)
  340 CONTINUE
C
C     Compute Flux at All Nodes by Solving the Flux Law.
      CALL FLUX
     I         (CP,X,Y,Z,IE,WETAB,VX,VY,VZ,TH,PROP,
     O          FX,FY,FZ,CMATRX)
C
C     Initiate KFLOW to -1 to indicate initial or pre-initial condition
      KFLOW = -1
      CALL SFLOW
     I          (X,Y,Z,IE,C,FX,FY,FZ,TH,DCOSB,ISB,NPBB,SOS,
     I           ISTYP,LES,WSS,IWTYP,NPW,NPVB,NPDB,NPCB,NPNB,
     I           PROP,DELT,KFLOW,
     M           BFLX,BFLXP)
C
      DO 430 I = 1,14
        IF (I .NE. 8 .AND. I .NE. 9) THEN
          FLOW(I)  = 0.0
          TFLOW(I) = 0.0
        END IF
  430 CONTINUE
      FLOW(8) = 0.0
      FLOW(9) = 0.0
C
C     Print initial or pre-initial variables
      KDIAG = -2
      CALL PRINTT
     I           (LUOUT,CP,FX,FY,FZ,TIME,DELT,KPR0,-1,
     O            KOUT,KDIAG)
C
C     Store initial or pre-initial variables
      IF (KDSK0 .EQ. 1 .AND. KSS .EQ. 1) THEN
        CALL STORE
     I            (LUSTO,X,Y,Z,IE,CP,FX,FY,FZ,TITLE,NPROB,TIME)
      END IF
C
      IF (KSS .NE. 1) THEN
C
C $$$$$$$ PERFORM STEADY STATE COMPUTATION
C
C       Initial guess of nonlinear iterate CW and block iterate RI
        DO 460 NP = 1,NNP
          CW(NP) = OME*C(NP) + (1.0D0 - OME)*CP(NP)
          RI(NP) = CW(NP)
  460   CONTINUE
C
        DO 480 M = 1,NEL
          DO 470 IQ = 1,8
            DTH(IQ,M) = 0.0
            THP(IQ,M) = TH(IQ,M)
  470     CONTINUE
  480   CONTINUE
C
C       Write debugging information if desired.
        KDIG = KDIG + 1
        IF (IBUG .NE. 0) THEN
C         Print debugging information
          WRITE(LUOUT,2100) KDIG,TIME,DELT
          WRITE(LUOUT,2110)
        END IF
C
C ******* Begin the Nonlinear Iteration Loop.
C
        EPS = 0.5D0*TOLA
        ITER = 0
  540   CONTINUE
          ITER = ITER + 1
C
C         Assemble the coefficient matrix and construct the load vector.
          CALL ASEMBL
     I               (LUOUT,CW,CP,CSTAR,X,Y,Z,IE,LRN,WETAB,VX,VY,VZ,
     I                VXP,VYP,VZP,TH,THP,DTH,LES,ISTYP,SOS,NPW,
     I                IWTYP,WSS,PROP,DELT,KSS,DTI,
     O                CMATRX,RLD)
C
C         Apply boundary conditions
          CALL BC
     I           (X,Y,Z,IE,LRN,DCOSB,ISB,VX,VY,VZ,VXP,VYP,VZP,
     I            QCB,ISC,ICTYP,QNB,ISN,INTYP,CVB,ISV,IVTYP,CDB,
     I            IDTYP,NPDB,
     O            CMATRX,RLD)
C
C         Solve the matrix equation with block iterations
          CALL BLKITR
     I               (LUOUT,CMTRXL,RLDL, CMATRX,RLD, GNLR,LNOJCN,
     I                NNPLR,LMAXDF, EPS,NPITER,IBUG,KPR0,OMI,
     O                C,RI)
C
C         Check nonlinear loop convergence
          DIFMAX = 0.0
          NOCCUR = 1
          DO 520 NP = 1,NNP
            IF (CW(NP) .NE. 0.0) THEN
              DIF = (C(NP) - CW(NP))/CW(NP)
              DIF = DABS(DIF)
              IF (DIF .GT. DIFMAX) THEN
                DIFMAX = DIF
                NOCCUR = NP
              END IF
            END IF
  520     CONTINUE
C
C         Update nonlinear iterate
          DO 530 NP = 1,NNP
            CW(NP) = OME*C(NP) + (1.0D0 - OME)*CW(NP)
            RI(NP) = CW(NP)
  530     CONTINUE
C
          IF (NITER .NE. 1) THEN
            IF (IBUG .NE. 0) WRITE(LUOUT,2120) ITER,DIFMAX,TOLA,NOCCUR
C
            IF (ITER .EQ. 1) THEN
              IF (ITER .LT. NITER) GO TO 540
              IF (ITER .GE. NITER) THEN
                WRITE(LUOUT,2130) ITER,NITER,DIFMAX,TOLA,NOCCUR
              END IF
            END IF
C
            IF (ITER .NE. 1) THEN
              IF (DIFMAX .GT. TOLA .AND. ITER .LT. NITER) GO TO 540
              IF (DIFMAX .GT. TOLA .AND. ITER .GE. NITER) THEN
C               Nonlinear loop has been completed but no convergent
C               solution has been obtained, print the error message
C               and stop
                WRITE(LUOUT,2130) ITER,NITER,DIFMAX,TOLA,NOCCUR
                STOP
              END IF
            END IF
          END IF
C
C ******* End the Nonlinear Iteration Loop.
C
C       Put the steady state solution C(NP) into CP(NP) for transient
C       state computation.
        DO 555 NP = 1,NNP
          CP(NP) = C(NP)
  555   CONTINUE
C
C       Compute steady state flux at all nodes
        CALL FLUX
     I           (CP,X,Y,Z,IE,WETAB,VX,VY,VZ,TH,PROP,
     O            FX,FY,FZ,CMATRX)
C
C       Compute mass balance for steady state solution
        KFLOW = 0
        CALL SFLOW
     I            (X,Y,Z,IE,C,FX,FY,FZ,TH,DCOSB,ISB,NPBB,SOS,
     I             ISTYP,LES,WSS,IWTYP,NPW,NPVB,NPDB,NPCB,NPNB,
     I             PROP,DELT,KFLOW,
     M             BFLX,BFLXP)
C
        DO 560 I = 1,14
          IF (I .NE. 8 .AND. I .NE. 9) THEN
            FLOW(I)  = 0.0
            TFLOW(I) = 0.0
          END IF
  560   CONTINUE
        FLOW(8) = 0.0
        FLOW(9) = 0.0
C
C       Print steady state variables.
        KDIAG = -1
        CALL PRINTT
     I             (LUOUT,CP,FX,FY,FZ,TIME,DELT,KPR0,0,
     O              KOUT,KDIAG)
C
C       Store steady state solution
        IF (KDSK0 .EQ. 1) THEN
          CALL STORE
     I              (LUSTO,X,Y,Z,IE,CP,FX,FY,FZ,TITLE,NPROB,TIME)
        END IF
      END IF
C
C     Steady State Computation Has Been Completed, Check if Transient
C     State Solution Is to Be Performed?
C
      IF (NTI .NE. 0) THEN
        KSS = 1
C
C $$$$$$$ Perform Transient-State or Transient Computation
C
        TIME = TIME + DELT
        KFLOW    = 1
        TFLOW(8) = 0.0
        TFLOW(9) = 0.0
        KDIAG    = 0
        IDELT    = 0
        EPS      = 0.5D0*TOLB
C
C ******* Beginning of Time Loop
C
        DO 890 ITM = 1,NTI
C
          IF (TIME .LE. TMAX) THEN
            JTM  = ITM
            KPRZ = KPR(JTM)
            KDSZ = KDSK(JTM)
C
C           Compute source and boundary condition values at the present
C           time
C
            IF (NSEL .NE. 0) THEN
C             Obtain element-wide source values
              CALL ALLFCT
     I              (TSOSF,SOSF(1,1,1),TIME,MXSPR,MXSDP,NSPR,NSDP,KSAI,
     O               SOS(1,1))
              CALL ALLFCT
     I              (TSOSF,SOSF(1,1,2),TIME,MXSPR,MXSDP,NSPR,NSDP,KSAI,
     O               SOS(1,2))
            END IF
C
            IF (NWNP .NE. 0) THEN
C             Obtain point source values
              CALL ALLFCT
     I              (TWSSF,WSSF(1,1,1),TIME,MXWPR,MXWDP,NWPR,NWDP,KWAI,
     O               WSS(1,1))
              CALL ALLFCT
     I              (TWSSF,WSSF(1,1,2),TIME,MXWPR,MXWDP,NWPR,NWDP,KWAI,
     O               WSS(1,2))
            END IF
C
            IF (NDNP .NE. 0) THEN
C             Obtain Dirichlet concentration
              CALL ALLFCT
     I                   (TCDBF,CDBF,TIME,MXDPR,MXDDP,NDPR,NDDP,KDAI,
     O                    CDB)
            END IF
C
            IF (NVES .NE. 0) THEN
C             Obtain variable-concentration
              CALL ALLFCT
     I                   (TCVBF,CVBF,TIME,MXRPR,MXRDP,NRPR,NRDP,KRAI,
     O                    CVB)
            END IF
C
            IF (NCNP .NE. 0) THEN
C             Obtain Cauchy flux
              CALL ALLFCT
     I                   (TQCBF,QCBF,TIME,MXCPR,MXCDP,NCPR,NCDP,KCAI,
     O                    QCB)
            END IF
C
            IF (NNNP .NE. 0) THEN
C             Obtain Neumann flux
              CALL ALLFCT
     I                   (TQNBF,QNBF,TIME,MXNPR,MXNDP,NNPR,NNDP,KNAI,
     O                    QNB)
            END IF
C
C           Put veloity components VX(NP), VY(NP), and VZ(NP) into
C           VXP(NP), VY(NP), and VZ(NP), respectively.
            DO 610 NP = 1,NNP
              VXP(NP) = VX(NP)
              VYP(NP) = VY(NP)
              VZP(NP) = VZ(NP)
  610       CONTINUE
C
C           Put moisture content TH(IQ,M) into array THP(IQ,M)
            DO 618 M = 1,NEL
              DO 615 IQ = 1,8
                THP(IQ,M) = TH(IQ,M)
  615         CONTINUE
  618       CONTINUE
C
            IF (KVI .EQ. 2) THEN
C
C             Read time-dependent hydrologic variables, and compute
C             moisture content at all nodes and weighting factors.
C
              READ(LUFLW) TIMEM,(H,NP = 1,NNP),(HT,NP = 1,NNP),
     >                 ((TH(IQ,M),IQ = 1,8),M = 1,NEL),
     >                 (VX(NP),NP = 1,NNP),(VY(NP),NP = 1,NNP),
     >                 (VZ(NP),NP = 1,NNP)
C
              CALL THNODE
     I                   (TH,THP,PROP,IE,X,Y,Z,KSORP,
     O                    THN,WWRK)
              CALL AFABTA
     I                   (X,Y,Z,IE,VX,VXP,VY,VYP,VZ,VZP,PROP,IOPTIM,
     O                    WETAB)
            END IF
C
C           Update CP and Estimate nonlinear iterate CW for computing
C           coefficient matrix and load vector.
            DO 624 NPP = 1,NDNP
              NP    = NPDB(NPP)
              ITYP  = IDTYP(NPP)
              C(NP) = CDB(ITYP)
  624       CONTINUE
            DO 625 NP = 1,NNP
              CP(NP) = C(NP)
              CW(NP) = C(NP)
  625       CONTINUE
C
C           Compute dTH/dt
            DO 633 M = 1,NEL
              DO 630 IQ = 1,8
                DTH(IQ,M) = (TH(IQ,M) - THP(IQ,M))/DELT
  630         CONTINUE
  633       CONTINUE
C
C *******   Compute Advection Concentration
C
            DO 640 I=1,NNP
              VXBAR(I)=0.5*(VX(I)+VXP(I))/THN(I)
              VYBAR(I)=0.5*(VY(I)+VYP(I))/THN(I)
              VZBAR(I)=0.5*(VZ(I)+VZP(I))/THN(I)
  640       CONTINUE
C
C           Compute Lagrangian Concentrations CSTAR
            CALL ADVBC
     I                (THN,IE,X,Y,Z,VX,VY,VZ,VXP,VYP,VZP,DCOSB,ISB,
     I                 NPBB,CVB,IVTYP,ISV,NPVB,CDB,IDTYP,NPDB,QCB,
     I                 ICTYP,ISC,NPCB,
     M                 RI,RL,
     O                 CSTAR)
C
C           Excute backward tracking
            DO 645 NPP = 1,NNP
              DTI(NPP)=1.0D0/DELT
  645       CONTINUE
            CALL BTGN
     I               (X,Y,Z,VXBAR,VYBAR,VZBAR,IB,NLRL,LRL,IE,CP,MAXNP,
     I                MAXEL,DELT,NNP,luout,nti,MXKBD,
     M                CSTAR,DTI)
C
C           Incorpotate boundary condition for the Lagrangian step.
            CALL ADVBC
     I                (THN,IE,X,Y,Z,VX,VY,VZ,VXP,VYP,VZP,DCOSB,ISB,
     I                 NPBB,CVB,IVTYP,ISV,NPVB,CDB,IDTYP,NPDB,QCB,
     I                 ICTYP,ISC,NPCB,
     M                 RI,RL,
     O                 CSTAR)
C
            KDIG = KDIG + 1
            IF (IBUG .NE. 0 .AND. KPRZ .EQ. 0) THEN
              WRITE(LUOUT,2100) KDIG,TIME,DELT
            END IF
            IF (IBUG .NE. 0 .AND. KPRZ .NE. 0) WRITE(LUOUT,2110)
C
C %%%%%%%   Begin the Nonlinear Iteration Loop.
C
            DO 650 NP = 1,NNP
C           Make initial guess for block iteration
              RI(NP) = CW(NP)
  650       CONTINUE
C
C
            ITER = 0
  740       CONTINUE
              ITER = ITER + 1
C
C             Assemble coefficient matrix and construct load vector
              CALL ASEMBL
     I                   (LUOUT,CW,CP,CSTAR,X,Y,Z,IE,LRN,WETAB,VX,VY,VZ,
     I                    VXP,VYP,VZP,TH,THP,DTH,LES,ISTYP,SOS,NPW,
     I                    IWTYP,WSS,PROP,DELT,KSS,DTI,
     O                    CMATRX,RLD)
C
C             Apply global boundary conditions
              CALL BC
     I               (X,Y,Z,IE,LRN,DCOSB,ISB,VX,VY,VZ,VXP,VYP,VZP,
     I                QCB,ISC,ICTYP,QNB,ISN,INTYP,CVB,ISV,IVTYP,CDB,
     I                IDTYP,NPDB,
     O                CMATRX,RLD)
C
C             Solve the matrix equation by block iteration
              CALL BLKITR
     I                   (LUOUT,CMTRXL,RLDL, CMATRX,RLD, GNLR,LNOJCN,
     I                    NNPLR,LMAXDF, EPS,NPITER,IBUG,KPRZ,OMI,
     O                    C,RI)
C
C             Check convergency of nonlinear loop
              DIFMAX = 0.0
              NOCR   = 1
              DO 720 NP = 1,NNP
                IF (CW(NP) .NE. 0.0) THEN
                  DIF = (C(NP) - CW(NP))/CW(NP)
                  DIF = DABS(DIF)
                  IF (DIF .GT. DIFMAX) THEN
                    DIFMAX = DIF
                    NOCR   = NP
                  END IF
                END IF
  720         CONTINUE
C
C             Update nonlinear iterate CW for computing coefficient
C             matrix and load vector.
              DO 730 NP = 1,NNP
                CW(NP) = OME*C(NP) + (1.0D0 - OME)*CW(NP)
                RI(NP) = CW(NP)
  730         CONTINUE
C
              IF (NITER .NE. 1) THEN
                IF (IBUG .NE. 0 .AND. KPRZ .NE. 0) THEN
                  WRITE(LUOUT,2120) ITER,DIFMAX,TOLB,NOCR
                END IF
C
                IF (ITER .EQ. 1) THEN
                  IF (ITER .LT. NITER) GO TO 740
                  IF (ITER .GE. NITER) THEN
                    WRITE(LUOUT,2140) ITM,ITER,NITER,DIFMAX,TOLB,NOCR
                  END IF
                END IF
C
                IF (ITER .NE. 1) THEN
                  IF (DIFMAX .GE. TOLB .AND. ITER .LT. NITER) GO TO 740
                  IF (DIFMAX .GE. TOLB .AND. ITER .GE. NITER) THEN
                    WRITE(LUOUT,2140) ITM,ITER,NITER,DIFMAX,TOLB,NOCR
                  END IF
                END IF
              END IF
C
C %%%%%%%   End of Nonlinear Loop.
C
C           Calculate material flux FX, FY, and FZ for the present time
            CALL FLUX
     I               (C,X,Y,Z,IE,WETAB,VX,VY,VZ,TH,PROP,
     O                FX,FY,FZ,CMATRX)
C
C           Determine flux through all boundaries at present time
            CALL SFLOW
     I                (X,Y,Z,IE,C,FX,FY,FZ,TH,DCOSB,ISB,NPBB,SOS,
     I                 ISTYP,LES,WSS,IWTYP,NPW,NPVB,NPDB,NPCB,NPNB,
     I                 PROP,DELT,KFLOW,
     M                 BFLX,BFLXP)
C
C           Print variables at current time step
            CALL PRINTT
     I                 (LUOUT,C,FX,FY,FZ,TIME,DELT,KPRZ,JTM,
     O                  KOUT,KDIAG)
C
C           Store solution at the current time step
            IF (KDSZ .EQ. 1) THEN
              CALL STORE
     I                  (LUSTO,X,Y,Z,IE,C,FX,FY,FZ,TITLE,NPROB,TIME)
            END IF
C
C           Prepare variables for next time step computation
            DELT = DELT*(1.0D0 + CHNG)
            DELT = DMIN1(DELT,DELMAX)
            IF (IDELT .NE. 0) THEN
              IF (TIME .EQ. TDTCH(IDELT)) DELT = DELT0
            END IF
            TIME = TIME + DELT
            IF (TIME .GE. TDTCH(IDELT + 1)) THEN
              IDELT = IDELT + 1
              TIME  = TIME - DELT
              DELT  = TDTCH(IDELT) - TIME
              IF (DELT .LE. 0.0) THEN
                DELT = DELT0
              END IF
              TIME = TIME + DELT
            END IF
          END IF
  890   CONTINUE
C
C ******* End of Time Loop
C
      END IF
C
      RETURN
      END
