      PROGRAM   LEWAST3D
C
C --------------------------------------------------------------------------
C Date: Tuesday, 10 August 1993.  Time: 07:41:08.
C --------------------------------------------------------------------------
C User recompiling and re-linking any portion of LEWASTE model code
C must search all source code files (*.INC, *.FOR) to locate system and/or
C compiler specific statements.  Search on the following character strings:
C      CPC - statements used for standard microcomputer for Lahey FORTRAN
C      NDP - statements used for microcomputer for NDP FORTRAN
C LEWASTE code has not be run time tested under any other microcomputer
C FORTRAN development tools.
C --------------------------------------------------------------------------
C
C ------- MAIN PROGRAM OF 3DLEWASTE - BLOCK ITERATION
C
C     + + + PARAMETERS + + +
      INCLUDE 'PMXSD.INC'
      INCLUDE 'PMXTD.INC'
      INCLUDE 'PMXSR.INC'
      INCLUDE 'PMXSS.INC'
      INCLUDE 'PMXCB.INC'
      INCLUDE 'PMXNB.INC'
      INCLUDE 'PMXRSB.INC'
      INCLUDE 'PMXDB.INC'
      INCLUDE 'PMXMS.INC'
C
C     + + + COMMON BLOCKS + + +
      INCLUDE 'SGEOM.INC'
      INCLUDE 'CGEOM.INC'
      INCLUDE 'LGEOM.INC'
      INCLUDE 'CINTE.INC'
      INCLUDE 'CREAL.INC'
      INCLUDE 'CELS.INC'
      INCLUDE 'CNPS.INC'
      INCLUDE 'CCBC.INC'
      INCLUDE 'CNBC.INC'
      INCLUDE 'CVBC.INC'
      INCLUDE 'CDBC.INC'
      INCLUDE 'MATL.INC'
      INCLUDE 'OPTN.INC'
      INCLUDE 'WETX.INC'
      INCLUDE 'WETY.INC'
      INCLUDE 'WETZ.INC'
      INCLUDE 'CFLOW.INC'
C
      INTEGER            IE(MAXELK,9),LRN(MXJBDK,MAXNPK),
     >                   LRL(MXKBDK,MAXNPK),GNLR(LTMXNK,MXRGNK),
     >                   LNOJCN(MXJBDK,LMXNPK,MXRGNK),
     >                   NTNPLR(MXRGNK),NNPLR(MXRGNK),LMAXDF(MXRGNK),
     >                   ISB(6,MXBESK),NPBB(MXBNPK),ISTYP(MXSELK),
     >                   LES(MXSELK),IWTYP(MXWNPK),NPW(MXWNPK),
     >                   ICTYP(MXCESK),ISC(5,MXCESK),NPCB(MXCNPK),
     >                   INTYP(MXNESK),ISN(5,MXNESK),NPNB(MXNNPK),
     >                   IVTYP(MXVESK),ISV(5,MXVESK),NPVB(MXVNPK),
     >                   IDTYP(MXDNPK),NPDB(MXDNPK), KPR(MXNTIK),
     >                   IB(MAXNPK),NLRL(MAXNPK),
     >                   KDSK(MXNTIK),LUINP,LUOUT,LUFLW,LUSTO,LUBAR,
     >                   LUPAR
C
C     + + + VARIABLE DEFINITION + + +
C --- Arrays of discretization
C     IE(M,I)  - global node number of the I-th node of the M-th element
C                if I is between 1 and 8
C     IE(M,9)  - integer to indicate the material type of the M-th
C                element
C     LRN(I,N) - global node number of the I-th node connecting
C                to the N-th global node
C     LRL(I,N) - global element number of the I-th element connecting
C                to the N-th global node
C     NLRL(N)  - total number of elements connecting to the N-th global
C                node
C --- Subregion Arrays
C     GNLR(I,K)     - global nodal number of the I-th local nodal
C                     number in the K-th subregion.  This array is an
C                     input for I = 1, 2, ..,  NNPLR(K).
C                     For = NNPLR(K)+1, ... NTNPLR(K), this array is
C                     generated based on IE(NEL,8) and inputted GNLR.
C     LNOJCN(J,I,K) - local node number of the J-th node connecting to
C                     the I-th local node for the K-th subregion.
C                     This array is genereated from GNLR and IE.
C                     I = 1, 2, 3, ...., NNPLR(K).
C     NTNPLR(K)     - total number of nodes for the K-th subregion
C                     including interior, global boundary, and intra-
C                     boundary nodes
C     NNPLR(K)      - number of nodes for the K-th subregion including
C                     interior and global boundary nodes
C     LMAXDF(K)     - maximum number of difference between nodes for
C                     any element in the K-th local region.
C                     This array is genereated from the array LNOJCN.
C --- Boundary Arryas
C     ISB(1,I)   - boundary node number of the first node of the I-th
C                  boundary side
C     ISB(2,I)   - boundary node number of the second node of the I-th
C                  boundary side
C     ISB(3,I)   - boundary node number of the third node of the I-th
C                  boundary side
C     ISB(4,I)   - boundary node number of the fourth node of the I-th
C                  boundary side
C     ISB(5,I)   - element side index of the I-th boundary side
C                  1=left side, 2=front side, 3=right side,
C                  4=back side, 5=bottom side, 6=top side
C     ISB(6,I)   - element number to which the I-th boundary side belong
C     NPBB(I)    - global node number of the I-the boundary node
C --- Source Arrays
C     ISTYP(M)    - type of source profile assigned to the M-th element
C     LES(I)      - global element number of the I-th element-source
C     IWTYP(I)    - type of source profile assigned to the I-th node
C     NPW(I)      - global node number of the I-th well node
C --- Cauchy Boundary Condition Arrays
C     ICTYP(MP)  - type of Cauchy flux profile assigned to the MP-th
C                  Cauchy side
C     ISC(1,MP)  - global node number of the first node of the Mp-th
C                  Cauchy side
C     ISC(2,MP)  - global node number of the second node of the Mp-th
C                  Cauchy side
C     ISC(3,MP)  - global node number of the third node of the Mp-th
C                  Cauchy side
C     ISC(4,MP)  - global node number of the fourth node of the Mp-th
C                  Cauchy side
C     ISC(5,MP)  - boundary side number of the MP-th Cauchy side
C     NPCB(NP)   - global nodal number of the NP-Cauchy node on input
C                  Then is changed to contain boundary node number
C --- Neumann Boundary Arrays
C     INTYP(MP)  - type of Neumann flux profile assigned to the MP-th
C                  Neumann side
C     ISN(1,MP)  - global node number of the first node of the Mp-th
C                  Neumann side
C     ISN(2,MP)  - global node number of the second node of the Mp-th
C                  Neumann side
C     ISN(3,MP)  - global node number of the third node of the Mp-th
C                  Neumann side
C     ISN(4,MP)  - global node number of the fourth node of the Mp-th
C                  Neumann side
C     ISN(5,MP)  - boundary side number of the MP-th Neumann side
C     NPNB(NP)   - global nodal number of the NP-Neumann node on input
C                  Then is changed to contain boundary node number
C --- Variable Boundary Arrays
C     IVTYP(MP)  - type of variable concentration profile assigned to
C                  the MP-th variable side
C     ISV(1,MP)  - global node number of the first node of the Mp-th
C                  Variable side
C     ISV(2,MP)  - global node number of the second node of the Mp-th
C                  variable side
C     ISV(3,MP)  - global node number of the third node of the Mp-th
C                  variable side
C     ISV(4,MP)  - global node number of the fourth node of the Mp-th
C                  variable side
C     ISV(5,MP)  - boundary side number of the MP-th variable side
C     NPVB(NP)   - global nodal number of the NP-variable node on input
C                  Then is changed to contain boundary node number
C --- Dirichlet Boundary Arrays
C     IDTYP(NP)  - type of Dirichlet concentration profile assigned to
C                  the NP-th Dirichlet node
C     NPDB(NP)   - global nodal number of the NP-Dirichlet node on input
C                  Then is changed to contain boundary node number
C --- Time Control Arrays
C     KPR(I)   - line printing indicator for the I-th time step
C                 0 = print nothing
C                 1 = print fluxes through all types of boundaries
C                 2 = print concentration also
C                 3 = print mateiral flux also
C     KDSK(I)  - store results on logical unit 12? 0=no, 1=yes
C --- Logical unit
C     LUINP  - logical unit for input data
C     LUOUT  - logical unit for output data
C     LUFLW  - logical unit for flow data
C     LUSTO  - logical unit for store binary output
C     LUBAR  - logical unit for store binary boundary arrays
C     LUPAR  - logical unit for store binary pointer arrays
C
      DOUBLE PRECISION   C(MAXNPK),CP(MAXNPK),CW(MAXNPK),CSTAR(MAXNPK),
     >                   FX(MAXNPK),FY(MAXNPK),FZ(MAXNPK),
     >                   X(MAXNPK),Y(MAXNPK),Z(MAXNPK),
     >                   CMATRX(MAXNPK,MXJBDK),RLD(MAXNPK),
     >                   RI(MAXNPK),RL(MAXNPK),WWRK(MAXNPK),
     >                   CMTRXL(LMXNPK,LMXBWK), RLDL(LMXNPK),
     >                   DCOSB(3,MXBESK),BFLX(MXBNPK),BFLXP(MXBNPK),
     >                   WETAB(12,MAXELK),VX(MAXNPK),VY(MAXNPK),
     >                   VZ(MAXNPK),VXBAR(MAXNPK),VYBAR(MAXNPK),
     >                   VZBAR(MAXNPK),VXP(MAXNPK),VYP(MAXNPK),
     >                   VZP(MAXNPK),TH(8,MAXELK),THP(8,MAXELK),
     >                   DTH(8,MAXELK),THN(MAXNPK),SOS(MXSPRK,2),
     >                   SOSF(MXSDPK,MXSPRK,2),TSOSF(MXSDPK,MXSPRK),
     >                   WSS(MXWPRK,2),WSSF(MXWDPK,MXWPRK,2),
     >                   TWSSF(MXWDPK,MXWPRK),QCB(MXCPRK),
     >                   QCBF(MXCDPK,MXCPRK),TQCBF(MXCDPK,MXCPRK),
     >                   QNB(MXNPRK),QNBF(MXNDPK,MXNPRK),
     >                   TQNBF(MXNDPK,MXNPRK),CVB(MXVPRK),
     >                   CVBF(MXVDPK,MXVPRK),TCVBF(MXVDPK,MXVPRK),
     >                   CDB(MXDPRK),CDBF(MXDDPK,MXDPRK),
     >                   TCDBF(MXDDPK,MXDPRK),PROP(MXMPMK,MXMATK)
      DOUBLE PRECISION   TDTCH(MXDTCK),DTI(MAXNPK)
C
C     + + + VARIABLE DEFINITION + + +
C --- Solution Arrays for Concentrations and Fluxes
C     C(N)     - Concentration of the N-th node at the present time
C     CP(N)    - Concentration of the N-th node at previous time
C     CSTAR(N) - Lagrangian concentration at the N-th node
C     CW(N)    - Nonlinear iterate of concentration at the N-th node
C     FX(N)    - x-direction material flux at the N-th node
C     FY(N)    - y-direction material flux at the N-th node
C     FZ(N)    - z-direction material flux at the N-th node
C --- Arrays of Discretization
C     X(N)     - x-coordiante of the N-th node
C     Y(N)     - y-coordinate of the N-th node
C     Z(N)     - z-coordinate of the N-th node
C---- Global Matrix Arrays
C     CMATRX(N,I) - an array to store the I-th non-zero entry of the
C                   N-th equation of the assembled global matrix
C     RLD(N)      - an array to store the right hand side of the N-th
C                   equation of the assembled global load vector
C     DTI(N)      - an array to store the reciprocal value of real
C                   diffusion time of the N-th global node
C --- Working Arrays
C     RI(N)  - A working array used in subroutines BLKITR and ADVBC
C     RL     - A working array used in subroutine ADVBC
C     WWRK   - A working array used in subroutine THNODE
C --- Subregion arrays
C     CMTRXL(N,I)   - assembled matrix for a subregion
C     RLDL(N)       - assembled load vector for a subregion
C --- Boundary Arryas
C     DCOSB(1,I) - x-directional cosine of the I-th boundary side
C     DCOSB(2,I) - y-directional cosine of the I-th boundary side
C     DCOSB(3,I) - z-directional cosine of the I-th boundary side
C     BFLX(I)    - boundary flux at the I-th boundary node
C     BFLXP(I)   - value of BFLX(I) at previous time
C --- Hydrologic-Variables Arrays
C     WETAB(J,M) - weighting factor for the J-the side of the M-th
C                  element
C     VX(N)      - x-component velocity at the N-th node
C     VY(N)      - y-component velocity at the N-th node
C     VZ(N)      - z-component velocity at the N-th node
C     VXP(N)     - value of VX(N) at previous time
C     VYP(N)     - value of VY(N) at previous time
C     VZP(N)     - value of VZ(N) at previous time
C     TH(I,M)    - moisture content at the I-th node of the M-th element
C     THP(I,M)   - value of TH(I,M) at the previous time
C     DTH(I,M)   - (TH(I,M)-THP(I,M))/DELT
C     THN(N)     - moisture content at the N-th node
C --- Source Arrays
C     SOS(I,1)    - source flow rate of the I-th profile at time t
C     SOS(I,2)    - source concentration of the I-th profile at time t
C     SOSF(I,J,1) - source flow rate of the I-th data point in
C                   the J-th profile
C     SOSF(I,J,2) - source concentration of the I-th data point in
C                   the J-th profile
C     TSOSF(I,J)  - time of the I-th data point in the J-the profile
C     WSS(I,1)    - well source flow rate of the I-th profile at time t
C     WSS(I,2)    - well source concentration of the I-th profile
C     WSSF(J,I,1) - well-source flow rate of the I-th data point in
C                   the J-th profile
C     WSSF(J,I,2) - well-source concentration of the I-th data point in
C                   the J-th profile
C     TWSSF(J,I)  - time of the J-th data point in the J-th profile
C --- Cauchy Boundary Condition Arrays
C     QCB(I)     - Value of Cauchy flux at the presnet time of the
C                  I-th Cauchy flux profile
C     QCBF(I,J)  - Flux of the I-th data point in the J-th
C                  Cauchy flux vs time profile
C     TQCBF(I,J) - time of the I-th data point in the J-th
C                  Cauchy flux vs time profile
C --- Neumann Boundary Arrays
C     QNB(I)     - Value of Neumann flux at the presnet time of the
C                  I-th Neumann flux profile
C     QNBF(I,J)  - Flux of the I-th data point in the J-th
C                  Neumann flux vs time profile
C     TQNBF(I,J) - time of the I-th data point in the J-th
C                  Neumann flux vs time profile
C --- Variable Boundary Arrays
C     CVB(I)     - variable concentration of the I-th profile
C                  at the present time
C     CVBF(I,J)  - concentration of the I-th data point in the J-th
C                  variable concentration vs time profile
C     TCVBF(I,J) - time of the I-th data point in the J-th
C                  variable concentration vs time profile
C --- Dirichlet Boundary Arrays
C     CDB(I)     - Dirichlet concentration of the I-th profile
C                  at the present time
C     CDBF(I,J)  - concentration of the I-th data point in the J-th
C                  Dirichlet concentration vs time profile
C     TCDBF(I,J) - time of the I-th data point in the J-th
C                  Dirichlet concentration vs time profile
C --- Material Arrays
C     PROP(J,I) - J-the material property of the I-th material
C                 PROP(1,I) = distribution coefficient or
C                             Freundlich K or Langmuir K
C                 PROP(2,I) = bulk density
C                 PROP(3,I) = longitudinal dispersivity
C                 PROP(4,I) = lateral dispersivity
C                 PROP(5,I) = molecular diffusion coefficient
C                 PROP(6,I) = tortuosity
C                 PROP(7,I) = decay constant
C                 PROP(8,I) = Freundlich N or Langmuir SMAX
C --- Time Control Arrays
C     TDTCH(I) - time of the I-th time to reset time-step size = DELT0
C
C     + + + LOCAL VARIABLES + + +
      DOUBLE PRECISION   SGNBR,EPSIN
      CHARACTER*80       DATAFL,OUTFL,STORFL,FLOWFL,BARFL,PARFL,CHKFL
C
      CHARACTER*1        ANS
      CHARACTER*26       VERNUM
C
C     + + + EXTERNALS + + +
      EXTERNAL   CLRSCR
C
C     + + + END SPECIFICATIONS + + +
C
      ANS    = ' '
      VERNUM = ' Version 1.00 / July 1993 '
C
C     + + + INPUT FORMATS + + +
 1000 FORMAT(A80)
C
C     + + + OUTPUT FORMATS + + +
 2000 FORMAT('1','*** MACHINE SIGNIFICANT NUBMER, SGNBR = ',1PD15.6)
C
      MAXNP  = MAXNPK
      MAXEL  = MAXELK
      MAXBNP = MXBNPK
      MAXBES = MXBESK
      MXJBD  = MXJBDK
      MXKBD  = MXKBDK
      MXNTI  = MXNTIK
      MXDTC  = MXDTCK
      LTMXNP = LTMXNK
      LMXNP  = LMXNPK
      LMXBW  = LMXBWK
      MXREGN = MXRGNK
      MXSEL  = MXSELK
      MXSPR  = MXSPRK
      MXSDP  = MXSDPK
      MXWNP  = MXWNPK
      MXWPR  = MXWPRK
      MXWDP  = MXWDPK
      MXCNP  = MXCNPK
      MXCES  = MXCESK
      MXCPR  = MXCPRK
      MXCDP  = MXCDPK
      MXNNP  = MXNNPK
      MXNES  = MXNESK
      MXNPR  = MXNPRK
      MXNDP  = MXNDPK
      MXVNP  = MXVNPK
      MXVES  = MXVESK
      MXRPR  = MXVPRK
      MXRDP  = MXVDPK
      MXDNP  = MXDNPK
      MXDPR  = MXDPRK
      MXDDP  = MXDDPK
      MAXMAT = MXMATK
      MXMPPM = MXMPMK
CC
      LUINP = 15
      LUOUT = 16
      LUFLW = 11
      LUSTO = 12
      LUBAR = 13
      LUPAR = 14
C
      CALL CLRSCR
      INCLUDE 'ANNOUN.INC'
      CALL CLRSCR
      WRITE (*,10)
   10 FORMAT(//,1X,'LEWASTE Program')
      WRITE (*,12)
   12 FORMAT(1X,'Run-time Input Parameter Screen')
      WRITE (*,14)
   14 FORMAT(1X,'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~',/)
C
C     query names of required files
CNDP
      WRITE(*,15)
   15 FORMAT(/,' Type input data file name, then press <Enter> key: ',$)
CNDP
CPC      PRINT *,' Type input data file name, then press <Enter> key: ',$
C
      READ (*,1000) DATAFL
C
CNDP
      WRITE(*,16)
   16 FORMAT(/,' Type output file name, then press <Enter> key: ',$)
CNDP
CPC      PRINT *,' Type output file name, then press <Enter> key: '
      READ (*,1000) OUTFL
C
CNDP
      WRITE(*,17)
   17 FORMAT(/,' Type output flow file name, then press <Enter> key: ',
     1$)
CNDP
CPC      PRINT *,' Type output flow file name, then press <Enter> key: '
      READ (*,1000) FLOWFL
C
CNDP
      WRITE(*,18)
   18 FORMAT(/,' Type output storage file name, then press <Enter> key: 
     1',$)
CNDP
CPC      PRINT *,' Type output storage file name, then press <Enter> key: '
      READ (*,1000) STORFL
C
CNDP
      WRITE(*,19)
   19 FORMAT(/,' Type output boundary array file name, then press <Enter
     1> key: ',$)
CNDP
CPC      PRINT *,' Type output boundary array file name, then press <Enter>
CPC     1 key: '
      READ (*,1000) BARFL
C
CNDP
      WRITE(*,20)
   20 FORMAT(/,' Type output pointer array file name, then press <Ente',
     1'r> key: ',$)
CNDP
CPC      PRINT *,' Type output pointer array file name, then press <Enter>
CPC     1key: '
      READ (*,1000) PARFL
C
      CALL CLRSCR
      WRITE (*,21)
   21 FORMAT(///////////,1X,
     1 '                       Executing LEWASTE program...wait.')
C
C      PRINT *,' PLEASE INPUT YOUR DATA FILE NAME.'
C      READ (*,1000) DATAFL
C      PRINT *,' THEN, YOUR OUTPUT FILE NAME.'
C      READ (*,1000) OUTFL
C      PRINT *,'THEN, YOUR FLOW FILE NAME.'
C      READ (*,1000) FLOWFL
C      PRINT *,' THEN, YOUR STORAGE FILE NAME.'
C      READ (*,1000) STORFL
C      PRINT *,' THEN, YOUR BOUNDARY ARRAY FILE NAME.'
C      READ (*,1000) BARFL
C      PRINT *,' THEN, YOUR POINTER ARRAY FILE NAME.'
C      READ (*,1000) PARFL
C
      OPEN(UNIT=LUINP,FILE=DATAFL,STATUS='UNKNOWN',ACCESS='SEQUENTIAL',
     1                FORM='FORMATTED',CARRIAGECONTROL='LIST')
C      OPEN (UNIT=LUINP,FILE=DATAFL,STATUS='UNKNOWN')
      OPEN (UNIT=LUOUT,FILE=OUTFL,STATUS='UNKNOWN')
      OPEN (UNIT=LUFLW,FILE=FLOWFL,FORM='UNFORMATTED',STATUS='UNKNOWN')
      OPEN (UNIT=LUSTO,FILE=STORFL,FORM='UNFORMATTED',STATUS='UNKNOWN')
      OPEN (UNIT=LUBAR,FILE=BARFL,FORM='UNFORMATTED',STATUS='UNKNOWN')
      OPEN (UNIT=LUPAR,FILE=PARFL,FORM='UNFORMATTED',STATUS='UNKNOWN')
C
CC
      SGNBR=1.0D0
  100 CONTINUE
        SGNBR=SGNBR/2.0D0
        EPSIN=1.0D0+SGNBR
      IF (EPSIN.GT.1.0D0) GO TO 100
      WRITE(LUOUT,2000) SGNBR
C
C     Pass the program to GM3D
      CALL GM3D
     I         (LUINP,LUOUT,LUFLW,LUSTO,LUBAR,LUPAR,
     M          WWRK,RI,RL,X,Y,Z,IE,IB,LRL,NLRL,LRN,CMATRX,RLD,
     M          NTNPLR,NNPLR,LMAXDF,GNLR,LNOJCN,CMTRXL,RLDL,
     M          DCOSB,ISB,NPBB,BFLX,BFLXP,WETAB,VXBAR,VYBAR,VZBAR,
     M          VX,VY,VZ,DTI,
     M          VXP,VYP,VZP,TH,THP,DTH,THN,LES,SOS,SOSF,
     M          TSOSF,ISTYP,NPW,WSS,WSSF,TWSSF,IWTYP,QCB,
     M          QCBF,TQCBF,ICTYP,ISC,NPCB,QNB,QNBF,TQNBF,
     M          INTYP,ISN,NPNB,CVB,CVBF,TCVBF,IVTYP,ISV,
     M          NPVB,CDB,CDBF,TCDBF,IDTYP,NPDB,PROP,
     M          KPR,KDSK,TDTCH,
     O          C,CP,CW,CSTAR,FX,FY,FZ)
C
      CALL CLRSCR
      WRITE (*,22)
   22 FORMAT(///////////,1X,
     1 '                           LEWASTE program complete.')
C
      CLOSE (UNIT=LUINP)
      CLOSE (UNIT=LUOUT)
      CLOSE (UNIT=LUFLW)
      CLOSE (UNIT=LUSTO)
      CLOSE (UNIT=LUBAR)
      CLOSE (UNIT=LUPAR)
C
      STOP
      END
