      SUBROUTINE LOCQ8
     I                (XX,YY,ZZ,VXX,VYY,VZZ,XP,YP,ZP,VXP,VYP,VZP,
     I                 N1,N2,N3,N4,SDT,MQ,IJUDGE,KXSI,KETA,LUOUT,TIM,
     O                 XQ,YQ,ZQ,VXQ,VYQ,VZQ,XSI,ETA,SDT1,ICHG)
C
C***** 3:15 PM, 5/5/92
C
C
C----------------------------------------------------------------------C
C          PURPOSE:                                                    C
C                                                                      C
C         IT CALLS:                                                    C
C                                                                      C
C  IT IS CALLED BY:                                                    C
C                                                                      C
C----------------------------------------------------------------------C
C
      IMPLICIT REAL*8(A-H,O-Z)
C
      DIMENSION XX(8),YY(8),ZZ(8),VXX(8),VYY(8),VZZ(8),DL(8)
      DIMENSION SS(4),TT(4),UU(4),VSS(4),VTT(4),VUU(4)
C
      DATA NITER/100/, EPSX/1.0D-8/, OMEGA/1.0D0/, EPSR/1.0D-6/
C
      IF(VZP.NE.0.0)THEN
        INDEX=1
        SP=XP
        TP=YP
        UP=ZP
        VSP=VXP
        VTP=VYP
        VUP=VZP
      ELSEIF(VYP.NE.0.0)THEN
        INDEX=2
        SP=ZP
        TP=XP
        UP=YP
        VSP=VZP
        VTP=VXP
        VUP=VYP
      ELSEIF(VXP.NE.0.0)THEN
        INDEX=3
        SP=YP
        TP=ZP
        UP=XP
        VSP=VYP
        VTP=VZP
        VUP=VXP
      ELSE
        SDT1=0.0
        XQ=XP
        YQ=YP
        ZQ=ZP
        VXQ=VXP
        VYQ=VYP
        VZQ=VXP
        RETURN
      ENDIF
C
      DO I=1,4
        IF(I.EQ.1)NP=N1
        IF(I.EQ.2)NP=N2
        IF(I.EQ.3)NP=N3
        IF(I.EQ.4)NP=N4
        IF(VZP.NE.0.0)THEN
          SS(I)=XX(NP)
          TT(I)=YY(NP)
          UU(I)=ZZ(NP)
          VSS(I)=VXX(NP)
          VTT(I)=VYY(NP)
          VUU(I)=VZZ(NP)
        ELSEIF(VYP.NE.0.0)THEN
          SS(I)=ZZ(NP)
          TT(I)=XX(NP)
          UU(I)=YY(NP)
          VSS(I)=VZZ(NP)
          VTT(I)=VXX(NP)
          VUU(I)=VYY(NP)
        ELSE
          SS(I)=YY(NP)
          TT(I)=ZZ(NP)
          UU(I)=XX(NP)
          VSS(I)=VYY(NP)
          VTT(I)=VZZ(NP)
          VUU(I)=VXX(NP)
        ENDIF
      ENDDO
C
C $$$$$ DETERMINE THE LOCATION OF Q WITH DIFFERENT APPROACHES.
C
      IF(IJUDGE.EQ.2)THEN
C
C ***** Q IS DETERMINED BY CONSIDERING THE VELOCITY OF P ONLY
C
        DX=VXP*SDT
        DY=VYP*SDT
        DZ=VZP*SDT
        DIFN=SQRT(DX**2+DY**2+DZ**2)
        IF(DIFN.LE.EPSX)THEN
          SDT1=0.0
          XQ=XP
          YQ=YP
          ZQ=ZP
          VXQ=VXP
          VYQ=VYP
          VZQ=VZP
          RETURN
        ENDIF
        A=(TT(2)-TT(1))*(UU(3)-UU(1))-(TT(3)-TT(1))*(UU(2)-UU(1))
        B=(UU(2)-UU(1))*(SS(3)-SS(1))-(UU(3)-UU(1))*(SS(2)-SS(1))
        C=(SS(2)-SS(1))*(TT(3)-TT(1))-(SS(3)-SS(1))*(TT(2)-TT(1))
        D=A*SS(1)+B*TT(1)+C*UU(1)
        DT=-(D-A*SP-B*TP-C*UP)/(A*VSP+B*VTP+C*VUP)
        DIFM=DSQRT((DT*VXP)**2+(DT*VYP)**2+(DT*VZP)**2)
        IF(DIFM.LE.EPSX)THEN
          SDT1=SDT
          XQ=XP
          YQ=YP
          ZQ=ZP
          VXQ=VXP
          VYQ=VYP
          VZQ=VZP
          RETURN
        ENDIF
        XQ=XP-VXP*DT
        YQ=YP-VYP*DT
        ZQ=ZP-VZP*DT
        CALL XSI3D
     I           (LUOUT,XX,YY,ZZ,XQ,YQ,ZQ,MQ,
     O            S1S,T1T,U1U)
        IF(KXSI.EQ.1)XSI=S1S
        IF(KETA.EQ.1)ETA=S1S
        IF(KXSI.EQ.2)XSI=T1T
        IF(KETA.EQ.2)ETA=T1T
        IF(KXSI.EQ.3)XSI=U1U
        IF(KETA.EQ.3)ETA=U1U
        SM=1.0D0-S1S
        SP=1.0D0+S1S
        TM=1.0D0-T1T
        TP=1.0D0+T1T
        UM=1.0D0-U1U
        UP=1.0D0+U1U
        DL(1)=0.125D0*SM*TM*UM
        DL(2)=0.125D0*SP*TM*UM
        DL(3)=0.125D0*SP*TP*UM
        DL(4)=0.125D0*SM*TP*UM
        DL(5)=0.125D0*SM*TM*UP
        DL(6)=0.125D0*SP*TM*UP
        DL(7)=0.125D0*SP*TP*UP
        DL(8)=0.125D0*SM*TP*UP
        VXQ=0.0D0
        VYQ=0.0D0
        VZQ=0.0D0
        DO I=1,8
          VXQ=VXQ+DL(I)*VXX(I)
          VYQ=VYQ+DL(I)*VYY(I)
          VZQ=VZQ+DL(I)*VZZ(I)
        ENDDO
      ENDIF
C
      IF(IJUDGE.EQ.1)THEN
        ICHG=0
C
C ***** Q IS DETERMINED BY CONSIDERING BOTH THE VELOCITIES OF P AND Q
C
C
C ***** CALCULATE THE COEFFICIENTS OF SP-SQ
C
        A1=SS(1)+SS(2)+SS(3)+SS(4)-4.*SP
        A2=SS(2)+SS(3)-SS(1)-SS(4)
        A3=SS(3)+SS(4)-SS(1)-SS(2)
        A4=SS(1)+SS(3)-SS(2)-SS(4)
C
C ***** CALCULATE THE COEFFICIENTS OF TP-TQ
C
        B1=TT(1)+TT(2)+TT(3)+TT(4)-4.*TP
        B2=TT(2)+TT(3)-TT(1)-TT(4)
        B3=TT(3)+TT(4)-TT(1)-TT(2)
        B4=TT(1)+TT(3)-TT(2)-TT(4)
C
C ***** CALCULATE THE COEFFICIENTS OF UP-UQ
C
        C1=UU(1)+UU(2)+UU(3)+UU(4)-4.*UP
        C2=UU(2)+UU(3)-UU(1)-UU(4)
        C3=UU(3)+UU(4)-UU(1)-UU(2)
        C4=UU(1)+UU(3)-UU(2)-UU(4)
C
C ***** CALCULATE THE COEFFICIENTS OF VSP+VSQ
C
        D1=VSS(1)+VSS(2)+VSS(3)+VSS(4)+4.*VSP
        D2=VSS(2)+VSS(3)-VSS(1)-VSS(4)
        D3=VSS(3)+VSS(4)-VSS(1)-VSS(2)
        D4=VSS(1)+VSS(3)-VSS(2)-VSS(4)
C
C ***** CALCULATE THE COEFFICIENTS OF VTP+VTQ
C
        E1=VTT(1)+VTT(2)+VTT(3)+VTT(4)+4.*VTP
        E2=VTT(2)+VTT(3)-VTT(1)-VTT(4)
        E3=VTT(3)+VTT(4)-VTT(1)-VTT(2)
        E4=VTT(1)+VTT(3)-VTT(2)-VTT(4)
C
C ***** CALCULATE THE COEFFICIENTS OF VUP+VUQ
C
        F1=VUU(1)+VUU(2)+VUU(3)+VUU(4)+4.*VUP
        F2=VUU(2)+VUU(3)-VUU(1)-VUU(4)
        F3=VUU(3)+VUU(4)-VUU(1)-VUU(2)
        F4=VUU(1)+VUU(3)-VUU(2)-VUU(4)
C
C ***** CONSTRUCT FUNCTION FOF AND FUNCTION GOF FOR ITERATION
C
        IF(DABS(VSP*TIM).LE.EPSX .AND. DABS(VSS(1)*TIM).LE.EPSX .AND.
     >     DABS(VSS(2)*TIM).LE.EPSX .AND. DABS(VSS(3)*TIM).LE.EPSX .AND.
     >     DABS(VSS(4)*TIM).LE.EPSX)THEN
C
C ***** CALCULATE THE COEFFICIENTS OF EQUATION SP-SQ=0
C
          R1=A1
          R2=A2
          R3=A3
          R4=0.
          R5=A4
          R6=0.
          R7=0.
          R8=0.
          R9=0.
        ELSE
C
C ***** CALCULATE THE COEFFICIENTS OF EQUATION (SP-SQ)/(UP-UQ)=(VSP+VSQ)
C       /(VUP+VUQ)
C
          R1=A1*F1-C1*D1
          R2=A1*F2+A2*F1-C1*D2-C2*D1
          R3=A1*F3+A3*F1-C1*D3-C3*D1
          R4=A2*F2-C2*D2
          R5=A1*F4+A4*F1+A2*F3+A3*F2-C1*D4-C4*D1-C2*D3-C3*D2
          R6=A3*F3-C3*D3
          R7=A2*F4+A4*F2-C2*D4-C4*D2
          R8=A3*F4+A4*F3-C3*D4-C4*D3
          R9=A4*F4-C4*D4
        ENDIF
C
        IF(DABS(VTP*TIM).LE.EPSX .AND. DABS(VTT(1)*TIM).LE.EPSX .AND.
     >     DABS(VTT(2)*TIM).LE.EPSX .AND. DABS(VTT(3)*TIM).LE.EPSX .AND.
     >     DABS(VTT(4)*TIM).LE.EPSX)THEN
C
C ***** CALCULATE THE COEFFICIENTS OF EQUATION TP-TQ=0
C
          W1=B1
          W2=B2
          W3=B3
          W4=0.
          W5=B4
          W6=0.
          W7=0.
          W8=0.
          W9=0.
        ELSE
C
C ***** CALCULATE THE COEFFICIENTS OF EQUATION (TP-TQ)/(UP-UQ)=(VTP+VTQ)
C       /(VUP+VUQ)
C
          W1=B1*F1-C1*E1
          W2=B1*F2+B2*F1-C1*E2-C2*E1
          W3=B1*F3+B3*F1-C1*E3-C3*E1
          W4=B2*F2-C2*E2
          W5=B1*F4+B4*F1+B2*F3+B3*F2-C1*E4-C4*E1-C2*E3-C3*E2
          W6=B3*F3-C3*E3
          W7=B2*F4+B4*F2-C2*E4-C4*E2
          W8=B3*F4+B4*F3-C3*E4-C4*E3
          W9=B4*F4-C4*E4
        ENDIF
C
C ***** SOLVE THE ABOVE TWO EQUATIONS BY NEWTON-RAPHSON
C
        XSIO=0.0
        ETAO=0.0
        XSIW=XSIO
        ETAW=ETAO
        XSI=XSIO
        ETA=ETAO
C
C ***** START NEWTON-RAPHSON
C
        DO 200 ITER=1,NITER
          FOF=XSIW**2*(R9*ETAW**2+R7*ETAW+R4)+XSIW*(R8*ETAW**2+R5*ETAW
     +        +R2)+(R6*ETAW**2+R3*ETAW+R1)
          GOF=XSIW**2*(W9*ETAW**2+W7*ETAW+W4)+XSIW*(W8*ETAW**2+W5*ETAW
     +        +W2)+(W6*ETAW**2+W3*ETAW+W1)
          DFX=2.0*XSIW*(R9*ETAW**2+R7*ETAW+R4)+(R8*ETAW**2+R5*ETAW+R2)
          DFE=2.0*ETAW*(R9*XSIW**2+R8*XSIW+R6)+(R7*XSIW**2+R5*XSIW+R3)
          DGX=2.0*XSIW*(W9*ETAW**2+W7*ETAW+W4)+(W8*ETAW**2+W5*ETAW+W2)
          DGE=2.0*ETAW*(W9*XSIW**2+W8*XSIW+W6)+(W7*XSIW**2+W5*XSIW+W3)
          DETJ=DFX*DGE-DFE*DGX
C
C ***** COMPUTE FOR NEW XSI AND ETA
C
          XSI=XSIO-(DGE*FOF-DFE*GOF)/DETJ
          ETA=ETAO-(-DGX*FOF+DFX*GOF)/DETJ
C
C ***** TEST CONVERGENCE
C
          DIFMAX=0.0D0
          DIFMAX1=0.0D0
          IF(XSIW.NE.0.)THEN
            DIF=DABS((XSI-XSIW)/XSIW)
            DIFMAX=DMAX1(DIF,DIFMAX)
            DIF1=DABS(XSI-XSIW)
            DIFMAX1=DMAX1(DIF1,DIFMAX1)
          ENDIF
          IF(ETAW.NE.0.)THEN
            DIF=DABS((ETA-ETAW)/ETAW)
            DIFMAX=DMAX1(DIF,DIFMAX)
            DIF1=DABS(ETA-ETAW)
            DIFMAX1=DMAX1(DIF1,DIFMAX1)
          ENDIF
          IF(DIFMAX.LE.EPSR .AND. ITER.GT.1) GOTO 500
C
C ***** TAKE A NEW GUESS FOR XSI AND ETA
C
          IF(XSI.GT.1.0D0)XSI=1.0D0
          IF(XSI.LT.-1.0D0)XSI=-1.0D0
          IF(ETA.GT.1.0D0)ETA=1.0D0
          IF(ETA.LT.-1.0D0)ETA=-1.0D0
          XSIW=OMEGA*XSI+(1.0D0-OMEGA)*XSIO
          ETAW=OMEGA*ETA+(1.0D0-OMEGA)*ETAO
C
C ***** UPDATE XSIO,ETAO
C
          XSIO=XSI
          ETAO=ETA
  200   CONTINUE
        IF(DIFMAX1.GT.EPSR)THEN
          ICHG=1
          RETURN
        ENDIF
C
C ***** GET THE POSITION AND VELOCITY OF POINT Q
C
  500   CONTINUE
        IF(XSI.GT.1.0D0)XSI=1.0D0
        IF(XSI.LT.-1.0D0)XSI=-1.0D0
        IF(ETA.GT.1.0D0)ETA=1.0D0
        IF(ETA.LT.-1.0D0)ETA=-1.0D0
        SQ=SP+0.25*(A1+XSI*A2+ETA*A3+XSI*ETA*A4)
        TQ=TP+0.25*(B1+XSI*B2+ETA*B3+XSI*ETA*B4)
        UQ=UP+0.25*(C1+XSI*C2+ETA*C3+XSI*ETA*C4)
        VSQ=-VSP+0.25*(D1+XSI*D2+ETA*D3+XSI*ETA*D4)
        VTQ=-VTP+0.25*(E1+XSI*E2+ETA*E3+XSI*ETA*E4)
        VUQ=-VUP+0.25*(F1+XSI*F2+ETA*F3+XSI*ETA*F4)
        IF(INDEX.EQ.1)THEN
          XQ=SQ
          YQ=TQ
          ZQ=UQ
          VXQ=VSQ
          VYQ=VTQ
          VZQ=VUQ
        ELSEIF(INDEX.EQ.2)THEN
          XQ=TQ
          YQ=UQ
          ZQ=SQ
          VXQ=VTQ
          VYQ=VUQ
          VZQ=VSQ
        ELSE
          XQ=UQ
          YQ=SQ
          ZQ=TQ
          VXQ=VUQ
          VYQ=VSQ
          VZQ=VTQ
        ENDIF
C
C ***** CALCULATE DT
C
        DX=(VXP+VXQ)*SDT*0.5D0
        DY=(VYP+VYQ)*SDT*0.5D0
        DZ=(VZP+VZQ)*SDT*0.5D0
        DIFN=SQRT(DX**2+DY**2+DZ**2)
        IF(DIFN.LE.EPSX)THEN
          SDT1=0.0D0
          XQ=XP
          YQ=YP
          ZQ=ZP
          VXQ=VXP
          VYQ=VYP
          VZQ=VZP
          RETURN
        ENDIF
        DIFM=SQRT((XQ-XP)**2+(YQ-YP)**2+(ZQ-ZP)**2)
        IF(DIFM.LE.EPSX)THEN
          SDT1=SDT
          XQ=XP
          YQ=YP
          ZQ=ZP
          VXQ=VXP
          VYQ=VYP
          VZQ=VZP
          RETURN
        ENDIF
        D1=0.5D0*(VXP+VXQ)
        D2=0.5D0*(VYP+VYQ)
        D3=0.5D0*(VZP+VZQ)
        D4=SQRT(D1**2+D2**2+D3**2)
        DT=DIFM/D4
        IF(DT.LE.0)THEN
          WRITE(16,*)'ERROR OCCURRED AT LOCQ8 ----- 1'
          STOP
        ENDIF
        DT=DT
      ENDIF
C
      IF(DT.GT.0)THEN
C
        IF(DABS(DT).GE.SDT)THEN
          SSDT=SDT
          SDT1=0.0
          XQ=XP+SSDT*(XQ-XP)/DT
          YQ=YP+SSDT*(YQ-YP)/DT
          ZQ=ZP+SSDT*(ZQ-ZP)/DT
          VXQ=VXP+SSDT*(VXQ-VXP)/DT
          VYQ=VYP+SSDT*(VYQ-VYP)/DT
          VZQ=VZP+SSDT*(VZQ-VZP)/DT
C
C ***** COMPUTE THE BASE FUNCTIONS
C
C         CALL XSI3D
C    I              (LUOUT,XX,YY,ZZ,XQ,YQ,ZQ,MQ,
C    O               S1S,T1T,U1U)
C         SM=1.0D0-S1S
C         SP=1.0D0+S1S
C         TM=1.0D0-T1T
C         TP=1.0D0+T1T
C         UM=1.0D0-U1U
C         UP=1.0D0+U1U
C         DL(1)=0.125D0*SM*TM*UM
C         DL(2)=0.125D0*SP*TM*UM
C         DL(3)=0.125D0*SP*TP*UM
C         DL(4)=0.125D0*SM*TP*UM
C         DL(5)=0.125D0*SM*TM*UP
C         DL(6)=0.125D0*SP*TM*UP
C         DL(7)=0.125D0*SP*TP*UP
C         DL(8)=0.125D0*SM*TP*UP
C
C ***** COMPUTE VELOCITY AT POINT Q BY INTERPOLATION
C
C         VXQ=0.0
C         VYQ=0.0
C         VZQ=0.0
C         DO 300 I=1,8
C           VXQ=VXQ+DL(I)*VXX(I)
C           VYQ=VYQ+DL(I)*VYY(I)
C           VZQ=VZQ+DL(I)*VZZ(I)
C 300     CONTINUE
        ELSE
          SDT1=SDT-DABS(DT)
        ENDIF
      ELSE
        WRITE(LUOUT,*)'ERROR OCCURRED AT LOCQ8 ----- 2'
        STOP
      ENDIF
C
  999 FORMAT(I5,2X,6F12.6)
      RETURN
      END
