      SUBROUTINE PAGEN
     I                  (IE,NNPLR,LUOUT,
     M                   GNLR,
     O                   NLRL,LRN,LRL,LNOJCN,LMAXDF,NTNPLR)
C
C     + + + PURPOSE + + +
C     To generate pointer arrays
C
C     + + + COMMON BLOCKS + + +
      INCLUDE 'SGEOM.INC'
      INCLUDE 'CGEOM.INC'
      INCLUDE 'LGEOM.INC'
      INCLUDE 'CINTE.INC'
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER   IE(MAXEL,9),NNPLR(MXREGN),LUOUT,GNLR(LTMXNP,MXREGN),
     >          LRN(MXJBD,MAXNP),LNOJCN(MXJBD,LMXNP,MXREGN),
     >          LMAXDF(MXREGN),NTNPLR(MXREGN),LRL(MXKBD,MAXNP),
     >          NLRL(MAXNP)
C
C     + + + ARGUMENT DEFINITIONS + + +
C     IE(M,I)     - global node number of I-th node of the M-th element
C                   if I = 1 to 8, material type of the M0th element if
C                   I = 9
C     NNPLR(K)    - number of node points in the K-th subregion
C     LUOUT       -
C     GNLR(I,K)   - global node number of the I-th node in the K-th
C                   subregion
C     LRN(I,N)    - global node number of the I-th connecting node to
C                   the N-th node
C     LRL(I,N) - global element number of the I-th element connecting
C                to the N-th global node
C     NLRL(N)  - total number of elements connecting to the N-th global
C                node
C     LNOJCN((J,I,K) - local node number of the J-th compressed number
C                      connecting to the I-th local node in the K-th
C                      subregion
C     LMAXDF(K)   - maximum difference between eight nodes of any
C                   element
C     NTNPLR(K)   - total number of node points in the K-th subregion
C                   = NNPLR(K) + intra-boundary nodes
C
C     + + + LOCAL VARIABLES + + +
      INTEGER    IEM(8),NP,I,NLNOD,KOUNT,M,IQ,NI,J,NJ,KONT,JBND,
     >           LINE,K,LNNP,LTNNP,LI,LJ,NLJ,MAXDF,IDIF,LNNP1,JDO,LJDO,
     >           NOCUR,NAMX,NN
C
C     + + + INTRINSICS + + +
      INTRINSIC  MOD
C
C     + + + OUTPUT FORMATS + + +
 1100 FORMAT(1H0/5X,'*** NUMBER OF ELEMENTS CONNECTING TO NODE ',I6,
     1 ' IS',I3, ' WHICH IS GREATER THAN MXKBD =',I3,'  STOP')
 2000 FORMAT(///5X,' ***',I4,'-TH NODE HAS',I4,' NODES SURROUNDING',
     > ' IT, WHICH IS MORE THAN MXJBD - 1 =',I5,'  STOP ***')
 2010 FORMAT('1'/5X,' ** GENERATED SURROUNDING NODES OF ALL NODES *',//
     > 1X,'   NP    1    2    3    4    5    6    7    8',
     > '    9   10   11   12   13'/1X,9X,'   14   15   16   17',
     > '   18   19   20   21   22   23   24   25   26   27'/1X,
     > 14('   --')/1X,9X,14('   --')/)
 2020 FORMAT(1H ,14I5/1X,9X,14I5)
 2030 FORMAT(///5X,' WE CANNOT FIND A LOCAL NODE IN REGION',I3,
     > ' CORRESPONDING TO',I3,'-TH COMPRESSED GLOBAL NODE',I4,
     > ' CONNECTING TO GLOBAL NODE',I4,' OR CONNECTING TO THE LOCAL ',
     > ' NODE ',I3)
 2040 FORMAT('1',10X,' *** ARRAY GNLR AND LNOJCN ***'///5X,
     > ' -- SUBREGION K =',I3,' --'//1X,
     > ' LNODE GNODE  SURROUNDING AND INCLUDING LOCAL NODES'/1X,
     > ' ----- -----  -------------------------------------')
 2050 FORMAT(1H ,2I6,14I4/17X,13I4)
 2060 FORMAT(///5X,' LIST OF HALF BAND WIDTH FOR ALL SUBREGIONS'/5X,
     > (18I4))
C
C     + + + END SPECIFICATIONS + + +
C
C     ******* Generate LRN(MXJBD,MAXNP) based on IE(MAXEL,9)
C
      DO 105 NP=1,NNP
        NLRL(NP) = 0
        DO 100 J=1,MXKBD
          LRL(J,NP)=0
  100   CONTINUE
  105 CONTINUE
C
      DO 190 M=1,NEL
        DO 180 IQ=1,8
          NP=IE(M,IQ)
C
          NLRL(NP)=NLRL(NP)+1
          J=NLRL(NP)
          LRL(J,NP)=M
 180    CONTINUE
 190  CONTINUE
C
      NMAX=0
      NOCUR=0
      DO 195 NP=1,NNP
        NN=NLRL(NP)
        IF(NN.GT.NMAX) THEN
          NMAX=NN
          NOCUR=NP
        ENDIF
 195  CONTINUE
      IF(NMAX.GT.MXKBD) THEN
        WRITE(LUOUT,1100)NOCUR,NMAX,MXKBD
        STOP
      ENDIF
C
      DO 490 NP = 1,NNP
C
C ******* GENERATE LRN(MXJBD,MAXNP) BASED ON LRL(MXKBD,MAXNP)
C
C       Initiate the array LRN
        DO 205 I = 1,MXJBD
          LRN(I,NP) = 0
  205   CONTINUE
C
        NLNOD = 0
        KOUNT = 0
C
C       Loop over all elements connected to node NP to see if any of
C       these elements have a node number equal to NP
        DO 390 I = 1,NLRL(NP)
          M=LRL(I,NP)
C
C         store eight nodes of the element M in array IEM
          DO 210 IQ = 1,8
            IEM(IQ) = IE(M,IQ)
  210     CONTINUE
C
          IQ = 0
C         check if any of the eight nodes stored in IEM is
C         node NP
  215     CONTINUE
            IQ = IQ + 1
            NI = IEM(IQ)
          IF (NI .NE. NP .AND. IQ .LT. 8) THEN
            GO TO 215
          END IF
C
          IF (NI .EQ. NP .OR. IQ .LT. 8) THEN
C           one of the eight nodes of the element M is node NP
            DO 290 IQ = 1,8
              NI = IE(M,IQ)
C
C             compress the nodes to 1 to MXJBD
C
              NLNOD = NLNOD + 1
              IF (NLNOD .LE. 1) THEN
C
C               first node is encountered
                KOUNT         = KOUNT + 1
                LRN(KOUNT,NP) = NI
C
              ELSE
C
C               NLNOD is greater than 1, we have to check if NI is the
C               node already compressed? If yes, skip.  If not, increase
C               the KOUNT
                J   = 0
                JDO = 1
  240           CONTINUE
C                 loop over all nodes that are already in array LRN
C                 to see if any one of them is node NI
                  J  = J + 1
                  NJ = LRN(J,NP)
                  IF (NI .EQ. NJ) THEN
C                   node NI is the node already compressed, set JDO to 0
                    JDO = 0
                  END IF
                IF (JDO .EQ. 1 .AND. J .LT. KOUNT) THEN
                  GO TO 240
                END IF
              END IF
              IF (NLNOD .GT. 1 .AND. JDO .EQ. 1) THEN
C               the node NI has not been compressed yet.
C               Hence compress it.
                KOUNT         = KOUNT + 1
                LRN(KOUNT,NP) = NI
C
              END IF
C
  290       CONTINUE
          END IF
  390   CONTINUE
C
        IF (KOUNT .GT. MXJBD) THEN
C         Too many surrounding nodes, print error message
          KONT = KOUNT - 1
          JBND = MXJBD - 1
          WRITE(LUOUT,2000) NP,KONT,JBND
          STOP
        END IF
C
  490 CONTINUE
C
C
      IF (MOD(IGEOM,2) .NE. 0) THEN
C       print Genereated Array LRN
        LINE = 0
        DO 590 NP=1,NNP
          IF (MOD(LINE,50) .EQ. 0) THEN
C           need a new header
            WRITE(LUOUT,2010)
          END IF
          LINE = LINE + 1
          WRITE(LUOUT,2020) NP,(LRN(I,NP),I = 1,MXJBD)
  590   CONTINUE
      END IF
C
C     *** 1.  Fill-up GNLR(I,MXREGN) from I=LMXNP+1 to I=LTMXNP based on
C     ***     IE(MAXEL,8) and on GNLR(I,MXREGN) from I=1 to I=LMXNP.
C     *** 2.  Generate NTNPLR(MXREGN) also based on IE(MAXEL,8) and on
C     ***     GNLR(I,MXREGN) from I=1 to I=LMXNP
C
      DO 690 K = 1,NREGN
        LNNP  = NNPLR(K)
        LTNNP = LNNP
        DO 680 M = 1,NEL
C         loop over all elements
          IQ = 0
  630     CONTINUE
C           loop over all eitht nodes of the element M
            IQ = IQ + 1
            NI = IE(M,IQ)
            J  = 0
  620       CONTINUE
              J  = J + 1
              NJ = GNLR(J,K)
C
C             The J-th interior node of the K-th region does not coincid
C             the IQ-node of element M, go to 620 for another interior n
C             of the K-th region.
C
            IF (NI .NE. NJ .AND. J .LT. LNNP) THEN
              GO TO 620
            END IF
C
C           None of the interior nodes of the K-th region coincides with
C           the node IQ, now determine if IQ is less than 8.  If yes,
C           go to 630 for another IQ.  If no, go to 680 for another
C           element.
C
          IF (NI .NE. NJ .AND. J .GE. LNNP .AND. IQ .LT. 8) THEN
C
C           IQ is not one of the interior node of the K-th region,
C           check another IQ to see if it is one of the interior node.
C
            GO TO 630
C
C           All eight nodes of element M is not one of the interior
C           nodes of the K-th region, go to 680 for another element.
C
          ELSE IF (NI .NE. NJ .AND. J .GE. LNNP .AND. IQ .GE. 8) THEN
            GO TO 680
          END IF
C
C         one of the eight nodes of element M is one of the interior
C         nodes of the K-th region, hence each of teh eight nodes is
C         either an interior node or an intra-boundary node.
          DO 670 IQ = 1,8
            NI = IE(M,IQ)
C
C           check if NI is one of the points in GNLR(I,K) for I=1,LTNNP
            J   = 0
            JDO = 1
  660       CONTINUE
              J  = J + 1
              NJ = GNLR(J,K)
C
C             NJ .EQ. NI means NI is already one of the GNLR(I,K) points
C             hence skip and go to 670
              IF (NJ .EQ. NI) THEN
                JDO = 0
              END IF
            IF (JDO .EQ. 1 .AND. J .LT. LTNNP) THEN
              GO TO 660
            END IF
            IF(JDO .EQ. 1) THEN
C             the IQ-th node, i.e. NI, is not one of the GNLR(I,K)
C             points hence factor this node into the array GNLR(I,K) by
C             filling-up.
              LTNNP         = LTNNP + 1
              GNLR(LTNNP,K) = NI
            END IF
  670     CONTINUE
C
  680   CONTINUE
C
C       Put the total number of nodes for the K-th region into
C       the array NTNPLR(K)
        NTNPLR(K) = LTNNP
C
  690 CONTINUE
C
C     ******* Generate LNOJCN(MXJBD,LMXNP,MXREGN) based on
C     ******* GNLR(LTMXNP,MXREGN) and LNR(MXJBD,MAXNP) and produce
C     ******* LMAXDF(MXREGN) based on LNOJCN(MXJBD,LMXNP,MXREGN) for
C     ******* all subregions
C
      DO 790 K = 1,NREGN
C
        LNNP  = NNPLR(K)
        LTNNP = NTNPLR(K)
C       initiate the array LNOJCN
        DO 710 J = 1,MXJBD
          DO 715 LI = 1,LNNP
            LNOJCN(J,LI,K) = 0
  715     CONTINUE
  710   CONTINUE
C
C       generate LNOJCN(MXJBD,LMXNP,MXREGN)
        DO 770 LI = 1,LNNP
          NI = GNLR(LI,K)
C
          DO 750 J = 1,MXJBD
C           loop over all the enitre bandwidth
            NJ = LRN(J,NI)
C
            IF (NJ .EQ. 0) THEN
C             for the case NJ .EQ. 0
              LNOJCN(J,LI,K) = 0
C
            ELSE
C             for the case NJ .NE. 0
              LJ   = 0
              LJDO = 1
  720         CONTINUE
                LJ  = LJ + 1
                NLJ = GNLR(LJ,K)
                IF (NLJ .EQ. NJ) THEN
C                 a node equal to NJ has been found
                  LNOJCN(J,LI,K) = LJ
                  LJDO = 0
                END IF
              IF (LJDO .EQ. 1 .AND. LJ .LT. LTNNP) THEN
                GO TO 720
              END IF
              IF (LJDO .EQ. 1) THEN
C               non of the nodes is node NJ, error and print message
                WRITE(LUOUT,2030) K,J,NJ,NI,LI
                STOP
              END IF
C
            END IF
  750     CONTINUE
  770   CONTINUE
C
C       generate LMAXDF(MXREGN)
        MAXDF = 0
        DO 785 LI = 1,LNNP
          DO 780 J = 1,MXJBD
            LJ = LNOJCN(J,LI,K)
            IF (LJ .LE. LNNP .AND. LJ .NE. 0) THEN
C             compute the maximum difference between nodes
              IDIF = LI - LJ
              IF (IDIF .LT. 0) THEN
                IDIF = LJ - LI
              END IF
              IF (MAXDF .LT. IDIF) THEN
                MAXDF = IDIF
              END IF
            END IF
  780     CONTINUE
  785   CONTINUE
C
        LMAXDF(K) = MAXDF
C
  790 CONTINUE
C
C     ******* Print generated arrays LNOJCN(MXJBD,LMXNP,MXREGN) and
C     ******* GNLR(LTMXNP,MXREGN)
C
      IF (MOD(IGEOM,2) .NE. 0) THEN
C       print the array
        DO 890 K = 1,NREGN
          WRITE(LUOUT,2040) K
C
          LNNP  = NNPLR(K)
          LNNP1 = LNNP + 1
          LTNNP = NTNPLR(K)
C         print array GNLR, LNOJCN
          DO 820 I = 1,LNNP
            WRITE(LUOUT,2050) I,GNLR(I,K),(LNOJCN(J,I,K),J = 1,MXJBD)
  820     CONTINUE
C         print array GNLR for intra-boundary nodes
          DO 830 I = LNNP1,LTNNP
            WRITE(LUOUT,2050) I,GNLR(I,K)
  830     CONTINUE
  890   CONTINUE
      END IF
C
      WRITE(LUOUT,2060) (LMAXDF(K),K = 1,NREGN)
C
      RETURN
      END
