      SUBROUTINE PRINTT
     I                 (LUOUT,C,FX,FY,FZ,TIME,DELT,KPR,ITIM,
     O                  KOUT,KDIAG)
C
C     + + + PURPOSE + + +
C ------- TO OUTPUT MATERIAL FLOWS, CONCENTRATION, AND MATERIAL FLUXES
C ------- AS SPECIFIED BY THE PARAMETER KPR.
C
C     + + + COMMON BLOCKS + + +
      INCLUDE 'SGEOM.INC'
      INCLUDE 'CGEOM.INC'
      INCLUDE 'CFLOW.INC'
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER            LUOUT,KPR,ITIM,KOUT,KDIAG
      DOUBLE PRECISION   C(MAXNP),FX(MAXNP),FY(MAXNP),FZ(MAXNP),
     >                   TIME,DELT
C
C     + + + ARGUMENT DEFINITIONS + + +
C     LUOUT    - logical unit for output data
C     C(N)     - Concentration of the N-th node at the present time
C     FX(N)    - x-direction material flux at the N-th node
C     FY(N)    - y-direction material flux at the N-th node
C     FZ(N)    - z-direction material flux at the N-th node
C     TIME     - time
C     DELT     - time-step size
C     KPR      - line printer control
C     ITIM     - time-step index
C     KOUT     - output-table number index
C     KDIAG    - diagonistic output table index
C
C     + + + LOCAL VARIABLES + + +
      INTEGER            I,LINE,NI,NJMN,NJMX,NJ
C
C     + + + INTRINSICS + + +
      INTRINSIC    MIN0,MOD
C
C     + + + OUTPUT FORMATS + + +
 2000 FORMAT('1','****************************************************',
     2 '*****'///' SYSTEM-FLOW TABLE',I4,'.. AT TIME =',1PD10.3,
     3 ' ,(DELT =',1PD10.3,')',' ITIM=',I5)
 2010 FORMAT(//11X,'TYPE OF FLOW',25X,'RATE',4X,'INC. FLOW',2X,
     > 'TOTAL FLOW'/1X,
     > ' 1. THROUGH DIRICHLET BOUNDARY NODES . . . ',3(1PD11.3)/1X,
     > ' 2. THROUGH CAUCHY BOUNDARY NODES . .  . . ',3(1PD11.3)/1X,
     > ' 3. THROUGH NEUMANN BOUNDARY NODES . . . . ',3(1PD11.3)/1X,
     > ' 4. THROUGH SEEPAGE NODES . . . . . .  . . ',3(1PD11.3)/1X,
     > ' 5. THROUGH INFILTRATION NODES .. . .  . . ',3(1PD11.3)/1X,
     > ' 6. THROUGH UNSPECIFIED NODES(NUMERICAL) . ',3(1PD11.3)/1X,
     > ' 7. NET FLOW THROUGH ENTIRE BOUNDARY NODES ',3(1PD11.3)/1X,
     > ' 8. INCREASE IN MATERIAL CONTENT (LIQUID) .',3(1PD11.3)/1X,
     > ' 9. INCREASE IN MATERIAL CONTENT (SOLID) . ',3(1PD11.3)/1X,
     > '10. RADIOACTIVE LOSSES (LIQUID AND SOLID) .',3(1PD11.3)/1X,
     > '11. LOSS TO COMP. OF SKELTON . . . . . . ..',3(1PD11.3)/1X,
     > '12. LOSS THROUGH DISSOLVED PHASE . . . . ..',3(1PD11.3)/1X,
     > '13. LOSS THROUGH ADSORBED PHASE . . . . . .',3(1PD11.3)/1X,
     > '14. ARTIFICIAL SOURCES/SINKS . . . . . . ..',3(1PD11.3)/1X,
     > ' *** NOTE: (+) = OUT FROM, (-) = INTO THE REGION. '/1X,
     > ' *** RATE (M/T/L), INC. FLOW (M/L), TOTAL FLOW (M/L)'/)
 2020 FORMAT('1OUTPUT TABLE',I4,'.. CONCENTRATIONS(M/L**3) AT TIME =',
     > 1PD12.4   /5X,' (DELT =',1PD12.4,')'    ,' *** ITIME =',I6/1X,
     > 4(' NODE   C(M/L**3)  ')/1X,4(' ---- ------------ ')/)
 2030 FORMAT(' ',4(I5,1PD13.4,1X))
 2040 FORMAT('1OUTPUT TABLE',I4,'.. MATERIAL FLUX (M/L**2/T) AT TIME =',
     > 1PD12.4/5X,' (DELT =',1PD12.4,')'    ,' *** ITIME =',I6//1X,
     > 2(' NODE     FX         FY         FZ     ')/1X,
     > 2(' ------------------------------------- ')/)
 2050 FORMAT(' ',2(I5,1PD11.3,1PD11.3,1PD11.3,1X))
C
C     + + + END SPECIFICATIONS + + +
C
      IF (KPR .GT. 0) THEN
C
C ****  Print flow through all types of boundaries
C
        KDIAG = KDIAG + 1
        WRITE(LUOUT,2000) KDIAG,TIME,DELT,ITIM
        WRITE(LUOUT,2010) (FRATE(I),FLOW(I),TFLOW(I),I = 1,14)
      END IF
C
      IF (KPR .GE. 2) THEN
C
C ****  Print concentratins
C
        KOUT = KOUT + 1
        LINE = 0
        DO 200 NI = 1,NNP,4
          NJMN = NI
          NJMX = MIN0(NI + 3,NNP)
          LINE = LINE + 1
          IF (MOD(LINE - 1,50) .EQ. 0) THEN
            WRITE(LUOUT,2020) KOUT,TIME,DELT,ITIM
          END IF
          WRITE(LUOUT,2030) (NJ,C(NJ),NJ = NJMN,NJMX)
  200   CONTINUE
      END IF
C
      IF (KPR .GE. 3) THEN
C
C ****  Pint material fluxes
C
        KOUT = KOUT + 1
        LINE = 0
        DO 300 NI = 1,NNP,2
          NJMN = NI
          NJMX = MIN0(NI + 1,NNP)
          LINE = LINE + 1
          IF (MOD(LINE - 1,50) .EQ. 0) THEN
            WRITE(LUOUT,2040) KOUT,TIME,DELT,ITIM
          END IF
          WRITE(LUOUT,2050) (NJ,FX(NJ),FY(NJ),FZ(NJ),NJ = NJMN,NJMX)
  300 CONTINUE
      END IF
C
      RETURN
      END
