      SUBROUTINE Q4ADB
     I                (XQ,YQ,ZQ,VXQ,VYQ,VZQ,DCOSB,QBMP,IBC,
     O                 RQL,RQI)
C
C     + + + PURPOSE + + +
C     To compute boundary-surface flow-fluxes and material-fluxes
C       over a boundary surface in Lagrangian step.
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER            IBC
      DOUBLE PRECISION   XQ(4),YQ(4),ZQ(4),VXQ(4),VYQ(4),VZQ(4),
     >                   DCOSB(3),QBMP,RQL(4),RQI(4)
C
C     + + + ARGUMENT DEFINITIONS + + +
C     XQ    - x-coordinate at four nodes of the surface
C     YQ    - y-coordinate at four nodes of the surface
C     ZQ    - z-coordinate at four nodes of the surface
C     VXQ   - x-velocity component at four nodes of the surface
C     VYQ   - y-velocity component at four nodes of the surface
C     VZQ   - z-velocity component at four nodes of the surface
C     DCOSB - directional cosine of the surface
C     QBMP  - flux or concentration through the surface
C     IBC   - index of boundary condition type
C     RQL   - flow-flux at four nodes of the surface
C     RQI   - material-flux at four nodes of the surface
C
C     + + + LOCAL VARIABLES + + +
      INTEGER            IQ,KG
      DOUBLE PRECISION   P,SS,TT,SM,SP,TM,TP,DXDSS,DYDSS,DZDSS,
     >                   DXDTT,DYDTT,DZDTT,DETZ,DETY,DETX,DET,
     >                   VXK,VYK,VZK,VNK,S(4),T(4),DNSS(4),DNTT(4),
     >                   N(4)
C
C     + + + INTRINSICS + + +
      INTRINSIC     DSQRT
C
C     + + + DATA INITIALIZATIONS + + +
      DATA P/ 1.0D0/              , S/-1.0D+00, 1.0D+00, 1.0D+00,
     > -1.0D+00/, T/-1.0D+00,-1.0D+00, 1.0D+00, 1.0D+00/
C
C     + + + END SPECIFICATIONS + + +
C
C     initiate vector RQL(IQ) and RQI(IQ)
C
      DO 100 IQ = 1,4
        RQL(IQ) = 0.0
        RQI(IQ) = 0.0
  100 CONTINUE
C
C *** Perform integration with Gaussian quadrature
C
      DO 690 KG = 1,4
C
C       determine local coordinate of the Gaussian point KG
        SS = P*S(KG)
        TT = P*T(KG)
C
C       compute some grouped variables
        SM = 1.0D0 - SS
        SP = 1.0D0 + SS
        TM = 1.0D0 - TT
        TP = 1.0D0 + TT
C
C       compute base functions at four nodes of the surface
        N(1) = 0.25D0*SM*TM
        N(2) = 0.25D0*SP*TM
        N(3) = 0.25D0*SP*TP
        N(4) = 0.25D0*SM*TP
C
C       compute partial derivatives of base functions with respect to
C       local coordiante xsi
        DNSS(1) = -0.25D0*TM
        DNSS(2) =  0.25D0*TM
        DNSS(3) =  0.25D0*TP
        DNSS(4) = -0.25D0*TP
C
C       compute partial derivatives of base functions with respect to
C       local coordiante eta
        DNTT(1) = -0.25D0*SM
        DNTT(2) = -0.25D0*SP
        DNTT(3) =  0.25D0*SP
        DNTT(4) =  0.25D0*SM
C
C       initiate six entries of
C       (partial r/partial xsi) X (partial r/partial eta)
        DXDSS = 0.0D0
        DYDSS = 0.0D0
        DZDSS = 0.0D0
        DXDTT = 0.0D0
        DYDTT = 0.0D0
        DZDTT = 0.0D0
C
C       compute six entries of
C       (partial r/partial xsi) X (partial r/partial eta)
        DO 290 IQ = 1,4
          DXDSS = DXDSS + XQ(IQ)*DNSS(IQ)
          DYDSS = DYDSS + YQ(IQ)*DNSS(IQ)
          DZDSS = DZDSS + ZQ(IQ)*DNSS(IQ)
          DXDTT = DXDTT + XQ(IQ)*DNTT(IQ)
          DYDTT = DYDTT + YQ(IQ)*DNTT(IQ)
          DZDTT = DZDTT + ZQ(IQ)*DNTT(IQ)
  290   CONTINUE
C
C       compute Jx*Jx, Jy*Jy, and Jz*Jz, and the Square Root of
C       Jx*Jx + Jy*Jy + Jz*Jz,
        DETZ =  DXDSS*DYDTT - DYDSS*DXDTT
        DETY = -DXDSS*DZDTT + DZDSS*DXDTT
        DETX =  DYDSS*DZDTT - DZDSS*DYDTT
        DET  =  DSQRT(DETX*DETX + DETY*DETY + DETZ*DETZ)
C
C       Accumulate the sum to RQL and RQI
C
        IF (IBC .EQ. 1) THEN
C         Cauchy condition
          VXK = 0.0
          VYK = 0.0
          VZK = 0.0
          DO 320 IQ = 1,4
            VXK = VXK + VXQ(IQ)*N(IQ)
            VYK = VYK + VYQ(IQ)*N(IQ)
            VZK = VZK + VZQ(IQ)*N(IQ)
  320     CONTINUE
          VNK = VXK*DCOSB(1) + VYK*DCOSB(2) + VZK*DCOSB(3)
          DO 390 IQ = 1,4
            RQI(IQ) = RQI(IQ) + N(IQ)*QBMP*DET
            RQL(IQ) = RQL(IQ) + N(IQ)*VNK*DET
  390     CONTINUE
C
C
        ELSE IF (IBC .EQ. 3) THEN
C         variable boundary condition
          VXK = 0.0
          VYK = 0.0
          VZK = 0.0
          DO 520 IQ = 1,4
            VXK = VXK + VXQ(IQ)*N(IQ)
            VYK = VYK + VYQ(IQ)*N(IQ)
            VZK = VZK + VZQ(IQ)*N(IQ)
  520     CONTINUE
          VNK = VXK*DCOSB(1) + VYK*DCOSB(2) + VZK*DCOSB(3)
          IF (VNK .LT. 0.0) THEN
            DO 590 IQ = 1,4
              RQI(IQ) = RQI(IQ) + N(IQ)*VNK*QBMP*DET
              RQL(IQ) = RQL(IQ) + N(IQ)*VNK*DET
  590       CONTINUE
          END IF
        END IF
  690 CONTINUE
C
      RETURN
      END
