      SUBROUTINE Q4BB
     I               (FQ,XQ,YQ,ZQ,
     O                RQ)
C
C     + + + PURPOSE + + +
C     To compute the normal flow rates by integrating the normal fluxes
C     over a boundary surface.
C
C     + + + DUMMY ARGUMENTS + + +
      DOUBLE PRECISION   FQ(4),XQ(4),YQ(4),ZQ(4),RQ(4)
C
C     + + + ARGUMENT DEFINITIONS + + +
C     FQ - normal flux at four points of the element surface
C     XQ - x-coordinate at four points of the element surface
C     YQ - y-coordinate at four points of the element surface
C     ZQ - z-coordinate at four points of the element surface
C     RQ - integrated flux at four nodes of the element surface
C
C     + + + LOCAL VARIABLES + + +
      INTEGER            IQ,KG
      DOUBLE PRECISION   N(4),P,SS,TT,SM,SP,TM,TP,DXDSS,DYDSS,
     >                   DZDSS,DXDTT,DYDTT,DZDTT,DETX,DETY,DETZ,
     >                   DET,FK,S(4),T(4),DNSS(4),DNTT(4)
C
C     + + + INTRINSICS + + +
      INTRINSIC     DSQRT
C
C     + + + DATA INITIALIZATIONS + + +
      DATA P/1.0D0/
      DATA S/-1.0D+00, 1.0D+00, 1.0D+00, -1.0D+00/
      DATA T/-1.0D+00, -1.0D+00, 1.0D+00, 1.0D+00/
C
C     + + + END SPECIFICATIONS + + +
C
C     Initiate matrices RQ(IQ)
      DO 100 IQ = 1,4
        RQ(IQ) = 0.0
  100 CONTINUE
C
C *** Perform integration with Gaussian quadrature.
C
      DO 490 KG = 1,4
C
C       determine local coordinate of the Gaussian point KG
        SS      = P*S(KG)
        TT      = P*T(KG)
C
C       compute some grouped variables
        SM      = 1.0D0 - SS
        SP      = 1.0D0 + SS
        TM      = 1.0D0 - TT
        TP      = 1.0D0 + TT
C
C       compute base functions at the Gaussian point KG
        N(1)    = 0.25D0*SM*TM
        N(2)    = 0.25D0*SP*TM
        N(3)    = 0.25D0*SP*TP
        N(4)    = 0.25D0*SM*TP
C
C       compute the derivative of base functions with respect to xsi
        DNSS(1) = -0.25D0*TM
        DNSS(2) = 0.25D0*TM
        DNSS(3) = 0.25D0*TP
        DNSS(4) = -0.25D0*TP
C
C       compute the derivative of base functions with respect to eta
        DNTT(1) = -0.25D0*SM
        DNTT(2) = -0.25D0*SP
        DNTT(3) =  0.25D0*SP
        DNTT(4) = 0.25D0*SM
C
C       initiate the six entries of
C        (partial r / partial xsi) X (partial r / partial eta)
        DXDSS   = 0.0D0
        DYDSS   = 0.0D0
        DZDSS   = 0.0D0
        DXDTT   = 0.0D0
        DYDTT   = 0.0D0
        DZDTT   = 0.0D0
C
C       compute the six entries of
C        (partial r / partial xsi) X (partial r / partial eta)
        DO 290 IQ = 1,4
          DXDSS = DXDSS + XQ(IQ)*DNSS(IQ)
          DYDSS = DYDSS + YQ(IQ)*DNSS(IQ)
          DZDSS = DZDSS + ZQ(IQ)*DNSS(IQ)
          DXDTT = DXDTT + XQ(IQ)*DNTT(IQ)
          DYDTT = DYDTT + YQ(IQ)*DNTT(IQ)
          DZDTT = DZDTT + ZQ(IQ)*DNTT(IQ)
  290   CONTINUE
C
C       compute Jx*Jx, Jy*Jy, Jz*Jz, and Square Root of
C        (Jx*Jx + Jy*Jy + Jz*Jz)
        DETZ = DXDSS*DYDTT - DYDSS*DXDTT
        DETY = -DXDSS*DZDTT + DZDSS*DXDTT
        DETX = DYDSS*DZDTT - DZDSS*DYDTT
        DET  = DSQRT(DETX*DETX + DETY*DETY + DETZ*DETZ)
C
C       evaluate the normal flux at the Gaussian point KG
        FK = 0.0D0
        DO 350 IQ = 1,4
          FK = FK + FQ(IQ)*N(IQ)
  350   CONTINUE
C
C       sum the contribution to surface flux due to the Gaussian point
C       KG
        DO 390 IQ = 1,4
          RQ(IQ) = RQ(IQ) + N(IQ)*FK*DET
  390   CONTINUE
  490 CONTINUE
C
      RETURN
      END
