      SUBROUTINE Q4CNVB
     I                 (XQ,YQ,ZQ,VXQ,VYQ,VZQ,DCOSB,QBMP,IBC,
     O                  BQ,RQ)
C
C     + + + PURPOSE + + +
C     To compute boundary-surface matrix and load vector over a boundary
C        surface.
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER            IBC
      DOUBLE PRECISION   XQ(4),YQ(4),ZQ(4),VXQ(4),VYQ(4),VZQ(4),
     >                   DCOSB(3),QBMP,BQ(4,4),RQ(4)
C
C     + + + ARGUMENT DEFINITIONS + + +
C     XQ    - x-coordinate at four points of the boundary side
C     YQ    - y-coordinate at four points of the boundary side
C     ZQ    - z-coordinate at four points of the boundary side
C     VXQ   - x-component of the velocity at four points of the side
C     VYQ   - y-component of the velocity at four points of the side
C     VZQ   - z-component of the velocity at four points of the side
C     DCOSB - directional cosine of the boundary side
C     QBMP  - flux or concentration of the boundary side
C     IBC   - index of boundary condition;
C             1=Cauchy, 2=Neumann, 3=variable
C     BQ    - the 2 by 2 boundary surface matrix
C     RQ    - the boundary surface load vector
C
C     + + + LOCAL VARIABLES + + +
      INTEGER            IQ,JQ,KG
      DOUBLE PRECISION   P,SS,TT,SM,SP,TM,TP,DXDSS,DYDSS,DZDSS,DXDTT,
     >                   DYDTT,DZDTT,DETZ,DETY,DETX,DET,VXK,VYK,VZK,
     >                   VNK,S(4),T(4),DNSS(4),DNTT(4),N(4)
C
C     + + + INTRINSICS + + +
      INTRINSIC    DSQRT
C
C     + + + DATA INITIALIZATIONS + + +
      DATA P/1.0D0/
      DATA S/-1.0D+00, 1.0D+00, 1.0D+00, -1.0D+00/
      DATA T/-1.0D+00, -1.0D+00, 1.0D+00, 1.0D+00/
C
C     + + + END SPECIFICATIONS + + +
C
C     Initiate matrices and flux vectors
      DO 200 IQ = 1,4
        RQ(IQ)=0.0
        DO 100 JQ = 1,4
          BQ(IQ,JQ) = 0.0
  100   CONTINUE
  200 CONTINUE
C
C *** Perform Surface Integration with Gaussian Quadrature.
C
      DO 690 KG = 1,4
C
C       determine local coordinate of the Gaussian point KG
        SS = P*S(KG)
        TT = P*T(KG)
C
C       compute some grouped variables
        SM = 1.0D0 - SS
        SP = 1.0D0 + SS
        TM = 1.0D0 - TT
        TP = 1.0D0 + TT
C
C       compute base functions
        N(1) = 0.25D0*SM*TM
        N(2) = 0.25D0*SP*TM
        N(3) = 0.25D0*SP*TP
        N(4) = 0.25D0*SM*TP
C
C       compute partial derivatives of base functions with respect to
C       local coordinate xi
        DNSS(1) = -0.25D0*TM
        DNSS(2) = 0.25D0*TM
        DNSS(3) = 0.25D0*TP
        DNSS(4) = -0.25D0*TP
C
C       compute partial derivatives of base functions with respect to
C       local coordinate xi
        DNTT(1) = -0.25D0*SM
        DNTT(2) = -0.25D0*SP
        DNTT(3) = 0.25D0*SP
        DNTT(4) = 0.25D0*SM
C
C       initiate four entries of the Jacobian matrix
        DXDSS = 0.0D0
        DYDSS = 0.0D0
        DZDSS = 0.0D0
        DXDTT = 0.0D0
        DYDTT = 0.0D0
        DZDTT = 0.0D0
C
C       compute four entries of the Jacobian matrix
        DO 290 IQ = 1,4
          DXDSS = DXDSS + XQ(IQ)*DNSS(IQ)
          DYDSS = DYDSS + YQ(IQ)*DNSS(IQ)
          DZDSS = DZDSS + ZQ(IQ)*DNSS(IQ)
          DXDTT = DXDTT + XQ(IQ)*DNTT(IQ)
          DYDTT = DYDTT + YQ(IQ)*DNTT(IQ)
          DZDTT = DZDTT + ZQ(IQ)*DNTT(IQ)
  290   CONTINUE
C
C       compute the determinant of the Jacobian matrix
        DETZ =  DXDSS*DYDTT - DYDSS*DXDTT
        DETY = -DXDSS*DZDTT + DZDSS*DXDTT
        DETX =  DYDSS*DZDTT - DZDSS*DYDTT
        DET  =  DSQRT(DETX*DETX + DETY*DETY + DETZ*DETZ)
C
C
        IF (IBC .EQ. 1) THEN
C         for the case of Cauchy boundary condition
          VXK = 0.0
          VYK = 0.0
          VZK = 0.0
          DO 320 IQ = 1,4
            VXK = VXK + VXQ(IQ)*N(IQ)
            VYK = VYK + VYQ(IQ)*N(IQ)
            VZK = VZK + VZQ(IQ)*N(IQ)
  320     CONTINUE
          VNK = VXK*DCOSB(1) + VYK*DCOSB(2) + VZK*DCOSB(3)
          DO 390 IQ = 1,4
            RQ(IQ) = RQ(IQ) - N(IQ)*QBMP*DET
            DO 350 JQ = 1,4
              BQ(IQ,JQ) = BQ(IQ,JQ) - N(IQ)*VNK*N(JQ)*DET
  350       CONTINUE
  390     CONTINUE
C
        ELSE IF (IBC .EQ. 2) THEN
C         for the case of Neumann boundary condition
          DO 490 IQ = 1,4
            RQ(IQ) = RQ(IQ) - N(IQ)*QBMP*DET
  490     CONTINUE
C
        ELSE
C         for the case of variable boundary conditions
          VXK = 0.0
          VYK = 0.0
          VZK = 0.0
          DO 520 IQ = 1,4
            VXK = VXK + VXQ(IQ)*N(IQ)
            VYK = VYK + VYQ(IQ)*N(IQ)
            VZK = VZK + VZQ(IQ)*N(IQ)
  520     CONTINUE
          VNK = VXK*DCOSB(1) + VYK*DCOSB(2) + VZK*DCOSB(3)
          IF (VNK .LT. 0.0) THEN
            DO 590 IQ = 1,4
              RQ(IQ) = RQ(IQ) - N(IQ)*VNK*QBMP*DET
              DO 550 JQ = 1,4
                BQ(IQ,JQ) = BQ(IQ,JQ) - N(IQ)*VNK*N(JQ)*DET
  550         CONTINUE
  590       CONTINUE
          END IF
        END IF
  690 CONTINUE
C
      RETURN
      END
