      SUBROUTINE Q8
     I             (VXQ,VYQ,VZQ,THG,DTHG,RHOB,AL,AT,LAMBDA,
     I              AM,TAU,SOSQ,SOSC,DSDCQ,SWQ,CWQ,
     O              QA,QAA,QB,QC,QV,QR,XQ,YQ,ZQ)
C
C     + + + PURPOSE + + +
C     To compute element matrices and element load vector given by
C        QA(IQ,JQ) = integration of N(I)*TH*N(NJ)
C        QAA(IQ,JQ) = integration of N(I)*RHOB*dS/dC*N(J)
C        QB(IQ,JQ) = integration of Grad(N(I)).TH*D.Grad(N(J))
C        QC(IQ,JQ) = integration of N(I)*[LAMADA*(TH+RHOB*dS/dC)+Q]*N(J)
C        QV(IQ,JQ) = integration of W(I).V.Grad(N(J))
C        QR(IQ) = integration of N(IQ)*[Q*CIN+LAMADA*RHOB*(S-dS/dC*C)]
C
C     + + + COMMON BLOCKS + + +
      INCLUDE 'OPTN.INC'
C
C     + + + DUMMY ARGUMENTS + + +
      DOUBLE PRECISION   VXQ(8),VYQ(8),VZQ(8),THG(8),DTHG(8),
     >                   RHOB,AL,AT,LAMBDA,AM,TAU,SOSQ,SOSC,
     >                   DSDCQ(8),SWQ(8),CWQ(8),QA(8,8),
     >                   QAA(8,8),QB(8,8),QC(8,8),QV(8,8),QR(8),
     >                   XQ(8),YQ(8),ZQ(8)
C
C     + + + ARGUMENT DEFINITIONS + + +
C     VXQ    - x-velocity of eight nodes of the element
C     VYQ    - y-velocity of eight nodes of the elmeent
C     VZQ    - z-velocity of eight nodes of the element
C     THG    - moisture content at eight Gaussian points of the element
C     DTHG   - dTH/dt at eight Gaussian points of the element
C     RHOB   - bulk density of the material in element
C     AL     - logitudinal dispersivity
C     AT     - lateral dispersivity
C     LAMBDA - decay constant
C     AM     - molecular diffusion coefficient
C     TAU    - tortuosity
C     SOSQ   - source flow rate
C     SOSC   - source concentration
C     DSDCQ  - the derivative of adsorbed concentration with respect to
C              dissolved concentration at eight points of the element
C     SWQ    - iterate of the adsorbed concentration at eight
C              Gaussian points of the element
C     CWQ    - iterate of the dissolved concentration at eight
C              Gaussian points of the element
C     QA     - an element matrix
C     QAA    - an element matrix
C     QB     - an element matrix
C     QC     - an element matrix
C     QV     - an element matrix
C     QR     - an element load vector
C     XQ     - x-coordinate of eight points of the element
C     YQ     - y-coordinate of eight points of the element
C     ZQ     - z-coordinate of eight points of the element
C
C     + + + LOCAL VARIABLES + + +
      INTEGER            IQ,JQ,KG,I,J
      DOUBLE PRECISION   N(8),P,DD,SS,TT,UU,DJAC,VXK,VYK,VZK,DSDCK,
     >                   SORPSK,THK,DTHK,VK,VKI,DXX,DYY,DZZ,DXY,DXZ,
     >                   DYZ,SOSK,GAMAS,A,AA,B,C,WN,DWXDNX,DWXDNY,
     >                   DWXDNZ,DWYDNX,DWYDNY,DWYDNZ,DWZDNX,DWZDNY,
     >                   DWZDNZ,WDNX,WDNY,WDNZ,SUM,SUMAA,SUMC,
     >                   DNX(8),DNY(8),DNZ(8),W(8),S(8),T(8),U(8)
C
C     + + + INTRINSICS + + +
      INTRINSIC     DSQRT
C
C     + + + EXTERNALS + + +
      EXTERNAL    SHAPE
C
C     + + + DATA INITIALIZATIONS + + +
      DATA P/1.0D0/
      DATA S/-1.0D0,1.0D0,1.0D0,-1.0D0, -1.0D0,1.0D0,1.0D0,-1.0D0/
      DATA T/-1.0D0,-1.0D0,1.0D0,1.0D0, -1.0D0,-1.0D0,1.0D0,1.0D0/
      DATA U/-1.0D0,-1.0D0,-1.0D0,-1.0D0, 1.0D0,1.0D0,1.0D0,1.0D0/
C
C     + + + END SPECIFICATIONS + + +
C
C     effective diffusion coefficient
      DD = AM*TAU
C
C *** Initiate element matrices and load vector
C
      DO 120 IQ = 1,8
        QR(IQ) = 0.0
        DO 110 JQ = 1,8
          QA(IQ,JQ)  = 0.0
          QAA(IQ,JQ) = 0.0
          QB(IQ,JQ)  = 0.0
          QC(IQ,JQ)  = 0.0
          QV(IQ,JQ)  = 0.0
  110   CONTINUE
  120 CONTINUE
C
C *** Perform integration by Gaussian quadrature
C
      DO 490 KG = 1,8
C
C       Determine local coordinate of the Gaussian point KG
        SS = P*S(KG)
        TT = P*T(KG)
        UU = P*U(KG)
C
C       compute base and weighting functions and their derivatives with
C       respect to x, y, and z, and determinant of the Jacobian.
        CALL SHAPE
     I            (XQ,YQ,ZQ,SS,TT,UU,
     O             N,DNX,DNY,DNZ,W,DJAC)
C
C       compute velocity, dS/dC, and (S - dS/dC*C) at the Gaussian point
        VXK    = 0.0
        VYK    = 0.0
        VZK    = 0.0
        DSDCK  = 0.0
        SORPSK = 0.0
        DO 210 IQ = 1,8
          VXK    = VXK + VXQ(IQ)*N(IQ)
          VYK    = VYK + VYQ(IQ)*N(IQ)
          VZK    = VZK + VZQ(IQ)*N(IQ)
          DSDCK  = DSDCK + DSDCQ(IQ)*N(IQ)
          SORPSK = SORPSK + (SWQ(IQ) - DSDCQ(IQ)*CWQ(IQ))*N(IQ)
  210   CONTINUE
C
        THK = THG(KG)
        DTHK = DTHG(KG)
C
        VK = DSQRT(VXK*VXK + VYK*VYK + VZK*VZK)
        IF (VK .EQ. 0.0) THEN
          VKI = 0.0
        ELSE
          VKI = 1.0D0/VK
        END IF
C
        DXX   = DJAC*((AL*VXK*VXK + AT*(VYK*VYK +
     >          VZK*VZK))*VKI + DD*THK)
        DYY   = DJAC*((AL*VYK*VYK + AT*(VZK*VZK +
     >          VXK*VXK))*VKI + DD*THK)
        DZZ   = DJAC*((AL*VZK*VZK + AT*(VXK*VXK +
     >          VYK*VYK))*VKI + DD*THK)
        DXY   = DJAC*(AL - AT)*VXK*VYK*VKI
        DXZ   = DJAC*(AL - AT)*VXK*VZK*VKI
        DYZ   = DJAC*(AL - AT)*VYK*VZK*VKI
C
        VXK   = VXK*DJAC
        VYK   = VYK*DJAC
        VZK   = VZK*DJAC
C
        SOSK  = SOSQ*DJAC
        GAMAS = 1.0D0
        IF (SOSK .LT. 0.0) THEN
          GAMAS=-1.0D0
        END IF
        SORPSK = SORPSK*DJAC
C
        A  = DJAC*THK
        AA = DJAC*RHOB*DSDCK
        B  = 0.5D0*(1.0D0 + GAMAS)*SOSK*SOSC - RHOB*LAMBDA*SORPSK
        C  = DJAC*(LAMBDA*(THK + RHOB*DSDCK)) + 0.5D0*
     >       (1.0D0 + GAMAS)*SOSK
C
C       sum the contribution from the Gaussian point KG to element
C       matrices and load vector.
        DO 390 IQ = 1,8
          QR(IQ) = QR(IQ) + B*N(IQ)
          DO 350 JQ = 1,8
            WN         = N(IQ)*N(JQ)
            DWXDNX     = DNX(IQ)*DNX(JQ)
            DWXDNY     = DNX(IQ)*DNY(JQ)
            DWXDNZ     = DNX(IQ)*DNZ(JQ)
            DWYDNX     = DNY(IQ)*DNX(JQ)
            DWYDNY     = DNY(IQ)*DNY(JQ)
            DWYDNZ     = DNY(IQ)*DNZ(JQ)
            DWZDNX     = DNZ(IQ)*DNX(JQ)
            DWZDNY     = DNZ(IQ)*DNY(JQ)
            DWZDNZ     = DNZ(IQ)*DNZ(JQ)
            WDNX       = W(IQ)*DNX(JQ)
            WDNY       = W(IQ)*DNY(JQ)
            WDNZ       = W(IQ)*DNZ(JQ)
C
            QA(IQ,JQ)  = QA(IQ,JQ) + A*WN
            QAA(IQ,JQ) = QAA(IQ,JQ) + AA*WN
            QB(IQ,JQ)  = QB(IQ,JQ) + DWXDNX*DXX + (DWXDNY + DWYDNX)*
     >                   DXY + DWYDNY*DYY + (DWYDNZ + DWZDNY)*DYZ +
     >                   DWZDNZ*DZZ + (DWXDNZ + DWZDNX)*DXZ
            QC(IQ,JQ)  = QC(IQ,JQ) + C*WN
            QV(IQ,JQ)  = QV(IQ,JQ) + (VXK*WDNX + VYK*WDNY + VZK*WDNZ)
  350     CONTINUE
  390   CONTINUE
  490 CONTINUE
C
C *** Perform element matrix lumping if desired
C
      IF (ILUMP .NE. 0) THEN
        DO 940 I = 1,8
          SUM   = 0.0
          SUMAA = 0.0
          SUMC  = 0.0
          DO 920 J = 1,8
            SUM      = SUM + QA(I,J)
            SUMAA    = SUMAA + QAA(I,J)
            SUMC     = SUMC + QC(I,J)
            QA(I,J)  = 0.0
            QAA(I,J) = 0.0
            QC(I,J)  = 0.0
  920     CONTINUE
          QA(I,I)  = SUM
          QAA(I,I) = SUMAA
          QC(I,I)  = SUMC
  940   CONTINUE
      END IF
C
      RETURN
      END
