      SUBROUTINE Q8DV
     I               (CQ,XQ,YQ,ZQ,VXQ,VYQ,VZQ,THQ,DD,AL,AT,
     O                QB,QRX,QRY,QRZ)
C
C     + + + PURPOSE + + +
C     To compute the integration of N(I)*N(J) AND -N(I)*n.D.GRAD(C)
C       over an element.
C
C     + + + DUMMY ARGUMENTS + + +
      DOUBLE PRECISION   CQ(8),XQ(8),YQ(8),ZQ(8),VXQ(8),VYQ(8),
     >                   VZQ(8),THQ(8),DD,AL,AT,QB(8,8),QRX(8),
     >                   QRY(8),QRZ(8)
C
C     + + + ARGUMENT DEFINITIONS + + +
C     CQ  - concentration at eight points of the element
C     XQ  - x-coordinate at eight points of the element
C     YQ  - y-coordinate at eight points of the element
C     ZQ  - z-coordinate at eight points of the element
C     VXQ - x-component of the velocity at eight points of the element
C     VYQ - y-component of the velocity at eight points of the element
C     VZQ - z-component of the velocity at eight points of the element
C     THQ - moisture content at eight points of the element
C     DD  - effect molecular diffusion coefficient
C     AL  - longitudinal dispersivity
C     AT  - lateral dispersivity
C     QB  - a 8 by 8 element matrix
C     QRX - element load vector for x-flux
C     QRY - element load vector for y-flux
C     QRZ - element load vector for z-flux
C
C     + + + LOCAL VARIABLES + + +
      INTEGER            IQ,JQ,KG
      DOUBLE PRECISION   P,SS,TT,UU,DJAC,VXK,VYK,VZK,THK,VK,VKI,
     >                   AKXK,AKYK,AKZK,AKXYK,AKXZK,AKYZK,DNX(8),
     >                   DNY(8),DNZ(8),S(8),T(8),U(8),W(8),N(8)
C
C     + + + INTRINSICS + + +
      INTRINSIC     DSQRT
C
C     + + + EXTERNALS + + +
      EXTERNAL     SHAPE
C
C     + + + DATA INITIALIZATIONS + + +
      DATA P /1.0D0/
      DATA S/-1.0D0,1.0D0,1.0D0,-1.0D0, -1.0D0,1.0D0,1.0D0,-1.0D0/
      DATA T/-1.0D0,-1.0D0,1.0D0,1.0D0, -1.0D0,-1.0D0,1.0D0,1.0D0/
      DATA U/-1.0D0,-1.0D0,-1.0D0,-1.0D0, 1.0D0,1.0D0,1.0D0,1.0D0/
C
C     + + + END SPECIFICATIONS + + +
C
C     initiate element load vectors and matrix
      DO 150 IQ = 1,8
        QRX(IQ) = 0.0
        QRY(IQ) = 0.0
        QRZ(IQ) = 0.0
        DO 100 JQ = 1,8
          QB(IQ,JQ) = 0.0
  100   CONTINUE
  150 CONTINUE
C
C *** Perform integration by Gaussian quadrature
C
      DO 490 KG = 1,8
C
C       determine local coordinate of Gaussian point KG
        SS = P*S(KG)
        TT = P*T(KG)
        UU = P*U(KG)
C
C       calculate base functions and their derivatives with respect to
C       x, y, and z at the Gaussian point KG.
        CALL SHAPE
     I            (XQ,YQ,ZQ,SS,TT,UU,
     O             N,DNX,DNY,DNZ,W,DJAC)
C
C       calculate velocity at the Gaussian point
        VXK = 0.0
        VYK = 0.0
        VZK = 0.0
        DO 280 IQ = 1,8
          VXK = VXK + VXQ(IQ)*N(IQ)
          VYK = VYK + VYQ(IQ)*N(IQ)
          VZK = VZK + VZQ(IQ)*N(IQ)
  280   CONTINUE
C
C       put moisture content at the Gaussian point into local variables
        THK = THQ(KG)
C
C       compute dispersion coefficient at the Gaussian point
        VK = DSQRT(VXK*VXK + VYK*VYK + VZK*VZK)
        IF (VK .EQ. 0.0) THEN
          VKI = 0.0
        ELSE
          VKI = 1.0D0/VK
        END IF
        AKXK = ((AL*VXK*VXK + AT*(VYK*VYK + VZK*VZK))*VKI + DD*THK)*DJAC
        AKYK = ((AL*VYK*VYK + AT*(VZK*VZK + VXK*VXK))*VKI + DD*THK)*DJAC
        AKZK = ((AL*VZK*VZK + AT*(VXK*VXK + VYK*VYK))*VKI + DD*THK)*DJAC
        AKXYK = ((AL - AT)*VXK*VYK*VKI)*DJAC
        AKXZK = ((AL - AT)*VXK*VZK*VKI)*DJAC
        AKYZK = ((AL - AT)*VYK*VZK*VKI)*DJAC
C
C       sum the contribution to element matrix and vectors due to the
C       Gaussian point KG
        DO 390 IQ = 1,8
          DO 380 JQ = 1,8
            QB(IQ,JQ) = QB(IQ,JQ) + N(IQ)*N(JQ)*DJAC
            QRX(IQ)   = QRX(IQ) - N(IQ)*CQ(JQ)*(AKXK*DNX(JQ) +
     >                  AKXYK*DNY(JQ) + AKXZK*DNZ(JQ))
            QRY(IQ)   = QRY(IQ) - N(IQ)*CQ(JQ)*(AKXYK*DNX(JQ) +
     >                  AKYK*DNY(JQ) + AKYZK*DNZ(JQ))
            QRZ(IQ)   = QRZ(IQ) - N(IQ)*CQ(JQ)*(AKXZK*DNX(JQ) +
     >                  AKYZK*DNY(JQ) + AKZK*DNZ(JQ))
  380     CONTINUE
  390   CONTINUE
  490 CONTINUE
C
      RETURN
      END
