      SUBROUTINE Q8R
     I              (CQ,CSQ,THG,XQ,YQ,ZQ,SOSQP,SOSCP,
     O               QRM,QDM,SOSM)
C
C
C     + + + PURPOSE + + +
C     To compute the material integration and element source integration
C       over an element.
C
C     + + + DUMMY ARGUMENTS + + +
      DOUBLE PRECISION   CQ(8),CSQ(8),THG(8),XQ(8),YQ(8),ZQ(8),
     >                   SOSQP,SOSCP,QRM,QDM,SOSM
C
C     + + + ARGUMENT DEFINITIONS + + +
C     CQ    - dissolved concentration at eight points of the element
C     CSQ   - adsorbed concentration at eight points of the element
C     THG   - moisture content at eight points of the element
C     XQ    - x-coordinate at eight points of the element
C     YQ    - y-coordinate at eight points of the element
C     ZQ    - z-coordinate at eight points of the element
C     SOSQP - element-source flow rate
C     SOSCP - concentration in element-source
C     QRM   - integration of TH*C
C     QDM   - integration of S
C     SOSM  - integration of Q*Cin
C
C     + + + LOCAL VARIABLES + + +
      INTEGER            KG,J,I,IQ
      DOUBLE PRECISION   P,SS,TT,UU,SM,SP,TM,TP,UM,UP,DJAC,CQP,CSQP,
     >                   SOSMK,THQP,PJAB(3,3),DNSS(8),DNTT(8),
     >                   DNUU(8),S(8),T(8),U(8),N(8)
C
C     + + + DATA INITIALIZATIONS + + +
      DATA P / 1.0D0/
      DATA S/-1.0D0,1.0D0,1.0D0,-1.0D0, -1.0D0,1.0D0,1.0D0,-1.0D0/
      DATA T/-1.0D0,-1.0D0,1.0D0,1.0D0, -1.0D0,-1.0D0,1.0D0,1.0D0/
      DATA U/-1.0D0,-1.0D0,-1.0D0,-1.0D0, 1.0D0,1.0D0,1.0D0,1.0D0/
C
C     + + + END SPECIFICATIONS + + +
C
C     initiate integrations
      QRM  = 0.0
      QDM  = 0.0
      SOSM = 0.0
C
C *** Perform integration with Gaussian quadrature
C
      DO 490 KG = 1,8
C
C       determine local coordinate of the Gaussian point KG.
        SS = P*S(KG)
        TT = P*T(KG)
        UU = P*U(KG)
C
C       compute some grouped variables
        SM = 1.0D0 - SS
        SP = 1.0D0 + SS
        TM = 1.0D0 - TT
        TP = 1.0D0 + TT
        UM = 1.0D0 - UU
        UP = 1.0D0 + UU
C
C       calculate base functions at the Gaussian point
        N(1) = 0.125D0*SM*TM*UM
        N(2) = 0.125D0*SP*TM*UM
        N(3) = 0.125D0*SP*TP*UM
        N(4) = 0.125D0*SM*TP*UM
        N(5) = 0.125D0*SM*TM*UP
        N(6) = 0.125D0*SP*TM*UP
        N(7) = 0.125D0*SP*TP*UP
        N(8) = 0.125D0*SM*TP*UP
C
C       compute partial derivatives of base functions with respect to
C       the local coordinate xsi
        DNSS(1) = -0.125D0*TM*UM
        DNSS(2) =  0.125D0*TM*UM
        DNSS(3) =  0.125D0*TP*UM
        DNSS(4) = -0.125D0*TP*UM
        DNSS(5) = -0.125D0*TM*UP
        DNSS(6) =  0.125D0*TM*UP
        DNSS(7) =  0.125D0*TP*UP
        DNSS(8) = -0.125D0*TP*UP
C
C       compute partial derivatives of base functions with respect to
C       the local coordinate eta
        DNTT(1) = -0.125D0*SM*UM
        DNTT(2) = -0.125D0*SP*UM
        DNTT(3) =  0.125D0*SP*UM
        DNTT(4) =  0.125D0*SM*UM
        DNTT(5) = -0.125D0*SM*UP
        DNTT(6) = -0.125D0*SP*UP
        DNTT(7) =  0.125D0*SP*UP
        DNTT(8) =  0.125D0*SM*UP
C
C       compute partial derivatives of base functions with respect to
C       the local coordinate zeta
        DNUU(1) = -0.125D0*SM*TM
        DNUU(2) = -0.125D0*SP*TM
        DNUU(3) = -0.125D0*SP*TP
        DNUU(4) = -0.125D0*SM*TP
        DNUU(5) =  0.125D0*SM*TM
        DNUU(6) =  0.125D0*SP*TM
        DNUU(7) =  0.125D0*SP*TP
        DNUU(8) =  0.125D0*SM*TP
C
C       initiate the Jacobian
        DO 215 J = 1,3
          DO 210 I = 1,3
            PJAB(I,J) = 0.
  210     CONTINUE
  215   CONTINUE
C
C       compute the Jacobian
        DO 220 I = 1,8
          PJAB(1,1) = PJAB(1,1) + XQ(I)*DNSS(I)
          PJAB(1,2) = PJAB(1,2) + YQ(I)*DNSS(I)
          PJAB(1,3) = PJAB(1,3) + ZQ(I)*DNSS(I)
          PJAB(2,1) = PJAB(2,1) + XQ(I)*DNTT(I)
          PJAB(2,2) = PJAB(2,2) + YQ(I)*DNTT(I)
          PJAB(2,3) = PJAB(2,3) + ZQ(I)*DNTT(I)
          PJAB(3,1) = PJAB(3,1) + XQ(I)*DNUU(I)
          PJAB(3,2) = PJAB(3,2) + YQ(I)*DNUU(I)
          PJAB(3,3) = PJAB(3,3) + ZQ(I)*DNUU(I)
  220   CONTINUE
C
C       compute the determinant of the Jacobian
        DJAC = PJAB(1,1)*(PJAB(2,2)*PJAB(3,3) - PJAB(2,3)*PJAB(3,2)) -
     >         PJAB(1,2)*(PJAB(2,1)*PJAB(3,3) - PJAB(2,3)*PJAB(3,1)) +
     >         PJAB(1,3)*(PJAB(2,1)*PJAB(3,2) - PJAB(2,2)*PJAB(3,1))
C
C       compute the dissolved concentration, adsorbed concentration,
C       and sink at the Gaussian point KG
        CQP   = 0.0
        CSQP  = 0.0
        SOSMK = 0.0
        DO 390 IQ = 1,8
          CQP  = CQP + CQ(IQ)*N(IQ)
          CSQP = CSQP + CSQ(IQ)*N(IQ)
          IF (SOSQP .LT. 0.0) THEN
            SOSMK = SOSMK + SOSQP*CQ(IQ)*N(IQ)
          END IF
  390   CONTINUE
C
        IF (SOSQP .GE. 0.0) THEN
          SOSMK = SOSQP*SOSCP
        END IF
C
C       put moisture content in local variable
        THQP = THG(KG)
C
C       Sum the contribution to the integration due to the KG-th
C       Gaussian point
C
        QRM  = QRM + THQP*CQP*DJAC
        QDM  = QDM + CSQP*DJAC
        SOSM = SOSM + SOSMK*DJAC
  490 CONTINUE
C
      RETURN
      END
