      SUBROUTINE READR
     I                (LUINP,LUOUT,MAXNOD,NNP,
     O                 F)
C
C     + + + PURPOSE + + +
C     To automatically generate real number input
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER            LUINP,LUOUT,MAXNOD,NNP
      DOUBLE PRECISION   F(MAXNOD)
C
C     + + + ARGUMENT DEFINITIONS + + +
C     LUINP  - Logical unit for input data
C     LUOUT  - Logical unit for line print
C     MAXNOD - maximum number of data points to be read
C     NNP    - number of data points to be read
C     F      - array of real numbers that are to be read and
C              generated automatically
C
C     + + + LOCAL VARIABLES + + +
      INTEGER            NODES,DONFG,NI,NSEQ,NAD,NJ,N,I,I1
      DOUBLE PRECISION   FNI,FAD,FRD,DINC
C
C     + + + INTRINSICS + + +
      INTRINSIC DABS,DBLE
C
C     + + + OUTPUT FORMATS + + +
 2000 FORMAT(///,' **** ERROR IN READR: NODES .NE. NNP',/,
     >           ' ****                ',I6,'     ',I5,/,
     >           ' **** FATAL ERROR, MUST STOP')
 2010 FORMAT(///,' **** ERROR IN READR: NNP .GT. MAXNOD',/,
     >           ' ****                ',I6,'    ',I6,/,
     >           ' **** FATAL ERROR, MUST STOP')
C
C     + + + END SPECIFICATIONS + + +
C
      NODES= 0
      DONFG= 0
  150 CONTINUE
        READ(LUINP,*) NI,NSEQ,NAD,FNI,FAD,FRD
        IF (NI .GT. 0) THEN
C         automatically generate real number input
          NJ= NI+NSEQ
          DO 160 N= NI,NJ
            NODES= NODES+1
            I    = NI+(N-NI)*NAD
            IF (DABS(FRD) .LE. 1.0E-30) THEN
C             generate number with constant increment
              F(I)= FNI+FAD*DBLE(N-NI)
            ELSE
C             generate number with geometrically increaing increment
              I1= I-NAD
              IF (N .EQ. NI) THEN
                F(I)= FNI
                DINC= 1.0D0
              ELSE IF (N .GT. NI) THEN
                DINC= DINC*(1.0D0+FRD)
                F(I)= F(I1)+FAD*DINC
              END IF
            END IF
  160     CONTINUE
        ELSE
C         complete input
          DONFG= 1
        END IF
      IF (DONFG .EQ. 0) GO TO 150
C
C     check for errors
C
      IF (NODES .NE. NNP) THEN
C       number of data points read is not the same as those to be read
        WRITE(LUOUT,2000) NODES,NNP
        STOP
      ELSE IF (NNP .GT. MAXNOD) THEN
C       number of data points to be read is greater than the maximum
C       allowed
        WRITE(LUOUT,2010) NNP,MAXNOD
        STOP
      END IF
C
      RETURN
      END
