      SUBROUTINE SFLOW
     I                (X,Y,Z,IE,C,FX,FY,FZ,TH,DCOSB,ISB,NPBB,SOS,
     I                 ISTYP,LES,WSS,IWTYP,NPW,NPVB,NPDB,NPCB,NPNB,
     I                 PROP,DELT,KFLOW,
     M                 BFLX,BFLXP)
C
C     + + + PURPOSE + + +
C     To compute material fluxes, Iincremental mass flow, and
C        accumulated mass flow through all types of boundaries: and
C        change of materials in the region of interest.
C
C     + + + COMMON BLOCKS + + +
      INCLUDE 'SGEOM.INC'
      INCLUDE 'CGEOM.INC'
      INCLUDE 'CELS.INC'
      INCLUDE 'CNPS.INC'
      INCLUDE 'CCBC.INC'
      INCLUDE 'CNBC.INC'
      INCLUDE 'CVBC.INC'
      INCLUDE 'CDBC.INC'
      INCLUDE 'MATL.INC'
      INCLUDE 'OPTN.INC'
      INCLUDE 'CFLOW.INC'
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER            IE(MAXEL,9),ISB(6,MAXBES),NPBB(MAXBNP),
     >                   ISTYP(MXSEL),LES(MXSEL),IWTYP(MXWNP),
     >                   NPW(MXWNP),NPVB(MXVNP),NPDB(MXDNP),
     >                   NPCB(MXCNP),NPNB(MXNNP),KFLOW
      DOUBLE PRECISION   X(MAXNP),Y(MAXNP),Z(MAXNP),C(MAXNP),
     >                   FX(MAXNP),FY(MAXNP),FZ(MAXNP),TH(8,MAXEL),
     >                   DCOSB(3,MAXBES),SOS(MXSPR,2),WSS(MXWPR,2),
     >                   PROP(MXMPPM,MAXMAT),DELT,BFLX(MAXNP),
     >                   BFLXP(MAXNP)
C
C     + + + ARGUMENT DEFINITIONS + + +
C     X(N)     - x-coordiante of the N-th node
C     Y(N)     - y-coordinate of the N-th node
C     Z(N)     - z-coordinate of the N-th node
C     IE(M,I)  - global node number of the I-th node of the M-th element
C                if I is between 1 and 8
C     IE(M,9)  - integer to indicate the material type of the M-th
C                element
C     C(N)     - Concentration of the N-th node at the present time
C     FX(N)    - x-direction material flux at the N-th node
C     FY(N)    - y-direction material flux at the N-th node
C     FZ(N)    - z-direction material flux at the N-th node
C     TH(I,M)  - moisture content at the I-th node of the M-th element
C
C     DCOSB(1,I) - x-directional cosine of the I-th boundary side
C     DCOSB(2,I) - y-directional cosine of the I-th boundary side
C     DCOSB(3,I) - z-directional cosine of the I-th boundary side
C     ISB(1,I)   - boundary node number of the first node of the I-th
C                  boundary side
C     ISB(2,I)   - boundary node number of the second node of the I-th
C                  boundary side
C     ISB(3,I)   - boundary node number of the third node of the I-th
C                  boundary side
C     ISB(4,I)   - boundary node number of the fourth node of the I-th
C                  boundary side
C     ISB(5,I)   - element side index of the I-th boundary side
C                  1=left side, 2=front side, 3=right side,
C                  4=back side, 5=bottom side, 6=top side
C     ISB(6,I)   - element number to which the I-th boundary side belong
C     NPBB(I)    - global node number of the I-the boundary node
C
C     SOS(I,1)    - source flow rate of the I-th profile at time t
C     SOS(I,2)    - source concentration of the I-th profile at time t
C     ISTYP(M)    - type of source profile assigned to the M-th element
C     LES(I)      - global element number of the I-th element-source
C     WSS(I,1)    - well source flow rate of the I-th profile at time t
C     WSS(I,2)    - well source concentration of the I-th profile
C     IWTYP(I)    - type of source profile assigned to the I-th node
C     NPW(I)      - global node number of the I-th well node
C
C     NPVB(NP)   - global nodal number of the NP-variable node on input
C                  Then is changed to contain boundary node number
C     NPDB(NP)   - global nodal number of the NP-Dirichlet node on input
C                  Then is changed to contain boundary node number
C     NPCB(NP)   - global nodal number of the NP-Cauchy node on input
C                  Then is changed to contain boundary node number
C     NPNB(NP)   - global nodal number of the NP-Neumann node on input
C                  Then is changed to contain boundary node number
C
C     PROP(J,I) - J-the material property of the I-th material
C                 PROP(1,I) = distribution coefficient or
C                             Freundlich K or Langmuir K
C                 PROP(2,I) = bulk density
C                 PROP(3,I) = longitudinal dispersivity
C                 PROP(4,I) = lateral dispersivity
C                 PROP(5,I) = molecular diffusion coefficient
C                 PROP(6,I) = tortuosity
C                 PROP(7,I) = decay constant
C                 PROP(8,I) = Freundlich N or Langmuir SMAX
C
C     DELT     - time-step size
C     KFLOW    - flow indicator
C     BFLX(I)  - boundary flux at the I-th boundary node
C     BFLXP(I) - value of BFLX(I) at previous time
C
C     + + + LOCAL VARIABLES + + +
      INTEGER            NP,MP,LS,M,IQ,I,NI,NII,NPP,IJ,MS,ITYP,MTYP,KG,
     >                   KGB(4,6)
      DOUBLE PRECISION   QR,QD,QL,SOURCE,S,SP,SM,SMP,QRP,QDP,QLP,
     >                   SOURSP,SOSQP,SOSCP,RHOB,FNLS,QRM,QDM,QLM,
     >                   SPOSCP,SOSM,WSSQ,WSSC,SUM,CQ(8),CSQ(8),
     >                   XQ(8),YQ(8),ZQ(8),THG(8),RRQ(4),FFQ(4),
     >                   XXQ(4),YYQ(4),ZZQ(4),KD,LAMBDA
C
C     + + + EXTERNALS + + +
      EXTERNAL     Q4BB,Q8R
C
C     + + + DATA INITIALIZATIONS + + +
      DATA KGB/1,4,8,5, 1,2,6,5, 2,3,7,6, 4,3,7,8, 1,2,3,4, 5,6,7,8/
      DATA QR,QD,QL,SOURCE /0.0D0,0.0D0,0.0D0,0.0D0/
C
C     + + + END SPECIFICATIONS + + +
C
      DO 110 NP = 1,NBNP
        BFLXP(NP) = BFLX(NP)
        BFLX(NP)  = 0.0
  110 CONTINUE
C
C *** Calculate nodal flow rates through all boundary nodes
C
      DO 170 MP = 1,NBES
        LS = ISB(5,MP)
        M  = ISB(6,MP)
        DO 120 IQ = 1,4
          I       = KGB(IQ,LS)
          NI      = IE(M,I)
          XXQ(IQ) = X(NI)
          YYQ(IQ) = Y(NI)
          ZZQ(IQ) = Z(NI)
          FFQ(IQ) = DCOSB(1,MP)*FX(NI) + DCOSB(2,MP)*FY(NI) +
     >              DCOSB(3,MP)*FZ(NI)
  120   CONTINUE
C
C       perform boundary-flux integration
        CALL Q4BB
     I           (FFQ,XXQ,YYQ,ZZQ,
     O            RRQ)
C
        DO 140 IQ = 1,4
          NII       = ISB(IQ,MP)
          BFLX(NII) = BFLX(NII) + RRQ(IQ)
  140   CONTINUE
  170 CONTINUE
C
      IF (KFLOW .LE. 0) THEN
        DO 180 NP = 1,NBNP
          BFLXP(NP) = BFLX(NP)
  180   CONTINUE
        DO 190 I = 1,14
          TFLOW(I) = 0.0
  190   CONTINUE
      END IF
C
C *** Determine flows and flow rates through various types of nodes,
C *** starting with the net flows through all boundary nodes
C
      S  = 0.
      SP = 0.
      DO 210 NP = 1,NBNP
        S  = S + BFLX(NP)
        SP = SP + BFLXP(NP)
  210 CONTINUE
      FRATE(7) = S
      FLOW(7)  = .5D0*(S + SP)*DELT
C
C *** through Dirichlet boundary nodes
C
      FRATE(1) = 0.
      FLOW(1)  = 0.
      IF (NDNP .GT. 0) THEN
        S  = 0.
        SP = 0.
        DO 330 NPP = 1,NDNP
          NP = NPDB(NPP)
          DONFG = 0
          I     = 0
  310     CONTINUE
            I  = I + 1
            IJ = NPBB(I)
            IF (IJ .EQ. NP) THEN
              NII=I
              DONFG = 1
            END IF
            IF (DONFG .EQ. 0 .AND. I .LT. NBNP) THEN
              GO TO 310
            END IF
          S  = S + BFLX(NII)
          SP = SP + BFLXP(NII)
  330   CONTINUE
        FRATE(1) = S
        FLOW(1) = 0.5D0*(S + SP)*DELT
      END IF
C
C *** through Cauchy nodes
C
      FRATE(2) = 0.
      FLOW(2)  = 0.
      IF (NCNP .GT. 0) THEN
        S  = 0.
        SP = 0.
        DO 370 NPP = 1,NCNP
          NII = NPCB(NPP)
          S   = S + BFLX(NII)
          SP  = SP + BFLXP(NII)
  370   CONTINUE
        FRATE(2) = S
        FLOW(2)  = 0.5D0*(S + SP)*DELT
      END IF
C
C *** through Neuman nodes
C
      FRATE(3) = 0.0
      FLOW(3)  = 0.0
      IF (NNNP .GT. 0) THEN
        S  = 0.0
        SP = 0.0
        DO 395 NPP = 1,NNNP
          NII = NPNB(NPP)
          S   = S + BFLX(NII)
          SP  = SP + BFLXP(NII)
  395   CONTINUE
        FRATE(3) = S
        FLOW(3)  = 0.5D0*(S + SP)*DELT
      END IF
C
C *** through-variable nodes
C
      FRATE(4) = 0.
      FLOW(4)  = 0.
      FRATE(5) = 0.0
      FLOW(5)  = 0.0
      IF (NVNP .GT. 0) THEN
        S   = 0.
        SP  = 0.
        SM  = 0.0
        SMP = 0.0
        DO 490 NPP = 1,NVNP
          NII = NPVB(NPP)
          IF (BFLX(NII) .LT. 0.0) THEN
            SM = SM + BFLX(NII)
          ELSE
            S = S + BFLX(NII)
          END IF
          IF (BFLXP(NII) .LT. 0.0) THEN
            SMP = SMP + BFLXP(NII)
          ELSE
            SP = SP + BFLXP(NII)
          END IF
  490   CONTINUE
        FRATE(4) = S
        FLOW(4) = 0.5D0*(S + SP)*DELT
        FRATE(5) = SM
        FLOW(5)  = 0.5D0*(SM + SMP)*DELT
      END IF
C
C *** numerical flow through unspecified boundary nodes
C
      S  = 0.
      SP = 0.
      DO 510 I = 1,5
        S  = S + FRATE(I)
        SP = SP + FLOW(I)
  510 CONTINUE
      FRATE(6) = FRATE(7) - S
      FLOW(6)  = FLOW(7) - SP
C
C *** calculate increases of integrated material contents in the fluid
C *** QR and in solid QD; determine losss due to radioactive decay QL;
C *** and compute integrated source/sinks
C
      QRP    = QR
      QDP    = QD
      QLP    = QL
      SOURSP = SOURCE
      QR     = 0.
      QD     = 0.
      QL     = 0.
      SOURCE = 0.0
C
      DO 690 M = 1,NEL
C
        SOSQP = 0.0
        SOSCP = 0.0
        IF (NSEL .NE. 0) THEN
          MP = 0
  603     CONTINUE
            MP = MP + 1
            MS = LES(MP)
            IF (MS .EQ. M) THEN
              ITYP  = ISTYP(MP)
              SOSQP = SOS(ITYP,1)
              SOSCP = SOS(ITYP,2)
            ELSE
              IF (MP .LT. NSEL) THEN
                GO TO 603
            END IF
          END IF
        END IF
C
        MTYP   = IE(M,9)
        KD     = PROP(1,MTYP)
        RHOB   = PROP(2,MTYP)
        LAMBDA = PROP(7,MTYP)
        FNLS   = PROP(8,MTYP)
        DO 650 IQ = 1,8
          NP     = IE(M,IQ)
          XQ(IQ) = X(NP)
          YQ(IQ) = Y(NP)
          ZQ(IQ) = Z(NP)
          CQ(IQ) = C(NP)
          IF (KSORP .EQ. 1) THEN
            CSQ(IQ) = KD*CQ(IQ)
          ELSE IF (KSORP .EQ. 2) THEN
            CSQ(IQ) = KD*CQ(IQ)**FNLS
          ELSE
            CSQ(IQ) = KD*FNLS*CQ(IQ)/(1.0D0 + KD*CQ(IQ))
          END IF
  650   CONTINUE
C
        DO 670 KG = 1,8
          THG(KG) = TH(KG,M)
  670   CONTINUE
C
        CALL Q8R
     I          (CQ,CSQ,THG,XQ,YQ,ZQ,SOSQP,SOSCP,
     O           QRM,QDM,SOSM)
C
        QR     = QR + QRM
        QD     = QD + QDM*RHOB
        QLM    = QRM + QDM*RHOB
        QL     = QL + LAMBDA*QLM
        SOURCE = SOURCE - SOSM
  690 CONTINUE
C
C *** Incorporate well source/sinks
C
      IF (NWNP .GT. 0) THEN
        DO 700 I = 1,NWNP
          ITYP = IWTYP(I)
          WSSQ = WSS(ITYP,1)
          WSSC = WSS(ITYP,2)
          NI   = NPW(I)
          IF (WSSQ .LT. 0.0) THEN
            SOURCE = SOURCE - WSSQ*C(NI)
          END IF
          IF (WSSQ .GE. 0.0) THEN
            SOURCE = SOURCE - WSSQ*WSSC
          END IF
  700   CONTINUE
      END IF
C
      IF (KFLOW .LE. 0) THEN
        QRP    = 0.0
        QDP    = 0.0
        QLP    = QL
        SOURSP = SOURCE
        SUM    = QR + QD
        S      = FRATE(7) + QL + SOURCE
      END IF
C
      FLOW(8)  = QR - QRP
      FRATE(8) = FLOW(8)/DELT
      IF (KFLOW .LE. 0 .AND. SUM .NE. 0.0D0) THEN
        FRATE(8) = -S*QR/SUM
      END IF
C
      FLOW(9)  = QD - QDP
      FRATE(9) = FLOW(9)/DELT
      IF (KFLOW .LE. 0 .AND. SUM .NE. 0.0D0) THEN
C        FRATE(9) = -S*QD/SUM
      END IF
C
      FRATE(10) = QL
      FRATE(11) = 0.0
      FRATE(12) = 0.0
      FRATE(13) = 0.0
      FRATE(14) = SOURCE
C
      FLOW(10)  = 0.5D0*(QL + QLP)*DELT
      FLOW(11)  = 0.0
      FLOW(12)  = 0.0
      FLOW(13)  = 0.0
      FLOW(14)  = 0.5D0*(SOURCE + SOURSP)*DELT
C
      DO 720 I = 1,14
        TFLOW(I) = TFLOW(I) + FLOW(I)
  720 CONTINUE
C
      RETURN
      END
