      SUBROUTINE SHAPE
     I                (XQ,YQ,ZQ,SS,TT,UU,
     O                 N,DNX,DNY,DNZ,W,DJAC)
C
C     + + + PURPOSE + + +
C     To compute basis and weighting functions, their derivatives with
C       respecti to x, y, z, and the Jacobian at a Gaussian point.
C
C     + + + COMMON BLOCKS + + +
      INCLUDE 'OPTN.INC'
      INCLUDE 'WETX.INC'
      INCLUDE 'WETY.INC'
      INCLUDE 'WETZ.INC'
C
C     + + + DUMMY ARGUMENTS + + +
      DOUBLE PRECISION   XQ(8),YQ(8),ZQ(8),SS,TT,UU,N(8),DNX(8),
     >                   DNY(8),DNZ(8),W(8),DJAC
C
C     + + + ARGUMENT DEFINITIONS + + +
C     XQ   - x-coordinate at eight points of the element
C     YQ   - y-coordinate at eight points of the element
C     ZQ   - z-coordinate at eight points of the element
C     SS   - xsi-coordinate of the Gaussian point
C     TT   - eta-coordinate of the Gaussian point
C     UU   - zeta-coordinate of the Gaussian point
C     N    - base function at eight points of the element
C     DNX  - parital derivative of the base function with respect to x
C     DNY  - parital derivative of the base function with respect to y
C     DNZ  - parital derivative of the base function with respect to z
C     W    - weighting function at eight points of the element
C     DJAC - determinant of the Jacobian
C
C     + + + LOCAL VARIABLES + + +
      INTEGER            I
      DOUBLE PRECISION   SM,SP,TM,TP,UM,UP,SUM1,SUM2,SUM3,SUM4,
     >                   SUM5,SUM6,SUM7,SUM8,SUM9,DJACI,SUMI1,
     >                   SUMI2,SUMI3,SUMI4,SUMI5,SUMI6,SUMI7,
     >                   SUMI8,SUMI9,DNSS(8),DNTT(8),DNUU(8),
     >                   WF1,WF2,A,X
C
C     + + + END SPECIFICATIONS + + +
C
C ------- DEFINE UPSTREAM WEIGHTING FUNCTIONS AND THEIR DERIVATIVES
C
C     define weighting functions
      WF1(X,A) = 0.25D0*((2.0D0 - 3.0D0*A) - 2.0D0*X + 3.0D0*A*X*X)
      WF2(X,A) = 0.25D0*((2.0D0 + 3.0D0*A) + 2.0D0*X - 3.0D0*A*X*X)
C
C     compute some grouped variables
      SM = 1.0D0 - SS
      SP = 1.0D0 + SS
      TM = 1.0D0 - TT
      TP = 1.0D0 + TT
      UM = 1.0D0 - UU
      UP = 1.0D0 + UU
C
C     compute base functions
      N(1) = .125D0*SM*TM*UM
      N(2) = .125D0*SP*TM*UM
      N(3) = .125D0*SP*TP*UM
      N(4) = .125D0*SM*TP*UM
      N(5) = .125D0*SM*TM*UP
      N(6) = .125D0*SP*TM*UP
      N(7) = .125D0*SP*TP*UP
      N(8) = .125D0*SM*TP*UP
C
C     compute the partial derivative of base functions with respect to
C     local coordinate xsi
      DNSS(1) = -.125D0*TM*UM
      DNSS(2) = .125D0*TM*UM
      DNSS(3) = .125D0*TP*UM
      DNSS(4) = -.125D0*TP*UM
      DNSS(5) = -.125D0*TM*UP
      DNSS(6) = .125D0*TM*UP
      DNSS(7) = .125D0*TP*UP
      DNSS(8) = -.125D0*TP*UP
C
C     compute the partial derivative of base functions with respect to
C     local coordinate eta
      DNTT(1) = -.125D0*SM*UM
      DNTT(2) = -.125D0*SP*UM
      DNTT(3) = .125D0*SP*UM
      DNTT(4) = .125D0*SM*UM
      DNTT(5) = -.125D0*SM*UP
      DNTT(6) = -.125D0*SP*UP
      DNTT(7) = .125D0*SP*UP
      DNTT(8) = .125D0*SM*UP
C
C     compute the partial derivative ob base functions with respect to
C     local coordinate zeta
      DNUU(1) = -.125D0*SM*TM
      DNUU(2) = -.125D0*SP*TM
      DNUU(3) = -.125D0*SP*TP
      DNUU(4) = -.125D0*SM*TP
      DNUU(5) = .125D0*SM*TM
      DNUU(6) = .125D0*SP*TM
      DNUU(7) = .125D0*SP*TP
      DNUU(8) = .125D0*SM*TP
C
C     initiate the nine entries of the Jacobian matrix
      SUM1 = 0.0
      SUM2 = 0.0
      SUM3 = 0.0
      SUM4 = 0.0
      SUM5 = 0.0
      SUM6 = 0.0
      SUM7 = 0.0
      SUM8 = 0.0
      SUM9 = 0.0
C
C     compute the nine entries of the Jacobian matrix
      DO 290 I = 1,8
        SUM1 = SUM1 + XQ(I)*DNSS(I)
        SUM2 = SUM2 + YQ(I)*DNSS(I)
        SUM3 = SUM3 + ZQ(I)*DNSS(I)
        SUM4 = SUM4 + XQ(I)*DNTT(I)
        SUM5 = SUM5 + YQ(I)*DNTT(I)
        SUM6 = SUM6 + ZQ(I)*DNTT(I)
        SUM7 = SUM7 + XQ(I)*DNUU(I)
        SUM8 = SUM8 + YQ(I)*DNUU(I)
        SUM9 = SUM9 + ZQ(I)*DNUU(I)
  290 CONTINUE
C
C     compute the determinant of the Jacobian matrix
      DJAC = SUM1*(SUM5*SUM9 - SUM6*SUM8) + SUM2*(SUM6*SUM7
     >     - SUM4*SUM9) +  SUM3*(SUM4*SUM8 - SUM5*SUM7)
C
C     compute the inverse of the determinant of the Jacobian matrix
      DJACI = 1.0D0/DJAC
C
C     compute the inverse of the determinant of the Jacobian matrix
      SUMI1 = DJACI*(SUM5*SUM9 - SUM6*SUM8)
      SUMI2 = DJACI*(SUM3*SUM8 - SUM2*SUM9)
      SUMI3 = DJACI*(SUM2*SUM6 - SUM3*SUM5)
      SUMI4 = DJACI*(SUM6*SUM7 - SUM4*SUM9)
      SUMI5 = DJACI*(SUM1*SUM9 - SUM3*SUM7)
      SUMI6 = DJACI*(SUM3*SUM4 - SUM1*SUM6)
      SUMI7 = DJACI*(SUM4*SUM8 - SUM5*SUM7)
      SUMI8 = DJACI*(SUM2*SUM7 - SUM1*SUM8)
      SUMI9 = DJACI*(SUM1*SUM5 - SUM2*SUM4)
C
C     compute the partial derivatives of base functions with respect to
C     global coordinate x, y, and z.
      DO 390 I = 1,8
        DNX(I) = SUMI1*DNSS(I) + SUMI2*DNTT(I) + SUMI3*DNUU(I)
        DNY(I) = SUMI4*DNSS(I) + SUMI5*DNTT(I) + SUMI6*DNUU(I)
        DNZ(I) = SUMI7*DNSS(I) + SUMI8*DNTT(I) + SUMI9*DNUU(I)
  390 CONTINUE
C
C ******* Compute Weighting Functions
C
      IF (IWET .NE. 0) THEN
C       for the case of upstream weighting
        W(1) = WF1(SS,APHA1)*WF1(TT,BETA1)*WF1(UU,GAMA1)
        W(2) = WF2(SS,APHA1)*WF1(TT,BETA2)*WF1(UU,GAMA2)
        W(3) = WF2(SS,APHA2)*WF2(TT,BETA2)*WF1(UU,GAMA3)
        W(4) = WF1(SS,APHA2)*WF2(TT,BETA1)*WF1(UU,GAMA4)
        W(5) = WF1(SS,APHA3)*WF1(TT,BETA3)*WF2(UU,GAMA1)
        W(6) = WF2(SS,APHA3)*WF1(TT,BETA4)*WF2(UU,GAMA2)
        W(7) = WF2(SS,APHA4)*WF2(TT,BETA4)*WF2(UU,GAMA3)
        W(8) = WF1(SS,APHA4)*WF2(TT,BETA3)*WF2(UU,GAMA4)
      ELSE
C       for the case of Galerkin weighting
        DO 790 I = 1,8
          W(I) = N(I)
  790   CONTINUE
      END IF
C
      RETURN
      END
